/*
 * Wink API
 *  # Introduction  Welcome to the Wink API - A programmer-friendly way to manage, sell and book travel inventory on the Wink platform. The API gives you all the tools you need to ready your properties and inventory for sale across 1000s of our native sales channels.  Integrators, affiliates, travel agents and content creators have the ability search for your travel inventory and promote / sell it in a wide variety of ways.   # Integrations  We have already integrated with the most well-known channel managers so you don't have to. To see our current integrations, please go to https://extranet.wink.travel and scroll to Connectivity section. Once your properties are set up, you can finish the setup by mapping your property to Wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API.   # Intended Audience  Programmers are [most likely] a requirement to start integrating with Wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible.  - Hotel chains  - Hotel brands  - Travel tech companies  - Destination sites  - Integrators  - Aggregators  - Destination management companies  - Travel agencies  - OTAs   ## APIs  Not every integrator needs every API. For that reason, we have separated APIs into context.  ### Test API   - [Ping](/ping): The Ping API is a quick test endpoint to verify that your credentials work Wink.  ### Common APIs  - [Notifications](/notifications): The Notifications API is a way for us to stay in touch with your user, property or affiliate account. - [User Settings](/user-settings): The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink.  ### Consume APIs Consume endpoints are for developers who want to find existing travel inventory and either book it or use it to advertise through one of their Wink affiliate accounts.   - [Configuration](/customization-client): A single endpoint to retrieve whitelabel + customization information for the booking customization.  - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags.  - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API..  - [Booking](/booking): All APIs related to creating bookings on the platform.  - [Travel Agent](/travel-agent): The Travel Agent API exposes endpoints to manage agent-facilitated bookings.   ### Produce APIs  Produce endpoints are for developers who want to create and manage travel inventory.   #### Property  - [Property registration](/extranet/property/register): As a producer, this is, oftentimes, where you start your journey. These endpoints let you create properties on Wink.  - [Property](/extranet/property): This collection of property endpoints are mostly management endpoints that let you display, change status and similar for your existing properties.  - [Facilities](/extranet/facilities): This collection of endpoints let you manage facilities; such as room types.  - [Experiences](/extranet/experiences): This collection of endpoints let you manage experiences, such as activities.  - [Monetize](/extranet/monetize): The Monetize API exposes endpoints for managing cancellation polies, rate plans, promotions and more on Wink.  - [Distribution](/extranet/distribution): The Distribution API exposes endpoints for sales channels, connecting with affiliates, managing rates and inventory calendars and more on Wink.  - [Property Booking](/extranet/booking): The Property Booking API exposes endpoints for managing bookings and reviews at the property-level.   #### Affiliate  - [Affiliate](/affiliate): This collection of affiliate endpoints are mostly management endpoints that let you display, change status and similar for your existing accounts.  - [Browse](/affiliate/browse): The Browse API exposes endpoints for affiliates to find suppliers and inventory to sell.  - [Inventory](/affiliate/inventory): The Inventory API exposes endpoints for affiliates to manage the inventory they want to sell and how they want to sell it.  - [Sales Channel](/affiliate/sales-channel): The Sales Channel API exposes endpoints for affiliates to manage existing sales channels as well as find new ones.  - [WinkLinks](/affiliate/winklinks): The WinkLinks API exposes endpoints for affiliates to manage their WinkLinks page.   #### Rate provider  - [Channel manager](/channel-manager): The Channel Manager API enables external channel manager partners to map, exchange rate / availability information with us as well as be informed of bookings that occur on the Wink platform for one of their properties.   ### Taxonomy APIs  Taxonomy endpoints are for developers who want to consume and produce travel inventory and need taxonomies of standard and non-standard codes for inventory types, classes, statuses etc.   - [Reference](/reactive): All APIs related to retrieving platform-supported taxonomies.   ### Insight APIs  Insight endpoints do exactly what the name implies - They offer platform-level insight into the activities of producers and consumers.   - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics.   ### Payment APIs  Payment endpoints are for developers who want to purchase travel inventory. This can be done via the API as a registered Travel Agent or using our API in conjunction with our PCI compliant reactive widget for all other entities.   - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.   ## SDKs  We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).   - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)   ## Usage  These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.   ## Versioning  We chose to version our endpoints in a way that we hope affects your integration minimally. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.   ## Release history  - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md    # Booking Engine API Welcome to the Booking Engine API - A programmer-friendly way to book inventory that was found on our platform. This API lets you:  1. Shopping Cart: Manage shopping cart. 2. Checkout: Move shopping cart items through the reactive workflow. 3. Booking: Move selected inventory through to booking completion. 4. Review: Leave a review after a completed stay.  Browse the endpoints in the left navigation bar to get started.  
 *
 * The version of the OpenAPI document: 30.17.8
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.booking.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import travel.wink.sdk.booking.model.CustomMonetaryAmount;
import travel.wink.sdk.booking.model.LocalizedDescriptionBooker;
import travel.wink.sdk.booking.model.QuoteLightweightBooker;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * StayRateBooker
 */
@JsonPropertyOrder({
  StayRateBooker.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_BASE_TOTAL,
  StayRateBooker.JSON_PROPERTY_SOURCE_BASE_TOTAL,
  StayRateBooker.JSON_PROPERTY_INTERNAL_BASE_TOTAL,
  StayRateBooker.JSON_PROPERTY_SOURCE_EXTRA_PAX_MODIFIER,
  StayRateBooker.JSON_PROPERTY_INTERNAL_EXTRA_PAX_MODIFIER,
  StayRateBooker.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_EXTRA_PAX_MODIFIER,
  StayRateBooker.JSON_PROPERTY_SOURCE_EXTRA_CHILD_MODIFIER,
  StayRateBooker.JSON_PROPERTY_INTERNAL_EXTRA_CHILD_MODIFIER,
  StayRateBooker.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_EXTRA_CHILD_MODIFIER,
  StayRateBooker.JSON_PROPERTY_SOURCE_SINGLE_OCCUPANT_MODIFIER,
  StayRateBooker.JSON_PROPERTY_INTERNAL_SINGLE_OCCUPANT_MODIFIER,
  StayRateBooker.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_SINGLE_OCCUPANT_MODIFIER,
  StayRateBooker.JSON_PROPERTY_SOURCE_PROMOTIONAL_MODIFIER,
  StayRateBooker.JSON_PROPERTY_INTERNAL_PROMOTIONAL_MODIFIER,
  StayRateBooker.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PROMOTIONAL_MODIFIER,
  StayRateBooker.JSON_PROPERTY_SOURCE_PREMIUM_MODIFIER,
  StayRateBooker.JSON_PROPERTY_INTERNAL_PREMIUM_MODIFIER,
  StayRateBooker.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PREMIUM_MODIFIER,
  StayRateBooker.JSON_PROPERTY_SOURCE_CHANNEL_MODIFIER,
  StayRateBooker.JSON_PROPERTY_INTERNAL_CHANNEL_MODIFIER,
  StayRateBooker.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_CHANNEL_MODIFIER,
  StayRateBooker.JSON_PROPERTY_QUANTITY,
  StayRateBooker.JSON_PROPERTY_MIN_OCCUPANCY,
  StayRateBooker.JSON_PROPERTY_MAX_OCCUPANCY,
  StayRateBooker.JSON_PROPERTY_RATE_SOURCE,
  StayRateBooker.JSON_PROPERTY_PROMOTIONAL_DISCOUNT_PERCENT,
  StayRateBooker.JSON_PROPERTY_CHANNEL_DISCOUNT_PERCENT,
  StayRateBooker.JSON_PROPERTY_PREMIUM_PERCENT,
  StayRateBooker.JSON_PROPERTY_AVAILABLE,
  StayRateBooker.JSON_PROPERTY_SOURCE_TO_USER_CURRENCY_QUOTE,
  StayRateBooker.JSON_PROPERTY_SOURCE_TO_INTERNAL_CURRENCY_QUOTE,
  StayRateBooker.JSON_PROPERTY_OFFER_DETAILS,
  StayRateBooker.JSON_PROPERTY_PROMOTIONAL_CODES,
  StayRateBooker.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL,
  StayRateBooker.JSON_PROPERTY_SOURCE_TOTAL,
  StayRateBooker.JSON_PROPERTY_INTERNAL_TOTAL,
  StayRateBooker.JSON_PROPERTY_TOTAL_DISCOUNT_PERCENT,
  StayRateBooker.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_AVERAGE_PRICE_PER_NIGHT,
  StayRateBooker.JSON_PROPERTY_INTERNAL_AVERAGE_PRICE_PER_NIGHT,
  StayRateBooker.JSON_PROPERTY_SOURCE_AVERAGE_PRICE_PER_NIGHT
})
@JsonTypeName("StayRate_Booker")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-26T20:16:53.154776164+07:00[Asia/Bangkok]", comments = "Generator version: 7.13.0")
public class StayRateBooker {
  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_BASE_TOTAL = "userSpecifiedCurrencyBaseTotal";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount userSpecifiedCurrencyBaseTotal;

  public static final String JSON_PROPERTY_SOURCE_BASE_TOTAL = "sourceBaseTotal";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount sourceBaseTotal;

  public static final String JSON_PROPERTY_INTERNAL_BASE_TOTAL = "internalBaseTotal";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount internalBaseTotal;

  public static final String JSON_PROPERTY_SOURCE_EXTRA_PAX_MODIFIER = "sourceExtraPaxModifier";
  @jakarta.annotation.Nullable
  private BigDecimal sourceExtraPaxModifier;

  public static final String JSON_PROPERTY_INTERNAL_EXTRA_PAX_MODIFIER = "internalExtraPaxModifier";
  @jakarta.annotation.Nullable
  private BigDecimal internalExtraPaxModifier;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_EXTRA_PAX_MODIFIER = "userSpecifiedCurrencyExtraPaxModifier";
  @jakarta.annotation.Nullable
  private BigDecimal userSpecifiedCurrencyExtraPaxModifier;

  public static final String JSON_PROPERTY_SOURCE_EXTRA_CHILD_MODIFIER = "sourceExtraChildModifier";
  @jakarta.annotation.Nullable
  private BigDecimal sourceExtraChildModifier;

  public static final String JSON_PROPERTY_INTERNAL_EXTRA_CHILD_MODIFIER = "internalExtraChildModifier";
  @jakarta.annotation.Nullable
  private BigDecimal internalExtraChildModifier;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_EXTRA_CHILD_MODIFIER = "userSpecifiedCurrencyExtraChildModifier";
  @jakarta.annotation.Nullable
  private BigDecimal userSpecifiedCurrencyExtraChildModifier;

  public static final String JSON_PROPERTY_SOURCE_SINGLE_OCCUPANT_MODIFIER = "sourceSingleOccupantModifier";
  @jakarta.annotation.Nullable
  private BigDecimal sourceSingleOccupantModifier;

  public static final String JSON_PROPERTY_INTERNAL_SINGLE_OCCUPANT_MODIFIER = "internalSingleOccupantModifier";
  @jakarta.annotation.Nullable
  private BigDecimal internalSingleOccupantModifier;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_SINGLE_OCCUPANT_MODIFIER = "userSpecifiedCurrencySingleOccupantModifier";
  @jakarta.annotation.Nullable
  private BigDecimal userSpecifiedCurrencySingleOccupantModifier;

  public static final String JSON_PROPERTY_SOURCE_PROMOTIONAL_MODIFIER = "sourcePromotionalModifier";
  @jakarta.annotation.Nullable
  private BigDecimal sourcePromotionalModifier;

  public static final String JSON_PROPERTY_INTERNAL_PROMOTIONAL_MODIFIER = "internalPromotionalModifier";
  @jakarta.annotation.Nullable
  private BigDecimal internalPromotionalModifier;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PROMOTIONAL_MODIFIER = "userSpecifiedCurrencyPromotionalModifier";
  @jakarta.annotation.Nullable
  private BigDecimal userSpecifiedCurrencyPromotionalModifier;

  public static final String JSON_PROPERTY_SOURCE_PREMIUM_MODIFIER = "sourcePremiumModifier";
  @jakarta.annotation.Nullable
  private BigDecimal sourcePremiumModifier;

  public static final String JSON_PROPERTY_INTERNAL_PREMIUM_MODIFIER = "internalPremiumModifier";
  @jakarta.annotation.Nullable
  private BigDecimal internalPremiumModifier;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PREMIUM_MODIFIER = "userSpecifiedCurrencyPremiumModifier";
  @jakarta.annotation.Nullable
  private BigDecimal userSpecifiedCurrencyPremiumModifier;

  public static final String JSON_PROPERTY_SOURCE_CHANNEL_MODIFIER = "sourceChannelModifier";
  @jakarta.annotation.Nullable
  private BigDecimal sourceChannelModifier;

  public static final String JSON_PROPERTY_INTERNAL_CHANNEL_MODIFIER = "internalChannelModifier";
  @jakarta.annotation.Nullable
  private BigDecimal internalChannelModifier;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_CHANNEL_MODIFIER = "userSpecifiedCurrencyChannelModifier";
  @jakarta.annotation.Nullable
  private BigDecimal userSpecifiedCurrencyChannelModifier;

  public static final String JSON_PROPERTY_QUANTITY = "quantity";
  @jakarta.annotation.Nullable
  private Integer quantity;

  public static final String JSON_PROPERTY_MIN_OCCUPANCY = "minOccupancy";
  @jakarta.annotation.Nullable
  private Integer minOccupancy;

  public static final String JSON_PROPERTY_MAX_OCCUPANCY = "maxOccupancy";
  @jakarta.annotation.Nullable
  private Integer maxOccupancy;

  public static final String JSON_PROPERTY_RATE_SOURCE = "rateSource";
  @jakarta.annotation.Nullable
  private String rateSource;

  public static final String JSON_PROPERTY_PROMOTIONAL_DISCOUNT_PERCENT = "promotionalDiscountPercent";
  @jakarta.annotation.Nullable
  private Float promotionalDiscountPercent;

  public static final String JSON_PROPERTY_CHANNEL_DISCOUNT_PERCENT = "channelDiscountPercent";
  @jakarta.annotation.Nullable
  private Float channelDiscountPercent;

  public static final String JSON_PROPERTY_PREMIUM_PERCENT = "premiumPercent";
  @jakarta.annotation.Nullable
  private Float premiumPercent;

  public static final String JSON_PROPERTY_AVAILABLE = "available";
  @jakarta.annotation.Nullable
  private Boolean available;

  public static final String JSON_PROPERTY_SOURCE_TO_USER_CURRENCY_QUOTE = "sourceToUserCurrencyQuote";
  @jakarta.annotation.Nullable
  private QuoteLightweightBooker sourceToUserCurrencyQuote;

  public static final String JSON_PROPERTY_SOURCE_TO_INTERNAL_CURRENCY_QUOTE = "sourceToInternalCurrencyQuote";
  @jakarta.annotation.Nullable
  private QuoteLightweightBooker sourceToInternalCurrencyQuote;

  public static final String JSON_PROPERTY_OFFER_DETAILS = "offerDetails";
  @jakarta.annotation.Nullable
  private List<@Valid LocalizedDescriptionBooker> offerDetails = new ArrayList<>();

  public static final String JSON_PROPERTY_PROMOTIONAL_CODES = "promotionalCodes";
  @jakarta.annotation.Nullable
  private List<String> promotionalCodes = new ArrayList<>();

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL = "userSpecifiedCurrencyTotal";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount userSpecifiedCurrencyTotal;

  public static final String JSON_PROPERTY_SOURCE_TOTAL = "sourceTotal";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount sourceTotal;

  public static final String JSON_PROPERTY_INTERNAL_TOTAL = "internalTotal";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount internalTotal;

  public static final String JSON_PROPERTY_TOTAL_DISCOUNT_PERCENT = "totalDiscountPercent";
  @jakarta.annotation.Nullable
  private Float totalDiscountPercent;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_AVERAGE_PRICE_PER_NIGHT = "userSpecifiedCurrencyAveragePricePerNight";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount userSpecifiedCurrencyAveragePricePerNight;

  public static final String JSON_PROPERTY_INTERNAL_AVERAGE_PRICE_PER_NIGHT = "internalAveragePricePerNight";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount internalAveragePricePerNight;

  public static final String JSON_PROPERTY_SOURCE_AVERAGE_PRICE_PER_NIGHT = "sourceAveragePricePerNight";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount sourceAveragePricePerNight;

  public StayRateBooker() {
  }

  public StayRateBooker userSpecifiedCurrencyBaseTotal(@jakarta.annotation.Nullable CustomMonetaryAmount userSpecifiedCurrencyBaseTotal) {
    
    this.userSpecifiedCurrencyBaseTotal = userSpecifiedCurrencyBaseTotal;
    return this;
  }

  /**
   * Base total in user specified currency.
   * @return userSpecifiedCurrencyBaseTotal
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_BASE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getUserSpecifiedCurrencyBaseTotal() {
    return userSpecifiedCurrencyBaseTotal;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_BASE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyBaseTotal(@jakarta.annotation.Nullable CustomMonetaryAmount userSpecifiedCurrencyBaseTotal) {
    this.userSpecifiedCurrencyBaseTotal = userSpecifiedCurrencyBaseTotal;
  }

  public StayRateBooker sourceBaseTotal(@jakarta.annotation.Nullable CustomMonetaryAmount sourceBaseTotal) {
    
    this.sourceBaseTotal = sourceBaseTotal;
    return this;
  }

  /**
   * Base total in hotel&#39;s currency.
   * @return sourceBaseTotal
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_BASE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getSourceBaseTotal() {
    return sourceBaseTotal;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_BASE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceBaseTotal(@jakarta.annotation.Nullable CustomMonetaryAmount sourceBaseTotal) {
    this.sourceBaseTotal = sourceBaseTotal;
  }

  public StayRateBooker internalBaseTotal(@jakarta.annotation.Nullable CustomMonetaryAmount internalBaseTotal) {
    
    this.internalBaseTotal = internalBaseTotal;
    return this;
  }

  /**
   * Base total in wink currency.
   * @return internalBaseTotal
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_INTERNAL_BASE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getInternalBaseTotal() {
    return internalBaseTotal;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_BASE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalBaseTotal(@jakarta.annotation.Nullable CustomMonetaryAmount internalBaseTotal) {
    this.internalBaseTotal = internalBaseTotal;
  }

  public StayRateBooker sourceExtraPaxModifier(@jakarta.annotation.Nullable BigDecimal sourceExtraPaxModifier) {
    
    this.sourceExtraPaxModifier = sourceExtraPaxModifier;
    return this;
  }

  /**
   * Extra person modifier in hotel currency.
   * @return sourceExtraPaxModifier
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_EXTRA_PAX_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getSourceExtraPaxModifier() {
    return sourceExtraPaxModifier;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_EXTRA_PAX_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceExtraPaxModifier(@jakarta.annotation.Nullable BigDecimal sourceExtraPaxModifier) {
    this.sourceExtraPaxModifier = sourceExtraPaxModifier;
  }

  public StayRateBooker internalExtraPaxModifier(@jakarta.annotation.Nullable BigDecimal internalExtraPaxModifier) {
    
    this.internalExtraPaxModifier = internalExtraPaxModifier;
    return this;
  }

  /**
   * Extra person modifier in wink currency
   * @return internalExtraPaxModifier
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_INTERNAL_EXTRA_PAX_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getInternalExtraPaxModifier() {
    return internalExtraPaxModifier;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_EXTRA_PAX_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalExtraPaxModifier(@jakarta.annotation.Nullable BigDecimal internalExtraPaxModifier) {
    this.internalExtraPaxModifier = internalExtraPaxModifier;
  }

  public StayRateBooker userSpecifiedCurrencyExtraPaxModifier(@jakarta.annotation.Nullable BigDecimal userSpecifiedCurrencyExtraPaxModifier) {
    
    this.userSpecifiedCurrencyExtraPaxModifier = userSpecifiedCurrencyExtraPaxModifier;
    return this;
  }

  /**
   * Extra person modifier in user specified currency
   * @return userSpecifiedCurrencyExtraPaxModifier
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_EXTRA_PAX_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getUserSpecifiedCurrencyExtraPaxModifier() {
    return userSpecifiedCurrencyExtraPaxModifier;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_EXTRA_PAX_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyExtraPaxModifier(@jakarta.annotation.Nullable BigDecimal userSpecifiedCurrencyExtraPaxModifier) {
    this.userSpecifiedCurrencyExtraPaxModifier = userSpecifiedCurrencyExtraPaxModifier;
  }

  public StayRateBooker sourceExtraChildModifier(@jakarta.annotation.Nullable BigDecimal sourceExtraChildModifier) {
    
    this.sourceExtraChildModifier = sourceExtraChildModifier;
    return this;
  }

  /**
   * Extra child modifier in hotel currency
   * @return sourceExtraChildModifier
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_EXTRA_CHILD_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getSourceExtraChildModifier() {
    return sourceExtraChildModifier;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_EXTRA_CHILD_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceExtraChildModifier(@jakarta.annotation.Nullable BigDecimal sourceExtraChildModifier) {
    this.sourceExtraChildModifier = sourceExtraChildModifier;
  }

  public StayRateBooker internalExtraChildModifier(@jakarta.annotation.Nullable BigDecimal internalExtraChildModifier) {
    
    this.internalExtraChildModifier = internalExtraChildModifier;
    return this;
  }

  /**
   * Extra child modifier in wink currency
   * @return internalExtraChildModifier
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_INTERNAL_EXTRA_CHILD_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getInternalExtraChildModifier() {
    return internalExtraChildModifier;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_EXTRA_CHILD_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalExtraChildModifier(@jakarta.annotation.Nullable BigDecimal internalExtraChildModifier) {
    this.internalExtraChildModifier = internalExtraChildModifier;
  }

  public StayRateBooker userSpecifiedCurrencyExtraChildModifier(@jakarta.annotation.Nullable BigDecimal userSpecifiedCurrencyExtraChildModifier) {
    
    this.userSpecifiedCurrencyExtraChildModifier = userSpecifiedCurrencyExtraChildModifier;
    return this;
  }

  /**
   * Extra child modifier in user specified currcency
   * @return userSpecifiedCurrencyExtraChildModifier
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_EXTRA_CHILD_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getUserSpecifiedCurrencyExtraChildModifier() {
    return userSpecifiedCurrencyExtraChildModifier;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_EXTRA_CHILD_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyExtraChildModifier(@jakarta.annotation.Nullable BigDecimal userSpecifiedCurrencyExtraChildModifier) {
    this.userSpecifiedCurrencyExtraChildModifier = userSpecifiedCurrencyExtraChildModifier;
  }

  public StayRateBooker sourceSingleOccupantModifier(@jakarta.annotation.Nullable BigDecimal sourceSingleOccupantModifier) {
    
    this.sourceSingleOccupantModifier = sourceSingleOccupantModifier;
    return this;
  }

  /**
   * Single occupant modifier in hotel currency
   * @return sourceSingleOccupantModifier
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_SINGLE_OCCUPANT_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getSourceSingleOccupantModifier() {
    return sourceSingleOccupantModifier;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_SINGLE_OCCUPANT_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceSingleOccupantModifier(@jakarta.annotation.Nullable BigDecimal sourceSingleOccupantModifier) {
    this.sourceSingleOccupantModifier = sourceSingleOccupantModifier;
  }

  public StayRateBooker internalSingleOccupantModifier(@jakarta.annotation.Nullable BigDecimal internalSingleOccupantModifier) {
    
    this.internalSingleOccupantModifier = internalSingleOccupantModifier;
    return this;
  }

  /**
   * Singe occupant modifier in wink currency
   * @return internalSingleOccupantModifier
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_INTERNAL_SINGLE_OCCUPANT_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getInternalSingleOccupantModifier() {
    return internalSingleOccupantModifier;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_SINGLE_OCCUPANT_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalSingleOccupantModifier(@jakarta.annotation.Nullable BigDecimal internalSingleOccupantModifier) {
    this.internalSingleOccupantModifier = internalSingleOccupantModifier;
  }

  public StayRateBooker userSpecifiedCurrencySingleOccupantModifier(@jakarta.annotation.Nullable BigDecimal userSpecifiedCurrencySingleOccupantModifier) {
    
    this.userSpecifiedCurrencySingleOccupantModifier = userSpecifiedCurrencySingleOccupantModifier;
    return this;
  }

  /**
   * Single occupant modifier in user specified currency
   * @return userSpecifiedCurrencySingleOccupantModifier
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_SINGLE_OCCUPANT_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getUserSpecifiedCurrencySingleOccupantModifier() {
    return userSpecifiedCurrencySingleOccupantModifier;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_SINGLE_OCCUPANT_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencySingleOccupantModifier(@jakarta.annotation.Nullable BigDecimal userSpecifiedCurrencySingleOccupantModifier) {
    this.userSpecifiedCurrencySingleOccupantModifier = userSpecifiedCurrencySingleOccupantModifier;
  }

  public StayRateBooker sourcePromotionalModifier(@jakarta.annotation.Nullable BigDecimal sourcePromotionalModifier) {
    
    this.sourcePromotionalModifier = sourcePromotionalModifier;
    return this;
  }

  /**
   * Rate discount modifiers in hotel currency
   * @return sourcePromotionalModifier
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_PROMOTIONAL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getSourcePromotionalModifier() {
    return sourcePromotionalModifier;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_PROMOTIONAL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourcePromotionalModifier(@jakarta.annotation.Nullable BigDecimal sourcePromotionalModifier) {
    this.sourcePromotionalModifier = sourcePromotionalModifier;
  }

  public StayRateBooker internalPromotionalModifier(@jakarta.annotation.Nullable BigDecimal internalPromotionalModifier) {
    
    this.internalPromotionalModifier = internalPromotionalModifier;
    return this;
  }

  /**
   * Rate discount modifiers in wink currency
   * @return internalPromotionalModifier
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_INTERNAL_PROMOTIONAL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getInternalPromotionalModifier() {
    return internalPromotionalModifier;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_PROMOTIONAL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalPromotionalModifier(@jakarta.annotation.Nullable BigDecimal internalPromotionalModifier) {
    this.internalPromotionalModifier = internalPromotionalModifier;
  }

  public StayRateBooker userSpecifiedCurrencyPromotionalModifier(@jakarta.annotation.Nullable BigDecimal userSpecifiedCurrencyPromotionalModifier) {
    
    this.userSpecifiedCurrencyPromotionalModifier = userSpecifiedCurrencyPromotionalModifier;
    return this;
  }

  /**
   * Rate discount modifiers in user specified currency
   * @return userSpecifiedCurrencyPromotionalModifier
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PROMOTIONAL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getUserSpecifiedCurrencyPromotionalModifier() {
    return userSpecifiedCurrencyPromotionalModifier;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PROMOTIONAL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyPromotionalModifier(@jakarta.annotation.Nullable BigDecimal userSpecifiedCurrencyPromotionalModifier) {
    this.userSpecifiedCurrencyPromotionalModifier = userSpecifiedCurrencyPromotionalModifier;
  }

  public StayRateBooker sourcePremiumModifier(@jakarta.annotation.Nullable BigDecimal sourcePremiumModifier) {
    
    this.sourcePremiumModifier = sourcePremiumModifier;
    return this;
  }

  /**
   * Rate premiums modifiers in hotel currency
   * @return sourcePremiumModifier
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_PREMIUM_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getSourcePremiumModifier() {
    return sourcePremiumModifier;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_PREMIUM_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourcePremiumModifier(@jakarta.annotation.Nullable BigDecimal sourcePremiumModifier) {
    this.sourcePremiumModifier = sourcePremiumModifier;
  }

  public StayRateBooker internalPremiumModifier(@jakarta.annotation.Nullable BigDecimal internalPremiumModifier) {
    
    this.internalPremiumModifier = internalPremiumModifier;
    return this;
  }

  /**
   * Rate premiums modifiers in wink currency
   * @return internalPremiumModifier
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_INTERNAL_PREMIUM_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getInternalPremiumModifier() {
    return internalPremiumModifier;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_PREMIUM_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalPremiumModifier(@jakarta.annotation.Nullable BigDecimal internalPremiumModifier) {
    this.internalPremiumModifier = internalPremiumModifier;
  }

  public StayRateBooker userSpecifiedCurrencyPremiumModifier(@jakarta.annotation.Nullable BigDecimal userSpecifiedCurrencyPremiumModifier) {
    
    this.userSpecifiedCurrencyPremiumModifier = userSpecifiedCurrencyPremiumModifier;
    return this;
  }

  /**
   * Rate premiums modifiers in user specified currency
   * @return userSpecifiedCurrencyPremiumModifier
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PREMIUM_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getUserSpecifiedCurrencyPremiumModifier() {
    return userSpecifiedCurrencyPremiumModifier;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PREMIUM_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyPremiumModifier(@jakarta.annotation.Nullable BigDecimal userSpecifiedCurrencyPremiumModifier) {
    this.userSpecifiedCurrencyPremiumModifier = userSpecifiedCurrencyPremiumModifier;
  }

  public StayRateBooker sourceChannelModifier(@jakarta.annotation.Nullable BigDecimal sourceChannelModifier) {
    
    this.sourceChannelModifier = sourceChannelModifier;
    return this;
  }

  /**
   * Channel / Membership modifier in hotel currency
   * @return sourceChannelModifier
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_CHANNEL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getSourceChannelModifier() {
    return sourceChannelModifier;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_CHANNEL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceChannelModifier(@jakarta.annotation.Nullable BigDecimal sourceChannelModifier) {
    this.sourceChannelModifier = sourceChannelModifier;
  }

  public StayRateBooker internalChannelModifier(@jakarta.annotation.Nullable BigDecimal internalChannelModifier) {
    
    this.internalChannelModifier = internalChannelModifier;
    return this;
  }

  /**
   * Channel / Membership modifier in wink currency
   * @return internalChannelModifier
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_INTERNAL_CHANNEL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getInternalChannelModifier() {
    return internalChannelModifier;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_CHANNEL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalChannelModifier(@jakarta.annotation.Nullable BigDecimal internalChannelModifier) {
    this.internalChannelModifier = internalChannelModifier;
  }

  public StayRateBooker userSpecifiedCurrencyChannelModifier(@jakarta.annotation.Nullable BigDecimal userSpecifiedCurrencyChannelModifier) {
    
    this.userSpecifiedCurrencyChannelModifier = userSpecifiedCurrencyChannelModifier;
    return this;
  }

  /**
   * Channel / Membership modifier in user specified currency
   * @return userSpecifiedCurrencyChannelModifier
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_CHANNEL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getUserSpecifiedCurrencyChannelModifier() {
    return userSpecifiedCurrencyChannelModifier;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_CHANNEL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyChannelModifier(@jakarta.annotation.Nullable BigDecimal userSpecifiedCurrencyChannelModifier) {
    this.userSpecifiedCurrencyChannelModifier = userSpecifiedCurrencyChannelModifier;
  }

  public StayRateBooker quantity(@jakarta.annotation.Nullable Integer quantity) {
    
    this.quantity = quantity;
    return this;
  }

  /**
   * Quantity
   * @return quantity
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getQuantity() {
    return quantity;
  }


  @JsonProperty(JSON_PROPERTY_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setQuantity(@jakarta.annotation.Nullable Integer quantity) {
    this.quantity = quantity;
  }

  public StayRateBooker minOccupancy(@jakarta.annotation.Nullable Integer minOccupancy) {
    
    this.minOccupancy = minOccupancy;
    return this;
  }

  /**
   * Minimum occupancy
   * @return minOccupancy
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MIN_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMinOccupancy() {
    return minOccupancy;
  }


  @JsonProperty(JSON_PROPERTY_MIN_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinOccupancy(@jakarta.annotation.Nullable Integer minOccupancy) {
    this.minOccupancy = minOccupancy;
  }

  public StayRateBooker maxOccupancy(@jakarta.annotation.Nullable Integer maxOccupancy) {
    
    this.maxOccupancy = maxOccupancy;
    return this;
  }

  /**
   * Maximum occupancy
   * @return maxOccupancy
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MAX_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMaxOccupancy() {
    return maxOccupancy;
  }


  @JsonProperty(JSON_PROPERTY_MAX_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxOccupancy(@jakarta.annotation.Nullable Integer maxOccupancy) {
    this.maxOccupancy = maxOccupancy;
  }

  public StayRateBooker rateSource(@jakarta.annotation.Nullable String rateSource) {
    
    this.rateSource = rateSource;
    return this;
  }

  /**
   * Source
   * @return rateSource
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RATE_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRateSource() {
    return rateSource;
  }


  @JsonProperty(JSON_PROPERTY_RATE_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRateSource(@jakarta.annotation.Nullable String rateSource) {
    this.rateSource = rateSource;
  }

  public StayRateBooker promotionalDiscountPercent(@jakarta.annotation.Nullable Float promotionalDiscountPercent) {
    
    this.promotionalDiscountPercent = promotionalDiscountPercent;
    return this;
  }

  /**
   * Promotional discount percent
   * @return promotionalDiscountPercent
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PROMOTIONAL_DISCOUNT_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getPromotionalDiscountPercent() {
    return promotionalDiscountPercent;
  }


  @JsonProperty(JSON_PROPERTY_PROMOTIONAL_DISCOUNT_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPromotionalDiscountPercent(@jakarta.annotation.Nullable Float promotionalDiscountPercent) {
    this.promotionalDiscountPercent = promotionalDiscountPercent;
  }

  public StayRateBooker channelDiscountPercent(@jakarta.annotation.Nullable Float channelDiscountPercent) {
    
    this.channelDiscountPercent = channelDiscountPercent;
    return this;
  }

  /**
   * Chanel discount percent
   * @return channelDiscountPercent
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CHANNEL_DISCOUNT_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getChannelDiscountPercent() {
    return channelDiscountPercent;
  }


  @JsonProperty(JSON_PROPERTY_CHANNEL_DISCOUNT_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChannelDiscountPercent(@jakarta.annotation.Nullable Float channelDiscountPercent) {
    this.channelDiscountPercent = channelDiscountPercent;
  }

  public StayRateBooker premiumPercent(@jakarta.annotation.Nullable Float premiumPercent) {
    
    this.premiumPercent = premiumPercent;
    return this;
  }

  /**
   * Premium percent
   * @return premiumPercent
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PREMIUM_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getPremiumPercent() {
    return premiumPercent;
  }


  @JsonProperty(JSON_PROPERTY_PREMIUM_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPremiumPercent(@jakarta.annotation.Nullable Float premiumPercent) {
    this.premiumPercent = premiumPercent;
  }

  public StayRateBooker available(@jakarta.annotation.Nullable Boolean available) {
    
    this.available = available;
    return this;
  }

  /**
   * Available
   * @return available
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAvailable() {
    return available;
  }


  @JsonProperty(JSON_PROPERTY_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAvailable(@jakarta.annotation.Nullable Boolean available) {
    this.available = available;
  }

  public StayRateBooker sourceToUserCurrencyQuote(@jakarta.annotation.Nullable QuoteLightweightBooker sourceToUserCurrencyQuote) {
    
    this.sourceToUserCurrencyQuote = sourceToUserCurrencyQuote;
    return this;
  }

  /**
   * Hotel to user currency exchange rate.
   * @return sourceToUserCurrencyQuote
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_TO_USER_CURRENCY_QUOTE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public QuoteLightweightBooker getSourceToUserCurrencyQuote() {
    return sourceToUserCurrencyQuote;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_TO_USER_CURRENCY_QUOTE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceToUserCurrencyQuote(@jakarta.annotation.Nullable QuoteLightweightBooker sourceToUserCurrencyQuote) {
    this.sourceToUserCurrencyQuote = sourceToUserCurrencyQuote;
  }

  public StayRateBooker sourceToInternalCurrencyQuote(@jakarta.annotation.Nullable QuoteLightweightBooker sourceToInternalCurrencyQuote) {
    
    this.sourceToInternalCurrencyQuote = sourceToInternalCurrencyQuote;
    return this;
  }

  /**
   * Hotel to wink currency exchange rate.
   * @return sourceToInternalCurrencyQuote
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_TO_INTERNAL_CURRENCY_QUOTE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public QuoteLightweightBooker getSourceToInternalCurrencyQuote() {
    return sourceToInternalCurrencyQuote;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_TO_INTERNAL_CURRENCY_QUOTE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceToInternalCurrencyQuote(@jakarta.annotation.Nullable QuoteLightweightBooker sourceToInternalCurrencyQuote) {
    this.sourceToInternalCurrencyQuote = sourceToInternalCurrencyQuote;
  }

  public StayRateBooker offerDetails(@jakarta.annotation.Nullable List<@Valid LocalizedDescriptionBooker> offerDetails) {
    
    this.offerDetails = offerDetails;
    return this;
  }

  public StayRateBooker addOfferDetailsItem(LocalizedDescriptionBooker offerDetailsItem) {
    if (this.offerDetails == null) {
      this.offerDetails = new ArrayList<>();
    }
    this.offerDetails.add(offerDetailsItem);
    return this;
  }

  /**
   * Get offerDetails
   * @return offerDetails
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_OFFER_DETAILS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<@Valid LocalizedDescriptionBooker> getOfferDetails() {
    return offerDetails;
  }


  @JsonProperty(JSON_PROPERTY_OFFER_DETAILS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOfferDetails(@jakarta.annotation.Nullable List<@Valid LocalizedDescriptionBooker> offerDetails) {
    this.offerDetails = offerDetails;
  }

  public StayRateBooker promotionalCodes(@jakarta.annotation.Nullable List<String> promotionalCodes) {
    
    this.promotionalCodes = promotionalCodes;
    return this;
  }

  public StayRateBooker addPromotionalCodesItem(String promotionalCodesItem) {
    if (this.promotionalCodes == null) {
      this.promotionalCodes = new ArrayList<>();
    }
    this.promotionalCodes.add(promotionalCodesItem);
    return this;
  }

  /**
   * Get promotionalCodes
   * @return promotionalCodes
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PROMOTIONAL_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getPromotionalCodes() {
    return promotionalCodes;
  }


  @JsonProperty(JSON_PROPERTY_PROMOTIONAL_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPromotionalCodes(@jakarta.annotation.Nullable List<String> promotionalCodes) {
    this.promotionalCodes = promotionalCodes;
  }

  public StayRateBooker userSpecifiedCurrencyTotal(@jakarta.annotation.Nullable CustomMonetaryAmount userSpecifiedCurrencyTotal) {
    
    this.userSpecifiedCurrencyTotal = userSpecifiedCurrencyTotal;
    return this;
  }

  /**
   * User-defined currency final price.
   * @return userSpecifiedCurrencyTotal
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getUserSpecifiedCurrencyTotal() {
    return userSpecifiedCurrencyTotal;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyTotal(@jakarta.annotation.Nullable CustomMonetaryAmount userSpecifiedCurrencyTotal) {
    this.userSpecifiedCurrencyTotal = userSpecifiedCurrencyTotal;
  }

  public StayRateBooker sourceTotal(@jakarta.annotation.Nullable CustomMonetaryAmount sourceTotal) {
    
    this.sourceTotal = sourceTotal;
    return this;
  }

  /**
   * Source currency final price.
   * @return sourceTotal
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getSourceTotal() {
    return sourceTotal;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceTotal(@jakarta.annotation.Nullable CustomMonetaryAmount sourceTotal) {
    this.sourceTotal = sourceTotal;
  }

  public StayRateBooker internalTotal(@jakarta.annotation.Nullable CustomMonetaryAmount internalTotal) {
    
    this.internalTotal = internalTotal;
    return this;
  }

  /**
   * Internal currency final price.
   * @return internalTotal
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_INTERNAL_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getInternalTotal() {
    return internalTotal;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalTotal(@jakarta.annotation.Nullable CustomMonetaryAmount internalTotal) {
    this.internalTotal = internalTotal;
  }

  public StayRateBooker totalDiscountPercent(@jakarta.annotation.Nullable Float totalDiscountPercent) {
    
    this.totalDiscountPercent = totalDiscountPercent;
    return this;
  }

  /**
   * Get totalDiscountPercent
   * @return totalDiscountPercent
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOTAL_DISCOUNT_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getTotalDiscountPercent() {
    return totalDiscountPercent;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_DISCOUNT_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalDiscountPercent(@jakarta.annotation.Nullable Float totalDiscountPercent) {
    this.totalDiscountPercent = totalDiscountPercent;
  }

  public StayRateBooker userSpecifiedCurrencyAveragePricePerNight(@jakarta.annotation.Nullable CustomMonetaryAmount userSpecifiedCurrencyAveragePricePerNight) {
    
    this.userSpecifiedCurrencyAveragePricePerNight = userSpecifiedCurrencyAveragePricePerNight;
    return this;
  }

  /**
   * Get userSpecifiedCurrencyAveragePricePerNight
   * @return userSpecifiedCurrencyAveragePricePerNight
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_AVERAGE_PRICE_PER_NIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getUserSpecifiedCurrencyAveragePricePerNight() {
    return userSpecifiedCurrencyAveragePricePerNight;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_AVERAGE_PRICE_PER_NIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyAveragePricePerNight(@jakarta.annotation.Nullable CustomMonetaryAmount userSpecifiedCurrencyAveragePricePerNight) {
    this.userSpecifiedCurrencyAveragePricePerNight = userSpecifiedCurrencyAveragePricePerNight;
  }

  public StayRateBooker internalAveragePricePerNight(@jakarta.annotation.Nullable CustomMonetaryAmount internalAveragePricePerNight) {
    
    this.internalAveragePricePerNight = internalAveragePricePerNight;
    return this;
  }

  /**
   * Get internalAveragePricePerNight
   * @return internalAveragePricePerNight
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_INTERNAL_AVERAGE_PRICE_PER_NIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getInternalAveragePricePerNight() {
    return internalAveragePricePerNight;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_AVERAGE_PRICE_PER_NIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalAveragePricePerNight(@jakarta.annotation.Nullable CustomMonetaryAmount internalAveragePricePerNight) {
    this.internalAveragePricePerNight = internalAveragePricePerNight;
  }

  public StayRateBooker sourceAveragePricePerNight(@jakarta.annotation.Nullable CustomMonetaryAmount sourceAveragePricePerNight) {
    
    this.sourceAveragePricePerNight = sourceAveragePricePerNight;
    return this;
  }

  /**
   * Get sourceAveragePricePerNight
   * @return sourceAveragePricePerNight
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_AVERAGE_PRICE_PER_NIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getSourceAveragePricePerNight() {
    return sourceAveragePricePerNight;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_AVERAGE_PRICE_PER_NIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceAveragePricePerNight(@jakarta.annotation.Nullable CustomMonetaryAmount sourceAveragePricePerNight) {
    this.sourceAveragePricePerNight = sourceAveragePricePerNight;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    StayRateBooker stayRateBooker = (StayRateBooker) o;
    return Objects.equals(this.userSpecifiedCurrencyBaseTotal, stayRateBooker.userSpecifiedCurrencyBaseTotal) &&
        Objects.equals(this.sourceBaseTotal, stayRateBooker.sourceBaseTotal) &&
        Objects.equals(this.internalBaseTotal, stayRateBooker.internalBaseTotal) &&
        Objects.equals(this.sourceExtraPaxModifier, stayRateBooker.sourceExtraPaxModifier) &&
        Objects.equals(this.internalExtraPaxModifier, stayRateBooker.internalExtraPaxModifier) &&
        Objects.equals(this.userSpecifiedCurrencyExtraPaxModifier, stayRateBooker.userSpecifiedCurrencyExtraPaxModifier) &&
        Objects.equals(this.sourceExtraChildModifier, stayRateBooker.sourceExtraChildModifier) &&
        Objects.equals(this.internalExtraChildModifier, stayRateBooker.internalExtraChildModifier) &&
        Objects.equals(this.userSpecifiedCurrencyExtraChildModifier, stayRateBooker.userSpecifiedCurrencyExtraChildModifier) &&
        Objects.equals(this.sourceSingleOccupantModifier, stayRateBooker.sourceSingleOccupantModifier) &&
        Objects.equals(this.internalSingleOccupantModifier, stayRateBooker.internalSingleOccupantModifier) &&
        Objects.equals(this.userSpecifiedCurrencySingleOccupantModifier, stayRateBooker.userSpecifiedCurrencySingleOccupantModifier) &&
        Objects.equals(this.sourcePromotionalModifier, stayRateBooker.sourcePromotionalModifier) &&
        Objects.equals(this.internalPromotionalModifier, stayRateBooker.internalPromotionalModifier) &&
        Objects.equals(this.userSpecifiedCurrencyPromotionalModifier, stayRateBooker.userSpecifiedCurrencyPromotionalModifier) &&
        Objects.equals(this.sourcePremiumModifier, stayRateBooker.sourcePremiumModifier) &&
        Objects.equals(this.internalPremiumModifier, stayRateBooker.internalPremiumModifier) &&
        Objects.equals(this.userSpecifiedCurrencyPremiumModifier, stayRateBooker.userSpecifiedCurrencyPremiumModifier) &&
        Objects.equals(this.sourceChannelModifier, stayRateBooker.sourceChannelModifier) &&
        Objects.equals(this.internalChannelModifier, stayRateBooker.internalChannelModifier) &&
        Objects.equals(this.userSpecifiedCurrencyChannelModifier, stayRateBooker.userSpecifiedCurrencyChannelModifier) &&
        Objects.equals(this.quantity, stayRateBooker.quantity) &&
        Objects.equals(this.minOccupancy, stayRateBooker.minOccupancy) &&
        Objects.equals(this.maxOccupancy, stayRateBooker.maxOccupancy) &&
        Objects.equals(this.rateSource, stayRateBooker.rateSource) &&
        Objects.equals(this.promotionalDiscountPercent, stayRateBooker.promotionalDiscountPercent) &&
        Objects.equals(this.channelDiscountPercent, stayRateBooker.channelDiscountPercent) &&
        Objects.equals(this.premiumPercent, stayRateBooker.premiumPercent) &&
        Objects.equals(this.available, stayRateBooker.available) &&
        Objects.equals(this.sourceToUserCurrencyQuote, stayRateBooker.sourceToUserCurrencyQuote) &&
        Objects.equals(this.sourceToInternalCurrencyQuote, stayRateBooker.sourceToInternalCurrencyQuote) &&
        Objects.equals(this.offerDetails, stayRateBooker.offerDetails) &&
        Objects.equals(this.promotionalCodes, stayRateBooker.promotionalCodes) &&
        Objects.equals(this.userSpecifiedCurrencyTotal, stayRateBooker.userSpecifiedCurrencyTotal) &&
        Objects.equals(this.sourceTotal, stayRateBooker.sourceTotal) &&
        Objects.equals(this.internalTotal, stayRateBooker.internalTotal) &&
        Objects.equals(this.totalDiscountPercent, stayRateBooker.totalDiscountPercent) &&
        Objects.equals(this.userSpecifiedCurrencyAveragePricePerNight, stayRateBooker.userSpecifiedCurrencyAveragePricePerNight) &&
        Objects.equals(this.internalAveragePricePerNight, stayRateBooker.internalAveragePricePerNight) &&
        Objects.equals(this.sourceAveragePricePerNight, stayRateBooker.sourceAveragePricePerNight);
  }

  @Override
  public int hashCode() {
    return Objects.hash(userSpecifiedCurrencyBaseTotal, sourceBaseTotal, internalBaseTotal, sourceExtraPaxModifier, internalExtraPaxModifier, userSpecifiedCurrencyExtraPaxModifier, sourceExtraChildModifier, internalExtraChildModifier, userSpecifiedCurrencyExtraChildModifier, sourceSingleOccupantModifier, internalSingleOccupantModifier, userSpecifiedCurrencySingleOccupantModifier, sourcePromotionalModifier, internalPromotionalModifier, userSpecifiedCurrencyPromotionalModifier, sourcePremiumModifier, internalPremiumModifier, userSpecifiedCurrencyPremiumModifier, sourceChannelModifier, internalChannelModifier, userSpecifiedCurrencyChannelModifier, quantity, minOccupancy, maxOccupancy, rateSource, promotionalDiscountPercent, channelDiscountPercent, premiumPercent, available, sourceToUserCurrencyQuote, sourceToInternalCurrencyQuote, offerDetails, promotionalCodes, userSpecifiedCurrencyTotal, sourceTotal, internalTotal, totalDiscountPercent, userSpecifiedCurrencyAveragePricePerNight, internalAveragePricePerNight, sourceAveragePricePerNight);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class StayRateBooker {\n");
    sb.append("    userSpecifiedCurrencyBaseTotal: ").append(toIndentedString(userSpecifiedCurrencyBaseTotal)).append("\n");
    sb.append("    sourceBaseTotal: ").append(toIndentedString(sourceBaseTotal)).append("\n");
    sb.append("    internalBaseTotal: ").append(toIndentedString(internalBaseTotal)).append("\n");
    sb.append("    sourceExtraPaxModifier: ").append(toIndentedString(sourceExtraPaxModifier)).append("\n");
    sb.append("    internalExtraPaxModifier: ").append(toIndentedString(internalExtraPaxModifier)).append("\n");
    sb.append("    userSpecifiedCurrencyExtraPaxModifier: ").append(toIndentedString(userSpecifiedCurrencyExtraPaxModifier)).append("\n");
    sb.append("    sourceExtraChildModifier: ").append(toIndentedString(sourceExtraChildModifier)).append("\n");
    sb.append("    internalExtraChildModifier: ").append(toIndentedString(internalExtraChildModifier)).append("\n");
    sb.append("    userSpecifiedCurrencyExtraChildModifier: ").append(toIndentedString(userSpecifiedCurrencyExtraChildModifier)).append("\n");
    sb.append("    sourceSingleOccupantModifier: ").append(toIndentedString(sourceSingleOccupantModifier)).append("\n");
    sb.append("    internalSingleOccupantModifier: ").append(toIndentedString(internalSingleOccupantModifier)).append("\n");
    sb.append("    userSpecifiedCurrencySingleOccupantModifier: ").append(toIndentedString(userSpecifiedCurrencySingleOccupantModifier)).append("\n");
    sb.append("    sourcePromotionalModifier: ").append(toIndentedString(sourcePromotionalModifier)).append("\n");
    sb.append("    internalPromotionalModifier: ").append(toIndentedString(internalPromotionalModifier)).append("\n");
    sb.append("    userSpecifiedCurrencyPromotionalModifier: ").append(toIndentedString(userSpecifiedCurrencyPromotionalModifier)).append("\n");
    sb.append("    sourcePremiumModifier: ").append(toIndentedString(sourcePremiumModifier)).append("\n");
    sb.append("    internalPremiumModifier: ").append(toIndentedString(internalPremiumModifier)).append("\n");
    sb.append("    userSpecifiedCurrencyPremiumModifier: ").append(toIndentedString(userSpecifiedCurrencyPremiumModifier)).append("\n");
    sb.append("    sourceChannelModifier: ").append(toIndentedString(sourceChannelModifier)).append("\n");
    sb.append("    internalChannelModifier: ").append(toIndentedString(internalChannelModifier)).append("\n");
    sb.append("    userSpecifiedCurrencyChannelModifier: ").append(toIndentedString(userSpecifiedCurrencyChannelModifier)).append("\n");
    sb.append("    quantity: ").append(toIndentedString(quantity)).append("\n");
    sb.append("    minOccupancy: ").append(toIndentedString(minOccupancy)).append("\n");
    sb.append("    maxOccupancy: ").append(toIndentedString(maxOccupancy)).append("\n");
    sb.append("    rateSource: ").append(toIndentedString(rateSource)).append("\n");
    sb.append("    promotionalDiscountPercent: ").append(toIndentedString(promotionalDiscountPercent)).append("\n");
    sb.append("    channelDiscountPercent: ").append(toIndentedString(channelDiscountPercent)).append("\n");
    sb.append("    premiumPercent: ").append(toIndentedString(premiumPercent)).append("\n");
    sb.append("    available: ").append(toIndentedString(available)).append("\n");
    sb.append("    sourceToUserCurrencyQuote: ").append(toIndentedString(sourceToUserCurrencyQuote)).append("\n");
    sb.append("    sourceToInternalCurrencyQuote: ").append(toIndentedString(sourceToInternalCurrencyQuote)).append("\n");
    sb.append("    offerDetails: ").append(toIndentedString(offerDetails)).append("\n");
    sb.append("    promotionalCodes: ").append(toIndentedString(promotionalCodes)).append("\n");
    sb.append("    userSpecifiedCurrencyTotal: ").append(toIndentedString(userSpecifiedCurrencyTotal)).append("\n");
    sb.append("    sourceTotal: ").append(toIndentedString(sourceTotal)).append("\n");
    sb.append("    internalTotal: ").append(toIndentedString(internalTotal)).append("\n");
    sb.append("    totalDiscountPercent: ").append(toIndentedString(totalDiscountPercent)).append("\n");
    sb.append("    userSpecifiedCurrencyAveragePricePerNight: ").append(toIndentedString(userSpecifiedCurrencyAveragePricePerNight)).append("\n");
    sb.append("    internalAveragePricePerNight: ").append(toIndentedString(internalAveragePricePerNight)).append("\n");
    sb.append("    sourceAveragePricePerNight: ").append(toIndentedString(sourceAveragePricePerNight)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

