/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release   # Booking API Welcome to the Booking Engine API - A programmer-friendly way to book inventory that was found on our platform. We take great care in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive payment-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 21.16.3
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.booking.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.booking.model.CancellationPolicy;
import travel.wink.sdk.booking.model.ExtraCharges;
import travel.wink.sdk.booking.model.GuestRoom;
import travel.wink.sdk.booking.model.MoneySetInternalTotal;
import travel.wink.sdk.booking.model.MoneySetSourceTotal;
import travel.wink.sdk.booking.model.MoneySetUserSpecifiedCurrencyTotal;
import travel.wink.sdk.booking.model.PropertyPolicy;
import travel.wink.sdk.booking.model.RatePlan;
import travel.wink.sdk.booking.model.StayRate;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * All information about the room that was booked.
 */
@ApiModel(description = "All information about the room that was booked.")
@JsonPropertyOrder({
  RoomStay.JSON_PROPERTY_POLICY,
  RoomStay.JSON_PROPERTY_ROOM,
  RoomStay.JSON_PROPERTY_ROOMS,
  RoomStay.JSON_PROPERTY_BED_TYPE,
  RoomStay.JSON_PROPERTY_ADULTS,
  RoomStay.JSON_PROPERTY_CHILDREN,
  RoomStay.JSON_PROPERTY_START_DATE,
  RoomStay.JSON_PROPERTY_END_DATE,
  RoomStay.JSON_PROPERTY_PRICE,
  RoomStay.JSON_PROPERTY_ROOM_RATE_IDENTIFIER,
  RoomStay.JSON_PROPERTY_ROOM_RATE_INTERNAL_NAME,
  RoomStay.JSON_PROPERTY_RATE_PLAN,
  RoomStay.JSON_PROPERTY_PERK_TYPES,
  RoomStay.JSON_PROPERTY_EXTRA_CHARGES,
  RoomStay.JSON_PROPERTY_ACTIVE_CANCELLATION_POLICY,
  RoomStay.JSON_PROPERTY_CANCELLABLE,
  RoomStay.JSON_PROPERTY_CANCELLABLE_BY_HOTEL,
  RoomStay.JSON_PROPERTY_CANCELLABLE_WITH_POTENTIAL_CHARGE,
  RoomStay.JSON_PROPERTY_SOURCE_TOTAL,
  RoomStay.JSON_PROPERTY_INTERNAL_TOTAL,
  RoomStay.JSON_PROPERTY_ROOM_NIGHTS,
  RoomStay.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL,
  RoomStay.JSON_PROPERTY_GUESTS,
  RoomStay.JSON_PROPERTY_RATE_SOURCE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-09-16T10:41:43.298714057+07:00[Asia/Bangkok]")
public class RoomStay {
  public static final String JSON_PROPERTY_POLICY = "policy";
  private PropertyPolicy policy;

  public static final String JSON_PROPERTY_ROOM = "room";
  private GuestRoom room;

  public static final String JSON_PROPERTY_ROOMS = "rooms";
  private Integer rooms = 1;

  public static final String JSON_PROPERTY_BED_TYPE = "bedType";
  private String bedType;

  public static final String JSON_PROPERTY_ADULTS = "adults";
  private Integer adults = 0;

  public static final String JSON_PROPERTY_CHILDREN = "children";
  private Integer children = 0;

  public static final String JSON_PROPERTY_START_DATE = "startDate";
  private LocalDate startDate;

  public static final String JSON_PROPERTY_END_DATE = "endDate";
  private LocalDate endDate;

  public static final String JSON_PROPERTY_PRICE = "price";
  private StayRate price;

  public static final String JSON_PROPERTY_ROOM_RATE_IDENTIFIER = "roomRateIdentifier";
  private UUID roomRateIdentifier;

  public static final String JSON_PROPERTY_ROOM_RATE_INTERNAL_NAME = "roomRateInternalName";
  private String roomRateInternalName;

  public static final String JSON_PROPERTY_RATE_PLAN = "ratePlan";
  private RatePlan ratePlan;

  /**
   * List of perks that came with the master rate
   */
  public enum PerkTypesEnum {
    LOYALTY_POINTS("PERK_LOYALTY_POINTS"),
    
    WINE("PERK_WINE"),
    
    FREE_DRINK_VOUCHER("PERK_FREE_DRINK_VOUCHER"),
    
    FREE_MEAL_TWO_PEOPLE("PERK_FREE_MEAL_TWO_PEOPLE"),
    
    FREE_ONE_HOUR_MASSAGE("PERK_FREE_ONE_HOUR_MASSAGE"),
    
    TWENTY_PERCENT_FOOD_BEVERAGE_DISCOUNT("PERK_TWENTY_PERCENT_FOOD_BEVERAGE_DISCOUNT"),
    
    TWENTY_PERCENT_SPA_DISCOUNT_VOUCHER("PERK_TWENTY_PERCENT_SPA_DISCOUNT_VOUCHER"),
    
    GUARANTEED_UPGRADE("PERK_GUARANTEED_UPGRADE"),
    
    EARLY_CHECKIN("PERK_EARLY_CHECKIN"),
    
    ROOM_UPGRADE("PERK_ROOM_UPGRADE"),
    
    LATE_CHECKOUT("PERK_LATE_CHECKOUT"),
    
    AIRPORT_TRANSFER("PERK_AIRPORT_TRANSFER"),
    
    AIRPORT_PICK_UP("PERK_AIRPORT_PICK_UP"),
    
    BOTTLE_CHAMPAGNE_ON_ARRIVAL("PERK_BOTTLE_CHAMPAGNE_ON_ARRIVAL"),
    
    BOTTLE_SPARKLING_WINE_ON_ARRIVAL("PERK_BOTTLE_SPARKLING_WINE_ON_ARRIVAL"),
    
    BOTTLE_WINE_ON_ARRIVAL("PERK_BOTTLE_WINE_ON_ARRIVAL");

    private String value;

    PerkTypesEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PerkTypesEnum fromValue(String value) {
      for (PerkTypesEnum b : PerkTypesEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PERK_TYPES = "perkTypes";
  private List<PerkTypesEnum> perkTypes = null;

  public static final String JSON_PROPERTY_EXTRA_CHARGES = "extraCharges";
  private ExtraCharges extraCharges;

  public static final String JSON_PROPERTY_ACTIVE_CANCELLATION_POLICY = "activeCancellationPolicy";
  private CancellationPolicy activeCancellationPolicy;

  public static final String JSON_PROPERTY_CANCELLABLE = "cancellable";
  private Boolean cancellable;

  public static final String JSON_PROPERTY_CANCELLABLE_BY_HOTEL = "cancellableByHotel";
  private Boolean cancellableByHotel;

  public static final String JSON_PROPERTY_CANCELLABLE_WITH_POTENTIAL_CHARGE = "cancellableWithPotentialCharge";
  private Boolean cancellableWithPotentialCharge;

  public static final String JSON_PROPERTY_SOURCE_TOTAL = "sourceTotal";
  private MoneySetSourceTotal sourceTotal;

  public static final String JSON_PROPERTY_INTERNAL_TOTAL = "internalTotal";
  private MoneySetInternalTotal internalTotal;

  public static final String JSON_PROPERTY_ROOM_NIGHTS = "roomNights";
  private Long roomNights;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL = "userSpecifiedCurrencyTotal";
  private MoneySetUserSpecifiedCurrencyTotal userSpecifiedCurrencyTotal;

  public static final String JSON_PROPERTY_GUESTS = "guests";
  private Integer guests;

  /**
   * Gets or Sets rateSource
   */
  public enum RateSourceEnum {
    TRAVELIKO("TRAVELIKO"),
    
    SITEMINDER("SITEMINDER"),
    
    FASTBOOKING("FASTBOOKING"),
    
    RATEGAIN("RATEGAIN"),
    
    CLOUD_BEDS("CLOUD_BEDS"),
    
    YIELD_PLANET("YIELD_PLANET"),
    
    TRAVELCLICK("TRAVELCLICK"),
    
    HOTEL_GURU("HOTEL_GURU"),
    
    OTHER_CHANNEL_MANAGER("OTHER_CHANNEL_MANAGER"),
    
    BOOKING_JINI("BOOKING_JINI"),
    
    HOTEL_LINK_SOLUTIONS("HOTEL_LINK_SOLUTIONS"),
    
    ALLOTZ("ALLOTZ"),
    
    DEDGE("DEDGE"),
    
    RATE_TIGER("RATE_TIGER"),
    
    RESAVENUE("RESAVENUE"),
    
    COMANCHE("COMANCHE"),
    
    OMNIBEES("OMNIBEES"),
    
    EZEE("EZEE"),
    
    SYNXIS("SYNXIS");

    private String value;

    RateSourceEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static RateSourceEnum fromValue(String value) {
      for (RateSourceEnum b : RateSourceEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_RATE_SOURCE = "rateSource";
  private RateSourceEnum rateSource;

  public RoomStay() { 
  }

  public RoomStay policy(PropertyPolicy policy) {
    
    this.policy = policy;
    return this;
  }

   /**
   * Get policy
   * @return policy
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PropertyPolicy getPolicy() {
    return policy;
  }


  @JsonProperty(JSON_PROPERTY_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPolicy(PropertyPolicy policy) {
    this.policy = policy;
  }


  public RoomStay room(GuestRoom room) {
    
    this.room = room;
    return this;
  }

   /**
   * Get room
   * @return room
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ROOM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GuestRoom getRoom() {
    return room;
  }


  @JsonProperty(JSON_PROPERTY_ROOM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoom(GuestRoom room) {
    this.room = room;
  }


  public RoomStay rooms(Integer rooms) {
    
    this.rooms = rooms;
    return this;
  }

   /**
   * Number of rooms. Always 1 since we switched to creating one booking per room.
   * @return rooms
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "1", value = "Number of rooms. Always 1 since we switched to creating one booking per room.")
  @JsonProperty(JSON_PROPERTY_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getRooms() {
    return rooms;
  }


  @JsonProperty(JSON_PROPERTY_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRooms(Integer rooms) {
    this.rooms = rooms;
  }


  public RoomStay bedType(String bedType) {
    
    this.bedType = bedType;
    return this;
  }

   /**
   * Supported OTA specification &#x60;BED&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return bedType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Supported OTA specification `BED` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
  @JsonProperty(JSON_PROPERTY_BED_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBedType() {
    return bedType;
  }


  @JsonProperty(JSON_PROPERTY_BED_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBedType(String bedType) {
    this.bedType = bedType;
  }


  public RoomStay adults(Integer adults) {
    
    this.adults = adults;
    return this;
  }

   /**
   * The actual amount of adults as determined by the hotel&#39;s policy.
   * @return adults
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "2", value = "The actual amount of adults as determined by the hotel's policy.")
  @JsonProperty(JSON_PROPERTY_ADULTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getAdults() {
    return adults;
  }


  @JsonProperty(JSON_PROPERTY_ADULTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAdults(Integer adults) {
    this.adults = adults;
  }


  public RoomStay children(Integer children) {
    
    this.children = children;
    return this;
  }

   /**
   * The actual amount of children as determined by the hotel&#39;s policy.
   * @return children
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "0", value = "The actual amount of children as determined by the hotel's policy.")
  @JsonProperty(JSON_PROPERTY_CHILDREN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getChildren() {
    return children;
  }


  @JsonProperty(JSON_PROPERTY_CHILDREN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChildren(Integer children) {
    this.children = children;
  }


  public RoomStay startDate(LocalDate startDate) {
    
    this.startDate = startDate;
    return this;
  }

   /**
   * Stay start date
   * @return startDate
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(example = "Fri Dec 24 07:00:00 ICT 2021", value = "Stay start date")
  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getStartDate() {
    return startDate;
  }


  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStartDate(LocalDate startDate) {
    this.startDate = startDate;
  }


  public RoomStay endDate(LocalDate endDate) {
    
    this.endDate = endDate;
    return this;
  }

   /**
   * Stay end date
   * @return endDate
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(example = "Fri Dec 31 07:00:00 ICT 2021", value = "Stay end date")
  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getEndDate() {
    return endDate;
  }


  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEndDate(LocalDate endDate) {
    this.endDate = endDate;
  }


  public RoomStay price(StayRate price) {
    
    this.price = price;
    return this;
  }

   /**
   * Get price
   * @return price
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StayRate getPrice() {
    return price;
  }


  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPrice(StayRate price) {
    this.price = price;
  }


  public RoomStay roomRateIdentifier(UUID roomRateIdentifier) {
    
    this.roomRateIdentifier = roomRateIdentifier;
    return this;
  }

   /**
   * Master rate identifier
   * @return roomRateIdentifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Master rate identifier")
  @JsonProperty(JSON_PROPERTY_ROOM_RATE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getRoomRateIdentifier() {
    return roomRateIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_RATE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomRateIdentifier(UUID roomRateIdentifier) {
    this.roomRateIdentifier = roomRateIdentifier;
  }


  public RoomStay roomRateInternalName(String roomRateInternalName) {
    
    this.roomRateInternalName = roomRateInternalName;
    return this;
  }

   /**
   * Master rate internal name
   * @return roomRateInternalName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Master Rate 1", value = "Master rate internal name")
  @JsonProperty(JSON_PROPERTY_ROOM_RATE_INTERNAL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRoomRateInternalName() {
    return roomRateInternalName;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_RATE_INTERNAL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomRateInternalName(String roomRateInternalName) {
    this.roomRateInternalName = roomRateInternalName;
  }


  public RoomStay ratePlan(RatePlan ratePlan) {
    
    this.ratePlan = ratePlan;
    return this;
  }

   /**
   * Get ratePlan
   * @return ratePlan
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_RATE_PLAN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RatePlan getRatePlan() {
    return ratePlan;
  }


  @JsonProperty(JSON_PROPERTY_RATE_PLAN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRatePlan(RatePlan ratePlan) {
    this.ratePlan = ratePlan;
  }


  public RoomStay perkTypes(List<PerkTypesEnum> perkTypes) {
    
    this.perkTypes = perkTypes;
    return this;
  }

  public RoomStay addPerkTypesItem(PerkTypesEnum perkTypesItem) {
    if (this.perkTypes == null) {
      this.perkTypes = new ArrayList<>();
    }
    this.perkTypes.add(perkTypesItem);
    return this;
  }

   /**
   * List of perks that came with the master rate
   * @return perkTypes
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "[\"PERK_FREE_DRINK_VOUCHER\",\"PERK_EARLY_CHECKIN\"]", value = "List of perks that came with the master rate")
  @JsonProperty(JSON_PROPERTY_PERK_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<PerkTypesEnum> getPerkTypes() {
    return perkTypes;
  }


  @JsonProperty(JSON_PROPERTY_PERK_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPerkTypes(List<PerkTypesEnum> perkTypes) {
    this.perkTypes = perkTypes;
  }


  public RoomStay extraCharges(ExtraCharges extraCharges) {
    
    this.extraCharges = extraCharges;
    return this;
  }

   /**
   * Get extraCharges
   * @return extraCharges
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_EXTRA_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ExtraCharges getExtraCharges() {
    return extraCharges;
  }


  @JsonProperty(JSON_PROPERTY_EXTRA_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExtraCharges(ExtraCharges extraCharges) {
    this.extraCharges = extraCharges;
  }


  public RoomStay activeCancellationPolicy(CancellationPolicy activeCancellationPolicy) {
    
    this.activeCancellationPolicy = activeCancellationPolicy;
    return this;
  }

   /**
   * Get activeCancellationPolicy
   * @return activeCancellationPolicy
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ACTIVE_CANCELLATION_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CancellationPolicy getActiveCancellationPolicy() {
    return activeCancellationPolicy;
  }


  @JsonProperty(JSON_PROPERTY_ACTIVE_CANCELLATION_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setActiveCancellationPolicy(CancellationPolicy activeCancellationPolicy) {
    this.activeCancellationPolicy = activeCancellationPolicy;
  }


  public RoomStay cancellable(Boolean cancellable) {
    
    this.cancellable = cancellable;
    return this;
  }

   /**
   * Get cancellable
   * @return cancellable
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CANCELLABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellable() {
    return cancellable;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellable(Boolean cancellable) {
    this.cancellable = cancellable;
  }


  public RoomStay cancellableByHotel(Boolean cancellableByHotel) {
    
    this.cancellableByHotel = cancellableByHotel;
    return this;
  }

   /**
   * Get cancellableByHotel
   * @return cancellableByHotel
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_HOTEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableByHotel() {
    return cancellableByHotel;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_HOTEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableByHotel(Boolean cancellableByHotel) {
    this.cancellableByHotel = cancellableByHotel;
  }


  public RoomStay cancellableWithPotentialCharge(Boolean cancellableWithPotentialCharge) {
    
    this.cancellableWithPotentialCharge = cancellableWithPotentialCharge;
    return this;
  }

   /**
   * Get cancellableWithPotentialCharge
   * @return cancellableWithPotentialCharge
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CANCELLABLE_WITH_POTENTIAL_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableWithPotentialCharge() {
    return cancellableWithPotentialCharge;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_WITH_POTENTIAL_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableWithPotentialCharge(Boolean cancellableWithPotentialCharge) {
    this.cancellableWithPotentialCharge = cancellableWithPotentialCharge;
  }


  public RoomStay sourceTotal(MoneySetSourceTotal sourceTotal) {
    
    this.sourceTotal = sourceTotal;
    return this;
  }

   /**
   * Get sourceTotal
   * @return sourceTotal
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SOURCE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MoneySetSourceTotal getSourceTotal() {
    return sourceTotal;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceTotal(MoneySetSourceTotal sourceTotal) {
    this.sourceTotal = sourceTotal;
  }


  public RoomStay internalTotal(MoneySetInternalTotal internalTotal) {
    
    this.internalTotal = internalTotal;
    return this;
  }

   /**
   * Get internalTotal
   * @return internalTotal
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INTERNAL_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MoneySetInternalTotal getInternalTotal() {
    return internalTotal;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalTotal(MoneySetInternalTotal internalTotal) {
    this.internalTotal = internalTotal;
  }


  public RoomStay roomNights(Long roomNights) {
    
    this.roomNights = roomNights;
    return this;
  }

   /**
   * Total number of nights the guest stays at the hotel. -1 indicates there is an error.
   * @return roomNights
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "2", value = "Total number of nights the guest stays at the hotel. -1 indicates there is an error.")
  @JsonProperty(JSON_PROPERTY_ROOM_NIGHTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getRoomNights() {
    return roomNights;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_NIGHTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomNights(Long roomNights) {
    this.roomNights = roomNights;
  }


  public RoomStay userSpecifiedCurrencyTotal(MoneySetUserSpecifiedCurrencyTotal userSpecifiedCurrencyTotal) {
    
    this.userSpecifiedCurrencyTotal = userSpecifiedCurrencyTotal;
    return this;
  }

   /**
   * Get userSpecifiedCurrencyTotal
   * @return userSpecifiedCurrencyTotal
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MoneySetUserSpecifiedCurrencyTotal getUserSpecifiedCurrencyTotal() {
    return userSpecifiedCurrencyTotal;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyTotal(MoneySetUserSpecifiedCurrencyTotal userSpecifiedCurrencyTotal) {
    this.userSpecifiedCurrencyTotal = userSpecifiedCurrencyTotal;
  }


  public RoomStay guests(Integer guests) {
    
    this.guests = guests;
    return this;
  }

   /**
   * Get guests
   * @return guests
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_GUESTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getGuests() {
    return guests;
  }


  @JsonProperty(JSON_PROPERTY_GUESTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGuests(Integer guests) {
    this.guests = guests;
  }


  public RoomStay rateSource(RateSourceEnum rateSource) {
    
    this.rateSource = rateSource;
    return this;
  }

   /**
   * Get rateSource
   * @return rateSource
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_RATE_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RateSourceEnum getRateSource() {
    return rateSource;
  }


  @JsonProperty(JSON_PROPERTY_RATE_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRateSource(RateSourceEnum rateSource) {
    this.rateSource = rateSource;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RoomStay roomStay = (RoomStay) o;
    return Objects.equals(this.policy, roomStay.policy) &&
        Objects.equals(this.room, roomStay.room) &&
        Objects.equals(this.rooms, roomStay.rooms) &&
        Objects.equals(this.bedType, roomStay.bedType) &&
        Objects.equals(this.adults, roomStay.adults) &&
        Objects.equals(this.children, roomStay.children) &&
        Objects.equals(this.startDate, roomStay.startDate) &&
        Objects.equals(this.endDate, roomStay.endDate) &&
        Objects.equals(this.price, roomStay.price) &&
        Objects.equals(this.roomRateIdentifier, roomStay.roomRateIdentifier) &&
        Objects.equals(this.roomRateInternalName, roomStay.roomRateInternalName) &&
        Objects.equals(this.ratePlan, roomStay.ratePlan) &&
        Objects.equals(this.perkTypes, roomStay.perkTypes) &&
        Objects.equals(this.extraCharges, roomStay.extraCharges) &&
        Objects.equals(this.activeCancellationPolicy, roomStay.activeCancellationPolicy) &&
        Objects.equals(this.cancellable, roomStay.cancellable) &&
        Objects.equals(this.cancellableByHotel, roomStay.cancellableByHotel) &&
        Objects.equals(this.cancellableWithPotentialCharge, roomStay.cancellableWithPotentialCharge) &&
        Objects.equals(this.sourceTotal, roomStay.sourceTotal) &&
        Objects.equals(this.internalTotal, roomStay.internalTotal) &&
        Objects.equals(this.roomNights, roomStay.roomNights) &&
        Objects.equals(this.userSpecifiedCurrencyTotal, roomStay.userSpecifiedCurrencyTotal) &&
        Objects.equals(this.guests, roomStay.guests) &&
        Objects.equals(this.rateSource, roomStay.rateSource);
  }

  @Override
  public int hashCode() {
    return Objects.hash(policy, room, rooms, bedType, adults, children, startDate, endDate, price, roomRateIdentifier, roomRateInternalName, ratePlan, perkTypes, extraCharges, activeCancellationPolicy, cancellable, cancellableByHotel, cancellableWithPotentialCharge, sourceTotal, internalTotal, roomNights, userSpecifiedCurrencyTotal, guests, rateSource);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RoomStay {\n");
    sb.append("    policy: ").append(toIndentedString(policy)).append("\n");
    sb.append("    room: ").append(toIndentedString(room)).append("\n");
    sb.append("    rooms: ").append(toIndentedString(rooms)).append("\n");
    sb.append("    bedType: ").append(toIndentedString(bedType)).append("\n");
    sb.append("    adults: ").append(toIndentedString(adults)).append("\n");
    sb.append("    children: ").append(toIndentedString(children)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    price: ").append(toIndentedString(price)).append("\n");
    sb.append("    roomRateIdentifier: ").append(toIndentedString(roomRateIdentifier)).append("\n");
    sb.append("    roomRateInternalName: ").append(toIndentedString(roomRateInternalName)).append("\n");
    sb.append("    ratePlan: ").append(toIndentedString(ratePlan)).append("\n");
    sb.append("    perkTypes: ").append(toIndentedString(perkTypes)).append("\n");
    sb.append("    extraCharges: ").append(toIndentedString(extraCharges)).append("\n");
    sb.append("    activeCancellationPolicy: ").append(toIndentedString(activeCancellationPolicy)).append("\n");
    sb.append("    cancellable: ").append(toIndentedString(cancellable)).append("\n");
    sb.append("    cancellableByHotel: ").append(toIndentedString(cancellableByHotel)).append("\n");
    sb.append("    cancellableWithPotentialCharge: ").append(toIndentedString(cancellableWithPotentialCharge)).append("\n");
    sb.append("    sourceTotal: ").append(toIndentedString(sourceTotal)).append("\n");
    sb.append("    internalTotal: ").append(toIndentedString(internalTotal)).append("\n");
    sb.append("    roomNights: ").append(toIndentedString(roomNights)).append("\n");
    sb.append("    userSpecifiedCurrencyTotal: ").append(toIndentedString(userSpecifiedCurrencyTotal)).append("\n");
    sb.append("    guests: ").append(toIndentedString(guests)).append("\n");
    sb.append("    rateSource: ").append(toIndentedString(rateSource)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

