/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.booking.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import travel.wink.sdk.booking.model.AgentBookingRequest;

@JsonPropertyOrder(value={"rooms", "displayCurrency", "displayLanguage", "sourceUrl", "traceId"})
public class CreateAgentBookingRequest {
    public static final String JSON_PROPERTY_ROOMS = "rooms";
    private List<AgentBookingRequest> rooms = new ArrayList<AgentBookingRequest>();
    public static final String JSON_PROPERTY_DISPLAY_CURRENCY = "displayCurrency";
    private String displayCurrency = "USD";
    public static final String JSON_PROPERTY_DISPLAY_LANGUAGE = "displayLanguage";
    private String displayLanguage = "en";
    public static final String JSON_PROPERTY_SOURCE_URL = "sourceUrl";
    private String sourceUrl;
    public static final String JSON_PROPERTY_TRACE_ID = "traceId";
    private String traceId;

    public CreateAgentBookingRequest rooms(List<AgentBookingRequest> rooms) {
        this.rooms = rooms;
        return this;
    }

    public CreateAgentBookingRequest addRoomsItem(AgentBookingRequest roomsItem) {
        this.rooms.add(roomsItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="List of room configuration booking requests. Each entry is a separately booked room.")
    @JsonProperty(value="rooms")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<AgentBookingRequest> getRooms() {
        return this.rooms;
    }

    @JsonProperty(value="rooms")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRooms(List<AgentBookingRequest> rooms) {
        this.rooms = rooms;
    }

    public CreateAgentBookingRequest displayCurrency(String displayCurrency) {
        this.displayCurrency = displayCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="USD", required=true, value="The desired currency")
    @JsonProperty(value="displayCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDisplayCurrency() {
        return this.displayCurrency;
    }

    @JsonProperty(value="displayCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDisplayCurrency(String displayCurrency) {
        this.displayCurrency = displayCurrency;
    }

    public CreateAgentBookingRequest displayLanguage(String displayLanguage) {
        this.displayLanguage = displayLanguage;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="en", required=true, value="The desired language")
    @JsonProperty(value="displayLanguage")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDisplayLanguage() {
        return this.displayLanguage;
    }

    @JsonProperty(value="displayLanguage")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDisplayLanguage(String displayLanguage) {
        this.displayLanguage = displayLanguage;
    }

    public CreateAgentBookingRequest sourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="https://www.traveliko.com", required=true, value="Where did the booking occur")
    @JsonProperty(value="sourceUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSourceUrl() {
        return this.sourceUrl;
    }

    @JsonProperty(value="sourceUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    public CreateAgentBookingRequest traceId(String traceId) {
        this.traceId = traceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="integrator-booking-code-1", value="Integrator can choose to include a unique identifier to help identify the collection of bookings")
    @JsonProperty(value="traceId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTraceId() {
        return this.traceId;
    }

    @JsonProperty(value="traceId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateAgentBookingRequest createAgentBookingRequest = (CreateAgentBookingRequest)o;
        return Objects.equals(this.rooms, createAgentBookingRequest.rooms) && Objects.equals(this.displayCurrency, createAgentBookingRequest.displayCurrency) && Objects.equals(this.displayLanguage, createAgentBookingRequest.displayLanguage) && Objects.equals(this.sourceUrl, createAgentBookingRequest.sourceUrl) && Objects.equals(this.traceId, createAgentBookingRequest.traceId);
    }

    public int hashCode() {
        return Objects.hash(this.rooms, this.displayCurrency, this.displayLanguage, this.sourceUrl, this.traceId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateAgentBookingRequest {\n");
        sb.append("    rooms: ").append(this.toIndentedString(this.rooms)).append("\n");
        sb.append("    displayCurrency: ").append(this.toIndentedString(this.displayCurrency)).append("\n");
        sb.append("    displayLanguage: ").append(this.toIndentedString(this.displayLanguage)).append("\n");
        sb.append("    sourceUrl: ").append(this.toIndentedString(this.sourceUrl)).append("\n");
        sb.append("    traceId: ").append(this.toIndentedString(this.traceId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

