/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.booking.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import travel.wink.sdk.booking.model.AncillaryRequest;
import travel.wink.sdk.booking.model.BookingUserRequest;
import travel.wink.sdk.booking.model.RoomConfiguration;

@ApiModel(description="List of room configuration booking requests. Each entry is a separately booked room.")
@JsonPropertyOrder(value={"hotelIdentifier", "startDate", "endDate", "roomConfiguration", "promotionalCodes", "roomRateIdentifier", "bedType", "packageOffers", "addOnOffers", "ancillaries", "specialRequests", "user", "traceId", "paymentIdentifier"})
public class MerchantBookingRequest {
    public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
    private UUID hotelIdentifier;
    public static final String JSON_PROPERTY_START_DATE = "startDate";
    private LocalDate startDate;
    public static final String JSON_PROPERTY_END_DATE = "endDate";
    private LocalDate endDate;
    public static final String JSON_PROPERTY_ROOM_CONFIGURATION = "roomConfiguration";
    private RoomConfiguration roomConfiguration;
    public static final String JSON_PROPERTY_PROMOTIONAL_CODES = "promotionalCodes";
    private List<String> promotionalCodes = null;
    public static final String JSON_PROPERTY_ROOM_RATE_IDENTIFIER = "roomRateIdentifier";
    private UUID roomRateIdentifier;
    public static final String JSON_PROPERTY_BED_TYPE = "bedType";
    private String bedType;
    public static final String JSON_PROPERTY_PACKAGE_OFFERS = "packageOffers";
    private List<String> packageOffers = null;
    public static final String JSON_PROPERTY_ADD_ON_OFFERS = "addOnOffers";
    private List<String> addOnOffers = null;
    public static final String JSON_PROPERTY_ANCILLARIES = "ancillaries";
    private List<AncillaryRequest> ancillaries = null;
    public static final String JSON_PROPERTY_SPECIAL_REQUESTS = "specialRequests";
    private String specialRequests;
    public static final String JSON_PROPERTY_USER = "user";
    private BookingUserRequest user;
    public static final String JSON_PROPERTY_TRACE_ID = "traceId";
    private String traceId;
    public static final String JSON_PROPERTY_PAYMENT_IDENTIFIER = "paymentIdentifier";
    private String paymentIdentifier;

    public MerchantBookingRequest hotelIdentifier(UUID hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Unique hotel record identifier.")
    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getHotelIdentifier() {
        return this.hotelIdentifier;
    }

    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setHotelIdentifier(UUID hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
    }

    public MerchantBookingRequest startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(example="Sun Jan 31 07:00:00 ICT 2021", required=true, value="Date when guest arrives on the premises.")
    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDate getStartDate() {
        return this.startDate;
    }

    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public MerchantBookingRequest endDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(example="Sun Feb 07 07:00:00 ICT 2021", required=true, value="Date when guest departs the premises.")
    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDate getEndDate() {
        return this.endDate;
    }

    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public MerchantBookingRequest roomConfiguration(RoomConfiguration roomConfiguration) {
        this.roomConfiguration = roomConfiguration;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="roomConfiguration")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public RoomConfiguration getRoomConfiguration() {
        return this.roomConfiguration;
    }

    @JsonProperty(value="roomConfiguration")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRoomConfiguration(RoomConfiguration roomConfiguration) {
        this.roomConfiguration = roomConfiguration;
    }

    public MerchantBookingRequest promotionalCodes(List<String> promotionalCodes) {
        this.promotionalCodes = promotionalCodes;
        return this;
    }

    public MerchantBookingRequest addPromotionalCodesItem(String promotionalCodesItem) {
        if (this.promotionalCodes == null) {
            this.promotionalCodes = new ArrayList<String>();
        }
        this.promotionalCodes.add(promotionalCodesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"promo-1\",\"promo-2\"]", value="List of promotional codes the user entered to to activate a promotion.")
    @JsonProperty(value="promotionalCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getPromotionalCodes() {
        return this.promotionalCodes;
    }

    @JsonProperty(value="promotionalCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPromotionalCodes(List<String> promotionalCodes) {
        this.promotionalCodes = promotionalCodes;
    }

    public MerchantBookingRequest roomRateIdentifier(UUID roomRateIdentifier) {
        this.roomRateIdentifier = roomRateIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="The unique master rate that made the guest room / rate plan available for sale.")
    @JsonProperty(value="roomRateIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getRoomRateIdentifier() {
        return this.roomRateIdentifier;
    }

    @JsonProperty(value="roomRateIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRoomRateIdentifier(UUID roomRateIdentifier) {
        this.roomRateIdentifier = roomRateIdentifier;
    }

    public MerchantBookingRequest bedType(String bedType) {
        this.bedType = bedType;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="9", value="Guest can optionally request a specific bed type if the room type is set up with multiple bed type choices. Example: 9 is a `Single`. Taken from the `BED` OTA specification.")
    @JsonProperty(value="bedType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBedType() {
        return this.bedType;
    }

    @JsonProperty(value="bedType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBedType(String bedType) {
        this.bedType = bedType;
    }

    public MerchantBookingRequest packageOffers(List<String> packageOffers) {
        this.packageOffers = packageOffers;
        return this;
    }

    public MerchantBookingRequest addPackageOffersItem(String packageOffersItem) {
        if (this.packageOffers == null) {
            this.packageOffers = new ArrayList<String>();
        }
        this.packageOffers.add(packageOffersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"package-1\"]", value="Unique package identifiers guest wants added to her booking. Note: these add-ons must be available as part of the room type to be able to add them to a booking.")
    @JsonProperty(value="packageOffers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getPackageOffers() {
        return this.packageOffers;
    }

    @JsonProperty(value="packageOffers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPackageOffers(List<String> packageOffers) {
        this.packageOffers = packageOffers;
    }

    public MerchantBookingRequest addOnOffers(List<String> addOnOffers) {
        this.addOnOffers = addOnOffers;
        return this;
    }

    public MerchantBookingRequest addAddOnOffersItem(String addOnOffersItem) {
        if (this.addOnOffers == null) {
            this.addOnOffers = new ArrayList<String>();
        }
        this.addOnOffers.add(addOnOffersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"add-on-1\"]", value="Unique add-on identifiers guest wants added to her booking. Note: these add-ons must be available as part of the room type to be able to add them to a booking.")
    @JsonProperty(value="addOnOffers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getAddOnOffers() {
        return this.addOnOffers;
    }

    @JsonProperty(value="addOnOffers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAddOnOffers(List<String> addOnOffers) {
        this.addOnOffers = addOnOffers;
    }

    public MerchantBookingRequest ancillaries(List<AncillaryRequest> ancillaries) {
        this.ancillaries = ancillaries;
        return this;
    }

    public MerchantBookingRequest addAncillariesItem(AncillaryRequest ancillariesItem) {
        if (this.ancillaries == null) {
            this.ancillaries = new ArrayList<AncillaryRequest>();
        }
        this.ancillaries.add(ancillariesItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Extra reservations of spas, meeting rooms etc that should accompany the room type booking.")
    @JsonProperty(value="ancillaries")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<AncillaryRequest> getAncillaries() {
        return this.ancillaries;
    }

    @JsonProperty(value="ancillaries")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAncillaries(List<AncillaryRequest> ancillaries) {
        this.ancillaries = ancillaries;
    }

    public MerchantBookingRequest specialRequests(String specialRequests) {
        this.specialRequests = specialRequests;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Can I please have rose petals on my pillows when I arrive?", value="A guest can send a special request to the hotel in free-text here.")
    @JsonProperty(value="specialRequests")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSpecialRequests() {
        return this.specialRequests;
    }

    @JsonProperty(value="specialRequests")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSpecialRequests(String specialRequests) {
        this.specialRequests = specialRequests;
    }

    public MerchantBookingRequest user(BookingUserRequest user) {
        this.user = user;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public BookingUserRequest getUser() {
        return this.user;
    }

    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUser(BookingUserRequest user) {
        this.user = user;
    }

    public MerchantBookingRequest traceId(String traceId) {
        this.traceId = traceId;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="trace-1", required=true, value="traceId is a way to track multiple booking contracts")
    @JsonProperty(value="traceId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTraceId() {
        return this.traceId;
    }

    @JsonProperty(value="traceId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public MerchantBookingRequest paymentIdentifier(String paymentIdentifier) {
        this.paymentIdentifier = paymentIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="trip-pay-1", required=true, value="Identifier generated by TripPay.")
    @JsonProperty(value="paymentIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getPaymentIdentifier() {
        return this.paymentIdentifier;
    }

    @JsonProperty(value="paymentIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPaymentIdentifier(String paymentIdentifier) {
        this.paymentIdentifier = paymentIdentifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MerchantBookingRequest merchantBookingRequest = (MerchantBookingRequest)o;
        return Objects.equals(this.hotelIdentifier, merchantBookingRequest.hotelIdentifier) && Objects.equals(this.startDate, merchantBookingRequest.startDate) && Objects.equals(this.endDate, merchantBookingRequest.endDate) && Objects.equals(this.roomConfiguration, merchantBookingRequest.roomConfiguration) && Objects.equals(this.promotionalCodes, merchantBookingRequest.promotionalCodes) && Objects.equals(this.roomRateIdentifier, merchantBookingRequest.roomRateIdentifier) && Objects.equals(this.bedType, merchantBookingRequest.bedType) && Objects.equals(this.packageOffers, merchantBookingRequest.packageOffers) && Objects.equals(this.addOnOffers, merchantBookingRequest.addOnOffers) && Objects.equals(this.ancillaries, merchantBookingRequest.ancillaries) && Objects.equals(this.specialRequests, merchantBookingRequest.specialRequests) && Objects.equals(this.user, merchantBookingRequest.user) && Objects.equals(this.traceId, merchantBookingRequest.traceId) && Objects.equals(this.paymentIdentifier, merchantBookingRequest.paymentIdentifier);
    }

    public int hashCode() {
        return Objects.hash(this.hotelIdentifier, this.startDate, this.endDate, this.roomConfiguration, this.promotionalCodes, this.roomRateIdentifier, this.bedType, this.packageOffers, this.addOnOffers, this.ancillaries, this.specialRequests, this.user, this.traceId, this.paymentIdentifier);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MerchantBookingRequest {\n");
        sb.append("    hotelIdentifier: ").append(this.toIndentedString(this.hotelIdentifier)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    roomConfiguration: ").append(this.toIndentedString(this.roomConfiguration)).append("\n");
        sb.append("    promotionalCodes: ").append(this.toIndentedString(this.promotionalCodes)).append("\n");
        sb.append("    roomRateIdentifier: ").append(this.toIndentedString(this.roomRateIdentifier)).append("\n");
        sb.append("    bedType: ").append(this.toIndentedString(this.bedType)).append("\n");
        sb.append("    packageOffers: ").append(this.toIndentedString(this.packageOffers)).append("\n");
        sb.append("    addOnOffers: ").append(this.toIndentedString(this.addOnOffers)).append("\n");
        sb.append("    ancillaries: ").append(this.toIndentedString(this.ancillaries)).append("\n");
        sb.append("    specialRequests: ").append(this.toIndentedString(this.specialRequests)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    traceId: ").append(this.toIndentedString(this.traceId)).append("\n");
        sb.append("    paymentIdentifier: ").append(this.toIndentedString(this.paymentIdentifier)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

