package travel.wink.sdk.booking.api;

import travel.wink.sdk.booking.invoker.ApiClient;

import travel.wink.sdk.booking.model.BookingConfirmations;
import travel.wink.sdk.booking.model.BookingView;
import travel.wink.sdk.booking.model.BooleanResponse;
import travel.wink.sdk.booking.model.CancellationDetail;
import travel.wink.sdk.booking.model.CreateAgentBookingRequest;
import travel.wink.sdk.booking.model.CreateMerchantBooking400Response;
import travel.wink.sdk.booking.model.CreateMerchantBookingRequest;
import travel.wink.sdk.booking.model.GenericErrorMessage;
import travel.wink.sdk.booking.model.PageBookingView;
import travel.wink.sdk.booking.model.State;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-11-08T09:35:53.801098523+07:00[Asia/Bangkok]")
public class BookingApi {
    private ApiClient apiClient;

    public BookingApi() {
        this(new ApiClient());
    }

    @Autowired
    public BookingApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Cancel Booking
     * Cancel a booking by its booking identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param bookingIdentifier Cancel booking by identifier
     * @param cancellationDetail The cancellationDetail parameter
     * @param winkVersion The winkVersion parameter
     * @return BookingView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec cancelBookingRequestCreation(String bookingIdentifier, CancellationDetail cancellationDetail, String winkVersion) throws WebClientResponseException {
        Object postBody = cancellationDetail;
        // verify the required parameter 'bookingIdentifier' is set
        if (bookingIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingIdentifier' when calling cancelBooking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'cancellationDetail' is set
        if (cancellationDetail == null) {
            throw new WebClientResponseException("Missing the required parameter 'cancellationDetail' when calling cancelBooking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("bookingIdentifier", bookingIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BookingView> localVarReturnType = new ParameterizedTypeReference<BookingView>() {};
        return apiClient.invokeAPI("/api/booking/{bookingIdentifier}", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Cancel Booking
     * Cancel a booking by its booking identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param bookingIdentifier Cancel booking by identifier
     * @param cancellationDetail The cancellationDetail parameter
     * @param winkVersion The winkVersion parameter
     * @return BookingView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BookingView> cancelBooking(String bookingIdentifier, CancellationDetail cancellationDetail, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingView> localVarReturnType = new ParameterizedTypeReference<BookingView>() {};
        return cancelBookingRequestCreation(bookingIdentifier, cancellationDetail, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<BookingView>> cancelBookingWithHttpInfo(String bookingIdentifier, CancellationDetail cancellationDetail, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingView> localVarReturnType = new ParameterizedTypeReference<BookingView>() {};
        return cancelBookingRequestCreation(bookingIdentifier, cancellationDetail, winkVersion).toEntity(localVarReturnType);
    }
    /**
     * Cancel Group Booking
     * Cancel a group booking by its group identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param groupIdentifier Cancel booking by group identifier
     * @param cancellationDetail The cancellationDetail parameter
     * @param winkVersion The winkVersion parameter
     * @return List&lt;BookingView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec cancelGroupBookingRequestCreation(String groupIdentifier, CancellationDetail cancellationDetail, String winkVersion) throws WebClientResponseException {
        Object postBody = cancellationDetail;
        // verify the required parameter 'groupIdentifier' is set
        if (groupIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'groupIdentifier' when calling cancelGroupBooking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'cancellationDetail' is set
        if (cancellationDetail == null) {
            throw new WebClientResponseException("Missing the required parameter 'cancellationDetail' when calling cancelGroupBooking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("groupIdentifier", groupIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BookingView> localVarReturnType = new ParameterizedTypeReference<BookingView>() {};
        return apiClient.invokeAPI("/api/booking/group/{groupIdentifier}", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Cancel Group Booking
     * Cancel a group booking by its group identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param groupIdentifier Cancel booking by group identifier
     * @param cancellationDetail The cancellationDetail parameter
     * @param winkVersion The winkVersion parameter
     * @return List&lt;BookingView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<BookingView> cancelGroupBooking(String groupIdentifier, CancellationDetail cancellationDetail, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingView> localVarReturnType = new ParameterizedTypeReference<BookingView>() {};
        return cancelGroupBookingRequestCreation(groupIdentifier, cancellationDetail, winkVersion).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<BookingView>>> cancelGroupBookingWithHttpInfo(String groupIdentifier, CancellationDetail cancellationDetail, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingView> localVarReturnType = new ParameterizedTypeReference<BookingView>() {};
        return cancelGroupBookingRequestCreation(groupIdentifier, cancellationDetail, winkVersion).toEntityList(localVarReturnType);
    }
    /**
     * Create Agent Booking
     * Create agent booking. Expects the agent to be a registered agent with TripPay and have available funds to cover the booking amount.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param createAgentBookingRequest The createAgentBookingRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return BookingConfirmations
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createAgentBookingRequestCreation(CreateAgentBookingRequest createAgentBookingRequest, String winkVersion) throws WebClientResponseException {
        Object postBody = createAgentBookingRequest;
        // verify the required parameter 'createAgentBookingRequest' is set
        if (createAgentBookingRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'createAgentBookingRequest' when calling createAgentBooking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BookingConfirmations> localVarReturnType = new ParameterizedTypeReference<BookingConfirmations>() {};
        return apiClient.invokeAPI("/api/booking/agent", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Agent Booking
     * Create agent booking. Expects the agent to be a registered agent with TripPay and have available funds to cover the booking amount.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param createAgentBookingRequest The createAgentBookingRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return BookingConfirmations
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BookingConfirmations> createAgentBooking(CreateAgentBookingRequest createAgentBookingRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingConfirmations> localVarReturnType = new ParameterizedTypeReference<BookingConfirmations>() {};
        return createAgentBookingRequestCreation(createAgentBookingRequest, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<BookingConfirmations>> createAgentBookingWithHttpInfo(CreateAgentBookingRequest createAgentBookingRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingConfirmations> localVarReturnType = new ParameterizedTypeReference<BookingConfirmations>() {};
        return createAgentBookingRequestCreation(createAgentBookingRequest, winkVersion).toEntity(localVarReturnType);
    }
    /**
     * Create Merchant Booking
     * Create a merchant booking. Expects a TripPay contract to be available and a authenticated traveler user to be making the booking.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param createMerchantBookingRequest The createMerchantBookingRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return BookingConfirmations
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createMerchantBookingRequestCreation(CreateMerchantBookingRequest createMerchantBookingRequest, String winkVersion) throws WebClientResponseException {
        Object postBody = createMerchantBookingRequest;
        // verify the required parameter 'createMerchantBookingRequest' is set
        if (createMerchantBookingRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'createMerchantBookingRequest' when calling createMerchantBooking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BookingConfirmations> localVarReturnType = new ParameterizedTypeReference<BookingConfirmations>() {};
        return apiClient.invokeAPI("/api/booking/merchant", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Merchant Booking
     * Create a merchant booking. Expects a TripPay contract to be available and a authenticated traveler user to be making the booking.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param createMerchantBookingRequest The createMerchantBookingRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return BookingConfirmations
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BookingConfirmations> createMerchantBooking(CreateMerchantBookingRequest createMerchantBookingRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingConfirmations> localVarReturnType = new ParameterizedTypeReference<BookingConfirmations>() {};
        return createMerchantBookingRequestCreation(createMerchantBookingRequest, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<BookingConfirmations>> createMerchantBookingWithHttpInfo(CreateMerchantBookingRequest createMerchantBookingRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingConfirmations> localVarReturnType = new ParameterizedTypeReference<BookingConfirmations>() {};
        return createMerchantBookingRequestCreation(createMerchantBookingRequest, winkVersion).toEntity(localVarReturnType);
    }
    /**
     * Resend Booking Confirmation
     * Resends booking confirmation email to traveler.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param bookingIdentifier Retrieve booking by identifier
     * @param winkVersion The winkVersion parameter
     * @return BooleanResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec resendBookingConfirmationEmailRequestCreation(String bookingIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'bookingIdentifier' is set
        if (bookingIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingIdentifier' when calling resendBookingConfirmationEmail", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("bookingIdentifier", bookingIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BooleanResponse> localVarReturnType = new ParameterizedTypeReference<BooleanResponse>() {};
        return apiClient.invokeAPI("/api/booking/{bookingIdentifier}/resend", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Resend Booking Confirmation
     * Resends booking confirmation email to traveler.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param bookingIdentifier Retrieve booking by identifier
     * @param winkVersion The winkVersion parameter
     * @return BooleanResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BooleanResponse> resendBookingConfirmationEmail(String bookingIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BooleanResponse> localVarReturnType = new ParameterizedTypeReference<BooleanResponse>() {};
        return resendBookingConfirmationEmailRequestCreation(bookingIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<BooleanResponse>> resendBookingConfirmationEmailWithHttpInfo(String bookingIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BooleanResponse> localVarReturnType = new ParameterizedTypeReference<BooleanResponse>() {};
        return resendBookingConfirmationEmailRequestCreation(bookingIdentifier, winkVersion).toEntity(localVarReturnType);
    }
    /**
     * Show Booking
     * Retrieve a booking by its booking identifier. User needs to be authenticated.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param bookingIdentifier Retrieve booking by identifier
     * @param winkVersion The winkVersion parameter
     * @return BookingView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showBookingRequestCreation(String bookingIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'bookingIdentifier' is set
        if (bookingIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingIdentifier' when calling showBooking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("bookingIdentifier", bookingIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BookingView> localVarReturnType = new ParameterizedTypeReference<BookingView>() {};
        return apiClient.invokeAPI("/api/booking/{bookingIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Booking
     * Retrieve a booking by its booking identifier. User needs to be authenticated.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param bookingIdentifier Retrieve booking by identifier
     * @param winkVersion The winkVersion parameter
     * @return BookingView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BookingView> showBooking(String bookingIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingView> localVarReturnType = new ParameterizedTypeReference<BookingView>() {};
        return showBookingRequestCreation(bookingIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<BookingView>> showBookingWithHttpInfo(String bookingIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingView> localVarReturnType = new ParameterizedTypeReference<BookingView>() {};
        return showBookingRequestCreation(bookingIdentifier, winkVersion).toEntity(localVarReturnType);
    }
    /**
     * Show Booking Grid
     * Retrieve paginated bookings based on a query state
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param state The state parameter
     * @param winkVersion The winkVersion parameter
     * @return PageBookingView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showBookingGridRequestCreation(State state, String winkVersion) throws WebClientResponseException {
        Object postBody = state;
        // verify the required parameter 'state' is set
        if (state == null) {
            throw new WebClientResponseException("Missing the required parameter 'state' when calling showBookingGrid", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<PageBookingView> localVarReturnType = new ParameterizedTypeReference<PageBookingView>() {};
        return apiClient.invokeAPI("/api/booking/grid", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Booking Grid
     * Retrieve paginated bookings based on a query state
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param state The state parameter
     * @param winkVersion The winkVersion parameter
     * @return PageBookingView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PageBookingView> showBookingGrid(State state, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageBookingView> localVarReturnType = new ParameterizedTypeReference<PageBookingView>() {};
        return showBookingGridRequestCreation(state, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<PageBookingView>> showBookingGridWithHttpInfo(State state, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageBookingView> localVarReturnType = new ParameterizedTypeReference<PageBookingView>() {};
        return showBookingGridRequestCreation(state, winkVersion).toEntity(localVarReturnType);
    }
    /**
     * Show Booking List
     * Retrieve bookings in a paginated list
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param page Page to start retrieving records for
     * @param size Number of records to retrieve
     * @param winkVersion The winkVersion parameter
     * @return PageBookingView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showBookingsRequestCreation(Integer page, Integer size, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "page", page));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "size", size));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<PageBookingView> localVarReturnType = new ParameterizedTypeReference<PageBookingView>() {};
        return apiClient.invokeAPI("/api/booking/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Booking List
     * Retrieve bookings in a paginated list
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param page Page to start retrieving records for
     * @param size Number of records to retrieve
     * @param winkVersion The winkVersion parameter
     * @return PageBookingView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PageBookingView> showBookings(Integer page, Integer size, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageBookingView> localVarReturnType = new ParameterizedTypeReference<PageBookingView>() {};
        return showBookingsRequestCreation(page, size, winkVersion).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<PageBookingView>> showBookingsWithHttpInfo(Integer page, Integer size, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageBookingView> localVarReturnType = new ParameterizedTypeReference<PageBookingView>() {};
        return showBookingsRequestCreation(page, size, winkVersion).toEntity(localVarReturnType);
    }
    /**
     * Show Bookings by Review
     * List bookings by their review state
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param state Retrieve bookings by review state
     * @param winkVersion The winkVersion parameter
     * @return List&lt;BookingView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showBookingsByReviewStateRequestCreation(String state, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "state", state));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BookingView> localVarReturnType = new ParameterizedTypeReference<BookingView>() {};
        return apiClient.invokeAPI("/api/booking/review/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Bookings by Review
     * List bookings by their review state
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param state Retrieve bookings by review state
     * @param winkVersion The winkVersion parameter
     * @return List&lt;BookingView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<BookingView> showBookingsByReviewState(String state, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingView> localVarReturnType = new ParameterizedTypeReference<BookingView>() {};
        return showBookingsByReviewStateRequestCreation(state, winkVersion).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<BookingView>>> showBookingsByReviewStateWithHttpInfo(String state, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingView> localVarReturnType = new ParameterizedTypeReference<BookingView>() {};
        return showBookingsByReviewStateRequestCreation(state, winkVersion).toEntityList(localVarReturnType);
    }
    /**
     * Show Bookings by Time
     * Retrieve bookings for a date state
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param state Retrieve bookings by state
     * @param winkVersion The winkVersion parameter
     * @return List&lt;BookingView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showBookingsByStateRequestCreation(String state, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "state", state));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BookingView> localVarReturnType = new ParameterizedTypeReference<BookingView>() {};
        return apiClient.invokeAPI("/api/booking/state", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Bookings by Time
     * Retrieve bookings for a date state
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param state Retrieve bookings by state
     * @param winkVersion The winkVersion parameter
     * @return List&lt;BookingView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<BookingView> showBookingsByState(String state, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingView> localVarReturnType = new ParameterizedTypeReference<BookingView>() {};
        return showBookingsByStateRequestCreation(state, winkVersion).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<BookingView>>> showBookingsByStateWithHttpInfo(String state, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingView> localVarReturnType = new ParameterizedTypeReference<BookingView>() {};
        return showBookingsByStateRequestCreation(state, winkVersion).toEntityList(localVarReturnType);
    }
    /**
     * Show Grouped Bookings
     * Retrieve a list of bookings by group identifier. User needs to be authenticated.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param groupIdentifier Retrieve booking by identifier
     * @param winkVersion The winkVersion parameter
     * @return List&lt;BookingView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showGroupedBookingsRequestCreation(String groupIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'groupIdentifier' is set
        if (groupIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'groupIdentifier' when calling showGroupedBookings", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("groupIdentifier", groupIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BookingView> localVarReturnType = new ParameterizedTypeReference<BookingView>() {};
        return apiClient.invokeAPI("/api/booking/group/{groupIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Grouped Bookings
     * Retrieve a list of bookings by group identifier. User needs to be authenticated.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param groupIdentifier Retrieve booking by identifier
     * @param winkVersion The winkVersion parameter
     * @return List&lt;BookingView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<BookingView> showGroupedBookings(String groupIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingView> localVarReturnType = new ParameterizedTypeReference<BookingView>() {};
        return showGroupedBookingsRequestCreation(groupIdentifier, winkVersion).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<BookingView>>> showGroupedBookingsWithHttpInfo(String groupIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingView> localVarReturnType = new ParameterizedTypeReference<BookingView>() {};
        return showGroupedBookingsRequestCreation(groupIdentifier, winkVersion).toEntityList(localVarReturnType);
    }
}
