/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release   # Booking API Welcome to the Booking Engine API - A programmer-friendly way to book inventory that was found on our platform. We take great care in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive payment-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 23.1.1
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.booking.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.booking.model.BookingUserSpecifiedCurrencyTotal;
import travel.wink.sdk.booking.model.SimpleDescription;
import travel.wink.sdk.booking.model.SimpleMultimedia;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * This is one bookable unit that can stand alongside a restaurant / meeting room etc.
 */
@ApiModel(description = "This is one bookable unit that can stand alongside a restaurant / meeting room etc.")
@JsonPropertyOrder({
  TransactionalTravelInventory.JSON_PROPERTY_IDENTIFIER,
  TransactionalTravelInventory.JSON_PROPERTY_NAME,
  TransactionalTravelInventory.JSON_PROPERTY_DESCRIPTIONS,
  TransactionalTravelInventory.JSON_PROPERTY_PRICING_TYPE,
  TransactionalTravelInventory.JSON_PROPERTY_BASE_PRICE,
  TransactionalTravelInventory.JSON_PROPERTY_DISCOUNTED_PRICE,
  TransactionalTravelInventory.JSON_PROPERTY_MULTIMEDIAS,
  TransactionalTravelInventory.JSON_PROPERTY_MIN_PAX,
  TransactionalTravelInventory.JSON_PROPERTY_MAX_PAX
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-11-08T09:35:53.801098523+07:00[Asia/Bangkok]")
public class TransactionalTravelInventory {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private UUID identifier;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_DESCRIPTIONS = "descriptions";
  private List<SimpleDescription> descriptions = new ArrayList<>();

  /**
   * How this inventory item should be priced.
   */
  public enum PricingTypeEnum {
    PERSON_PER_USE("PER_PERSON_PER_USE"),
    
    USE("PER_USE"),
    
    PERSON_PER_HOUR("PER_PERSON_PER_HOUR"),
    
    HOUR("PER_HOUR");

    private String value;

    PricingTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PricingTypeEnum fromValue(String value) {
      for (PricingTypeEnum b : PricingTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PRICING_TYPE = "pricingType";
  private PricingTypeEnum pricingType;

  public static final String JSON_PROPERTY_BASE_PRICE = "basePrice";
  private BookingUserSpecifiedCurrencyTotal basePrice;

  public static final String JSON_PROPERTY_DISCOUNTED_PRICE = "discountedPrice";
  private BookingUserSpecifiedCurrencyTotal discountedPrice;

  public static final String JSON_PROPERTY_MULTIMEDIAS = "multimedias";
  private List<SimpleMultimedia> multimedias = new ArrayList<>();

  public static final String JSON_PROPERTY_MIN_PAX = "minPax";
  private Integer minPax;

  public static final String JSON_PROPERTY_MAX_PAX = "maxPax";
  private Integer maxPax;

  public TransactionalTravelInventory() { 
  }

  public TransactionalTravelInventory identifier(UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique transactional identifier
   * @return identifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "Unique transactional identifier")
  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifier(UUID identifier) {
    this.identifier = identifier;
  }


  public TransactionalTravelInventory name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Internal name of transactional inventory.
   * @return name
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "1 hour session", required = true, value = "Internal name of transactional inventory.")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public TransactionalTravelInventory descriptions(List<SimpleDescription> descriptions) {
    
    this.descriptions = descriptions;
    return this;
  }

  public TransactionalTravelInventory addDescriptionsItem(SimpleDescription descriptionsItem) {
    this.descriptions.add(descriptionsItem);
    return this;
  }

   /**
   * Localized descriptions describing inventory.
   * @return descriptions
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
 @Size(min=1,max=2147483647)  @ApiModelProperty(required = true, value = "Localized descriptions describing inventory.")
  @JsonProperty(JSON_PROPERTY_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<SimpleDescription> getDescriptions() {
    return descriptions;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDescriptions(List<SimpleDescription> descriptions) {
    this.descriptions = descriptions;
  }


  public TransactionalTravelInventory pricingType(PricingTypeEnum pricingType) {
    
    this.pricingType = pricingType;
    return this;
  }

   /**
   * How this inventory item should be priced.
   * @return pricingType
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(required = true, value = "How this inventory item should be priced.")
  @JsonProperty(JSON_PROPERTY_PRICING_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public PricingTypeEnum getPricingType() {
    return pricingType;
  }


  @JsonProperty(JSON_PROPERTY_PRICING_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPricingType(PricingTypeEnum pricingType) {
    this.pricingType = pricingType;
  }


  public TransactionalTravelInventory basePrice(BookingUserSpecifiedCurrencyTotal basePrice) {
    
    this.basePrice = basePrice;
    return this;
  }

   /**
   * Get basePrice
   * @return basePrice
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_BASE_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BookingUserSpecifiedCurrencyTotal getBasePrice() {
    return basePrice;
  }


  @JsonProperty(JSON_PROPERTY_BASE_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBasePrice(BookingUserSpecifiedCurrencyTotal basePrice) {
    this.basePrice = basePrice;
  }


  public TransactionalTravelInventory discountedPrice(BookingUserSpecifiedCurrencyTotal discountedPrice) {
    
    this.discountedPrice = discountedPrice;
    return this;
  }

   /**
   * Get discountedPrice
   * @return discountedPrice
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_DISCOUNTED_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BookingUserSpecifiedCurrencyTotal getDiscountedPrice() {
    return discountedPrice;
  }


  @JsonProperty(JSON_PROPERTY_DISCOUNTED_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDiscountedPrice(BookingUserSpecifiedCurrencyTotal discountedPrice) {
    this.discountedPrice = discountedPrice;
  }


  public TransactionalTravelInventory multimedias(List<SimpleMultimedia> multimedias) {
    
    this.multimedias = multimedias;
    return this;
  }

  public TransactionalTravelInventory addMultimediasItem(SimpleMultimedia multimediasItem) {
    this.multimedias.add(multimediasItem);
    return this;
  }

   /**
   * List of images / videos of item.
   * @return multimedias
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "List of images / videos of item.")
  @JsonProperty(JSON_PROPERTY_MULTIMEDIAS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<SimpleMultimedia> getMultimedias() {
    return multimedias;
  }


  @JsonProperty(JSON_PROPERTY_MULTIMEDIAS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMultimedias(List<SimpleMultimedia> multimedias) {
    this.multimedias = multimedias;
  }


  public TransactionalTravelInventory minPax(Integer minPax) {
    
    this.minPax = minPax;
    return this;
  }

   /**
   * Whether there is a limit to minimum group size.
   * @return minPax
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "2", value = "Whether there is a limit to minimum group size.")
  @JsonProperty(JSON_PROPERTY_MIN_PAX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMinPax() {
    return minPax;
  }


  @JsonProperty(JSON_PROPERTY_MIN_PAX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinPax(Integer minPax) {
    this.minPax = minPax;
  }


  public TransactionalTravelInventory maxPax(Integer maxPax) {
    
    this.maxPax = maxPax;
    return this;
  }

   /**
   * Whether there is a limit to maximum group size.
   * @return maxPax
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "10", value = "Whether there is a limit to maximum group size.")
  @JsonProperty(JSON_PROPERTY_MAX_PAX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMaxPax() {
    return maxPax;
  }


  @JsonProperty(JSON_PROPERTY_MAX_PAX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxPax(Integer maxPax) {
    this.maxPax = maxPax;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TransactionalTravelInventory transactionalTravelInventory = (TransactionalTravelInventory) o;
    return Objects.equals(this.identifier, transactionalTravelInventory.identifier) &&
        Objects.equals(this.name, transactionalTravelInventory.name) &&
        Objects.equals(this.descriptions, transactionalTravelInventory.descriptions) &&
        Objects.equals(this.pricingType, transactionalTravelInventory.pricingType) &&
        Objects.equals(this.basePrice, transactionalTravelInventory.basePrice) &&
        Objects.equals(this.discountedPrice, transactionalTravelInventory.discountedPrice) &&
        Objects.equals(this.multimedias, transactionalTravelInventory.multimedias) &&
        Objects.equals(this.minPax, transactionalTravelInventory.minPax) &&
        Objects.equals(this.maxPax, transactionalTravelInventory.maxPax);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, name, descriptions, pricingType, basePrice, discountedPrice, multimedias, minPax, maxPax);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TransactionalTravelInventory {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    descriptions: ").append(toIndentedString(descriptions)).append("\n");
    sb.append("    pricingType: ").append(toIndentedString(pricingType)).append("\n");
    sb.append("    basePrice: ").append(toIndentedString(basePrice)).append("\n");
    sb.append("    discountedPrice: ").append(toIndentedString(discountedPrice)).append("\n");
    sb.append("    multimedias: ").append(toIndentedString(multimedias)).append("\n");
    sb.append("    minPax: ").append(toIndentedString(minPax)).append("\n");
    sb.append("    maxPax: ").append(toIndentedString(maxPax)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

