/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.booking.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.validation.Valid;
import travel.wink.sdk.booking.model.Address;
import travel.wink.sdk.booking.model.Contact;
import travel.wink.sdk.booking.model.LocalizedPrice;

@ApiModel(description="Place reservation records.")
@JsonPropertyOrder(value={"hotelIdentifier", "typeIdentifier", "name", "pricingType", "type", "price", "startDate", "endDate", "allDay", "attendees", "imageIdentifier", "imageUrl", "localizedName", "localizedDescription", "contact", "address"})
public class ExtraBookingRequest {
    public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
    private UUID hotelIdentifier;
    public static final String JSON_PROPERTY_TYPE_IDENTIFIER = "typeIdentifier";
    private UUID typeIdentifier;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_PRICING_TYPE = "pricingType";
    private PricingTypeEnum pricingType;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_PRICE = "price";
    private LocalizedPrice price;
    public static final String JSON_PROPERTY_START_DATE = "startDate";
    private LocalDateTime startDate;
    public static final String JSON_PROPERTY_END_DATE = "endDate";
    private LocalDateTime endDate;
    public static final String JSON_PROPERTY_ALL_DAY = "allDay";
    private Boolean allDay = false;
    public static final String JSON_PROPERTY_ATTENDEES = "attendees";
    private Integer attendees = 1;
    public static final String JSON_PROPERTY_IMAGE_IDENTIFIER = "imageIdentifier";
    private String imageIdentifier;
    public static final String JSON_PROPERTY_IMAGE_URL = "imageUrl";
    private String imageUrl;
    public static final String JSON_PROPERTY_LOCALIZED_NAME = "localizedName";
    private String localizedName;
    public static final String JSON_PROPERTY_LOCALIZED_DESCRIPTION = "localizedDescription";
    private String localizedDescription;
    public static final String JSON_PROPERTY_CONTACT = "contact";
    private Contact contact;
    public static final String JSON_PROPERTY_ADDRESS = "address";
    private Address address;

    public ExtraBookingRequest hotelIdentifier(UUID hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Hotel identifier")
    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getHotelIdentifier() {
        return this.hotelIdentifier;
    }

    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHotelIdentifier(UUID hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
    }

    public ExtraBookingRequest typeIdentifier(UUID typeIdentifier) {
        this.typeIdentifier = typeIdentifier;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Travel inventory identifier")
    @JsonProperty(value="typeIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getTypeIdentifier() {
        return this.typeIdentifier;
    }

    @JsonProperty(value="typeIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTypeIdentifier(UUID typeIdentifier) {
        this.typeIdentifier = typeIdentifier;
    }

    public ExtraBookingRequest name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Place 1", value="Name of inventory")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public ExtraBookingRequest pricingType(PricingTypeEnum pricingType) {
        this.pricingType = pricingType;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="PER_USE", value="Pricing type")
    @JsonProperty(value="pricingType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PricingTypeEnum getPricingType() {
        return this.pricingType;
    }

    @JsonProperty(value="pricingType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPricingType(PricingTypeEnum pricingType) {
        this.pricingType = pricingType;
    }

    public ExtraBookingRequest type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="PLACE", value="Inventory type")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public ExtraBookingRequest price(LocalizedPrice price) {
        this.price = price;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="price")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalizedPrice getPrice() {
        return this.price;
    }

    @JsonProperty(value="price")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPrice(LocalizedPrice price) {
        this.price = price;
    }

    public ExtraBookingRequest startDate(LocalDateTime startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Date start time when reservation was made for.")
    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDateTime getStartDate() {
        return this.startDate;
    }

    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStartDate(LocalDateTime startDate) {
        this.startDate = startDate;
    }

    public ExtraBookingRequest endDate(LocalDateTime endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Date end time when reservation was made for.")
    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDateTime getEndDate() {
        return this.endDate;
    }

    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEndDate(LocalDateTime endDate) {
        this.endDate = endDate;
    }

    public ExtraBookingRequest allDay(Boolean allDay) {
        this.allDay = allDay;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Indicates if this reservation is for the whole day.")
    @JsonProperty(value="allDay")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAllDay() {
        return this.allDay;
    }

    @JsonProperty(value="allDay")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAllDay(Boolean allDay) {
        this.allDay = allDay;
    }

    public ExtraBookingRequest attendees(Integer attendees) {
        this.attendees = attendees;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2", value="Number of guests that are part of this reservation.")
    @JsonProperty(value="attendees")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getAttendees() {
        return this.attendees;
    }

    @JsonProperty(value="attendees")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAttendees(Integer attendees) {
        this.attendees = attendees;
    }

    public ExtraBookingRequest imageIdentifier(String imageIdentifier) {
        this.imageIdentifier = imageIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="cloudinary-image-1", value="Cloudinary image identifier")
    @JsonProperty(value="imageIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getImageIdentifier() {
        return this.imageIdentifier;
    }

    @JsonProperty(value="imageIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setImageIdentifier(String imageIdentifier) {
        this.imageIdentifier = imageIdentifier;
    }

    public ExtraBookingRequest imageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://path.to.image.com/this-is-me.jpg", value="Absolute URL to image of inventory")
    @JsonProperty(value="imageUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getImageUrl() {
        return this.imageUrl;
    }

    @JsonProperty(value="imageUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public ExtraBookingRequest localizedName(String localizedName) {
        this.localizedName = localizedName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Plass 1", value="Name of travel inventory in traveler language (if available). Defaults to English.")
    @JsonProperty(value="localizedName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLocalizedName() {
        return this.localizedName;
    }

    @JsonProperty(value="localizedName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLocalizedName(String localizedName) {
        this.localizedName = localizedName;
    }

    public ExtraBookingRequest localizedDescription(String localizedDescription) {
        this.localizedDescription = localizedDescription;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="place-1", value="Description of travel inventory in traveler language (if available). Defaults to English.")
    @JsonProperty(value="localizedDescription")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLocalizedDescription() {
        return this.localizedDescription;
    }

    @JsonProperty(value="localizedDescription")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLocalizedDescription(String localizedDescription) {
        this.localizedDescription = localizedDescription;
    }

    public ExtraBookingRequest contact(Contact contact) {
        this.contact = contact;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="contact")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Contact getContact() {
        return this.contact;
    }

    @JsonProperty(value="contact")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContact(Contact contact) {
        this.contact = contact;
    }

    public ExtraBookingRequest address(Address address) {
        this.address = address;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Address getAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAddress(Address address) {
        this.address = address;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtraBookingRequest extraBookingRequest = (ExtraBookingRequest)o;
        return Objects.equals(this.hotelIdentifier, extraBookingRequest.hotelIdentifier) && Objects.equals(this.typeIdentifier, extraBookingRequest.typeIdentifier) && Objects.equals(this.name, extraBookingRequest.name) && Objects.equals((Object)this.pricingType, (Object)extraBookingRequest.pricingType) && Objects.equals((Object)this.type, (Object)extraBookingRequest.type) && Objects.equals(this.price, extraBookingRequest.price) && Objects.equals(this.startDate, extraBookingRequest.startDate) && Objects.equals(this.endDate, extraBookingRequest.endDate) && Objects.equals(this.allDay, extraBookingRequest.allDay) && Objects.equals(this.attendees, extraBookingRequest.attendees) && Objects.equals(this.imageIdentifier, extraBookingRequest.imageIdentifier) && Objects.equals(this.imageUrl, extraBookingRequest.imageUrl) && Objects.equals(this.localizedName, extraBookingRequest.localizedName) && Objects.equals(this.localizedDescription, extraBookingRequest.localizedDescription) && Objects.equals(this.contact, extraBookingRequest.contact) && Objects.equals(this.address, extraBookingRequest.address);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.hotelIdentifier, this.typeIdentifier, this.name, this.pricingType, this.type, this.price, this.startDate, this.endDate, this.allDay, this.attendees, this.imageIdentifier, this.imageUrl, this.localizedName, this.localizedDescription, this.contact, this.address});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExtraBookingRequest {\n");
        sb.append("    hotelIdentifier: ").append(this.toIndentedString(this.hotelIdentifier)).append("\n");
        sb.append("    typeIdentifier: ").append(this.toIndentedString(this.typeIdentifier)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    pricingType: ").append(this.toIndentedString((Object)this.pricingType)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    price: ").append(this.toIndentedString(this.price)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    allDay: ").append(this.toIndentedString(this.allDay)).append("\n");
        sb.append("    attendees: ").append(this.toIndentedString(this.attendees)).append("\n");
        sb.append("    imageIdentifier: ").append(this.toIndentedString(this.imageIdentifier)).append("\n");
        sb.append("    imageUrl: ").append(this.toIndentedString(this.imageUrl)).append("\n");
        sb.append("    localizedName: ").append(this.toIndentedString(this.localizedName)).append("\n");
        sb.append("    localizedDescription: ").append(this.toIndentedString(this.localizedDescription)).append("\n");
        sb.append("    contact: ").append(this.toIndentedString(this.contact)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PricingTypeEnum {
        PERSON_PER_USE("PER_PERSON_PER_USE"),
        USE("PER_USE"),
        PERSON_PER_HOUR("PER_PERSON_PER_HOUR"),
        HOUR("PER_HOUR");

        private String value;

        private PricingTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PricingTypeEnum fromValue(String value) {
            for (PricingTypeEnum b : PricingTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        MEETING_ROOM("MEETING_ROOM"),
        SPA("SPA"),
        RESTAURANT("RESTAURANT"),
        ACTIVITY("ACTIVITY"),
        ATTRACTION("ATTRACTION"),
        PLACE("PLACE");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

