/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release   # Booking API Welcome to the Booking Engine API - A programmer-friendly way to book inventory that was found on our platform. We take great care in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive payment-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 24.0.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.booking.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Payment details the merchant provided us at the time of payment.
 */
@ApiModel(description = "Payment details the merchant provided us at the time of payment.")
@JsonPropertyOrder({
  BookingContractPaymentDetailsBooker.JSON_PROPERTY_VENDOR,
  BookingContractPaymentDetailsBooker.JSON_PROPERTY_TYPE,
  BookingContractPaymentDetailsBooker.JSON_PROPERTY_TRANSACTION_IDENTIFIER,
  BookingContractPaymentDetailsBooker.JSON_PROPERTY_AGENT_INVOICED_DATE,
  BookingContractPaymentDetailsBooker.JSON_PROPERTY_AGENT_INVOICE_IDENTIFIER,
  BookingContractPaymentDetailsBooker.JSON_PROPERTY_VENDOR_SPECIFIC
})
@JsonTypeName("BookingContractPaymentDetails_Booker")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-03-06T16:57:07.874773188+07:00[Asia/Bangkok]")
public class BookingContractPaymentDetailsBooker {
  /**
   * Name of acquiring vendor
   */
  public enum VendorEnum {
    STRIPE("STRIPE"),
    
    YAPILY("YAPILY"),
    
    PAY_PAL("PAY_PAL"),
    
    NMI("NMI"),
    
    AGENT("AGENT");

    private String value;

    VendorEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static VendorEnum fromValue(String value) {
      for (VendorEnum b : VendorEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_VENDOR = "vendor";
  private VendorEnum vendor;

  /**
   * Technology taking the charge
   */
  public enum TypeEnum {
    CREDIT_CARD("CREDIT_CARD"),
    
    BANK_TRANSFER("BANK_TRANSFER"),
    
    PAY_PAL("PAY_PAL"),
    
    CRYPTO("CRYPTO"),
    
    AGENT("AGENT"),
    
    CASH("CASH");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_TRANSACTION_IDENTIFIER = "transactionIdentifier";
  private String transactionIdentifier;

  public static final String JSON_PROPERTY_AGENT_INVOICED_DATE = "agentInvoicedDate";
  private java.time.LocalDateTime agentInvoicedDate;

  public static final String JSON_PROPERTY_AGENT_INVOICE_IDENTIFIER = "agentInvoiceIdentifier";
  private String agentInvoiceIdentifier;

  public static final String JSON_PROPERTY_VENDOR_SPECIFIC = "vendorSpecific";
  private Map<String, String> vendorSpecific = new HashMap<>();

  public BookingContractPaymentDetailsBooker() { 
  }

  public BookingContractPaymentDetailsBooker vendor(VendorEnum vendor) {
    
    this.vendor = vendor;
    return this;
  }

   /**
   * Name of acquiring vendor
   * @return vendor
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "STRIPE", required = true, value = "Name of acquiring vendor")
  @JsonProperty(JSON_PROPERTY_VENDOR)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public VendorEnum getVendor() {
    return vendor;
  }


  @JsonProperty(JSON_PROPERTY_VENDOR)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setVendor(VendorEnum vendor) {
    this.vendor = vendor;
  }


  public BookingContractPaymentDetailsBooker type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * Technology taking the charge
   * @return type
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "CREDIT_CARD", required = true, value = "Technology taking the charge")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public BookingContractPaymentDetailsBooker transactionIdentifier(String transactionIdentifier) {
    
    this.transactionIdentifier = transactionIdentifier;
    return this;
  }

   /**
   * Unique transaction id from the vendor upon a successful sale. Agent adds their transaction identifier.
   * @return transactionIdentifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "tx-1", required = true, value = "Unique transaction id from the vendor upon a successful sale. Agent adds their transaction identifier.")
  @JsonProperty(JSON_PROPERTY_TRANSACTION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getTransactionIdentifier() {
    return transactionIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_TRANSACTION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTransactionIdentifier(String transactionIdentifier) {
    this.transactionIdentifier = transactionIdentifier;
  }


  public BookingContractPaymentDetailsBooker agentInvoicedDate(java.time.LocalDateTime agentInvoicedDate) {
    
    this.agentInvoicedDate = agentInvoicedDate;
    return this;
  }

   /**
   * The date/time the invoice was generated
   * @return agentInvoicedDate
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "The date/time the invoice was generated")
  @JsonProperty(JSON_PROPERTY_AGENT_INVOICED_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getAgentInvoicedDate() {
    return agentInvoicedDate;
  }


  @JsonProperty(JSON_PROPERTY_AGENT_INVOICED_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAgentInvoicedDate(java.time.LocalDateTime agentInvoicedDate) {
    this.agentInvoicedDate = agentInvoicedDate;
  }


  public BookingContractPaymentDetailsBooker agentInvoiceIdentifier(String agentInvoiceIdentifier) {
    
    this.agentInvoiceIdentifier = agentInvoiceIdentifier;
    return this;
  }

   /**
   * The specific invoice this booking was registered on
   * @return agentInvoiceIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "invoice-1", value = "The specific invoice this booking was registered on")
  @JsonProperty(JSON_PROPERTY_AGENT_INVOICE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAgentInvoiceIdentifier() {
    return agentInvoiceIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_AGENT_INVOICE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAgentInvoiceIdentifier(String agentInvoiceIdentifier) {
    this.agentInvoiceIdentifier = agentInvoiceIdentifier;
  }


  public BookingContractPaymentDetailsBooker vendorSpecific(Map<String, String> vendorSpecific) {
    
    this.vendorSpecific = vendorSpecific;
    return this;
  }

  public BookingContractPaymentDetailsBooker putVendorSpecificItem(String key, String vendorSpecificItem) {
    this.vendorSpecific.put(key, vendorSpecificItem);
    return this;
  }

   /**
   * Vendor specific values that are returned in a successful response
   * @return vendorSpecific
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(required = true, value = "Vendor specific values that are returned in a successful response")
  @JsonProperty(JSON_PROPERTY_VENDOR_SPECIFIC)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Map<String, String> getVendorSpecific() {
    return vendorSpecific;
  }


  @JsonProperty(JSON_PROPERTY_VENDOR_SPECIFIC)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setVendorSpecific(Map<String, String> vendorSpecific) {
    this.vendorSpecific = vendorSpecific;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BookingContractPaymentDetailsBooker bookingContractPaymentDetailsBooker = (BookingContractPaymentDetailsBooker) o;
    return Objects.equals(this.vendor, bookingContractPaymentDetailsBooker.vendor) &&
        Objects.equals(this.type, bookingContractPaymentDetailsBooker.type) &&
        Objects.equals(this.transactionIdentifier, bookingContractPaymentDetailsBooker.transactionIdentifier) &&
        Objects.equals(this.agentInvoicedDate, bookingContractPaymentDetailsBooker.agentInvoicedDate) &&
        Objects.equals(this.agentInvoiceIdentifier, bookingContractPaymentDetailsBooker.agentInvoiceIdentifier) &&
        Objects.equals(this.vendorSpecific, bookingContractPaymentDetailsBooker.vendorSpecific);
  }

  @Override
  public int hashCode() {
    return Objects.hash(vendor, type, transactionIdentifier, agentInvoicedDate, agentInvoiceIdentifier, vendorSpecific);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BookingContractPaymentDetailsBooker {\n");
    sb.append("    vendor: ").append(toIndentedString(vendor)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    transactionIdentifier: ").append(toIndentedString(transactionIdentifier)).append("\n");
    sb.append("    agentInvoicedDate: ").append(toIndentedString(agentInvoicedDate)).append("\n");
    sb.append("    agentInvoiceIdentifier: ").append(toIndentedString(agentInvoiceIdentifier)).append("\n");
    sb.append("    vendorSpecific: ").append(toIndentedString(vendorSpecific)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

