/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release   # Booking API Welcome to the Booking Engine API - A programmer-friendly way to book inventory that was found on our platform. We take great care in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive payment-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 24.0.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.booking.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.booking.model.AddressBooker;
import travel.wink.sdk.booking.model.BedroomConfigurationBooker;
import travel.wink.sdk.booking.model.ContactBooker;
import travel.wink.sdk.booking.model.GeoJsonPointBooker;
import travel.wink.sdk.booking.model.SimpleDescriptionBooker;
import travel.wink.sdk.booking.model.SimpleMultimediaBooker;
import travel.wink.sdk.booking.model.SocialBooker;
import travel.wink.sdk.booking.model.TravelInventoryRecognitionBooker;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Guest room details.
 */
@ApiModel(description = "Guest room details.")
@JsonPropertyOrder({
  GuestRoomBooker.JSON_PROPERTY_IDENTIFIER,
  GuestRoomBooker.JSON_PROPERTY_HOTEL_IDENTIFIER,
  GuestRoomBooker.JSON_PROPERTY_FEATURED_IND,
  GuestRoomBooker.JSON_PROPERTY_LIFESTYLE_TYPE,
  GuestRoomBooker.JSON_PROPERTY_LOCATION,
  GuestRoomBooker.JSON_PROPERTY_DESCRIPTIONS,
  GuestRoomBooker.JSON_PROPERTY_MULTIMEDIAS,
  GuestRoomBooker.JSON_PROPERTY_CONTACT,
  GuestRoomBooker.JSON_PROPERTY_ADDRESS,
  GuestRoomBooker.JSON_PROPERTY_COMMISSIONABLE,
  GuestRoomBooker.JSON_PROPERTY_NAME,
  GuestRoomBooker.JSON_PROPERTY_PROXIMITY_CODE,
  GuestRoomBooker.JSON_PROPERTY_SORT,
  GuestRoomBooker.JSON_PROPERTY_MIN_AGE_APPROPRIATE_CODE,
  GuestRoomBooker.JSON_PROPERTY_BOOKABLE,
  GuestRoomBooker.JSON_PROPERTY_ACTIVE,
  GuestRoomBooker.JSON_PROPERTY_DISABILITY_FEATURES,
  GuestRoomBooker.JSON_PROPERTY_SECURITY_FEATURES,
  GuestRoomBooker.JSON_PROPERTY_SOCIALS,
  GuestRoomBooker.JSON_PROPERTY_PRICE_POINT,
  GuestRoomBooker.JSON_PROPERTY_RECOGNITION_LIST,
  GuestRoomBooker.JSON_PROPERTY_MAX_OCCUPANCY,
  GuestRoomBooker.JSON_PROPERTY_MIN_OCCUPANCY,
  GuestRoomBooker.JSON_PROPERTY_QUANTITY,
  GuestRoomBooker.JSON_PROPERTY_NON_SMOKING,
  GuestRoomBooker.JSON_PROPERTY_BEDROOM_CONFIGURATION_LIST,
  GuestRoomBooker.JSON_PROPERTY_SIZE,
  GuestRoomBooker.JSON_PROPERTY_MAX_ADULT_OCCUPANCY,
  GuestRoomBooker.JSON_PROPERTY_MAX_CHILD_OCCUPANCY,
  GuestRoomBooker.JSON_PROPERTY_BATHROOM_COUNT,
  GuestRoomBooker.JSON_PROPERTY_LIVING_ROOM_COUNT,
  GuestRoomBooker.JSON_PROPERTY_MAX_ROLLAWAYS,
  GuestRoomBooker.JSON_PROPERTY_ROOM_CATEGORY,
  GuestRoomBooker.JSON_PROPERTY_FLOOR,
  GuestRoomBooker.JSON_PROPERTY_ROOM_LOCATION_CODE,
  GuestRoomBooker.JSON_PROPERTY_ROOM_VIEW_CODE,
  GuestRoomBooker.JSON_PROPERTY_COMPOSITE,
  GuestRoomBooker.JSON_PROPERTY_COMPOSITE_COUNT,
  GuestRoomBooker.JSON_PROPERTY_ROOM_CLASSIFICATION_CODE,
  GuestRoomBooker.JSON_PROPERTY_ROOM_ARCHITECTURE_CODE,
  GuestRoomBooker.JSON_PROPERTY_ROOM_GENDER,
  GuestRoomBooker.JSON_PROPERTY_SHARED_ROOM_IND,
  GuestRoomBooker.JSON_PROPERTY_MAX_CRIBS,
  GuestRoomBooker.JSON_PROPERTY_AMENITIES,
  GuestRoomBooker.JSON_PROPERTY_INCLUDED_ADULT_OCCUPANCY,
  GuestRoomBooker.JSON_PROPERTY_INCLUDED_CHILD_OCCUPANCY
})
@JsonTypeName("GuestRoom_Booker")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-03-06T16:57:07.874773188+07:00[Asia/Bangkok]")
public class GuestRoomBooker {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private UUID identifier;

  public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
  private UUID hotelIdentifier;

  public static final String JSON_PROPERTY_FEATURED_IND = "featuredInd";
  private Boolean featuredInd;

  /**
   * Indicate the type of lifestyle this inventory should be associated with.
   */
  public enum LifestyleTypeEnum {
    HEALTH_FITNESS("LIFESTYLE_HEALTH_FITNESS"),
    
    RELAX("LIFESTYLE_RELAX"),
    
    ADULT_ONLY("LIFESTYLE_ADULT_ONLY"),
    
    ADVENTURE("LIFESTYLE_ADVENTURE"),
    
    BUSINESS("LIFESTYLE_BUSINESS"),
    
    LGBT("LIFESTYLE_LGBT"),
    
    SINGLE_PARENT("LIFESTYLE_SINGLE_PARENT"),
    
    SOLO_FEMALE("LIFESTYLE_SOLO_FEMALE"),
    
    BEAUTY("LIFESTYLE_BEAUTY"),
    
    FOODIE("LIFESTYLE_FOODIE"),
    
    FAMILY("LIFESTYLE_FAMILY"),
    
    ROMANCE("LIFESTYLE_ROMANCE"),
    
    COUPLE("LIFESTYLE_COUPLE"),
    
    SOLO("LIFESTYLE_SOLO"),
    
    BACKPACKER("LIFESTYLE_BACKPACKER"),
    
    SHOPPING("LIFESTYLE_SHOPPING"),
    
    SPORTS("LIFESTYLE_SPORTS"),
    
    MOUNTAIN("LIFESTYLE_MOUNTAIN"),
    
    BEACH("LIFESTYLE_BEACH"),
    
    CITY("LIFESTYLE_CITY"),
    
    COUNTRY("LIFESTYLE_COUNTRY"),
    
    CULTURE("LIFESTYLE_CULTURE"),
    
    ECO("LIFESTYLE_ECO");

    private String value;

    LifestyleTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static LifestyleTypeEnum fromValue(String value) {
      for (LifestyleTypeEnum b : LifestyleTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_LIFESTYLE_TYPE = "lifestyleType";
  private LifestyleTypeEnum lifestyleType;

  public static final String JSON_PROPERTY_LOCATION = "location";
  private GeoJsonPointBooker location;

  public static final String JSON_PROPERTY_DESCRIPTIONS = "descriptions";
  private List<SimpleDescriptionBooker> descriptions = new ArrayList<>();

  public static final String JSON_PROPERTY_MULTIMEDIAS = "multimedias";
  private List<SimpleMultimediaBooker> multimedias = new ArrayList<>();

  public static final String JSON_PROPERTY_CONTACT = "contact";
  private ContactBooker contact;

  public static final String JSON_PROPERTY_ADDRESS = "address";
  private AddressBooker address;

  public static final String JSON_PROPERTY_COMMISSIONABLE = "commissionable";
  private Boolean commissionable = true;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_PROXIMITY_CODE = "proximityCode";
  private String proximityCode;

  public static final String JSON_PROPERTY_SORT = "sort";
  private Integer sort;

  public static final String JSON_PROPERTY_MIN_AGE_APPROPRIATE_CODE = "minAgeAppropriateCode";
  private String minAgeAppropriateCode;

  public static final String JSON_PROPERTY_BOOKABLE = "bookable";
  private Boolean bookable = true;

  public static final String JSON_PROPERTY_ACTIVE = "active";
  private Boolean active = true;

  public static final String JSON_PROPERTY_DISABILITY_FEATURES = "disabilityFeatures";
  private List<String> disabilityFeatures = null;

  public static final String JSON_PROPERTY_SECURITY_FEATURES = "securityFeatures";
  private List<String> securityFeatures = null;

  public static final String JSON_PROPERTY_SOCIALS = "socials";
  private List<SocialBooker> socials = null;

  /**
   * Level of expensiveness.
   */
  public enum PricePointEnum {
    HALF("HALF"),
    
    ONE("ONE"),
    
    ONE_HALF("ONE_HALF"),
    
    TWO("TWO"),
    
    TWO_HALF("TWO_HALF"),
    
    THREE("THREE"),
    
    THREE_HALF("THREE_HALF"),
    
    FOUR("FOUR"),
    
    FOUR_HALF("FOUR_HALF"),
    
    FIVE("FIVE");

    private String value;

    PricePointEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PricePointEnum fromValue(String value) {
      for (PricePointEnum b : PricePointEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PRICE_POINT = "pricePoint";
  private PricePointEnum pricePoint = PricePointEnum.THREE;

  public static final String JSON_PROPERTY_RECOGNITION_LIST = "recognitionList";
  private List<TravelInventoryRecognitionBooker> recognitionList = null;

  public static final String JSON_PROPERTY_MAX_OCCUPANCY = "maxOccupancy";
  private Integer maxOccupancy = 2;

  public static final String JSON_PROPERTY_MIN_OCCUPANCY = "minOccupancy";
  private Integer minOccupancy = 1;

  public static final String JSON_PROPERTY_QUANTITY = "quantity";
  private Integer quantity;

  public static final String JSON_PROPERTY_NON_SMOKING = "nonSmoking";
  private Boolean nonSmoking;

  public static final String JSON_PROPERTY_BEDROOM_CONFIGURATION_LIST = "bedroomConfigurationList";
  private List<BedroomConfigurationBooker> bedroomConfigurationList = new ArrayList<>();

  public static final String JSON_PROPERTY_SIZE = "size";
  private Float size;

  public static final String JSON_PROPERTY_MAX_ADULT_OCCUPANCY = "maxAdultOccupancy";
  private Integer maxAdultOccupancy = 2;

  public static final String JSON_PROPERTY_MAX_CHILD_OCCUPANCY = "maxChildOccupancy";
  private Integer maxChildOccupancy = 0;

  public static final String JSON_PROPERTY_BATHROOM_COUNT = "bathroomCount";
  private Integer bathroomCount = 1;

  public static final String JSON_PROPERTY_LIVING_ROOM_COUNT = "livingRoomCount";
  private Integer livingRoomCount = 1;

  public static final String JSON_PROPERTY_MAX_ROLLAWAYS = "maxRollaways";
  private Integer maxRollaways = 0;

  public static final String JSON_PROPERTY_ROOM_CATEGORY = "roomCategory";
  private String roomCategory;

  public static final String JSON_PROPERTY_FLOOR = "floor";
  private String floor;

  public static final String JSON_PROPERTY_ROOM_LOCATION_CODE = "roomLocationCode";
  private String roomLocationCode;

  public static final String JSON_PROPERTY_ROOM_VIEW_CODE = "roomViewCode";
  private String roomViewCode;

  public static final String JSON_PROPERTY_COMPOSITE = "composite";
  private Boolean composite = false;

  public static final String JSON_PROPERTY_COMPOSITE_COUNT = "compositeCount";
  private Integer compositeCount = 0;

  public static final String JSON_PROPERTY_ROOM_CLASSIFICATION_CODE = "roomClassificationCode";
  private String roomClassificationCode;

  public static final String JSON_PROPERTY_ROOM_ARCHITECTURE_CODE = "roomArchitectureCode";
  private String roomArchitectureCode;

  /**
   * Used to request or specify a gender assignment for a room. Note: Typically used by Hosteliers.
   */
  public enum RoomGenderEnum {
    MALE("Male"),
    
    FEMALE("Female"),
    
    MALEANDFEMALE("MaleAndFemale"),
    
    UNKNOWN("Unknown");

    private String value;

    RoomGenderEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static RoomGenderEnum fromValue(String value) {
      for (RoomGenderEnum b : RoomGenderEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_ROOM_GENDER = "roomGender";
  private RoomGenderEnum roomGender = RoomGenderEnum.UNKNOWN;

  public static final String JSON_PROPERTY_SHARED_ROOM_IND = "sharedRoomInd";
  private Boolean sharedRoomInd = false;

  public static final String JSON_PROPERTY_MAX_CRIBS = "maxCribs";
  private Integer maxCribs = 0;

  public static final String JSON_PROPERTY_AMENITIES = "amenities";
  private List<String> amenities = null;

  public static final String JSON_PROPERTY_INCLUDED_ADULT_OCCUPANCY = "includedAdultOccupancy";
  private Integer includedAdultOccupancy = 2;

  public static final String JSON_PROPERTY_INCLUDED_CHILD_OCCUPANCY = "includedChildOccupancy";
  private Integer includedChildOccupancy = 0;

  public GuestRoomBooker() { 
  }

  public GuestRoomBooker identifier(UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique record identifier
   * @return identifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "Unique record identifier")
  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifier(UUID identifier) {
    this.identifier = identifier;
  }


  public GuestRoomBooker hotelIdentifier(UUID hotelIdentifier) {
    
    this.hotelIdentifier = hotelIdentifier;
    return this;
  }

   /**
   * Hotel identifier.
   * @return hotelIdentifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "Hotel identifier.")
  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getHotelIdentifier() {
    return hotelIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setHotelIdentifier(UUID hotelIdentifier) {
    this.hotelIdentifier = hotelIdentifier;
  }


  public GuestRoomBooker featuredInd(Boolean featuredInd) {
    
    this.featuredInd = featuredInd;
    return this;
  }

   /**
   * Indicates whether this inventory is featured. Use this flag as a way to signify that this inventory is special.
   * @return featuredInd
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "false", required = true, value = "Indicates whether this inventory is featured. Use this flag as a way to signify that this inventory is special.")
  @JsonProperty(JSON_PROPERTY_FEATURED_IND)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getFeaturedInd() {
    return featuredInd;
  }


  @JsonProperty(JSON_PROPERTY_FEATURED_IND)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setFeaturedInd(Boolean featuredInd) {
    this.featuredInd = featuredInd;
  }


  public GuestRoomBooker lifestyleType(LifestyleTypeEnum lifestyleType) {
    
    this.lifestyleType = lifestyleType;
    return this;
  }

   /**
   * Indicate the type of lifestyle this inventory should be associated with.
   * @return lifestyleType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "LIFESTYLE_HEALTH_FITNESS", value = "Indicate the type of lifestyle this inventory should be associated with.")
  @JsonProperty(JSON_PROPERTY_LIFESTYLE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LifestyleTypeEnum getLifestyleType() {
    return lifestyleType;
  }


  @JsonProperty(JSON_PROPERTY_LIFESTYLE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLifestyleType(LifestyleTypeEnum lifestyleType) {
    this.lifestyleType = lifestyleType;
  }


  public GuestRoomBooker location(GeoJsonPointBooker location) {
    
    this.location = location;
    return this;
  }

   /**
   * Get location
   * @return location
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public GeoJsonPointBooker getLocation() {
    return location;
  }


  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLocation(GeoJsonPointBooker location) {
    this.location = location;
  }


  public GuestRoomBooker descriptions(List<SimpleDescriptionBooker> descriptions) {
    
    this.descriptions = descriptions;
    return this;
  }

  public GuestRoomBooker addDescriptionsItem(SimpleDescriptionBooker descriptionsItem) {
    this.descriptions.add(descriptionsItem);
    return this;
  }

   /**
   * Localized descriptions describing inventory.
   * @return descriptions
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "Localized descriptions describing inventory.")
  @JsonProperty(JSON_PROPERTY_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<SimpleDescriptionBooker> getDescriptions() {
    return descriptions;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDescriptions(List<SimpleDescriptionBooker> descriptions) {
    this.descriptions = descriptions;
  }


  public GuestRoomBooker multimedias(List<SimpleMultimediaBooker> multimedias) {
    
    this.multimedias = multimedias;
    return this;
  }

  public GuestRoomBooker addMultimediasItem(SimpleMultimediaBooker multimediasItem) {
    this.multimedias.add(multimediasItem);
    return this;
  }

   /**
   * List of images / videos of inventory.
   * @return multimedias
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "List of images / videos of inventory.")
  @JsonProperty(JSON_PROPERTY_MULTIMEDIAS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<SimpleMultimediaBooker> getMultimedias() {
    return multimedias;
  }


  @JsonProperty(JSON_PROPERTY_MULTIMEDIAS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMultimedias(List<SimpleMultimediaBooker> multimedias) {
    this.multimedias = multimedias;
  }


  public GuestRoomBooker contact(ContactBooker contact) {
    
    this.contact = contact;
    return this;
  }

   /**
   * Get contact
   * @return contact
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_CONTACT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ContactBooker getContact() {
    return contact;
  }


  @JsonProperty(JSON_PROPERTY_CONTACT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setContact(ContactBooker contact) {
    this.contact = contact;
  }


  public GuestRoomBooker address(AddressBooker address) {
    
    this.address = address;
    return this;
  }

   /**
   * Get address
   * @return address
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public AddressBooker getAddress() {
    return address;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAddress(AddressBooker address) {
    this.address = address;
  }


  public GuestRoomBooker commissionable(Boolean commissionable) {
    
    this.commissionable = commissionable;
    return this;
  }

   /**
   * Indicate whether sales channels receive commission for selling this inventory.
   * @return commissionable
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "true", required = true, value = "Indicate whether sales channels receive commission for selling this inventory.")
  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getCommissionable() {
    return commissionable;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCommissionable(Boolean commissionable) {
    this.commissionable = commissionable;
  }


  public GuestRoomBooker name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Internal name of inventory.
   * @return name
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "Archery lesson", required = true, value = "Internal name of inventory.")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public GuestRoomBooker proximityCode(String proximityCode) {
    
    this.proximityCode = proximityCode;
    return this;
  }

   /**
   * Supported OTA specification &#x60;PRX&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return proximityCode
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "1", required = true, value = "Supported OTA specification `PRX` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
  @JsonProperty(JSON_PROPERTY_PROXIMITY_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getProximityCode() {
    return proximityCode;
  }


  @JsonProperty(JSON_PROPERTY_PROXIMITY_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setProximityCode(String proximityCode) {
    this.proximityCode = proximityCode;
  }


  public GuestRoomBooker sort(Integer sort) {
    
    this.sort = sort;
    return this;
  }

   /**
   * Use this property to sort an inventory in a list of activities.
   * @return sort
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "1", value = "Use this property to sort an inventory in a list of activities.")
  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getSort() {
    return sort;
  }


  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSort(Integer sort) {
    this.sort = sort;
  }


  public GuestRoomBooker minAgeAppropriateCode(String minAgeAppropriateCode) {
    
    this.minAgeAppropriateCode = minAgeAppropriateCode;
    return this;
  }

   /**
   * Supported OTA specification &#x60;AQC&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return minAgeAppropriateCode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "1", value = "Supported OTA specification `AQC` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
  @JsonProperty(JSON_PROPERTY_MIN_AGE_APPROPRIATE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMinAgeAppropriateCode() {
    return minAgeAppropriateCode;
  }


  @JsonProperty(JSON_PROPERTY_MIN_AGE_APPROPRIATE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinAgeAppropriateCode(String minAgeAppropriateCode) {
    this.minAgeAppropriateCode = minAgeAppropriateCode;
  }


  public GuestRoomBooker bookable(Boolean bookable) {
    
    this.bookable = bookable;
    return this;
  }

   /**
   * Indicates if this inventory can be added to a booking or if it is read-only marketing material only.
   * @return bookable
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "true", required = true, value = "Indicates if this inventory can be added to a booking or if it is read-only marketing material only.")
  @JsonProperty(JSON_PROPERTY_BOOKABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getBookable() {
    return bookable;
  }


  @JsonProperty(JSON_PROPERTY_BOOKABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBookable(Boolean bookable) {
    this.bookable = bookable;
  }


  public GuestRoomBooker active(Boolean active) {
    
    this.active = active;
    return this;
  }

   /**
   * Modify inventory availability with this flag.
   * @return active
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "true", required = true, value = "Modify inventory availability with this flag.")
  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getActive() {
    return active;
  }


  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setActive(Boolean active) {
    this.active = active;
  }


  public GuestRoomBooker disabilityFeatures(List<String> disabilityFeatures) {
    
    this.disabilityFeatures = disabilityFeatures;
    return this;
  }

  public GuestRoomBooker addDisabilityFeaturesItem(String disabilityFeaturesItem) {
    if (this.disabilityFeatures == null) {
      this.disabilityFeatures = new ArrayList<>();
    }
    this.disabilityFeatures.add(disabilityFeaturesItem);
    return this;
  }

   /**
   * Supported OTA specification &#x60;PHY&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return disabilityFeatures
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "[\"1\"]", value = "Supported OTA specification `PHY` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
  @JsonProperty(JSON_PROPERTY_DISABILITY_FEATURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getDisabilityFeatures() {
    return disabilityFeatures;
  }


  @JsonProperty(JSON_PROPERTY_DISABILITY_FEATURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisabilityFeatures(List<String> disabilityFeatures) {
    this.disabilityFeatures = disabilityFeatures;
  }


  public GuestRoomBooker securityFeatures(List<String> securityFeatures) {
    
    this.securityFeatures = securityFeatures;
    return this;
  }

  public GuestRoomBooker addSecurityFeaturesItem(String securityFeaturesItem) {
    if (this.securityFeatures == null) {
      this.securityFeatures = new ArrayList<>();
    }
    this.securityFeatures.add(securityFeaturesItem);
    return this;
  }

   /**
   * Supported OTA specification &#x60;SEC&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return securityFeatures
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "[\"1\"]", value = "Supported OTA specification `SEC` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
  @JsonProperty(JSON_PROPERTY_SECURITY_FEATURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getSecurityFeatures() {
    return securityFeatures;
  }


  @JsonProperty(JSON_PROPERTY_SECURITY_FEATURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSecurityFeatures(List<String> securityFeatures) {
    this.securityFeatures = securityFeatures;
  }


  public GuestRoomBooker socials(List<SocialBooker> socials) {
    
    this.socials = socials;
    return this;
  }

  public GuestRoomBooker addSocialsItem(SocialBooker socialsItem) {
    if (this.socials == null) {
      this.socials = new ArrayList<>();
    }
    this.socials.add(socialsItem);
    return this;
  }

   /**
   * Social network accounts for inventory (if applicable).
   * @return socials
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Social network accounts for inventory (if applicable).")
  @JsonProperty(JSON_PROPERTY_SOCIALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SocialBooker> getSocials() {
    return socials;
  }


  @JsonProperty(JSON_PROPERTY_SOCIALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSocials(List<SocialBooker> socials) {
    this.socials = socials;
  }


  public GuestRoomBooker pricePoint(PricePointEnum pricePoint) {
    
    this.pricePoint = pricePoint;
    return this;
  }

   /**
   * Level of expensiveness.
   * @return pricePoint
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "THREE", required = true, value = "Level of expensiveness.")
  @JsonProperty(JSON_PROPERTY_PRICE_POINT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public PricePointEnum getPricePoint() {
    return pricePoint;
  }


  @JsonProperty(JSON_PROPERTY_PRICE_POINT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPricePoint(PricePointEnum pricePoint) {
    this.pricePoint = pricePoint;
  }


  public GuestRoomBooker recognitionList(List<TravelInventoryRecognitionBooker> recognitionList) {
    
    this.recognitionList = recognitionList;
    return this;
  }

  public GuestRoomBooker addRecognitionListItem(TravelInventoryRecognitionBooker recognitionListItem) {
    if (this.recognitionList == null) {
      this.recognitionList = new ArrayList<>();
    }
    this.recognitionList.add(recognitionListItem);
    return this;
  }

   /**
   * Inventory-level recognition.
   * @return recognitionList
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Inventory-level recognition.")
  @JsonProperty(JSON_PROPERTY_RECOGNITION_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<TravelInventoryRecognitionBooker> getRecognitionList() {
    return recognitionList;
  }


  @JsonProperty(JSON_PROPERTY_RECOGNITION_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecognitionList(List<TravelInventoryRecognitionBooker> recognitionList) {
    this.recognitionList = recognitionList;
  }


  public GuestRoomBooker maxOccupancy(Integer maxOccupancy) {
    
    this.maxOccupancy = maxOccupancy;
    return this;
  }

   /**
   * Maximum number of guest allowed in a room type.
   * minimum: 1
   * @return maxOccupancy
  **/
  @javax.annotation.Nonnull
  @NotNull
 @Min(1)  @ApiModelProperty(example = "2", required = true, value = "Maximum number of guest allowed in a room type.")
  @JsonProperty(JSON_PROPERTY_MAX_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getMaxOccupancy() {
    return maxOccupancy;
  }


  @JsonProperty(JSON_PROPERTY_MAX_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMaxOccupancy(Integer maxOccupancy) {
    this.maxOccupancy = maxOccupancy;
  }


  public GuestRoomBooker minOccupancy(Integer minOccupancy) {
    
    this.minOccupancy = minOccupancy;
    return this;
  }

   /**
   * Minimum number of guests allowed in a room type.
   * minimum: 1
   * @return minOccupancy
  **/
  @javax.annotation.Nonnull
  @NotNull
 @Min(1)  @ApiModelProperty(example = "1", required = true, value = "Minimum number of guests allowed in a room type.")
  @JsonProperty(JSON_PROPERTY_MIN_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getMinOccupancy() {
    return minOccupancy;
  }


  @JsonProperty(JSON_PROPERTY_MIN_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMinOccupancy(Integer minOccupancy) {
    this.minOccupancy = minOccupancy;
  }


  public GuestRoomBooker quantity(Integer quantity) {
    
    this.quantity = quantity;
    return this;
  }

   /**
   * Defines the number of rooms of this type
   * minimum: 1
   * @return quantity
  **/
  @javax.annotation.Nonnull
  @NotNull
 @Min(1)  @ApiModelProperty(example = "40", required = true, value = "Defines the number of rooms of this type")
  @JsonProperty(JSON_PROPERTY_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getQuantity() {
    return quantity;
  }


  @JsonProperty(JSON_PROPERTY_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setQuantity(Integer quantity) {
    this.quantity = quantity;
  }


  public GuestRoomBooker nonSmoking(Boolean nonSmoking) {
    
    this.nonSmoking = nonSmoking;
    return this;
  }

   /**
   * Non-smoking indicator
   * @return nonSmoking
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "true", required = true, value = "Non-smoking indicator")
  @JsonProperty(JSON_PROPERTY_NON_SMOKING)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getNonSmoking() {
    return nonSmoking;
  }


  @JsonProperty(JSON_PROPERTY_NON_SMOKING)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setNonSmoking(Boolean nonSmoking) {
    this.nonSmoking = nonSmoking;
  }


  public GuestRoomBooker bedroomConfigurationList(List<BedroomConfigurationBooker> bedroomConfigurationList) {
    
    this.bedroomConfigurationList = bedroomConfigurationList;
    return this;
  }

  public GuestRoomBooker addBedroomConfigurationListItem(BedroomConfigurationBooker bedroomConfigurationListItem) {
    this.bedroomConfigurationList.add(bedroomConfigurationListItem);
    return this;
  }

   /**
   * A room type can have more than one bed configuration.
   * @return bedroomConfigurationList
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "A room type can have more than one bed configuration.")
  @JsonProperty(JSON_PROPERTY_BEDROOM_CONFIGURATION_LIST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<BedroomConfigurationBooker> getBedroomConfigurationList() {
    return bedroomConfigurationList;
  }


  @JsonProperty(JSON_PROPERTY_BEDROOM_CONFIGURATION_LIST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBedroomConfigurationList(List<BedroomConfigurationBooker> bedroomConfigurationList) {
    this.bedroomConfigurationList = bedroomConfigurationList;
  }


  public GuestRoomBooker size(Float size) {
    
    this.size = size;
    return this;
  }

   /**
   * Number of square meters that defines the size of this room type.
   * minimum: 1
   * @return size
  **/
  @javax.annotation.Nonnull
  @NotNull
 @DecimalMin("1")  @ApiModelProperty(example = "55", required = true, value = "Number of square meters that defines the size of this room type.")
  @JsonProperty(JSON_PROPERTY_SIZE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Float getSize() {
    return size;
  }


  @JsonProperty(JSON_PROPERTY_SIZE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSize(Float size) {
    this.size = size;
  }


  public GuestRoomBooker maxAdultOccupancy(Integer maxAdultOccupancy) {
    
    this.maxAdultOccupancy = maxAdultOccupancy;
    return this;
  }

   /**
   * Maximum number of adults allowed in a room type.
   * minimum: 1
   * @return maxAdultOccupancy
  **/
  @javax.annotation.Nonnull
  @NotNull
 @Min(1)  @ApiModelProperty(example = "1", required = true, value = "Maximum number of adults allowed in a room type.")
  @JsonProperty(JSON_PROPERTY_MAX_ADULT_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getMaxAdultOccupancy() {
    return maxAdultOccupancy;
  }


  @JsonProperty(JSON_PROPERTY_MAX_ADULT_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMaxAdultOccupancy(Integer maxAdultOccupancy) {
    this.maxAdultOccupancy = maxAdultOccupancy;
  }


  public GuestRoomBooker maxChildOccupancy(Integer maxChildOccupancy) {
    
    this.maxChildOccupancy = maxChildOccupancy;
    return this;
  }

   /**
   * Maximum number of children allowed in a room type.
   * minimum: 0
   * @return maxChildOccupancy
  **/
  @javax.annotation.Nonnull
  @NotNull
 @Min(0)  @ApiModelProperty(example = "0", required = true, value = "Maximum number of children allowed in a room type.")
  @JsonProperty(JSON_PROPERTY_MAX_CHILD_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getMaxChildOccupancy() {
    return maxChildOccupancy;
  }


  @JsonProperty(JSON_PROPERTY_MAX_CHILD_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMaxChildOccupancy(Integer maxChildOccupancy) {
    this.maxChildOccupancy = maxChildOccupancy;
  }


  public GuestRoomBooker bathroomCount(Integer bathroomCount) {
    
    this.bathroomCount = bathroomCount;
    return this;
  }

   /**
   * Number of bathrooms
   * minimum: 0
   * @return bathroomCount
  **/
  @javax.annotation.Nonnull
  @NotNull
 @Min(0)  @ApiModelProperty(example = "0", required = true, value = "Number of bathrooms")
  @JsonProperty(JSON_PROPERTY_BATHROOM_COUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getBathroomCount() {
    return bathroomCount;
  }


  @JsonProperty(JSON_PROPERTY_BATHROOM_COUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBathroomCount(Integer bathroomCount) {
    this.bathroomCount = bathroomCount;
  }


  public GuestRoomBooker livingRoomCount(Integer livingRoomCount) {
    
    this.livingRoomCount = livingRoomCount;
    return this;
  }

   /**
   * Number of living rooms
   * minimum: 0
   * @return livingRoomCount
  **/
  @javax.annotation.Nonnull
  @NotNull
 @Min(0)  @ApiModelProperty(example = "0", required = true, value = "Number of living rooms")
  @JsonProperty(JSON_PROPERTY_LIVING_ROOM_COUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getLivingRoomCount() {
    return livingRoomCount;
  }


  @JsonProperty(JSON_PROPERTY_LIVING_ROOM_COUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLivingRoomCount(Integer livingRoomCount) {
    this.livingRoomCount = livingRoomCount;
  }


  public GuestRoomBooker maxRollaways(Integer maxRollaways) {
    
    this.maxRollaways = maxRollaways;
    return this;
  }

   /**
   * Maximum number of rollaway beds allowed in this room type.
   * minimum: 0
   * @return maxRollaways
  **/
  @javax.annotation.Nonnull
  @NotNull
 @Min(0)  @ApiModelProperty(example = "0", required = true, value = "Maximum number of rollaway beds allowed in this room type.")
  @JsonProperty(JSON_PROPERTY_MAX_ROLLAWAYS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getMaxRollaways() {
    return maxRollaways;
  }


  @JsonProperty(JSON_PROPERTY_MAX_ROLLAWAYS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMaxRollaways(Integer maxRollaways) {
    this.maxRollaways = maxRollaways;
  }


  public GuestRoomBooker roomCategory(String roomCategory) {
    
    this.roomCategory = roomCategory;
    return this;
  }

   /**
   * Indicates the category of the room. Typical values would be Moderate, Standard, or Deluxe. Supported OTA specification &#x60;SEG&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return roomCategory
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "1", required = true, value = "Indicates the category of the room. Typical values would be Moderate, Standard, or Deluxe. Supported OTA specification `SEG` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
  @JsonProperty(JSON_PROPERTY_ROOM_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRoomCategory() {
    return roomCategory;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRoomCategory(String roomCategory) {
    this.roomCategory = roomCategory;
  }


  public GuestRoomBooker floor(String floor) {
    
    this.floor = floor;
    return this;
  }

   /**
   * Floor an which a room is located
   * @return floor
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Floor an which a room is located")
  @JsonProperty(JSON_PROPERTY_FLOOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFloor() {
    return floor;
  }


  @JsonProperty(JSON_PROPERTY_FLOOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFloor(String floor) {
    this.floor = floor;
  }


  public GuestRoomBooker roomLocationCode(String roomLocationCode) {
    
    this.roomLocationCode = roomLocationCode;
    return this;
  }

   /**
   * Indicates the location of the room within the hotel structure. Typical values would be \&quot;Near Exit\&quot;,\&quot;Close to elevator\&quot;, \&quot;Low Floor\&quot; or \&quot;High Floor\&quot;. Supported OTA specification &#x60;RLT&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return roomLocationCode
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "1", required = true, value = "Indicates the location of the room within the hotel structure. Typical values would be \"Near Exit\",\"Close to elevator\", \"Low Floor\" or \"High Floor\". Supported OTA specification `RLT` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
  @JsonProperty(JSON_PROPERTY_ROOM_LOCATION_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRoomLocationCode() {
    return roomLocationCode;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_LOCATION_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRoomLocationCode(String roomLocationCode) {
    this.roomLocationCode = roomLocationCode;
  }


  public GuestRoomBooker roomViewCode(String roomViewCode) {
    
    this.roomViewCode = roomViewCode;
    return this;
  }

   /**
   * Indicates the view of the room. Typical values would be \&quot;Ocean view\&quot;, \&quot;Pool view\&quot; or \&quot;Garden View\&quot;. Supported OTA specification &#x60;RVT&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return roomViewCode
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "1", required = true, value = "Indicates the view of the room. Typical values would be \"Ocean view\", \"Pool view\" or \"Garden View\". Supported OTA specification `RVT` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
  @JsonProperty(JSON_PROPERTY_ROOM_VIEW_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRoomViewCode() {
    return roomViewCode;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_VIEW_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRoomViewCode(String roomViewCode) {
    this.roomViewCode = roomViewCode;
  }


  public GuestRoomBooker composite(Boolean composite) {
    
    this.composite = composite;
    return this;
  }

   /**
   * Indicates that the room (suite) is a composite of smaller units.
   * @return composite
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "false", required = true, value = "Indicates that the room (suite) is a composite of smaller units.")
  @JsonProperty(JSON_PROPERTY_COMPOSITE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getComposite() {
    return composite;
  }


  @JsonProperty(JSON_PROPERTY_COMPOSITE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setComposite(Boolean composite) {
    this.composite = composite;
  }


  public GuestRoomBooker compositeCount(Integer compositeCount) {
    
    this.compositeCount = compositeCount;
    return this;
  }

   /**
   * Number of rooms of this room type that makes up a larger unit (composite) such as a two bedroom suite could be comprised of two king rooms plus other room types. A 0 means disabled.
   * minimum: 0
   * @return compositeCount
  **/
  @javax.annotation.Nonnull
  @NotNull
 @Min(0)  @ApiModelProperty(example = "2", required = true, value = "Number of rooms of this room type that makes up a larger unit (composite) such as a two bedroom suite could be comprised of two king rooms plus other room types. A 0 means disabled.")
  @JsonProperty(JSON_PROPERTY_COMPOSITE_COUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getCompositeCount() {
    return compositeCount;
  }


  @JsonProperty(JSON_PROPERTY_COMPOSITE_COUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCompositeCount(Integer compositeCount) {
    this.compositeCount = compositeCount;
  }


  public GuestRoomBooker roomClassificationCode(String roomClassificationCode) {
    
    this.roomClassificationCode = roomClassificationCode;
    return this;
  }

   /**
   * Specifies the room classification (e.g., cabin, apartment). Supported OTA specification &#x60;GRI&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return roomClassificationCode
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "1", required = true, value = "Specifies the room classification (e.g., cabin, apartment). Supported OTA specification `GRI` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
  @JsonProperty(JSON_PROPERTY_ROOM_CLASSIFICATION_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRoomClassificationCode() {
    return roomClassificationCode;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_CLASSIFICATION_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRoomClassificationCode(String roomClassificationCode) {
    this.roomClassificationCode = roomClassificationCode;
  }


  public GuestRoomBooker roomArchitectureCode(String roomArchitectureCode) {
    
    this.roomArchitectureCode = roomArchitectureCode;
    return this;
  }

   /**
   * Specifies the architectural style of a room. Supported OTA specification &#x60;ARC&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return roomArchitectureCode
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "1", required = true, value = "Specifies the architectural style of a room. Supported OTA specification `ARC` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
  @JsonProperty(JSON_PROPERTY_ROOM_ARCHITECTURE_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRoomArchitectureCode() {
    return roomArchitectureCode;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_ARCHITECTURE_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRoomArchitectureCode(String roomArchitectureCode) {
    this.roomArchitectureCode = roomArchitectureCode;
  }


  public GuestRoomBooker roomGender(RoomGenderEnum roomGender) {
    
    this.roomGender = roomGender;
    return this;
  }

   /**
   * Used to request or specify a gender assignment for a room. Note: Typically used by Hosteliers.
   * @return roomGender
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Female", value = "Used to request or specify a gender assignment for a room. Note: Typically used by Hosteliers.")
  @JsonProperty(JSON_PROPERTY_ROOM_GENDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RoomGenderEnum getRoomGender() {
    return roomGender;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_GENDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomGender(RoomGenderEnum roomGender) {
    this.roomGender = roomGender;
  }


  public GuestRoomBooker sharedRoomInd(Boolean sharedRoomInd) {
    
    this.sharedRoomInd = sharedRoomInd;
    return this;
  }

   /**
   * If TRUE, the room requires or has sharing available. Note: Typically used by Hosteliers.
   * @return sharedRoomInd
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "false", required = true, value = "If TRUE, the room requires or has sharing available. Note: Typically used by Hosteliers.")
  @JsonProperty(JSON_PROPERTY_SHARED_ROOM_IND)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getSharedRoomInd() {
    return sharedRoomInd;
  }


  @JsonProperty(JSON_PROPERTY_SHARED_ROOM_IND)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSharedRoomInd(Boolean sharedRoomInd) {
    this.sharedRoomInd = sharedRoomInd;
  }


  public GuestRoomBooker maxCribs(Integer maxCribs) {
    
    this.maxCribs = maxCribs;
    return this;
  }

   /**
   * Maximum number of cribs allowed in a room type.
   * minimum: 0
   * @return maxCribs
  **/
  @javax.annotation.Nonnull
  @NotNull
 @Min(0)  @ApiModelProperty(example = "1", required = true, value = "Maximum number of cribs allowed in a room type.")
  @JsonProperty(JSON_PROPERTY_MAX_CRIBS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getMaxCribs() {
    return maxCribs;
  }


  @JsonProperty(JSON_PROPERTY_MAX_CRIBS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMaxCribs(Integer maxCribs) {
    this.maxCribs = maxCribs;
  }


  public GuestRoomBooker amenities(List<String> amenities) {
    
    this.amenities = amenities;
    return this;
  }

  public GuestRoomBooker addAmenitiesItem(String amenitiesItem) {
    if (this.amenities == null) {
      this.amenities = new ArrayList<>();
    }
    this.amenities.add(amenitiesItem);
    return this;
  }

   /**
   * Collection of room amenity items available to the guest. Supported OTA specification &#x60;RMA&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return amenities
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "[\"1\",\"7\"]", value = "Collection of room amenity items available to the guest. Supported OTA specification `RMA` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
  @JsonProperty(JSON_PROPERTY_AMENITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getAmenities() {
    return amenities;
  }


  @JsonProperty(JSON_PROPERTY_AMENITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAmenities(List<String> amenities) {
    this.amenities = amenities;
  }


  public GuestRoomBooker includedAdultOccupancy(Integer includedAdultOccupancy) {
    
    this.includedAdultOccupancy = includedAdultOccupancy;
    return this;
  }

   /**
   * The number of pax the room price was meant for
   * minimum: 0
   * @return includedAdultOccupancy
  **/
  @javax.annotation.Nonnull
  @NotNull
 @Min(0)  @ApiModelProperty(example = "2", required = true, value = "The number of pax the room price was meant for")
  @JsonProperty(JSON_PROPERTY_INCLUDED_ADULT_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getIncludedAdultOccupancy() {
    return includedAdultOccupancy;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDED_ADULT_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIncludedAdultOccupancy(Integer includedAdultOccupancy) {
    this.includedAdultOccupancy = includedAdultOccupancy;
  }


  public GuestRoomBooker includedChildOccupancy(Integer includedChildOccupancy) {
    
    this.includedChildOccupancy = includedChildOccupancy;
    return this;
  }

   /**
   * The number of children the room price was meant for
   * minimum: 0
   * @return includedChildOccupancy
  **/
  @javax.annotation.Nonnull
  @NotNull
 @Min(0)  @ApiModelProperty(example = "0", required = true, value = "The number of children the room price was meant for")
  @JsonProperty(JSON_PROPERTY_INCLUDED_CHILD_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getIncludedChildOccupancy() {
    return includedChildOccupancy;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDED_CHILD_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIncludedChildOccupancy(Integer includedChildOccupancy) {
    this.includedChildOccupancy = includedChildOccupancy;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GuestRoomBooker guestRoomBooker = (GuestRoomBooker) o;
    return Objects.equals(this.identifier, guestRoomBooker.identifier) &&
        Objects.equals(this.hotelIdentifier, guestRoomBooker.hotelIdentifier) &&
        Objects.equals(this.featuredInd, guestRoomBooker.featuredInd) &&
        Objects.equals(this.lifestyleType, guestRoomBooker.lifestyleType) &&
        Objects.equals(this.location, guestRoomBooker.location) &&
        Objects.equals(this.descriptions, guestRoomBooker.descriptions) &&
        Objects.equals(this.multimedias, guestRoomBooker.multimedias) &&
        Objects.equals(this.contact, guestRoomBooker.contact) &&
        Objects.equals(this.address, guestRoomBooker.address) &&
        Objects.equals(this.commissionable, guestRoomBooker.commissionable) &&
        Objects.equals(this.name, guestRoomBooker.name) &&
        Objects.equals(this.proximityCode, guestRoomBooker.proximityCode) &&
        Objects.equals(this.sort, guestRoomBooker.sort) &&
        Objects.equals(this.minAgeAppropriateCode, guestRoomBooker.minAgeAppropriateCode) &&
        Objects.equals(this.bookable, guestRoomBooker.bookable) &&
        Objects.equals(this.active, guestRoomBooker.active) &&
        Objects.equals(this.disabilityFeatures, guestRoomBooker.disabilityFeatures) &&
        Objects.equals(this.securityFeatures, guestRoomBooker.securityFeatures) &&
        Objects.equals(this.socials, guestRoomBooker.socials) &&
        Objects.equals(this.pricePoint, guestRoomBooker.pricePoint) &&
        Objects.equals(this.recognitionList, guestRoomBooker.recognitionList) &&
        Objects.equals(this.maxOccupancy, guestRoomBooker.maxOccupancy) &&
        Objects.equals(this.minOccupancy, guestRoomBooker.minOccupancy) &&
        Objects.equals(this.quantity, guestRoomBooker.quantity) &&
        Objects.equals(this.nonSmoking, guestRoomBooker.nonSmoking) &&
        Objects.equals(this.bedroomConfigurationList, guestRoomBooker.bedroomConfigurationList) &&
        Objects.equals(this.size, guestRoomBooker.size) &&
        Objects.equals(this.maxAdultOccupancy, guestRoomBooker.maxAdultOccupancy) &&
        Objects.equals(this.maxChildOccupancy, guestRoomBooker.maxChildOccupancy) &&
        Objects.equals(this.bathroomCount, guestRoomBooker.bathroomCount) &&
        Objects.equals(this.livingRoomCount, guestRoomBooker.livingRoomCount) &&
        Objects.equals(this.maxRollaways, guestRoomBooker.maxRollaways) &&
        Objects.equals(this.roomCategory, guestRoomBooker.roomCategory) &&
        Objects.equals(this.floor, guestRoomBooker.floor) &&
        Objects.equals(this.roomLocationCode, guestRoomBooker.roomLocationCode) &&
        Objects.equals(this.roomViewCode, guestRoomBooker.roomViewCode) &&
        Objects.equals(this.composite, guestRoomBooker.composite) &&
        Objects.equals(this.compositeCount, guestRoomBooker.compositeCount) &&
        Objects.equals(this.roomClassificationCode, guestRoomBooker.roomClassificationCode) &&
        Objects.equals(this.roomArchitectureCode, guestRoomBooker.roomArchitectureCode) &&
        Objects.equals(this.roomGender, guestRoomBooker.roomGender) &&
        Objects.equals(this.sharedRoomInd, guestRoomBooker.sharedRoomInd) &&
        Objects.equals(this.maxCribs, guestRoomBooker.maxCribs) &&
        Objects.equals(this.amenities, guestRoomBooker.amenities) &&
        Objects.equals(this.includedAdultOccupancy, guestRoomBooker.includedAdultOccupancy) &&
        Objects.equals(this.includedChildOccupancy, guestRoomBooker.includedChildOccupancy);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, hotelIdentifier, featuredInd, lifestyleType, location, descriptions, multimedias, contact, address, commissionable, name, proximityCode, sort, minAgeAppropriateCode, bookable, active, disabilityFeatures, securityFeatures, socials, pricePoint, recognitionList, maxOccupancy, minOccupancy, quantity, nonSmoking, bedroomConfigurationList, size, maxAdultOccupancy, maxChildOccupancy, bathroomCount, livingRoomCount, maxRollaways, roomCategory, floor, roomLocationCode, roomViewCode, composite, compositeCount, roomClassificationCode, roomArchitectureCode, roomGender, sharedRoomInd, maxCribs, amenities, includedAdultOccupancy, includedChildOccupancy);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GuestRoomBooker {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    hotelIdentifier: ").append(toIndentedString(hotelIdentifier)).append("\n");
    sb.append("    featuredInd: ").append(toIndentedString(featuredInd)).append("\n");
    sb.append("    lifestyleType: ").append(toIndentedString(lifestyleType)).append("\n");
    sb.append("    location: ").append(toIndentedString(location)).append("\n");
    sb.append("    descriptions: ").append(toIndentedString(descriptions)).append("\n");
    sb.append("    multimedias: ").append(toIndentedString(multimedias)).append("\n");
    sb.append("    contact: ").append(toIndentedString(contact)).append("\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    commissionable: ").append(toIndentedString(commissionable)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    proximityCode: ").append(toIndentedString(proximityCode)).append("\n");
    sb.append("    sort: ").append(toIndentedString(sort)).append("\n");
    sb.append("    minAgeAppropriateCode: ").append(toIndentedString(minAgeAppropriateCode)).append("\n");
    sb.append("    bookable: ").append(toIndentedString(bookable)).append("\n");
    sb.append("    active: ").append(toIndentedString(active)).append("\n");
    sb.append("    disabilityFeatures: ").append(toIndentedString(disabilityFeatures)).append("\n");
    sb.append("    securityFeatures: ").append(toIndentedString(securityFeatures)).append("\n");
    sb.append("    socials: ").append(toIndentedString(socials)).append("\n");
    sb.append("    pricePoint: ").append(toIndentedString(pricePoint)).append("\n");
    sb.append("    recognitionList: ").append(toIndentedString(recognitionList)).append("\n");
    sb.append("    maxOccupancy: ").append(toIndentedString(maxOccupancy)).append("\n");
    sb.append("    minOccupancy: ").append(toIndentedString(minOccupancy)).append("\n");
    sb.append("    quantity: ").append(toIndentedString(quantity)).append("\n");
    sb.append("    nonSmoking: ").append(toIndentedString(nonSmoking)).append("\n");
    sb.append("    bedroomConfigurationList: ").append(toIndentedString(bedroomConfigurationList)).append("\n");
    sb.append("    size: ").append(toIndentedString(size)).append("\n");
    sb.append("    maxAdultOccupancy: ").append(toIndentedString(maxAdultOccupancy)).append("\n");
    sb.append("    maxChildOccupancy: ").append(toIndentedString(maxChildOccupancy)).append("\n");
    sb.append("    bathroomCount: ").append(toIndentedString(bathroomCount)).append("\n");
    sb.append("    livingRoomCount: ").append(toIndentedString(livingRoomCount)).append("\n");
    sb.append("    maxRollaways: ").append(toIndentedString(maxRollaways)).append("\n");
    sb.append("    roomCategory: ").append(toIndentedString(roomCategory)).append("\n");
    sb.append("    floor: ").append(toIndentedString(floor)).append("\n");
    sb.append("    roomLocationCode: ").append(toIndentedString(roomLocationCode)).append("\n");
    sb.append("    roomViewCode: ").append(toIndentedString(roomViewCode)).append("\n");
    sb.append("    composite: ").append(toIndentedString(composite)).append("\n");
    sb.append("    compositeCount: ").append(toIndentedString(compositeCount)).append("\n");
    sb.append("    roomClassificationCode: ").append(toIndentedString(roomClassificationCode)).append("\n");
    sb.append("    roomArchitectureCode: ").append(toIndentedString(roomArchitectureCode)).append("\n");
    sb.append("    roomGender: ").append(toIndentedString(roomGender)).append("\n");
    sb.append("    sharedRoomInd: ").append(toIndentedString(sharedRoomInd)).append("\n");
    sb.append("    maxCribs: ").append(toIndentedString(maxCribs)).append("\n");
    sb.append("    amenities: ").append(toIndentedString(amenities)).append("\n");
    sb.append("    includedAdultOccupancy: ").append(toIndentedString(includedAdultOccupancy)).append("\n");
    sb.append("    includedChildOccupancy: ").append(toIndentedString(includedChildOccupancy)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

