/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release   # Booking API Welcome to the Booking Engine API - A programmer-friendly way to book inventory that was found on our platform. We take great care in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive payment-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 24.3.2
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.booking.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.booking.model.AncillaryRequestAgent;
import travel.wink.sdk.booking.model.BookingUserRequestAgent;
import travel.wink.sdk.booking.model.RoomConfigurationAgent;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * List of room configuration booking requests. Each entry is a separately booked room.
 */
@ApiModel(description = "List of room configuration booking requests. Each entry is a separately booked room.")
@JsonPropertyOrder({
  AgentBookingRequestAgent.JSON_PROPERTY_HOTEL_IDENTIFIER,
  AgentBookingRequestAgent.JSON_PROPERTY_START_DATE,
  AgentBookingRequestAgent.JSON_PROPERTY_END_DATE,
  AgentBookingRequestAgent.JSON_PROPERTY_ROOM_CONFIGURATION,
  AgentBookingRequestAgent.JSON_PROPERTY_PROMOTIONAL_CODES,
  AgentBookingRequestAgent.JSON_PROPERTY_ROOM_RATE_IDENTIFIER,
  AgentBookingRequestAgent.JSON_PROPERTY_BEDROOM_CONFIGURATION_IDENTIFIER,
  AgentBookingRequestAgent.JSON_PROPERTY_ANCILLARIES,
  AgentBookingRequestAgent.JSON_PROPERTY_SPECIAL_REQUESTS,
  AgentBookingRequestAgent.JSON_PROPERTY_USER,
  AgentBookingRequestAgent.JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE,
  AgentBookingRequestAgent.JSON_PROPERTY_EXTERNAL_TRANSACTION_IDENTIFIER
})
@JsonTypeName("AgentBookingRequest_Agent")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-03-10T10:48:08.191600840+07:00[Asia/Bangkok]")
public class AgentBookingRequestAgent {
  public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
  private UUID hotelIdentifier;

  public static final String JSON_PROPERTY_START_DATE = "startDate";
  private LocalDate startDate;

  public static final String JSON_PROPERTY_END_DATE = "endDate";
  private LocalDate endDate;

  public static final String JSON_PROPERTY_ROOM_CONFIGURATION = "roomConfiguration";
  private RoomConfigurationAgent roomConfiguration;

  public static final String JSON_PROPERTY_PROMOTIONAL_CODES = "promotionalCodes";
  private List<String> promotionalCodes = null;

  public static final String JSON_PROPERTY_ROOM_RATE_IDENTIFIER = "roomRateIdentifier";
  private UUID roomRateIdentifier;

  public static final String JSON_PROPERTY_BEDROOM_CONFIGURATION_IDENTIFIER = "bedroomConfigurationIdentifier";
  private String bedroomConfigurationIdentifier;

  public static final String JSON_PROPERTY_ANCILLARIES = "ancillaries";
  private List<AncillaryRequestAgent> ancillaries = null;

  public static final String JSON_PROPERTY_SPECIAL_REQUESTS = "specialRequests";
  private String specialRequests;

  public static final String JSON_PROPERTY_USER = "user";
  private BookingUserRequestAgent user;

  public static final String JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE = "externalSupplierBookingCode";
  private String externalSupplierBookingCode;

  public static final String JSON_PROPERTY_EXTERNAL_TRANSACTION_IDENTIFIER = "externalTransactionIdentifier";
  private String externalTransactionIdentifier;

  public AgentBookingRequestAgent() { 
  }

  public AgentBookingRequestAgent hotelIdentifier(UUID hotelIdentifier) {
    
    this.hotelIdentifier = hotelIdentifier;
    return this;
  }

   /**
   * Unique hotel record identifier.
   * @return hotelIdentifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "Unique hotel record identifier.")
  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getHotelIdentifier() {
    return hotelIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setHotelIdentifier(UUID hotelIdentifier) {
    this.hotelIdentifier = hotelIdentifier;
  }


  public AgentBookingRequestAgent startDate(LocalDate startDate) {
    
    this.startDate = startDate;
    return this;
  }

   /**
   * Date when guest arrives on the premises.
   * @return startDate
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(example = "Sun Jan 31 07:00:00 ICT 2021", required = true, value = "Date when guest arrives on the premises.")
  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public LocalDate getStartDate() {
    return startDate;
  }


  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStartDate(LocalDate startDate) {
    this.startDate = startDate;
  }


  public AgentBookingRequestAgent endDate(LocalDate endDate) {
    
    this.endDate = endDate;
    return this;
  }

   /**
   * Date when guest departs the premises.
   * @return endDate
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(example = "Sun Feb 07 07:00:00 ICT 2021", required = true, value = "Date when guest departs the premises.")
  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public LocalDate getEndDate() {
    return endDate;
  }


  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEndDate(LocalDate endDate) {
    this.endDate = endDate;
  }


  public AgentBookingRequestAgent roomConfiguration(RoomConfigurationAgent roomConfiguration) {
    
    this.roomConfiguration = roomConfiguration;
    return this;
  }

   /**
   * Get roomConfiguration
   * @return roomConfiguration
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_ROOM_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public RoomConfigurationAgent getRoomConfiguration() {
    return roomConfiguration;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRoomConfiguration(RoomConfigurationAgent roomConfiguration) {
    this.roomConfiguration = roomConfiguration;
  }


  public AgentBookingRequestAgent promotionalCodes(List<String> promotionalCodes) {
    
    this.promotionalCodes = promotionalCodes;
    return this;
  }

  public AgentBookingRequestAgent addPromotionalCodesItem(String promotionalCodesItem) {
    if (this.promotionalCodes == null) {
      this.promotionalCodes = new ArrayList<>();
    }
    this.promotionalCodes.add(promotionalCodesItem);
    return this;
  }

   /**
   * Get promotionalCodes
   * @return promotionalCodes
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PROMOTIONAL_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getPromotionalCodes() {
    return promotionalCodes;
  }


  @JsonProperty(JSON_PROPERTY_PROMOTIONAL_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPromotionalCodes(List<String> promotionalCodes) {
    this.promotionalCodes = promotionalCodes;
  }


  public AgentBookingRequestAgent roomRateIdentifier(UUID roomRateIdentifier) {
    
    this.roomRateIdentifier = roomRateIdentifier;
    return this;
  }

   /**
   * The unique master rate that made the guest room / rate plan available for sale.
   * @return roomRateIdentifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "The unique master rate that made the guest room / rate plan available for sale.")
  @JsonProperty(JSON_PROPERTY_ROOM_RATE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getRoomRateIdentifier() {
    return roomRateIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_RATE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRoomRateIdentifier(UUID roomRateIdentifier) {
    this.roomRateIdentifier = roomRateIdentifier;
  }


  public AgentBookingRequestAgent bedroomConfigurationIdentifier(String bedroomConfigurationIdentifier) {
    
    this.bedroomConfigurationIdentifier = bedroomConfigurationIdentifier;
    return this;
  }

   /**
   * Guest can optionally request a specific bedroom layout if the room type is set up with multiple layout choices.
   * @return bedroomConfigurationIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Guest can optionally request a specific bedroom layout if the room type is set up with multiple layout choices.")
  @JsonProperty(JSON_PROPERTY_BEDROOM_CONFIGURATION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBedroomConfigurationIdentifier() {
    return bedroomConfigurationIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_BEDROOM_CONFIGURATION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBedroomConfigurationIdentifier(String bedroomConfigurationIdentifier) {
    this.bedroomConfigurationIdentifier = bedroomConfigurationIdentifier;
  }


  public AgentBookingRequestAgent ancillaries(List<AncillaryRequestAgent> ancillaries) {
    
    this.ancillaries = ancillaries;
    return this;
  }

  public AgentBookingRequestAgent addAncillariesItem(AncillaryRequestAgent ancillariesItem) {
    if (this.ancillaries == null) {
      this.ancillaries = new ArrayList<>();
    }
    this.ancillaries.add(ancillariesItem);
    return this;
  }

   /**
   * Get ancillaries
   * @return ancillaries
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ANCILLARIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<AncillaryRequestAgent> getAncillaries() {
    return ancillaries;
  }


  @JsonProperty(JSON_PROPERTY_ANCILLARIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAncillaries(List<AncillaryRequestAgent> ancillaries) {
    this.ancillaries = ancillaries;
  }


  public AgentBookingRequestAgent specialRequests(String specialRequests) {
    
    this.specialRequests = specialRequests;
    return this;
  }

   /**
   * A guest can send a special request to the hotel in free-text here.
   * @return specialRequests
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Can I please have rose petals on my pillows when I arrive?", value = "A guest can send a special request to the hotel in free-text here.")
  @JsonProperty(JSON_PROPERTY_SPECIAL_REQUESTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSpecialRequests() {
    return specialRequests;
  }


  @JsonProperty(JSON_PROPERTY_SPECIAL_REQUESTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSpecialRequests(String specialRequests) {
    this.specialRequests = specialRequests;
  }


  public AgentBookingRequestAgent user(BookingUserRequestAgent user) {
    
    this.user = user;
    return this;
  }

   /**
   * Get user
   * @return user
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_USER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BookingUserRequestAgent getUser() {
    return user;
  }


  @JsonProperty(JSON_PROPERTY_USER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUser(BookingUserRequestAgent user) {
    this.user = user;
  }


  public AgentBookingRequestAgent externalSupplierBookingCode(String externalSupplierBookingCode) {
    
    this.externalSupplierBookingCode = externalSupplierBookingCode;
    return this;
  }

   /**
   * External booking code generated by the affiliate
   * @return externalSupplierBookingCode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "external-booking-code-1", value = "External booking code generated by the affiliate")
  @JsonProperty(JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getExternalSupplierBookingCode() {
    return externalSupplierBookingCode;
  }


  @JsonProperty(JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExternalSupplierBookingCode(String externalSupplierBookingCode) {
    this.externalSupplierBookingCode = externalSupplierBookingCode;
  }


  public AgentBookingRequestAgent externalTransactionIdentifier(String externalTransactionIdentifier) {
    
    this.externalTransactionIdentifier = externalTransactionIdentifier;
    return this;
  }

   /**
   * External transaction identifier populated when agent responsible for acquiring
   * @return externalTransactionIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "external-transaction-1", value = "External transaction identifier populated when agent responsible for acquiring")
  @JsonProperty(JSON_PROPERTY_EXTERNAL_TRANSACTION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getExternalTransactionIdentifier() {
    return externalTransactionIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_EXTERNAL_TRANSACTION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExternalTransactionIdentifier(String externalTransactionIdentifier) {
    this.externalTransactionIdentifier = externalTransactionIdentifier;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AgentBookingRequestAgent agentBookingRequestAgent = (AgentBookingRequestAgent) o;
    return Objects.equals(this.hotelIdentifier, agentBookingRequestAgent.hotelIdentifier) &&
        Objects.equals(this.startDate, agentBookingRequestAgent.startDate) &&
        Objects.equals(this.endDate, agentBookingRequestAgent.endDate) &&
        Objects.equals(this.roomConfiguration, agentBookingRequestAgent.roomConfiguration) &&
        Objects.equals(this.promotionalCodes, agentBookingRequestAgent.promotionalCodes) &&
        Objects.equals(this.roomRateIdentifier, agentBookingRequestAgent.roomRateIdentifier) &&
        Objects.equals(this.bedroomConfigurationIdentifier, agentBookingRequestAgent.bedroomConfigurationIdentifier) &&
        Objects.equals(this.ancillaries, agentBookingRequestAgent.ancillaries) &&
        Objects.equals(this.specialRequests, agentBookingRequestAgent.specialRequests) &&
        Objects.equals(this.user, agentBookingRequestAgent.user) &&
        Objects.equals(this.externalSupplierBookingCode, agentBookingRequestAgent.externalSupplierBookingCode) &&
        Objects.equals(this.externalTransactionIdentifier, agentBookingRequestAgent.externalTransactionIdentifier);
  }

  @Override
  public int hashCode() {
    return Objects.hash(hotelIdentifier, startDate, endDate, roomConfiguration, promotionalCodes, roomRateIdentifier, bedroomConfigurationIdentifier, ancillaries, specialRequests, user, externalSupplierBookingCode, externalTransactionIdentifier);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AgentBookingRequestAgent {\n");
    sb.append("    hotelIdentifier: ").append(toIndentedString(hotelIdentifier)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    roomConfiguration: ").append(toIndentedString(roomConfiguration)).append("\n");
    sb.append("    promotionalCodes: ").append(toIndentedString(promotionalCodes)).append("\n");
    sb.append("    roomRateIdentifier: ").append(toIndentedString(roomRateIdentifier)).append("\n");
    sb.append("    bedroomConfigurationIdentifier: ").append(toIndentedString(bedroomConfigurationIdentifier)).append("\n");
    sb.append("    ancillaries: ").append(toIndentedString(ancillaries)).append("\n");
    sb.append("    specialRequests: ").append(toIndentedString(specialRequests)).append("\n");
    sb.append("    user: ").append(toIndentedString(user)).append("\n");
    sb.append("    externalSupplierBookingCode: ").append(toIndentedString(externalSupplierBookingCode)).append("\n");
    sb.append("    externalTransactionIdentifier: ").append(toIndentedString(externalTransactionIdentifier)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

