/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release   # Booking API Welcome to the Booking Engine API - A programmer-friendly way to book inventory that was found on our platform. We take great care in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive payment-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 24.3.2
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.booking.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.booking.model.BookingContractItemAgent;
import travel.wink.sdk.booking.model.BookingContractPaymentDetailsAgent;
import travel.wink.sdk.booking.model.MoneysAgent;
import travel.wink.sdk.booking.model.QuoteAgent;
import travel.wink.sdk.booking.model.RefundAgent;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Booking contract created by TripPay
 */
@ApiModel(description = "Booking contract created by TripPay")
@JsonPropertyOrder({
  BookingContractAgent.JSON_PROPERTY_BOOKING_CONTRACT_IDENTIFIER,
  BookingContractAgent.JSON_PROPERTY_CREATED_DATE,
  BookingContractAgent.JSON_PROPERTY_LAST_UPDATE,
  BookingContractAgent.JSON_PROPERTY_IP_ADDRESS,
  BookingContractAgent.JSON_PROPERTY_TRACE_ID,
  BookingContractAgent.JSON_PROPERTY_SOURCE_URL,
  BookingContractAgent.JSON_PROPERTY_IDENTIFIER,
  BookingContractAgent.JSON_PROPERTY_SUPPLIER_IDENTIFIER,
  BookingContractAgent.JSON_PROPERTY_SUPPLIER_NAME,
  BookingContractAgent.JSON_PROPERTY_DISPLAY_PRICE_QUOTE,
  BookingContractAgent.JSON_PROPERTY_SUPPLIER_PRICE_QUOTE,
  BookingContractAgent.JSON_PROPERTY_INTERNAL_PRICE_QUOTE,
  BookingContractAgent.JSON_PROPERTY_CAPTURE_PRICE_QUOTE,
  BookingContractAgent.JSON_PROPERTY_ITEM_LIST,
  BookingContractAgent.JSON_PROPERTY_EXTERNAL_SUPPLIER_IDENTIFIER,
  BookingContractAgent.JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE,
  BookingContractAgent.JSON_PROPERTY_PAYMENT,
  BookingContractAgent.JSON_PROPERTY_CANCELLED,
  BookingContractAgent.JSON_PROPERTY_CANCELLED_ON,
  BookingContractAgent.JSON_PROPERTY_CANCELLER,
  BookingContractAgent.JSON_PROPERTY_CANCELLATION_TYPE,
  BookingContractAgent.JSON_PROPERTY_CANCELLER_USER_IDENTIFIER,
  BookingContractAgent.JSON_PROPERTY_CANCEL_REASON,
  BookingContractAgent.JSON_PROPERTY_FUNDS_PROCESSED,
  BookingContractAgent.JSON_PROPERTY_REFUNDS,
  BookingContractAgent.JSON_PROPERTY_TOTAL_SOURCE_PRICE,
  BookingContractAgent.JSON_PROPERTY_TOTAL_DISPLAY_PRICE,
  BookingContractAgent.JSON_PROPERTY_TOTAL_SUPPLIER_PRICE,
  BookingContractAgent.JSON_PROPERTY_TOTAL_INTERNAL_PRICE,
  BookingContractAgent.JSON_PROPERTY_TOTAL_CAPTURE_PRICE,
  BookingContractAgent.JSON_PROPERTY_TOTAL_SOURCE_PRICE_AFTER_REFUND,
  BookingContractAgent.JSON_PROPERTY_TOTAL_DISPLAY_PRICE_AFTER_REFUND,
  BookingContractAgent.JSON_PROPERTY_TOTAL_SUPPLIER_PRICE_AFTER_REFUND,
  BookingContractAgent.JSON_PROPERTY_TOTAL_INTERNAL_PRICE_AFTER_REFUND,
  BookingContractAgent.JSON_PROPERTY_TOTAL_CAPTURE_PRICE_AFTER_REFUND,
  BookingContractAgent.JSON_PROPERTY_REFUNDED_SOURCE_PRICE,
  BookingContractAgent.JSON_PROPERTY_REFUNDED_DISPLAY_PRICE,
  BookingContractAgent.JSON_PROPERTY_REFUNDED_SUPPLIER_PRICE,
  BookingContractAgent.JSON_PROPERTY_REFUNDED_INTERNAL_PRICE,
  BookingContractAgent.JSON_PROPERTY_REFUNDED_CAPTURE_PRICE,
  BookingContractAgent.JSON_PROPERTY_TOTAL_TOKENS_EARNED,
  BookingContractAgent.JSON_PROPERTY_CANCELLABLE_WITH_NO_CHARGES,
  BookingContractAgent.JSON_PROPERTY_IS_CANCELLABLE_WITH_POTENTIAL_CHARGES,
  BookingContractAgent.JSON_PROPERTY_COMMISSIONABLE_TOTAL_SOURCE_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_COMMISSIONABLE_TOTAL_CAPTURE_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_COMMISSIONABLE_TOTAL_DISPLAY_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_COMMISSIONABLE_TOTAL_SUPPLIER_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_COMMISSIONABLE_TOTAL_INTERNAL_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER,
  BookingContractAgent.JSON_PROPERTY_CANCELLABLE_BY_TRAVELER
})
@JsonTypeName("BookingContract_Agent")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-03-10T10:48:08.191600840+07:00[Asia/Bangkok]")
public class BookingContractAgent {
  public static final String JSON_PROPERTY_BOOKING_CONTRACT_IDENTIFIER = "bookingContractIdentifier";
  private UUID bookingContractIdentifier;

  public static final String JSON_PROPERTY_CREATED_DATE = "createdDate";
  private java.time.LocalDateTime createdDate;

  public static final String JSON_PROPERTY_LAST_UPDATE = "lastUpdate";
  private java.time.LocalDateTime lastUpdate;

  public static final String JSON_PROPERTY_IP_ADDRESS = "ipAddress";
  private String ipAddress;

  public static final String JSON_PROPERTY_TRACE_ID = "traceId";
  private String traceId;

  public static final String JSON_PROPERTY_SOURCE_URL = "sourceUrl";
  private String sourceUrl;

  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private UUID identifier;

  public static final String JSON_PROPERTY_SUPPLIER_IDENTIFIER = "supplierIdentifier";
  private UUID supplierIdentifier;

  public static final String JSON_PROPERTY_SUPPLIER_NAME = "supplierName";
  private String supplierName;

  public static final String JSON_PROPERTY_DISPLAY_PRICE_QUOTE = "displayPriceQuote";
  private QuoteAgent displayPriceQuote;

  public static final String JSON_PROPERTY_SUPPLIER_PRICE_QUOTE = "supplierPriceQuote";
  private QuoteAgent supplierPriceQuote;

  public static final String JSON_PROPERTY_INTERNAL_PRICE_QUOTE = "internalPriceQuote";
  private QuoteAgent internalPriceQuote;

  public static final String JSON_PROPERTY_CAPTURE_PRICE_QUOTE = "capturePriceQuote";
  private QuoteAgent capturePriceQuote;

  public static final String JSON_PROPERTY_ITEM_LIST = "itemList";
  private List<BookingContractItemAgent> itemList = new ArrayList<>();

  public static final String JSON_PROPERTY_EXTERNAL_SUPPLIER_IDENTIFIER = "externalSupplierIdentifier";
  private String externalSupplierIdentifier;

  public static final String JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE = "externalSupplierBookingCode";
  private String externalSupplierBookingCode;

  public static final String JSON_PROPERTY_PAYMENT = "payment";
  private BookingContractPaymentDetailsAgent payment;

  public static final String JSON_PROPERTY_CANCELLED = "cancelled";
  private Boolean cancelled = false;

  public static final String JSON_PROPERTY_CANCELLED_ON = "cancelledOn";
  private java.time.LocalDateTime cancelledOn;

  /**
   * Type of entity that cancelled the booking.
   */
  public enum CancellerEnum {
    SALES_CHANNEL("SALES_CHANNEL"),
    
    SUPPLIER("SUPPLIER"),
    
    TRAVELER("TRAVELER"),
    
    ACQUIRER("ACQUIRER"),
    
    ADMINISTRATOR("ADMINISTRATOR");

    private String value;

    CancellerEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CancellerEnum fromValue(String value) {
      for (CancellerEnum b : CancellerEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CANCELLER = "canceller";
  private CancellerEnum canceller;

  /**
   * Reason type.
   */
  public enum CancellationTypeEnum {
    DUPLICATE("DUPLICATE"),
    
    CANCELLATION("CANCELLATION"),
    
    NO_SHOW("NO_SHOW"),
    
    CC_INVALID("CC_INVALID"),
    
    CC_INSUFFICIENT("CC_INSUFFICIENT"),
    
    DISCRETIONARY("DISCRETIONARY");

    private String value;

    CancellationTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CancellationTypeEnum fromValue(String value) {
      for (CancellationTypeEnum b : CancellationTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CANCELLATION_TYPE = "cancellationType";
  private CancellationTypeEnum cancellationType;

  public static final String JSON_PROPERTY_CANCELLER_USER_IDENTIFIER = "cancellerUserIdentifier";
  private String cancellerUserIdentifier;

  public static final String JSON_PROPERTY_CANCEL_REASON = "cancelReason";
  private String cancelReason;

  public static final String JSON_PROPERTY_FUNDS_PROCESSED = "fundsProcessed";
  private Boolean fundsProcessed;

  public static final String JSON_PROPERTY_REFUNDS = "refunds";
  private List<RefundAgent> refunds = null;

  public static final String JSON_PROPERTY_TOTAL_SOURCE_PRICE = "totalSourcePrice";
  private MoneysAgent totalSourcePrice;

  public static final String JSON_PROPERTY_TOTAL_DISPLAY_PRICE = "totalDisplayPrice";
  private MoneysAgent totalDisplayPrice;

  public static final String JSON_PROPERTY_TOTAL_SUPPLIER_PRICE = "totalSupplierPrice";
  private MoneysAgent totalSupplierPrice;

  public static final String JSON_PROPERTY_TOTAL_INTERNAL_PRICE = "totalInternalPrice";
  private MoneysAgent totalInternalPrice;

  public static final String JSON_PROPERTY_TOTAL_CAPTURE_PRICE = "totalCapturePrice";
  private MoneysAgent totalCapturePrice;

  public static final String JSON_PROPERTY_TOTAL_SOURCE_PRICE_AFTER_REFUND = "totalSourcePriceAfterRefund";
  private MoneysAgent totalSourcePriceAfterRefund;

  public static final String JSON_PROPERTY_TOTAL_DISPLAY_PRICE_AFTER_REFUND = "totalDisplayPriceAfterRefund";
  private MoneysAgent totalDisplayPriceAfterRefund;

  public static final String JSON_PROPERTY_TOTAL_SUPPLIER_PRICE_AFTER_REFUND = "totalSupplierPriceAfterRefund";
  private MoneysAgent totalSupplierPriceAfterRefund;

  public static final String JSON_PROPERTY_TOTAL_INTERNAL_PRICE_AFTER_REFUND = "totalInternalPriceAfterRefund";
  private MoneysAgent totalInternalPriceAfterRefund;

  public static final String JSON_PROPERTY_TOTAL_CAPTURE_PRICE_AFTER_REFUND = "totalCapturePriceAfterRefund";
  private MoneysAgent totalCapturePriceAfterRefund;

  public static final String JSON_PROPERTY_REFUNDED_SOURCE_PRICE = "refundedSourcePrice";
  private MoneysAgent refundedSourcePrice;

  public static final String JSON_PROPERTY_REFUNDED_DISPLAY_PRICE = "refundedDisplayPrice";
  private MoneysAgent refundedDisplayPrice;

  public static final String JSON_PROPERTY_REFUNDED_SUPPLIER_PRICE = "refundedSupplierPrice";
  private MoneysAgent refundedSupplierPrice;

  public static final String JSON_PROPERTY_REFUNDED_INTERNAL_PRICE = "refundedInternalPrice";
  private MoneysAgent refundedInternalPrice;

  public static final String JSON_PROPERTY_REFUNDED_CAPTURE_PRICE = "refundedCapturePrice";
  private MoneysAgent refundedCapturePrice;

  public static final String JSON_PROPERTY_TOTAL_TOKENS_EARNED = "totalTokensEarned";
  private Long totalTokensEarned;

  public static final String JSON_PROPERTY_CANCELLABLE_WITH_NO_CHARGES = "cancellableWithNoCharges";
  private Boolean cancellableWithNoCharges;

  public static final String JSON_PROPERTY_IS_CANCELLABLE_WITH_POTENTIAL_CHARGES = "isCancellableWithPotentialCharges";
  private Boolean isCancellableWithPotentialCharges;

  public static final String JSON_PROPERTY_COMMISSIONABLE_TOTAL_SOURCE_AMOUNT = "commissionableTotalSourceAmount";
  private MoneysAgent commissionableTotalSourceAmount;

  public static final String JSON_PROPERTY_COMMISSIONABLE_TOTAL_CAPTURE_AMOUNT = "commissionableTotalCaptureAmount";
  private MoneysAgent commissionableTotalCaptureAmount;

  public static final String JSON_PROPERTY_COMMISSIONABLE_TOTAL_DISPLAY_AMOUNT = "commissionableTotalDisplayAmount";
  private MoneysAgent commissionableTotalDisplayAmount;

  public static final String JSON_PROPERTY_COMMISSIONABLE_TOTAL_SUPPLIER_AMOUNT = "commissionableTotalSupplierAmount";
  private MoneysAgent commissionableTotalSupplierAmount;

  public static final String JSON_PROPERTY_COMMISSIONABLE_TOTAL_INTERNAL_AMOUNT = "commissionableTotalInternalAmount";
  private MoneysAgent commissionableTotalInternalAmount;

  public static final String JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER = "cancellableBySupplier";
  private Boolean cancellableBySupplier;

  public static final String JSON_PROPERTY_CANCELLABLE_BY_TRAVELER = "cancellableByTraveler";
  private Boolean cancellableByTraveler;

  public BookingContractAgent() { 
  }

  public BookingContractAgent bookingContractIdentifier(UUID bookingContractIdentifier) {
    
    this.bookingContractIdentifier = bookingContractIdentifier;
    return this;
  }

   /**
   * Document UUID
   * @return bookingContractIdentifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Document UUID")
  @JsonProperty(JSON_PROPERTY_BOOKING_CONTRACT_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getBookingContractIdentifier() {
    return bookingContractIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_BOOKING_CONTRACT_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBookingContractIdentifier(UUID bookingContractIdentifier) {
    this.bookingContractIdentifier = bookingContractIdentifier;
  }


  public BookingContractAgent createdDate(java.time.LocalDateTime createdDate) {
    
    this.createdDate = createdDate;
    return this;
  }

   /**
   * Datetime this record was first created
   * @return createdDate
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Datetime this record was first created")
  @JsonProperty(JSON_PROPERTY_CREATED_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getCreatedDate() {
    return createdDate;
  }


  @JsonProperty(JSON_PROPERTY_CREATED_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreatedDate(java.time.LocalDateTime createdDate) {
    this.createdDate = createdDate;
  }


  public BookingContractAgent lastUpdate(java.time.LocalDateTime lastUpdate) {
    
    this.lastUpdate = lastUpdate;
    return this;
  }

   /**
   * Datetime this record was last updated
   * @return lastUpdate
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Datetime this record was last updated")
  @JsonProperty(JSON_PROPERTY_LAST_UPDATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getLastUpdate() {
    return lastUpdate;
  }


  @JsonProperty(JSON_PROPERTY_LAST_UPDATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLastUpdate(java.time.LocalDateTime lastUpdate) {
    this.lastUpdate = lastUpdate;
  }


  public BookingContractAgent ipAddress(String ipAddress) {
    
    this.ipAddress = ipAddress;
    return this;
  }

   /**
   * Caller&#39;s IP address
   * @return ipAddress
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "111.222.333.444", required = true, value = "Caller's IP address")
  @JsonProperty(JSON_PROPERTY_IP_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getIpAddress() {
    return ipAddress;
  }


  @JsonProperty(JSON_PROPERTY_IP_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIpAddress(String ipAddress) {
    this.ipAddress = ipAddress;
  }


  public BookingContractAgent traceId(String traceId) {
    
    this.traceId = traceId;
    return this;
  }

   /**
   * Way to track which booking contracts were made together
   * @return traceId
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "T-123456", required = true, value = "Way to track which booking contracts were made together")
  @JsonProperty(JSON_PROPERTY_TRACE_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getTraceId() {
    return traceId;
  }


  @JsonProperty(JSON_PROPERTY_TRACE_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTraceId(String traceId) {
    this.traceId = traceId;
  }


  public BookingContractAgent sourceUrl(String sourceUrl) {
    
    this.sourceUrl = sourceUrl;
    return this;
  }

   /**
   * Where did the booking occur
   * @return sourceUrl
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "https://www.traveliko.com", required = true, value = "Where did the booking occur")
  @JsonProperty(JSON_PROPERTY_SOURCE_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSourceUrl() {
    return sourceUrl;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSourceUrl(String sourceUrl) {
    this.sourceUrl = sourceUrl;
  }


  public BookingContractAgent identifier(UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique identifier used to track the contract. Create a UUID for this purpose.
   * @return identifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "Unique identifier used to track the contract. Create a UUID for this purpose.")
  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifier(UUID identifier) {
    this.identifier = identifier;
  }


  public BookingContractAgent supplierIdentifier(UUID supplierIdentifier) {
    
    this.supplierIdentifier = supplierIdentifier;
    return this;
  }

   /**
   * Supplier identifier
   * @return supplierIdentifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "Supplier identifier")
  @JsonProperty(JSON_PROPERTY_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getSupplierIdentifier() {
    return supplierIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSupplierIdentifier(UUID supplierIdentifier) {
    this.supplierIdentifier = supplierIdentifier;
  }


  public BookingContractAgent supplierName(String supplierName) {
    
    this.supplierName = supplierName;
    return this;
  }

   /**
   * Supplier name
   * @return supplierName
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "Supplier One", required = true, value = "Supplier name")
  @JsonProperty(JSON_PROPERTY_SUPPLIER_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSupplierName() {
    return supplierName;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSupplierName(String supplierName) {
    this.supplierName = supplierName;
  }


  public BookingContractAgent displayPriceQuote(QuoteAgent displayPriceQuote) {
    
    this.displayPriceQuote = displayPriceQuote;
    return this;
  }

   /**
   * Get displayPriceQuote
   * @return displayPriceQuote
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_DISPLAY_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public QuoteAgent getDisplayPriceQuote() {
    return displayPriceQuote;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDisplayPriceQuote(QuoteAgent displayPriceQuote) {
    this.displayPriceQuote = displayPriceQuote;
  }


  public BookingContractAgent supplierPriceQuote(QuoteAgent supplierPriceQuote) {
    
    this.supplierPriceQuote = supplierPriceQuote;
    return this;
  }

   /**
   * Get supplierPriceQuote
   * @return supplierPriceQuote
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_SUPPLIER_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public QuoteAgent getSupplierPriceQuote() {
    return supplierPriceQuote;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSupplierPriceQuote(QuoteAgent supplierPriceQuote) {
    this.supplierPriceQuote = supplierPriceQuote;
  }


  public BookingContractAgent internalPriceQuote(QuoteAgent internalPriceQuote) {
    
    this.internalPriceQuote = internalPriceQuote;
    return this;
  }

   /**
   * Get internalPriceQuote
   * @return internalPriceQuote
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_INTERNAL_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public QuoteAgent getInternalPriceQuote() {
    return internalPriceQuote;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInternalPriceQuote(QuoteAgent internalPriceQuote) {
    this.internalPriceQuote = internalPriceQuote;
  }


  public BookingContractAgent capturePriceQuote(QuoteAgent capturePriceQuote) {
    
    this.capturePriceQuote = capturePriceQuote;
    return this;
  }

   /**
   * Get capturePriceQuote
   * @return capturePriceQuote
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_CAPTURE_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public QuoteAgent getCapturePriceQuote() {
    return capturePriceQuote;
  }


  @JsonProperty(JSON_PROPERTY_CAPTURE_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCapturePriceQuote(QuoteAgent capturePriceQuote) {
    this.capturePriceQuote = capturePriceQuote;
  }


  public BookingContractAgent itemList(List<BookingContractItemAgent> itemList) {
    
    this.itemList = itemList;
    return this;
  }

  public BookingContractAgent addItemListItem(BookingContractItemAgent itemListItem) {
    this.itemList.add(itemListItem);
    return this;
  }

   /**
   * Holds one booking line item for a specific supplier.
   * @return itemList
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
 @Size(min=1,max=2147483647)  @ApiModelProperty(required = true, value = "Holds one booking line item for a specific supplier.")
  @JsonProperty(JSON_PROPERTY_ITEM_LIST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<BookingContractItemAgent> getItemList() {
    return itemList;
  }


  @JsonProperty(JSON_PROPERTY_ITEM_LIST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setItemList(List<BookingContractItemAgent> itemList) {
    this.itemList = itemList;
  }


  public BookingContractAgent externalSupplierIdentifier(String externalSupplierIdentifier) {
    
    this.externalSupplierIdentifier = externalSupplierIdentifier;
    return this;
  }

   /**
   * Contract creator can choose to geoname this record with her own identifier
   * @return externalSupplierIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "supplier-a", value = "Contract creator can choose to geoname this record with her own identifier")
  @JsonProperty(JSON_PROPERTY_EXTERNAL_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getExternalSupplierIdentifier() {
    return externalSupplierIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_EXTERNAL_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExternalSupplierIdentifier(String externalSupplierIdentifier) {
    this.externalSupplierIdentifier = externalSupplierIdentifier;
  }


  public BookingContractAgent externalSupplierBookingCode(String externalSupplierBookingCode) {
    
    this.externalSupplierBookingCode = externalSupplierBookingCode;
    return this;
  }

   /**
   * External booking code generated by the affiliate
   * @return externalSupplierBookingCode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "external-booking-code-1", value = "External booking code generated by the affiliate")
  @JsonProperty(JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getExternalSupplierBookingCode() {
    return externalSupplierBookingCode;
  }


  @JsonProperty(JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExternalSupplierBookingCode(String externalSupplierBookingCode) {
    this.externalSupplierBookingCode = externalSupplierBookingCode;
  }


  public BookingContractAgent payment(BookingContractPaymentDetailsAgent payment) {
    
    this.payment = payment;
    return this;
  }

   /**
   * Get payment
   * @return payment
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PAYMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BookingContractPaymentDetailsAgent getPayment() {
    return payment;
  }


  @JsonProperty(JSON_PROPERTY_PAYMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPayment(BookingContractPaymentDetailsAgent payment) {
    this.payment = payment;
  }


  public BookingContractAgent cancelled(Boolean cancelled) {
    
    this.cancelled = cancelled;
    return this;
  }

   /**
   * Optional geoname externalIdentifier to remote inventory.
   * @return cancelled
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Optional geoname externalIdentifier to remote inventory.")
  @JsonProperty(JSON_PROPERTY_CANCELLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancelled() {
    return cancelled;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancelled(Boolean cancelled) {
    this.cancelled = cancelled;
  }


  public BookingContractAgent cancelledOn(java.time.LocalDateTime cancelledOn) {
    
    this.cancelledOn = cancelledOn;
    return this;
  }

   /**
   * When the booking was cancelled.
   * @return cancelledOn
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "When the booking was cancelled.")
  @JsonProperty(JSON_PROPERTY_CANCELLED_ON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getCancelledOn() {
    return cancelledOn;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLED_ON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancelledOn(java.time.LocalDateTime cancelledOn) {
    this.cancelledOn = cancelledOn;
  }


  public BookingContractAgent canceller(CancellerEnum canceller) {
    
    this.canceller = canceller;
    return this;
  }

   /**
   * Type of entity that cancelled the booking.
   * @return canceller
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Type of entity that cancelled the booking.")
  @JsonProperty(JSON_PROPERTY_CANCELLER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CancellerEnum getCanceller() {
    return canceller;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCanceller(CancellerEnum canceller) {
    this.canceller = canceller;
  }


  public BookingContractAgent cancellationType(CancellationTypeEnum cancellationType) {
    
    this.cancellationType = cancellationType;
    return this;
  }

   /**
   * Reason type.
   * @return cancellationType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Reason type.")
  @JsonProperty(JSON_PROPERTY_CANCELLATION_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CancellationTypeEnum getCancellationType() {
    return cancellationType;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLATION_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellationType(CancellationTypeEnum cancellationType) {
    this.cancellationType = cancellationType;
  }


  public BookingContractAgent cancellerUserIdentifier(String cancellerUserIdentifier) {
    
    this.cancellerUserIdentifier = cancellerUserIdentifier;
    return this;
  }

   /**
   * User identifier that cancelled the entity.
   * @return cancellerUserIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "User identifier that cancelled the entity.")
  @JsonProperty(JSON_PROPERTY_CANCELLER_USER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCancellerUserIdentifier() {
    return cancellerUserIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLER_USER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellerUserIdentifier(String cancellerUserIdentifier) {
    this.cancellerUserIdentifier = cancellerUserIdentifier;
  }


  public BookingContractAgent cancelReason(String cancelReason) {
    
    this.cancelReason = cancelReason;
    return this;
  }

   /**
   * Reason for cancellation.
   * @return cancelReason
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Reason for cancellation.")
  @JsonProperty(JSON_PROPERTY_CANCEL_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCancelReason() {
    return cancelReason;
  }


  @JsonProperty(JSON_PROPERTY_CANCEL_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancelReason(String cancelReason) {
    this.cancelReason = cancelReason;
  }


  public BookingContractAgent fundsProcessed(Boolean fundsProcessed) {
    
    this.fundsProcessed = fundsProcessed;
    return this;
  }

   /**
   * Whether a funds transfer request has been created for this booking.
   * @return fundsProcessed
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Whether a funds transfer request has been created for this booking.")
  @JsonProperty(JSON_PROPERTY_FUNDS_PROCESSED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getFundsProcessed() {
    return fundsProcessed;
  }


  @JsonProperty(JSON_PROPERTY_FUNDS_PROCESSED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFundsProcessed(Boolean fundsProcessed) {
    this.fundsProcessed = fundsProcessed;
  }


  public BookingContractAgent refunds(List<RefundAgent> refunds) {
    
    this.refunds = refunds;
    return this;
  }

  public BookingContractAgent addRefundsItem(RefundAgent refundsItem) {
    if (this.refunds == null) {
      this.refunds = new ArrayList<>();
    }
    this.refunds.add(refundsItem);
    return this;
  }

   /**
   * An optional list of refunds that occurred with this booking. If the refund amount(s) is the same as the total price, the booking also gets cancelled.
   * @return refunds
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "An optional list of refunds that occurred with this booking. If the refund amount(s) is the same as the total price, the booking also gets cancelled.")
  @JsonProperty(JSON_PROPERTY_REFUNDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<RefundAgent> getRefunds() {
    return refunds;
  }


  @JsonProperty(JSON_PROPERTY_REFUNDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRefunds(List<RefundAgent> refunds) {
    this.refunds = refunds;
  }


  public BookingContractAgent totalSourcePrice(MoneysAgent totalSourcePrice) {
    
    this.totalSourcePrice = totalSourcePrice;
    return this;
  }

   /**
   * Get totalSourcePrice
   * @return totalSourcePrice
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TOTAL_SOURCE_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MoneysAgent getTotalSourcePrice() {
    return totalSourcePrice;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_SOURCE_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalSourcePrice(MoneysAgent totalSourcePrice) {
    this.totalSourcePrice = totalSourcePrice;
  }


  public BookingContractAgent totalDisplayPrice(MoneysAgent totalDisplayPrice) {
    
    this.totalDisplayPrice = totalDisplayPrice;
    return this;
  }

   /**
   * Get totalDisplayPrice
   * @return totalDisplayPrice
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TOTAL_DISPLAY_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MoneysAgent getTotalDisplayPrice() {
    return totalDisplayPrice;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_DISPLAY_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalDisplayPrice(MoneysAgent totalDisplayPrice) {
    this.totalDisplayPrice = totalDisplayPrice;
  }


  public BookingContractAgent totalSupplierPrice(MoneysAgent totalSupplierPrice) {
    
    this.totalSupplierPrice = totalSupplierPrice;
    return this;
  }

   /**
   * Get totalSupplierPrice
   * @return totalSupplierPrice
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TOTAL_SUPPLIER_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MoneysAgent getTotalSupplierPrice() {
    return totalSupplierPrice;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_SUPPLIER_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalSupplierPrice(MoneysAgent totalSupplierPrice) {
    this.totalSupplierPrice = totalSupplierPrice;
  }


  public BookingContractAgent totalInternalPrice(MoneysAgent totalInternalPrice) {
    
    this.totalInternalPrice = totalInternalPrice;
    return this;
  }

   /**
   * Get totalInternalPrice
   * @return totalInternalPrice
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TOTAL_INTERNAL_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MoneysAgent getTotalInternalPrice() {
    return totalInternalPrice;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_INTERNAL_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalInternalPrice(MoneysAgent totalInternalPrice) {
    this.totalInternalPrice = totalInternalPrice;
  }


  public BookingContractAgent totalCapturePrice(MoneysAgent totalCapturePrice) {
    
    this.totalCapturePrice = totalCapturePrice;
    return this;
  }

   /**
   * Get totalCapturePrice
   * @return totalCapturePrice
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TOTAL_CAPTURE_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MoneysAgent getTotalCapturePrice() {
    return totalCapturePrice;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_CAPTURE_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalCapturePrice(MoneysAgent totalCapturePrice) {
    this.totalCapturePrice = totalCapturePrice;
  }


  public BookingContractAgent totalSourcePriceAfterRefund(MoneysAgent totalSourcePriceAfterRefund) {
    
    this.totalSourcePriceAfterRefund = totalSourcePriceAfterRefund;
    return this;
  }

   /**
   * Get totalSourcePriceAfterRefund
   * @return totalSourcePriceAfterRefund
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TOTAL_SOURCE_PRICE_AFTER_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MoneysAgent getTotalSourcePriceAfterRefund() {
    return totalSourcePriceAfterRefund;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_SOURCE_PRICE_AFTER_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalSourcePriceAfterRefund(MoneysAgent totalSourcePriceAfterRefund) {
    this.totalSourcePriceAfterRefund = totalSourcePriceAfterRefund;
  }


  public BookingContractAgent totalDisplayPriceAfterRefund(MoneysAgent totalDisplayPriceAfterRefund) {
    
    this.totalDisplayPriceAfterRefund = totalDisplayPriceAfterRefund;
    return this;
  }

   /**
   * Get totalDisplayPriceAfterRefund
   * @return totalDisplayPriceAfterRefund
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TOTAL_DISPLAY_PRICE_AFTER_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MoneysAgent getTotalDisplayPriceAfterRefund() {
    return totalDisplayPriceAfterRefund;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_DISPLAY_PRICE_AFTER_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalDisplayPriceAfterRefund(MoneysAgent totalDisplayPriceAfterRefund) {
    this.totalDisplayPriceAfterRefund = totalDisplayPriceAfterRefund;
  }


  public BookingContractAgent totalSupplierPriceAfterRefund(MoneysAgent totalSupplierPriceAfterRefund) {
    
    this.totalSupplierPriceAfterRefund = totalSupplierPriceAfterRefund;
    return this;
  }

   /**
   * Get totalSupplierPriceAfterRefund
   * @return totalSupplierPriceAfterRefund
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TOTAL_SUPPLIER_PRICE_AFTER_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MoneysAgent getTotalSupplierPriceAfterRefund() {
    return totalSupplierPriceAfterRefund;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_SUPPLIER_PRICE_AFTER_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalSupplierPriceAfterRefund(MoneysAgent totalSupplierPriceAfterRefund) {
    this.totalSupplierPriceAfterRefund = totalSupplierPriceAfterRefund;
  }


  public BookingContractAgent totalInternalPriceAfterRefund(MoneysAgent totalInternalPriceAfterRefund) {
    
    this.totalInternalPriceAfterRefund = totalInternalPriceAfterRefund;
    return this;
  }

   /**
   * Get totalInternalPriceAfterRefund
   * @return totalInternalPriceAfterRefund
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TOTAL_INTERNAL_PRICE_AFTER_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MoneysAgent getTotalInternalPriceAfterRefund() {
    return totalInternalPriceAfterRefund;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_INTERNAL_PRICE_AFTER_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalInternalPriceAfterRefund(MoneysAgent totalInternalPriceAfterRefund) {
    this.totalInternalPriceAfterRefund = totalInternalPriceAfterRefund;
  }


  public BookingContractAgent totalCapturePriceAfterRefund(MoneysAgent totalCapturePriceAfterRefund) {
    
    this.totalCapturePriceAfterRefund = totalCapturePriceAfterRefund;
    return this;
  }

   /**
   * Get totalCapturePriceAfterRefund
   * @return totalCapturePriceAfterRefund
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TOTAL_CAPTURE_PRICE_AFTER_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MoneysAgent getTotalCapturePriceAfterRefund() {
    return totalCapturePriceAfterRefund;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_CAPTURE_PRICE_AFTER_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalCapturePriceAfterRefund(MoneysAgent totalCapturePriceAfterRefund) {
    this.totalCapturePriceAfterRefund = totalCapturePriceAfterRefund;
  }


  public BookingContractAgent refundedSourcePrice(MoneysAgent refundedSourcePrice) {
    
    this.refundedSourcePrice = refundedSourcePrice;
    return this;
  }

   /**
   * Get refundedSourcePrice
   * @return refundedSourcePrice
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_REFUNDED_SOURCE_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MoneysAgent getRefundedSourcePrice() {
    return refundedSourcePrice;
  }


  @JsonProperty(JSON_PROPERTY_REFUNDED_SOURCE_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRefundedSourcePrice(MoneysAgent refundedSourcePrice) {
    this.refundedSourcePrice = refundedSourcePrice;
  }


  public BookingContractAgent refundedDisplayPrice(MoneysAgent refundedDisplayPrice) {
    
    this.refundedDisplayPrice = refundedDisplayPrice;
    return this;
  }

   /**
   * Get refundedDisplayPrice
   * @return refundedDisplayPrice
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_REFUNDED_DISPLAY_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MoneysAgent getRefundedDisplayPrice() {
    return refundedDisplayPrice;
  }


  @JsonProperty(JSON_PROPERTY_REFUNDED_DISPLAY_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRefundedDisplayPrice(MoneysAgent refundedDisplayPrice) {
    this.refundedDisplayPrice = refundedDisplayPrice;
  }


  public BookingContractAgent refundedSupplierPrice(MoneysAgent refundedSupplierPrice) {
    
    this.refundedSupplierPrice = refundedSupplierPrice;
    return this;
  }

   /**
   * Get refundedSupplierPrice
   * @return refundedSupplierPrice
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_REFUNDED_SUPPLIER_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MoneysAgent getRefundedSupplierPrice() {
    return refundedSupplierPrice;
  }


  @JsonProperty(JSON_PROPERTY_REFUNDED_SUPPLIER_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRefundedSupplierPrice(MoneysAgent refundedSupplierPrice) {
    this.refundedSupplierPrice = refundedSupplierPrice;
  }


  public BookingContractAgent refundedInternalPrice(MoneysAgent refundedInternalPrice) {
    
    this.refundedInternalPrice = refundedInternalPrice;
    return this;
  }

   /**
   * Get refundedInternalPrice
   * @return refundedInternalPrice
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_REFUNDED_INTERNAL_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MoneysAgent getRefundedInternalPrice() {
    return refundedInternalPrice;
  }


  @JsonProperty(JSON_PROPERTY_REFUNDED_INTERNAL_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRefundedInternalPrice(MoneysAgent refundedInternalPrice) {
    this.refundedInternalPrice = refundedInternalPrice;
  }


  public BookingContractAgent refundedCapturePrice(MoneysAgent refundedCapturePrice) {
    
    this.refundedCapturePrice = refundedCapturePrice;
    return this;
  }

   /**
   * Get refundedCapturePrice
   * @return refundedCapturePrice
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_REFUNDED_CAPTURE_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MoneysAgent getRefundedCapturePrice() {
    return refundedCapturePrice;
  }


  @JsonProperty(JSON_PROPERTY_REFUNDED_CAPTURE_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRefundedCapturePrice(MoneysAgent refundedCapturePrice) {
    this.refundedCapturePrice = refundedCapturePrice;
  }


  public BookingContractAgent totalTokensEarned(Long totalTokensEarned) {
    
    this.totalTokensEarned = totalTokensEarned;
    return this;
  }

   /**
   * Total amount of tokens minted on this contract.
   * @return totalTokensEarned
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Total amount of tokens minted on this contract.")
  @JsonProperty(JSON_PROPERTY_TOTAL_TOKENS_EARNED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getTotalTokensEarned() {
    return totalTokensEarned;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_TOKENS_EARNED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalTokensEarned(Long totalTokensEarned) {
    this.totalTokensEarned = totalTokensEarned;
  }


  public BookingContractAgent cancellableWithNoCharges(Boolean cancellableWithNoCharges) {
    
    this.cancellableWithNoCharges = cancellableWithNoCharges;
    return this;
  }

   /**
   * Whether the cancellation comes at no cost to the traveler.
   * @return cancellableWithNoCharges
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Whether the cancellation comes at no cost to the traveler.")
  @JsonProperty(JSON_PROPERTY_CANCELLABLE_WITH_NO_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableWithNoCharges() {
    return cancellableWithNoCharges;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_WITH_NO_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableWithNoCharges(Boolean cancellableWithNoCharges) {
    this.cancellableWithNoCharges = cancellableWithNoCharges;
  }


  public BookingContractAgent isCancellableWithPotentialCharges(Boolean isCancellableWithPotentialCharges) {
    
    this.isCancellableWithPotentialCharges = isCancellableWithPotentialCharges;
    return this;
  }

   /**
   * Whether a cancellation comes with partial charges. I.e. Only some of the items in contract are not fully refundable.
   * @return isCancellableWithPotentialCharges
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Whether a cancellation comes with partial charges. I.e. Only some of the items in contract are not fully refundable.")
  @JsonProperty(JSON_PROPERTY_IS_CANCELLABLE_WITH_POTENTIAL_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIsCancellableWithPotentialCharges() {
    return isCancellableWithPotentialCharges;
  }


  @JsonProperty(JSON_PROPERTY_IS_CANCELLABLE_WITH_POTENTIAL_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIsCancellableWithPotentialCharges(Boolean isCancellableWithPotentialCharges) {
    this.isCancellableWithPotentialCharges = isCancellableWithPotentialCharges;
  }


  public BookingContractAgent commissionableTotalSourceAmount(MoneysAgent commissionableTotalSourceAmount) {
    
    this.commissionableTotalSourceAmount = commissionableTotalSourceAmount;
    return this;
  }

   /**
   * Get commissionableTotalSourceAmount
   * @return commissionableTotalSourceAmount
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE_TOTAL_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MoneysAgent getCommissionableTotalSourceAmount() {
    return commissionableTotalSourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE_TOTAL_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCommissionableTotalSourceAmount(MoneysAgent commissionableTotalSourceAmount) {
    this.commissionableTotalSourceAmount = commissionableTotalSourceAmount;
  }


  public BookingContractAgent commissionableTotalCaptureAmount(MoneysAgent commissionableTotalCaptureAmount) {
    
    this.commissionableTotalCaptureAmount = commissionableTotalCaptureAmount;
    return this;
  }

   /**
   * Get commissionableTotalCaptureAmount
   * @return commissionableTotalCaptureAmount
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE_TOTAL_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MoneysAgent getCommissionableTotalCaptureAmount() {
    return commissionableTotalCaptureAmount;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE_TOTAL_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCommissionableTotalCaptureAmount(MoneysAgent commissionableTotalCaptureAmount) {
    this.commissionableTotalCaptureAmount = commissionableTotalCaptureAmount;
  }


  public BookingContractAgent commissionableTotalDisplayAmount(MoneysAgent commissionableTotalDisplayAmount) {
    
    this.commissionableTotalDisplayAmount = commissionableTotalDisplayAmount;
    return this;
  }

   /**
   * Get commissionableTotalDisplayAmount
   * @return commissionableTotalDisplayAmount
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE_TOTAL_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MoneysAgent getCommissionableTotalDisplayAmount() {
    return commissionableTotalDisplayAmount;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE_TOTAL_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCommissionableTotalDisplayAmount(MoneysAgent commissionableTotalDisplayAmount) {
    this.commissionableTotalDisplayAmount = commissionableTotalDisplayAmount;
  }


  public BookingContractAgent commissionableTotalSupplierAmount(MoneysAgent commissionableTotalSupplierAmount) {
    
    this.commissionableTotalSupplierAmount = commissionableTotalSupplierAmount;
    return this;
  }

   /**
   * Get commissionableTotalSupplierAmount
   * @return commissionableTotalSupplierAmount
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE_TOTAL_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MoneysAgent getCommissionableTotalSupplierAmount() {
    return commissionableTotalSupplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE_TOTAL_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCommissionableTotalSupplierAmount(MoneysAgent commissionableTotalSupplierAmount) {
    this.commissionableTotalSupplierAmount = commissionableTotalSupplierAmount;
  }


  public BookingContractAgent commissionableTotalInternalAmount(MoneysAgent commissionableTotalInternalAmount) {
    
    this.commissionableTotalInternalAmount = commissionableTotalInternalAmount;
    return this;
  }

   /**
   * Get commissionableTotalInternalAmount
   * @return commissionableTotalInternalAmount
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE_TOTAL_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MoneysAgent getCommissionableTotalInternalAmount() {
    return commissionableTotalInternalAmount;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE_TOTAL_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCommissionableTotalInternalAmount(MoneysAgent commissionableTotalInternalAmount) {
    this.commissionableTotalInternalAmount = commissionableTotalInternalAmount;
  }


  public BookingContractAgent cancellableBySupplier(Boolean cancellableBySupplier) {
    
    this.cancellableBySupplier = cancellableBySupplier;
    return this;
  }

   /**
   * Whether the booking can still be cancelled completely by the supplier.
   * @return cancellableBySupplier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Whether the booking can still be cancelled completely by the supplier.")
  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableBySupplier() {
    return cancellableBySupplier;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableBySupplier(Boolean cancellableBySupplier) {
    this.cancellableBySupplier = cancellableBySupplier;
  }


  public BookingContractAgent cancellableByTraveler(Boolean cancellableByTraveler) {
    
    this.cancellableByTraveler = cancellableByTraveler;
    return this;
  }

   /**
   * Whether the booking can still be cancelled completely by the traveller.
   * @return cancellableByTraveler
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Whether the booking can still be cancelled completely by the traveller.")
  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_TRAVELER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableByTraveler() {
    return cancellableByTraveler;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_TRAVELER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableByTraveler(Boolean cancellableByTraveler) {
    this.cancellableByTraveler = cancellableByTraveler;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BookingContractAgent bookingContractAgent = (BookingContractAgent) o;
    return Objects.equals(this.bookingContractIdentifier, bookingContractAgent.bookingContractIdentifier) &&
        Objects.equals(this.createdDate, bookingContractAgent.createdDate) &&
        Objects.equals(this.lastUpdate, bookingContractAgent.lastUpdate) &&
        Objects.equals(this.ipAddress, bookingContractAgent.ipAddress) &&
        Objects.equals(this.traceId, bookingContractAgent.traceId) &&
        Objects.equals(this.sourceUrl, bookingContractAgent.sourceUrl) &&
        Objects.equals(this.identifier, bookingContractAgent.identifier) &&
        Objects.equals(this.supplierIdentifier, bookingContractAgent.supplierIdentifier) &&
        Objects.equals(this.supplierName, bookingContractAgent.supplierName) &&
        Objects.equals(this.displayPriceQuote, bookingContractAgent.displayPriceQuote) &&
        Objects.equals(this.supplierPriceQuote, bookingContractAgent.supplierPriceQuote) &&
        Objects.equals(this.internalPriceQuote, bookingContractAgent.internalPriceQuote) &&
        Objects.equals(this.capturePriceQuote, bookingContractAgent.capturePriceQuote) &&
        Objects.equals(this.itemList, bookingContractAgent.itemList) &&
        Objects.equals(this.externalSupplierIdentifier, bookingContractAgent.externalSupplierIdentifier) &&
        Objects.equals(this.externalSupplierBookingCode, bookingContractAgent.externalSupplierBookingCode) &&
        Objects.equals(this.payment, bookingContractAgent.payment) &&
        Objects.equals(this.cancelled, bookingContractAgent.cancelled) &&
        Objects.equals(this.cancelledOn, bookingContractAgent.cancelledOn) &&
        Objects.equals(this.canceller, bookingContractAgent.canceller) &&
        Objects.equals(this.cancellationType, bookingContractAgent.cancellationType) &&
        Objects.equals(this.cancellerUserIdentifier, bookingContractAgent.cancellerUserIdentifier) &&
        Objects.equals(this.cancelReason, bookingContractAgent.cancelReason) &&
        Objects.equals(this.fundsProcessed, bookingContractAgent.fundsProcessed) &&
        Objects.equals(this.refunds, bookingContractAgent.refunds) &&
        Objects.equals(this.totalSourcePrice, bookingContractAgent.totalSourcePrice) &&
        Objects.equals(this.totalDisplayPrice, bookingContractAgent.totalDisplayPrice) &&
        Objects.equals(this.totalSupplierPrice, bookingContractAgent.totalSupplierPrice) &&
        Objects.equals(this.totalInternalPrice, bookingContractAgent.totalInternalPrice) &&
        Objects.equals(this.totalCapturePrice, bookingContractAgent.totalCapturePrice) &&
        Objects.equals(this.totalSourcePriceAfterRefund, bookingContractAgent.totalSourcePriceAfterRefund) &&
        Objects.equals(this.totalDisplayPriceAfterRefund, bookingContractAgent.totalDisplayPriceAfterRefund) &&
        Objects.equals(this.totalSupplierPriceAfterRefund, bookingContractAgent.totalSupplierPriceAfterRefund) &&
        Objects.equals(this.totalInternalPriceAfterRefund, bookingContractAgent.totalInternalPriceAfterRefund) &&
        Objects.equals(this.totalCapturePriceAfterRefund, bookingContractAgent.totalCapturePriceAfterRefund) &&
        Objects.equals(this.refundedSourcePrice, bookingContractAgent.refundedSourcePrice) &&
        Objects.equals(this.refundedDisplayPrice, bookingContractAgent.refundedDisplayPrice) &&
        Objects.equals(this.refundedSupplierPrice, bookingContractAgent.refundedSupplierPrice) &&
        Objects.equals(this.refundedInternalPrice, bookingContractAgent.refundedInternalPrice) &&
        Objects.equals(this.refundedCapturePrice, bookingContractAgent.refundedCapturePrice) &&
        Objects.equals(this.totalTokensEarned, bookingContractAgent.totalTokensEarned) &&
        Objects.equals(this.cancellableWithNoCharges, bookingContractAgent.cancellableWithNoCharges) &&
        Objects.equals(this.isCancellableWithPotentialCharges, bookingContractAgent.isCancellableWithPotentialCharges) &&
        Objects.equals(this.commissionableTotalSourceAmount, bookingContractAgent.commissionableTotalSourceAmount) &&
        Objects.equals(this.commissionableTotalCaptureAmount, bookingContractAgent.commissionableTotalCaptureAmount) &&
        Objects.equals(this.commissionableTotalDisplayAmount, bookingContractAgent.commissionableTotalDisplayAmount) &&
        Objects.equals(this.commissionableTotalSupplierAmount, bookingContractAgent.commissionableTotalSupplierAmount) &&
        Objects.equals(this.commissionableTotalInternalAmount, bookingContractAgent.commissionableTotalInternalAmount) &&
        Objects.equals(this.cancellableBySupplier, bookingContractAgent.cancellableBySupplier) &&
        Objects.equals(this.cancellableByTraveler, bookingContractAgent.cancellableByTraveler);
  }

  @Override
  public int hashCode() {
    return Objects.hash(bookingContractIdentifier, createdDate, lastUpdate, ipAddress, traceId, sourceUrl, identifier, supplierIdentifier, supplierName, displayPriceQuote, supplierPriceQuote, internalPriceQuote, capturePriceQuote, itemList, externalSupplierIdentifier, externalSupplierBookingCode, payment, cancelled, cancelledOn, canceller, cancellationType, cancellerUserIdentifier, cancelReason, fundsProcessed, refunds, totalSourcePrice, totalDisplayPrice, totalSupplierPrice, totalInternalPrice, totalCapturePrice, totalSourcePriceAfterRefund, totalDisplayPriceAfterRefund, totalSupplierPriceAfterRefund, totalInternalPriceAfterRefund, totalCapturePriceAfterRefund, refundedSourcePrice, refundedDisplayPrice, refundedSupplierPrice, refundedInternalPrice, refundedCapturePrice, totalTokensEarned, cancellableWithNoCharges, isCancellableWithPotentialCharges, commissionableTotalSourceAmount, commissionableTotalCaptureAmount, commissionableTotalDisplayAmount, commissionableTotalSupplierAmount, commissionableTotalInternalAmount, cancellableBySupplier, cancellableByTraveler);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BookingContractAgent {\n");
    sb.append("    bookingContractIdentifier: ").append(toIndentedString(bookingContractIdentifier)).append("\n");
    sb.append("    createdDate: ").append(toIndentedString(createdDate)).append("\n");
    sb.append("    lastUpdate: ").append(toIndentedString(lastUpdate)).append("\n");
    sb.append("    ipAddress: ").append(toIndentedString(ipAddress)).append("\n");
    sb.append("    traceId: ").append(toIndentedString(traceId)).append("\n");
    sb.append("    sourceUrl: ").append(toIndentedString(sourceUrl)).append("\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    supplierIdentifier: ").append(toIndentedString(supplierIdentifier)).append("\n");
    sb.append("    supplierName: ").append(toIndentedString(supplierName)).append("\n");
    sb.append("    displayPriceQuote: ").append(toIndentedString(displayPriceQuote)).append("\n");
    sb.append("    supplierPriceQuote: ").append(toIndentedString(supplierPriceQuote)).append("\n");
    sb.append("    internalPriceQuote: ").append(toIndentedString(internalPriceQuote)).append("\n");
    sb.append("    capturePriceQuote: ").append(toIndentedString(capturePriceQuote)).append("\n");
    sb.append("    itemList: ").append(toIndentedString(itemList)).append("\n");
    sb.append("    externalSupplierIdentifier: ").append(toIndentedString(externalSupplierIdentifier)).append("\n");
    sb.append("    externalSupplierBookingCode: ").append(toIndentedString(externalSupplierBookingCode)).append("\n");
    sb.append("    payment: ").append(toIndentedString(payment)).append("\n");
    sb.append("    cancelled: ").append(toIndentedString(cancelled)).append("\n");
    sb.append("    cancelledOn: ").append(toIndentedString(cancelledOn)).append("\n");
    sb.append("    canceller: ").append(toIndentedString(canceller)).append("\n");
    sb.append("    cancellationType: ").append(toIndentedString(cancellationType)).append("\n");
    sb.append("    cancellerUserIdentifier: ").append(toIndentedString(cancellerUserIdentifier)).append("\n");
    sb.append("    cancelReason: ").append(toIndentedString(cancelReason)).append("\n");
    sb.append("    fundsProcessed: ").append(toIndentedString(fundsProcessed)).append("\n");
    sb.append("    refunds: ").append(toIndentedString(refunds)).append("\n");
    sb.append("    totalSourcePrice: ").append(toIndentedString(totalSourcePrice)).append("\n");
    sb.append("    totalDisplayPrice: ").append(toIndentedString(totalDisplayPrice)).append("\n");
    sb.append("    totalSupplierPrice: ").append(toIndentedString(totalSupplierPrice)).append("\n");
    sb.append("    totalInternalPrice: ").append(toIndentedString(totalInternalPrice)).append("\n");
    sb.append("    totalCapturePrice: ").append(toIndentedString(totalCapturePrice)).append("\n");
    sb.append("    totalSourcePriceAfterRefund: ").append(toIndentedString(totalSourcePriceAfterRefund)).append("\n");
    sb.append("    totalDisplayPriceAfterRefund: ").append(toIndentedString(totalDisplayPriceAfterRefund)).append("\n");
    sb.append("    totalSupplierPriceAfterRefund: ").append(toIndentedString(totalSupplierPriceAfterRefund)).append("\n");
    sb.append("    totalInternalPriceAfterRefund: ").append(toIndentedString(totalInternalPriceAfterRefund)).append("\n");
    sb.append("    totalCapturePriceAfterRefund: ").append(toIndentedString(totalCapturePriceAfterRefund)).append("\n");
    sb.append("    refundedSourcePrice: ").append(toIndentedString(refundedSourcePrice)).append("\n");
    sb.append("    refundedDisplayPrice: ").append(toIndentedString(refundedDisplayPrice)).append("\n");
    sb.append("    refundedSupplierPrice: ").append(toIndentedString(refundedSupplierPrice)).append("\n");
    sb.append("    refundedInternalPrice: ").append(toIndentedString(refundedInternalPrice)).append("\n");
    sb.append("    refundedCapturePrice: ").append(toIndentedString(refundedCapturePrice)).append("\n");
    sb.append("    totalTokensEarned: ").append(toIndentedString(totalTokensEarned)).append("\n");
    sb.append("    cancellableWithNoCharges: ").append(toIndentedString(cancellableWithNoCharges)).append("\n");
    sb.append("    isCancellableWithPotentialCharges: ").append(toIndentedString(isCancellableWithPotentialCharges)).append("\n");
    sb.append("    commissionableTotalSourceAmount: ").append(toIndentedString(commissionableTotalSourceAmount)).append("\n");
    sb.append("    commissionableTotalCaptureAmount: ").append(toIndentedString(commissionableTotalCaptureAmount)).append("\n");
    sb.append("    commissionableTotalDisplayAmount: ").append(toIndentedString(commissionableTotalDisplayAmount)).append("\n");
    sb.append("    commissionableTotalSupplierAmount: ").append(toIndentedString(commissionableTotalSupplierAmount)).append("\n");
    sb.append("    commissionableTotalInternalAmount: ").append(toIndentedString(commissionableTotalInternalAmount)).append("\n");
    sb.append("    cancellableBySupplier: ").append(toIndentedString(cancellableBySupplier)).append("\n");
    sb.append("    cancellableByTraveler: ").append(toIndentedString(cancellableByTraveler)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

