/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release   # Booking API Welcome to the Booking Engine API - A programmer-friendly way to book inventory that was found on our platform. We take great care in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive payment-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 24.3.2
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.booking.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.time.LocalDateTime;
import travel.wink.sdk.booking.model.MoneysAgent;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Refund objects allow you to refund a charge that has previously been created but not yet refunded. Funds will be refunded to the credit or debit card that was originally charged.
 */
@ApiModel(description = "Refund objects allow you to refund a charge that has previously been created but not yet refunded. Funds will be refunded to the credit or debit card that was originally charged.")
@JsonPropertyOrder({
  RefundAgent.JSON_PROPERTY_IDENTIFIER,
  RefundAgent.JSON_PROPERTY_ACQUIRER_REFUND_IDENTIFIER,
  RefundAgent.JSON_PROPERTY_REFUND,
  RefundAgent.JSON_PROPERTY_CREATED,
  RefundAgent.JSON_PROPERTY_DESCRIPTION,
  RefundAgent.JSON_PROPERTY_REASON_TYPE,
  RefundAgent.JSON_PROPERTY_STATUS_TYPE,
  RefundAgent.JSON_PROPERTY_REQUEST_TYPE,
  RefundAgent.JSON_PROPERTY_REQUEST_STATUS,
  RefundAgent.JSON_PROPERTY_REQUEST_RESPONSE,
  RefundAgent.JSON_PROPERTY_RECEIPT_URL
})
@JsonTypeName("Refund_Agent")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-03-10T10:48:08.191600840+07:00[Asia/Bangkok]")
public class RefundAgent {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private String identifier;

  public static final String JSON_PROPERTY_ACQUIRER_REFUND_IDENTIFIER = "acquirerRefundIdentifier";
  private String acquirerRefundIdentifier;

  public static final String JSON_PROPERTY_REFUND = "refund";
  private MoneysAgent refund;

  public static final String JSON_PROPERTY_CREATED = "created";
  private java.time.LocalDateTime created;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  /**
   * A description of the refund that can be displayed to booker
   */
  public enum ReasonTypeEnum {
    DUPLICATE("DUPLICATE"),
    
    FRAUDULENT("FRAUDULENT"),
    
    REQUESTED_BY_CUSTOMER("REQUESTED_BY_CUSTOMER"),
    
    GUEST_COMPLAINT("GUEST_COMPLAINT"),
    
    GUEST_BOOKED_INCORRECT_DATE("GUEST_BOOKED_INCORRECT_DATE"),
    
    GUEST_SICK("GUEST_SICK"),
    
    OVERBOOKING("OVERBOOKING"),
    
    EMERGENCY("EMERGENCY"),
    
    FLIGHT_CANCELLED("FLIGHT_CANCELLED"),
    
    DEATH_IN_FAMILY("DEATH_IN_FAMILY"),
    
    OTHER("OTHER"),
    
    EXPIRED_UNCAPTURED_CHARGE("EXPIRED_UNCAPTURED_CHARGE");

    private String value;

    ReasonTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ReasonTypeEnum fromValue(String value) {
      for (ReasonTypeEnum b : ReasonTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_REASON_TYPE = "reasonType";
  private ReasonTypeEnum reasonType;

  /**
   * Status of the refund
   */
  public enum StatusTypeEnum {
    PENDING("PENDING"),
    
    SUCCEEDED("SUCCEEDED"),
    
    CANCELED("CANCELED"),
    
    REQUIRES_ACTION("REQUIRES_ACTION"),
    
    FAILED("FAILED");

    private String value;

    StatusTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusTypeEnum fromValue(String value) {
      for (StatusTypeEnum b : StatusTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STATUS_TYPE = "statusType";
  private StatusTypeEnum statusType;

  /**
   * The entity making the refund request
   */
  public enum RequestTypeEnum {
    SUPPLIER("BY_SUPPLIER"),
    
    ADMIN("BY_ADMIN"),
    
    STRIPE("BY_STRIPE"),
    
    SYSTEM("BY_SYSTEM");

    private String value;

    RequestTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static RequestTypeEnum fromValue(String value) {
      for (RequestTypeEnum b : RequestTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_REQUEST_TYPE = "requestType";
  private RequestTypeEnum requestType;

  /**
   * Status of the refund request
   */
  public enum RequestStatusEnum {
    PENDING("PENDING"),
    
    APPROVED("APPROVED"),
    
    REJECTED("REJECTED");

    private String value;

    RequestStatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static RequestStatusEnum fromValue(String value) {
      for (RequestStatusEnum b : RequestStatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_REQUEST_STATUS = "requestStatus";
  private RequestStatusEnum requestStatus;

  public static final String JSON_PROPERTY_REQUEST_RESPONSE = "requestResponse";
  private String requestResponse;

  public static final String JSON_PROPERTY_RECEIPT_URL = "receiptUrl";
  private String receiptUrl;

  public RefundAgent() { 
  }

  public RefundAgent identifier(String identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * A unique identifier
   * @return identifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "refund-1", required = true, value = "A unique identifier")
  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifier(String identifier) {
    this.identifier = identifier;
  }


  public RefundAgent acquirerRefundIdentifier(String acquirerRefundIdentifier) {
    
    this.acquirerRefundIdentifier = acquirerRefundIdentifier;
    return this;
  }

   /**
   * The acquirer refund identifier. Will get attached once it comes in on the webhook.
   * @return acquirerRefundIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "r-123456", value = "The acquirer refund identifier. Will get attached once it comes in on the webhook.")
  @JsonProperty(JSON_PROPERTY_ACQUIRER_REFUND_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAcquirerRefundIdentifier() {
    return acquirerRefundIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_ACQUIRER_REFUND_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAcquirerRefundIdentifier(String acquirerRefundIdentifier) {
    this.acquirerRefundIdentifier = acquirerRefundIdentifier;
  }


  public RefundAgent refund(MoneysAgent refund) {
    
    this.refund = refund;
    return this;
  }

   /**
   * Get refund
   * @return refund
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_REFUND)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public MoneysAgent getRefund() {
    return refund;
  }


  @JsonProperty(JSON_PROPERTY_REFUND)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRefund(MoneysAgent refund) {
    this.refund = refund;
  }


  public RefundAgent created(java.time.LocalDateTime created) {
    
    this.created = created;
    return this;
  }

   /**
   * When the amount was refunded
   * @return created
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "When the amount was refunded")
  @JsonProperty(JSON_PROPERTY_CREATED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public java.time.LocalDateTime getCreated() {
    return created;
  }


  @JsonProperty(JSON_PROPERTY_CREATED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCreated(java.time.LocalDateTime created) {
    this.created = created;
  }


  public RefundAgent description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * A description of the refund that can be displayed to booker
   * @return description
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "Customer made a mistake", required = true, value = "A description of the refund that can be displayed to booker")
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDescription(String description) {
    this.description = description;
  }


  public RefundAgent reasonType(ReasonTypeEnum reasonType) {
    
    this.reasonType = reasonType;
    return this;
  }

   /**
   * A description of the refund that can be displayed to booker
   * @return reasonType
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "DUPLICATE", required = true, value = "A description of the refund that can be displayed to booker")
  @JsonProperty(JSON_PROPERTY_REASON_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ReasonTypeEnum getReasonType() {
    return reasonType;
  }


  @JsonProperty(JSON_PROPERTY_REASON_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setReasonType(ReasonTypeEnum reasonType) {
    this.reasonType = reasonType;
  }


  public RefundAgent statusType(StatusTypeEnum statusType) {
    
    this.statusType = statusType;
    return this;
  }

   /**
   * Status of the refund
   * @return statusType
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "SUCCEEDED", required = true, value = "Status of the refund")
  @JsonProperty(JSON_PROPERTY_STATUS_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public StatusTypeEnum getStatusType() {
    return statusType;
  }


  @JsonProperty(JSON_PROPERTY_STATUS_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStatusType(StatusTypeEnum statusType) {
    this.statusType = statusType;
  }


  public RefundAgent requestType(RequestTypeEnum requestType) {
    
    this.requestType = requestType;
    return this;
  }

   /**
   * The entity making the refund request
   * @return requestType
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "BY_ADMIN", required = true, value = "The entity making the refund request")
  @JsonProperty(JSON_PROPERTY_REQUEST_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public RequestTypeEnum getRequestType() {
    return requestType;
  }


  @JsonProperty(JSON_PROPERTY_REQUEST_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRequestType(RequestTypeEnum requestType) {
    this.requestType = requestType;
  }


  public RefundAgent requestStatus(RequestStatusEnum requestStatus) {
    
    this.requestStatus = requestStatus;
    return this;
  }

   /**
   * Status of the refund request
   * @return requestStatus
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "APPROVED", required = true, value = "Status of the refund request")
  @JsonProperty(JSON_PROPERTY_REQUEST_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public RequestStatusEnum getRequestStatus() {
    return requestStatus;
  }


  @JsonProperty(JSON_PROPERTY_REQUEST_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRequestStatus(RequestStatusEnum requestStatus) {
    this.requestStatus = requestStatus;
  }


  public RefundAgent requestResponse(String requestResponse) {
    
    this.requestResponse = requestResponse;
    return this;
  }

   /**
   * Admin may choose to respond to the refund request made by the hotel
   * @return requestResponse
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "We have rejected your request. Your cancellation policy does not warrant a manual refund.", required = true, value = "Admin may choose to respond to the refund request made by the hotel")
  @JsonProperty(JSON_PROPERTY_REQUEST_RESPONSE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRequestResponse() {
    return requestResponse;
  }


  @JsonProperty(JSON_PROPERTY_REQUEST_RESPONSE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRequestResponse(String requestResponse) {
    this.requestResponse = requestResponse;
  }


  public RefundAgent receiptUrl(String receiptUrl) {
    
    this.receiptUrl = receiptUrl;
    return this;
  }

   /**
   * This is the receipt url that contains a friendly web confirmation page. Comes in on the webhook.
   * @return receiptUrl
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "https://pay.stripe.com/receipts/payment/CAcaFwoVYWNjdF8xSXcxazVBQ3F2UW9nN1IxKIPqo54GMgbHKn45YQY6LBbCZ62655YzamuWDVeWAaw7uApCrxewxjSsZX4C9Lef5jY9JeYFrOVx3IaI", value = "This is the receipt url that contains a friendly web confirmation page. Comes in on the webhook.")
  @JsonProperty(JSON_PROPERTY_RECEIPT_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getReceiptUrl() {
    return receiptUrl;
  }


  @JsonProperty(JSON_PROPERTY_RECEIPT_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReceiptUrl(String receiptUrl) {
    this.receiptUrl = receiptUrl;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RefundAgent refundAgent = (RefundAgent) o;
    return Objects.equals(this.identifier, refundAgent.identifier) &&
        Objects.equals(this.acquirerRefundIdentifier, refundAgent.acquirerRefundIdentifier) &&
        Objects.equals(this.refund, refundAgent.refund) &&
        Objects.equals(this.created, refundAgent.created) &&
        Objects.equals(this.description, refundAgent.description) &&
        Objects.equals(this.reasonType, refundAgent.reasonType) &&
        Objects.equals(this.statusType, refundAgent.statusType) &&
        Objects.equals(this.requestType, refundAgent.requestType) &&
        Objects.equals(this.requestStatus, refundAgent.requestStatus) &&
        Objects.equals(this.requestResponse, refundAgent.requestResponse) &&
        Objects.equals(this.receiptUrl, refundAgent.receiptUrl);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, acquirerRefundIdentifier, refund, created, description, reasonType, statusType, requestType, requestStatus, requestResponse, receiptUrl);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RefundAgent {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    acquirerRefundIdentifier: ").append(toIndentedString(acquirerRefundIdentifier)).append("\n");
    sb.append("    refund: ").append(toIndentedString(refund)).append("\n");
    sb.append("    created: ").append(toIndentedString(created)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    reasonType: ").append(toIndentedString(reasonType)).append("\n");
    sb.append("    statusType: ").append(toIndentedString(statusType)).append("\n");
    sb.append("    requestType: ").append(toIndentedString(requestType)).append("\n");
    sb.append("    requestStatus: ").append(toIndentedString(requestStatus)).append("\n");
    sb.append("    requestResponse: ").append(toIndentedString(requestResponse)).append("\n");
    sb.append("    receiptUrl: ").append(toIndentedString(receiptUrl)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

