/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.booking.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@ApiModel(description="Extra reservations of spas, meeting rooms etc that should accompany the room type booking.")
@JsonPropertyOrder(value={"typeIdentifier", "channelInventoryIdentifier", "transactionalTravelInventoryIdentifier", "type", "startDate", "endDate", "quantity"})
@JsonTypeName(value="AncillaryRequest_Booker")
public class AncillaryRequestBooker {
    public static final String JSON_PROPERTY_TYPE_IDENTIFIER = "typeIdentifier";
    private UUID typeIdentifier;
    public static final String JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER = "channelInventoryIdentifier";
    private UUID channelInventoryIdentifier;
    public static final String JSON_PROPERTY_TRANSACTIONAL_TRAVEL_INVENTORY_IDENTIFIER = "transactionalTravelInventoryIdentifier";
    private UUID transactionalTravelInventoryIdentifier;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_START_DATE = "startDate";
    private LocalDateTime startDate;
    public static final String JSON_PROPERTY_END_DATE = "endDate";
    private LocalDateTime endDate;
    public static final String JSON_PROPERTY_QUANTITY = "quantity";
    private Integer quantity = 1;

    public AncillaryRequestBooker typeIdentifier(UUID typeIdentifier) {
        this.typeIdentifier = typeIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Travel inventory identifier")
    @JsonProperty(value="typeIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getTypeIdentifier() {
        return this.typeIdentifier;
    }

    @JsonProperty(value="typeIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTypeIdentifier(UUID typeIdentifier) {
        this.typeIdentifier = typeIdentifier;
    }

    public AncillaryRequestBooker channelInventoryIdentifier(UUID channelInventoryIdentifier) {
        this.channelInventoryIdentifier = channelInventoryIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Channel inventory identifier")
    @JsonProperty(value="channelInventoryIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getChannelInventoryIdentifier() {
        return this.channelInventoryIdentifier;
    }

    @JsonProperty(value="channelInventoryIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setChannelInventoryIdentifier(UUID channelInventoryIdentifier) {
        this.channelInventoryIdentifier = channelInventoryIdentifier;
    }

    public AncillaryRequestBooker transactionalTravelInventoryIdentifier(UUID transactionalTravelInventoryIdentifier) {
        this.transactionalTravelInventoryIdentifier = transactionalTravelInventoryIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Travel inventory identifier")
    @JsonProperty(value="transactionalTravelInventoryIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getTransactionalTravelInventoryIdentifier() {
        return this.transactionalTravelInventoryIdentifier;
    }

    @JsonProperty(value="transactionalTravelInventoryIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTransactionalTravelInventoryIdentifier(UUID transactionalTravelInventoryIdentifier) {
        this.transactionalTravelInventoryIdentifier = transactionalTravelInventoryIdentifier;
    }

    public AncillaryRequestBooker type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="PLACE", required=true, value="Inventory type")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public AncillaryRequestBooker startDate(LocalDateTime startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Date start time when reservation was made for.")
    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDateTime getStartDate() {
        return this.startDate;
    }

    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStartDate(LocalDateTime startDate) {
        this.startDate = startDate;
    }

    public AncillaryRequestBooker endDate(LocalDateTime endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Date end time when reservation was made for.")
    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDateTime getEndDate() {
        return this.endDate;
    }

    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEndDate(LocalDateTime endDate) {
        this.endDate = endDate;
    }

    public AncillaryRequestBooker quantity(Integer quantity) {
        this.quantity = quantity;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=1L)
    @ApiModelProperty(example="2", required=true, value="Quantity of the ancillary requested.")
    @JsonProperty(value="quantity")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=1L) Integer getQuantity() {
        return this.quantity;
    }

    @JsonProperty(value="quantity")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AncillaryRequestBooker ancillaryRequestBooker = (AncillaryRequestBooker)o;
        return Objects.equals(this.typeIdentifier, ancillaryRequestBooker.typeIdentifier) && Objects.equals(this.channelInventoryIdentifier, ancillaryRequestBooker.channelInventoryIdentifier) && Objects.equals(this.transactionalTravelInventoryIdentifier, ancillaryRequestBooker.transactionalTravelInventoryIdentifier) && Objects.equals((Object)this.type, (Object)ancillaryRequestBooker.type) && Objects.equals(this.startDate, ancillaryRequestBooker.startDate) && Objects.equals(this.endDate, ancillaryRequestBooker.endDate) && Objects.equals(this.quantity, ancillaryRequestBooker.quantity);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.typeIdentifier, this.channelInventoryIdentifier, this.transactionalTravelInventoryIdentifier, this.type, this.startDate, this.endDate, this.quantity});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AncillaryRequestBooker {\n");
        sb.append("    typeIdentifier: ").append(this.toIndentedString(this.typeIdentifier)).append("\n");
        sb.append("    channelInventoryIdentifier: ").append(this.toIndentedString(this.channelInventoryIdentifier)).append("\n");
        sb.append("    transactionalTravelInventoryIdentifier: ").append(this.toIndentedString(this.transactionalTravelInventoryIdentifier)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        ROOM_TYPE_ANCILLARY("ROOM_TYPE_ANCILLARY"),
        ADD_ON("ADD_ON"),
        MEETING_ROOM("MEETING_ROOM"),
        SPA("SPA"),
        RESTAURANT("RESTAURANT"),
        ACTIVITY("ACTIVITY"),
        ATTRACTION("ATTRACTION"),
        PLACE("PLACE");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

