/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.booking.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@JsonPropertyOrder(value={"bedTypeCode", "quantity"})
@JsonTypeName(value="Bed_Agent")
public class BedAgent {
    public static final String JSON_PROPERTY_BED_TYPE_CODE = "bedTypeCode";
    private String bedTypeCode;
    public static final String JSON_PROPERTY_QUANTITY = "quantity";
    private Integer quantity;

    public BedAgent bedTypeCode(String bedTypeCode) {
        this.bedTypeCode = bedTypeCode;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="1", required=true, value="Indicates the type of bed(s) found in the room. Typical values would be Double, Twin, Queen, or King. Supported OTA specification `BED` code. See [OTA geoname data](#operation/showAvailableCodesForCategory).")
    @JsonProperty(value="bedTypeCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getBedTypeCode() {
        return this.bedTypeCode;
    }

    @JsonProperty(value="bedTypeCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBedTypeCode(String bedTypeCode) {
        this.bedTypeCode = bedTypeCode;
    }

    public BedAgent quantity(Integer quantity) {
        this.quantity = quantity;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=1L)
    @ApiModelProperty(example="10", required=true, value="Number of beds for this bed type.")
    @JsonProperty(value="quantity")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=1L) Integer getQuantity() {
        return this.quantity;
    }

    @JsonProperty(value="quantity")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BedAgent bedAgent = (BedAgent)o;
        return Objects.equals(this.bedTypeCode, bedAgent.bedTypeCode) && Objects.equals(this.quantity, bedAgent.quantity);
    }

    public int hashCode() {
        return Objects.hash(this.bedTypeCode, this.quantity);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BedAgent {\n");
        sb.append("    bedTypeCode: ").append(this.toIndentedString(this.bedTypeCode)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

