/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.booking.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDateTime;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import travel.wink.sdk.booking.model.BookingAgent;

@JsonPropertyOrder(value={"id", "createdDate", "lastUpdate", "version", "booking"})
@JsonTypeName(value="BookingView_Agent")
public class BookingViewAgent {
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_CREATED_DATE = "createdDate";
    private LocalDateTime createdDate;
    public static final String JSON_PROPERTY_LAST_UPDATE = "lastUpdate";
    private LocalDateTime lastUpdate;
    public static final String JSON_PROPERTY_VERSION = "version";
    private Long version;
    public static final String JSON_PROPERTY_BOOKING = "booking";
    private BookingAgent booking;

    public BookingViewAgent id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="doc-1", value="Document UUID")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public BookingViewAgent createdDate(LocalDateTime createdDate) {
        this.createdDate = createdDate;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Datetime this record was first created")
    @JsonProperty(value="createdDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDateTime getCreatedDate() {
        return this.createdDate;
    }

    @JsonProperty(value="createdDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedDate(LocalDateTime createdDate) {
        this.createdDate = createdDate;
    }

    public BookingViewAgent lastUpdate(LocalDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Datetime this record was last updated")
    @JsonProperty(value="lastUpdate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDateTime getLastUpdate() {
        return this.lastUpdate;
    }

    @JsonProperty(value="lastUpdate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLastUpdate(LocalDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public BookingViewAgent version(Long version) {
        this.version = version;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="12", value="Version property that shows how many times this document has been persisted. Document will not persist if the version property is less than current version property in the system. Result in an optimistic locking exception.")
    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVersion(Long version) {
        this.version = version;
    }

    public BookingViewAgent booking(BookingAgent booking) {
        this.booking = booking;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="booking")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public BookingAgent getBooking() {
        return this.booking;
    }

    @JsonProperty(value="booking")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBooking(BookingAgent booking) {
        this.booking = booking;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BookingViewAgent bookingViewAgent = (BookingViewAgent)o;
        return Objects.equals(this.id, bookingViewAgent.id) && Objects.equals(this.createdDate, bookingViewAgent.createdDate) && Objects.equals(this.lastUpdate, bookingViewAgent.lastUpdate) && Objects.equals(this.version, bookingViewAgent.version) && Objects.equals(this.booking, bookingViewAgent.booking);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.createdDate, this.lastUpdate, this.version, this.booking);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BookingViewAgent {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    createdDate: ").append(this.toIndentedString(this.createdDate)).append("\n");
        sb.append("    lastUpdate: ").append(this.toIndentedString(this.lastUpdate)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    booking: ").append(this.toIndentedString(this.booking)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

