/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.booking.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import travel.wink.sdk.booking.model.MoneysAgent;
import travel.wink.sdk.booking.model.QuoteAgent;

@ApiModel(description="Pricing information for this ancillary.")
@JsonPropertyOrder(value={"sourceToUserCurrencyQuote", "sourceToInternalCurrencyQuote", "userSpecifiedCurrencyBaseTotal", "sourceBaseTotal", "internalBaseTotal", "userSpecifiedCurrencyPromotionalModifier", "sourcePromotionalModifier", "internalPromotionalModifier", "userSpecifiedCurrencyPremiumModifier", "sourcePremiumModifier", "internalPremiumModifier", "userSpecifiedCurrencyChannelModifier", "sourceChannelModifier", "internalChannelModifier", "quantity", "promotionalDiscountPercent", "channelDiscountPercent", "premiumPercent", "sourceTotal", "userSpecifiedCurrencyTotal", "internalTotal", "hasPromotion", "hasPremium", "totalDiscountPercent", "hasChannelDiscount"})
@JsonTypeName(value="LocalizedPrice_Agent")
public class LocalizedPriceAgent {
    public static final String JSON_PROPERTY_SOURCE_TO_USER_CURRENCY_QUOTE = "sourceToUserCurrencyQuote";
    private QuoteAgent sourceToUserCurrencyQuote;
    public static final String JSON_PROPERTY_SOURCE_TO_INTERNAL_CURRENCY_QUOTE = "sourceToInternalCurrencyQuote";
    private QuoteAgent sourceToInternalCurrencyQuote;
    public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_BASE_TOTAL = "userSpecifiedCurrencyBaseTotal";
    private MoneysAgent userSpecifiedCurrencyBaseTotal;
    public static final String JSON_PROPERTY_SOURCE_BASE_TOTAL = "sourceBaseTotal";
    private MoneysAgent sourceBaseTotal;
    public static final String JSON_PROPERTY_INTERNAL_BASE_TOTAL = "internalBaseTotal";
    private MoneysAgent internalBaseTotal;
    public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PROMOTIONAL_MODIFIER = "userSpecifiedCurrencyPromotionalModifier";
    private Double userSpecifiedCurrencyPromotionalModifier;
    public static final String JSON_PROPERTY_SOURCE_PROMOTIONAL_MODIFIER = "sourcePromotionalModifier";
    private Double sourcePromotionalModifier;
    public static final String JSON_PROPERTY_INTERNAL_PROMOTIONAL_MODIFIER = "internalPromotionalModifier";
    private Double internalPromotionalModifier;
    public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PREMIUM_MODIFIER = "userSpecifiedCurrencyPremiumModifier";
    private Double userSpecifiedCurrencyPremiumModifier;
    public static final String JSON_PROPERTY_SOURCE_PREMIUM_MODIFIER = "sourcePremiumModifier";
    private Double sourcePremiumModifier;
    public static final String JSON_PROPERTY_INTERNAL_PREMIUM_MODIFIER = "internalPremiumModifier";
    private Double internalPremiumModifier;
    public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_CHANNEL_MODIFIER = "userSpecifiedCurrencyChannelModifier";
    private Double userSpecifiedCurrencyChannelModifier;
    public static final String JSON_PROPERTY_SOURCE_CHANNEL_MODIFIER = "sourceChannelModifier";
    private Double sourceChannelModifier;
    public static final String JSON_PROPERTY_INTERNAL_CHANNEL_MODIFIER = "internalChannelModifier";
    private Double internalChannelModifier;
    public static final String JSON_PROPERTY_QUANTITY = "quantity";
    private Integer quantity = 1;
    public static final String JSON_PROPERTY_PROMOTIONAL_DISCOUNT_PERCENT = "promotionalDiscountPercent";
    private Float promotionalDiscountPercent;
    public static final String JSON_PROPERTY_CHANNEL_DISCOUNT_PERCENT = "channelDiscountPercent";
    private Float channelDiscountPercent;
    public static final String JSON_PROPERTY_PREMIUM_PERCENT = "premiumPercent";
    private Float premiumPercent;
    public static final String JSON_PROPERTY_SOURCE_TOTAL = "sourceTotal";
    private MoneysAgent sourceTotal;
    public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL = "userSpecifiedCurrencyTotal";
    private MoneysAgent userSpecifiedCurrencyTotal;
    public static final String JSON_PROPERTY_INTERNAL_TOTAL = "internalTotal";
    private MoneysAgent internalTotal;
    public static final String JSON_PROPERTY_HAS_PROMOTION = "hasPromotion";
    private Boolean hasPromotion;
    public static final String JSON_PROPERTY_HAS_PREMIUM = "hasPremium";
    private Boolean hasPremium;
    public static final String JSON_PROPERTY_TOTAL_DISCOUNT_PERCENT = "totalDiscountPercent";
    private Float totalDiscountPercent;
    public static final String JSON_PROPERTY_HAS_CHANNEL_DISCOUNT = "hasChannelDiscount";
    private Boolean hasChannelDiscount;

    public LocalizedPriceAgent sourceToUserCurrencyQuote(QuoteAgent sourceToUserCurrencyQuote) {
        this.sourceToUserCurrencyQuote = sourceToUserCurrencyQuote;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="sourceToUserCurrencyQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public QuoteAgent getSourceToUserCurrencyQuote() {
        return this.sourceToUserCurrencyQuote;
    }

    @JsonProperty(value="sourceToUserCurrencyQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSourceToUserCurrencyQuote(QuoteAgent sourceToUserCurrencyQuote) {
        this.sourceToUserCurrencyQuote = sourceToUserCurrencyQuote;
    }

    public LocalizedPriceAgent sourceToInternalCurrencyQuote(QuoteAgent sourceToInternalCurrencyQuote) {
        this.sourceToInternalCurrencyQuote = sourceToInternalCurrencyQuote;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="sourceToInternalCurrencyQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public QuoteAgent getSourceToInternalCurrencyQuote() {
        return this.sourceToInternalCurrencyQuote;
    }

    @JsonProperty(value="sourceToInternalCurrencyQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSourceToInternalCurrencyQuote(QuoteAgent sourceToInternalCurrencyQuote) {
        this.sourceToInternalCurrencyQuote = sourceToInternalCurrencyQuote;
    }

    public LocalizedPriceAgent userSpecifiedCurrencyBaseTotal(MoneysAgent userSpecifiedCurrencyBaseTotal) {
        this.userSpecifiedCurrencyBaseTotal = userSpecifiedCurrencyBaseTotal;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="userSpecifiedCurrencyBaseTotal")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public MoneysAgent getUserSpecifiedCurrencyBaseTotal() {
        return this.userSpecifiedCurrencyBaseTotal;
    }

    @JsonProperty(value="userSpecifiedCurrencyBaseTotal")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUserSpecifiedCurrencyBaseTotal(MoneysAgent userSpecifiedCurrencyBaseTotal) {
        this.userSpecifiedCurrencyBaseTotal = userSpecifiedCurrencyBaseTotal;
    }

    public LocalizedPriceAgent sourceBaseTotal(MoneysAgent sourceBaseTotal) {
        this.sourceBaseTotal = sourceBaseTotal;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="sourceBaseTotal")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public MoneysAgent getSourceBaseTotal() {
        return this.sourceBaseTotal;
    }

    @JsonProperty(value="sourceBaseTotal")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSourceBaseTotal(MoneysAgent sourceBaseTotal) {
        this.sourceBaseTotal = sourceBaseTotal;
    }

    public LocalizedPriceAgent internalBaseTotal(MoneysAgent internalBaseTotal) {
        this.internalBaseTotal = internalBaseTotal;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="internalBaseTotal")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public MoneysAgent getInternalBaseTotal() {
        return this.internalBaseTotal;
    }

    @JsonProperty(value="internalBaseTotal")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setInternalBaseTotal(MoneysAgent internalBaseTotal) {
        this.internalBaseTotal = internalBaseTotal;
    }

    public LocalizedPriceAgent userSpecifiedCurrencyPromotionalModifier(Double userSpecifiedCurrencyPromotionalModifier) {
        this.userSpecifiedCurrencyPromotionalModifier = userSpecifiedCurrencyPromotionalModifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="-40", value="Promotional modifiers in user specified currency")
    @JsonProperty(value="userSpecifiedCurrencyPromotionalModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getUserSpecifiedCurrencyPromotionalModifier() {
        return this.userSpecifiedCurrencyPromotionalModifier;
    }

    @JsonProperty(value="userSpecifiedCurrencyPromotionalModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserSpecifiedCurrencyPromotionalModifier(Double userSpecifiedCurrencyPromotionalModifier) {
        this.userSpecifiedCurrencyPromotionalModifier = userSpecifiedCurrencyPromotionalModifier;
    }

    public LocalizedPriceAgent sourcePromotionalModifier(Double sourcePromotionalModifier) {
        this.sourcePromotionalModifier = sourcePromotionalModifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="-40", value="Promotional modifiers in hotel currency")
    @JsonProperty(value="sourcePromotionalModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getSourcePromotionalModifier() {
        return this.sourcePromotionalModifier;
    }

    @JsonProperty(value="sourcePromotionalModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourcePromotionalModifier(Double sourcePromotionalModifier) {
        this.sourcePromotionalModifier = sourcePromotionalModifier;
    }

    public LocalizedPriceAgent internalPromotionalModifier(Double internalPromotionalModifier) {
        this.internalPromotionalModifier = internalPromotionalModifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="-40", value="Promotional modifiers in wink currency")
    @JsonProperty(value="internalPromotionalModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getInternalPromotionalModifier() {
        return this.internalPromotionalModifier;
    }

    @JsonProperty(value="internalPromotionalModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInternalPromotionalModifier(Double internalPromotionalModifier) {
        this.internalPromotionalModifier = internalPromotionalModifier;
    }

    public LocalizedPriceAgent userSpecifiedCurrencyPremiumModifier(Double userSpecifiedCurrencyPremiumModifier) {
        this.userSpecifiedCurrencyPremiumModifier = userSpecifiedCurrencyPremiumModifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="40", value="Premium modifiers in user specified currency")
    @JsonProperty(value="userSpecifiedCurrencyPremiumModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getUserSpecifiedCurrencyPremiumModifier() {
        return this.userSpecifiedCurrencyPremiumModifier;
    }

    @JsonProperty(value="userSpecifiedCurrencyPremiumModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserSpecifiedCurrencyPremiumModifier(Double userSpecifiedCurrencyPremiumModifier) {
        this.userSpecifiedCurrencyPremiumModifier = userSpecifiedCurrencyPremiumModifier;
    }

    public LocalizedPriceAgent sourcePremiumModifier(Double sourcePremiumModifier) {
        this.sourcePremiumModifier = sourcePremiumModifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="40", value="Premium modifiers in hotel currency")
    @JsonProperty(value="sourcePremiumModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getSourcePremiumModifier() {
        return this.sourcePremiumModifier;
    }

    @JsonProperty(value="sourcePremiumModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourcePremiumModifier(Double sourcePremiumModifier) {
        this.sourcePremiumModifier = sourcePremiumModifier;
    }

    public LocalizedPriceAgent internalPremiumModifier(Double internalPremiumModifier) {
        this.internalPremiumModifier = internalPremiumModifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="40", value="Premium modifiers in wink currency")
    @JsonProperty(value="internalPremiumModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getInternalPremiumModifier() {
        return this.internalPremiumModifier;
    }

    @JsonProperty(value="internalPremiumModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInternalPremiumModifier(Double internalPremiumModifier) {
        this.internalPremiumModifier = internalPremiumModifier;
    }

    public LocalizedPriceAgent userSpecifiedCurrencyChannelModifier(Double userSpecifiedCurrencyChannelModifier) {
        this.userSpecifiedCurrencyChannelModifier = userSpecifiedCurrencyChannelModifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="-10", value="Channel / Membership modifier in user specified currency")
    @JsonProperty(value="userSpecifiedCurrencyChannelModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getUserSpecifiedCurrencyChannelModifier() {
        return this.userSpecifiedCurrencyChannelModifier;
    }

    @JsonProperty(value="userSpecifiedCurrencyChannelModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserSpecifiedCurrencyChannelModifier(Double userSpecifiedCurrencyChannelModifier) {
        this.userSpecifiedCurrencyChannelModifier = userSpecifiedCurrencyChannelModifier;
    }

    public LocalizedPriceAgent sourceChannelModifier(Double sourceChannelModifier) {
        this.sourceChannelModifier = sourceChannelModifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="-10", value="Channel / Membership modifier in hotel currency")
    @JsonProperty(value="sourceChannelModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getSourceChannelModifier() {
        return this.sourceChannelModifier;
    }

    @JsonProperty(value="sourceChannelModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourceChannelModifier(Double sourceChannelModifier) {
        this.sourceChannelModifier = sourceChannelModifier;
    }

    public LocalizedPriceAgent internalChannelModifier(Double internalChannelModifier) {
        this.internalChannelModifier = internalChannelModifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="-10", value="Channel / Membership modifier in wink currency")
    @JsonProperty(value="internalChannelModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getInternalChannelModifier() {
        return this.internalChannelModifier;
    }

    @JsonProperty(value="internalChannelModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInternalChannelModifier(Double internalChannelModifier) {
        this.internalChannelModifier = internalChannelModifier;
    }

    public LocalizedPriceAgent quantity(Integer quantity) {
        this.quantity = quantity;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="How many of this item is included in this price")
    @JsonProperty(value="quantity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getQuantity() {
        return this.quantity;
    }

    @JsonProperty(value="quantity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public LocalizedPriceAgent promotionalDiscountPercent(Float promotionalDiscountPercent) {
        this.promotionalDiscountPercent = promotionalDiscountPercent;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Promotional discount percent")
    @JsonProperty(value="promotionalDiscountPercent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Float getPromotionalDiscountPercent() {
        return this.promotionalDiscountPercent;
    }

    @JsonProperty(value="promotionalDiscountPercent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPromotionalDiscountPercent(Float promotionalDiscountPercent) {
        this.promotionalDiscountPercent = promotionalDiscountPercent;
    }

    public LocalizedPriceAgent channelDiscountPercent(Float channelDiscountPercent) {
        this.channelDiscountPercent = channelDiscountPercent;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Channel discount percent")
    @JsonProperty(value="channelDiscountPercent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Float getChannelDiscountPercent() {
        return this.channelDiscountPercent;
    }

    @JsonProperty(value="channelDiscountPercent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChannelDiscountPercent(Float channelDiscountPercent) {
        this.channelDiscountPercent = channelDiscountPercent;
    }

    public LocalizedPriceAgent premiumPercent(Float premiumPercent) {
        this.premiumPercent = premiumPercent;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Premium percent")
    @JsonProperty(value="premiumPercent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Float getPremiumPercent() {
        return this.premiumPercent;
    }

    @JsonProperty(value="premiumPercent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPremiumPercent(Float premiumPercent) {
        this.premiumPercent = premiumPercent;
    }

    public LocalizedPriceAgent sourceTotal(MoneysAgent sourceTotal) {
        this.sourceTotal = sourceTotal;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="sourceTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MoneysAgent getSourceTotal() {
        return this.sourceTotal;
    }

    @JsonProperty(value="sourceTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourceTotal(MoneysAgent sourceTotal) {
        this.sourceTotal = sourceTotal;
    }

    public LocalizedPriceAgent userSpecifiedCurrencyTotal(MoneysAgent userSpecifiedCurrencyTotal) {
        this.userSpecifiedCurrencyTotal = userSpecifiedCurrencyTotal;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="userSpecifiedCurrencyTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MoneysAgent getUserSpecifiedCurrencyTotal() {
        return this.userSpecifiedCurrencyTotal;
    }

    @JsonProperty(value="userSpecifiedCurrencyTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserSpecifiedCurrencyTotal(MoneysAgent userSpecifiedCurrencyTotal) {
        this.userSpecifiedCurrencyTotal = userSpecifiedCurrencyTotal;
    }

    public LocalizedPriceAgent internalTotal(MoneysAgent internalTotal) {
        this.internalTotal = internalTotal;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="internalTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MoneysAgent getInternalTotal() {
        return this.internalTotal;
    }

    @JsonProperty(value="internalTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInternalTotal(MoneysAgent internalTotal) {
        this.internalTotal = internalTotal;
    }

    public LocalizedPriceAgent hasPromotion(Boolean hasPromotion) {
        this.hasPromotion = hasPromotion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="hasPromotion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHasPromotion() {
        return this.hasPromotion;
    }

    @JsonProperty(value="hasPromotion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHasPromotion(Boolean hasPromotion) {
        this.hasPromotion = hasPromotion;
    }

    public LocalizedPriceAgent hasPremium(Boolean hasPremium) {
        this.hasPremium = hasPremium;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="hasPremium")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHasPremium() {
        return this.hasPremium;
    }

    @JsonProperty(value="hasPremium")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHasPremium(Boolean hasPremium) {
        this.hasPremium = hasPremium;
    }

    public LocalizedPriceAgent totalDiscountPercent(Float totalDiscountPercent) {
        this.totalDiscountPercent = totalDiscountPercent;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="totalDiscountPercent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Float getTotalDiscountPercent() {
        return this.totalDiscountPercent;
    }

    @JsonProperty(value="totalDiscountPercent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalDiscountPercent(Float totalDiscountPercent) {
        this.totalDiscountPercent = totalDiscountPercent;
    }

    public LocalizedPriceAgent hasChannelDiscount(Boolean hasChannelDiscount) {
        this.hasChannelDiscount = hasChannelDiscount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="hasChannelDiscount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHasChannelDiscount() {
        return this.hasChannelDiscount;
    }

    @JsonProperty(value="hasChannelDiscount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHasChannelDiscount(Boolean hasChannelDiscount) {
        this.hasChannelDiscount = hasChannelDiscount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalizedPriceAgent localizedPriceAgent = (LocalizedPriceAgent)o;
        return Objects.equals(this.sourceToUserCurrencyQuote, localizedPriceAgent.sourceToUserCurrencyQuote) && Objects.equals(this.sourceToInternalCurrencyQuote, localizedPriceAgent.sourceToInternalCurrencyQuote) && Objects.equals(this.userSpecifiedCurrencyBaseTotal, localizedPriceAgent.userSpecifiedCurrencyBaseTotal) && Objects.equals(this.sourceBaseTotal, localizedPriceAgent.sourceBaseTotal) && Objects.equals(this.internalBaseTotal, localizedPriceAgent.internalBaseTotal) && Objects.equals(this.userSpecifiedCurrencyPromotionalModifier, localizedPriceAgent.userSpecifiedCurrencyPromotionalModifier) && Objects.equals(this.sourcePromotionalModifier, localizedPriceAgent.sourcePromotionalModifier) && Objects.equals(this.internalPromotionalModifier, localizedPriceAgent.internalPromotionalModifier) && Objects.equals(this.userSpecifiedCurrencyPremiumModifier, localizedPriceAgent.userSpecifiedCurrencyPremiumModifier) && Objects.equals(this.sourcePremiumModifier, localizedPriceAgent.sourcePremiumModifier) && Objects.equals(this.internalPremiumModifier, localizedPriceAgent.internalPremiumModifier) && Objects.equals(this.userSpecifiedCurrencyChannelModifier, localizedPriceAgent.userSpecifiedCurrencyChannelModifier) && Objects.equals(this.sourceChannelModifier, localizedPriceAgent.sourceChannelModifier) && Objects.equals(this.internalChannelModifier, localizedPriceAgent.internalChannelModifier) && Objects.equals(this.quantity, localizedPriceAgent.quantity) && Objects.equals(this.promotionalDiscountPercent, localizedPriceAgent.promotionalDiscountPercent) && Objects.equals(this.channelDiscountPercent, localizedPriceAgent.channelDiscountPercent) && Objects.equals(this.premiumPercent, localizedPriceAgent.premiumPercent) && Objects.equals(this.sourceTotal, localizedPriceAgent.sourceTotal) && Objects.equals(this.userSpecifiedCurrencyTotal, localizedPriceAgent.userSpecifiedCurrencyTotal) && Objects.equals(this.internalTotal, localizedPriceAgent.internalTotal) && Objects.equals(this.hasPromotion, localizedPriceAgent.hasPromotion) && Objects.equals(this.hasPremium, localizedPriceAgent.hasPremium) && Objects.equals(this.totalDiscountPercent, localizedPriceAgent.totalDiscountPercent) && Objects.equals(this.hasChannelDiscount, localizedPriceAgent.hasChannelDiscount);
    }

    public int hashCode() {
        return Objects.hash(this.sourceToUserCurrencyQuote, this.sourceToInternalCurrencyQuote, this.userSpecifiedCurrencyBaseTotal, this.sourceBaseTotal, this.internalBaseTotal, this.userSpecifiedCurrencyPromotionalModifier, this.sourcePromotionalModifier, this.internalPromotionalModifier, this.userSpecifiedCurrencyPremiumModifier, this.sourcePremiumModifier, this.internalPremiumModifier, this.userSpecifiedCurrencyChannelModifier, this.sourceChannelModifier, this.internalChannelModifier, this.quantity, this.promotionalDiscountPercent, this.channelDiscountPercent, this.premiumPercent, this.sourceTotal, this.userSpecifiedCurrencyTotal, this.internalTotal, this.hasPromotion, this.hasPremium, this.totalDiscountPercent, this.hasChannelDiscount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LocalizedPriceAgent {\n");
        sb.append("    sourceToUserCurrencyQuote: ").append(this.toIndentedString(this.sourceToUserCurrencyQuote)).append("\n");
        sb.append("    sourceToInternalCurrencyQuote: ").append(this.toIndentedString(this.sourceToInternalCurrencyQuote)).append("\n");
        sb.append("    userSpecifiedCurrencyBaseTotal: ").append(this.toIndentedString(this.userSpecifiedCurrencyBaseTotal)).append("\n");
        sb.append("    sourceBaseTotal: ").append(this.toIndentedString(this.sourceBaseTotal)).append("\n");
        sb.append("    internalBaseTotal: ").append(this.toIndentedString(this.internalBaseTotal)).append("\n");
        sb.append("    userSpecifiedCurrencyPromotionalModifier: ").append(this.toIndentedString(this.userSpecifiedCurrencyPromotionalModifier)).append("\n");
        sb.append("    sourcePromotionalModifier: ").append(this.toIndentedString(this.sourcePromotionalModifier)).append("\n");
        sb.append("    internalPromotionalModifier: ").append(this.toIndentedString(this.internalPromotionalModifier)).append("\n");
        sb.append("    userSpecifiedCurrencyPremiumModifier: ").append(this.toIndentedString(this.userSpecifiedCurrencyPremiumModifier)).append("\n");
        sb.append("    sourcePremiumModifier: ").append(this.toIndentedString(this.sourcePremiumModifier)).append("\n");
        sb.append("    internalPremiumModifier: ").append(this.toIndentedString(this.internalPremiumModifier)).append("\n");
        sb.append("    userSpecifiedCurrencyChannelModifier: ").append(this.toIndentedString(this.userSpecifiedCurrencyChannelModifier)).append("\n");
        sb.append("    sourceChannelModifier: ").append(this.toIndentedString(this.sourceChannelModifier)).append("\n");
        sb.append("    internalChannelModifier: ").append(this.toIndentedString(this.internalChannelModifier)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    promotionalDiscountPercent: ").append(this.toIndentedString(this.promotionalDiscountPercent)).append("\n");
        sb.append("    channelDiscountPercent: ").append(this.toIndentedString(this.channelDiscountPercent)).append("\n");
        sb.append("    premiumPercent: ").append(this.toIndentedString(this.premiumPercent)).append("\n");
        sb.append("    sourceTotal: ").append(this.toIndentedString(this.sourceTotal)).append("\n");
        sb.append("    userSpecifiedCurrencyTotal: ").append(this.toIndentedString(this.userSpecifiedCurrencyTotal)).append("\n");
        sb.append("    internalTotal: ").append(this.toIndentedString(this.internalTotal)).append("\n");
        sb.append("    hasPromotion: ").append(this.toIndentedString(this.hasPromotion)).append("\n");
        sb.append("    hasPremium: ").append(this.toIndentedString(this.hasPremium)).append("\n");
        sb.append("    totalDiscountPercent: ").append(this.toIndentedString(this.totalDiscountPercent)).append("\n");
        sb.append("    hasChannelDiscount: ").append(this.toIndentedString(this.hasChannelDiscount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

