/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.booking.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import travel.wink.sdk.booking.model.PersonalBooker;
import travel.wink.sdk.booking.model.PreferencesBooker;
import travel.wink.sdk.booking.model.ProfileUserBooker;

@ApiModel(description="A user profile accompanies this booking IF user has created and enabled sharing of profile")
@JsonPropertyOrder(value={"profileIdentifier", "userIdentifier", "share", "user", "personal", "preferences"})
@JsonTypeName(value="Profile_Booker")
public class ProfileBooker {
    public static final String JSON_PROPERTY_PROFILE_IDENTIFIER = "profileIdentifier";
    private UUID profileIdentifier;
    public static final String JSON_PROPERTY_USER_IDENTIFIER = "userIdentifier";
    private UUID userIdentifier;
    public static final String JSON_PROPERTY_SHARE = "share";
    private Boolean share;
    public static final String JSON_PROPERTY_USER = "user";
    private ProfileUserBooker user;
    public static final String JSON_PROPERTY_PERSONAL = "personal";
    private PersonalBooker personal;
    public static final String JSON_PROPERTY_PREFERENCES = "preferences";
    private PreferencesBooker preferences;

    public ProfileBooker profileIdentifier(UUID profileIdentifier) {
        this.profileIdentifier = profileIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Profile identifier")
    @JsonProperty(value="profileIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getProfileIdentifier() {
        return this.profileIdentifier;
    }

    @JsonProperty(value="profileIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setProfileIdentifier(UUID profileIdentifier) {
        this.profileIdentifier = profileIdentifier;
    }

    public ProfileBooker userIdentifier(UUID userIdentifier) {
        this.userIdentifier = userIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="User identifier")
    @JsonProperty(value="userIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getUserIdentifier() {
        return this.userIdentifier;
    }

    @JsonProperty(value="userIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUserIdentifier(UUID userIdentifier) {
        this.userIdentifier = userIdentifier;
    }

    public ProfileBooker share(Boolean share) {
        this.share = share;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="Indicates whether the user wants to share this profile of themselves with hotel(s)")
    @JsonProperty(value="share")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getShare() {
        return this.share;
    }

    @JsonProperty(value="share")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setShare(Boolean share) {
        this.share = share;
    }

    public ProfileBooker user(ProfileUserBooker user) {
        this.user = user;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ProfileUserBooker getUser() {
        return this.user;
    }

    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUser(ProfileUserBooker user) {
        this.user = user;
    }

    public ProfileBooker personal(PersonalBooker personal) {
        this.personal = personal;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="personal")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PersonalBooker getPersonal() {
        return this.personal;
    }

    @JsonProperty(value="personal")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPersonal(PersonalBooker personal) {
        this.personal = personal;
    }

    public ProfileBooker preferences(PreferencesBooker preferences) {
        this.preferences = preferences;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="preferences")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PreferencesBooker getPreferences() {
        return this.preferences;
    }

    @JsonProperty(value="preferences")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPreferences(PreferencesBooker preferences) {
        this.preferences = preferences;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProfileBooker profileBooker = (ProfileBooker)o;
        return Objects.equals(this.profileIdentifier, profileBooker.profileIdentifier) && Objects.equals(this.userIdentifier, profileBooker.userIdentifier) && Objects.equals(this.share, profileBooker.share) && Objects.equals(this.user, profileBooker.user) && Objects.equals(this.personal, profileBooker.personal) && Objects.equals(this.preferences, profileBooker.preferences);
    }

    public int hashCode() {
        return Objects.hash(this.profileIdentifier, this.userIdentifier, this.share, this.user, this.personal, this.preferences);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProfileBooker {\n");
        sb.append("    profileIdentifier: ").append(this.toIndentedString(this.profileIdentifier)).append("\n");
        sb.append("    userIdentifier: ").append(this.toIndentedString(this.userIdentifier)).append("\n");
        sb.append("    share: ").append(this.toIndentedString(this.share)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    personal: ").append(this.toIndentedString(this.personal)).append("\n");
        sb.append("    preferences: ").append(this.toIndentedString(this.preferences)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

