/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.booking.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import travel.wink.sdk.booking.model.MoneysBooker;

@JsonPropertyOrder(value={"accountIdentifier", "type", "amountDueInSourceCurrency", "amountDueInDisplayCurrency", "amountDueInSupplierCurrency", "amountDueInInternalCurrency", "amountDueInCaptureCurrency"})
@JsonTypeName(value="Beneficiary_Booker")
public class BeneficiaryBooker {
    public static final String JSON_PROPERTY_ACCOUNT_IDENTIFIER = "accountIdentifier";
    private UUID accountIdentifier;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_AMOUNT_DUE_IN_SOURCE_CURRENCY = "amountDueInSourceCurrency";
    private MoneysBooker amountDueInSourceCurrency;
    public static final String JSON_PROPERTY_AMOUNT_DUE_IN_DISPLAY_CURRENCY = "amountDueInDisplayCurrency";
    private MoneysBooker amountDueInDisplayCurrency;
    public static final String JSON_PROPERTY_AMOUNT_DUE_IN_SUPPLIER_CURRENCY = "amountDueInSupplierCurrency";
    private MoneysBooker amountDueInSupplierCurrency;
    public static final String JSON_PROPERTY_AMOUNT_DUE_IN_INTERNAL_CURRENCY = "amountDueInInternalCurrency";
    private MoneysBooker amountDueInInternalCurrency;
    public static final String JSON_PROPERTY_AMOUNT_DUE_IN_CAPTURE_CURRENCY = "amountDueInCaptureCurrency";
    private MoneysBooker amountDueInCaptureCurrency;

    public BeneficiaryBooker accountIdentifier(UUID accountIdentifier) {
        this.accountIdentifier = accountIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="accountIdentifier of beneficiary from payment")
    @JsonProperty(value="accountIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getAccountIdentifier() {
        return this.accountIdentifier;
    }

    @JsonProperty(value="accountIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAccountIdentifier(UUID accountIdentifier) {
        this.accountIdentifier = accountIdentifier;
    }

    public BeneficiaryBooker type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="The type of beneficiary payment.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public BeneficiaryBooker amountDueInSourceCurrency(MoneysBooker amountDueInSourceCurrency) {
        this.amountDueInSourceCurrency = amountDueInSourceCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="amountDueInSourceCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public MoneysBooker getAmountDueInSourceCurrency() {
        return this.amountDueInSourceCurrency;
    }

    @JsonProperty(value="amountDueInSourceCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAmountDueInSourceCurrency(MoneysBooker amountDueInSourceCurrency) {
        this.amountDueInSourceCurrency = amountDueInSourceCurrency;
    }

    public BeneficiaryBooker amountDueInDisplayCurrency(MoneysBooker amountDueInDisplayCurrency) {
        this.amountDueInDisplayCurrency = amountDueInDisplayCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="amountDueInDisplayCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public MoneysBooker getAmountDueInDisplayCurrency() {
        return this.amountDueInDisplayCurrency;
    }

    @JsonProperty(value="amountDueInDisplayCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAmountDueInDisplayCurrency(MoneysBooker amountDueInDisplayCurrency) {
        this.amountDueInDisplayCurrency = amountDueInDisplayCurrency;
    }

    public BeneficiaryBooker amountDueInSupplierCurrency(MoneysBooker amountDueInSupplierCurrency) {
        this.amountDueInSupplierCurrency = amountDueInSupplierCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="amountDueInSupplierCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public MoneysBooker getAmountDueInSupplierCurrency() {
        return this.amountDueInSupplierCurrency;
    }

    @JsonProperty(value="amountDueInSupplierCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAmountDueInSupplierCurrency(MoneysBooker amountDueInSupplierCurrency) {
        this.amountDueInSupplierCurrency = amountDueInSupplierCurrency;
    }

    public BeneficiaryBooker amountDueInInternalCurrency(MoneysBooker amountDueInInternalCurrency) {
        this.amountDueInInternalCurrency = amountDueInInternalCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="amountDueInInternalCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public MoneysBooker getAmountDueInInternalCurrency() {
        return this.amountDueInInternalCurrency;
    }

    @JsonProperty(value="amountDueInInternalCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAmountDueInInternalCurrency(MoneysBooker amountDueInInternalCurrency) {
        this.amountDueInInternalCurrency = amountDueInInternalCurrency;
    }

    public BeneficiaryBooker amountDueInCaptureCurrency(MoneysBooker amountDueInCaptureCurrency) {
        this.amountDueInCaptureCurrency = amountDueInCaptureCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="amountDueInCaptureCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public MoneysBooker getAmountDueInCaptureCurrency() {
        return this.amountDueInCaptureCurrency;
    }

    @JsonProperty(value="amountDueInCaptureCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAmountDueInCaptureCurrency(MoneysBooker amountDueInCaptureCurrency) {
        this.amountDueInCaptureCurrency = amountDueInCaptureCurrency;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BeneficiaryBooker beneficiaryBooker = (BeneficiaryBooker)o;
        return Objects.equals(this.accountIdentifier, beneficiaryBooker.accountIdentifier) && Objects.equals((Object)this.type, (Object)beneficiaryBooker.type) && Objects.equals(this.amountDueInSourceCurrency, beneficiaryBooker.amountDueInSourceCurrency) && Objects.equals(this.amountDueInDisplayCurrency, beneficiaryBooker.amountDueInDisplayCurrency) && Objects.equals(this.amountDueInSupplierCurrency, beneficiaryBooker.amountDueInSupplierCurrency) && Objects.equals(this.amountDueInInternalCurrency, beneficiaryBooker.amountDueInInternalCurrency) && Objects.equals(this.amountDueInCaptureCurrency, beneficiaryBooker.amountDueInCaptureCurrency);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountIdentifier, this.type, this.amountDueInSourceCurrency, this.amountDueInDisplayCurrency, this.amountDueInSupplierCurrency, this.amountDueInInternalCurrency, this.amountDueInCaptureCurrency});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BeneficiaryBooker {\n");
        sb.append("    accountIdentifier: ").append(this.toIndentedString(this.accountIdentifier)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    amountDueInSourceCurrency: ").append(this.toIndentedString(this.amountDueInSourceCurrency)).append("\n");
        sb.append("    amountDueInDisplayCurrency: ").append(this.toIndentedString(this.amountDueInDisplayCurrency)).append("\n");
        sb.append("    amountDueInSupplierCurrency: ").append(this.toIndentedString(this.amountDueInSupplierCurrency)).append("\n");
        sb.append("    amountDueInInternalCurrency: ").append(this.toIndentedString(this.amountDueInInternalCurrency)).append("\n");
        sb.append("    amountDueInCaptureCurrency: ").append(this.toIndentedString(this.amountDueInCaptureCurrency)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        COMMISSION("COMMISSION"),
        PLATFORM_FEE("PLATFORM_FEE"),
        SALE("SALE"),
        TRIP_PAY("TRIP_PAY");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

