/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release   # Booking API Welcome to the Booking Engine API - A programmer-friendly way to book inventory that was found on our platform. We take great care in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive payment-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 25.0.3
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.booking.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.time.LocalDateTime;
import java.util.UUID;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Extra reservations of spas, meeting rooms etc that should accompany the room type booking.
 */
@ApiModel(description = "Extra reservations of spas, meeting rooms etc that should accompany the room type booking.")
@JsonPropertyOrder({
  AncillaryRequestAgent.JSON_PROPERTY_TYPE_IDENTIFIER,
  AncillaryRequestAgent.JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER,
  AncillaryRequestAgent.JSON_PROPERTY_TRANSACTIONAL_TRAVEL_INVENTORY_IDENTIFIER,
  AncillaryRequestAgent.JSON_PROPERTY_TYPE,
  AncillaryRequestAgent.JSON_PROPERTY_START_DATE,
  AncillaryRequestAgent.JSON_PROPERTY_END_DATE,
  AncillaryRequestAgent.JSON_PROPERTY_QUANTITY
})
@JsonTypeName("AncillaryRequest_Agent")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-03-24T11:13:07.607433685+07:00[Asia/Bangkok]")
public class AncillaryRequestAgent {
  public static final String JSON_PROPERTY_TYPE_IDENTIFIER = "typeIdentifier";
  private UUID typeIdentifier;

  public static final String JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER = "channelInventoryIdentifier";
  private UUID channelInventoryIdentifier;

  public static final String JSON_PROPERTY_TRANSACTIONAL_TRAVEL_INVENTORY_IDENTIFIER = "transactionalTravelInventoryIdentifier";
  private UUID transactionalTravelInventoryIdentifier;

  /**
   * Inventory type
   */
  public enum TypeEnum {
    ROOM_TYPE_ANCILLARY("ROOM_TYPE_ANCILLARY"),
    
    ADD_ON("ADD_ON"),
    
    MEETING_ROOM("MEETING_ROOM"),
    
    SPA("SPA"),
    
    RESTAURANT("RESTAURANT"),
    
    ACTIVITY("ACTIVITY"),
    
    ATTRACTION("ATTRACTION"),
    
    PLACE("PLACE");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_START_DATE = "startDate";
  private java.time.LocalDateTime startDate;

  public static final String JSON_PROPERTY_END_DATE = "endDate";
  private java.time.LocalDateTime endDate;

  public static final String JSON_PROPERTY_QUANTITY = "quantity";
  private Integer quantity = 1;

  public AncillaryRequestAgent() { 
  }

  public AncillaryRequestAgent typeIdentifier(UUID typeIdentifier) {
    
    this.typeIdentifier = typeIdentifier;
    return this;
  }

   /**
   * Travel inventory identifier
   * @return typeIdentifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "Travel inventory identifier")
  @JsonProperty(JSON_PROPERTY_TYPE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getTypeIdentifier() {
    return typeIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_TYPE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTypeIdentifier(UUID typeIdentifier) {
    this.typeIdentifier = typeIdentifier;
  }


  public AncillaryRequestAgent channelInventoryIdentifier(UUID channelInventoryIdentifier) {
    
    this.channelInventoryIdentifier = channelInventoryIdentifier;
    return this;
  }

   /**
   * Channel inventory identifier
   * @return channelInventoryIdentifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "Channel inventory identifier")
  @JsonProperty(JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getChannelInventoryIdentifier() {
    return channelInventoryIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setChannelInventoryIdentifier(UUID channelInventoryIdentifier) {
    this.channelInventoryIdentifier = channelInventoryIdentifier;
  }


  public AncillaryRequestAgent transactionalTravelInventoryIdentifier(UUID transactionalTravelInventoryIdentifier) {
    
    this.transactionalTravelInventoryIdentifier = transactionalTravelInventoryIdentifier;
    return this;
  }

   /**
   * Travel inventory identifier
   * @return transactionalTravelInventoryIdentifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "Travel inventory identifier")
  @JsonProperty(JSON_PROPERTY_TRANSACTIONAL_TRAVEL_INVENTORY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getTransactionalTravelInventoryIdentifier() {
    return transactionalTravelInventoryIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_TRANSACTIONAL_TRAVEL_INVENTORY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTransactionalTravelInventoryIdentifier(UUID transactionalTravelInventoryIdentifier) {
    this.transactionalTravelInventoryIdentifier = transactionalTravelInventoryIdentifier;
  }


  public AncillaryRequestAgent type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * Inventory type
   * @return type
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "PLACE", required = true, value = "Inventory type")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public AncillaryRequestAgent startDate(java.time.LocalDateTime startDate) {
    
    this.startDate = startDate;
    return this;
  }

   /**
   * Date start time when reservation was made for.
   * @return startDate
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "Date start time when reservation was made for.")
  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public java.time.LocalDateTime getStartDate() {
    return startDate;
  }


  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStartDate(java.time.LocalDateTime startDate) {
    this.startDate = startDate;
  }


  public AncillaryRequestAgent endDate(java.time.LocalDateTime endDate) {
    
    this.endDate = endDate;
    return this;
  }

   /**
   * Date end time when reservation was made for.
   * @return endDate
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "Date end time when reservation was made for.")
  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public java.time.LocalDateTime getEndDate() {
    return endDate;
  }


  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEndDate(java.time.LocalDateTime endDate) {
    this.endDate = endDate;
  }


  public AncillaryRequestAgent quantity(Integer quantity) {
    
    this.quantity = quantity;
    return this;
  }

   /**
   * Quantity of the ancillary requested.
   * minimum: 1
   * @return quantity
  **/
  @javax.annotation.Nonnull
  @NotNull
 @Min(1)  @ApiModelProperty(example = "2", required = true, value = "Quantity of the ancillary requested.")
  @JsonProperty(JSON_PROPERTY_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getQuantity() {
    return quantity;
  }


  @JsonProperty(JSON_PROPERTY_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setQuantity(Integer quantity) {
    this.quantity = quantity;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AncillaryRequestAgent ancillaryRequestAgent = (AncillaryRequestAgent) o;
    return Objects.equals(this.typeIdentifier, ancillaryRequestAgent.typeIdentifier) &&
        Objects.equals(this.channelInventoryIdentifier, ancillaryRequestAgent.channelInventoryIdentifier) &&
        Objects.equals(this.transactionalTravelInventoryIdentifier, ancillaryRequestAgent.transactionalTravelInventoryIdentifier) &&
        Objects.equals(this.type, ancillaryRequestAgent.type) &&
        Objects.equals(this.startDate, ancillaryRequestAgent.startDate) &&
        Objects.equals(this.endDate, ancillaryRequestAgent.endDate) &&
        Objects.equals(this.quantity, ancillaryRequestAgent.quantity);
  }

  @Override
  public int hashCode() {
    return Objects.hash(typeIdentifier, channelInventoryIdentifier, transactionalTravelInventoryIdentifier, type, startDate, endDate, quantity);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AncillaryRequestAgent {\n");
    sb.append("    typeIdentifier: ").append(toIndentedString(typeIdentifier)).append("\n");
    sb.append("    channelInventoryIdentifier: ").append(toIndentedString(channelInventoryIdentifier)).append("\n");
    sb.append("    transactionalTravelInventoryIdentifier: ").append(toIndentedString(transactionalTravelInventoryIdentifier)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    quantity: ").append(toIndentedString(quantity)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

