/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release   # Booking API Welcome to the Booking Engine API - A programmer-friendly way to book inventory that was found on our platform. We take great care in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive payment-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 25.0.3
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.booking.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import travel.wink.sdk.booking.model.FilterDescriptorBooker;
import travel.wink.sdk.booking.model.GroupDescriptorBooker;
import travel.wink.sdk.booking.model.SortDescriptorBooker;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * StateBooker
 */
@JsonPropertyOrder({
  StateBooker.JSON_PROPERTY_SKIP,
  StateBooker.JSON_PROPERTY_TAKE,
  StateBooker.JSON_PROPERTY_SORT,
  StateBooker.JSON_PROPERTY_FILTER,
  StateBooker.JSON_PROPERTY_GROUP
})
@JsonTypeName("State_Booker")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-03-24T11:13:07.607433685+07:00[Asia/Bangkok]")
public class StateBooker {
  public static final String JSON_PROPERTY_SKIP = "skip";
  private Integer skip = 0;

  public static final String JSON_PROPERTY_TAKE = "take";
  private Integer take = 30;

  public static final String JSON_PROPERTY_SORT = "sort";
  private List<SortDescriptorBooker> sort = null;

  public static final String JSON_PROPERTY_FILTER = "filter";
  private FilterDescriptorBooker filter;

  public static final String JSON_PROPERTY_GROUP = "group";
  private List<GroupDescriptorBooker> group = null;

  public StateBooker() { 
  }

  public StateBooker skip(Integer skip) {
    
    this.skip = skip;
    return this;
  }

   /**
   * Number of records to be skipped by the pager.
   * minimum: 0
   * @return skip
  **/
  @javax.annotation.Nonnull
  @NotNull
 @Min(0)  @ApiModelProperty(example = "0", required = true, value = "Number of records to be skipped by the pager.")
  @JsonProperty(JSON_PROPERTY_SKIP)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getSkip() {
    return skip;
  }


  @JsonProperty(JSON_PROPERTY_SKIP)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSkip(Integer skip) {
    this.skip = skip;
  }


  public StateBooker take(Integer take) {
    
    this.take = take;
    return this;
  }

   /**
   * Number of records to take.
   * minimum: 1
   * maximum: 180
   * @return take
  **/
  @javax.annotation.Nonnull
  @NotNull
 @Min(1) @Max(180)  @ApiModelProperty(example = "10", required = true, value = "Number of records to take.")
  @JsonProperty(JSON_PROPERTY_TAKE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getTake() {
    return take;
  }


  @JsonProperty(JSON_PROPERTY_TAKE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTake(Integer take) {
    this.take = take;
  }


  public StateBooker sort(List<SortDescriptorBooker> sort) {
    
    this.sort = sort;
    return this;
  }

  public StateBooker addSortItem(SortDescriptorBooker sortItem) {
    if (this.sort == null) {
      this.sort = new ArrayList<>();
    }
    this.sort.add(sortItem);
    return this;
  }

   /**
   * Descriptors used for sorting result set.
   * @return sort
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Descriptors used for sorting result set.")
  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SortDescriptorBooker> getSort() {
    return sort;
  }


  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSort(List<SortDescriptorBooker> sort) {
    this.sort = sort;
  }


  public StateBooker filter(FilterDescriptorBooker filter) {
    
    this.filter = filter;
    return this;
  }

   /**
   * Get filter
   * @return filter
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FILTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public FilterDescriptorBooker getFilter() {
    return filter;
  }


  @JsonProperty(JSON_PROPERTY_FILTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFilter(FilterDescriptorBooker filter) {
    this.filter = filter;
  }


  public StateBooker group(List<GroupDescriptorBooker> group) {
    
    this.group = group;
    return this;
  }

  public StateBooker addGroupItem(GroupDescriptorBooker groupItem) {
    if (this.group == null) {
      this.group = new ArrayList<>();
    }
    this.group.add(groupItem);
    return this;
  }

   /**
   * Descriptors to group result sets by.
   * @return group
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Descriptors to group result sets by.")
  @JsonProperty(JSON_PROPERTY_GROUP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<GroupDescriptorBooker> getGroup() {
    return group;
  }


  @JsonProperty(JSON_PROPERTY_GROUP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGroup(List<GroupDescriptorBooker> group) {
    this.group = group;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    StateBooker stateBooker = (StateBooker) o;
    return Objects.equals(this.skip, stateBooker.skip) &&
        Objects.equals(this.take, stateBooker.take) &&
        Objects.equals(this.sort, stateBooker.sort) &&
        Objects.equals(this.filter, stateBooker.filter) &&
        Objects.equals(this.group, stateBooker.group);
  }

  @Override
  public int hashCode() {
    return Objects.hash(skip, take, sort, filter, group);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class StateBooker {\n");
    sb.append("    skip: ").append(toIndentedString(skip)).append("\n");
    sb.append("    take: ").append(toIndentedString(take)).append("\n");
    sb.append("    sort: ").append(toIndentedString(sort)).append("\n");
    sb.append("    filter: ").append(toIndentedString(filter)).append("\n");
    sb.append("    group: ").append(toIndentedString(group)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

