/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.booking.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import travel.wink.sdk.booking.model.GeoNameBooker;

@ApiModel(description="Address information")
@JsonPropertyOrder(value={"address1", "address2", "state", "postalCode", "county", "city"})
@JsonTypeName(value="Address_Booker")
public class AddressBooker {
    public static final String JSON_PROPERTY_ADDRESS1 = "address1";
    private String address1;
    public static final String JSON_PROPERTY_ADDRESS2 = "address2";
    private String address2;
    public static final String JSON_PROPERTY_STATE = "state";
    private String state;
    public static final String JSON_PROPERTY_POSTAL_CODE = "postalCode";
    private String postalCode;
    public static final String JSON_PROPERTY_COUNTY = "county";
    private String county;
    public static final String JSON_PROPERTY_CITY = "city";
    private GeoNameBooker city;

    public AddressBooker address1(String address1) {
        this.address1 = address1;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="234 Near da beach", required=true, value="Address line 1")
    @JsonProperty(value="address1")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAddress1() {
        return this.address1;
    }

    @JsonProperty(value="address1")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAddress1(String address1) {
        this.address1 = address1;
    }

    public AddressBooker address2(String address2) {
        this.address2 = address2;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Pebble #5001", value="Address line 2")
    @JsonProperty(value="address2")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAddress2() {
        return this.address2;
    }

    @JsonProperty(value="address2")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAddress2(String address2) {
        this.address2 = address2;
    }

    public AddressBooker state(String state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="CA", value="State")
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setState(String state) {
        this.state = state;
    }

    public AddressBooker postalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="90210", required=true, value="Postal / zip code")
    @JsonProperty(value="postalCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getPostalCode() {
        return this.postalCode;
    }

    @JsonProperty(value="postalCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public AddressBooker county(String county) {
        this.county = county;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Alameda county", value="County")
    @JsonProperty(value="county")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCounty() {
        return this.county;
    }

    @JsonProperty(value="county")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCounty(String county) {
        this.county = county;
    }

    public AddressBooker city(GeoNameBooker city) {
        this.city = city;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="city")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public GeoNameBooker getCity() {
        return this.city;
    }

    @JsonProperty(value="city")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCity(GeoNameBooker city) {
        this.city = city;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddressBooker addressBooker = (AddressBooker)o;
        return Objects.equals(this.address1, addressBooker.address1) && Objects.equals(this.address2, addressBooker.address2) && Objects.equals(this.state, addressBooker.state) && Objects.equals(this.postalCode, addressBooker.postalCode) && Objects.equals(this.county, addressBooker.county) && Objects.equals(this.city, addressBooker.city);
    }

    public int hashCode() {
        return Objects.hash(this.address1, this.address2, this.state, this.postalCode, this.county, this.city);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AddressBooker {\n");
        sb.append("    address1: ").append(this.toIndentedString(this.address1)).append("\n");
        sb.append("    address2: ").append(this.toIndentedString(this.address2)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    postalCode: ").append(this.toIndentedString(this.postalCode)).append("\n");
        sb.append("    county: ").append(this.toIndentedString(this.county)).append("\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

