/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.booking.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import travel.wink.sdk.booking.model.BookingContractItemBooker;
import travel.wink.sdk.booking.model.BookingContractPaymentDetailsBooker;
import travel.wink.sdk.booking.model.MoneysBooker;
import travel.wink.sdk.booking.model.QuoteBooker;
import travel.wink.sdk.booking.model.RefundBooker;

@ApiModel(description="Booking contract created by TripPay")
@JsonPropertyOrder(value={"bookingContractIdentifier", "createdDate", "lastUpdate", "ipAddress", "traceId", "sourceUrl", "identifier", "supplierIdentifier", "supplierName", "displayPriceQuote", "supplierPriceQuote", "internalPriceQuote", "capturePriceQuote", "itemList", "externalSupplierIdentifier", "externalSupplierBookingCode", "payment", "cancelled", "cancelledOn", "canceller", "cancellationType", "cancellerUserIdentifier", "cancelReason", "fundsProcessed", "refunds", "totalSourcePrice", "totalDisplayPrice", "totalSupplierPrice", "totalInternalPrice", "totalCapturePrice", "totalSourcePriceAfterRefund", "totalDisplayPriceAfterRefund", "totalSupplierPriceAfterRefund", "totalInternalPriceAfterRefund", "totalCapturePriceAfterRefund", "refundedSourcePrice", "refundedDisplayPrice", "refundedSupplierPrice", "refundedInternalPrice", "refundedCapturePrice", "totalTokensEarned", "cancellableBySupplier", "cancellableByTraveler", "cancellableWithNoCharges", "isCancellableWithPotentialCharges", "commissionableTotalSourceAmount", "commissionableTotalCaptureAmount", "commissionableTotalDisplayAmount", "commissionableTotalSupplierAmount", "commissionableTotalInternalAmount"})
@JsonTypeName(value="BookingContract_Booker")
public class BookingContractBooker {
    public static final String JSON_PROPERTY_BOOKING_CONTRACT_IDENTIFIER = "bookingContractIdentifier";
    private UUID bookingContractIdentifier;
    public static final String JSON_PROPERTY_CREATED_DATE = "createdDate";
    private LocalDateTime createdDate;
    public static final String JSON_PROPERTY_LAST_UPDATE = "lastUpdate";
    private LocalDateTime lastUpdate;
    public static final String JSON_PROPERTY_IP_ADDRESS = "ipAddress";
    private String ipAddress;
    public static final String JSON_PROPERTY_TRACE_ID = "traceId";
    private String traceId;
    public static final String JSON_PROPERTY_SOURCE_URL = "sourceUrl";
    private String sourceUrl;
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private UUID identifier;
    public static final String JSON_PROPERTY_SUPPLIER_IDENTIFIER = "supplierIdentifier";
    private UUID supplierIdentifier;
    public static final String JSON_PROPERTY_SUPPLIER_NAME = "supplierName";
    private String supplierName;
    public static final String JSON_PROPERTY_DISPLAY_PRICE_QUOTE = "displayPriceQuote";
    private QuoteBooker displayPriceQuote;
    public static final String JSON_PROPERTY_SUPPLIER_PRICE_QUOTE = "supplierPriceQuote";
    private QuoteBooker supplierPriceQuote;
    public static final String JSON_PROPERTY_INTERNAL_PRICE_QUOTE = "internalPriceQuote";
    private QuoteBooker internalPriceQuote;
    public static final String JSON_PROPERTY_CAPTURE_PRICE_QUOTE = "capturePriceQuote";
    private QuoteBooker capturePriceQuote;
    public static final String JSON_PROPERTY_ITEM_LIST = "itemList";
    private List<BookingContractItemBooker> itemList = new ArrayList<BookingContractItemBooker>();
    public static final String JSON_PROPERTY_EXTERNAL_SUPPLIER_IDENTIFIER = "externalSupplierIdentifier";
    private String externalSupplierIdentifier;
    public static final String JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE = "externalSupplierBookingCode";
    private String externalSupplierBookingCode;
    public static final String JSON_PROPERTY_PAYMENT = "payment";
    private BookingContractPaymentDetailsBooker payment;
    public static final String JSON_PROPERTY_CANCELLED = "cancelled";
    private Boolean cancelled = false;
    public static final String JSON_PROPERTY_CANCELLED_ON = "cancelledOn";
    private LocalDateTime cancelledOn;
    public static final String JSON_PROPERTY_CANCELLER = "canceller";
    private CancellerEnum canceller;
    public static final String JSON_PROPERTY_CANCELLATION_TYPE = "cancellationType";
    private CancellationTypeEnum cancellationType;
    public static final String JSON_PROPERTY_CANCELLER_USER_IDENTIFIER = "cancellerUserIdentifier";
    private String cancellerUserIdentifier;
    public static final String JSON_PROPERTY_CANCEL_REASON = "cancelReason";
    private String cancelReason;
    public static final String JSON_PROPERTY_FUNDS_PROCESSED = "fundsProcessed";
    private Boolean fundsProcessed;
    public static final String JSON_PROPERTY_REFUNDS = "refunds";
    private List<RefundBooker> refunds = null;
    public static final String JSON_PROPERTY_TOTAL_SOURCE_PRICE = "totalSourcePrice";
    private MoneysBooker totalSourcePrice;
    public static final String JSON_PROPERTY_TOTAL_DISPLAY_PRICE = "totalDisplayPrice";
    private MoneysBooker totalDisplayPrice;
    public static final String JSON_PROPERTY_TOTAL_SUPPLIER_PRICE = "totalSupplierPrice";
    private MoneysBooker totalSupplierPrice;
    public static final String JSON_PROPERTY_TOTAL_INTERNAL_PRICE = "totalInternalPrice";
    private MoneysBooker totalInternalPrice;
    public static final String JSON_PROPERTY_TOTAL_CAPTURE_PRICE = "totalCapturePrice";
    private MoneysBooker totalCapturePrice;
    public static final String JSON_PROPERTY_TOTAL_SOURCE_PRICE_AFTER_REFUND = "totalSourcePriceAfterRefund";
    private MoneysBooker totalSourcePriceAfterRefund;
    public static final String JSON_PROPERTY_TOTAL_DISPLAY_PRICE_AFTER_REFUND = "totalDisplayPriceAfterRefund";
    private MoneysBooker totalDisplayPriceAfterRefund;
    public static final String JSON_PROPERTY_TOTAL_SUPPLIER_PRICE_AFTER_REFUND = "totalSupplierPriceAfterRefund";
    private MoneysBooker totalSupplierPriceAfterRefund;
    public static final String JSON_PROPERTY_TOTAL_INTERNAL_PRICE_AFTER_REFUND = "totalInternalPriceAfterRefund";
    private MoneysBooker totalInternalPriceAfterRefund;
    public static final String JSON_PROPERTY_TOTAL_CAPTURE_PRICE_AFTER_REFUND = "totalCapturePriceAfterRefund";
    private MoneysBooker totalCapturePriceAfterRefund;
    public static final String JSON_PROPERTY_REFUNDED_SOURCE_PRICE = "refundedSourcePrice";
    private MoneysBooker refundedSourcePrice;
    public static final String JSON_PROPERTY_REFUNDED_DISPLAY_PRICE = "refundedDisplayPrice";
    private MoneysBooker refundedDisplayPrice;
    public static final String JSON_PROPERTY_REFUNDED_SUPPLIER_PRICE = "refundedSupplierPrice";
    private MoneysBooker refundedSupplierPrice;
    public static final String JSON_PROPERTY_REFUNDED_INTERNAL_PRICE = "refundedInternalPrice";
    private MoneysBooker refundedInternalPrice;
    public static final String JSON_PROPERTY_REFUNDED_CAPTURE_PRICE = "refundedCapturePrice";
    private MoneysBooker refundedCapturePrice;
    public static final String JSON_PROPERTY_TOTAL_TOKENS_EARNED = "totalTokensEarned";
    private Long totalTokensEarned;
    public static final String JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER = "cancellableBySupplier";
    private Boolean cancellableBySupplier;
    public static final String JSON_PROPERTY_CANCELLABLE_BY_TRAVELER = "cancellableByTraveler";
    private Boolean cancellableByTraveler;
    public static final String JSON_PROPERTY_CANCELLABLE_WITH_NO_CHARGES = "cancellableWithNoCharges";
    private Boolean cancellableWithNoCharges;
    public static final String JSON_PROPERTY_IS_CANCELLABLE_WITH_POTENTIAL_CHARGES = "isCancellableWithPotentialCharges";
    private Boolean isCancellableWithPotentialCharges;
    public static final String JSON_PROPERTY_COMMISSIONABLE_TOTAL_SOURCE_AMOUNT = "commissionableTotalSourceAmount";
    private MoneysBooker commissionableTotalSourceAmount;
    public static final String JSON_PROPERTY_COMMISSIONABLE_TOTAL_CAPTURE_AMOUNT = "commissionableTotalCaptureAmount";
    private MoneysBooker commissionableTotalCaptureAmount;
    public static final String JSON_PROPERTY_COMMISSIONABLE_TOTAL_DISPLAY_AMOUNT = "commissionableTotalDisplayAmount";
    private MoneysBooker commissionableTotalDisplayAmount;
    public static final String JSON_PROPERTY_COMMISSIONABLE_TOTAL_SUPPLIER_AMOUNT = "commissionableTotalSupplierAmount";
    private MoneysBooker commissionableTotalSupplierAmount;
    public static final String JSON_PROPERTY_COMMISSIONABLE_TOTAL_INTERNAL_AMOUNT = "commissionableTotalInternalAmount";
    private MoneysBooker commissionableTotalInternalAmount;

    public BookingContractBooker bookingContractIdentifier(UUID bookingContractIdentifier) {
        this.bookingContractIdentifier = bookingContractIdentifier;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Document UUID")
    @JsonProperty(value="bookingContractIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getBookingContractIdentifier() {
        return this.bookingContractIdentifier;
    }

    @JsonProperty(value="bookingContractIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBookingContractIdentifier(UUID bookingContractIdentifier) {
        this.bookingContractIdentifier = bookingContractIdentifier;
    }

    public BookingContractBooker createdDate(LocalDateTime createdDate) {
        this.createdDate = createdDate;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Datetime this record was first created")
    @JsonProperty(value="createdDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDateTime getCreatedDate() {
        return this.createdDate;
    }

    @JsonProperty(value="createdDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedDate(LocalDateTime createdDate) {
        this.createdDate = createdDate;
    }

    public BookingContractBooker lastUpdate(LocalDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Datetime this record was last updated")
    @JsonProperty(value="lastUpdate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDateTime getLastUpdate() {
        return this.lastUpdate;
    }

    @JsonProperty(value="lastUpdate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLastUpdate(LocalDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public BookingContractBooker ipAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="111.222.333.444", required=true, value="Caller's IP address")
    @JsonProperty(value="ipAddress")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getIpAddress() {
        return this.ipAddress;
    }

    @JsonProperty(value="ipAddress")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public BookingContractBooker traceId(String traceId) {
        this.traceId = traceId;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="T-123456", required=true, value="Way to track which booking contracts were made together")
    @JsonProperty(value="traceId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTraceId() {
        return this.traceId;
    }

    @JsonProperty(value="traceId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public BookingContractBooker sourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="https://www.traveliko.com", required=true, value="Where did the booking occur")
    @JsonProperty(value="sourceUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSourceUrl() {
        return this.sourceUrl;
    }

    @JsonProperty(value="sourceUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    public BookingContractBooker identifier(UUID identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Unique identifier used to track the contract. Create a UUID for this purpose.")
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIdentifier(UUID identifier) {
        this.identifier = identifier;
    }

    public BookingContractBooker supplierIdentifier(UUID supplierIdentifier) {
        this.supplierIdentifier = supplierIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Supplier identifier")
    @JsonProperty(value="supplierIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getSupplierIdentifier() {
        return this.supplierIdentifier;
    }

    @JsonProperty(value="supplierIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupplierIdentifier(UUID supplierIdentifier) {
        this.supplierIdentifier = supplierIdentifier;
    }

    public BookingContractBooker supplierName(String supplierName) {
        this.supplierName = supplierName;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="Supplier One", required=true, value="Supplier name")
    @JsonProperty(value="supplierName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSupplierName() {
        return this.supplierName;
    }

    @JsonProperty(value="supplierName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public BookingContractBooker displayPriceQuote(QuoteBooker displayPriceQuote) {
        this.displayPriceQuote = displayPriceQuote;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="displayPriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public QuoteBooker getDisplayPriceQuote() {
        return this.displayPriceQuote;
    }

    @JsonProperty(value="displayPriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDisplayPriceQuote(QuoteBooker displayPriceQuote) {
        this.displayPriceQuote = displayPriceQuote;
    }

    public BookingContractBooker supplierPriceQuote(QuoteBooker supplierPriceQuote) {
        this.supplierPriceQuote = supplierPriceQuote;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="supplierPriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public QuoteBooker getSupplierPriceQuote() {
        return this.supplierPriceQuote;
    }

    @JsonProperty(value="supplierPriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupplierPriceQuote(QuoteBooker supplierPriceQuote) {
        this.supplierPriceQuote = supplierPriceQuote;
    }

    public BookingContractBooker internalPriceQuote(QuoteBooker internalPriceQuote) {
        this.internalPriceQuote = internalPriceQuote;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="internalPriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public QuoteBooker getInternalPriceQuote() {
        return this.internalPriceQuote;
    }

    @JsonProperty(value="internalPriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setInternalPriceQuote(QuoteBooker internalPriceQuote) {
        this.internalPriceQuote = internalPriceQuote;
    }

    public BookingContractBooker capturePriceQuote(QuoteBooker capturePriceQuote) {
        this.capturePriceQuote = capturePriceQuote;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="capturePriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public QuoteBooker getCapturePriceQuote() {
        return this.capturePriceQuote;
    }

    @JsonProperty(value="capturePriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCapturePriceQuote(QuoteBooker capturePriceQuote) {
        this.capturePriceQuote = capturePriceQuote;
    }

    public BookingContractBooker itemList(List<BookingContractItemBooker> itemList) {
        this.itemList = itemList;
        return this;
    }

    public BookingContractBooker addItemListItem(BookingContractItemBooker itemListItem) {
        this.itemList.add(itemListItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1, max=0x7FFFFFFF)
    @ApiModelProperty(required=true, value="Holds one booking line item for a specific supplier.")
    @JsonProperty(value="itemList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1, max=0x7FFFFFFF) List<BookingContractItemBooker> getItemList() {
        return this.itemList;
    }

    @JsonProperty(value="itemList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setItemList(List<BookingContractItemBooker> itemList) {
        this.itemList = itemList;
    }

    public BookingContractBooker externalSupplierIdentifier(String externalSupplierIdentifier) {
        this.externalSupplierIdentifier = externalSupplierIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="supplier-a", value="Contract creator can choose to geoname this record with her own identifier")
    @JsonProperty(value="externalSupplierIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalSupplierIdentifier() {
        return this.externalSupplierIdentifier;
    }

    @JsonProperty(value="externalSupplierIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExternalSupplierIdentifier(String externalSupplierIdentifier) {
        this.externalSupplierIdentifier = externalSupplierIdentifier;
    }

    public BookingContractBooker externalSupplierBookingCode(String externalSupplierBookingCode) {
        this.externalSupplierBookingCode = externalSupplierBookingCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="external-booking-code-1", value="External booking code generated by the affiliate")
    @JsonProperty(value="externalSupplierBookingCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalSupplierBookingCode() {
        return this.externalSupplierBookingCode;
    }

    @JsonProperty(value="externalSupplierBookingCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExternalSupplierBookingCode(String externalSupplierBookingCode) {
        this.externalSupplierBookingCode = externalSupplierBookingCode;
    }

    public BookingContractBooker payment(BookingContractPaymentDetailsBooker payment) {
        this.payment = payment;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="payment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BookingContractPaymentDetailsBooker getPayment() {
        return this.payment;
    }

    @JsonProperty(value="payment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPayment(BookingContractPaymentDetailsBooker payment) {
        this.payment = payment;
    }

    public BookingContractBooker cancelled(Boolean cancelled) {
        this.cancelled = cancelled;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Optional geoname externalIdentifier to remote inventory.")
    @JsonProperty(value="cancelled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCancelled() {
        return this.cancelled;
    }

    @JsonProperty(value="cancelled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancelled(Boolean cancelled) {
        this.cancelled = cancelled;
    }

    public BookingContractBooker cancelledOn(LocalDateTime cancelledOn) {
        this.cancelledOn = cancelledOn;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="When the booking was cancelled.")
    @JsonProperty(value="cancelledOn")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDateTime getCancelledOn() {
        return this.cancelledOn;
    }

    @JsonProperty(value="cancelledOn")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancelledOn(LocalDateTime cancelledOn) {
        this.cancelledOn = cancelledOn;
    }

    public BookingContractBooker canceller(CancellerEnum canceller) {
        this.canceller = canceller;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Type of entity that cancelled the booking.")
    @JsonProperty(value="canceller")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CancellerEnum getCanceller() {
        return this.canceller;
    }

    @JsonProperty(value="canceller")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCanceller(CancellerEnum canceller) {
        this.canceller = canceller;
    }

    public BookingContractBooker cancellationType(CancellationTypeEnum cancellationType) {
        this.cancellationType = cancellationType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Reason type.")
    @JsonProperty(value="cancellationType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CancellationTypeEnum getCancellationType() {
        return this.cancellationType;
    }

    @JsonProperty(value="cancellationType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellationType(CancellationTypeEnum cancellationType) {
        this.cancellationType = cancellationType;
    }

    public BookingContractBooker cancellerUserIdentifier(String cancellerUserIdentifier) {
        this.cancellerUserIdentifier = cancellerUserIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="User identifier that cancelled the entity.")
    @JsonProperty(value="cancellerUserIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCancellerUserIdentifier() {
        return this.cancellerUserIdentifier;
    }

    @JsonProperty(value="cancellerUserIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellerUserIdentifier(String cancellerUserIdentifier) {
        this.cancellerUserIdentifier = cancellerUserIdentifier;
    }

    public BookingContractBooker cancelReason(String cancelReason) {
        this.cancelReason = cancelReason;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Reason for cancellation.")
    @JsonProperty(value="cancelReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCancelReason() {
        return this.cancelReason;
    }

    @JsonProperty(value="cancelReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancelReason(String cancelReason) {
        this.cancelReason = cancelReason;
    }

    public BookingContractBooker fundsProcessed(Boolean fundsProcessed) {
        this.fundsProcessed = fundsProcessed;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Whether a funds transfer request has been created for this booking.")
    @JsonProperty(value="fundsProcessed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getFundsProcessed() {
        return this.fundsProcessed;
    }

    @JsonProperty(value="fundsProcessed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFundsProcessed(Boolean fundsProcessed) {
        this.fundsProcessed = fundsProcessed;
    }

    public BookingContractBooker refunds(List<RefundBooker> refunds) {
        this.refunds = refunds;
        return this;
    }

    public BookingContractBooker addRefundsItem(RefundBooker refundsItem) {
        if (this.refunds == null) {
            this.refunds = new ArrayList<RefundBooker>();
        }
        this.refunds.add(refundsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="An optional list of refunds that occurred with this booking. If the refund amount(s) is the same as the total price, the booking also gets cancelled.")
    @JsonProperty(value="refunds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<RefundBooker> getRefunds() {
        return this.refunds;
    }

    @JsonProperty(value="refunds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRefunds(List<RefundBooker> refunds) {
        this.refunds = refunds;
    }

    public BookingContractBooker totalSourcePrice(MoneysBooker totalSourcePrice) {
        this.totalSourcePrice = totalSourcePrice;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="totalSourcePrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MoneysBooker getTotalSourcePrice() {
        return this.totalSourcePrice;
    }

    @JsonProperty(value="totalSourcePrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalSourcePrice(MoneysBooker totalSourcePrice) {
        this.totalSourcePrice = totalSourcePrice;
    }

    public BookingContractBooker totalDisplayPrice(MoneysBooker totalDisplayPrice) {
        this.totalDisplayPrice = totalDisplayPrice;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="totalDisplayPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MoneysBooker getTotalDisplayPrice() {
        return this.totalDisplayPrice;
    }

    @JsonProperty(value="totalDisplayPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalDisplayPrice(MoneysBooker totalDisplayPrice) {
        this.totalDisplayPrice = totalDisplayPrice;
    }

    public BookingContractBooker totalSupplierPrice(MoneysBooker totalSupplierPrice) {
        this.totalSupplierPrice = totalSupplierPrice;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="totalSupplierPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MoneysBooker getTotalSupplierPrice() {
        return this.totalSupplierPrice;
    }

    @JsonProperty(value="totalSupplierPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalSupplierPrice(MoneysBooker totalSupplierPrice) {
        this.totalSupplierPrice = totalSupplierPrice;
    }

    public BookingContractBooker totalInternalPrice(MoneysBooker totalInternalPrice) {
        this.totalInternalPrice = totalInternalPrice;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="totalInternalPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MoneysBooker getTotalInternalPrice() {
        return this.totalInternalPrice;
    }

    @JsonProperty(value="totalInternalPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalInternalPrice(MoneysBooker totalInternalPrice) {
        this.totalInternalPrice = totalInternalPrice;
    }

    public BookingContractBooker totalCapturePrice(MoneysBooker totalCapturePrice) {
        this.totalCapturePrice = totalCapturePrice;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="totalCapturePrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MoneysBooker getTotalCapturePrice() {
        return this.totalCapturePrice;
    }

    @JsonProperty(value="totalCapturePrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalCapturePrice(MoneysBooker totalCapturePrice) {
        this.totalCapturePrice = totalCapturePrice;
    }

    public BookingContractBooker totalSourcePriceAfterRefund(MoneysBooker totalSourcePriceAfterRefund) {
        this.totalSourcePriceAfterRefund = totalSourcePriceAfterRefund;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="totalSourcePriceAfterRefund")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MoneysBooker getTotalSourcePriceAfterRefund() {
        return this.totalSourcePriceAfterRefund;
    }

    @JsonProperty(value="totalSourcePriceAfterRefund")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalSourcePriceAfterRefund(MoneysBooker totalSourcePriceAfterRefund) {
        this.totalSourcePriceAfterRefund = totalSourcePriceAfterRefund;
    }

    public BookingContractBooker totalDisplayPriceAfterRefund(MoneysBooker totalDisplayPriceAfterRefund) {
        this.totalDisplayPriceAfterRefund = totalDisplayPriceAfterRefund;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="totalDisplayPriceAfterRefund")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MoneysBooker getTotalDisplayPriceAfterRefund() {
        return this.totalDisplayPriceAfterRefund;
    }

    @JsonProperty(value="totalDisplayPriceAfterRefund")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalDisplayPriceAfterRefund(MoneysBooker totalDisplayPriceAfterRefund) {
        this.totalDisplayPriceAfterRefund = totalDisplayPriceAfterRefund;
    }

    public BookingContractBooker totalSupplierPriceAfterRefund(MoneysBooker totalSupplierPriceAfterRefund) {
        this.totalSupplierPriceAfterRefund = totalSupplierPriceAfterRefund;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="totalSupplierPriceAfterRefund")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MoneysBooker getTotalSupplierPriceAfterRefund() {
        return this.totalSupplierPriceAfterRefund;
    }

    @JsonProperty(value="totalSupplierPriceAfterRefund")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalSupplierPriceAfterRefund(MoneysBooker totalSupplierPriceAfterRefund) {
        this.totalSupplierPriceAfterRefund = totalSupplierPriceAfterRefund;
    }

    public BookingContractBooker totalInternalPriceAfterRefund(MoneysBooker totalInternalPriceAfterRefund) {
        this.totalInternalPriceAfterRefund = totalInternalPriceAfterRefund;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="totalInternalPriceAfterRefund")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MoneysBooker getTotalInternalPriceAfterRefund() {
        return this.totalInternalPriceAfterRefund;
    }

    @JsonProperty(value="totalInternalPriceAfterRefund")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalInternalPriceAfterRefund(MoneysBooker totalInternalPriceAfterRefund) {
        this.totalInternalPriceAfterRefund = totalInternalPriceAfterRefund;
    }

    public BookingContractBooker totalCapturePriceAfterRefund(MoneysBooker totalCapturePriceAfterRefund) {
        this.totalCapturePriceAfterRefund = totalCapturePriceAfterRefund;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="totalCapturePriceAfterRefund")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MoneysBooker getTotalCapturePriceAfterRefund() {
        return this.totalCapturePriceAfterRefund;
    }

    @JsonProperty(value="totalCapturePriceAfterRefund")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalCapturePriceAfterRefund(MoneysBooker totalCapturePriceAfterRefund) {
        this.totalCapturePriceAfterRefund = totalCapturePriceAfterRefund;
    }

    public BookingContractBooker refundedSourcePrice(MoneysBooker refundedSourcePrice) {
        this.refundedSourcePrice = refundedSourcePrice;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="refundedSourcePrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MoneysBooker getRefundedSourcePrice() {
        return this.refundedSourcePrice;
    }

    @JsonProperty(value="refundedSourcePrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRefundedSourcePrice(MoneysBooker refundedSourcePrice) {
        this.refundedSourcePrice = refundedSourcePrice;
    }

    public BookingContractBooker refundedDisplayPrice(MoneysBooker refundedDisplayPrice) {
        this.refundedDisplayPrice = refundedDisplayPrice;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="refundedDisplayPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MoneysBooker getRefundedDisplayPrice() {
        return this.refundedDisplayPrice;
    }

    @JsonProperty(value="refundedDisplayPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRefundedDisplayPrice(MoneysBooker refundedDisplayPrice) {
        this.refundedDisplayPrice = refundedDisplayPrice;
    }

    public BookingContractBooker refundedSupplierPrice(MoneysBooker refundedSupplierPrice) {
        this.refundedSupplierPrice = refundedSupplierPrice;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="refundedSupplierPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MoneysBooker getRefundedSupplierPrice() {
        return this.refundedSupplierPrice;
    }

    @JsonProperty(value="refundedSupplierPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRefundedSupplierPrice(MoneysBooker refundedSupplierPrice) {
        this.refundedSupplierPrice = refundedSupplierPrice;
    }

    public BookingContractBooker refundedInternalPrice(MoneysBooker refundedInternalPrice) {
        this.refundedInternalPrice = refundedInternalPrice;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="refundedInternalPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MoneysBooker getRefundedInternalPrice() {
        return this.refundedInternalPrice;
    }

    @JsonProperty(value="refundedInternalPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRefundedInternalPrice(MoneysBooker refundedInternalPrice) {
        this.refundedInternalPrice = refundedInternalPrice;
    }

    public BookingContractBooker refundedCapturePrice(MoneysBooker refundedCapturePrice) {
        this.refundedCapturePrice = refundedCapturePrice;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="refundedCapturePrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MoneysBooker getRefundedCapturePrice() {
        return this.refundedCapturePrice;
    }

    @JsonProperty(value="refundedCapturePrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRefundedCapturePrice(MoneysBooker refundedCapturePrice) {
        this.refundedCapturePrice = refundedCapturePrice;
    }

    public BookingContractBooker totalTokensEarned(Long totalTokensEarned) {
        this.totalTokensEarned = totalTokensEarned;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Total amount of tokens minted on this contract.")
    @JsonProperty(value="totalTokensEarned")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getTotalTokensEarned() {
        return this.totalTokensEarned;
    }

    @JsonProperty(value="totalTokensEarned")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalTokensEarned(Long totalTokensEarned) {
        this.totalTokensEarned = totalTokensEarned;
    }

    public BookingContractBooker cancellableBySupplier(Boolean cancellableBySupplier) {
        this.cancellableBySupplier = cancellableBySupplier;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether the booking can still be cancelled completely by the supplier.")
    @JsonProperty(value="cancellableBySupplier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCancellableBySupplier() {
        return this.cancellableBySupplier;
    }

    @JsonProperty(value="cancellableBySupplier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellableBySupplier(Boolean cancellableBySupplier) {
        this.cancellableBySupplier = cancellableBySupplier;
    }

    public BookingContractBooker cancellableByTraveler(Boolean cancellableByTraveler) {
        this.cancellableByTraveler = cancellableByTraveler;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether the booking can still be cancelled completely by the traveller.")
    @JsonProperty(value="cancellableByTraveler")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCancellableByTraveler() {
        return this.cancellableByTraveler;
    }

    @JsonProperty(value="cancellableByTraveler")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellableByTraveler(Boolean cancellableByTraveler) {
        this.cancellableByTraveler = cancellableByTraveler;
    }

    public BookingContractBooker cancellableWithNoCharges(Boolean cancellableWithNoCharges) {
        this.cancellableWithNoCharges = cancellableWithNoCharges;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether the cancellation comes at no cost to the traveler.")
    @JsonProperty(value="cancellableWithNoCharges")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCancellableWithNoCharges() {
        return this.cancellableWithNoCharges;
    }

    @JsonProperty(value="cancellableWithNoCharges")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellableWithNoCharges(Boolean cancellableWithNoCharges) {
        this.cancellableWithNoCharges = cancellableWithNoCharges;
    }

    public BookingContractBooker isCancellableWithPotentialCharges(Boolean isCancellableWithPotentialCharges) {
        this.isCancellableWithPotentialCharges = isCancellableWithPotentialCharges;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether a cancellation comes with partial charges. I.e. Only some of the items in contract are not fully refundable.")
    @JsonProperty(value="isCancellableWithPotentialCharges")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsCancellableWithPotentialCharges() {
        return this.isCancellableWithPotentialCharges;
    }

    @JsonProperty(value="isCancellableWithPotentialCharges")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIsCancellableWithPotentialCharges(Boolean isCancellableWithPotentialCharges) {
        this.isCancellableWithPotentialCharges = isCancellableWithPotentialCharges;
    }

    public BookingContractBooker commissionableTotalSourceAmount(MoneysBooker commissionableTotalSourceAmount) {
        this.commissionableTotalSourceAmount = commissionableTotalSourceAmount;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="commissionableTotalSourceAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MoneysBooker getCommissionableTotalSourceAmount() {
        return this.commissionableTotalSourceAmount;
    }

    @JsonProperty(value="commissionableTotalSourceAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCommissionableTotalSourceAmount(MoneysBooker commissionableTotalSourceAmount) {
        this.commissionableTotalSourceAmount = commissionableTotalSourceAmount;
    }

    public BookingContractBooker commissionableTotalCaptureAmount(MoneysBooker commissionableTotalCaptureAmount) {
        this.commissionableTotalCaptureAmount = commissionableTotalCaptureAmount;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="commissionableTotalCaptureAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MoneysBooker getCommissionableTotalCaptureAmount() {
        return this.commissionableTotalCaptureAmount;
    }

    @JsonProperty(value="commissionableTotalCaptureAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCommissionableTotalCaptureAmount(MoneysBooker commissionableTotalCaptureAmount) {
        this.commissionableTotalCaptureAmount = commissionableTotalCaptureAmount;
    }

    public BookingContractBooker commissionableTotalDisplayAmount(MoneysBooker commissionableTotalDisplayAmount) {
        this.commissionableTotalDisplayAmount = commissionableTotalDisplayAmount;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="commissionableTotalDisplayAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MoneysBooker getCommissionableTotalDisplayAmount() {
        return this.commissionableTotalDisplayAmount;
    }

    @JsonProperty(value="commissionableTotalDisplayAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCommissionableTotalDisplayAmount(MoneysBooker commissionableTotalDisplayAmount) {
        this.commissionableTotalDisplayAmount = commissionableTotalDisplayAmount;
    }

    public BookingContractBooker commissionableTotalSupplierAmount(MoneysBooker commissionableTotalSupplierAmount) {
        this.commissionableTotalSupplierAmount = commissionableTotalSupplierAmount;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="commissionableTotalSupplierAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MoneysBooker getCommissionableTotalSupplierAmount() {
        return this.commissionableTotalSupplierAmount;
    }

    @JsonProperty(value="commissionableTotalSupplierAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCommissionableTotalSupplierAmount(MoneysBooker commissionableTotalSupplierAmount) {
        this.commissionableTotalSupplierAmount = commissionableTotalSupplierAmount;
    }

    public BookingContractBooker commissionableTotalInternalAmount(MoneysBooker commissionableTotalInternalAmount) {
        this.commissionableTotalInternalAmount = commissionableTotalInternalAmount;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="commissionableTotalInternalAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MoneysBooker getCommissionableTotalInternalAmount() {
        return this.commissionableTotalInternalAmount;
    }

    @JsonProperty(value="commissionableTotalInternalAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCommissionableTotalInternalAmount(MoneysBooker commissionableTotalInternalAmount) {
        this.commissionableTotalInternalAmount = commissionableTotalInternalAmount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BookingContractBooker bookingContractBooker = (BookingContractBooker)o;
        return Objects.equals(this.bookingContractIdentifier, bookingContractBooker.bookingContractIdentifier) && Objects.equals(this.createdDate, bookingContractBooker.createdDate) && Objects.equals(this.lastUpdate, bookingContractBooker.lastUpdate) && Objects.equals(this.ipAddress, bookingContractBooker.ipAddress) && Objects.equals(this.traceId, bookingContractBooker.traceId) && Objects.equals(this.sourceUrl, bookingContractBooker.sourceUrl) && Objects.equals(this.identifier, bookingContractBooker.identifier) && Objects.equals(this.supplierIdentifier, bookingContractBooker.supplierIdentifier) && Objects.equals(this.supplierName, bookingContractBooker.supplierName) && Objects.equals(this.displayPriceQuote, bookingContractBooker.displayPriceQuote) && Objects.equals(this.supplierPriceQuote, bookingContractBooker.supplierPriceQuote) && Objects.equals(this.internalPriceQuote, bookingContractBooker.internalPriceQuote) && Objects.equals(this.capturePriceQuote, bookingContractBooker.capturePriceQuote) && Objects.equals(this.itemList, bookingContractBooker.itemList) && Objects.equals(this.externalSupplierIdentifier, bookingContractBooker.externalSupplierIdentifier) && Objects.equals(this.externalSupplierBookingCode, bookingContractBooker.externalSupplierBookingCode) && Objects.equals(this.payment, bookingContractBooker.payment) && Objects.equals(this.cancelled, bookingContractBooker.cancelled) && Objects.equals(this.cancelledOn, bookingContractBooker.cancelledOn) && Objects.equals((Object)this.canceller, (Object)bookingContractBooker.canceller) && Objects.equals((Object)this.cancellationType, (Object)bookingContractBooker.cancellationType) && Objects.equals(this.cancellerUserIdentifier, bookingContractBooker.cancellerUserIdentifier) && Objects.equals(this.cancelReason, bookingContractBooker.cancelReason) && Objects.equals(this.fundsProcessed, bookingContractBooker.fundsProcessed) && Objects.equals(this.refunds, bookingContractBooker.refunds) && Objects.equals(this.totalSourcePrice, bookingContractBooker.totalSourcePrice) && Objects.equals(this.totalDisplayPrice, bookingContractBooker.totalDisplayPrice) && Objects.equals(this.totalSupplierPrice, bookingContractBooker.totalSupplierPrice) && Objects.equals(this.totalInternalPrice, bookingContractBooker.totalInternalPrice) && Objects.equals(this.totalCapturePrice, bookingContractBooker.totalCapturePrice) && Objects.equals(this.totalSourcePriceAfterRefund, bookingContractBooker.totalSourcePriceAfterRefund) && Objects.equals(this.totalDisplayPriceAfterRefund, bookingContractBooker.totalDisplayPriceAfterRefund) && Objects.equals(this.totalSupplierPriceAfterRefund, bookingContractBooker.totalSupplierPriceAfterRefund) && Objects.equals(this.totalInternalPriceAfterRefund, bookingContractBooker.totalInternalPriceAfterRefund) && Objects.equals(this.totalCapturePriceAfterRefund, bookingContractBooker.totalCapturePriceAfterRefund) && Objects.equals(this.refundedSourcePrice, bookingContractBooker.refundedSourcePrice) && Objects.equals(this.refundedDisplayPrice, bookingContractBooker.refundedDisplayPrice) && Objects.equals(this.refundedSupplierPrice, bookingContractBooker.refundedSupplierPrice) && Objects.equals(this.refundedInternalPrice, bookingContractBooker.refundedInternalPrice) && Objects.equals(this.refundedCapturePrice, bookingContractBooker.refundedCapturePrice) && Objects.equals(this.totalTokensEarned, bookingContractBooker.totalTokensEarned) && Objects.equals(this.cancellableBySupplier, bookingContractBooker.cancellableBySupplier) && Objects.equals(this.cancellableByTraveler, bookingContractBooker.cancellableByTraveler) && Objects.equals(this.cancellableWithNoCharges, bookingContractBooker.cancellableWithNoCharges) && Objects.equals(this.isCancellableWithPotentialCharges, bookingContractBooker.isCancellableWithPotentialCharges) && Objects.equals(this.commissionableTotalSourceAmount, bookingContractBooker.commissionableTotalSourceAmount) && Objects.equals(this.commissionableTotalCaptureAmount, bookingContractBooker.commissionableTotalCaptureAmount) && Objects.equals(this.commissionableTotalDisplayAmount, bookingContractBooker.commissionableTotalDisplayAmount) && Objects.equals(this.commissionableTotalSupplierAmount, bookingContractBooker.commissionableTotalSupplierAmount) && Objects.equals(this.commissionableTotalInternalAmount, bookingContractBooker.commissionableTotalInternalAmount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bookingContractIdentifier, this.createdDate, this.lastUpdate, this.ipAddress, this.traceId, this.sourceUrl, this.identifier, this.supplierIdentifier, this.supplierName, this.displayPriceQuote, this.supplierPriceQuote, this.internalPriceQuote, this.capturePriceQuote, this.itemList, this.externalSupplierIdentifier, this.externalSupplierBookingCode, this.payment, this.cancelled, this.cancelledOn, this.canceller, this.cancellationType, this.cancellerUserIdentifier, this.cancelReason, this.fundsProcessed, this.refunds, this.totalSourcePrice, this.totalDisplayPrice, this.totalSupplierPrice, this.totalInternalPrice, this.totalCapturePrice, this.totalSourcePriceAfterRefund, this.totalDisplayPriceAfterRefund, this.totalSupplierPriceAfterRefund, this.totalInternalPriceAfterRefund, this.totalCapturePriceAfterRefund, this.refundedSourcePrice, this.refundedDisplayPrice, this.refundedSupplierPrice, this.refundedInternalPrice, this.refundedCapturePrice, this.totalTokensEarned, this.cancellableBySupplier, this.cancellableByTraveler, this.cancellableWithNoCharges, this.isCancellableWithPotentialCharges, this.commissionableTotalSourceAmount, this.commissionableTotalCaptureAmount, this.commissionableTotalDisplayAmount, this.commissionableTotalSupplierAmount, this.commissionableTotalInternalAmount});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BookingContractBooker {\n");
        sb.append("    bookingContractIdentifier: ").append(this.toIndentedString(this.bookingContractIdentifier)).append("\n");
        sb.append("    createdDate: ").append(this.toIndentedString(this.createdDate)).append("\n");
        sb.append("    lastUpdate: ").append(this.toIndentedString(this.lastUpdate)).append("\n");
        sb.append("    ipAddress: ").append(this.toIndentedString(this.ipAddress)).append("\n");
        sb.append("    traceId: ").append(this.toIndentedString(this.traceId)).append("\n");
        sb.append("    sourceUrl: ").append(this.toIndentedString(this.sourceUrl)).append("\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    supplierIdentifier: ").append(this.toIndentedString(this.supplierIdentifier)).append("\n");
        sb.append("    supplierName: ").append(this.toIndentedString(this.supplierName)).append("\n");
        sb.append("    displayPriceQuote: ").append(this.toIndentedString(this.displayPriceQuote)).append("\n");
        sb.append("    supplierPriceQuote: ").append(this.toIndentedString(this.supplierPriceQuote)).append("\n");
        sb.append("    internalPriceQuote: ").append(this.toIndentedString(this.internalPriceQuote)).append("\n");
        sb.append("    capturePriceQuote: ").append(this.toIndentedString(this.capturePriceQuote)).append("\n");
        sb.append("    itemList: ").append(this.toIndentedString(this.itemList)).append("\n");
        sb.append("    externalSupplierIdentifier: ").append(this.toIndentedString(this.externalSupplierIdentifier)).append("\n");
        sb.append("    externalSupplierBookingCode: ").append(this.toIndentedString(this.externalSupplierBookingCode)).append("\n");
        sb.append("    payment: ").append(this.toIndentedString(this.payment)).append("\n");
        sb.append("    cancelled: ").append(this.toIndentedString(this.cancelled)).append("\n");
        sb.append("    cancelledOn: ").append(this.toIndentedString(this.cancelledOn)).append("\n");
        sb.append("    canceller: ").append(this.toIndentedString((Object)this.canceller)).append("\n");
        sb.append("    cancellationType: ").append(this.toIndentedString((Object)this.cancellationType)).append("\n");
        sb.append("    cancellerUserIdentifier: ").append(this.toIndentedString(this.cancellerUserIdentifier)).append("\n");
        sb.append("    cancelReason: ").append(this.toIndentedString(this.cancelReason)).append("\n");
        sb.append("    fundsProcessed: ").append(this.toIndentedString(this.fundsProcessed)).append("\n");
        sb.append("    refunds: ").append(this.toIndentedString(this.refunds)).append("\n");
        sb.append("    totalSourcePrice: ").append(this.toIndentedString(this.totalSourcePrice)).append("\n");
        sb.append("    totalDisplayPrice: ").append(this.toIndentedString(this.totalDisplayPrice)).append("\n");
        sb.append("    totalSupplierPrice: ").append(this.toIndentedString(this.totalSupplierPrice)).append("\n");
        sb.append("    totalInternalPrice: ").append(this.toIndentedString(this.totalInternalPrice)).append("\n");
        sb.append("    totalCapturePrice: ").append(this.toIndentedString(this.totalCapturePrice)).append("\n");
        sb.append("    totalSourcePriceAfterRefund: ").append(this.toIndentedString(this.totalSourcePriceAfterRefund)).append("\n");
        sb.append("    totalDisplayPriceAfterRefund: ").append(this.toIndentedString(this.totalDisplayPriceAfterRefund)).append("\n");
        sb.append("    totalSupplierPriceAfterRefund: ").append(this.toIndentedString(this.totalSupplierPriceAfterRefund)).append("\n");
        sb.append("    totalInternalPriceAfterRefund: ").append(this.toIndentedString(this.totalInternalPriceAfterRefund)).append("\n");
        sb.append("    totalCapturePriceAfterRefund: ").append(this.toIndentedString(this.totalCapturePriceAfterRefund)).append("\n");
        sb.append("    refundedSourcePrice: ").append(this.toIndentedString(this.refundedSourcePrice)).append("\n");
        sb.append("    refundedDisplayPrice: ").append(this.toIndentedString(this.refundedDisplayPrice)).append("\n");
        sb.append("    refundedSupplierPrice: ").append(this.toIndentedString(this.refundedSupplierPrice)).append("\n");
        sb.append("    refundedInternalPrice: ").append(this.toIndentedString(this.refundedInternalPrice)).append("\n");
        sb.append("    refundedCapturePrice: ").append(this.toIndentedString(this.refundedCapturePrice)).append("\n");
        sb.append("    totalTokensEarned: ").append(this.toIndentedString(this.totalTokensEarned)).append("\n");
        sb.append("    cancellableBySupplier: ").append(this.toIndentedString(this.cancellableBySupplier)).append("\n");
        sb.append("    cancellableByTraveler: ").append(this.toIndentedString(this.cancellableByTraveler)).append("\n");
        sb.append("    cancellableWithNoCharges: ").append(this.toIndentedString(this.cancellableWithNoCharges)).append("\n");
        sb.append("    isCancellableWithPotentialCharges: ").append(this.toIndentedString(this.isCancellableWithPotentialCharges)).append("\n");
        sb.append("    commissionableTotalSourceAmount: ").append(this.toIndentedString(this.commissionableTotalSourceAmount)).append("\n");
        sb.append("    commissionableTotalCaptureAmount: ").append(this.toIndentedString(this.commissionableTotalCaptureAmount)).append("\n");
        sb.append("    commissionableTotalDisplayAmount: ").append(this.toIndentedString(this.commissionableTotalDisplayAmount)).append("\n");
        sb.append("    commissionableTotalSupplierAmount: ").append(this.toIndentedString(this.commissionableTotalSupplierAmount)).append("\n");
        sb.append("    commissionableTotalInternalAmount: ").append(this.toIndentedString(this.commissionableTotalInternalAmount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CancellerEnum {
        SALES_CHANNEL("SALES_CHANNEL"),
        SUPPLIER("SUPPLIER"),
        TRAVELER("TRAVELER"),
        ACQUIRER("ACQUIRER"),
        ADMINISTRATOR("ADMINISTRATOR");

        private String value;

        private CancellerEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CancellerEnum fromValue(String value) {
            for (CancellerEnum b : CancellerEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum CancellationTypeEnum {
        DUPLICATE("DUPLICATE"),
        CANCELLATION("CANCELLATION"),
        NO_SHOW("NO_SHOW"),
        CC_INVALID("CC_INVALID"),
        CC_INSUFFICIENT("CC_INSUFFICIENT"),
        DISCRETIONARY("DISCRETIONARY");

        private String value;

        private CancellationTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CancellationTypeEnum fromValue(String value) {
            for (CancellationTypeEnum b : CancellationTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

