/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release   # Booking API Welcome to the Booking Engine API - A programmer-friendly way to book inventory that was found on our platform. We take great care in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive payment-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 25.1.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.booking.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import travel.wink.sdk.booking.model.BeneficiaryBooker;
import travel.wink.sdk.booking.model.BookingUserBooker;
import travel.wink.sdk.booking.model.DailyRateBooker;
import travel.wink.sdk.booking.model.ItineraryBooker;
import travel.wink.sdk.booking.model.MoneysBooker;
import travel.wink.sdk.booking.model.SupplierContractItemPolicyBooker;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Holds one booking line item for a specific supplier.
 */
@JsonPropertyOrder({
  BookingContractItemBooker.JSON_PROPERTY_SUPPLIER_ITEM_BOOKING_CODE,
  BookingContractItemBooker.JSON_PROPERTY_USER,
  BookingContractItemBooker.JSON_PROPERTY_NAME_IN_ENGLISH,
  BookingContractItemBooker.JSON_PROPERTY_DESCRIPTION_IN_ENGLISH,
  BookingContractItemBooker.JSON_PROPERTY_TOTAL_SOURCE_PRICE,
  BookingContractItemBooker.JSON_PROPERTY_TOTAL_DISPLAY_PRICE,
  BookingContractItemBooker.JSON_PROPERTY_TOTAL_SUPPLIER_PRICE,
  BookingContractItemBooker.JSON_PROPERTY_TOTAL_INTERNAL_PRICE,
  BookingContractItemBooker.JSON_PROPERTY_TOTAL_CAPTURE_PRICE,
  BookingContractItemBooker.JSON_PROPERTY_ITINERARY,
  BookingContractItemBooker.JSON_PROPERTY_PRICING_TYPE,
  BookingContractItemBooker.JSON_PROPERTY_TYPE,
  BookingContractItemBooker.JSON_PROPERTY_BENEFICIARY_LIST,
  BookingContractItemBooker.JSON_PROPERTY_PAYABLE,
  BookingContractItemBooker.JSON_PROPERTY_POLICY,
  BookingContractItemBooker.JSON_PROPERTY_EXTERNAL_IDENTIFIER,
  BookingContractItemBooker.JSON_PROPERTY_TOKENS_EARNED,
  BookingContractItemBooker.JSON_PROPERTY_DAILY_RATE_LIST,
  BookingContractItemBooker.JSON_PROPERTY_CANCELLED,
  BookingContractItemBooker.JSON_PROPERTY_TOTAL_SOURCE_PRICE_AFTER_REFUND,
  BookingContractItemBooker.JSON_PROPERTY_TOTAL_DISPLAY_PRICE_AFTER_REFUND,
  BookingContractItemBooker.JSON_PROPERTY_TOTAL_SUPPLIER_PRICE_AFTER_REFUND,
  BookingContractItemBooker.JSON_PROPERTY_TOTAL_INTERNAL_PRICE_AFTER_REFUND,
  BookingContractItemBooker.JSON_PROPERTY_TOTAL_CAPTURE_PRICE_AFTER_REFUND,
  BookingContractItemBooker.JSON_PROPERTY_CANCELLABLE_WITH_NO_CHARGES,
  BookingContractItemBooker.JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER,
  BookingContractItemBooker.JSON_PROPERTY_IS_CANCELLABLE_BY_SUPPLIER,
  BookingContractItemBooker.JSON_PROPERTY_IS_CANCELLABLE_BY_TRAVELER,
  BookingContractItemBooker.JSON_PROPERTY_CANCELLABLE_BY_TRAVELER,
  BookingContractItemBooker.JSON_PROPERTY_CANCELLABLE_WITH_POTENTIAL_CHARGES
})
@JsonTypeName("BookingContractItem_Booker")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-04-06T14:58:11.163992317+07:00[Asia/Bangkok]")
public class BookingContractItemBooker {
  public static final String JSON_PROPERTY_SUPPLIER_ITEM_BOOKING_CODE = "supplierItemBookingCode";
  private String supplierItemBookingCode;

  public static final String JSON_PROPERTY_USER = "user";
  private BookingUserBooker user;

  public static final String JSON_PROPERTY_NAME_IN_ENGLISH = "nameInEnglish";
  private String nameInEnglish;

  public static final String JSON_PROPERTY_DESCRIPTION_IN_ENGLISH = "descriptionInEnglish";
  private String descriptionInEnglish;

  public static final String JSON_PROPERTY_TOTAL_SOURCE_PRICE = "totalSourcePrice";
  private MoneysBooker totalSourcePrice;

  public static final String JSON_PROPERTY_TOTAL_DISPLAY_PRICE = "totalDisplayPrice";
  private MoneysBooker totalDisplayPrice;

  public static final String JSON_PROPERTY_TOTAL_SUPPLIER_PRICE = "totalSupplierPrice";
  private MoneysBooker totalSupplierPrice;

  public static final String JSON_PROPERTY_TOTAL_INTERNAL_PRICE = "totalInternalPrice";
  private MoneysBooker totalInternalPrice;

  public static final String JSON_PROPERTY_TOTAL_CAPTURE_PRICE = "totalCapturePrice";
  private MoneysBooker totalCapturePrice;

  public static final String JSON_PROPERTY_ITINERARY = "itinerary";
  private ItineraryBooker itinerary;

  /**
   * How to calculate the total amount.
   */
  public enum PricingTypeEnum {
    STAY("PER_STAY"),
    
    DAY("PER_DAY"),
    
    NIGHT("PER_NIGHT"),
    
    USE("PER_USE"),
    
    HOUR("PER_HOUR"),
    
    PERSON("PER_PERSON"),
    
    PERSON_PER_NIGHT("PER_PERSON_PER_NIGHT"),
    
    PERSON_PER_HOUR("PER_PERSON_PER_HOUR"),
    
    ADULT("PER_ADULT"),
    
    ADULT_PER_NIGHT("PER_ADULT_PER_NIGHT"),
    
    ADULT_PER_HOUR("PER_ADULT_PER_HOUR"),
    
    CHILD("PER_CHILD"),
    
    CHILD_PER_NIGHT("PER_CHILD_PER_NIGHT"),
    
    CHILD_PER_HOUR("PER_CHILD_PER_HOUR");

    private String value;

    PricingTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PricingTypeEnum fromValue(String value) {
      for (PricingTypeEnum b : PricingTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PRICING_TYPE = "pricingType";
  private PricingTypeEnum pricingType;

  /**
   * Type of item this is.
   */
  public enum TypeEnum {
    LODGING("LODGING"),
    
    RAIL("RAIL"),
    
    AIR("AIR"),
    
    CAR("CAR"),
    
    CRUISE("CRUISE"),
    
    PACKAGE("PACKAGE"),
    
    ADD_ON("ADD_ON"),
    
    RENTAL("RENTAL"),
    
    EXPERIENCE("EXPERIENCE"),
    
    ANCILLARY_BOOKING("ANCILLARY_BOOKING"),
    
    ANCILLARY_FEE("ANCILLARY_FEE");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_BENEFICIARY_LIST = "beneficiaryList";
  private List<BeneficiaryBooker> beneficiaryList = new ArrayList<>();

  /**
   * When to charge for this item.
   */
  public enum PayableEnum {
    IMMEDIATE("IMMEDIATE"),
    
    ARRIVAL("ARRIVAL"),
    
    DEPARTURE("DEPARTURE"),
    
    AGENT("AGENT");

    private String value;

    PayableEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PayableEnum fromValue(String value) {
      for (PayableEnum b : PayableEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PAYABLE = "payable";
  private PayableEnum payable;

  public static final String JSON_PROPERTY_POLICY = "policy";
  private SupplierContractItemPolicyBooker policy;

  public static final String JSON_PROPERTY_EXTERNAL_IDENTIFIER = "externalIdentifier";
  private String externalIdentifier;

  public static final String JSON_PROPERTY_TOKENS_EARNED = "tokensEarned";
  private Long tokensEarned;

  public static final String JSON_PROPERTY_DAILY_RATE_LIST = "dailyRateList";
  private List<DailyRateBooker> dailyRateList = new ArrayList<>();

  public static final String JSON_PROPERTY_CANCELLED = "cancelled";
  private Boolean cancelled;

  public static final String JSON_PROPERTY_TOTAL_SOURCE_PRICE_AFTER_REFUND = "totalSourcePriceAfterRefund";
  private MoneysBooker totalSourcePriceAfterRefund;

  public static final String JSON_PROPERTY_TOTAL_DISPLAY_PRICE_AFTER_REFUND = "totalDisplayPriceAfterRefund";
  private MoneysBooker totalDisplayPriceAfterRefund;

  public static final String JSON_PROPERTY_TOTAL_SUPPLIER_PRICE_AFTER_REFUND = "totalSupplierPriceAfterRefund";
  private MoneysBooker totalSupplierPriceAfterRefund;

  public static final String JSON_PROPERTY_TOTAL_INTERNAL_PRICE_AFTER_REFUND = "totalInternalPriceAfterRefund";
  private MoneysBooker totalInternalPriceAfterRefund;

  public static final String JSON_PROPERTY_TOTAL_CAPTURE_PRICE_AFTER_REFUND = "totalCapturePriceAfterRefund";
  private MoneysBooker totalCapturePriceAfterRefund;

  public static final String JSON_PROPERTY_CANCELLABLE_WITH_NO_CHARGES = "cancellableWithNoCharges";
  private Boolean cancellableWithNoCharges;

  public static final String JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER = "cancellableBySupplier";
  private Boolean cancellableBySupplier;

  public static final String JSON_PROPERTY_IS_CANCELLABLE_BY_SUPPLIER = "isCancellableBySupplier";
  private Boolean isCancellableBySupplier;

  public static final String JSON_PROPERTY_IS_CANCELLABLE_BY_TRAVELER = "isCancellableByTraveler";
  private Boolean isCancellableByTraveler;

  public static final String JSON_PROPERTY_CANCELLABLE_BY_TRAVELER = "cancellableByTraveler";
  private Boolean cancellableByTraveler;

  public static final String JSON_PROPERTY_CANCELLABLE_WITH_POTENTIAL_CHARGES = "cancellableWithPotentialCharges";
  private Boolean cancellableWithPotentialCharges;

  public BookingContractItemBooker() {
  }

  public BookingContractItemBooker supplierItemBookingCode(String supplierItemBookingCode) {
    
    this.supplierItemBookingCode = supplierItemBookingCode;
    return this;
  }

   /**
   * Booking code identifying the supplier line item.
   * @return supplierItemBookingCode
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_SUPPLIER_ITEM_BOOKING_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSupplierItemBookingCode() {
    return supplierItemBookingCode;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_ITEM_BOOKING_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSupplierItemBookingCode(String supplierItemBookingCode) {
    this.supplierItemBookingCode = supplierItemBookingCode;
  }


  public BookingContractItemBooker user(BookingUserBooker user) {
    
    this.user = user;
    return this;
  }

   /**
   * Get user
   * @return user
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_USER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BookingUserBooker getUser() {
    return user;
  }


  @JsonProperty(JSON_PROPERTY_USER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUser(BookingUserBooker user) {
    this.user = user;
  }


  public BookingContractItemBooker nameInEnglish(String nameInEnglish) {
    
    this.nameInEnglish = nameInEnglish;
    return this;
  }

   /**
   * Name of item in English included in booking.
   * @return nameInEnglish
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_NAME_IN_ENGLISH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getNameInEnglish() {
    return nameInEnglish;
  }


  @JsonProperty(JSON_PROPERTY_NAME_IN_ENGLISH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setNameInEnglish(String nameInEnglish) {
    this.nameInEnglish = nameInEnglish;
  }


  public BookingContractItemBooker descriptionInEnglish(String descriptionInEnglish) {
    
    this.descriptionInEnglish = descriptionInEnglish;
    return this;
  }

   /**
   * Short description in English of item included in booking.
   * @return descriptionInEnglish
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_DESCRIPTION_IN_ENGLISH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDescriptionInEnglish() {
    return descriptionInEnglish;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION_IN_ENGLISH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDescriptionInEnglish(String descriptionInEnglish) {
    this.descriptionInEnglish = descriptionInEnglish;
  }


  public BookingContractItemBooker totalSourcePrice(MoneysBooker totalSourcePrice) {
    
    this.totalSourcePrice = totalSourcePrice;
    return this;
  }

   /**
   * Get totalSourcePrice
   * @return totalSourcePrice
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_SOURCE_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public MoneysBooker getTotalSourcePrice() {
    return totalSourcePrice;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_SOURCE_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTotalSourcePrice(MoneysBooker totalSourcePrice) {
    this.totalSourcePrice = totalSourcePrice;
  }


  public BookingContractItemBooker totalDisplayPrice(MoneysBooker totalDisplayPrice) {
    
    this.totalDisplayPrice = totalDisplayPrice;
    return this;
  }

   /**
   * Get totalDisplayPrice
   * @return totalDisplayPrice
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_DISPLAY_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public MoneysBooker getTotalDisplayPrice() {
    return totalDisplayPrice;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_DISPLAY_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTotalDisplayPrice(MoneysBooker totalDisplayPrice) {
    this.totalDisplayPrice = totalDisplayPrice;
  }


  public BookingContractItemBooker totalSupplierPrice(MoneysBooker totalSupplierPrice) {
    
    this.totalSupplierPrice = totalSupplierPrice;
    return this;
  }

   /**
   * Get totalSupplierPrice
   * @return totalSupplierPrice
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_SUPPLIER_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public MoneysBooker getTotalSupplierPrice() {
    return totalSupplierPrice;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_SUPPLIER_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTotalSupplierPrice(MoneysBooker totalSupplierPrice) {
    this.totalSupplierPrice = totalSupplierPrice;
  }


  public BookingContractItemBooker totalInternalPrice(MoneysBooker totalInternalPrice) {
    
    this.totalInternalPrice = totalInternalPrice;
    return this;
  }

   /**
   * Get totalInternalPrice
   * @return totalInternalPrice
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_INTERNAL_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public MoneysBooker getTotalInternalPrice() {
    return totalInternalPrice;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_INTERNAL_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTotalInternalPrice(MoneysBooker totalInternalPrice) {
    this.totalInternalPrice = totalInternalPrice;
  }


  public BookingContractItemBooker totalCapturePrice(MoneysBooker totalCapturePrice) {
    
    this.totalCapturePrice = totalCapturePrice;
    return this;
  }

   /**
   * Get totalCapturePrice
   * @return totalCapturePrice
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_CAPTURE_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public MoneysBooker getTotalCapturePrice() {
    return totalCapturePrice;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_CAPTURE_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTotalCapturePrice(MoneysBooker totalCapturePrice) {
    this.totalCapturePrice = totalCapturePrice;
  }


  public BookingContractItemBooker itinerary(ItineraryBooker itinerary) {
    
    this.itinerary = itinerary;
    return this;
  }

   /**
   * Get itinerary
   * @return itinerary
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ITINERARY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ItineraryBooker getItinerary() {
    return itinerary;
  }


  @JsonProperty(JSON_PROPERTY_ITINERARY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setItinerary(ItineraryBooker itinerary) {
    this.itinerary = itinerary;
  }


  public BookingContractItemBooker pricingType(PricingTypeEnum pricingType) {
    
    this.pricingType = pricingType;
    return this;
  }

   /**
   * How to calculate the total amount.
   * @return pricingType
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_PRICING_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public PricingTypeEnum getPricingType() {
    return pricingType;
  }


  @JsonProperty(JSON_PROPERTY_PRICING_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPricingType(PricingTypeEnum pricingType) {
    this.pricingType = pricingType;
  }


  public BookingContractItemBooker type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * Type of item this is.
   * @return type
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public BookingContractItemBooker beneficiaryList(List<BeneficiaryBooker> beneficiaryList) {
    
    this.beneficiaryList = beneficiaryList;
    return this;
  }

  public BookingContractItemBooker addBeneficiaryListItem(BeneficiaryBooker beneficiaryListItem) {
    this.beneficiaryList.add(beneficiaryListItem);
    return this;
  }

   /**
   * Get beneficiaryList
   * @return beneficiaryList
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @Size(min=1,max=2147483647)
  @JsonProperty(JSON_PROPERTY_BENEFICIARY_LIST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<BeneficiaryBooker> getBeneficiaryList() {
    return beneficiaryList;
  }


  @JsonProperty(JSON_PROPERTY_BENEFICIARY_LIST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBeneficiaryList(List<BeneficiaryBooker> beneficiaryList) {
    this.beneficiaryList = beneficiaryList;
  }


  public BookingContractItemBooker payable(PayableEnum payable) {
    
    this.payable = payable;
    return this;
  }

   /**
   * When to charge for this item.
   * @return payable
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_PAYABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public PayableEnum getPayable() {
    return payable;
  }


  @JsonProperty(JSON_PROPERTY_PAYABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPayable(PayableEnum payable) {
    this.payable = payable;
  }


  public BookingContractItemBooker policy(SupplierContractItemPolicyBooker policy) {
    
    this.policy = policy;
    return this;
  }

   /**
   * Get policy
   * @return policy
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SupplierContractItemPolicyBooker getPolicy() {
    return policy;
  }


  @JsonProperty(JSON_PROPERTY_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPolicy(SupplierContractItemPolicyBooker policy) {
    this.policy = policy;
  }


  public BookingContractItemBooker externalIdentifier(String externalIdentifier) {
    
    this.externalIdentifier = externalIdentifier;
    return this;
  }

   /**
   * Optional geoname externalIdentifier to remote inventory.
   * @return externalIdentifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_EXTERNAL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getExternalIdentifier() {
    return externalIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_EXTERNAL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExternalIdentifier(String externalIdentifier) {
    this.externalIdentifier = externalIdentifier;
  }


  public BookingContractItemBooker tokensEarned(Long tokensEarned) {
    
    this.tokensEarned = tokensEarned;
    return this;
  }

   /**
   * Tokens earned for this item
   * @return tokensEarned
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOKENS_EARNED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getTokensEarned() {
    return tokensEarned;
  }


  @JsonProperty(JSON_PROPERTY_TOKENS_EARNED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTokensEarned(Long tokensEarned) {
    this.tokensEarned = tokensEarned;
  }


  public BookingContractItemBooker dailyRateList(List<DailyRateBooker> dailyRateList) {
    
    this.dailyRateList = dailyRateList;
    return this;
  }

  public BookingContractItemBooker addDailyRateListItem(DailyRateBooker dailyRateListItem) {
    if (this.dailyRateList == null) {
      this.dailyRateList = new ArrayList<>();
    }
    this.dailyRateList.add(dailyRateListItem);
    return this;
  }

   /**
   * Get dailyRateList
   * @return dailyRateList
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_DAILY_RATE_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<DailyRateBooker> getDailyRateList() {
    return dailyRateList;
  }


  @JsonProperty(JSON_PROPERTY_DAILY_RATE_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDailyRateList(List<DailyRateBooker> dailyRateList) {
    this.dailyRateList = dailyRateList;
  }


  public BookingContractItemBooker cancelled(Boolean cancelled) {
    
    this.cancelled = cancelled;
    return this;
  }

   /**
   * Optional geoname externalIdentifier to remote inventory.
   * @return cancelled
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancelled() {
    return cancelled;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancelled(Boolean cancelled) {
    this.cancelled = cancelled;
  }


  public BookingContractItemBooker totalSourcePriceAfterRefund(MoneysBooker totalSourcePriceAfterRefund) {
    
    this.totalSourcePriceAfterRefund = totalSourcePriceAfterRefund;
    return this;
  }

   /**
   * Get totalSourcePriceAfterRefund
   * @return totalSourcePriceAfterRefund
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_SOURCE_PRICE_AFTER_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MoneysBooker getTotalSourcePriceAfterRefund() {
    return totalSourcePriceAfterRefund;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_SOURCE_PRICE_AFTER_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalSourcePriceAfterRefund(MoneysBooker totalSourcePriceAfterRefund) {
    this.totalSourcePriceAfterRefund = totalSourcePriceAfterRefund;
  }


  public BookingContractItemBooker totalDisplayPriceAfterRefund(MoneysBooker totalDisplayPriceAfterRefund) {
    
    this.totalDisplayPriceAfterRefund = totalDisplayPriceAfterRefund;
    return this;
  }

   /**
   * Get totalDisplayPriceAfterRefund
   * @return totalDisplayPriceAfterRefund
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_DISPLAY_PRICE_AFTER_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MoneysBooker getTotalDisplayPriceAfterRefund() {
    return totalDisplayPriceAfterRefund;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_DISPLAY_PRICE_AFTER_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalDisplayPriceAfterRefund(MoneysBooker totalDisplayPriceAfterRefund) {
    this.totalDisplayPriceAfterRefund = totalDisplayPriceAfterRefund;
  }


  public BookingContractItemBooker totalSupplierPriceAfterRefund(MoneysBooker totalSupplierPriceAfterRefund) {
    
    this.totalSupplierPriceAfterRefund = totalSupplierPriceAfterRefund;
    return this;
  }

   /**
   * Get totalSupplierPriceAfterRefund
   * @return totalSupplierPriceAfterRefund
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_SUPPLIER_PRICE_AFTER_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MoneysBooker getTotalSupplierPriceAfterRefund() {
    return totalSupplierPriceAfterRefund;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_SUPPLIER_PRICE_AFTER_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalSupplierPriceAfterRefund(MoneysBooker totalSupplierPriceAfterRefund) {
    this.totalSupplierPriceAfterRefund = totalSupplierPriceAfterRefund;
  }


  public BookingContractItemBooker totalInternalPriceAfterRefund(MoneysBooker totalInternalPriceAfterRefund) {
    
    this.totalInternalPriceAfterRefund = totalInternalPriceAfterRefund;
    return this;
  }

   /**
   * Get totalInternalPriceAfterRefund
   * @return totalInternalPriceAfterRefund
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_INTERNAL_PRICE_AFTER_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MoneysBooker getTotalInternalPriceAfterRefund() {
    return totalInternalPriceAfterRefund;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_INTERNAL_PRICE_AFTER_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalInternalPriceAfterRefund(MoneysBooker totalInternalPriceAfterRefund) {
    this.totalInternalPriceAfterRefund = totalInternalPriceAfterRefund;
  }


  public BookingContractItemBooker totalCapturePriceAfterRefund(MoneysBooker totalCapturePriceAfterRefund) {
    
    this.totalCapturePriceAfterRefund = totalCapturePriceAfterRefund;
    return this;
  }

   /**
   * Get totalCapturePriceAfterRefund
   * @return totalCapturePriceAfterRefund
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_CAPTURE_PRICE_AFTER_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MoneysBooker getTotalCapturePriceAfterRefund() {
    return totalCapturePriceAfterRefund;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_CAPTURE_PRICE_AFTER_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalCapturePriceAfterRefund(MoneysBooker totalCapturePriceAfterRefund) {
    this.totalCapturePriceAfterRefund = totalCapturePriceAfterRefund;
  }


  public BookingContractItemBooker cancellableWithNoCharges(Boolean cancellableWithNoCharges) {
    
    this.cancellableWithNoCharges = cancellableWithNoCharges;
    return this;
  }

   /**
   * Whether the booking can still be cancelled and whether cancellation charges might still occur.
   * @return cancellableWithNoCharges
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLABLE_WITH_NO_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableWithNoCharges() {
    return cancellableWithNoCharges;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_WITH_NO_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableWithNoCharges(Boolean cancellableWithNoCharges) {
    this.cancellableWithNoCharges = cancellableWithNoCharges;
  }


  public BookingContractItemBooker cancellableBySupplier(Boolean cancellableBySupplier) {
    
    this.cancellableBySupplier = cancellableBySupplier;
    return this;
  }

   /**
   * Whether the booking can still be cancelled by the supplier. A supplier cancellation overrides the refundable
   * @return cancellableBySupplier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableBySupplier() {
    return cancellableBySupplier;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableBySupplier(Boolean cancellableBySupplier) {
    this.cancellableBySupplier = cancellableBySupplier;
  }


  public BookingContractItemBooker isCancellableBySupplier(Boolean isCancellableBySupplier) {
    
    this.isCancellableBySupplier = isCancellableBySupplier;
    return this;
  }

   /**
   * Get isCancellableBySupplier
   * @return isCancellableBySupplier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_IS_CANCELLABLE_BY_SUPPLIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIsCancellableBySupplier() {
    return isCancellableBySupplier;
  }


  @JsonProperty(JSON_PROPERTY_IS_CANCELLABLE_BY_SUPPLIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIsCancellableBySupplier(Boolean isCancellableBySupplier) {
    this.isCancellableBySupplier = isCancellableBySupplier;
  }


  public BookingContractItemBooker isCancellableByTraveler(Boolean isCancellableByTraveler) {
    
    this.isCancellableByTraveler = isCancellableByTraveler;
    return this;
  }

   /**
   * Get isCancellableByTraveler
   * @return isCancellableByTraveler
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_IS_CANCELLABLE_BY_TRAVELER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIsCancellableByTraveler() {
    return isCancellableByTraveler;
  }


  @JsonProperty(JSON_PROPERTY_IS_CANCELLABLE_BY_TRAVELER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIsCancellableByTraveler(Boolean isCancellableByTraveler) {
    this.isCancellableByTraveler = isCancellableByTraveler;
  }


  public BookingContractItemBooker cancellableByTraveler(Boolean cancellableByTraveler) {
    
    this.cancellableByTraveler = cancellableByTraveler;
    return this;
  }

   /**
   * Whether the booking can still be cancelled by the traveller.
   * @return cancellableByTraveler
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_TRAVELER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableByTraveler() {
    return cancellableByTraveler;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_TRAVELER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableByTraveler(Boolean cancellableByTraveler) {
    this.cancellableByTraveler = cancellableByTraveler;
  }


  public BookingContractItemBooker cancellableWithPotentialCharges(Boolean cancellableWithPotentialCharges) {
    
    this.cancellableWithPotentialCharges = cancellableWithPotentialCharges;
    return this;
  }

   /**
   * Whether the booking can still be cancelled and whether cancellation charges might still occur.
   * @return cancellableWithPotentialCharges
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLABLE_WITH_POTENTIAL_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableWithPotentialCharges() {
    return cancellableWithPotentialCharges;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_WITH_POTENTIAL_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableWithPotentialCharges(Boolean cancellableWithPotentialCharges) {
    this.cancellableWithPotentialCharges = cancellableWithPotentialCharges;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BookingContractItemBooker bookingContractItemBooker = (BookingContractItemBooker) o;
    return Objects.equals(this.supplierItemBookingCode, bookingContractItemBooker.supplierItemBookingCode) &&
        Objects.equals(this.user, bookingContractItemBooker.user) &&
        Objects.equals(this.nameInEnglish, bookingContractItemBooker.nameInEnglish) &&
        Objects.equals(this.descriptionInEnglish, bookingContractItemBooker.descriptionInEnglish) &&
        Objects.equals(this.totalSourcePrice, bookingContractItemBooker.totalSourcePrice) &&
        Objects.equals(this.totalDisplayPrice, bookingContractItemBooker.totalDisplayPrice) &&
        Objects.equals(this.totalSupplierPrice, bookingContractItemBooker.totalSupplierPrice) &&
        Objects.equals(this.totalInternalPrice, bookingContractItemBooker.totalInternalPrice) &&
        Objects.equals(this.totalCapturePrice, bookingContractItemBooker.totalCapturePrice) &&
        Objects.equals(this.itinerary, bookingContractItemBooker.itinerary) &&
        Objects.equals(this.pricingType, bookingContractItemBooker.pricingType) &&
        Objects.equals(this.type, bookingContractItemBooker.type) &&
        Objects.equals(this.beneficiaryList, bookingContractItemBooker.beneficiaryList) &&
        Objects.equals(this.payable, bookingContractItemBooker.payable) &&
        Objects.equals(this.policy, bookingContractItemBooker.policy) &&
        Objects.equals(this.externalIdentifier, bookingContractItemBooker.externalIdentifier) &&
        Objects.equals(this.tokensEarned, bookingContractItemBooker.tokensEarned) &&
        Objects.equals(this.dailyRateList, bookingContractItemBooker.dailyRateList) &&
        Objects.equals(this.cancelled, bookingContractItemBooker.cancelled) &&
        Objects.equals(this.totalSourcePriceAfterRefund, bookingContractItemBooker.totalSourcePriceAfterRefund) &&
        Objects.equals(this.totalDisplayPriceAfterRefund, bookingContractItemBooker.totalDisplayPriceAfterRefund) &&
        Objects.equals(this.totalSupplierPriceAfterRefund, bookingContractItemBooker.totalSupplierPriceAfterRefund) &&
        Objects.equals(this.totalInternalPriceAfterRefund, bookingContractItemBooker.totalInternalPriceAfterRefund) &&
        Objects.equals(this.totalCapturePriceAfterRefund, bookingContractItemBooker.totalCapturePriceAfterRefund) &&
        Objects.equals(this.cancellableWithNoCharges, bookingContractItemBooker.cancellableWithNoCharges) &&
        Objects.equals(this.cancellableBySupplier, bookingContractItemBooker.cancellableBySupplier) &&
        Objects.equals(this.isCancellableBySupplier, bookingContractItemBooker.isCancellableBySupplier) &&
        Objects.equals(this.isCancellableByTraveler, bookingContractItemBooker.isCancellableByTraveler) &&
        Objects.equals(this.cancellableByTraveler, bookingContractItemBooker.cancellableByTraveler) &&
        Objects.equals(this.cancellableWithPotentialCharges, bookingContractItemBooker.cancellableWithPotentialCharges);
  }

  @Override
  public int hashCode() {
    return Objects.hash(supplierItemBookingCode, user, nameInEnglish, descriptionInEnglish, totalSourcePrice, totalDisplayPrice, totalSupplierPrice, totalInternalPrice, totalCapturePrice, itinerary, pricingType, type, beneficiaryList, payable, policy, externalIdentifier, tokensEarned, dailyRateList, cancelled, totalSourcePriceAfterRefund, totalDisplayPriceAfterRefund, totalSupplierPriceAfterRefund, totalInternalPriceAfterRefund, totalCapturePriceAfterRefund, cancellableWithNoCharges, cancellableBySupplier, isCancellableBySupplier, isCancellableByTraveler, cancellableByTraveler, cancellableWithPotentialCharges);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BookingContractItemBooker {\n");
    sb.append("    supplierItemBookingCode: ").append(toIndentedString(supplierItemBookingCode)).append("\n");
    sb.append("    user: ").append(toIndentedString(user)).append("\n");
    sb.append("    nameInEnglish: ").append(toIndentedString(nameInEnglish)).append("\n");
    sb.append("    descriptionInEnglish: ").append(toIndentedString(descriptionInEnglish)).append("\n");
    sb.append("    totalSourcePrice: ").append(toIndentedString(totalSourcePrice)).append("\n");
    sb.append("    totalDisplayPrice: ").append(toIndentedString(totalDisplayPrice)).append("\n");
    sb.append("    totalSupplierPrice: ").append(toIndentedString(totalSupplierPrice)).append("\n");
    sb.append("    totalInternalPrice: ").append(toIndentedString(totalInternalPrice)).append("\n");
    sb.append("    totalCapturePrice: ").append(toIndentedString(totalCapturePrice)).append("\n");
    sb.append("    itinerary: ").append(toIndentedString(itinerary)).append("\n");
    sb.append("    pricingType: ").append(toIndentedString(pricingType)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    beneficiaryList: ").append(toIndentedString(beneficiaryList)).append("\n");
    sb.append("    payable: ").append(toIndentedString(payable)).append("\n");
    sb.append("    policy: ").append(toIndentedString(policy)).append("\n");
    sb.append("    externalIdentifier: ").append(toIndentedString(externalIdentifier)).append("\n");
    sb.append("    tokensEarned: ").append(toIndentedString(tokensEarned)).append("\n");
    sb.append("    dailyRateList: ").append(toIndentedString(dailyRateList)).append("\n");
    sb.append("    cancelled: ").append(toIndentedString(cancelled)).append("\n");
    sb.append("    totalSourcePriceAfterRefund: ").append(toIndentedString(totalSourcePriceAfterRefund)).append("\n");
    sb.append("    totalDisplayPriceAfterRefund: ").append(toIndentedString(totalDisplayPriceAfterRefund)).append("\n");
    sb.append("    totalSupplierPriceAfterRefund: ").append(toIndentedString(totalSupplierPriceAfterRefund)).append("\n");
    sb.append("    totalInternalPriceAfterRefund: ").append(toIndentedString(totalInternalPriceAfterRefund)).append("\n");
    sb.append("    totalCapturePriceAfterRefund: ").append(toIndentedString(totalCapturePriceAfterRefund)).append("\n");
    sb.append("    cancellableWithNoCharges: ").append(toIndentedString(cancellableWithNoCharges)).append("\n");
    sb.append("    cancellableBySupplier: ").append(toIndentedString(cancellableBySupplier)).append("\n");
    sb.append("    isCancellableBySupplier: ").append(toIndentedString(isCancellableBySupplier)).append("\n");
    sb.append("    isCancellableByTraveler: ").append(toIndentedString(isCancellableByTraveler)).append("\n");
    sb.append("    cancellableByTraveler: ").append(toIndentedString(cancellableByTraveler)).append("\n");
    sb.append("    cancellableWithPotentialCharges: ").append(toIndentedString(cancellableWithPotentialCharges)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

