/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release   # Booking API Welcome to the Booking Engine API - A programmer-friendly way to book inventory that was found on our platform. We take great care in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive payment-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 25.2.7
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.booking.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.booking.model.AncillaryRequestBooker;
import travel.wink.sdk.booking.model.BookingUserRequestBooker;
import travel.wink.sdk.booking.model.RoomConfigurationBooker;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * List of room configuration booking requests. Each entry is a separately booked room.
 */
@JsonPropertyOrder({
  MerchantBookingRequestBooker.JSON_PROPERTY_HOTEL_IDENTIFIER,
  MerchantBookingRequestBooker.JSON_PROPERTY_START_DATE,
  MerchantBookingRequestBooker.JSON_PROPERTY_END_DATE,
  MerchantBookingRequestBooker.JSON_PROPERTY_ROOM_CONFIGURATION,
  MerchantBookingRequestBooker.JSON_PROPERTY_PROMOTIONAL_CODES,
  MerchantBookingRequestBooker.JSON_PROPERTY_ROOM_RATE_IDENTIFIER,
  MerchantBookingRequestBooker.JSON_PROPERTY_BEDROOM_CONFIGURATION_IDENTIFIER,
  MerchantBookingRequestBooker.JSON_PROPERTY_ANCILLARIES,
  MerchantBookingRequestBooker.JSON_PROPERTY_SPECIAL_REQUESTS,
  MerchantBookingRequestBooker.JSON_PROPERTY_USER,
  MerchantBookingRequestBooker.JSON_PROPERTY_TRACE_ID,
  MerchantBookingRequestBooker.JSON_PROPERTY_PAYMENT_IDENTIFIER
})
@JsonTypeName("MerchantBookingRequest_Booker")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-04-26T14:36:12.457859229+07:00[Asia/Bangkok]")
public class MerchantBookingRequestBooker {
  public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
  private UUID hotelIdentifier;

  public static final String JSON_PROPERTY_START_DATE = "startDate";
  private LocalDate startDate;

  public static final String JSON_PROPERTY_END_DATE = "endDate";
  private LocalDate endDate;

  public static final String JSON_PROPERTY_ROOM_CONFIGURATION = "roomConfiguration";
  private RoomConfigurationBooker roomConfiguration;

  public static final String JSON_PROPERTY_PROMOTIONAL_CODES = "promotionalCodes";
  private List<String> promotionalCodes = new ArrayList<>();

  public static final String JSON_PROPERTY_ROOM_RATE_IDENTIFIER = "roomRateIdentifier";
  private UUID roomRateIdentifier;

  public static final String JSON_PROPERTY_BEDROOM_CONFIGURATION_IDENTIFIER = "bedroomConfigurationIdentifier";
  private String bedroomConfigurationIdentifier;

  public static final String JSON_PROPERTY_ANCILLARIES = "ancillaries";
  private List<AncillaryRequestBooker> ancillaries = new ArrayList<>();

  public static final String JSON_PROPERTY_SPECIAL_REQUESTS = "specialRequests";
  private String specialRequests;

  public static final String JSON_PROPERTY_USER = "user";
  private BookingUserRequestBooker user;

  public static final String JSON_PROPERTY_TRACE_ID = "traceId";
  private String traceId;

  public static final String JSON_PROPERTY_PAYMENT_IDENTIFIER = "paymentIdentifier";
  private String paymentIdentifier;

  public MerchantBookingRequestBooker() {
  }

  public MerchantBookingRequestBooker hotelIdentifier(UUID hotelIdentifier) {
    
    this.hotelIdentifier = hotelIdentifier;
    return this;
  }

   /**
   * Unique hotel record identifier.
   * @return hotelIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getHotelIdentifier() {
    return hotelIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setHotelIdentifier(UUID hotelIdentifier) {
    this.hotelIdentifier = hotelIdentifier;
  }


  public MerchantBookingRequestBooker startDate(LocalDate startDate) {
    
    this.startDate = startDate;
    return this;
  }

   /**
   * Date when guest arrives on the premises.
   * @return startDate
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public LocalDate getStartDate() {
    return startDate;
  }


  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStartDate(LocalDate startDate) {
    this.startDate = startDate;
  }


  public MerchantBookingRequestBooker endDate(LocalDate endDate) {
    
    this.endDate = endDate;
    return this;
  }

   /**
   * Date when guest departs the premises.
   * @return endDate
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public LocalDate getEndDate() {
    return endDate;
  }


  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEndDate(LocalDate endDate) {
    this.endDate = endDate;
  }


  public MerchantBookingRequestBooker roomConfiguration(RoomConfigurationBooker roomConfiguration) {
    
    this.roomConfiguration = roomConfiguration;
    return this;
  }

   /**
   * Get roomConfiguration
   * @return roomConfiguration
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ROOM_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public RoomConfigurationBooker getRoomConfiguration() {
    return roomConfiguration;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRoomConfiguration(RoomConfigurationBooker roomConfiguration) {
    this.roomConfiguration = roomConfiguration;
  }


  public MerchantBookingRequestBooker promotionalCodes(List<String> promotionalCodes) {
    
    this.promotionalCodes = promotionalCodes;
    return this;
  }

  public MerchantBookingRequestBooker addPromotionalCodesItem(String promotionalCodesItem) {
    if (this.promotionalCodes == null) {
      this.promotionalCodes = new ArrayList<>();
    }
    this.promotionalCodes.add(promotionalCodesItem);
    return this;
  }

   /**
   * Get promotionalCodes
   * @return promotionalCodes
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PROMOTIONAL_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getPromotionalCodes() {
    return promotionalCodes;
  }


  @JsonProperty(JSON_PROPERTY_PROMOTIONAL_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPromotionalCodes(List<String> promotionalCodes) {
    this.promotionalCodes = promotionalCodes;
  }


  public MerchantBookingRequestBooker roomRateIdentifier(UUID roomRateIdentifier) {
    
    this.roomRateIdentifier = roomRateIdentifier;
    return this;
  }

   /**
   * The unique master rate that made the guest room / rate plan available for sale.
   * @return roomRateIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ROOM_RATE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getRoomRateIdentifier() {
    return roomRateIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_RATE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRoomRateIdentifier(UUID roomRateIdentifier) {
    this.roomRateIdentifier = roomRateIdentifier;
  }


  public MerchantBookingRequestBooker bedroomConfigurationIdentifier(String bedroomConfigurationIdentifier) {
    
    this.bedroomConfigurationIdentifier = bedroomConfigurationIdentifier;
    return this;
  }

   /**
   * Guest can optionally request a specific bedroom layout if the room type is set up with multiple layout choices.
   * @return bedroomConfigurationIdentifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_BEDROOM_CONFIGURATION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBedroomConfigurationIdentifier() {
    return bedroomConfigurationIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_BEDROOM_CONFIGURATION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBedroomConfigurationIdentifier(String bedroomConfigurationIdentifier) {
    this.bedroomConfigurationIdentifier = bedroomConfigurationIdentifier;
  }


  public MerchantBookingRequestBooker ancillaries(List<AncillaryRequestBooker> ancillaries) {
    
    this.ancillaries = ancillaries;
    return this;
  }

  public MerchantBookingRequestBooker addAncillariesItem(AncillaryRequestBooker ancillariesItem) {
    if (this.ancillaries == null) {
      this.ancillaries = new ArrayList<>();
    }
    this.ancillaries.add(ancillariesItem);
    return this;
  }

   /**
   * Get ancillaries
   * @return ancillaries
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ANCILLARIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<AncillaryRequestBooker> getAncillaries() {
    return ancillaries;
  }


  @JsonProperty(JSON_PROPERTY_ANCILLARIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAncillaries(List<AncillaryRequestBooker> ancillaries) {
    this.ancillaries = ancillaries;
  }


  public MerchantBookingRequestBooker specialRequests(String specialRequests) {
    
    this.specialRequests = specialRequests;
    return this;
  }

   /**
   * A guest can send a special request to the hotel in free-text here.
   * @return specialRequests
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SPECIAL_REQUESTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSpecialRequests() {
    return specialRequests;
  }


  @JsonProperty(JSON_PROPERTY_SPECIAL_REQUESTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSpecialRequests(String specialRequests) {
    this.specialRequests = specialRequests;
  }


  public MerchantBookingRequestBooker user(BookingUserRequestBooker user) {
    
    this.user = user;
    return this;
  }

   /**
   * Get user
   * @return user
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_USER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BookingUserRequestBooker getUser() {
    return user;
  }


  @JsonProperty(JSON_PROPERTY_USER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUser(BookingUserRequestBooker user) {
    this.user = user;
  }


  public MerchantBookingRequestBooker traceId(String traceId) {
    
    this.traceId = traceId;
    return this;
  }

   /**
   * traceId is a way to track multiple booking contracts
   * @return traceId
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_TRACE_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getTraceId() {
    return traceId;
  }


  @JsonProperty(JSON_PROPERTY_TRACE_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTraceId(String traceId) {
    this.traceId = traceId;
  }


  public MerchantBookingRequestBooker paymentIdentifier(String paymentIdentifier) {
    
    this.paymentIdentifier = paymentIdentifier;
    return this;
  }

   /**
   * Identifier generated by TripPay.
   * @return paymentIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_PAYMENT_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getPaymentIdentifier() {
    return paymentIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_PAYMENT_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPaymentIdentifier(String paymentIdentifier) {
    this.paymentIdentifier = paymentIdentifier;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MerchantBookingRequestBooker merchantBookingRequestBooker = (MerchantBookingRequestBooker) o;
    return Objects.equals(this.hotelIdentifier, merchantBookingRequestBooker.hotelIdentifier) &&
        Objects.equals(this.startDate, merchantBookingRequestBooker.startDate) &&
        Objects.equals(this.endDate, merchantBookingRequestBooker.endDate) &&
        Objects.equals(this.roomConfiguration, merchantBookingRequestBooker.roomConfiguration) &&
        Objects.equals(this.promotionalCodes, merchantBookingRequestBooker.promotionalCodes) &&
        Objects.equals(this.roomRateIdentifier, merchantBookingRequestBooker.roomRateIdentifier) &&
        Objects.equals(this.bedroomConfigurationIdentifier, merchantBookingRequestBooker.bedroomConfigurationIdentifier) &&
        Objects.equals(this.ancillaries, merchantBookingRequestBooker.ancillaries) &&
        Objects.equals(this.specialRequests, merchantBookingRequestBooker.specialRequests) &&
        Objects.equals(this.user, merchantBookingRequestBooker.user) &&
        Objects.equals(this.traceId, merchantBookingRequestBooker.traceId) &&
        Objects.equals(this.paymentIdentifier, merchantBookingRequestBooker.paymentIdentifier);
  }

  @Override
  public int hashCode() {
    return Objects.hash(hotelIdentifier, startDate, endDate, roomConfiguration, promotionalCodes, roomRateIdentifier, bedroomConfigurationIdentifier, ancillaries, specialRequests, user, traceId, paymentIdentifier);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MerchantBookingRequestBooker {\n");
    sb.append("    hotelIdentifier: ").append(toIndentedString(hotelIdentifier)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    roomConfiguration: ").append(toIndentedString(roomConfiguration)).append("\n");
    sb.append("    promotionalCodes: ").append(toIndentedString(promotionalCodes)).append("\n");
    sb.append("    roomRateIdentifier: ").append(toIndentedString(roomRateIdentifier)).append("\n");
    sb.append("    bedroomConfigurationIdentifier: ").append(toIndentedString(bedroomConfigurationIdentifier)).append("\n");
    sb.append("    ancillaries: ").append(toIndentedString(ancillaries)).append("\n");
    sb.append("    specialRequests: ").append(toIndentedString(specialRequests)).append("\n");
    sb.append("    user: ").append(toIndentedString(user)).append("\n");
    sb.append("    traceId: ").append(toIndentedString(traceId)).append("\n");
    sb.append("    paymentIdentifier: ").append(toIndentedString(paymentIdentifier)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

