/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release   # Booking API Welcome to the Booking Engine API - A programmer-friendly way to book inventory that was found on our platform. We take great care in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive payment-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 25.4.2
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.booking.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.booking.model.BedroomConfigurationAgent;
import travel.wink.sdk.booking.model.CancellationPolicyAgent;
import travel.wink.sdk.booking.model.ExtraChargesAgent;
import travel.wink.sdk.booking.model.GuestRoomAgent;
import travel.wink.sdk.booking.model.MoneysAgent;
import travel.wink.sdk.booking.model.PropertyPolicyAgent;
import travel.wink.sdk.booking.model.RatePlanAgent;
import travel.wink.sdk.booking.model.StayRateAgent;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * All information about the room that was booked.
 */
@JsonPropertyOrder({
  RoomStayAgent.JSON_PROPERTY_POLICY,
  RoomStayAgent.JSON_PROPERTY_ROOM,
  RoomStayAgent.JSON_PROPERTY_ROOMS,
  RoomStayAgent.JSON_PROPERTY_BEDROOM_CONFIGURATION,
  RoomStayAgent.JSON_PROPERTY_ADULTS,
  RoomStayAgent.JSON_PROPERTY_CHILDREN,
  RoomStayAgent.JSON_PROPERTY_START_DATE,
  RoomStayAgent.JSON_PROPERTY_END_DATE,
  RoomStayAgent.JSON_PROPERTY_PRICE,
  RoomStayAgent.JSON_PROPERTY_ROOM_RATE_IDENTIFIER,
  RoomStayAgent.JSON_PROPERTY_ROOM_RATE_INTERNAL_NAME,
  RoomStayAgent.JSON_PROPERTY_RATE_PLAN,
  RoomStayAgent.JSON_PROPERTY_PERK_TYPES,
  RoomStayAgent.JSON_PROPERTY_EXTRA_CHARGES,
  RoomStayAgent.JSON_PROPERTY_ACTIVE_CANCELLATION_POLICY,
  RoomStayAgent.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL,
  RoomStayAgent.JSON_PROPERTY_INTERNAL_TOTAL,
  RoomStayAgent.JSON_PROPERTY_GUESTS,
  RoomStayAgent.JSON_PROPERTY_SOURCE_TOTAL,
  RoomStayAgent.JSON_PROPERTY_CANCELLABLE,
  RoomStayAgent.JSON_PROPERTY_RATE_SOURCE,
  RoomStayAgent.JSON_PROPERTY_ROOM_NIGHTS,
  RoomStayAgent.JSON_PROPERTY_CANCELLABLE_BY_HOTEL,
  RoomStayAgent.JSON_PROPERTY_CANCELLABLE_WITH_POTENTIAL_CHARGE
})
@JsonTypeName("RoomStay_Agent")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-05-12T18:09:00.098679602+07:00[Asia/Bangkok]")
public class RoomStayAgent {
  public static final String JSON_PROPERTY_POLICY = "policy";
  private PropertyPolicyAgent policy;

  public static final String JSON_PROPERTY_ROOM = "room";
  private GuestRoomAgent room;

  public static final String JSON_PROPERTY_ROOMS = "rooms";
  private Integer rooms = 1;

  public static final String JSON_PROPERTY_BEDROOM_CONFIGURATION = "bedroomConfiguration";
  private BedroomConfigurationAgent bedroomConfiguration;

  public static final String JSON_PROPERTY_ADULTS = "adults";
  private Integer adults = 2;

  public static final String JSON_PROPERTY_CHILDREN = "children";
  private Integer children = 0;

  public static final String JSON_PROPERTY_START_DATE = "startDate";
  private LocalDate startDate;

  public static final String JSON_PROPERTY_END_DATE = "endDate";
  private LocalDate endDate;

  public static final String JSON_PROPERTY_PRICE = "price";
  private StayRateAgent price;

  public static final String JSON_PROPERTY_ROOM_RATE_IDENTIFIER = "roomRateIdentifier";
  private UUID roomRateIdentifier;

  public static final String JSON_PROPERTY_ROOM_RATE_INTERNAL_NAME = "roomRateInternalName";
  private String roomRateInternalName;

  public static final String JSON_PROPERTY_RATE_PLAN = "ratePlan";
  private RatePlanAgent ratePlan;

  /**
   * List of perks that came with the master rate
   */
  public enum PerkTypesEnum {
    LOYALTY_POINTS("PERK_LOYALTY_POINTS"),
    
    WINE("PERK_WINE"),
    
    FREE_DRINK_VOUCHER("PERK_FREE_DRINK_VOUCHER"),
    
    FREE_MEAL_TWO_PEOPLE("PERK_FREE_MEAL_TWO_PEOPLE"),
    
    FREE_ONE_HOUR_MASSAGE("PERK_FREE_ONE_HOUR_MASSAGE"),
    
    TWENTY_PERCENT_FOOD_BEVERAGE_DISCOUNT("PERK_TWENTY_PERCENT_FOOD_BEVERAGE_DISCOUNT"),
    
    TWENTY_PERCENT_SPA_DISCOUNT_VOUCHER("PERK_TWENTY_PERCENT_SPA_DISCOUNT_VOUCHER"),
    
    GUARANTEED_UPGRADE("PERK_GUARANTEED_UPGRADE"),
    
    EARLY_CHECKIN("PERK_EARLY_CHECKIN"),
    
    ROOM_UPGRADE("PERK_ROOM_UPGRADE"),
    
    LATE_CHECKOUT("PERK_LATE_CHECKOUT"),
    
    AIRPORT_TRANSFER("PERK_AIRPORT_TRANSFER"),
    
    AIRPORT_PICK_UP("PERK_AIRPORT_PICK_UP"),
    
    BOTTLE_CHAMPAGNE_ON_ARRIVAL("PERK_BOTTLE_CHAMPAGNE_ON_ARRIVAL"),
    
    BOTTLE_SPARKLING_WINE_ON_ARRIVAL("PERK_BOTTLE_SPARKLING_WINE_ON_ARRIVAL"),
    
    BOTTLE_WINE_ON_ARRIVAL("PERK_BOTTLE_WINE_ON_ARRIVAL");

    private String value;

    PerkTypesEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PerkTypesEnum fromValue(String value) {
      for (PerkTypesEnum b : PerkTypesEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PERK_TYPES = "perkTypes";
  private List<PerkTypesEnum> perkTypes = new ArrayList<>();

  public static final String JSON_PROPERTY_EXTRA_CHARGES = "extraCharges";
  private ExtraChargesAgent extraCharges;

  public static final String JSON_PROPERTY_ACTIVE_CANCELLATION_POLICY = "activeCancellationPolicy";
  private CancellationPolicyAgent activeCancellationPolicy;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL = "userSpecifiedCurrencyTotal";
  private MoneysAgent userSpecifiedCurrencyTotal;

  public static final String JSON_PROPERTY_INTERNAL_TOTAL = "internalTotal";
  private MoneysAgent internalTotal;

  public static final String JSON_PROPERTY_GUESTS = "guests";
  private Integer guests;

  public static final String JSON_PROPERTY_SOURCE_TOTAL = "sourceTotal";
  private MoneysAgent sourceTotal;

  public static final String JSON_PROPERTY_CANCELLABLE = "cancellable";
  private Boolean cancellable;

  public static final String JSON_PROPERTY_RATE_SOURCE = "rateSource";
  private String rateSource;

  public static final String JSON_PROPERTY_ROOM_NIGHTS = "roomNights";
  private Long roomNights;

  public static final String JSON_PROPERTY_CANCELLABLE_BY_HOTEL = "cancellableByHotel";
  private Boolean cancellableByHotel;

  public static final String JSON_PROPERTY_CANCELLABLE_WITH_POTENTIAL_CHARGE = "cancellableWithPotentialCharge";
  private Boolean cancellableWithPotentialCharge;

  public RoomStayAgent() {
  }

  public RoomStayAgent policy(PropertyPolicyAgent policy) {
    
    this.policy = policy;
    return this;
  }

   /**
   * Get policy
   * @return policy
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_POLICY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public PropertyPolicyAgent getPolicy() {
    return policy;
  }


  @JsonProperty(JSON_PROPERTY_POLICY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPolicy(PropertyPolicyAgent policy) {
    this.policy = policy;
  }


  public RoomStayAgent room(GuestRoomAgent room) {
    
    this.room = room;
    return this;
  }

   /**
   * Get room
   * @return room
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ROOM)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public GuestRoomAgent getRoom() {
    return room;
  }


  @JsonProperty(JSON_PROPERTY_ROOM)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRoom(GuestRoomAgent room) {
    this.room = room;
  }


  public RoomStayAgent rooms(Integer rooms) {
    
    this.rooms = rooms;
    return this;
  }

   /**
   * Number of rooms. Always 1 since we switched to creating one booking per room.
   * @return rooms
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ROOMS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getRooms() {
    return rooms;
  }


  @JsonProperty(JSON_PROPERTY_ROOMS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRooms(Integer rooms) {
    this.rooms = rooms;
  }


  public RoomStayAgent bedroomConfiguration(BedroomConfigurationAgent bedroomConfiguration) {
    
    this.bedroomConfiguration = bedroomConfiguration;
    return this;
  }

   /**
   * Get bedroomConfiguration
   * @return bedroomConfiguration
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_BEDROOM_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BedroomConfigurationAgent getBedroomConfiguration() {
    return bedroomConfiguration;
  }


  @JsonProperty(JSON_PROPERTY_BEDROOM_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBedroomConfiguration(BedroomConfigurationAgent bedroomConfiguration) {
    this.bedroomConfiguration = bedroomConfiguration;
  }


  public RoomStayAgent adults(Integer adults) {
    
    this.adults = adults;
    return this;
  }

   /**
   * The actual amount of adults as determined by the hotel&#39;s policy.
   * @return adults
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ADULTS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getAdults() {
    return adults;
  }


  @JsonProperty(JSON_PROPERTY_ADULTS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAdults(Integer adults) {
    this.adults = adults;
  }


  public RoomStayAgent children(Integer children) {
    
    this.children = children;
    return this;
  }

   /**
   * The actual amount of children as determined by the hotel&#39;s policy.
   * @return children
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_CHILDREN)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getChildren() {
    return children;
  }


  @JsonProperty(JSON_PROPERTY_CHILDREN)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setChildren(Integer children) {
    this.children = children;
  }


  public RoomStayAgent startDate(LocalDate startDate) {
    
    this.startDate = startDate;
    return this;
  }

   /**
   * Stay start date
   * @return startDate
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public LocalDate getStartDate() {
    return startDate;
  }


  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStartDate(LocalDate startDate) {
    this.startDate = startDate;
  }


  public RoomStayAgent endDate(LocalDate endDate) {
    
    this.endDate = endDate;
    return this;
  }

   /**
   * Stay end date
   * @return endDate
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public LocalDate getEndDate() {
    return endDate;
  }


  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEndDate(LocalDate endDate) {
    this.endDate = endDate;
  }


  public RoomStayAgent price(StayRateAgent price) {
    
    this.price = price;
    return this;
  }

   /**
   * Get price
   * @return price
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public StayRateAgent getPrice() {
    return price;
  }


  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPrice(StayRateAgent price) {
    this.price = price;
  }


  public RoomStayAgent roomRateIdentifier(UUID roomRateIdentifier) {
    
    this.roomRateIdentifier = roomRateIdentifier;
    return this;
  }

   /**
   * Master rate identifier
   * @return roomRateIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ROOM_RATE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getRoomRateIdentifier() {
    return roomRateIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_RATE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRoomRateIdentifier(UUID roomRateIdentifier) {
    this.roomRateIdentifier = roomRateIdentifier;
  }


  public RoomStayAgent roomRateInternalName(String roomRateInternalName) {
    
    this.roomRateInternalName = roomRateInternalName;
    return this;
  }

   /**
   * Master rate internal name
   * @return roomRateInternalName
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ROOM_RATE_INTERNAL_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRoomRateInternalName() {
    return roomRateInternalName;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_RATE_INTERNAL_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRoomRateInternalName(String roomRateInternalName) {
    this.roomRateInternalName = roomRateInternalName;
  }


  public RoomStayAgent ratePlan(RatePlanAgent ratePlan) {
    
    this.ratePlan = ratePlan;
    return this;
  }

   /**
   * Get ratePlan
   * @return ratePlan
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_RATE_PLAN)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public RatePlanAgent getRatePlan() {
    return ratePlan;
  }


  @JsonProperty(JSON_PROPERTY_RATE_PLAN)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRatePlan(RatePlanAgent ratePlan) {
    this.ratePlan = ratePlan;
  }


  public RoomStayAgent perkTypes(List<PerkTypesEnum> perkTypes) {
    
    this.perkTypes = perkTypes;
    return this;
  }

  public RoomStayAgent addPerkTypesItem(PerkTypesEnum perkTypesItem) {
    if (this.perkTypes == null) {
      this.perkTypes = new ArrayList<>();
    }
    this.perkTypes.add(perkTypesItem);
    return this;
  }

   /**
   * List of perks that came with the master rate
   * @return perkTypes
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PERK_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<PerkTypesEnum> getPerkTypes() {
    return perkTypes;
  }


  @JsonProperty(JSON_PROPERTY_PERK_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPerkTypes(List<PerkTypesEnum> perkTypes) {
    this.perkTypes = perkTypes;
  }


  public RoomStayAgent extraCharges(ExtraChargesAgent extraCharges) {
    
    this.extraCharges = extraCharges;
    return this;
  }

   /**
   * Get extraCharges
   * @return extraCharges
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_EXTRA_CHARGES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ExtraChargesAgent getExtraCharges() {
    return extraCharges;
  }


  @JsonProperty(JSON_PROPERTY_EXTRA_CHARGES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setExtraCharges(ExtraChargesAgent extraCharges) {
    this.extraCharges = extraCharges;
  }


  public RoomStayAgent activeCancellationPolicy(CancellationPolicyAgent activeCancellationPolicy) {
    
    this.activeCancellationPolicy = activeCancellationPolicy;
    return this;
  }

   /**
   * Get activeCancellationPolicy
   * @return activeCancellationPolicy
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ACTIVE_CANCELLATION_POLICY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public CancellationPolicyAgent getActiveCancellationPolicy() {
    return activeCancellationPolicy;
  }


  @JsonProperty(JSON_PROPERTY_ACTIVE_CANCELLATION_POLICY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setActiveCancellationPolicy(CancellationPolicyAgent activeCancellationPolicy) {
    this.activeCancellationPolicy = activeCancellationPolicy;
  }


  public RoomStayAgent userSpecifiedCurrencyTotal(MoneysAgent userSpecifiedCurrencyTotal) {
    
    this.userSpecifiedCurrencyTotal = userSpecifiedCurrencyTotal;
    return this;
  }

   /**
   * Get userSpecifiedCurrencyTotal
   * @return userSpecifiedCurrencyTotal
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MoneysAgent getUserSpecifiedCurrencyTotal() {
    return userSpecifiedCurrencyTotal;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyTotal(MoneysAgent userSpecifiedCurrencyTotal) {
    this.userSpecifiedCurrencyTotal = userSpecifiedCurrencyTotal;
  }


  public RoomStayAgent internalTotal(MoneysAgent internalTotal) {
    
    this.internalTotal = internalTotal;
    return this;
  }

   /**
   * Get internalTotal
   * @return internalTotal
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_INTERNAL_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MoneysAgent getInternalTotal() {
    return internalTotal;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalTotal(MoneysAgent internalTotal) {
    this.internalTotal = internalTotal;
  }


  public RoomStayAgent guests(Integer guests) {
    
    this.guests = guests;
    return this;
  }

   /**
   * Get guests
   * @return guests
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_GUESTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getGuests() {
    return guests;
  }


  @JsonProperty(JSON_PROPERTY_GUESTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGuests(Integer guests) {
    this.guests = guests;
  }


  public RoomStayAgent sourceTotal(MoneysAgent sourceTotal) {
    
    this.sourceTotal = sourceTotal;
    return this;
  }

   /**
   * Get sourceTotal
   * @return sourceTotal
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MoneysAgent getSourceTotal() {
    return sourceTotal;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceTotal(MoneysAgent sourceTotal) {
    this.sourceTotal = sourceTotal;
  }


  public RoomStayAgent cancellable(Boolean cancellable) {
    
    this.cancellable = cancellable;
    return this;
  }

   /**
   * Get cancellable
   * @return cancellable
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellable() {
    return cancellable;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellable(Boolean cancellable) {
    this.cancellable = cancellable;
  }


  public RoomStayAgent rateSource(String rateSource) {
    
    this.rateSource = rateSource;
    return this;
  }

   /**
   * Get rateSource
   * @return rateSource
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RATE_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRateSource() {
    return rateSource;
  }


  @JsonProperty(JSON_PROPERTY_RATE_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRateSource(String rateSource) {
    this.rateSource = rateSource;
  }


  public RoomStayAgent roomNights(Long roomNights) {
    
    this.roomNights = roomNights;
    return this;
  }

   /**
   * Total number of nights the guest stays at the hotel. -1 indicates there is an error.
   * @return roomNights
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ROOM_NIGHTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getRoomNights() {
    return roomNights;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_NIGHTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomNights(Long roomNights) {
    this.roomNights = roomNights;
  }


  public RoomStayAgent cancellableByHotel(Boolean cancellableByHotel) {
    
    this.cancellableByHotel = cancellableByHotel;
    return this;
  }

   /**
   * Get cancellableByHotel
   * @return cancellableByHotel
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_HOTEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableByHotel() {
    return cancellableByHotel;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_HOTEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableByHotel(Boolean cancellableByHotel) {
    this.cancellableByHotel = cancellableByHotel;
  }


  public RoomStayAgent cancellableWithPotentialCharge(Boolean cancellableWithPotentialCharge) {
    
    this.cancellableWithPotentialCharge = cancellableWithPotentialCharge;
    return this;
  }

   /**
   * Get cancellableWithPotentialCharge
   * @return cancellableWithPotentialCharge
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLABLE_WITH_POTENTIAL_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableWithPotentialCharge() {
    return cancellableWithPotentialCharge;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_WITH_POTENTIAL_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableWithPotentialCharge(Boolean cancellableWithPotentialCharge) {
    this.cancellableWithPotentialCharge = cancellableWithPotentialCharge;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RoomStayAgent roomStayAgent = (RoomStayAgent) o;
    return Objects.equals(this.policy, roomStayAgent.policy) &&
        Objects.equals(this.room, roomStayAgent.room) &&
        Objects.equals(this.rooms, roomStayAgent.rooms) &&
        Objects.equals(this.bedroomConfiguration, roomStayAgent.bedroomConfiguration) &&
        Objects.equals(this.adults, roomStayAgent.adults) &&
        Objects.equals(this.children, roomStayAgent.children) &&
        Objects.equals(this.startDate, roomStayAgent.startDate) &&
        Objects.equals(this.endDate, roomStayAgent.endDate) &&
        Objects.equals(this.price, roomStayAgent.price) &&
        Objects.equals(this.roomRateIdentifier, roomStayAgent.roomRateIdentifier) &&
        Objects.equals(this.roomRateInternalName, roomStayAgent.roomRateInternalName) &&
        Objects.equals(this.ratePlan, roomStayAgent.ratePlan) &&
        Objects.equals(this.perkTypes, roomStayAgent.perkTypes) &&
        Objects.equals(this.extraCharges, roomStayAgent.extraCharges) &&
        Objects.equals(this.activeCancellationPolicy, roomStayAgent.activeCancellationPolicy) &&
        Objects.equals(this.userSpecifiedCurrencyTotal, roomStayAgent.userSpecifiedCurrencyTotal) &&
        Objects.equals(this.internalTotal, roomStayAgent.internalTotal) &&
        Objects.equals(this.guests, roomStayAgent.guests) &&
        Objects.equals(this.sourceTotal, roomStayAgent.sourceTotal) &&
        Objects.equals(this.cancellable, roomStayAgent.cancellable) &&
        Objects.equals(this.rateSource, roomStayAgent.rateSource) &&
        Objects.equals(this.roomNights, roomStayAgent.roomNights) &&
        Objects.equals(this.cancellableByHotel, roomStayAgent.cancellableByHotel) &&
        Objects.equals(this.cancellableWithPotentialCharge, roomStayAgent.cancellableWithPotentialCharge);
  }

  @Override
  public int hashCode() {
    return Objects.hash(policy, room, rooms, bedroomConfiguration, adults, children, startDate, endDate, price, roomRateIdentifier, roomRateInternalName, ratePlan, perkTypes, extraCharges, activeCancellationPolicy, userSpecifiedCurrencyTotal, internalTotal, guests, sourceTotal, cancellable, rateSource, roomNights, cancellableByHotel, cancellableWithPotentialCharge);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RoomStayAgent {\n");
    sb.append("    policy: ").append(toIndentedString(policy)).append("\n");
    sb.append("    room: ").append(toIndentedString(room)).append("\n");
    sb.append("    rooms: ").append(toIndentedString(rooms)).append("\n");
    sb.append("    bedroomConfiguration: ").append(toIndentedString(bedroomConfiguration)).append("\n");
    sb.append("    adults: ").append(toIndentedString(adults)).append("\n");
    sb.append("    children: ").append(toIndentedString(children)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    price: ").append(toIndentedString(price)).append("\n");
    sb.append("    roomRateIdentifier: ").append(toIndentedString(roomRateIdentifier)).append("\n");
    sb.append("    roomRateInternalName: ").append(toIndentedString(roomRateInternalName)).append("\n");
    sb.append("    ratePlan: ").append(toIndentedString(ratePlan)).append("\n");
    sb.append("    perkTypes: ").append(toIndentedString(perkTypes)).append("\n");
    sb.append("    extraCharges: ").append(toIndentedString(extraCharges)).append("\n");
    sb.append("    activeCancellationPolicy: ").append(toIndentedString(activeCancellationPolicy)).append("\n");
    sb.append("    userSpecifiedCurrencyTotal: ").append(toIndentedString(userSpecifiedCurrencyTotal)).append("\n");
    sb.append("    internalTotal: ").append(toIndentedString(internalTotal)).append("\n");
    sb.append("    guests: ").append(toIndentedString(guests)).append("\n");
    sb.append("    sourceTotal: ").append(toIndentedString(sourceTotal)).append("\n");
    sb.append("    cancellable: ").append(toIndentedString(cancellable)).append("\n");
    sb.append("    rateSource: ").append(toIndentedString(rateSource)).append("\n");
    sb.append("    roomNights: ").append(toIndentedString(roomNights)).append("\n");
    sb.append("    cancellableByHotel: ").append(toIndentedString(cancellableByHotel)).append("\n");
    sb.append("    cancellableWithPotentialCharge: ").append(toIndentedString(cancellableWithPotentialCharge)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

