/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release   # Booking API Welcome to the Booking Engine API - A programmer-friendly way to book inventory that was found on our platform. We take great care in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive payment-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 25.4.2
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.booking.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.booking.model.GeoJsonPointBooker;
import travel.wink.sdk.booking.model.GeoJsonPolygonBooker;
import travel.wink.sdk.booking.model.IPLocationBooker;
import travel.wink.sdk.booking.model.ItineraryBooker;
import travel.wink.sdk.booking.model.RoomConfigurationBooker;
import travel.wink.sdk.booking.model.SearchFiltersBooker;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * User session information containing itinerary and other user related data.
 */
@JsonPropertyOrder({
  UserSessionBooker.JSON_PROPERTY_LOCATION,
  UserSessionBooker.JSON_PROPERTY_IP_LOCATION,
  UserSessionBooker.JSON_PROPERTY_IP_NUMBER,
  UserSessionBooker.JSON_PROPERTY_BOUNDS,
  UserSessionBooker.JSON_PROPERTY_ITINERARY,
  UserSessionBooker.JSON_PROPERTY_SEARCH_FILTERS,
  UserSessionBooker.JSON_PROPERTY_LANGUAGE,
  UserSessionBooker.JSON_PROPERTY_CURRENCY,
  UserSessionBooker.JSON_PROPERTY_REDIRECT_URL,
  UserSessionBooker.JSON_PROPERTY_USER_IDENTIFIER,
  UserSessionBooker.JSON_PROPERTY_PROMOTIONAL_CODES,
  UserSessionBooker.JSON_PROPERTY_SELECTED_ROOM_CONFIGURATION
})
@JsonTypeName("UserSession_Booker")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-05-12T18:09:00.098679602+07:00[Asia/Bangkok]")
public class UserSessionBooker {
  public static final String JSON_PROPERTY_LOCATION = "location";
  private GeoJsonPointBooker location;

  public static final String JSON_PROPERTY_IP_LOCATION = "ipLocation";
  private IPLocationBooker ipLocation;

  public static final String JSON_PROPERTY_IP_NUMBER = "ipNumber";
  private String ipNumber;

  public static final String JSON_PROPERTY_BOUNDS = "bounds";
  private GeoJsonPolygonBooker bounds;

  public static final String JSON_PROPERTY_ITINERARY = "itinerary";
  private ItineraryBooker itinerary;

  public static final String JSON_PROPERTY_SEARCH_FILTERS = "searchFilters";
  private SearchFiltersBooker searchFilters;

  public static final String JSON_PROPERTY_LANGUAGE = "language";
  private String language;

  public static final String JSON_PROPERTY_CURRENCY = "currency";
  private String currency;

  public static final String JSON_PROPERTY_REDIRECT_URL = "redirectUrl";
  private String redirectUrl;

  public static final String JSON_PROPERTY_USER_IDENTIFIER = "userIdentifier";
  private UUID userIdentifier;

  public static final String JSON_PROPERTY_PROMOTIONAL_CODES = "promotionalCodes";
  private List<String> promotionalCodes = new ArrayList<>();

  public static final String JSON_PROPERTY_SELECTED_ROOM_CONFIGURATION = "selectedRoomConfiguration";
  private RoomConfigurationBooker selectedRoomConfiguration;

  public UserSessionBooker() {
  }

  public UserSessionBooker location(GeoJsonPointBooker location) {
    
    this.location = location;
    return this;
  }

   /**
   * Get location
   * @return location
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GeoJsonPointBooker getLocation() {
    return location;
  }


  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLocation(GeoJsonPointBooker location) {
    this.location = location;
  }


  public UserSessionBooker ipLocation(IPLocationBooker ipLocation) {
    
    this.ipLocation = ipLocation;
    return this;
  }

   /**
   * Get ipLocation
   * @return ipLocation
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_IP_LOCATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public IPLocationBooker getIpLocation() {
    return ipLocation;
  }


  @JsonProperty(JSON_PROPERTY_IP_LOCATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIpLocation(IPLocationBooker ipLocation) {
    this.ipLocation = ipLocation;
  }


  public UserSessionBooker ipNumber(String ipNumber) {
    
    this.ipNumber = ipNumber;
    return this;
  }

   /**
   * User&#39;s incoming IP number
   * @return ipNumber
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_IP_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIpNumber() {
    return ipNumber;
  }


  @JsonProperty(JSON_PROPERTY_IP_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIpNumber(String ipNumber) {
    this.ipNumber = ipNumber;
  }


  public UserSessionBooker bounds(GeoJsonPolygonBooker bounds) {
    
    this.bounds = bounds;
    return this;
  }

   /**
   * Get bounds
   * @return bounds
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_BOUNDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GeoJsonPolygonBooker getBounds() {
    return bounds;
  }


  @JsonProperty(JSON_PROPERTY_BOUNDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBounds(GeoJsonPolygonBooker bounds) {
    this.bounds = bounds;
  }


  public UserSessionBooker itinerary(ItineraryBooker itinerary) {
    
    this.itinerary = itinerary;
    return this;
  }

   /**
   * Get itinerary
   * @return itinerary
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ITINERARY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ItineraryBooker getItinerary() {
    return itinerary;
  }


  @JsonProperty(JSON_PROPERTY_ITINERARY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setItinerary(ItineraryBooker itinerary) {
    this.itinerary = itinerary;
  }


  public UserSessionBooker searchFilters(SearchFiltersBooker searchFilters) {
    
    this.searchFilters = searchFilters;
    return this;
  }

   /**
   * Get searchFilters
   * @return searchFilters
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SEARCH_FILTERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SearchFiltersBooker getSearchFilters() {
    return searchFilters;
  }


  @JsonProperty(JSON_PROPERTY_SEARCH_FILTERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSearchFilters(SearchFiltersBooker searchFilters) {
    this.searchFilters = searchFilters;
  }


  public UserSessionBooker language(String language) {
    
    this.language = language;
    return this;
  }

   /**
   * User&#39;s language preference
   * @return language
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLanguage() {
    return language;
  }


  @JsonProperty(JSON_PROPERTY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLanguage(String language) {
    this.language = language;
  }


  public UserSessionBooker currency(String currency) {
    
    this.currency = currency;
    return this;
  }

   /**
   * User&#39;s currency preference
   * @return currency
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCurrency() {
    return currency;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCurrency(String currency) {
    this.currency = currency;
  }


  public UserSessionBooker redirectUrl(String redirectUrl) {
    
    this.redirectUrl = redirectUrl;
    return this;
  }

   /**
   * Get redirectUrl
   * @return redirectUrl
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_REDIRECT_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRedirectUrl() {
    return redirectUrl;
  }


  @JsonProperty(JSON_PROPERTY_REDIRECT_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRedirectUrl(String redirectUrl) {
    this.redirectUrl = redirectUrl;
  }


  public UserSessionBooker userIdentifier(UUID userIdentifier) {
    
    this.userIdentifier = userIdentifier;
    return this;
  }

   /**
   * Pass along the user identifier if user is known.
   * @return userIdentifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_USER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getUserIdentifier() {
    return userIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_USER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserIdentifier(UUID userIdentifier) {
    this.userIdentifier = userIdentifier;
  }


  public UserSessionBooker promotionalCodes(List<String> promotionalCodes) {
    
    this.promotionalCodes = promotionalCodes;
    return this;
  }

  public UserSessionBooker addPromotionalCodesItem(String promotionalCodesItem) {
    if (this.promotionalCodes == null) {
      this.promotionalCodes = new ArrayList<>();
    }
    this.promotionalCodes.add(promotionalCodesItem);
    return this;
  }

   /**
   * Get promotionalCodes
   * @return promotionalCodes
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PROMOTIONAL_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getPromotionalCodes() {
    return promotionalCodes;
  }


  @JsonProperty(JSON_PROPERTY_PROMOTIONAL_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPromotionalCodes(List<String> promotionalCodes) {
    this.promotionalCodes = promotionalCodes;
  }


  public UserSessionBooker selectedRoomConfiguration(RoomConfigurationBooker selectedRoomConfiguration) {
    
    this.selectedRoomConfiguration = selectedRoomConfiguration;
    return this;
  }

   /**
   * Get selectedRoomConfiguration
   * @return selectedRoomConfiguration
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SELECTED_ROOM_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RoomConfigurationBooker getSelectedRoomConfiguration() {
    return selectedRoomConfiguration;
  }


  @JsonProperty(JSON_PROPERTY_SELECTED_ROOM_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSelectedRoomConfiguration(RoomConfigurationBooker selectedRoomConfiguration) {
    this.selectedRoomConfiguration = selectedRoomConfiguration;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UserSessionBooker userSessionBooker = (UserSessionBooker) o;
    return Objects.equals(this.location, userSessionBooker.location) &&
        Objects.equals(this.ipLocation, userSessionBooker.ipLocation) &&
        Objects.equals(this.ipNumber, userSessionBooker.ipNumber) &&
        Objects.equals(this.bounds, userSessionBooker.bounds) &&
        Objects.equals(this.itinerary, userSessionBooker.itinerary) &&
        Objects.equals(this.searchFilters, userSessionBooker.searchFilters) &&
        Objects.equals(this.language, userSessionBooker.language) &&
        Objects.equals(this.currency, userSessionBooker.currency) &&
        Objects.equals(this.redirectUrl, userSessionBooker.redirectUrl) &&
        Objects.equals(this.userIdentifier, userSessionBooker.userIdentifier) &&
        Objects.equals(this.promotionalCodes, userSessionBooker.promotionalCodes) &&
        Objects.equals(this.selectedRoomConfiguration, userSessionBooker.selectedRoomConfiguration);
  }

  @Override
  public int hashCode() {
    return Objects.hash(location, ipLocation, ipNumber, bounds, itinerary, searchFilters, language, currency, redirectUrl, userIdentifier, promotionalCodes, selectedRoomConfiguration);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UserSessionBooker {\n");
    sb.append("    location: ").append(toIndentedString(location)).append("\n");
    sb.append("    ipLocation: ").append(toIndentedString(ipLocation)).append("\n");
    sb.append("    ipNumber: ").append(toIndentedString(ipNumber)).append("\n");
    sb.append("    bounds: ").append(toIndentedString(bounds)).append("\n");
    sb.append("    itinerary: ").append(toIndentedString(itinerary)).append("\n");
    sb.append("    searchFilters: ").append(toIndentedString(searchFilters)).append("\n");
    sb.append("    language: ").append(toIndentedString(language)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    redirectUrl: ").append(toIndentedString(redirectUrl)).append("\n");
    sb.append("    userIdentifier: ").append(toIndentedString(userIdentifier)).append("\n");
    sb.append("    promotionalCodes: ").append(toIndentedString(promotionalCodes)).append("\n");
    sb.append("    selectedRoomConfiguration: ").append(toIndentedString(selectedRoomConfiguration)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

