/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.booking.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import travel.wink.sdk.booking.model.GeoJsonPointAgent;
import travel.wink.sdk.booking.model.GeoJsonPolygonAgent;
import travel.wink.sdk.booking.model.IPLocationAgent;
import travel.wink.sdk.booking.model.ItineraryAgent;
import travel.wink.sdk.booking.model.RoomConfigurationAgent;
import travel.wink.sdk.booking.model.SearchFiltersAgent;

@JsonPropertyOrder(value={"location", "ipLocation", "ipNumber", "bounds", "itinerary", "searchFilters", "language", "currency", "redirectUrl", "userIdentifier", "promotionalCodes", "selectedRoomConfiguration"})
@JsonTypeName(value="UserSession_Agent")
public class UserSessionAgent {
    public static final String JSON_PROPERTY_LOCATION = "location";
    private GeoJsonPointAgent location;
    public static final String JSON_PROPERTY_IP_LOCATION = "ipLocation";
    private IPLocationAgent ipLocation;
    public static final String JSON_PROPERTY_IP_NUMBER = "ipNumber";
    private String ipNumber;
    public static final String JSON_PROPERTY_BOUNDS = "bounds";
    private GeoJsonPolygonAgent bounds;
    public static final String JSON_PROPERTY_ITINERARY = "itinerary";
    private ItineraryAgent itinerary;
    public static final String JSON_PROPERTY_SEARCH_FILTERS = "searchFilters";
    private SearchFiltersAgent searchFilters;
    public static final String JSON_PROPERTY_LANGUAGE = "language";
    private String language;
    public static final String JSON_PROPERTY_CURRENCY = "currency";
    private String currency;
    public static final String JSON_PROPERTY_REDIRECT_URL = "redirectUrl";
    private String redirectUrl;
    public static final String JSON_PROPERTY_USER_IDENTIFIER = "userIdentifier";
    private UUID userIdentifier;
    public static final String JSON_PROPERTY_PROMOTIONAL_CODES = "promotionalCodes";
    private List<String> promotionalCodes = new ArrayList<String>();
    public static final String JSON_PROPERTY_SELECTED_ROOM_CONFIGURATION = "selectedRoomConfiguration";
    private RoomConfigurationAgent selectedRoomConfiguration;

    public UserSessionAgent location(GeoJsonPointAgent location) {
        this.location = location;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="location")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public GeoJsonPointAgent getLocation() {
        return this.location;
    }

    @JsonProperty(value="location")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLocation(GeoJsonPointAgent location) {
        this.location = location;
    }

    public UserSessionAgent ipLocation(IPLocationAgent ipLocation) {
        this.ipLocation = ipLocation;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="ipLocation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IPLocationAgent getIpLocation() {
        return this.ipLocation;
    }

    @JsonProperty(value="ipLocation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIpLocation(IPLocationAgent ipLocation) {
        this.ipLocation = ipLocation;
    }

    public UserSessionAgent ipNumber(String ipNumber) {
        this.ipNumber = ipNumber;
        return this;
    }

    @Nullable
    @JsonProperty(value="ipNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIpNumber() {
        return this.ipNumber;
    }

    @JsonProperty(value="ipNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIpNumber(String ipNumber) {
        this.ipNumber = ipNumber;
    }

    public UserSessionAgent bounds(GeoJsonPolygonAgent bounds) {
        this.bounds = bounds;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="bounds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public GeoJsonPolygonAgent getBounds() {
        return this.bounds;
    }

    @JsonProperty(value="bounds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBounds(GeoJsonPolygonAgent bounds) {
        this.bounds = bounds;
    }

    public UserSessionAgent itinerary(ItineraryAgent itinerary) {
        this.itinerary = itinerary;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="itinerary")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ItineraryAgent getItinerary() {
        return this.itinerary;
    }

    @JsonProperty(value="itinerary")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setItinerary(ItineraryAgent itinerary) {
        this.itinerary = itinerary;
    }

    public UserSessionAgent searchFilters(SearchFiltersAgent searchFilters) {
        this.searchFilters = searchFilters;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="searchFilters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SearchFiltersAgent getSearchFilters() {
        return this.searchFilters;
    }

    @JsonProperty(value="searchFilters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSearchFilters(SearchFiltersAgent searchFilters) {
        this.searchFilters = searchFilters;
    }

    public UserSessionAgent language(String language) {
        this.language = language;
        return this;
    }

    @Nullable
    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLanguage() {
        return this.language;
    }

    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLanguage(String language) {
        this.language = language;
    }

    public UserSessionAgent currency(String currency) {
        this.currency = currency;
        return this;
    }

    @Nullable
    @JsonProperty(value="currency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="currency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public UserSessionAgent redirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
        return this;
    }

    @Nullable
    @JsonProperty(value="redirectUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    @JsonProperty(value="redirectUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    public UserSessionAgent userIdentifier(UUID userIdentifier) {
        this.userIdentifier = userIdentifier;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="userIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getUserIdentifier() {
        return this.userIdentifier;
    }

    @JsonProperty(value="userIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserIdentifier(UUID userIdentifier) {
        this.userIdentifier = userIdentifier;
    }

    public UserSessionAgent promotionalCodes(List<String> promotionalCodes) {
        this.promotionalCodes = promotionalCodes;
        return this;
    }

    public UserSessionAgent addPromotionalCodesItem(String promotionalCodesItem) {
        if (this.promotionalCodes == null) {
            this.promotionalCodes = new ArrayList<String>();
        }
        this.promotionalCodes.add(promotionalCodesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="promotionalCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getPromotionalCodes() {
        return this.promotionalCodes;
    }

    @JsonProperty(value="promotionalCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPromotionalCodes(List<String> promotionalCodes) {
        this.promotionalCodes = promotionalCodes;
    }

    public UserSessionAgent selectedRoomConfiguration(RoomConfigurationAgent selectedRoomConfiguration) {
        this.selectedRoomConfiguration = selectedRoomConfiguration;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="selectedRoomConfiguration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RoomConfigurationAgent getSelectedRoomConfiguration() {
        return this.selectedRoomConfiguration;
    }

    @JsonProperty(value="selectedRoomConfiguration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSelectedRoomConfiguration(RoomConfigurationAgent selectedRoomConfiguration) {
        this.selectedRoomConfiguration = selectedRoomConfiguration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserSessionAgent userSessionAgent = (UserSessionAgent)o;
        return Objects.equals(this.location, userSessionAgent.location) && Objects.equals(this.ipLocation, userSessionAgent.ipLocation) && Objects.equals(this.ipNumber, userSessionAgent.ipNumber) && Objects.equals(this.bounds, userSessionAgent.bounds) && Objects.equals(this.itinerary, userSessionAgent.itinerary) && Objects.equals(this.searchFilters, userSessionAgent.searchFilters) && Objects.equals(this.language, userSessionAgent.language) && Objects.equals(this.currency, userSessionAgent.currency) && Objects.equals(this.redirectUrl, userSessionAgent.redirectUrl) && Objects.equals(this.userIdentifier, userSessionAgent.userIdentifier) && Objects.equals(this.promotionalCodes, userSessionAgent.promotionalCodes) && Objects.equals(this.selectedRoomConfiguration, userSessionAgent.selectedRoomConfiguration);
    }

    public int hashCode() {
        return Objects.hash(this.location, this.ipLocation, this.ipNumber, this.bounds, this.itinerary, this.searchFilters, this.language, this.currency, this.redirectUrl, this.userIdentifier, this.promotionalCodes, this.selectedRoomConfiguration);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserSessionAgent {\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    ipLocation: ").append(this.toIndentedString(this.ipLocation)).append("\n");
        sb.append("    ipNumber: ").append(this.toIndentedString(this.ipNumber)).append("\n");
        sb.append("    bounds: ").append(this.toIndentedString(this.bounds)).append("\n");
        sb.append("    itinerary: ").append(this.toIndentedString(this.itinerary)).append("\n");
        sb.append("    searchFilters: ").append(this.toIndentedString(this.searchFilters)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    redirectUrl: ").append(this.toIndentedString(this.redirectUrl)).append("\n");
        sb.append("    userIdentifier: ").append(this.toIndentedString(this.userIdentifier)).append("\n");
        sb.append("    promotionalCodes: ").append(this.toIndentedString(this.promotionalCodes)).append("\n");
        sb.append("    selectedRoomConfiguration: ").append(this.toIndentedString(this.selectedRoomConfiguration)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

