/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release   # Booking API Welcome to the Booking Engine API - A programmer-friendly way to book inventory that was found on our platform. We take great care in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive payment-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 25.6.4
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.booking.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.booking.model.AncillaryRequestBooker;
import travel.wink.sdk.booking.model.BookingUserRequestBooker;
import travel.wink.sdk.booking.model.CreateStripeSaleRequestBooker;
import travel.wink.sdk.booking.model.RoomConfigurationBooker;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * List of room configuration booking requests. Each entry is a separately booked room.
 */
@JsonPropertyOrder({
  AcquireMerchantBookingRequestBooker.JSON_PROPERTY_HOTEL_IDENTIFIER,
  AcquireMerchantBookingRequestBooker.JSON_PROPERTY_START_DATE,
  AcquireMerchantBookingRequestBooker.JSON_PROPERTY_END_DATE,
  AcquireMerchantBookingRequestBooker.JSON_PROPERTY_ROOM_CONFIGURATION,
  AcquireMerchantBookingRequestBooker.JSON_PROPERTY_PROMOTIONAL_CODES,
  AcquireMerchantBookingRequestBooker.JSON_PROPERTY_ROOM_RATE_IDENTIFIER,
  AcquireMerchantBookingRequestBooker.JSON_PROPERTY_BEDROOM_CONFIGURATION_IDENTIFIER,
  AcquireMerchantBookingRequestBooker.JSON_PROPERTY_ANCILLARIES,
  AcquireMerchantBookingRequestBooker.JSON_PROPERTY_SPECIAL_REQUESTS,
  AcquireMerchantBookingRequestBooker.JSON_PROPERTY_USER,
  AcquireMerchantBookingRequestBooker.JSON_PROPERTY_SALE
})
@JsonTypeName("AcquireMerchantBookingRequest_Booker")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-06-04T14:49:19.658034394+07:00[Asia/Bangkok]")
public class AcquireMerchantBookingRequestBooker {
  public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
  private UUID hotelIdentifier;

  public static final String JSON_PROPERTY_START_DATE = "startDate";
  private LocalDate startDate;

  public static final String JSON_PROPERTY_END_DATE = "endDate";
  private LocalDate endDate;

  public static final String JSON_PROPERTY_ROOM_CONFIGURATION = "roomConfiguration";
  private RoomConfigurationBooker roomConfiguration;

  public static final String JSON_PROPERTY_PROMOTIONAL_CODES = "promotionalCodes";
  private List<String> promotionalCodes = new ArrayList<>();

  public static final String JSON_PROPERTY_ROOM_RATE_IDENTIFIER = "roomRateIdentifier";
  private UUID roomRateIdentifier;

  public static final String JSON_PROPERTY_BEDROOM_CONFIGURATION_IDENTIFIER = "bedroomConfigurationIdentifier";
  private String bedroomConfigurationIdentifier;

  public static final String JSON_PROPERTY_ANCILLARIES = "ancillaries";
  private List<AncillaryRequestBooker> ancillaries = new ArrayList<>();

  public static final String JSON_PROPERTY_SPECIAL_REQUESTS = "specialRequests";
  private String specialRequests;

  public static final String JSON_PROPERTY_USER = "user";
  private BookingUserRequestBooker user;

  public static final String JSON_PROPERTY_SALE = "sale";
  private CreateStripeSaleRequestBooker sale;

  public AcquireMerchantBookingRequestBooker() {
  }

  public AcquireMerchantBookingRequestBooker hotelIdentifier(UUID hotelIdentifier) {
    
    this.hotelIdentifier = hotelIdentifier;
    return this;
  }

   /**
   * Unique hotel record identifier.
   * @return hotelIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getHotelIdentifier() {
    return hotelIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setHotelIdentifier(UUID hotelIdentifier) {
    this.hotelIdentifier = hotelIdentifier;
  }


  public AcquireMerchantBookingRequestBooker startDate(LocalDate startDate) {
    
    this.startDate = startDate;
    return this;
  }

   /**
   * Date when guest arrives on the premises.
   * @return startDate
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public LocalDate getStartDate() {
    return startDate;
  }


  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStartDate(LocalDate startDate) {
    this.startDate = startDate;
  }


  public AcquireMerchantBookingRequestBooker endDate(LocalDate endDate) {
    
    this.endDate = endDate;
    return this;
  }

   /**
   * Date when guest departs the premises.
   * @return endDate
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public LocalDate getEndDate() {
    return endDate;
  }


  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEndDate(LocalDate endDate) {
    this.endDate = endDate;
  }


  public AcquireMerchantBookingRequestBooker roomConfiguration(RoomConfigurationBooker roomConfiguration) {
    
    this.roomConfiguration = roomConfiguration;
    return this;
  }

   /**
   * Get roomConfiguration
   * @return roomConfiguration
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ROOM_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public RoomConfigurationBooker getRoomConfiguration() {
    return roomConfiguration;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRoomConfiguration(RoomConfigurationBooker roomConfiguration) {
    this.roomConfiguration = roomConfiguration;
  }


  public AcquireMerchantBookingRequestBooker promotionalCodes(List<String> promotionalCodes) {
    
    this.promotionalCodes = promotionalCodes;
    return this;
  }

  public AcquireMerchantBookingRequestBooker addPromotionalCodesItem(String promotionalCodesItem) {
    if (this.promotionalCodes == null) {
      this.promotionalCodes = new ArrayList<>();
    }
    this.promotionalCodes.add(promotionalCodesItem);
    return this;
  }

   /**
   * Get promotionalCodes
   * @return promotionalCodes
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PROMOTIONAL_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getPromotionalCodes() {
    return promotionalCodes;
  }


  @JsonProperty(JSON_PROPERTY_PROMOTIONAL_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPromotionalCodes(List<String> promotionalCodes) {
    this.promotionalCodes = promotionalCodes;
  }


  public AcquireMerchantBookingRequestBooker roomRateIdentifier(UUID roomRateIdentifier) {
    
    this.roomRateIdentifier = roomRateIdentifier;
    return this;
  }

   /**
   * The unique master rate that made the guest room / rate plan available for sale.
   * @return roomRateIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ROOM_RATE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getRoomRateIdentifier() {
    return roomRateIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_RATE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRoomRateIdentifier(UUID roomRateIdentifier) {
    this.roomRateIdentifier = roomRateIdentifier;
  }


  public AcquireMerchantBookingRequestBooker bedroomConfigurationIdentifier(String bedroomConfigurationIdentifier) {
    
    this.bedroomConfigurationIdentifier = bedroomConfigurationIdentifier;
    return this;
  }

   /**
   * Guest can optionally request a specific bedroom layout if the room type is set up with multiple layout choices.
   * @return bedroomConfigurationIdentifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_BEDROOM_CONFIGURATION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBedroomConfigurationIdentifier() {
    return bedroomConfigurationIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_BEDROOM_CONFIGURATION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBedroomConfigurationIdentifier(String bedroomConfigurationIdentifier) {
    this.bedroomConfigurationIdentifier = bedroomConfigurationIdentifier;
  }


  public AcquireMerchantBookingRequestBooker ancillaries(List<AncillaryRequestBooker> ancillaries) {
    
    this.ancillaries = ancillaries;
    return this;
  }

  public AcquireMerchantBookingRequestBooker addAncillariesItem(AncillaryRequestBooker ancillariesItem) {
    if (this.ancillaries == null) {
      this.ancillaries = new ArrayList<>();
    }
    this.ancillaries.add(ancillariesItem);
    return this;
  }

   /**
   * Get ancillaries
   * @return ancillaries
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ANCILLARIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<AncillaryRequestBooker> getAncillaries() {
    return ancillaries;
  }


  @JsonProperty(JSON_PROPERTY_ANCILLARIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAncillaries(List<AncillaryRequestBooker> ancillaries) {
    this.ancillaries = ancillaries;
  }


  public AcquireMerchantBookingRequestBooker specialRequests(String specialRequests) {
    
    this.specialRequests = specialRequests;
    return this;
  }

   /**
   * A guest can send a special request to the hotel in free-text here.
   * @return specialRequests
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SPECIAL_REQUESTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSpecialRequests() {
    return specialRequests;
  }


  @JsonProperty(JSON_PROPERTY_SPECIAL_REQUESTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSpecialRequests(String specialRequests) {
    this.specialRequests = specialRequests;
  }


  public AcquireMerchantBookingRequestBooker user(BookingUserRequestBooker user) {
    
    this.user = user;
    return this;
  }

   /**
   * Get user
   * @return user
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_USER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BookingUserRequestBooker getUser() {
    return user;
  }


  @JsonProperty(JSON_PROPERTY_USER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUser(BookingUserRequestBooker user) {
    this.user = user;
  }


  public AcquireMerchantBookingRequestBooker sale(CreateStripeSaleRequestBooker sale) {
    
    this.sale = sale;
    return this;
  }

   /**
   * Get sale
   * @return sale
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_SALE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public CreateStripeSaleRequestBooker getSale() {
    return sale;
  }


  @JsonProperty(JSON_PROPERTY_SALE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSale(CreateStripeSaleRequestBooker sale) {
    this.sale = sale;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AcquireMerchantBookingRequestBooker acquireMerchantBookingRequestBooker = (AcquireMerchantBookingRequestBooker) o;
    return Objects.equals(this.hotelIdentifier, acquireMerchantBookingRequestBooker.hotelIdentifier) &&
        Objects.equals(this.startDate, acquireMerchantBookingRequestBooker.startDate) &&
        Objects.equals(this.endDate, acquireMerchantBookingRequestBooker.endDate) &&
        Objects.equals(this.roomConfiguration, acquireMerchantBookingRequestBooker.roomConfiguration) &&
        Objects.equals(this.promotionalCodes, acquireMerchantBookingRequestBooker.promotionalCodes) &&
        Objects.equals(this.roomRateIdentifier, acquireMerchantBookingRequestBooker.roomRateIdentifier) &&
        Objects.equals(this.bedroomConfigurationIdentifier, acquireMerchantBookingRequestBooker.bedroomConfigurationIdentifier) &&
        Objects.equals(this.ancillaries, acquireMerchantBookingRequestBooker.ancillaries) &&
        Objects.equals(this.specialRequests, acquireMerchantBookingRequestBooker.specialRequests) &&
        Objects.equals(this.user, acquireMerchantBookingRequestBooker.user) &&
        Objects.equals(this.sale, acquireMerchantBookingRequestBooker.sale);
  }

  @Override
  public int hashCode() {
    return Objects.hash(hotelIdentifier, startDate, endDate, roomConfiguration, promotionalCodes, roomRateIdentifier, bedroomConfigurationIdentifier, ancillaries, specialRequests, user, sale);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AcquireMerchantBookingRequestBooker {\n");
    sb.append("    hotelIdentifier: ").append(toIndentedString(hotelIdentifier)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    roomConfiguration: ").append(toIndentedString(roomConfiguration)).append("\n");
    sb.append("    promotionalCodes: ").append(toIndentedString(promotionalCodes)).append("\n");
    sb.append("    roomRateIdentifier: ").append(toIndentedString(roomRateIdentifier)).append("\n");
    sb.append("    bedroomConfigurationIdentifier: ").append(toIndentedString(bedroomConfigurationIdentifier)).append("\n");
    sb.append("    ancillaries: ").append(toIndentedString(ancillaries)).append("\n");
    sb.append("    specialRequests: ").append(toIndentedString(specialRequests)).append("\n");
    sb.append("    user: ").append(toIndentedString(user)).append("\n");
    sb.append("    sale: ").append(toIndentedString(sale)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

