/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release   # Booking API Welcome to the Booking Engine API - A programmer-friendly way to book inventory that was found on our platform. We take great care in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive payment-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 26.0.3
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.booking.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.UUID;
import travel.wink.sdk.booking.model.RawSupplierContractBooker;
import travel.wink.sdk.booking.model.StripeCardholderBooker;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * sale contains all the payment details we need to acquire from TripPay
 */
@JsonPropertyOrder({
  CreateStripeSaleRequestBooker.JSON_PROPERTY_ACQUIRER_IDENTIFIER,
  CreateStripeSaleRequestBooker.JSON_PROPERTY_AFFILIATE_ACCOUNT_IDENTIFIER,
  CreateStripeSaleRequestBooker.JSON_PROPERTY_AFFILIATE_ACCOUNT_IDENTIFIER_TYPE,
  CreateStripeSaleRequestBooker.JSON_PROPERTY_DISPLAY_CURRENCY,
  CreateStripeSaleRequestBooker.JSON_PROPERTY_SOURCE_URL,
  CreateStripeSaleRequestBooker.JSON_PROPERTY_TRACE_ID,
  CreateStripeSaleRequestBooker.JSON_PROPERTY_CONTRACT,
  CreateStripeSaleRequestBooker.JSON_PROPERTY_CARDHOLDER,
  CreateStripeSaleRequestBooker.JSON_PROPERTY_STRIPE_CUSTOMER_IDENTIFIER,
  CreateStripeSaleRequestBooker.JSON_PROPERTY_STRIPE_PAYMENT_METHOD_IDENTIFIER,
  CreateStripeSaleRequestBooker.JSON_PROPERTY_STRIPE_PAYMENT_INTENT_IDENTIFIER
})
@JsonTypeName("CreateStripeSaleRequest_Booker")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-06-10T15:16:35.775571862+07:00[Asia/Bangkok]")
public class CreateStripeSaleRequestBooker {
  public static final String JSON_PROPERTY_ACQUIRER_IDENTIFIER = "acquirerIdentifier";
  private String acquirerIdentifier;

  public static final String JSON_PROPERTY_AFFILIATE_ACCOUNT_IDENTIFIER = "affiliateAccountIdentifier";
  private UUID affiliateAccountIdentifier;

  /**
   * Gets or Sets affiliateAccountIdentifierType
   */
  public enum AffiliateAccountIdentifierTypeEnum {
    INTERNAL("INTERNAL"),
    
    EXTERNAL("EXTERNAL");

    private String value;

    AffiliateAccountIdentifierTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static AffiliateAccountIdentifierTypeEnum fromValue(String value) {
      for (AffiliateAccountIdentifierTypeEnum b : AffiliateAccountIdentifierTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_AFFILIATE_ACCOUNT_IDENTIFIER_TYPE = "affiliateAccountIdentifierType";
  private AffiliateAccountIdentifierTypeEnum affiliateAccountIdentifierType;

  public static final String JSON_PROPERTY_DISPLAY_CURRENCY = "displayCurrency";
  private String displayCurrency;

  public static final String JSON_PROPERTY_SOURCE_URL = "sourceUrl";
  private String sourceUrl;

  public static final String JSON_PROPERTY_TRACE_ID = "traceId";
  private String traceId;

  public static final String JSON_PROPERTY_CONTRACT = "contract";
  private RawSupplierContractBooker contract;

  public static final String JSON_PROPERTY_CARDHOLDER = "cardholder";
  private StripeCardholderBooker cardholder;

  public static final String JSON_PROPERTY_STRIPE_CUSTOMER_IDENTIFIER = "stripeCustomerIdentifier";
  private String stripeCustomerIdentifier;

  public static final String JSON_PROPERTY_STRIPE_PAYMENT_METHOD_IDENTIFIER = "stripePaymentMethodIdentifier";
  private String stripePaymentMethodIdentifier;

  public static final String JSON_PROPERTY_STRIPE_PAYMENT_INTENT_IDENTIFIER = "stripePaymentIntentIdentifier";
  private String stripePaymentIntentIdentifier;

  public CreateStripeSaleRequestBooker() {
  }

  public CreateStripeSaleRequestBooker acquirerIdentifier(String acquirerIdentifier) {
    
    this.acquirerIdentifier = acquirerIdentifier;
    return this;
  }

   /**
   * Get acquirerIdentifier
   * @return acquirerIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ACQUIRER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getAcquirerIdentifier() {
    return acquirerIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_ACQUIRER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAcquirerIdentifier(String acquirerIdentifier) {
    this.acquirerIdentifier = acquirerIdentifier;
  }


  public CreateStripeSaleRequestBooker affiliateAccountIdentifier(UUID affiliateAccountIdentifier) {
    
    this.affiliateAccountIdentifier = affiliateAccountIdentifier;
    return this;
  }

   /**
   * Get affiliateAccountIdentifier
   * @return affiliateAccountIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_AFFILIATE_ACCOUNT_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getAffiliateAccountIdentifier() {
    return affiliateAccountIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_AFFILIATE_ACCOUNT_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAffiliateAccountIdentifier(UUID affiliateAccountIdentifier) {
    this.affiliateAccountIdentifier = affiliateAccountIdentifier;
  }


  public CreateStripeSaleRequestBooker affiliateAccountIdentifierType(AffiliateAccountIdentifierTypeEnum affiliateAccountIdentifierType) {
    
    this.affiliateAccountIdentifierType = affiliateAccountIdentifierType;
    return this;
  }

   /**
   * Get affiliateAccountIdentifierType
   * @return affiliateAccountIdentifierType
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_AFFILIATE_ACCOUNT_IDENTIFIER_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public AffiliateAccountIdentifierTypeEnum getAffiliateAccountIdentifierType() {
    return affiliateAccountIdentifierType;
  }


  @JsonProperty(JSON_PROPERTY_AFFILIATE_ACCOUNT_IDENTIFIER_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAffiliateAccountIdentifierType(AffiliateAccountIdentifierTypeEnum affiliateAccountIdentifierType) {
    this.affiliateAccountIdentifierType = affiliateAccountIdentifierType;
  }


  public CreateStripeSaleRequestBooker displayCurrency(String displayCurrency) {
    
    this.displayCurrency = displayCurrency;
    return this;
  }

   /**
   * Get displayCurrency
   * @return displayCurrency
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_DISPLAY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDisplayCurrency() {
    return displayCurrency;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDisplayCurrency(String displayCurrency) {
    this.displayCurrency = displayCurrency;
  }


  public CreateStripeSaleRequestBooker sourceUrl(String sourceUrl) {
    
    this.sourceUrl = sourceUrl;
    return this;
  }

   /**
   * Get sourceUrl
   * @return sourceUrl
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_SOURCE_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSourceUrl() {
    return sourceUrl;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSourceUrl(String sourceUrl) {
    this.sourceUrl = sourceUrl;
  }


  public CreateStripeSaleRequestBooker traceId(String traceId) {
    
    this.traceId = traceId;
    return this;
  }

   /**
   * Get traceId
   * @return traceId
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TRACE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTraceId() {
    return traceId;
  }


  @JsonProperty(JSON_PROPERTY_TRACE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTraceId(String traceId) {
    this.traceId = traceId;
  }


  public CreateStripeSaleRequestBooker contract(RawSupplierContractBooker contract) {
    
    this.contract = contract;
    return this;
  }

   /**
   * Get contract
   * @return contract
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_CONTRACT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public RawSupplierContractBooker getContract() {
    return contract;
  }


  @JsonProperty(JSON_PROPERTY_CONTRACT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setContract(RawSupplierContractBooker contract) {
    this.contract = contract;
  }


  public CreateStripeSaleRequestBooker cardholder(StripeCardholderBooker cardholder) {
    
    this.cardholder = cardholder;
    return this;
  }

   /**
   * Get cardholder
   * @return cardholder
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CARDHOLDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StripeCardholderBooker getCardholder() {
    return cardholder;
  }


  @JsonProperty(JSON_PROPERTY_CARDHOLDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCardholder(StripeCardholderBooker cardholder) {
    this.cardholder = cardholder;
  }


  public CreateStripeSaleRequestBooker stripeCustomerIdentifier(String stripeCustomerIdentifier) {
    
    this.stripeCustomerIdentifier = stripeCustomerIdentifier;
    return this;
  }

   /**
   * Get stripeCustomerIdentifier
   * @return stripeCustomerIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_STRIPE_CUSTOMER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getStripeCustomerIdentifier() {
    return stripeCustomerIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_STRIPE_CUSTOMER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStripeCustomerIdentifier(String stripeCustomerIdentifier) {
    this.stripeCustomerIdentifier = stripeCustomerIdentifier;
  }


  public CreateStripeSaleRequestBooker stripePaymentMethodIdentifier(String stripePaymentMethodIdentifier) {
    
    this.stripePaymentMethodIdentifier = stripePaymentMethodIdentifier;
    return this;
  }

   /**
   * Get stripePaymentMethodIdentifier
   * @return stripePaymentMethodIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_STRIPE_PAYMENT_METHOD_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getStripePaymentMethodIdentifier() {
    return stripePaymentMethodIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_STRIPE_PAYMENT_METHOD_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStripePaymentMethodIdentifier(String stripePaymentMethodIdentifier) {
    this.stripePaymentMethodIdentifier = stripePaymentMethodIdentifier;
  }


  public CreateStripeSaleRequestBooker stripePaymentIntentIdentifier(String stripePaymentIntentIdentifier) {
    
    this.stripePaymentIntentIdentifier = stripePaymentIntentIdentifier;
    return this;
  }

   /**
   * Get stripePaymentIntentIdentifier
   * @return stripePaymentIntentIdentifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_STRIPE_PAYMENT_INTENT_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getStripePaymentIntentIdentifier() {
    return stripePaymentIntentIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_STRIPE_PAYMENT_INTENT_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStripePaymentIntentIdentifier(String stripePaymentIntentIdentifier) {
    this.stripePaymentIntentIdentifier = stripePaymentIntentIdentifier;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateStripeSaleRequestBooker createStripeSaleRequestBooker = (CreateStripeSaleRequestBooker) o;
    return Objects.equals(this.acquirerIdentifier, createStripeSaleRequestBooker.acquirerIdentifier) &&
        Objects.equals(this.affiliateAccountIdentifier, createStripeSaleRequestBooker.affiliateAccountIdentifier) &&
        Objects.equals(this.affiliateAccountIdentifierType, createStripeSaleRequestBooker.affiliateAccountIdentifierType) &&
        Objects.equals(this.displayCurrency, createStripeSaleRequestBooker.displayCurrency) &&
        Objects.equals(this.sourceUrl, createStripeSaleRequestBooker.sourceUrl) &&
        Objects.equals(this.traceId, createStripeSaleRequestBooker.traceId) &&
        Objects.equals(this.contract, createStripeSaleRequestBooker.contract) &&
        Objects.equals(this.cardholder, createStripeSaleRequestBooker.cardholder) &&
        Objects.equals(this.stripeCustomerIdentifier, createStripeSaleRequestBooker.stripeCustomerIdentifier) &&
        Objects.equals(this.stripePaymentMethodIdentifier, createStripeSaleRequestBooker.stripePaymentMethodIdentifier) &&
        Objects.equals(this.stripePaymentIntentIdentifier, createStripeSaleRequestBooker.stripePaymentIntentIdentifier);
  }

  @Override
  public int hashCode() {
    return Objects.hash(acquirerIdentifier, affiliateAccountIdentifier, affiliateAccountIdentifierType, displayCurrency, sourceUrl, traceId, contract, cardholder, stripeCustomerIdentifier, stripePaymentMethodIdentifier, stripePaymentIntentIdentifier);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateStripeSaleRequestBooker {\n");
    sb.append("    acquirerIdentifier: ").append(toIndentedString(acquirerIdentifier)).append("\n");
    sb.append("    affiliateAccountIdentifier: ").append(toIndentedString(affiliateAccountIdentifier)).append("\n");
    sb.append("    affiliateAccountIdentifierType: ").append(toIndentedString(affiliateAccountIdentifierType)).append("\n");
    sb.append("    displayCurrency: ").append(toIndentedString(displayCurrency)).append("\n");
    sb.append("    sourceUrl: ").append(toIndentedString(sourceUrl)).append("\n");
    sb.append("    traceId: ").append(toIndentedString(traceId)).append("\n");
    sb.append("    contract: ").append(toIndentedString(contract)).append("\n");
    sb.append("    cardholder: ").append(toIndentedString(cardholder)).append("\n");
    sb.append("    stripeCustomerIdentifier: ").append(toIndentedString(stripeCustomerIdentifier)).append("\n");
    sb.append("    stripePaymentMethodIdentifier: ").append(toIndentedString(stripePaymentMethodIdentifier)).append("\n");
    sb.append("    stripePaymentIntentIdentifier: ").append(toIndentedString(stripePaymentIntentIdentifier)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

