/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.booking.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import travel.wink.sdk.booking.model.RawSupplierContractItemBooker;

@JsonPropertyOrder(value={"identifier", "supplierIdentifier", "supplierIdentifierType", "contractItemList", "externalSupplierBookingCode", "externalTransactionIdentifier"})
@JsonTypeName(value="RawSupplierContract_Booker")
public class RawSupplierContractBooker {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private UUID identifier;
    public static final String JSON_PROPERTY_SUPPLIER_IDENTIFIER = "supplierIdentifier";
    private UUID supplierIdentifier;
    public static final String JSON_PROPERTY_SUPPLIER_IDENTIFIER_TYPE = "supplierIdentifierType";
    private SupplierIdentifierTypeEnum supplierIdentifierType;
    public static final String JSON_PROPERTY_CONTRACT_ITEM_LIST = "contractItemList";
    private List<RawSupplierContractItemBooker> contractItemList = new ArrayList<RawSupplierContractItemBooker>();
    public static final String JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE = "externalSupplierBookingCode";
    private String externalSupplierBookingCode;
    public static final String JSON_PROPERTY_EXTERNAL_TRANSACTION_IDENTIFIER = "externalTransactionIdentifier";
    private String externalTransactionIdentifier;

    public RawSupplierContractBooker identifier(UUID identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIdentifier(UUID identifier) {
        this.identifier = identifier;
    }

    public RawSupplierContractBooker supplierIdentifier(UUID supplierIdentifier) {
        this.supplierIdentifier = supplierIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="supplierIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getSupplierIdentifier() {
        return this.supplierIdentifier;
    }

    @JsonProperty(value="supplierIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupplierIdentifier(UUID supplierIdentifier) {
        this.supplierIdentifier = supplierIdentifier;
    }

    public RawSupplierContractBooker supplierIdentifierType(SupplierIdentifierTypeEnum supplierIdentifierType) {
        this.supplierIdentifierType = supplierIdentifierType;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="supplierIdentifierType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SupplierIdentifierTypeEnum getSupplierIdentifierType() {
        return this.supplierIdentifierType;
    }

    @JsonProperty(value="supplierIdentifierType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupplierIdentifierType(SupplierIdentifierTypeEnum supplierIdentifierType) {
        this.supplierIdentifierType = supplierIdentifierType;
    }

    public RawSupplierContractBooker contractItemList(List<RawSupplierContractItemBooker> contractItemList) {
        this.contractItemList = contractItemList;
        return this;
    }

    public RawSupplierContractBooker addContractItemListItem(RawSupplierContractItemBooker contractItemListItem) {
        this.contractItemList.add(contractItemListItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1, max=0x7FFFFFFF)
    @JsonProperty(value="contractItemList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1, max=0x7FFFFFFF) List<RawSupplierContractItemBooker> getContractItemList() {
        return this.contractItemList;
    }

    @JsonProperty(value="contractItemList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setContractItemList(List<RawSupplierContractItemBooker> contractItemList) {
        this.contractItemList = contractItemList;
    }

    public RawSupplierContractBooker externalSupplierBookingCode(String externalSupplierBookingCode) {
        this.externalSupplierBookingCode = externalSupplierBookingCode;
        return this;
    }

    @Nullable
    @JsonProperty(value="externalSupplierBookingCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalSupplierBookingCode() {
        return this.externalSupplierBookingCode;
    }

    @JsonProperty(value="externalSupplierBookingCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExternalSupplierBookingCode(String externalSupplierBookingCode) {
        this.externalSupplierBookingCode = externalSupplierBookingCode;
    }

    public RawSupplierContractBooker externalTransactionIdentifier(String externalTransactionIdentifier) {
        this.externalTransactionIdentifier = externalTransactionIdentifier;
        return this;
    }

    @Nullable
    @JsonProperty(value="externalTransactionIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalTransactionIdentifier() {
        return this.externalTransactionIdentifier;
    }

    @JsonProperty(value="externalTransactionIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExternalTransactionIdentifier(String externalTransactionIdentifier) {
        this.externalTransactionIdentifier = externalTransactionIdentifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RawSupplierContractBooker rawSupplierContractBooker = (RawSupplierContractBooker)o;
        return Objects.equals(this.identifier, rawSupplierContractBooker.identifier) && Objects.equals(this.supplierIdentifier, rawSupplierContractBooker.supplierIdentifier) && Objects.equals((Object)this.supplierIdentifierType, (Object)rawSupplierContractBooker.supplierIdentifierType) && Objects.equals(this.contractItemList, rawSupplierContractBooker.contractItemList) && Objects.equals(this.externalSupplierBookingCode, rawSupplierContractBooker.externalSupplierBookingCode) && Objects.equals(this.externalTransactionIdentifier, rawSupplierContractBooker.externalTransactionIdentifier);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identifier, this.supplierIdentifier, this.supplierIdentifierType, this.contractItemList, this.externalSupplierBookingCode, this.externalTransactionIdentifier});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RawSupplierContractBooker {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    supplierIdentifier: ").append(this.toIndentedString(this.supplierIdentifier)).append("\n");
        sb.append("    supplierIdentifierType: ").append(this.toIndentedString((Object)this.supplierIdentifierType)).append("\n");
        sb.append("    contractItemList: ").append(this.toIndentedString(this.contractItemList)).append("\n");
        sb.append("    externalSupplierBookingCode: ").append(this.toIndentedString(this.externalSupplierBookingCode)).append("\n");
        sb.append("    externalTransactionIdentifier: ").append(this.toIndentedString(this.externalTransactionIdentifier)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum SupplierIdentifierTypeEnum {
        INTERNAL("INTERNAL"),
        EXTERNAL("EXTERNAL");

        private String value;

        private SupplierIdentifierTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SupplierIdentifierTypeEnum fromValue(String value) {
            for (SupplierIdentifierTypeEnum b : SupplierIdentifierTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

