/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release   # Booking API Welcome to the Booking Engine API - A programmer-friendly way to book inventory that was found on our platform. We take great care in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive payment-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 27.1.1
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.booking.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Choose how you want our web components to look and more closely match with your own site style.
 */
@JsonPropertyOrder({
  EngineConfigurationThemeAgent.JSON_PROPERTY_PRIMARY,
  EngineConfigurationThemeAgent.JSON_PROPERTY_SECONDARY,
  EngineConfigurationThemeAgent.JSON_PROPERTY_SUCCESS,
  EngineConfigurationThemeAgent.JSON_PROPERTY_DANGER,
  EngineConfigurationThemeAgent.JSON_PROPERTY_WARNING,
  EngineConfigurationThemeAgent.JSON_PROPERTY_INFO,
  EngineConfigurationThemeAgent.JSON_PROPERTY_LIGHT,
  EngineConfigurationThemeAgent.JSON_PROPERTY_DARK,
  EngineConfigurationThemeAgent.JSON_PROPERTY_BODY,
  EngineConfigurationThemeAgent.JSON_PROPERTY_MUTED,
  EngineConfigurationThemeAgent.JSON_PROPERTY_WHITE
})
@JsonTypeName("EngineConfigurationTheme_Agent")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-07-24T11:28:48.911886725+07:00[Asia/Bangkok]")
public class EngineConfigurationThemeAgent {
  public static final String JSON_PROPERTY_PRIMARY = "primary";
  private String primary = "#dc3545";

  public static final String JSON_PROPERTY_SECONDARY = "secondary";
  private String secondary = "#6c757d";

  public static final String JSON_PROPERTY_SUCCESS = "success";
  private String success = "#28a745";

  public static final String JSON_PROPERTY_DANGER = "danger";
  private String danger = "#dc3545";

  public static final String JSON_PROPERTY_WARNING = "warning";
  private String warning = "#ffc107";

  public static final String JSON_PROPERTY_INFO = "info";
  private String info = "#17a2b8";

  public static final String JSON_PROPERTY_LIGHT = "light";
  private String light = "#f8f9fa";

  public static final String JSON_PROPERTY_DARK = "dark";
  private String dark = "#343a40";

  public static final String JSON_PROPERTY_BODY = "body";
  private String body = "#212529";

  public static final String JSON_PROPERTY_MUTED = "muted";
  private String muted = "#6c757d";

  public static final String JSON_PROPERTY_WHITE = "white";
  private String white = "#ffffff";

  public EngineConfigurationThemeAgent() {
  }

  public EngineConfigurationThemeAgent primary(String primary) {
    
    this.primary = primary;
    return this;
  }

   /**
   * Primary color
   * @return primary
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_PRIMARY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getPrimary() {
    return primary;
  }


  @JsonProperty(JSON_PROPERTY_PRIMARY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPrimary(String primary) {
    this.primary = primary;
  }


  public EngineConfigurationThemeAgent secondary(String secondary) {
    
    this.secondary = secondary;
    return this;
  }

   /**
   * Secondary color
   * @return secondary
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_SECONDARY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSecondary() {
    return secondary;
  }


  @JsonProperty(JSON_PROPERTY_SECONDARY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSecondary(String secondary) {
    this.secondary = secondary;
  }


  public EngineConfigurationThemeAgent success(String success) {
    
    this.success = success;
    return this;
  }

   /**
   * Success color
   * @return success
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_SUCCESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSuccess() {
    return success;
  }


  @JsonProperty(JSON_PROPERTY_SUCCESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSuccess(String success) {
    this.success = success;
  }


  public EngineConfigurationThemeAgent danger(String danger) {
    
    this.danger = danger;
    return this;
  }

   /**
   * Danger color
   * @return danger
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_DANGER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDanger() {
    return danger;
  }


  @JsonProperty(JSON_PROPERTY_DANGER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDanger(String danger) {
    this.danger = danger;
  }


  public EngineConfigurationThemeAgent warning(String warning) {
    
    this.warning = warning;
    return this;
  }

   /**
   * Warning color
   * @return warning
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_WARNING)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getWarning() {
    return warning;
  }


  @JsonProperty(JSON_PROPERTY_WARNING)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setWarning(String warning) {
    this.warning = warning;
  }


  public EngineConfigurationThemeAgent info(String info) {
    
    this.info = info;
    return this;
  }

   /**
   * Info color
   * @return info
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_INFO)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getInfo() {
    return info;
  }


  @JsonProperty(JSON_PROPERTY_INFO)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInfo(String info) {
    this.info = info;
  }


  public EngineConfigurationThemeAgent light(String light) {
    
    this.light = light;
    return this;
  }

   /**
   * Light color
   * @return light
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_LIGHT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getLight() {
    return light;
  }


  @JsonProperty(JSON_PROPERTY_LIGHT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLight(String light) {
    this.light = light;
  }


  public EngineConfigurationThemeAgent dark(String dark) {
    
    this.dark = dark;
    return this;
  }

   /**
   * Dark color
   * @return dark
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_DARK)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDark() {
    return dark;
  }


  @JsonProperty(JSON_PROPERTY_DARK)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDark(String dark) {
    this.dark = dark;
  }


  public EngineConfigurationThemeAgent body(String body) {
    
    this.body = body;
    return this;
  }

   /**
   * Body color
   * @return body
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_BODY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getBody() {
    return body;
  }


  @JsonProperty(JSON_PROPERTY_BODY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBody(String body) {
    this.body = body;
  }


  public EngineConfigurationThemeAgent muted(String muted) {
    
    this.muted = muted;
    return this;
  }

   /**
   * Muted color
   * @return muted
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_MUTED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getMuted() {
    return muted;
  }


  @JsonProperty(JSON_PROPERTY_MUTED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMuted(String muted) {
    this.muted = muted;
  }


  public EngineConfigurationThemeAgent white(String white) {
    
    this.white = white;
    return this;
  }

   /**
   * White color
   * @return white
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_WHITE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getWhite() {
    return white;
  }


  @JsonProperty(JSON_PROPERTY_WHITE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setWhite(String white) {
    this.white = white;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    EngineConfigurationThemeAgent engineConfigurationThemeAgent = (EngineConfigurationThemeAgent) o;
    return Objects.equals(this.primary, engineConfigurationThemeAgent.primary) &&
        Objects.equals(this.secondary, engineConfigurationThemeAgent.secondary) &&
        Objects.equals(this.success, engineConfigurationThemeAgent.success) &&
        Objects.equals(this.danger, engineConfigurationThemeAgent.danger) &&
        Objects.equals(this.warning, engineConfigurationThemeAgent.warning) &&
        Objects.equals(this.info, engineConfigurationThemeAgent.info) &&
        Objects.equals(this.light, engineConfigurationThemeAgent.light) &&
        Objects.equals(this.dark, engineConfigurationThemeAgent.dark) &&
        Objects.equals(this.body, engineConfigurationThemeAgent.body) &&
        Objects.equals(this.muted, engineConfigurationThemeAgent.muted) &&
        Objects.equals(this.white, engineConfigurationThemeAgent.white);
  }

  @Override
  public int hashCode() {
    return Objects.hash(primary, secondary, success, danger, warning, info, light, dark, body, muted, white);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class EngineConfigurationThemeAgent {\n");
    sb.append("    primary: ").append(toIndentedString(primary)).append("\n");
    sb.append("    secondary: ").append(toIndentedString(secondary)).append("\n");
    sb.append("    success: ").append(toIndentedString(success)).append("\n");
    sb.append("    danger: ").append(toIndentedString(danger)).append("\n");
    sb.append("    warning: ").append(toIndentedString(warning)).append("\n");
    sb.append("    info: ").append(toIndentedString(info)).append("\n");
    sb.append("    light: ").append(toIndentedString(light)).append("\n");
    sb.append("    dark: ").append(toIndentedString(dark)).append("\n");
    sb.append("    body: ").append(toIndentedString(body)).append("\n");
    sb.append("    muted: ").append(toIndentedString(muted)).append("\n");
    sb.append("    white: ").append(toIndentedString(white)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

