/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release   # Booking API Welcome to the Booking Engine API - A programmer-friendly way to book inventory that was found on our platform. We take great care in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive payment-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 29.11.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.booking.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * IPLocationAgent
 */
@JsonPropertyOrder({
  IPLocationAgent.JSON_PROPERTY_CITY_NAME,
  IPLocationAgent.JSON_PROPERTY_CITY_GEO_NAME_ID,
  IPLocationAgent.JSON_PROPERTY_COUNTRY_NAME,
  IPLocationAgent.JSON_PROPERTY_COUNTRY_CODE,
  IPLocationAgent.JSON_PROPERTY_COUNTRY_GEO_NAME_ID,
  IPLocationAgent.JSON_PROPERTY_CONTINENT_NAME,
  IPLocationAgent.JSON_PROPERTY_CONTINENT_CODE,
  IPLocationAgent.JSON_PROPERTY_CONTINENT_GEO_NAME_ID,
  IPLocationAgent.JSON_PROPERTY_TIMEZONE,
  IPLocationAgent.JSON_PROPERTY_LONGITUDE,
  IPLocationAgent.JSON_PROPERTY_LATITUDE
})
@JsonTypeName("IPLocation_Agent")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-06T10:49:15.982469720+07:00[Asia/Bangkok]")
public class IPLocationAgent {
  public static final String JSON_PROPERTY_CITY_NAME = "cityName";
  private String cityName;

  public static final String JSON_PROPERTY_CITY_GEO_NAME_ID = "cityGeoNameId";
  private Long cityGeoNameId;

  public static final String JSON_PROPERTY_COUNTRY_NAME = "countryName";
  private String countryName;

  public static final String JSON_PROPERTY_COUNTRY_CODE = "countryCode";
  private String countryCode;

  public static final String JSON_PROPERTY_COUNTRY_GEO_NAME_ID = "countryGeoNameId";
  private Long countryGeoNameId;

  public static final String JSON_PROPERTY_CONTINENT_NAME = "continentName";
  private String continentName;

  public static final String JSON_PROPERTY_CONTINENT_CODE = "continentCode";
  private String continentCode;

  public static final String JSON_PROPERTY_CONTINENT_GEO_NAME_ID = "continentGeoNameId";
  private Long continentGeoNameId;

  public static final String JSON_PROPERTY_TIMEZONE = "timezone";
  private String timezone;

  public static final String JSON_PROPERTY_LONGITUDE = "longitude";
  private java.math.BigDecimal longitude;

  public static final String JSON_PROPERTY_LATITUDE = "latitude";
  private java.math.BigDecimal latitude;

  public IPLocationAgent() {
  }

  public IPLocationAgent cityName(String cityName) {
    
    this.cityName = cityName;
    return this;
  }

   /**
   * Get cityName
   * @return cityName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CITY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCityName() {
    return cityName;
  }


  @JsonProperty(JSON_PROPERTY_CITY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCityName(String cityName) {
    this.cityName = cityName;
  }


  public IPLocationAgent cityGeoNameId(Long cityGeoNameId) {
    
    this.cityGeoNameId = cityGeoNameId;
    return this;
  }

   /**
   * Get cityGeoNameId
   * @return cityGeoNameId
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CITY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getCityGeoNameId() {
    return cityGeoNameId;
  }


  @JsonProperty(JSON_PROPERTY_CITY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCityGeoNameId(Long cityGeoNameId) {
    this.cityGeoNameId = cityGeoNameId;
  }


  public IPLocationAgent countryName(String countryName) {
    
    this.countryName = countryName;
    return this;
  }

   /**
   * Get countryName
   * @return countryName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_COUNTRY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCountryName() {
    return countryName;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountryName(String countryName) {
    this.countryName = countryName;
  }


  public IPLocationAgent countryCode(String countryCode) {
    
    this.countryCode = countryCode;
    return this;
  }

   /**
   * Get countryCode
   * @return countryCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCountryCode() {
    return countryCode;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountryCode(String countryCode) {
    this.countryCode = countryCode;
  }


  public IPLocationAgent countryGeoNameId(Long countryGeoNameId) {
    
    this.countryGeoNameId = countryGeoNameId;
    return this;
  }

   /**
   * Get countryGeoNameId
   * @return countryGeoNameId
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_COUNTRY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getCountryGeoNameId() {
    return countryGeoNameId;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountryGeoNameId(Long countryGeoNameId) {
    this.countryGeoNameId = countryGeoNameId;
  }


  public IPLocationAgent continentName(String continentName) {
    
    this.continentName = continentName;
    return this;
  }

   /**
   * Get continentName
   * @return continentName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CONTINENT_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getContinentName() {
    return continentName;
  }


  @JsonProperty(JSON_PROPERTY_CONTINENT_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContinentName(String continentName) {
    this.continentName = continentName;
  }


  public IPLocationAgent continentCode(String continentCode) {
    
    this.continentCode = continentCode;
    return this;
  }

   /**
   * Get continentCode
   * @return continentCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CONTINENT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getContinentCode() {
    return continentCode;
  }


  @JsonProperty(JSON_PROPERTY_CONTINENT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContinentCode(String continentCode) {
    this.continentCode = continentCode;
  }


  public IPLocationAgent continentGeoNameId(Long continentGeoNameId) {
    
    this.continentGeoNameId = continentGeoNameId;
    return this;
  }

   /**
   * Get continentGeoNameId
   * @return continentGeoNameId
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CONTINENT_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getContinentGeoNameId() {
    return continentGeoNameId;
  }


  @JsonProperty(JSON_PROPERTY_CONTINENT_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContinentGeoNameId(Long continentGeoNameId) {
    this.continentGeoNameId = continentGeoNameId;
  }


  public IPLocationAgent timezone(String timezone) {
    
    this.timezone = timezone;
    return this;
  }

   /**
   * Get timezone
   * @return timezone
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TIMEZONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTimezone() {
    return timezone;
  }


  @JsonProperty(JSON_PROPERTY_TIMEZONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTimezone(String timezone) {
    this.timezone = timezone;
  }


  public IPLocationAgent longitude(java.math.BigDecimal longitude) {
    
    this.longitude = longitude;
    return this;
  }

   /**
   * Get longitude
   * @return longitude
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LONGITUDE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.math.BigDecimal getLongitude() {
    return longitude;
  }


  @JsonProperty(JSON_PROPERTY_LONGITUDE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLongitude(java.math.BigDecimal longitude) {
    this.longitude = longitude;
  }


  public IPLocationAgent latitude(java.math.BigDecimal latitude) {
    
    this.latitude = latitude;
    return this;
  }

   /**
   * Get latitude
   * @return latitude
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LATITUDE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.math.BigDecimal getLatitude() {
    return latitude;
  }


  @JsonProperty(JSON_PROPERTY_LATITUDE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLatitude(java.math.BigDecimal latitude) {
    this.latitude = latitude;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    IPLocationAgent ipLocationAgent = (IPLocationAgent) o;
    return Objects.equals(this.cityName, ipLocationAgent.cityName) &&
        Objects.equals(this.cityGeoNameId, ipLocationAgent.cityGeoNameId) &&
        Objects.equals(this.countryName, ipLocationAgent.countryName) &&
        Objects.equals(this.countryCode, ipLocationAgent.countryCode) &&
        Objects.equals(this.countryGeoNameId, ipLocationAgent.countryGeoNameId) &&
        Objects.equals(this.continentName, ipLocationAgent.continentName) &&
        Objects.equals(this.continentCode, ipLocationAgent.continentCode) &&
        Objects.equals(this.continentGeoNameId, ipLocationAgent.continentGeoNameId) &&
        Objects.equals(this.timezone, ipLocationAgent.timezone) &&
        Objects.equals(this.longitude, ipLocationAgent.longitude) &&
        Objects.equals(this.latitude, ipLocationAgent.latitude);
  }

  @Override
  public int hashCode() {
    return Objects.hash(cityName, cityGeoNameId, countryName, countryCode, countryGeoNameId, continentName, continentCode, continentGeoNameId, timezone, longitude, latitude);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class IPLocationAgent {\n");
    sb.append("    cityName: ").append(toIndentedString(cityName)).append("\n");
    sb.append("    cityGeoNameId: ").append(toIndentedString(cityGeoNameId)).append("\n");
    sb.append("    countryName: ").append(toIndentedString(countryName)).append("\n");
    sb.append("    countryCode: ").append(toIndentedString(countryCode)).append("\n");
    sb.append("    countryGeoNameId: ").append(toIndentedString(countryGeoNameId)).append("\n");
    sb.append("    continentName: ").append(toIndentedString(continentName)).append("\n");
    sb.append("    continentCode: ").append(toIndentedString(continentCode)).append("\n");
    sb.append("    continentGeoNameId: ").append(toIndentedString(continentGeoNameId)).append("\n");
    sb.append("    timezone: ").append(toIndentedString(timezone)).append("\n");
    sb.append("    longitude: ").append(toIndentedString(longitude)).append("\n");
    sb.append("    latitude: ").append(toIndentedString(latitude)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

