/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.booking.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import travel.wink.sdk.booking.model.EngineConfigurationThemeBooker;
import travel.wink.sdk.booking.model.GeoNameBooker;
import travel.wink.sdk.booking.model.RoomConfigurationBooker;
import travel.wink.sdk.booking.model.SimpleMultimediaBooker;

@JsonPropertyOrder(value={"identifier", "name", "ownerIdentifier", "ownerName", "subType", "defaultCurrency", "defaultLanguage", "logos", "hostedBookingEngineUrl", "selfHosted", "themeColors", "numberOfAdvanceDays", "numberOfStayDays", "startDate", "endDate", "roomConfigurations", "useDays", "promotionalCodes", "sendBookingNotificationEmailsToProperty", "sendBookingNotificationEmailsToBooker", "sendBookingNotificationEmailsToChannelManager", "wcBookClickAction", "city", "showUnavailableCard", "showRankings"})
@JsonTypeName(value="EngineConfigurationBookingReport_Booker")
public class EngineConfigurationBookingReportBooker {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private UUID identifier;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_OWNER_IDENTIFIER = "ownerIdentifier";
    private UUID ownerIdentifier;
    public static final String JSON_PROPERTY_OWNER_NAME = "ownerName";
    private String ownerName;
    public static final String JSON_PROPERTY_SUB_TYPE = "subType";
    private SubTypeEnum subType;
    public static final String JSON_PROPERTY_DEFAULT_CURRENCY = "defaultCurrency";
    private String defaultCurrency = "USD";
    public static final String JSON_PROPERTY_DEFAULT_LANGUAGE = "defaultLanguage";
    private String defaultLanguage = "en";
    public static final String JSON_PROPERTY_LOGOS = "logos";
    private List<SimpleMultimediaBooker> logos;
    public static final String JSON_PROPERTY_HOSTED_BOOKING_ENGINE_URL = "hostedBookingEngineUrl";
    private String hostedBookingEngineUrl = "https://ota.wink.travel";
    public static final String JSON_PROPERTY_SELF_HOSTED = "selfHosted";
    private Boolean selfHosted = false;
    public static final String JSON_PROPERTY_THEME_COLORS = "themeColors";
    private EngineConfigurationThemeBooker themeColors;
    public static final String JSON_PROPERTY_NUMBER_OF_ADVANCE_DAYS = "numberOfAdvanceDays";
    private Integer numberOfAdvanceDays;
    public static final String JSON_PROPERTY_NUMBER_OF_STAY_DAYS = "numberOfStayDays";
    private Integer numberOfStayDays;
    public static final String JSON_PROPERTY_START_DATE = "startDate";
    private LocalDate startDate;
    public static final String JSON_PROPERTY_END_DATE = "endDate";
    private LocalDate endDate;
    public static final String JSON_PROPERTY_ROOM_CONFIGURATIONS = "roomConfigurations";
    private List<RoomConfigurationBooker> roomConfigurations;
    public static final String JSON_PROPERTY_USE_DAYS = "useDays";
    private Boolean useDays;
    public static final String JSON_PROPERTY_PROMOTIONAL_CODES = "promotionalCodes";
    private List<String> promotionalCodes;
    public static final String JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_PROPERTY = "sendBookingNotificationEmailsToProperty";
    private Boolean sendBookingNotificationEmailsToProperty = true;
    public static final String JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_BOOKER = "sendBookingNotificationEmailsToBooker";
    private Boolean sendBookingNotificationEmailsToBooker = true;
    public static final String JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_CHANNEL_MANAGER = "sendBookingNotificationEmailsToChannelManager";
    private Boolean sendBookingNotificationEmailsToChannelManager = true;
    public static final String JSON_PROPERTY_WC_BOOK_CLICK_ACTION = "wcBookClickAction";
    private WcBookClickActionEnum wcBookClickAction;
    public static final String JSON_PROPERTY_CITY = "city";
    private GeoNameBooker city;
    public static final String JSON_PROPERTY_SHOW_UNAVAILABLE_CARD = "showUnavailableCard";
    private Boolean showUnavailableCard;
    public static final String JSON_PROPERTY_SHOW_RANKINGS = "showRankings";
    private Boolean showRankings;

    public EngineConfigurationBookingReportBooker identifier(UUID identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIdentifier(UUID identifier) {
        this.identifier = identifier;
    }

    public EngineConfigurationBookingReportBooker name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public EngineConfigurationBookingReportBooker ownerIdentifier(UUID ownerIdentifier) {
        this.ownerIdentifier = ownerIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="ownerIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getOwnerIdentifier() {
        return this.ownerIdentifier;
    }

    @JsonProperty(value="ownerIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOwnerIdentifier(UUID ownerIdentifier) {
        this.ownerIdentifier = ownerIdentifier;
    }

    public EngineConfigurationBookingReportBooker ownerName(String ownerName) {
        this.ownerName = ownerName;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="ownerName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getOwnerName() {
        return this.ownerName;
    }

    @JsonProperty(value="ownerName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public EngineConfigurationBookingReportBooker subType(SubTypeEnum subType) {
        this.subType = subType;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="subType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SubTypeEnum getSubType() {
        return this.subType;
    }

    @JsonProperty(value="subType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSubType(SubTypeEnum subType) {
        this.subType = subType;
    }

    public EngineConfigurationBookingReportBooker defaultCurrency(String defaultCurrency) {
        this.defaultCurrency = defaultCurrency;
        return this;
    }

    @Nullable
    @JsonProperty(value="defaultCurrency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDefaultCurrency() {
        return this.defaultCurrency;
    }

    @JsonProperty(value="defaultCurrency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDefaultCurrency(String defaultCurrency) {
        this.defaultCurrency = defaultCurrency;
    }

    public EngineConfigurationBookingReportBooker defaultLanguage(String defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
        return this;
    }

    @Nullable
    @JsonProperty(value="defaultLanguage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    @JsonProperty(value="defaultLanguage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDefaultLanguage(String defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
    }

    public EngineConfigurationBookingReportBooker logos(List<SimpleMultimediaBooker> logos) {
        this.logos = logos;
        return this;
    }

    public EngineConfigurationBookingReportBooker addLogosItem(SimpleMultimediaBooker logosItem) {
        if (this.logos == null) {
            this.logos = new ArrayList<SimpleMultimediaBooker>();
        }
        this.logos.add(logosItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="logos")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SimpleMultimediaBooker> getLogos() {
        return this.logos;
    }

    @JsonProperty(value="logos")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLogos(List<SimpleMultimediaBooker> logos) {
        this.logos = logos;
    }

    public EngineConfigurationBookingReportBooker hostedBookingEngineUrl(String hostedBookingEngineUrl) {
        this.hostedBookingEngineUrl = hostedBookingEngineUrl;
        return this;
    }

    @Nullable
    @JsonProperty(value="hostedBookingEngineUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHostedBookingEngineUrl() {
        return this.hostedBookingEngineUrl;
    }

    @JsonProperty(value="hostedBookingEngineUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHostedBookingEngineUrl(String hostedBookingEngineUrl) {
        this.hostedBookingEngineUrl = hostedBookingEngineUrl;
    }

    public EngineConfigurationBookingReportBooker selfHosted(Boolean selfHosted) {
        this.selfHosted = selfHosted;
        return this;
    }

    @Nullable
    @JsonProperty(value="selfHosted")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSelfHosted() {
        return this.selfHosted;
    }

    @JsonProperty(value="selfHosted")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSelfHosted(Boolean selfHosted) {
        this.selfHosted = selfHosted;
    }

    public EngineConfigurationBookingReportBooker themeColors(EngineConfigurationThemeBooker themeColors) {
        this.themeColors = themeColors;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="themeColors")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EngineConfigurationThemeBooker getThemeColors() {
        return this.themeColors;
    }

    @JsonProperty(value="themeColors")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setThemeColors(EngineConfigurationThemeBooker themeColors) {
        this.themeColors = themeColors;
    }

    public EngineConfigurationBookingReportBooker numberOfAdvanceDays(Integer numberOfAdvanceDays) {
        this.numberOfAdvanceDays = numberOfAdvanceDays;
        return this;
    }

    @Nullable
    @JsonProperty(value="numberOfAdvanceDays")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getNumberOfAdvanceDays() {
        return this.numberOfAdvanceDays;
    }

    @JsonProperty(value="numberOfAdvanceDays")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNumberOfAdvanceDays(Integer numberOfAdvanceDays) {
        this.numberOfAdvanceDays = numberOfAdvanceDays;
    }

    public EngineConfigurationBookingReportBooker numberOfStayDays(Integer numberOfStayDays) {
        this.numberOfStayDays = numberOfStayDays;
        return this;
    }

    @Nullable
    @JsonProperty(value="numberOfStayDays")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getNumberOfStayDays() {
        return this.numberOfStayDays;
    }

    @JsonProperty(value="numberOfStayDays")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNumberOfStayDays(Integer numberOfStayDays) {
        this.numberOfStayDays = numberOfStayDays;
    }

    public EngineConfigurationBookingReportBooker startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getStartDate() {
        return this.startDate;
    }

    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public EngineConfigurationBookingReportBooker endDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getEndDate() {
        return this.endDate;
    }

    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public EngineConfigurationBookingReportBooker roomConfigurations(List<RoomConfigurationBooker> roomConfigurations) {
        this.roomConfigurations = roomConfigurations;
        return this;
    }

    public EngineConfigurationBookingReportBooker addRoomConfigurationsItem(RoomConfigurationBooker roomConfigurationsItem) {
        if (this.roomConfigurations == null) {
            this.roomConfigurations = new ArrayList<RoomConfigurationBooker>();
        }
        this.roomConfigurations.add(roomConfigurationsItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="roomConfigurations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<RoomConfigurationBooker> getRoomConfigurations() {
        return this.roomConfigurations;
    }

    @JsonProperty(value="roomConfigurations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRoomConfigurations(List<RoomConfigurationBooker> roomConfigurations) {
        this.roomConfigurations = roomConfigurations;
    }

    public EngineConfigurationBookingReportBooker useDays(Boolean useDays) {
        this.useDays = useDays;
        return this;
    }

    @Nullable
    @JsonProperty(value="useDays")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getUseDays() {
        return this.useDays;
    }

    @JsonProperty(value="useDays")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUseDays(Boolean useDays) {
        this.useDays = useDays;
    }

    public EngineConfigurationBookingReportBooker promotionalCodes(List<String> promotionalCodes) {
        this.promotionalCodes = promotionalCodes;
        return this;
    }

    public EngineConfigurationBookingReportBooker addPromotionalCodesItem(String promotionalCodesItem) {
        if (this.promotionalCodes == null) {
            this.promotionalCodes = new ArrayList<String>();
        }
        this.promotionalCodes.add(promotionalCodesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="promotionalCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getPromotionalCodes() {
        return this.promotionalCodes;
    }

    @JsonProperty(value="promotionalCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPromotionalCodes(List<String> promotionalCodes) {
        this.promotionalCodes = promotionalCodes;
    }

    public EngineConfigurationBookingReportBooker sendBookingNotificationEmailsToProperty(Boolean sendBookingNotificationEmailsToProperty) {
        this.sendBookingNotificationEmailsToProperty = sendBookingNotificationEmailsToProperty;
        return this;
    }

    @Nullable
    @JsonProperty(value="sendBookingNotificationEmailsToProperty")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSendBookingNotificationEmailsToProperty() {
        return this.sendBookingNotificationEmailsToProperty;
    }

    @JsonProperty(value="sendBookingNotificationEmailsToProperty")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSendBookingNotificationEmailsToProperty(Boolean sendBookingNotificationEmailsToProperty) {
        this.sendBookingNotificationEmailsToProperty = sendBookingNotificationEmailsToProperty;
    }

    public EngineConfigurationBookingReportBooker sendBookingNotificationEmailsToBooker(Boolean sendBookingNotificationEmailsToBooker) {
        this.sendBookingNotificationEmailsToBooker = sendBookingNotificationEmailsToBooker;
        return this;
    }

    @Nullable
    @JsonProperty(value="sendBookingNotificationEmailsToBooker")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSendBookingNotificationEmailsToBooker() {
        return this.sendBookingNotificationEmailsToBooker;
    }

    @JsonProperty(value="sendBookingNotificationEmailsToBooker")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSendBookingNotificationEmailsToBooker(Boolean sendBookingNotificationEmailsToBooker) {
        this.sendBookingNotificationEmailsToBooker = sendBookingNotificationEmailsToBooker;
    }

    public EngineConfigurationBookingReportBooker sendBookingNotificationEmailsToChannelManager(Boolean sendBookingNotificationEmailsToChannelManager) {
        this.sendBookingNotificationEmailsToChannelManager = sendBookingNotificationEmailsToChannelManager;
        return this;
    }

    @Nullable
    @JsonProperty(value="sendBookingNotificationEmailsToChannelManager")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSendBookingNotificationEmailsToChannelManager() {
        return this.sendBookingNotificationEmailsToChannelManager;
    }

    @JsonProperty(value="sendBookingNotificationEmailsToChannelManager")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSendBookingNotificationEmailsToChannelManager(Boolean sendBookingNotificationEmailsToChannelManager) {
        this.sendBookingNotificationEmailsToChannelManager = sendBookingNotificationEmailsToChannelManager;
    }

    public EngineConfigurationBookingReportBooker wcBookClickAction(WcBookClickActionEnum wcBookClickAction) {
        this.wcBookClickAction = wcBookClickAction;
        return this;
    }

    @Nullable
    @JsonProperty(value="wcBookClickAction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WcBookClickActionEnum getWcBookClickAction() {
        return this.wcBookClickAction;
    }

    @JsonProperty(value="wcBookClickAction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWcBookClickAction(WcBookClickActionEnum wcBookClickAction) {
        this.wcBookClickAction = wcBookClickAction;
    }

    public EngineConfigurationBookingReportBooker city(GeoNameBooker city) {
        this.city = city;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="city")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public GeoNameBooker getCity() {
        return this.city;
    }

    @JsonProperty(value="city")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCity(GeoNameBooker city) {
        this.city = city;
    }

    public EngineConfigurationBookingReportBooker showUnavailableCard(Boolean showUnavailableCard) {
        this.showUnavailableCard = showUnavailableCard;
        return this;
    }

    @Nullable
    @JsonProperty(value="showUnavailableCard")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getShowUnavailableCard() {
        return this.showUnavailableCard;
    }

    @JsonProperty(value="showUnavailableCard")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShowUnavailableCard(Boolean showUnavailableCard) {
        this.showUnavailableCard = showUnavailableCard;
    }

    public EngineConfigurationBookingReportBooker showRankings(Boolean showRankings) {
        this.showRankings = showRankings;
        return this;
    }

    @Nullable
    @JsonProperty(value="showRankings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getShowRankings() {
        return this.showRankings;
    }

    @JsonProperty(value="showRankings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShowRankings(Boolean showRankings) {
        this.showRankings = showRankings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EngineConfigurationBookingReportBooker engineConfigurationBookingReportBooker = (EngineConfigurationBookingReportBooker)o;
        return Objects.equals(this.identifier, engineConfigurationBookingReportBooker.identifier) && Objects.equals(this.name, engineConfigurationBookingReportBooker.name) && Objects.equals(this.ownerIdentifier, engineConfigurationBookingReportBooker.ownerIdentifier) && Objects.equals(this.ownerName, engineConfigurationBookingReportBooker.ownerName) && Objects.equals((Object)this.subType, (Object)engineConfigurationBookingReportBooker.subType) && Objects.equals(this.defaultCurrency, engineConfigurationBookingReportBooker.defaultCurrency) && Objects.equals(this.defaultLanguage, engineConfigurationBookingReportBooker.defaultLanguage) && Objects.equals(this.logos, engineConfigurationBookingReportBooker.logos) && Objects.equals(this.hostedBookingEngineUrl, engineConfigurationBookingReportBooker.hostedBookingEngineUrl) && Objects.equals(this.selfHosted, engineConfigurationBookingReportBooker.selfHosted) && Objects.equals(this.themeColors, engineConfigurationBookingReportBooker.themeColors) && Objects.equals(this.numberOfAdvanceDays, engineConfigurationBookingReportBooker.numberOfAdvanceDays) && Objects.equals(this.numberOfStayDays, engineConfigurationBookingReportBooker.numberOfStayDays) && Objects.equals(this.startDate, engineConfigurationBookingReportBooker.startDate) && Objects.equals(this.endDate, engineConfigurationBookingReportBooker.endDate) && Objects.equals(this.roomConfigurations, engineConfigurationBookingReportBooker.roomConfigurations) && Objects.equals(this.useDays, engineConfigurationBookingReportBooker.useDays) && Objects.equals(this.promotionalCodes, engineConfigurationBookingReportBooker.promotionalCodes) && Objects.equals(this.sendBookingNotificationEmailsToProperty, engineConfigurationBookingReportBooker.sendBookingNotificationEmailsToProperty) && Objects.equals(this.sendBookingNotificationEmailsToBooker, engineConfigurationBookingReportBooker.sendBookingNotificationEmailsToBooker) && Objects.equals(this.sendBookingNotificationEmailsToChannelManager, engineConfigurationBookingReportBooker.sendBookingNotificationEmailsToChannelManager) && Objects.equals((Object)this.wcBookClickAction, (Object)engineConfigurationBookingReportBooker.wcBookClickAction) && Objects.equals(this.city, engineConfigurationBookingReportBooker.city) && Objects.equals(this.showUnavailableCard, engineConfigurationBookingReportBooker.showUnavailableCard) && Objects.equals(this.showRankings, engineConfigurationBookingReportBooker.showRankings);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identifier, this.name, this.ownerIdentifier, this.ownerName, this.subType, this.defaultCurrency, this.defaultLanguage, this.logos, this.hostedBookingEngineUrl, this.selfHosted, this.themeColors, this.numberOfAdvanceDays, this.numberOfStayDays, this.startDate, this.endDate, this.roomConfigurations, this.useDays, this.promotionalCodes, this.sendBookingNotificationEmailsToProperty, this.sendBookingNotificationEmailsToBooker, this.sendBookingNotificationEmailsToChannelManager, this.wcBookClickAction, this.city, this.showUnavailableCard, this.showRankings});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EngineConfigurationBookingReportBooker {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    ownerIdentifier: ").append(this.toIndentedString(this.ownerIdentifier)).append("\n");
        sb.append("    ownerName: ").append(this.toIndentedString(this.ownerName)).append("\n");
        sb.append("    subType: ").append(this.toIndentedString((Object)this.subType)).append("\n");
        sb.append("    defaultCurrency: ").append(this.toIndentedString(this.defaultCurrency)).append("\n");
        sb.append("    defaultLanguage: ").append(this.toIndentedString(this.defaultLanguage)).append("\n");
        sb.append("    logos: ").append(this.toIndentedString(this.logos)).append("\n");
        sb.append("    hostedBookingEngineUrl: ").append(this.toIndentedString(this.hostedBookingEngineUrl)).append("\n");
        sb.append("    selfHosted: ").append(this.toIndentedString(this.selfHosted)).append("\n");
        sb.append("    themeColors: ").append(this.toIndentedString(this.themeColors)).append("\n");
        sb.append("    numberOfAdvanceDays: ").append(this.toIndentedString(this.numberOfAdvanceDays)).append("\n");
        sb.append("    numberOfStayDays: ").append(this.toIndentedString(this.numberOfStayDays)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    roomConfigurations: ").append(this.toIndentedString(this.roomConfigurations)).append("\n");
        sb.append("    useDays: ").append(this.toIndentedString(this.useDays)).append("\n");
        sb.append("    promotionalCodes: ").append(this.toIndentedString(this.promotionalCodes)).append("\n");
        sb.append("    sendBookingNotificationEmailsToProperty: ").append(this.toIndentedString(this.sendBookingNotificationEmailsToProperty)).append("\n");
        sb.append("    sendBookingNotificationEmailsToBooker: ").append(this.toIndentedString(this.sendBookingNotificationEmailsToBooker)).append("\n");
        sb.append("    sendBookingNotificationEmailsToChannelManager: ").append(this.toIndentedString(this.sendBookingNotificationEmailsToChannelManager)).append("\n");
        sb.append("    wcBookClickAction: ").append(this.toIndentedString((Object)this.wcBookClickAction)).append("\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    showUnavailableCard: ").append(this.toIndentedString(this.showUnavailableCard)).append("\n");
        sb.append("    showRankings: ").append(this.toIndentedString(this.showRankings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum SubTypeEnum {
        DIRECT("DIRECT"),
        APPLICATION("APPLICATION"),
        HOTEL("HOTEL"),
        TRAVELIKO("TRAVELIKO"),
        CORPORATE("CORPORATE"),
        TRAVEL_AGENT("TRAVEL_AGENT"),
        INFLUENCER("INFLUENCER"),
        BLOGGER("BLOGGER"),
        DESTINATION("DESTINATION"),
        CHANNEL_MANAGER("CHANNEL_MANAGER"),
        PROPERTY_MANAGEMENT_SYSTEM("PROPERTY_MANAGEMENT_SYSTEM"),
        CENTRAL_RESERVATION_SYSTEM("CENTRAL_RESERVATION_SYSTEM");

        private String value;

        private SubTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SubTypeEnum fromValue(String value) {
            for (SubTypeEnum b : SubTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum WcBookClickActionEnum {
        FORWARD_TO_IBE("FORWARD_TO_IBE"),
        IBE_MODAL("IBE_MODAL");

        private String value;

        private WcBookClickActionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static WcBookClickActionEnum fromValue(String value) {
            for (WcBookClickActionEnum b : WcBookClickActionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

