/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.booking.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import travel.wink.sdk.booking.model.BookingContractItemBooker;
import travel.wink.sdk.booking.model.BookingContractPaymentDetailsBooker;
import travel.wink.sdk.booking.model.CustomMonetaryAmount;
import travel.wink.sdk.booking.model.QuoteBooker;
import travel.wink.sdk.booking.model.RefundBooker;

@JsonPropertyOrder(value={"bookingContractIdentifier", "createdDate", "lastUpdate", "ipAddress", "traceId", "sourceUrl", "identifier", "supplierIdentifier", "supplierName", "displayPriceQuote", "supplierPriceQuote", "internalPriceQuote", "capturePriceQuote", "itemList", "externalSupplierIdentifier", "externalSupplierBookingCode", "payment", "cancelled", "cancelledOn", "canceller", "cancellationType", "cancellerUserIdentifier", "cancelReason", "fundsProcessed", "refunds", "sourceCurrency", "displayCurrency", "supplierCurrency", "internalCurrency", "captureCurrency", "sourceAmount", "displayAmount", "supplierAmount", "internalAmount", "captureAmount", "sourceAmountRefundModifier", "displayAmountRefundModifier", "supplierAmountRefundModifier", "internalAmountRefundModifier", "captureAmountRefundModifier", "netSourceAmount", "netDisplayAmount", "netSupplierAmount", "netInternalAmount", "netCaptureAmount", "totalTokensEarned", "hasRefunds", "originalCommissionsInPercent", "originalFeesInPercent", "totalCommissionsInPercentWithRefund", "totalFeesInPercentWithRefund", "totalTripPayFeeInPercentWithRefund", "lodging", "totalTripPayFeeInPercent", "cancellableBySupplier", "cancellableByTraveler", "cancellableWithNoCharges", "isCancellableWithPotentialCharges", "netCommissionableTotalSourceAmount", "netCommissionableTotalCaptureAmount", "netCommissionableTotalDisplayAmount", "netCommissionableTotalInternalAmount", "netTotalFeesAndCommissionsSourceAmount", "netTotalFeesAndCommissionsCaptureAmount", "netTotalFeesAndCommissionsDisplayAmount", "netTotalFeesAndCommissionsInternalAmount", "netTotalFeesSourceAmount", "netTotalFeesCaptureAmount", "netTotalFeesDisplayAmount", "netTotalFeesInternalAmount", "netTotalTripPayFeeSourceAmount", "netTotalTripPayFeeCaptureAmount", "netTotalTripPayFeeDisplayAmount", "netTotalTripPayFeeInternalAmount", "netTotalSalesSourceAmount", "netTotalSalesCaptureAmount", "netTotalSalesDisplayAmount", "netTotalSalesSupplierAmount", "netTotalSalesInternalAmount", "commissionableTotalSourceAmount", "commissionableTotalCaptureAmount", "commissionableTotalDisplayAmount", "commissionableTotalInternalAmount", "totalFeesAndCommissionsSourceAmount", "totalFeesAndCommissionsCaptureAmount", "totalFeesAndCommissionsDisplayAmount", "totalFeesAndCommissionsInternalAmount", "totalFeesSourceAmount", "totalFeesCaptureAmount", "totalFeesDisplayAmount", "totalFeesInternalAmount", "totalTripPayFeeSourceAmount", "totalTripPayFeeCaptureAmount", "totalTripPayFeeDisplayAmount", "totalTripPayFeeInternalAmount", "totalSalesSourceAmount", "totalSalesCaptureAmount", "totalSalesDisplayAmount", "totalSalesSupplierAmount", "totalSalesInternalAmount", "fundsAvailableDate", "totalFeesInPercent", "totalCommissionsInPercent", "totalFeesAndCommissionsInPercentWithRefund", "totalFeesAndCommissionsInPercent", "hasSuccessfulRefunds", "hasPendingRefunds", "hasFailedRefunds", "netTotalFeesAndCommissionsSupplierAmount", "totalFeesSupplierAmount", "netTotalTripPayFeeSupplierAmount", "totalTripPayFeeSupplierAmount", "netCommissionableTotalSupplierAmount", "commissionableTotalSupplierAmount", "totalFeesAndCommissionsSupplierAmount", "netTotalFeesSupplierAmount"})
@JsonTypeName(value="BookingContract_Booker")
public class BookingContractBooker {
    public static final String JSON_PROPERTY_BOOKING_CONTRACT_IDENTIFIER = "bookingContractIdentifier";
    private UUID bookingContractIdentifier;
    public static final String JSON_PROPERTY_CREATED_DATE = "createdDate";
    private LocalDateTime createdDate;
    public static final String JSON_PROPERTY_LAST_UPDATE = "lastUpdate";
    private LocalDateTime lastUpdate;
    public static final String JSON_PROPERTY_IP_ADDRESS = "ipAddress";
    private String ipAddress;
    public static final String JSON_PROPERTY_TRACE_ID = "traceId";
    private String traceId;
    public static final String JSON_PROPERTY_SOURCE_URL = "sourceUrl";
    private String sourceUrl;
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private UUID identifier;
    public static final String JSON_PROPERTY_SUPPLIER_IDENTIFIER = "supplierIdentifier";
    private UUID supplierIdentifier;
    public static final String JSON_PROPERTY_SUPPLIER_NAME = "supplierName";
    private String supplierName;
    public static final String JSON_PROPERTY_DISPLAY_PRICE_QUOTE = "displayPriceQuote";
    private QuoteBooker displayPriceQuote;
    public static final String JSON_PROPERTY_SUPPLIER_PRICE_QUOTE = "supplierPriceQuote";
    private QuoteBooker supplierPriceQuote;
    public static final String JSON_PROPERTY_INTERNAL_PRICE_QUOTE = "internalPriceQuote";
    private QuoteBooker internalPriceQuote;
    public static final String JSON_PROPERTY_CAPTURE_PRICE_QUOTE = "capturePriceQuote";
    private QuoteBooker capturePriceQuote;
    public static final String JSON_PROPERTY_ITEM_LIST = "itemList";
    private List<BookingContractItemBooker> itemList = new ArrayList<BookingContractItemBooker>();
    public static final String JSON_PROPERTY_EXTERNAL_SUPPLIER_IDENTIFIER = "externalSupplierIdentifier";
    private String externalSupplierIdentifier;
    public static final String JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE = "externalSupplierBookingCode";
    private String externalSupplierBookingCode;
    public static final String JSON_PROPERTY_PAYMENT = "payment";
    private BookingContractPaymentDetailsBooker payment;
    public static final String JSON_PROPERTY_CANCELLED = "cancelled";
    private Boolean cancelled = false;
    public static final String JSON_PROPERTY_CANCELLED_ON = "cancelledOn";
    private LocalDateTime cancelledOn;
    public static final String JSON_PROPERTY_CANCELLER = "canceller";
    private CancellerEnum canceller;
    public static final String JSON_PROPERTY_CANCELLATION_TYPE = "cancellationType";
    private CancellationTypeEnum cancellationType;
    public static final String JSON_PROPERTY_CANCELLER_USER_IDENTIFIER = "cancellerUserIdentifier";
    private String cancellerUserIdentifier;
    public static final String JSON_PROPERTY_CANCEL_REASON = "cancelReason";
    private String cancelReason;
    public static final String JSON_PROPERTY_FUNDS_PROCESSED = "fundsProcessed";
    private Boolean fundsProcessed;
    public static final String JSON_PROPERTY_REFUNDS = "refunds";
    private List<RefundBooker> refunds = new ArrayList<RefundBooker>();
    public static final String JSON_PROPERTY_SOURCE_CURRENCY = "sourceCurrency";
    private String sourceCurrency;
    public static final String JSON_PROPERTY_DISPLAY_CURRENCY = "displayCurrency";
    private String displayCurrency;
    public static final String JSON_PROPERTY_SUPPLIER_CURRENCY = "supplierCurrency";
    private String supplierCurrency;
    public static final String JSON_PROPERTY_INTERNAL_CURRENCY = "internalCurrency";
    private String internalCurrency;
    public static final String JSON_PROPERTY_CAPTURE_CURRENCY = "captureCurrency";
    private String captureCurrency;
    public static final String JSON_PROPERTY_SOURCE_AMOUNT = "sourceAmount";
    private BigDecimal sourceAmount;
    public static final String JSON_PROPERTY_DISPLAY_AMOUNT = "displayAmount";
    private BigDecimal displayAmount;
    public static final String JSON_PROPERTY_SUPPLIER_AMOUNT = "supplierAmount";
    private BigDecimal supplierAmount;
    public static final String JSON_PROPERTY_INTERNAL_AMOUNT = "internalAmount";
    private BigDecimal internalAmount;
    public static final String JSON_PROPERTY_CAPTURE_AMOUNT = "captureAmount";
    private BigDecimal captureAmount;
    public static final String JSON_PROPERTY_SOURCE_AMOUNT_REFUND_MODIFIER = "sourceAmountRefundModifier";
    private BigDecimal sourceAmountRefundModifier;
    public static final String JSON_PROPERTY_DISPLAY_AMOUNT_REFUND_MODIFIER = "displayAmountRefundModifier";
    private BigDecimal displayAmountRefundModifier;
    public static final String JSON_PROPERTY_SUPPLIER_AMOUNT_REFUND_MODIFIER = "supplierAmountRefundModifier";
    private BigDecimal supplierAmountRefundModifier;
    public static final String JSON_PROPERTY_INTERNAL_AMOUNT_REFUND_MODIFIER = "internalAmountRefundModifier";
    private BigDecimal internalAmountRefundModifier;
    public static final String JSON_PROPERTY_CAPTURE_AMOUNT_REFUND_MODIFIER = "captureAmountRefundModifier";
    private BigDecimal captureAmountRefundModifier;
    public static final String JSON_PROPERTY_NET_SOURCE_AMOUNT = "netSourceAmount";
    private BigDecimal netSourceAmount;
    public static final String JSON_PROPERTY_NET_DISPLAY_AMOUNT = "netDisplayAmount";
    private BigDecimal netDisplayAmount;
    public static final String JSON_PROPERTY_NET_SUPPLIER_AMOUNT = "netSupplierAmount";
    private BigDecimal netSupplierAmount;
    public static final String JSON_PROPERTY_NET_INTERNAL_AMOUNT = "netInternalAmount";
    private BigDecimal netInternalAmount;
    public static final String JSON_PROPERTY_NET_CAPTURE_AMOUNT = "netCaptureAmount";
    private BigDecimal netCaptureAmount;
    public static final String JSON_PROPERTY_TOTAL_TOKENS_EARNED = "totalTokensEarned";
    private Long totalTokensEarned;
    public static final String JSON_PROPERTY_HAS_REFUNDS = "hasRefunds";
    private Boolean hasRefunds;
    public static final String JSON_PROPERTY_ORIGINAL_COMMISSIONS_IN_PERCENT = "originalCommissionsInPercent";
    private BigDecimal originalCommissionsInPercent;
    public static final String JSON_PROPERTY_ORIGINAL_FEES_IN_PERCENT = "originalFeesInPercent";
    private BigDecimal originalFeesInPercent;
    public static final String JSON_PROPERTY_TOTAL_COMMISSIONS_IN_PERCENT_WITH_REFUND = "totalCommissionsInPercentWithRefund";
    private Float totalCommissionsInPercentWithRefund;
    public static final String JSON_PROPERTY_TOTAL_FEES_IN_PERCENT_WITH_REFUND = "totalFeesInPercentWithRefund";
    private Float totalFeesInPercentWithRefund;
    public static final String JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_IN_PERCENT_WITH_REFUND = "totalTripPayFeeInPercentWithRefund";
    private Float totalTripPayFeeInPercentWithRefund;
    public static final String JSON_PROPERTY_LODGING = "lodging";
    private BookingContractItemBooker lodging;
    public static final String JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_IN_PERCENT = "totalTripPayFeeInPercent";
    private Float totalTripPayFeeInPercent;
    public static final String JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER = "cancellableBySupplier";
    private Boolean cancellableBySupplier;
    public static final String JSON_PROPERTY_CANCELLABLE_BY_TRAVELER = "cancellableByTraveler";
    private Boolean cancellableByTraveler;
    public static final String JSON_PROPERTY_CANCELLABLE_WITH_NO_CHARGES = "cancellableWithNoCharges";
    private Boolean cancellableWithNoCharges;
    public static final String JSON_PROPERTY_IS_CANCELLABLE_WITH_POTENTIAL_CHARGES = "isCancellableWithPotentialCharges";
    private Boolean isCancellableWithPotentialCharges;
    public static final String JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_SOURCE_AMOUNT = "netCommissionableTotalSourceAmount";
    private CustomMonetaryAmount netCommissionableTotalSourceAmount;
    public static final String JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_CAPTURE_AMOUNT = "netCommissionableTotalCaptureAmount";
    private CustomMonetaryAmount netCommissionableTotalCaptureAmount;
    public static final String JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_DISPLAY_AMOUNT = "netCommissionableTotalDisplayAmount";
    private CustomMonetaryAmount netCommissionableTotalDisplayAmount;
    public static final String JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_INTERNAL_AMOUNT = "netCommissionableTotalInternalAmount";
    private CustomMonetaryAmount netCommissionableTotalInternalAmount;
    public static final String JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_SOURCE_AMOUNT = "netTotalFeesAndCommissionsSourceAmount";
    private CustomMonetaryAmount netTotalFeesAndCommissionsSourceAmount;
    public static final String JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_CAPTURE_AMOUNT = "netTotalFeesAndCommissionsCaptureAmount";
    private CustomMonetaryAmount netTotalFeesAndCommissionsCaptureAmount;
    public static final String JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_DISPLAY_AMOUNT = "netTotalFeesAndCommissionsDisplayAmount";
    private CustomMonetaryAmount netTotalFeesAndCommissionsDisplayAmount;
    public static final String JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_INTERNAL_AMOUNT = "netTotalFeesAndCommissionsInternalAmount";
    private CustomMonetaryAmount netTotalFeesAndCommissionsInternalAmount;
    public static final String JSON_PROPERTY_NET_TOTAL_FEES_SOURCE_AMOUNT = "netTotalFeesSourceAmount";
    private CustomMonetaryAmount netTotalFeesSourceAmount;
    public static final String JSON_PROPERTY_NET_TOTAL_FEES_CAPTURE_AMOUNT = "netTotalFeesCaptureAmount";
    private CustomMonetaryAmount netTotalFeesCaptureAmount;
    public static final String JSON_PROPERTY_NET_TOTAL_FEES_DISPLAY_AMOUNT = "netTotalFeesDisplayAmount";
    private CustomMonetaryAmount netTotalFeesDisplayAmount;
    public static final String JSON_PROPERTY_NET_TOTAL_FEES_INTERNAL_AMOUNT = "netTotalFeesInternalAmount";
    private CustomMonetaryAmount netTotalFeesInternalAmount;
    public static final String JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_SOURCE_AMOUNT = "netTotalTripPayFeeSourceAmount";
    private CustomMonetaryAmount netTotalTripPayFeeSourceAmount;
    public static final String JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_CAPTURE_AMOUNT = "netTotalTripPayFeeCaptureAmount";
    private CustomMonetaryAmount netTotalTripPayFeeCaptureAmount;
    public static final String JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_DISPLAY_AMOUNT = "netTotalTripPayFeeDisplayAmount";
    private CustomMonetaryAmount netTotalTripPayFeeDisplayAmount;
    public static final String JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_INTERNAL_AMOUNT = "netTotalTripPayFeeInternalAmount";
    private CustomMonetaryAmount netTotalTripPayFeeInternalAmount;
    public static final String JSON_PROPERTY_NET_TOTAL_SALES_SOURCE_AMOUNT = "netTotalSalesSourceAmount";
    private CustomMonetaryAmount netTotalSalesSourceAmount;
    public static final String JSON_PROPERTY_NET_TOTAL_SALES_CAPTURE_AMOUNT = "netTotalSalesCaptureAmount";
    private CustomMonetaryAmount netTotalSalesCaptureAmount;
    public static final String JSON_PROPERTY_NET_TOTAL_SALES_DISPLAY_AMOUNT = "netTotalSalesDisplayAmount";
    private CustomMonetaryAmount netTotalSalesDisplayAmount;
    public static final String JSON_PROPERTY_NET_TOTAL_SALES_SUPPLIER_AMOUNT = "netTotalSalesSupplierAmount";
    private CustomMonetaryAmount netTotalSalesSupplierAmount;
    public static final String JSON_PROPERTY_NET_TOTAL_SALES_INTERNAL_AMOUNT = "netTotalSalesInternalAmount";
    private CustomMonetaryAmount netTotalSalesInternalAmount;
    public static final String JSON_PROPERTY_COMMISSIONABLE_TOTAL_SOURCE_AMOUNT = "commissionableTotalSourceAmount";
    private CustomMonetaryAmount commissionableTotalSourceAmount;
    public static final String JSON_PROPERTY_COMMISSIONABLE_TOTAL_CAPTURE_AMOUNT = "commissionableTotalCaptureAmount";
    private CustomMonetaryAmount commissionableTotalCaptureAmount;
    public static final String JSON_PROPERTY_COMMISSIONABLE_TOTAL_DISPLAY_AMOUNT = "commissionableTotalDisplayAmount";
    private CustomMonetaryAmount commissionableTotalDisplayAmount;
    public static final String JSON_PROPERTY_COMMISSIONABLE_TOTAL_INTERNAL_AMOUNT = "commissionableTotalInternalAmount";
    private CustomMonetaryAmount commissionableTotalInternalAmount;
    public static final String JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_SOURCE_AMOUNT = "totalFeesAndCommissionsSourceAmount";
    private CustomMonetaryAmount totalFeesAndCommissionsSourceAmount;
    public static final String JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_CAPTURE_AMOUNT = "totalFeesAndCommissionsCaptureAmount";
    private CustomMonetaryAmount totalFeesAndCommissionsCaptureAmount;
    public static final String JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_DISPLAY_AMOUNT = "totalFeesAndCommissionsDisplayAmount";
    private CustomMonetaryAmount totalFeesAndCommissionsDisplayAmount;
    public static final String JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_INTERNAL_AMOUNT = "totalFeesAndCommissionsInternalAmount";
    private CustomMonetaryAmount totalFeesAndCommissionsInternalAmount;
    public static final String JSON_PROPERTY_TOTAL_FEES_SOURCE_AMOUNT = "totalFeesSourceAmount";
    private CustomMonetaryAmount totalFeesSourceAmount;
    public static final String JSON_PROPERTY_TOTAL_FEES_CAPTURE_AMOUNT = "totalFeesCaptureAmount";
    private CustomMonetaryAmount totalFeesCaptureAmount;
    public static final String JSON_PROPERTY_TOTAL_FEES_DISPLAY_AMOUNT = "totalFeesDisplayAmount";
    private CustomMonetaryAmount totalFeesDisplayAmount;
    public static final String JSON_PROPERTY_TOTAL_FEES_INTERNAL_AMOUNT = "totalFeesInternalAmount";
    private CustomMonetaryAmount totalFeesInternalAmount;
    public static final String JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_SOURCE_AMOUNT = "totalTripPayFeeSourceAmount";
    private CustomMonetaryAmount totalTripPayFeeSourceAmount;
    public static final String JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_CAPTURE_AMOUNT = "totalTripPayFeeCaptureAmount";
    private CustomMonetaryAmount totalTripPayFeeCaptureAmount;
    public static final String JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_DISPLAY_AMOUNT = "totalTripPayFeeDisplayAmount";
    private CustomMonetaryAmount totalTripPayFeeDisplayAmount;
    public static final String JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_INTERNAL_AMOUNT = "totalTripPayFeeInternalAmount";
    private CustomMonetaryAmount totalTripPayFeeInternalAmount;
    public static final String JSON_PROPERTY_TOTAL_SALES_SOURCE_AMOUNT = "totalSalesSourceAmount";
    private CustomMonetaryAmount totalSalesSourceAmount;
    public static final String JSON_PROPERTY_TOTAL_SALES_CAPTURE_AMOUNT = "totalSalesCaptureAmount";
    private CustomMonetaryAmount totalSalesCaptureAmount;
    public static final String JSON_PROPERTY_TOTAL_SALES_DISPLAY_AMOUNT = "totalSalesDisplayAmount";
    private CustomMonetaryAmount totalSalesDisplayAmount;
    public static final String JSON_PROPERTY_TOTAL_SALES_SUPPLIER_AMOUNT = "totalSalesSupplierAmount";
    private CustomMonetaryAmount totalSalesSupplierAmount;
    public static final String JSON_PROPERTY_TOTAL_SALES_INTERNAL_AMOUNT = "totalSalesInternalAmount";
    private CustomMonetaryAmount totalSalesInternalAmount;
    public static final String JSON_PROPERTY_FUNDS_AVAILABLE_DATE = "fundsAvailableDate";
    private LocalDate fundsAvailableDate;
    public static final String JSON_PROPERTY_TOTAL_FEES_IN_PERCENT = "totalFeesInPercent";
    private Float totalFeesInPercent;
    public static final String JSON_PROPERTY_TOTAL_COMMISSIONS_IN_PERCENT = "totalCommissionsInPercent";
    private Float totalCommissionsInPercent;
    public static final String JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_IN_PERCENT_WITH_REFUND = "totalFeesAndCommissionsInPercentWithRefund";
    private Float totalFeesAndCommissionsInPercentWithRefund;
    public static final String JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_IN_PERCENT = "totalFeesAndCommissionsInPercent";
    private Float totalFeesAndCommissionsInPercent;
    public static final String JSON_PROPERTY_HAS_SUCCESSFUL_REFUNDS = "hasSuccessfulRefunds";
    private Boolean hasSuccessfulRefunds;
    public static final String JSON_PROPERTY_HAS_PENDING_REFUNDS = "hasPendingRefunds";
    private Boolean hasPendingRefunds;
    public static final String JSON_PROPERTY_HAS_FAILED_REFUNDS = "hasFailedRefunds";
    private Boolean hasFailedRefunds;
    public static final String JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_SUPPLIER_AMOUNT = "netTotalFeesAndCommissionsSupplierAmount";
    private CustomMonetaryAmount netTotalFeesAndCommissionsSupplierAmount;
    public static final String JSON_PROPERTY_TOTAL_FEES_SUPPLIER_AMOUNT = "totalFeesSupplierAmount";
    private CustomMonetaryAmount totalFeesSupplierAmount;
    public static final String JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_SUPPLIER_AMOUNT = "netTotalTripPayFeeSupplierAmount";
    private CustomMonetaryAmount netTotalTripPayFeeSupplierAmount;
    public static final String JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_SUPPLIER_AMOUNT = "totalTripPayFeeSupplierAmount";
    private CustomMonetaryAmount totalTripPayFeeSupplierAmount;
    public static final String JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_SUPPLIER_AMOUNT = "netCommissionableTotalSupplierAmount";
    private CustomMonetaryAmount netCommissionableTotalSupplierAmount;
    public static final String JSON_PROPERTY_COMMISSIONABLE_TOTAL_SUPPLIER_AMOUNT = "commissionableTotalSupplierAmount";
    private CustomMonetaryAmount commissionableTotalSupplierAmount;
    public static final String JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_SUPPLIER_AMOUNT = "totalFeesAndCommissionsSupplierAmount";
    private CustomMonetaryAmount totalFeesAndCommissionsSupplierAmount;
    public static final String JSON_PROPERTY_NET_TOTAL_FEES_SUPPLIER_AMOUNT = "netTotalFeesSupplierAmount";
    private CustomMonetaryAmount netTotalFeesSupplierAmount;

    public BookingContractBooker bookingContractIdentifier(UUID bookingContractIdentifier) {
        this.bookingContractIdentifier = bookingContractIdentifier;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="bookingContractIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getBookingContractIdentifier() {
        return this.bookingContractIdentifier;
    }

    @JsonProperty(value="bookingContractIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBookingContractIdentifier(UUID bookingContractIdentifier) {
        this.bookingContractIdentifier = bookingContractIdentifier;
    }

    public BookingContractBooker createdDate(LocalDateTime createdDate) {
        this.createdDate = createdDate;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="createdDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDateTime getCreatedDate() {
        return this.createdDate;
    }

    @JsonProperty(value="createdDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedDate(LocalDateTime createdDate) {
        this.createdDate = createdDate;
    }

    public BookingContractBooker lastUpdate(LocalDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="lastUpdate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDateTime getLastUpdate() {
        return this.lastUpdate;
    }

    @JsonProperty(value="lastUpdate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLastUpdate(LocalDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public BookingContractBooker ipAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="ipAddress")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getIpAddress() {
        return this.ipAddress;
    }

    @JsonProperty(value="ipAddress")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public BookingContractBooker traceId(String traceId) {
        this.traceId = traceId;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="traceId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTraceId() {
        return this.traceId;
    }

    @JsonProperty(value="traceId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public BookingContractBooker sourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="sourceUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSourceUrl() {
        return this.sourceUrl;
    }

    @JsonProperty(value="sourceUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    public BookingContractBooker identifier(UUID identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIdentifier(UUID identifier) {
        this.identifier = identifier;
    }

    public BookingContractBooker supplierIdentifier(UUID supplierIdentifier) {
        this.supplierIdentifier = supplierIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="supplierIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getSupplierIdentifier() {
        return this.supplierIdentifier;
    }

    @JsonProperty(value="supplierIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupplierIdentifier(UUID supplierIdentifier) {
        this.supplierIdentifier = supplierIdentifier;
    }

    public BookingContractBooker supplierName(String supplierName) {
        this.supplierName = supplierName;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="supplierName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSupplierName() {
        return this.supplierName;
    }

    @JsonProperty(value="supplierName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public BookingContractBooker displayPriceQuote(QuoteBooker displayPriceQuote) {
        this.displayPriceQuote = displayPriceQuote;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="displayPriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public QuoteBooker getDisplayPriceQuote() {
        return this.displayPriceQuote;
    }

    @JsonProperty(value="displayPriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDisplayPriceQuote(QuoteBooker displayPriceQuote) {
        this.displayPriceQuote = displayPriceQuote;
    }

    public BookingContractBooker supplierPriceQuote(QuoteBooker supplierPriceQuote) {
        this.supplierPriceQuote = supplierPriceQuote;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="supplierPriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public QuoteBooker getSupplierPriceQuote() {
        return this.supplierPriceQuote;
    }

    @JsonProperty(value="supplierPriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupplierPriceQuote(QuoteBooker supplierPriceQuote) {
        this.supplierPriceQuote = supplierPriceQuote;
    }

    public BookingContractBooker internalPriceQuote(QuoteBooker internalPriceQuote) {
        this.internalPriceQuote = internalPriceQuote;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="internalPriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public QuoteBooker getInternalPriceQuote() {
        return this.internalPriceQuote;
    }

    @JsonProperty(value="internalPriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setInternalPriceQuote(QuoteBooker internalPriceQuote) {
        this.internalPriceQuote = internalPriceQuote;
    }

    public BookingContractBooker capturePriceQuote(QuoteBooker capturePriceQuote) {
        this.capturePriceQuote = capturePriceQuote;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="capturePriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public QuoteBooker getCapturePriceQuote() {
        return this.capturePriceQuote;
    }

    @JsonProperty(value="capturePriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCapturePriceQuote(QuoteBooker capturePriceQuote) {
        this.capturePriceQuote = capturePriceQuote;
    }

    public BookingContractBooker itemList(List<BookingContractItemBooker> itemList) {
        this.itemList = itemList;
        return this;
    }

    public BookingContractBooker addItemListItem(BookingContractItemBooker itemListItem) {
        this.itemList.add(itemListItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1, max=0x7FFFFFFF)
    @JsonProperty(value="itemList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1, max=0x7FFFFFFF) List<BookingContractItemBooker> getItemList() {
        return this.itemList;
    }

    @JsonProperty(value="itemList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setItemList(List<BookingContractItemBooker> itemList) {
        this.itemList = itemList;
    }

    public BookingContractBooker externalSupplierIdentifier(String externalSupplierIdentifier) {
        this.externalSupplierIdentifier = externalSupplierIdentifier;
        return this;
    }

    @Nullable
    @JsonProperty(value="externalSupplierIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalSupplierIdentifier() {
        return this.externalSupplierIdentifier;
    }

    @JsonProperty(value="externalSupplierIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExternalSupplierIdentifier(String externalSupplierIdentifier) {
        this.externalSupplierIdentifier = externalSupplierIdentifier;
    }

    public BookingContractBooker externalSupplierBookingCode(String externalSupplierBookingCode) {
        this.externalSupplierBookingCode = externalSupplierBookingCode;
        return this;
    }

    @Nullable
    @JsonProperty(value="externalSupplierBookingCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalSupplierBookingCode() {
        return this.externalSupplierBookingCode;
    }

    @JsonProperty(value="externalSupplierBookingCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExternalSupplierBookingCode(String externalSupplierBookingCode) {
        this.externalSupplierBookingCode = externalSupplierBookingCode;
    }

    public BookingContractBooker payment(BookingContractPaymentDetailsBooker payment) {
        this.payment = payment;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="payment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BookingContractPaymentDetailsBooker getPayment() {
        return this.payment;
    }

    @JsonProperty(value="payment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPayment(BookingContractPaymentDetailsBooker payment) {
        this.payment = payment;
    }

    public BookingContractBooker cancelled(Boolean cancelled) {
        this.cancelled = cancelled;
        return this;
    }

    @Nullable
    @JsonProperty(value="cancelled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCancelled() {
        return this.cancelled;
    }

    @JsonProperty(value="cancelled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancelled(Boolean cancelled) {
        this.cancelled = cancelled;
    }

    public BookingContractBooker cancelledOn(LocalDateTime cancelledOn) {
        this.cancelledOn = cancelledOn;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="cancelledOn")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDateTime getCancelledOn() {
        return this.cancelledOn;
    }

    @JsonProperty(value="cancelledOn")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancelledOn(LocalDateTime cancelledOn) {
        this.cancelledOn = cancelledOn;
    }

    public BookingContractBooker canceller(CancellerEnum canceller) {
        this.canceller = canceller;
        return this;
    }

    @Nullable
    @JsonProperty(value="canceller")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CancellerEnum getCanceller() {
        return this.canceller;
    }

    @JsonProperty(value="canceller")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCanceller(CancellerEnum canceller) {
        this.canceller = canceller;
    }

    public BookingContractBooker cancellationType(CancellationTypeEnum cancellationType) {
        this.cancellationType = cancellationType;
        return this;
    }

    @Nullable
    @JsonProperty(value="cancellationType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CancellationTypeEnum getCancellationType() {
        return this.cancellationType;
    }

    @JsonProperty(value="cancellationType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellationType(CancellationTypeEnum cancellationType) {
        this.cancellationType = cancellationType;
    }

    public BookingContractBooker cancellerUserIdentifier(String cancellerUserIdentifier) {
        this.cancellerUserIdentifier = cancellerUserIdentifier;
        return this;
    }

    @Nullable
    @JsonProperty(value="cancellerUserIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCancellerUserIdentifier() {
        return this.cancellerUserIdentifier;
    }

    @JsonProperty(value="cancellerUserIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellerUserIdentifier(String cancellerUserIdentifier) {
        this.cancellerUserIdentifier = cancellerUserIdentifier;
    }

    public BookingContractBooker cancelReason(String cancelReason) {
        this.cancelReason = cancelReason;
        return this;
    }

    @Nullable
    @JsonProperty(value="cancelReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCancelReason() {
        return this.cancelReason;
    }

    @JsonProperty(value="cancelReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancelReason(String cancelReason) {
        this.cancelReason = cancelReason;
    }

    public BookingContractBooker fundsProcessed(Boolean fundsProcessed) {
        this.fundsProcessed = fundsProcessed;
        return this;
    }

    @Nullable
    @JsonProperty(value="fundsProcessed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getFundsProcessed() {
        return this.fundsProcessed;
    }

    @JsonProperty(value="fundsProcessed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFundsProcessed(Boolean fundsProcessed) {
        this.fundsProcessed = fundsProcessed;
    }

    public BookingContractBooker refunds(List<RefundBooker> refunds) {
        this.refunds = refunds;
        return this;
    }

    public BookingContractBooker addRefundsItem(RefundBooker refundsItem) {
        if (this.refunds == null) {
            this.refunds = new ArrayList<RefundBooker>();
        }
        this.refunds.add(refundsItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="refunds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<RefundBooker> getRefunds() {
        return this.refunds;
    }

    @JsonProperty(value="refunds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRefunds(List<RefundBooker> refunds) {
        this.refunds = refunds;
    }

    public BookingContractBooker sourceCurrency(String sourceCurrency) {
        this.sourceCurrency = sourceCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="sourceCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSourceCurrency() {
        return this.sourceCurrency;
    }

    @JsonProperty(value="sourceCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSourceCurrency(String sourceCurrency) {
        this.sourceCurrency = sourceCurrency;
    }

    public BookingContractBooker displayCurrency(String displayCurrency) {
        this.displayCurrency = displayCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="displayCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDisplayCurrency() {
        return this.displayCurrency;
    }

    @JsonProperty(value="displayCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDisplayCurrency(String displayCurrency) {
        this.displayCurrency = displayCurrency;
    }

    public BookingContractBooker supplierCurrency(String supplierCurrency) {
        this.supplierCurrency = supplierCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="supplierCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSupplierCurrency() {
        return this.supplierCurrency;
    }

    @JsonProperty(value="supplierCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupplierCurrency(String supplierCurrency) {
        this.supplierCurrency = supplierCurrency;
    }

    public BookingContractBooker internalCurrency(String internalCurrency) {
        this.internalCurrency = internalCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="internalCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getInternalCurrency() {
        return this.internalCurrency;
    }

    @JsonProperty(value="internalCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setInternalCurrency(String internalCurrency) {
        this.internalCurrency = internalCurrency;
    }

    public BookingContractBooker captureCurrency(String captureCurrency) {
        this.captureCurrency = captureCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="captureCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCaptureCurrency() {
        return this.captureCurrency;
    }

    @JsonProperty(value="captureCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCaptureCurrency(String captureCurrency) {
        this.captureCurrency = captureCurrency;
    }

    public BookingContractBooker sourceAmount(BigDecimal sourceAmount) {
        this.sourceAmount = sourceAmount;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @DecimalMin(value="0")
    @JsonProperty(value="sourceAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @DecimalMin(value="0") BigDecimal getSourceAmount() {
        return this.sourceAmount;
    }

    @JsonProperty(value="sourceAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSourceAmount(BigDecimal sourceAmount) {
        this.sourceAmount = sourceAmount;
    }

    public BookingContractBooker displayAmount(BigDecimal displayAmount) {
        this.displayAmount = displayAmount;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @DecimalMin(value="0")
    @JsonProperty(value="displayAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @DecimalMin(value="0") BigDecimal getDisplayAmount() {
        return this.displayAmount;
    }

    @JsonProperty(value="displayAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDisplayAmount(BigDecimal displayAmount) {
        this.displayAmount = displayAmount;
    }

    public BookingContractBooker supplierAmount(BigDecimal supplierAmount) {
        this.supplierAmount = supplierAmount;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @DecimalMin(value="0")
    @JsonProperty(value="supplierAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @DecimalMin(value="0") BigDecimal getSupplierAmount() {
        return this.supplierAmount;
    }

    @JsonProperty(value="supplierAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupplierAmount(BigDecimal supplierAmount) {
        this.supplierAmount = supplierAmount;
    }

    public BookingContractBooker internalAmount(BigDecimal internalAmount) {
        this.internalAmount = internalAmount;
        return this;
    }

    @Nullable
    @Valid
    @DecimalMin(value="0")
    @JsonProperty(value="internalAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Valid @DecimalMin(value="0") BigDecimal getInternalAmount() {
        return this.internalAmount;
    }

    @JsonProperty(value="internalAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInternalAmount(BigDecimal internalAmount) {
        this.internalAmount = internalAmount;
    }

    public BookingContractBooker captureAmount(BigDecimal captureAmount) {
        this.captureAmount = captureAmount;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @DecimalMin(value="0")
    @JsonProperty(value="captureAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @DecimalMin(value="0") BigDecimal getCaptureAmount() {
        return this.captureAmount;
    }

    @JsonProperty(value="captureAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCaptureAmount(BigDecimal captureAmount) {
        this.captureAmount = captureAmount;
    }

    public BookingContractBooker sourceAmountRefundModifier(BigDecimal sourceAmountRefundModifier) {
        this.sourceAmountRefundModifier = sourceAmountRefundModifier;
        return this;
    }

    @Nullable
    @Valid
    @DecimalMin(value="0")
    @JsonProperty(value="sourceAmountRefundModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Valid @DecimalMin(value="0") BigDecimal getSourceAmountRefundModifier() {
        return this.sourceAmountRefundModifier;
    }

    @JsonProperty(value="sourceAmountRefundModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourceAmountRefundModifier(BigDecimal sourceAmountRefundModifier) {
        this.sourceAmountRefundModifier = sourceAmountRefundModifier;
    }

    public BookingContractBooker displayAmountRefundModifier(BigDecimal displayAmountRefundModifier) {
        this.displayAmountRefundModifier = displayAmountRefundModifier;
        return this;
    }

    @Nullable
    @Valid
    @DecimalMin(value="0")
    @JsonProperty(value="displayAmountRefundModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Valid @DecimalMin(value="0") BigDecimal getDisplayAmountRefundModifier() {
        return this.displayAmountRefundModifier;
    }

    @JsonProperty(value="displayAmountRefundModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisplayAmountRefundModifier(BigDecimal displayAmountRefundModifier) {
        this.displayAmountRefundModifier = displayAmountRefundModifier;
    }

    public BookingContractBooker supplierAmountRefundModifier(BigDecimal supplierAmountRefundModifier) {
        this.supplierAmountRefundModifier = supplierAmountRefundModifier;
        return this;
    }

    @Nullable
    @Valid
    @DecimalMin(value="0")
    @JsonProperty(value="supplierAmountRefundModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Valid @DecimalMin(value="0") BigDecimal getSupplierAmountRefundModifier() {
        return this.supplierAmountRefundModifier;
    }

    @JsonProperty(value="supplierAmountRefundModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSupplierAmountRefundModifier(BigDecimal supplierAmountRefundModifier) {
        this.supplierAmountRefundModifier = supplierAmountRefundModifier;
    }

    public BookingContractBooker internalAmountRefundModifier(BigDecimal internalAmountRefundModifier) {
        this.internalAmountRefundModifier = internalAmountRefundModifier;
        return this;
    }

    @Nullable
    @Valid
    @DecimalMin(value="0")
    @JsonProperty(value="internalAmountRefundModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Valid @DecimalMin(value="0") BigDecimal getInternalAmountRefundModifier() {
        return this.internalAmountRefundModifier;
    }

    @JsonProperty(value="internalAmountRefundModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInternalAmountRefundModifier(BigDecimal internalAmountRefundModifier) {
        this.internalAmountRefundModifier = internalAmountRefundModifier;
    }

    public BookingContractBooker captureAmountRefundModifier(BigDecimal captureAmountRefundModifier) {
        this.captureAmountRefundModifier = captureAmountRefundModifier;
        return this;
    }

    @Nullable
    @Valid
    @DecimalMin(value="0")
    @JsonProperty(value="captureAmountRefundModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Valid @DecimalMin(value="0") BigDecimal getCaptureAmountRefundModifier() {
        return this.captureAmountRefundModifier;
    }

    @JsonProperty(value="captureAmountRefundModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCaptureAmountRefundModifier(BigDecimal captureAmountRefundModifier) {
        this.captureAmountRefundModifier = captureAmountRefundModifier;
    }

    public BookingContractBooker netSourceAmount(BigDecimal netSourceAmount) {
        this.netSourceAmount = netSourceAmount;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @DecimalMin(value="0")
    @JsonProperty(value="netSourceAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @DecimalMin(value="0") BigDecimal getNetSourceAmount() {
        return this.netSourceAmount;
    }

    @JsonProperty(value="netSourceAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setNetSourceAmount(BigDecimal netSourceAmount) {
        this.netSourceAmount = netSourceAmount;
    }

    public BookingContractBooker netDisplayAmount(BigDecimal netDisplayAmount) {
        this.netDisplayAmount = netDisplayAmount;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @DecimalMin(value="0")
    @JsonProperty(value="netDisplayAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @DecimalMin(value="0") BigDecimal getNetDisplayAmount() {
        return this.netDisplayAmount;
    }

    @JsonProperty(value="netDisplayAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setNetDisplayAmount(BigDecimal netDisplayAmount) {
        this.netDisplayAmount = netDisplayAmount;
    }

    public BookingContractBooker netSupplierAmount(BigDecimal netSupplierAmount) {
        this.netSupplierAmount = netSupplierAmount;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @DecimalMin(value="0")
    @JsonProperty(value="netSupplierAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @DecimalMin(value="0") BigDecimal getNetSupplierAmount() {
        return this.netSupplierAmount;
    }

    @JsonProperty(value="netSupplierAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setNetSupplierAmount(BigDecimal netSupplierAmount) {
        this.netSupplierAmount = netSupplierAmount;
    }

    public BookingContractBooker netInternalAmount(BigDecimal netInternalAmount) {
        this.netInternalAmount = netInternalAmount;
        return this;
    }

    @Nullable
    @Valid
    @DecimalMin(value="0")
    @JsonProperty(value="netInternalAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Valid @DecimalMin(value="0") BigDecimal getNetInternalAmount() {
        return this.netInternalAmount;
    }

    @JsonProperty(value="netInternalAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetInternalAmount(BigDecimal netInternalAmount) {
        this.netInternalAmount = netInternalAmount;
    }

    public BookingContractBooker netCaptureAmount(BigDecimal netCaptureAmount) {
        this.netCaptureAmount = netCaptureAmount;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @DecimalMin(value="0")
    @JsonProperty(value="netCaptureAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @DecimalMin(value="0") BigDecimal getNetCaptureAmount() {
        return this.netCaptureAmount;
    }

    @JsonProperty(value="netCaptureAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setNetCaptureAmount(BigDecimal netCaptureAmount) {
        this.netCaptureAmount = netCaptureAmount;
    }

    public BookingContractBooker totalTokensEarned(Long totalTokensEarned) {
        this.totalTokensEarned = totalTokensEarned;
        return this;
    }

    @Nullable
    @JsonProperty(value="totalTokensEarned")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getTotalTokensEarned() {
        return this.totalTokensEarned;
    }

    @JsonProperty(value="totalTokensEarned")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalTokensEarned(Long totalTokensEarned) {
        this.totalTokensEarned = totalTokensEarned;
    }

    public BookingContractBooker hasRefunds(Boolean hasRefunds) {
        this.hasRefunds = hasRefunds;
        return this;
    }

    @Nullable
    @JsonProperty(value="hasRefunds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHasRefunds() {
        return this.hasRefunds;
    }

    @JsonProperty(value="hasRefunds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHasRefunds(Boolean hasRefunds) {
        this.hasRefunds = hasRefunds;
    }

    public BookingContractBooker originalCommissionsInPercent(BigDecimal originalCommissionsInPercent) {
        this.originalCommissionsInPercent = originalCommissionsInPercent;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="originalCommissionsInPercent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigDecimal getOriginalCommissionsInPercent() {
        return this.originalCommissionsInPercent;
    }

    @JsonProperty(value="originalCommissionsInPercent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOriginalCommissionsInPercent(BigDecimal originalCommissionsInPercent) {
        this.originalCommissionsInPercent = originalCommissionsInPercent;
    }

    public BookingContractBooker originalFeesInPercent(BigDecimal originalFeesInPercent) {
        this.originalFeesInPercent = originalFeesInPercent;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="originalFeesInPercent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigDecimal getOriginalFeesInPercent() {
        return this.originalFeesInPercent;
    }

    @JsonProperty(value="originalFeesInPercent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOriginalFeesInPercent(BigDecimal originalFeesInPercent) {
        this.originalFeesInPercent = originalFeesInPercent;
    }

    public BookingContractBooker totalCommissionsInPercentWithRefund(Float totalCommissionsInPercentWithRefund) {
        this.totalCommissionsInPercentWithRefund = totalCommissionsInPercentWithRefund;
        return this;
    }

    @Nullable
    @JsonProperty(value="totalCommissionsInPercentWithRefund")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Float getTotalCommissionsInPercentWithRefund() {
        return this.totalCommissionsInPercentWithRefund;
    }

    @JsonProperty(value="totalCommissionsInPercentWithRefund")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalCommissionsInPercentWithRefund(Float totalCommissionsInPercentWithRefund) {
        this.totalCommissionsInPercentWithRefund = totalCommissionsInPercentWithRefund;
    }

    public BookingContractBooker totalFeesInPercentWithRefund(Float totalFeesInPercentWithRefund) {
        this.totalFeesInPercentWithRefund = totalFeesInPercentWithRefund;
        return this;
    }

    @Nullable
    @JsonProperty(value="totalFeesInPercentWithRefund")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Float getTotalFeesInPercentWithRefund() {
        return this.totalFeesInPercentWithRefund;
    }

    @JsonProperty(value="totalFeesInPercentWithRefund")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalFeesInPercentWithRefund(Float totalFeesInPercentWithRefund) {
        this.totalFeesInPercentWithRefund = totalFeesInPercentWithRefund;
    }

    public BookingContractBooker totalTripPayFeeInPercentWithRefund(Float totalTripPayFeeInPercentWithRefund) {
        this.totalTripPayFeeInPercentWithRefund = totalTripPayFeeInPercentWithRefund;
        return this;
    }

    @Nullable
    @JsonProperty(value="totalTripPayFeeInPercentWithRefund")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Float getTotalTripPayFeeInPercentWithRefund() {
        return this.totalTripPayFeeInPercentWithRefund;
    }

    @JsonProperty(value="totalTripPayFeeInPercentWithRefund")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalTripPayFeeInPercentWithRefund(Float totalTripPayFeeInPercentWithRefund) {
        this.totalTripPayFeeInPercentWithRefund = totalTripPayFeeInPercentWithRefund;
    }

    public BookingContractBooker lodging(BookingContractItemBooker lodging) {
        this.lodging = lodging;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="lodging")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BookingContractItemBooker getLodging() {
        return this.lodging;
    }

    @JsonProperty(value="lodging")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLodging(BookingContractItemBooker lodging) {
        this.lodging = lodging;
    }

    public BookingContractBooker totalTripPayFeeInPercent(Float totalTripPayFeeInPercent) {
        this.totalTripPayFeeInPercent = totalTripPayFeeInPercent;
        return this;
    }

    @Nullable
    @JsonProperty(value="totalTripPayFeeInPercent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Float getTotalTripPayFeeInPercent() {
        return this.totalTripPayFeeInPercent;
    }

    @JsonProperty(value="totalTripPayFeeInPercent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalTripPayFeeInPercent(Float totalTripPayFeeInPercent) {
        this.totalTripPayFeeInPercent = totalTripPayFeeInPercent;
    }

    public BookingContractBooker cancellableBySupplier(Boolean cancellableBySupplier) {
        this.cancellableBySupplier = cancellableBySupplier;
        return this;
    }

    @Nullable
    @JsonProperty(value="cancellableBySupplier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCancellableBySupplier() {
        return this.cancellableBySupplier;
    }

    @JsonProperty(value="cancellableBySupplier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellableBySupplier(Boolean cancellableBySupplier) {
        this.cancellableBySupplier = cancellableBySupplier;
    }

    public BookingContractBooker cancellableByTraveler(Boolean cancellableByTraveler) {
        this.cancellableByTraveler = cancellableByTraveler;
        return this;
    }

    @Nullable
    @JsonProperty(value="cancellableByTraveler")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCancellableByTraveler() {
        return this.cancellableByTraveler;
    }

    @JsonProperty(value="cancellableByTraveler")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellableByTraveler(Boolean cancellableByTraveler) {
        this.cancellableByTraveler = cancellableByTraveler;
    }

    public BookingContractBooker cancellableWithNoCharges(Boolean cancellableWithNoCharges) {
        this.cancellableWithNoCharges = cancellableWithNoCharges;
        return this;
    }

    @Nullable
    @JsonProperty(value="cancellableWithNoCharges")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCancellableWithNoCharges() {
        return this.cancellableWithNoCharges;
    }

    @JsonProperty(value="cancellableWithNoCharges")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellableWithNoCharges(Boolean cancellableWithNoCharges) {
        this.cancellableWithNoCharges = cancellableWithNoCharges;
    }

    public BookingContractBooker isCancellableWithPotentialCharges(Boolean isCancellableWithPotentialCharges) {
        this.isCancellableWithPotentialCharges = isCancellableWithPotentialCharges;
        return this;
    }

    @Nullable
    @JsonProperty(value="isCancellableWithPotentialCharges")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsCancellableWithPotentialCharges() {
        return this.isCancellableWithPotentialCharges;
    }

    @JsonProperty(value="isCancellableWithPotentialCharges")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIsCancellableWithPotentialCharges(Boolean isCancellableWithPotentialCharges) {
        this.isCancellableWithPotentialCharges = isCancellableWithPotentialCharges;
    }

    public BookingContractBooker netCommissionableTotalSourceAmount(CustomMonetaryAmount netCommissionableTotalSourceAmount) {
        this.netCommissionableTotalSourceAmount = netCommissionableTotalSourceAmount;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="netCommissionableTotalSourceAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomMonetaryAmount getNetCommissionableTotalSourceAmount() {
        return this.netCommissionableTotalSourceAmount;
    }

    @JsonProperty(value="netCommissionableTotalSourceAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetCommissionableTotalSourceAmount(CustomMonetaryAmount netCommissionableTotalSourceAmount) {
        this.netCommissionableTotalSourceAmount = netCommissionableTotalSourceAmount;
    }

    public BookingContractBooker netCommissionableTotalCaptureAmount(CustomMonetaryAmount netCommissionableTotalCaptureAmount) {
        this.netCommissionableTotalCaptureAmount = netCommissionableTotalCaptureAmount;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="netCommissionableTotalCaptureAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomMonetaryAmount getNetCommissionableTotalCaptureAmount() {
        return this.netCommissionableTotalCaptureAmount;
    }

    @JsonProperty(value="netCommissionableTotalCaptureAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetCommissionableTotalCaptureAmount(CustomMonetaryAmount netCommissionableTotalCaptureAmount) {
        this.netCommissionableTotalCaptureAmount = netCommissionableTotalCaptureAmount;
    }

    public BookingContractBooker netCommissionableTotalDisplayAmount(CustomMonetaryAmount netCommissionableTotalDisplayAmount) {
        this.netCommissionableTotalDisplayAmount = netCommissionableTotalDisplayAmount;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="netCommissionableTotalDisplayAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomMonetaryAmount getNetCommissionableTotalDisplayAmount() {
        return this.netCommissionableTotalDisplayAmount;
    }

    @JsonProperty(value="netCommissionableTotalDisplayAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetCommissionableTotalDisplayAmount(CustomMonetaryAmount netCommissionableTotalDisplayAmount) {
        this.netCommissionableTotalDisplayAmount = netCommissionableTotalDisplayAmount;
    }

    public BookingContractBooker netCommissionableTotalInternalAmount(CustomMonetaryAmount netCommissionableTotalInternalAmount) {
        this.netCommissionableTotalInternalAmount = netCommissionableTotalInternalAmount;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="netCommissionableTotalInternalAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomMonetaryAmount getNetCommissionableTotalInternalAmount() {
        return this.netCommissionableTotalInternalAmount;
    }

    @JsonProperty(value="netCommissionableTotalInternalAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetCommissionableTotalInternalAmount(CustomMonetaryAmount netCommissionableTotalInternalAmount) {
        this.netCommissionableTotalInternalAmount = netCommissionableTotalInternalAmount;
    }

    public BookingContractBooker netTotalFeesAndCommissionsSourceAmount(CustomMonetaryAmount netTotalFeesAndCommissionsSourceAmount) {
        this.netTotalFeesAndCommissionsSourceAmount = netTotalFeesAndCommissionsSourceAmount;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="netTotalFeesAndCommissionsSourceAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomMonetaryAmount getNetTotalFeesAndCommissionsSourceAmount() {
        return this.netTotalFeesAndCommissionsSourceAmount;
    }

    @JsonProperty(value="netTotalFeesAndCommissionsSourceAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetTotalFeesAndCommissionsSourceAmount(CustomMonetaryAmount netTotalFeesAndCommissionsSourceAmount) {
        this.netTotalFeesAndCommissionsSourceAmount = netTotalFeesAndCommissionsSourceAmount;
    }

    public BookingContractBooker netTotalFeesAndCommissionsCaptureAmount(CustomMonetaryAmount netTotalFeesAndCommissionsCaptureAmount) {
        this.netTotalFeesAndCommissionsCaptureAmount = netTotalFeesAndCommissionsCaptureAmount;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="netTotalFeesAndCommissionsCaptureAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomMonetaryAmount getNetTotalFeesAndCommissionsCaptureAmount() {
        return this.netTotalFeesAndCommissionsCaptureAmount;
    }

    @JsonProperty(value="netTotalFeesAndCommissionsCaptureAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetTotalFeesAndCommissionsCaptureAmount(CustomMonetaryAmount netTotalFeesAndCommissionsCaptureAmount) {
        this.netTotalFeesAndCommissionsCaptureAmount = netTotalFeesAndCommissionsCaptureAmount;
    }

    public BookingContractBooker netTotalFeesAndCommissionsDisplayAmount(CustomMonetaryAmount netTotalFeesAndCommissionsDisplayAmount) {
        this.netTotalFeesAndCommissionsDisplayAmount = netTotalFeesAndCommissionsDisplayAmount;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="netTotalFeesAndCommissionsDisplayAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomMonetaryAmount getNetTotalFeesAndCommissionsDisplayAmount() {
        return this.netTotalFeesAndCommissionsDisplayAmount;
    }

    @JsonProperty(value="netTotalFeesAndCommissionsDisplayAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetTotalFeesAndCommissionsDisplayAmount(CustomMonetaryAmount netTotalFeesAndCommissionsDisplayAmount) {
        this.netTotalFeesAndCommissionsDisplayAmount = netTotalFeesAndCommissionsDisplayAmount;
    }

    public BookingContractBooker netTotalFeesAndCommissionsInternalAmount(CustomMonetaryAmount netTotalFeesAndCommissionsInternalAmount) {
        this.netTotalFeesAndCommissionsInternalAmount = netTotalFeesAndCommissionsInternalAmount;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="netTotalFeesAndCommissionsInternalAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomMonetaryAmount getNetTotalFeesAndCommissionsInternalAmount() {
        return this.netTotalFeesAndCommissionsInternalAmount;
    }

    @JsonProperty(value="netTotalFeesAndCommissionsInternalAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetTotalFeesAndCommissionsInternalAmount(CustomMonetaryAmount netTotalFeesAndCommissionsInternalAmount) {
        this.netTotalFeesAndCommissionsInternalAmount = netTotalFeesAndCommissionsInternalAmount;
    }

    public BookingContractBooker netTotalFeesSourceAmount(CustomMonetaryAmount netTotalFeesSourceAmount) {
        this.netTotalFeesSourceAmount = netTotalFeesSourceAmount;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="netTotalFeesSourceAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomMonetaryAmount getNetTotalFeesSourceAmount() {
        return this.netTotalFeesSourceAmount;
    }

    @JsonProperty(value="netTotalFeesSourceAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetTotalFeesSourceAmount(CustomMonetaryAmount netTotalFeesSourceAmount) {
        this.netTotalFeesSourceAmount = netTotalFeesSourceAmount;
    }

    public BookingContractBooker netTotalFeesCaptureAmount(CustomMonetaryAmount netTotalFeesCaptureAmount) {
        this.netTotalFeesCaptureAmount = netTotalFeesCaptureAmount;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="netTotalFeesCaptureAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomMonetaryAmount getNetTotalFeesCaptureAmount() {
        return this.netTotalFeesCaptureAmount;
    }

    @JsonProperty(value="netTotalFeesCaptureAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetTotalFeesCaptureAmount(CustomMonetaryAmount netTotalFeesCaptureAmount) {
        this.netTotalFeesCaptureAmount = netTotalFeesCaptureAmount;
    }

    public BookingContractBooker netTotalFeesDisplayAmount(CustomMonetaryAmount netTotalFeesDisplayAmount) {
        this.netTotalFeesDisplayAmount = netTotalFeesDisplayAmount;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="netTotalFeesDisplayAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomMonetaryAmount getNetTotalFeesDisplayAmount() {
        return this.netTotalFeesDisplayAmount;
    }

    @JsonProperty(value="netTotalFeesDisplayAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetTotalFeesDisplayAmount(CustomMonetaryAmount netTotalFeesDisplayAmount) {
        this.netTotalFeesDisplayAmount = netTotalFeesDisplayAmount;
    }

    public BookingContractBooker netTotalFeesInternalAmount(CustomMonetaryAmount netTotalFeesInternalAmount) {
        this.netTotalFeesInternalAmount = netTotalFeesInternalAmount;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="netTotalFeesInternalAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomMonetaryAmount getNetTotalFeesInternalAmount() {
        return this.netTotalFeesInternalAmount;
    }

    @JsonProperty(value="netTotalFeesInternalAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetTotalFeesInternalAmount(CustomMonetaryAmount netTotalFeesInternalAmount) {
        this.netTotalFeesInternalAmount = netTotalFeesInternalAmount;
    }

    public BookingContractBooker netTotalTripPayFeeSourceAmount(CustomMonetaryAmount netTotalTripPayFeeSourceAmount) {
        this.netTotalTripPayFeeSourceAmount = netTotalTripPayFeeSourceAmount;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="netTotalTripPayFeeSourceAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomMonetaryAmount getNetTotalTripPayFeeSourceAmount() {
        return this.netTotalTripPayFeeSourceAmount;
    }

    @JsonProperty(value="netTotalTripPayFeeSourceAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetTotalTripPayFeeSourceAmount(CustomMonetaryAmount netTotalTripPayFeeSourceAmount) {
        this.netTotalTripPayFeeSourceAmount = netTotalTripPayFeeSourceAmount;
    }

    public BookingContractBooker netTotalTripPayFeeCaptureAmount(CustomMonetaryAmount netTotalTripPayFeeCaptureAmount) {
        this.netTotalTripPayFeeCaptureAmount = netTotalTripPayFeeCaptureAmount;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="netTotalTripPayFeeCaptureAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomMonetaryAmount getNetTotalTripPayFeeCaptureAmount() {
        return this.netTotalTripPayFeeCaptureAmount;
    }

    @JsonProperty(value="netTotalTripPayFeeCaptureAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetTotalTripPayFeeCaptureAmount(CustomMonetaryAmount netTotalTripPayFeeCaptureAmount) {
        this.netTotalTripPayFeeCaptureAmount = netTotalTripPayFeeCaptureAmount;
    }

    public BookingContractBooker netTotalTripPayFeeDisplayAmount(CustomMonetaryAmount netTotalTripPayFeeDisplayAmount) {
        this.netTotalTripPayFeeDisplayAmount = netTotalTripPayFeeDisplayAmount;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="netTotalTripPayFeeDisplayAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomMonetaryAmount getNetTotalTripPayFeeDisplayAmount() {
        return this.netTotalTripPayFeeDisplayAmount;
    }

    @JsonProperty(value="netTotalTripPayFeeDisplayAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetTotalTripPayFeeDisplayAmount(CustomMonetaryAmount netTotalTripPayFeeDisplayAmount) {
        this.netTotalTripPayFeeDisplayAmount = netTotalTripPayFeeDisplayAmount;
    }

    public BookingContractBooker netTotalTripPayFeeInternalAmount(CustomMonetaryAmount netTotalTripPayFeeInternalAmount) {
        this.netTotalTripPayFeeInternalAmount = netTotalTripPayFeeInternalAmount;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="netTotalTripPayFeeInternalAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomMonetaryAmount getNetTotalTripPayFeeInternalAmount() {
        return this.netTotalTripPayFeeInternalAmount;
    }

    @JsonProperty(value="netTotalTripPayFeeInternalAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetTotalTripPayFeeInternalAmount(CustomMonetaryAmount netTotalTripPayFeeInternalAmount) {
        this.netTotalTripPayFeeInternalAmount = netTotalTripPayFeeInternalAmount;
    }

    public BookingContractBooker netTotalSalesSourceAmount(CustomMonetaryAmount netTotalSalesSourceAmount) {
        this.netTotalSalesSourceAmount = netTotalSalesSourceAmount;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="netTotalSalesSourceAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomMonetaryAmount getNetTotalSalesSourceAmount() {
        return this.netTotalSalesSourceAmount;
    }

    @JsonProperty(value="netTotalSalesSourceAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetTotalSalesSourceAmount(CustomMonetaryAmount netTotalSalesSourceAmount) {
        this.netTotalSalesSourceAmount = netTotalSalesSourceAmount;
    }

    public BookingContractBooker netTotalSalesCaptureAmount(CustomMonetaryAmount netTotalSalesCaptureAmount) {
        this.netTotalSalesCaptureAmount = netTotalSalesCaptureAmount;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="netTotalSalesCaptureAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomMonetaryAmount getNetTotalSalesCaptureAmount() {
        return this.netTotalSalesCaptureAmount;
    }

    @JsonProperty(value="netTotalSalesCaptureAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetTotalSalesCaptureAmount(CustomMonetaryAmount netTotalSalesCaptureAmount) {
        this.netTotalSalesCaptureAmount = netTotalSalesCaptureAmount;
    }

    public BookingContractBooker netTotalSalesDisplayAmount(CustomMonetaryAmount netTotalSalesDisplayAmount) {
        this.netTotalSalesDisplayAmount = netTotalSalesDisplayAmount;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="netTotalSalesDisplayAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomMonetaryAmount getNetTotalSalesDisplayAmount() {
        return this.netTotalSalesDisplayAmount;
    }

    @JsonProperty(value="netTotalSalesDisplayAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetTotalSalesDisplayAmount(CustomMonetaryAmount netTotalSalesDisplayAmount) {
        this.netTotalSalesDisplayAmount = netTotalSalesDisplayAmount;
    }

    public BookingContractBooker netTotalSalesSupplierAmount(CustomMonetaryAmount netTotalSalesSupplierAmount) {
        this.netTotalSalesSupplierAmount = netTotalSalesSupplierAmount;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="netTotalSalesSupplierAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomMonetaryAmount getNetTotalSalesSupplierAmount() {
        return this.netTotalSalesSupplierAmount;
    }

    @JsonProperty(value="netTotalSalesSupplierAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetTotalSalesSupplierAmount(CustomMonetaryAmount netTotalSalesSupplierAmount) {
        this.netTotalSalesSupplierAmount = netTotalSalesSupplierAmount;
    }

    public BookingContractBooker netTotalSalesInternalAmount(CustomMonetaryAmount netTotalSalesInternalAmount) {
        this.netTotalSalesInternalAmount = netTotalSalesInternalAmount;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="netTotalSalesInternalAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomMonetaryAmount getNetTotalSalesInternalAmount() {
        return this.netTotalSalesInternalAmount;
    }

    @JsonProperty(value="netTotalSalesInternalAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetTotalSalesInternalAmount(CustomMonetaryAmount netTotalSalesInternalAmount) {
        this.netTotalSalesInternalAmount = netTotalSalesInternalAmount;
    }

    public BookingContractBooker commissionableTotalSourceAmount(CustomMonetaryAmount commissionableTotalSourceAmount) {
        this.commissionableTotalSourceAmount = commissionableTotalSourceAmount;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="commissionableTotalSourceAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomMonetaryAmount getCommissionableTotalSourceAmount() {
        return this.commissionableTotalSourceAmount;
    }

    @JsonProperty(value="commissionableTotalSourceAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCommissionableTotalSourceAmount(CustomMonetaryAmount commissionableTotalSourceAmount) {
        this.commissionableTotalSourceAmount = commissionableTotalSourceAmount;
    }

    public BookingContractBooker commissionableTotalCaptureAmount(CustomMonetaryAmount commissionableTotalCaptureAmount) {
        this.commissionableTotalCaptureAmount = commissionableTotalCaptureAmount;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="commissionableTotalCaptureAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomMonetaryAmount getCommissionableTotalCaptureAmount() {
        return this.commissionableTotalCaptureAmount;
    }

    @JsonProperty(value="commissionableTotalCaptureAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCommissionableTotalCaptureAmount(CustomMonetaryAmount commissionableTotalCaptureAmount) {
        this.commissionableTotalCaptureAmount = commissionableTotalCaptureAmount;
    }

    public BookingContractBooker commissionableTotalDisplayAmount(CustomMonetaryAmount commissionableTotalDisplayAmount) {
        this.commissionableTotalDisplayAmount = commissionableTotalDisplayAmount;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="commissionableTotalDisplayAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomMonetaryAmount getCommissionableTotalDisplayAmount() {
        return this.commissionableTotalDisplayAmount;
    }

    @JsonProperty(value="commissionableTotalDisplayAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCommissionableTotalDisplayAmount(CustomMonetaryAmount commissionableTotalDisplayAmount) {
        this.commissionableTotalDisplayAmount = commissionableTotalDisplayAmount;
    }

    public BookingContractBooker commissionableTotalInternalAmount(CustomMonetaryAmount commissionableTotalInternalAmount) {
        this.commissionableTotalInternalAmount = commissionableTotalInternalAmount;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="commissionableTotalInternalAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomMonetaryAmount getCommissionableTotalInternalAmount() {
        return this.commissionableTotalInternalAmount;
    }

    @JsonProperty(value="commissionableTotalInternalAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCommissionableTotalInternalAmount(CustomMonetaryAmount commissionableTotalInternalAmount) {
        this.commissionableTotalInternalAmount = commissionableTotalInternalAmount;
    }

    public BookingContractBooker totalFeesAndCommissionsSourceAmount(CustomMonetaryAmount totalFeesAndCommissionsSourceAmount) {
        this.totalFeesAndCommissionsSourceAmount = totalFeesAndCommissionsSourceAmount;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="totalFeesAndCommissionsSourceAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomMonetaryAmount getTotalFeesAndCommissionsSourceAmount() {
        return this.totalFeesAndCommissionsSourceAmount;
    }

    @JsonProperty(value="totalFeesAndCommissionsSourceAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalFeesAndCommissionsSourceAmount(CustomMonetaryAmount totalFeesAndCommissionsSourceAmount) {
        this.totalFeesAndCommissionsSourceAmount = totalFeesAndCommissionsSourceAmount;
    }

    public BookingContractBooker totalFeesAndCommissionsCaptureAmount(CustomMonetaryAmount totalFeesAndCommissionsCaptureAmount) {
        this.totalFeesAndCommissionsCaptureAmount = totalFeesAndCommissionsCaptureAmount;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="totalFeesAndCommissionsCaptureAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomMonetaryAmount getTotalFeesAndCommissionsCaptureAmount() {
        return this.totalFeesAndCommissionsCaptureAmount;
    }

    @JsonProperty(value="totalFeesAndCommissionsCaptureAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalFeesAndCommissionsCaptureAmount(CustomMonetaryAmount totalFeesAndCommissionsCaptureAmount) {
        this.totalFeesAndCommissionsCaptureAmount = totalFeesAndCommissionsCaptureAmount;
    }

    public BookingContractBooker totalFeesAndCommissionsDisplayAmount(CustomMonetaryAmount totalFeesAndCommissionsDisplayAmount) {
        this.totalFeesAndCommissionsDisplayAmount = totalFeesAndCommissionsDisplayAmount;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="totalFeesAndCommissionsDisplayAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomMonetaryAmount getTotalFeesAndCommissionsDisplayAmount() {
        return this.totalFeesAndCommissionsDisplayAmount;
    }

    @JsonProperty(value="totalFeesAndCommissionsDisplayAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalFeesAndCommissionsDisplayAmount(CustomMonetaryAmount totalFeesAndCommissionsDisplayAmount) {
        this.totalFeesAndCommissionsDisplayAmount = totalFeesAndCommissionsDisplayAmount;
    }

    public BookingContractBooker totalFeesAndCommissionsInternalAmount(CustomMonetaryAmount totalFeesAndCommissionsInternalAmount) {
        this.totalFeesAndCommissionsInternalAmount = totalFeesAndCommissionsInternalAmount;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="totalFeesAndCommissionsInternalAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomMonetaryAmount getTotalFeesAndCommissionsInternalAmount() {
        return this.totalFeesAndCommissionsInternalAmount;
    }

    @JsonProperty(value="totalFeesAndCommissionsInternalAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalFeesAndCommissionsInternalAmount(CustomMonetaryAmount totalFeesAndCommissionsInternalAmount) {
        this.totalFeesAndCommissionsInternalAmount = totalFeesAndCommissionsInternalAmount;
    }

    public BookingContractBooker totalFeesSourceAmount(CustomMonetaryAmount totalFeesSourceAmount) {
        this.totalFeesSourceAmount = totalFeesSourceAmount;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="totalFeesSourceAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomMonetaryAmount getTotalFeesSourceAmount() {
        return this.totalFeesSourceAmount;
    }

    @JsonProperty(value="totalFeesSourceAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalFeesSourceAmount(CustomMonetaryAmount totalFeesSourceAmount) {
        this.totalFeesSourceAmount = totalFeesSourceAmount;
    }

    public BookingContractBooker totalFeesCaptureAmount(CustomMonetaryAmount totalFeesCaptureAmount) {
        this.totalFeesCaptureAmount = totalFeesCaptureAmount;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="totalFeesCaptureAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomMonetaryAmount getTotalFeesCaptureAmount() {
        return this.totalFeesCaptureAmount;
    }

    @JsonProperty(value="totalFeesCaptureAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalFeesCaptureAmount(CustomMonetaryAmount totalFeesCaptureAmount) {
        this.totalFeesCaptureAmount = totalFeesCaptureAmount;
    }

    public BookingContractBooker totalFeesDisplayAmount(CustomMonetaryAmount totalFeesDisplayAmount) {
        this.totalFeesDisplayAmount = totalFeesDisplayAmount;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="totalFeesDisplayAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomMonetaryAmount getTotalFeesDisplayAmount() {
        return this.totalFeesDisplayAmount;
    }

    @JsonProperty(value="totalFeesDisplayAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalFeesDisplayAmount(CustomMonetaryAmount totalFeesDisplayAmount) {
        this.totalFeesDisplayAmount = totalFeesDisplayAmount;
    }

    public BookingContractBooker totalFeesInternalAmount(CustomMonetaryAmount totalFeesInternalAmount) {
        this.totalFeesInternalAmount = totalFeesInternalAmount;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="totalFeesInternalAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomMonetaryAmount getTotalFeesInternalAmount() {
        return this.totalFeesInternalAmount;
    }

    @JsonProperty(value="totalFeesInternalAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalFeesInternalAmount(CustomMonetaryAmount totalFeesInternalAmount) {
        this.totalFeesInternalAmount = totalFeesInternalAmount;
    }

    public BookingContractBooker totalTripPayFeeSourceAmount(CustomMonetaryAmount totalTripPayFeeSourceAmount) {
        this.totalTripPayFeeSourceAmount = totalTripPayFeeSourceAmount;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="totalTripPayFeeSourceAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomMonetaryAmount getTotalTripPayFeeSourceAmount() {
        return this.totalTripPayFeeSourceAmount;
    }

    @JsonProperty(value="totalTripPayFeeSourceAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalTripPayFeeSourceAmount(CustomMonetaryAmount totalTripPayFeeSourceAmount) {
        this.totalTripPayFeeSourceAmount = totalTripPayFeeSourceAmount;
    }

    public BookingContractBooker totalTripPayFeeCaptureAmount(CustomMonetaryAmount totalTripPayFeeCaptureAmount) {
        this.totalTripPayFeeCaptureAmount = totalTripPayFeeCaptureAmount;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="totalTripPayFeeCaptureAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomMonetaryAmount getTotalTripPayFeeCaptureAmount() {
        return this.totalTripPayFeeCaptureAmount;
    }

    @JsonProperty(value="totalTripPayFeeCaptureAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalTripPayFeeCaptureAmount(CustomMonetaryAmount totalTripPayFeeCaptureAmount) {
        this.totalTripPayFeeCaptureAmount = totalTripPayFeeCaptureAmount;
    }

    public BookingContractBooker totalTripPayFeeDisplayAmount(CustomMonetaryAmount totalTripPayFeeDisplayAmount) {
        this.totalTripPayFeeDisplayAmount = totalTripPayFeeDisplayAmount;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="totalTripPayFeeDisplayAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomMonetaryAmount getTotalTripPayFeeDisplayAmount() {
        return this.totalTripPayFeeDisplayAmount;
    }

    @JsonProperty(value="totalTripPayFeeDisplayAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalTripPayFeeDisplayAmount(CustomMonetaryAmount totalTripPayFeeDisplayAmount) {
        this.totalTripPayFeeDisplayAmount = totalTripPayFeeDisplayAmount;
    }

    public BookingContractBooker totalTripPayFeeInternalAmount(CustomMonetaryAmount totalTripPayFeeInternalAmount) {
        this.totalTripPayFeeInternalAmount = totalTripPayFeeInternalAmount;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="totalTripPayFeeInternalAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomMonetaryAmount getTotalTripPayFeeInternalAmount() {
        return this.totalTripPayFeeInternalAmount;
    }

    @JsonProperty(value="totalTripPayFeeInternalAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalTripPayFeeInternalAmount(CustomMonetaryAmount totalTripPayFeeInternalAmount) {
        this.totalTripPayFeeInternalAmount = totalTripPayFeeInternalAmount;
    }

    public BookingContractBooker totalSalesSourceAmount(CustomMonetaryAmount totalSalesSourceAmount) {
        this.totalSalesSourceAmount = totalSalesSourceAmount;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="totalSalesSourceAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomMonetaryAmount getTotalSalesSourceAmount() {
        return this.totalSalesSourceAmount;
    }

    @JsonProperty(value="totalSalesSourceAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalSalesSourceAmount(CustomMonetaryAmount totalSalesSourceAmount) {
        this.totalSalesSourceAmount = totalSalesSourceAmount;
    }

    public BookingContractBooker totalSalesCaptureAmount(CustomMonetaryAmount totalSalesCaptureAmount) {
        this.totalSalesCaptureAmount = totalSalesCaptureAmount;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="totalSalesCaptureAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomMonetaryAmount getTotalSalesCaptureAmount() {
        return this.totalSalesCaptureAmount;
    }

    @JsonProperty(value="totalSalesCaptureAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalSalesCaptureAmount(CustomMonetaryAmount totalSalesCaptureAmount) {
        this.totalSalesCaptureAmount = totalSalesCaptureAmount;
    }

    public BookingContractBooker totalSalesDisplayAmount(CustomMonetaryAmount totalSalesDisplayAmount) {
        this.totalSalesDisplayAmount = totalSalesDisplayAmount;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="totalSalesDisplayAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomMonetaryAmount getTotalSalesDisplayAmount() {
        return this.totalSalesDisplayAmount;
    }

    @JsonProperty(value="totalSalesDisplayAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalSalesDisplayAmount(CustomMonetaryAmount totalSalesDisplayAmount) {
        this.totalSalesDisplayAmount = totalSalesDisplayAmount;
    }

    public BookingContractBooker totalSalesSupplierAmount(CustomMonetaryAmount totalSalesSupplierAmount) {
        this.totalSalesSupplierAmount = totalSalesSupplierAmount;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="totalSalesSupplierAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomMonetaryAmount getTotalSalesSupplierAmount() {
        return this.totalSalesSupplierAmount;
    }

    @JsonProperty(value="totalSalesSupplierAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalSalesSupplierAmount(CustomMonetaryAmount totalSalesSupplierAmount) {
        this.totalSalesSupplierAmount = totalSalesSupplierAmount;
    }

    public BookingContractBooker totalSalesInternalAmount(CustomMonetaryAmount totalSalesInternalAmount) {
        this.totalSalesInternalAmount = totalSalesInternalAmount;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="totalSalesInternalAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomMonetaryAmount getTotalSalesInternalAmount() {
        return this.totalSalesInternalAmount;
    }

    @JsonProperty(value="totalSalesInternalAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalSalesInternalAmount(CustomMonetaryAmount totalSalesInternalAmount) {
        this.totalSalesInternalAmount = totalSalesInternalAmount;
    }

    public BookingContractBooker fundsAvailableDate(LocalDate fundsAvailableDate) {
        this.fundsAvailableDate = fundsAvailableDate;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="fundsAvailableDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getFundsAvailableDate() {
        return this.fundsAvailableDate;
    }

    @JsonProperty(value="fundsAvailableDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFundsAvailableDate(LocalDate fundsAvailableDate) {
        this.fundsAvailableDate = fundsAvailableDate;
    }

    public BookingContractBooker totalFeesInPercent(Float totalFeesInPercent) {
        this.totalFeesInPercent = totalFeesInPercent;
        return this;
    }

    @Nullable
    @JsonProperty(value="totalFeesInPercent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Float getTotalFeesInPercent() {
        return this.totalFeesInPercent;
    }

    @JsonProperty(value="totalFeesInPercent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalFeesInPercent(Float totalFeesInPercent) {
        this.totalFeesInPercent = totalFeesInPercent;
    }

    public BookingContractBooker totalCommissionsInPercent(Float totalCommissionsInPercent) {
        this.totalCommissionsInPercent = totalCommissionsInPercent;
        return this;
    }

    @Nullable
    @JsonProperty(value="totalCommissionsInPercent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Float getTotalCommissionsInPercent() {
        return this.totalCommissionsInPercent;
    }

    @JsonProperty(value="totalCommissionsInPercent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalCommissionsInPercent(Float totalCommissionsInPercent) {
        this.totalCommissionsInPercent = totalCommissionsInPercent;
    }

    public BookingContractBooker totalFeesAndCommissionsInPercentWithRefund(Float totalFeesAndCommissionsInPercentWithRefund) {
        this.totalFeesAndCommissionsInPercentWithRefund = totalFeesAndCommissionsInPercentWithRefund;
        return this;
    }

    @Nullable
    @JsonProperty(value="totalFeesAndCommissionsInPercentWithRefund")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Float getTotalFeesAndCommissionsInPercentWithRefund() {
        return this.totalFeesAndCommissionsInPercentWithRefund;
    }

    @JsonProperty(value="totalFeesAndCommissionsInPercentWithRefund")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalFeesAndCommissionsInPercentWithRefund(Float totalFeesAndCommissionsInPercentWithRefund) {
        this.totalFeesAndCommissionsInPercentWithRefund = totalFeesAndCommissionsInPercentWithRefund;
    }

    public BookingContractBooker totalFeesAndCommissionsInPercent(Float totalFeesAndCommissionsInPercent) {
        this.totalFeesAndCommissionsInPercent = totalFeesAndCommissionsInPercent;
        return this;
    }

    @Nullable
    @JsonProperty(value="totalFeesAndCommissionsInPercent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Float getTotalFeesAndCommissionsInPercent() {
        return this.totalFeesAndCommissionsInPercent;
    }

    @JsonProperty(value="totalFeesAndCommissionsInPercent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalFeesAndCommissionsInPercent(Float totalFeesAndCommissionsInPercent) {
        this.totalFeesAndCommissionsInPercent = totalFeesAndCommissionsInPercent;
    }

    public BookingContractBooker hasSuccessfulRefunds(Boolean hasSuccessfulRefunds) {
        this.hasSuccessfulRefunds = hasSuccessfulRefunds;
        return this;
    }

    @Nullable
    @JsonProperty(value="hasSuccessfulRefunds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHasSuccessfulRefunds() {
        return this.hasSuccessfulRefunds;
    }

    @JsonProperty(value="hasSuccessfulRefunds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHasSuccessfulRefunds(Boolean hasSuccessfulRefunds) {
        this.hasSuccessfulRefunds = hasSuccessfulRefunds;
    }

    public BookingContractBooker hasPendingRefunds(Boolean hasPendingRefunds) {
        this.hasPendingRefunds = hasPendingRefunds;
        return this;
    }

    @Nullable
    @JsonProperty(value="hasPendingRefunds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHasPendingRefunds() {
        return this.hasPendingRefunds;
    }

    @JsonProperty(value="hasPendingRefunds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHasPendingRefunds(Boolean hasPendingRefunds) {
        this.hasPendingRefunds = hasPendingRefunds;
    }

    public BookingContractBooker hasFailedRefunds(Boolean hasFailedRefunds) {
        this.hasFailedRefunds = hasFailedRefunds;
        return this;
    }

    @Nullable
    @JsonProperty(value="hasFailedRefunds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHasFailedRefunds() {
        return this.hasFailedRefunds;
    }

    @JsonProperty(value="hasFailedRefunds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHasFailedRefunds(Boolean hasFailedRefunds) {
        this.hasFailedRefunds = hasFailedRefunds;
    }

    public BookingContractBooker netTotalFeesAndCommissionsSupplierAmount(CustomMonetaryAmount netTotalFeesAndCommissionsSupplierAmount) {
        this.netTotalFeesAndCommissionsSupplierAmount = netTotalFeesAndCommissionsSupplierAmount;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="netTotalFeesAndCommissionsSupplierAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomMonetaryAmount getNetTotalFeesAndCommissionsSupplierAmount() {
        return this.netTotalFeesAndCommissionsSupplierAmount;
    }

    @JsonProperty(value="netTotalFeesAndCommissionsSupplierAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetTotalFeesAndCommissionsSupplierAmount(CustomMonetaryAmount netTotalFeesAndCommissionsSupplierAmount) {
        this.netTotalFeesAndCommissionsSupplierAmount = netTotalFeesAndCommissionsSupplierAmount;
    }

    public BookingContractBooker totalFeesSupplierAmount(CustomMonetaryAmount totalFeesSupplierAmount) {
        this.totalFeesSupplierAmount = totalFeesSupplierAmount;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="totalFeesSupplierAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomMonetaryAmount getTotalFeesSupplierAmount() {
        return this.totalFeesSupplierAmount;
    }

    @JsonProperty(value="totalFeesSupplierAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalFeesSupplierAmount(CustomMonetaryAmount totalFeesSupplierAmount) {
        this.totalFeesSupplierAmount = totalFeesSupplierAmount;
    }

    public BookingContractBooker netTotalTripPayFeeSupplierAmount(CustomMonetaryAmount netTotalTripPayFeeSupplierAmount) {
        this.netTotalTripPayFeeSupplierAmount = netTotalTripPayFeeSupplierAmount;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="netTotalTripPayFeeSupplierAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomMonetaryAmount getNetTotalTripPayFeeSupplierAmount() {
        return this.netTotalTripPayFeeSupplierAmount;
    }

    @JsonProperty(value="netTotalTripPayFeeSupplierAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetTotalTripPayFeeSupplierAmount(CustomMonetaryAmount netTotalTripPayFeeSupplierAmount) {
        this.netTotalTripPayFeeSupplierAmount = netTotalTripPayFeeSupplierAmount;
    }

    public BookingContractBooker totalTripPayFeeSupplierAmount(CustomMonetaryAmount totalTripPayFeeSupplierAmount) {
        this.totalTripPayFeeSupplierAmount = totalTripPayFeeSupplierAmount;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="totalTripPayFeeSupplierAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomMonetaryAmount getTotalTripPayFeeSupplierAmount() {
        return this.totalTripPayFeeSupplierAmount;
    }

    @JsonProperty(value="totalTripPayFeeSupplierAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalTripPayFeeSupplierAmount(CustomMonetaryAmount totalTripPayFeeSupplierAmount) {
        this.totalTripPayFeeSupplierAmount = totalTripPayFeeSupplierAmount;
    }

    public BookingContractBooker netCommissionableTotalSupplierAmount(CustomMonetaryAmount netCommissionableTotalSupplierAmount) {
        this.netCommissionableTotalSupplierAmount = netCommissionableTotalSupplierAmount;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="netCommissionableTotalSupplierAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomMonetaryAmount getNetCommissionableTotalSupplierAmount() {
        return this.netCommissionableTotalSupplierAmount;
    }

    @JsonProperty(value="netCommissionableTotalSupplierAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetCommissionableTotalSupplierAmount(CustomMonetaryAmount netCommissionableTotalSupplierAmount) {
        this.netCommissionableTotalSupplierAmount = netCommissionableTotalSupplierAmount;
    }

    public BookingContractBooker commissionableTotalSupplierAmount(CustomMonetaryAmount commissionableTotalSupplierAmount) {
        this.commissionableTotalSupplierAmount = commissionableTotalSupplierAmount;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="commissionableTotalSupplierAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomMonetaryAmount getCommissionableTotalSupplierAmount() {
        return this.commissionableTotalSupplierAmount;
    }

    @JsonProperty(value="commissionableTotalSupplierAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCommissionableTotalSupplierAmount(CustomMonetaryAmount commissionableTotalSupplierAmount) {
        this.commissionableTotalSupplierAmount = commissionableTotalSupplierAmount;
    }

    public BookingContractBooker totalFeesAndCommissionsSupplierAmount(CustomMonetaryAmount totalFeesAndCommissionsSupplierAmount) {
        this.totalFeesAndCommissionsSupplierAmount = totalFeesAndCommissionsSupplierAmount;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="totalFeesAndCommissionsSupplierAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomMonetaryAmount getTotalFeesAndCommissionsSupplierAmount() {
        return this.totalFeesAndCommissionsSupplierAmount;
    }

    @JsonProperty(value="totalFeesAndCommissionsSupplierAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalFeesAndCommissionsSupplierAmount(CustomMonetaryAmount totalFeesAndCommissionsSupplierAmount) {
        this.totalFeesAndCommissionsSupplierAmount = totalFeesAndCommissionsSupplierAmount;
    }

    public BookingContractBooker netTotalFeesSupplierAmount(CustomMonetaryAmount netTotalFeesSupplierAmount) {
        this.netTotalFeesSupplierAmount = netTotalFeesSupplierAmount;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="netTotalFeesSupplierAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomMonetaryAmount getNetTotalFeesSupplierAmount() {
        return this.netTotalFeesSupplierAmount;
    }

    @JsonProperty(value="netTotalFeesSupplierAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetTotalFeesSupplierAmount(CustomMonetaryAmount netTotalFeesSupplierAmount) {
        this.netTotalFeesSupplierAmount = netTotalFeesSupplierAmount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BookingContractBooker bookingContractBooker = (BookingContractBooker)o;
        return Objects.equals(this.bookingContractIdentifier, bookingContractBooker.bookingContractIdentifier) && Objects.equals(this.createdDate, bookingContractBooker.createdDate) && Objects.equals(this.lastUpdate, bookingContractBooker.lastUpdate) && Objects.equals(this.ipAddress, bookingContractBooker.ipAddress) && Objects.equals(this.traceId, bookingContractBooker.traceId) && Objects.equals(this.sourceUrl, bookingContractBooker.sourceUrl) && Objects.equals(this.identifier, bookingContractBooker.identifier) && Objects.equals(this.supplierIdentifier, bookingContractBooker.supplierIdentifier) && Objects.equals(this.supplierName, bookingContractBooker.supplierName) && Objects.equals(this.displayPriceQuote, bookingContractBooker.displayPriceQuote) && Objects.equals(this.supplierPriceQuote, bookingContractBooker.supplierPriceQuote) && Objects.equals(this.internalPriceQuote, bookingContractBooker.internalPriceQuote) && Objects.equals(this.capturePriceQuote, bookingContractBooker.capturePriceQuote) && Objects.equals(this.itemList, bookingContractBooker.itemList) && Objects.equals(this.externalSupplierIdentifier, bookingContractBooker.externalSupplierIdentifier) && Objects.equals(this.externalSupplierBookingCode, bookingContractBooker.externalSupplierBookingCode) && Objects.equals(this.payment, bookingContractBooker.payment) && Objects.equals(this.cancelled, bookingContractBooker.cancelled) && Objects.equals(this.cancelledOn, bookingContractBooker.cancelledOn) && Objects.equals((Object)this.canceller, (Object)bookingContractBooker.canceller) && Objects.equals((Object)this.cancellationType, (Object)bookingContractBooker.cancellationType) && Objects.equals(this.cancellerUserIdentifier, bookingContractBooker.cancellerUserIdentifier) && Objects.equals(this.cancelReason, bookingContractBooker.cancelReason) && Objects.equals(this.fundsProcessed, bookingContractBooker.fundsProcessed) && Objects.equals(this.refunds, bookingContractBooker.refunds) && Objects.equals(this.sourceCurrency, bookingContractBooker.sourceCurrency) && Objects.equals(this.displayCurrency, bookingContractBooker.displayCurrency) && Objects.equals(this.supplierCurrency, bookingContractBooker.supplierCurrency) && Objects.equals(this.internalCurrency, bookingContractBooker.internalCurrency) && Objects.equals(this.captureCurrency, bookingContractBooker.captureCurrency) && Objects.equals(this.sourceAmount, bookingContractBooker.sourceAmount) && Objects.equals(this.displayAmount, bookingContractBooker.displayAmount) && Objects.equals(this.supplierAmount, bookingContractBooker.supplierAmount) && Objects.equals(this.internalAmount, bookingContractBooker.internalAmount) && Objects.equals(this.captureAmount, bookingContractBooker.captureAmount) && Objects.equals(this.sourceAmountRefundModifier, bookingContractBooker.sourceAmountRefundModifier) && Objects.equals(this.displayAmountRefundModifier, bookingContractBooker.displayAmountRefundModifier) && Objects.equals(this.supplierAmountRefundModifier, bookingContractBooker.supplierAmountRefundModifier) && Objects.equals(this.internalAmountRefundModifier, bookingContractBooker.internalAmountRefundModifier) && Objects.equals(this.captureAmountRefundModifier, bookingContractBooker.captureAmountRefundModifier) && Objects.equals(this.netSourceAmount, bookingContractBooker.netSourceAmount) && Objects.equals(this.netDisplayAmount, bookingContractBooker.netDisplayAmount) && Objects.equals(this.netSupplierAmount, bookingContractBooker.netSupplierAmount) && Objects.equals(this.netInternalAmount, bookingContractBooker.netInternalAmount) && Objects.equals(this.netCaptureAmount, bookingContractBooker.netCaptureAmount) && Objects.equals(this.totalTokensEarned, bookingContractBooker.totalTokensEarned) && Objects.equals(this.hasRefunds, bookingContractBooker.hasRefunds) && Objects.equals(this.originalCommissionsInPercent, bookingContractBooker.originalCommissionsInPercent) && Objects.equals(this.originalFeesInPercent, bookingContractBooker.originalFeesInPercent) && Objects.equals(this.totalCommissionsInPercentWithRefund, bookingContractBooker.totalCommissionsInPercentWithRefund) && Objects.equals(this.totalFeesInPercentWithRefund, bookingContractBooker.totalFeesInPercentWithRefund) && Objects.equals(this.totalTripPayFeeInPercentWithRefund, bookingContractBooker.totalTripPayFeeInPercentWithRefund) && Objects.equals(this.lodging, bookingContractBooker.lodging) && Objects.equals(this.totalTripPayFeeInPercent, bookingContractBooker.totalTripPayFeeInPercent) && Objects.equals(this.cancellableBySupplier, bookingContractBooker.cancellableBySupplier) && Objects.equals(this.cancellableByTraveler, bookingContractBooker.cancellableByTraveler) && Objects.equals(this.cancellableWithNoCharges, bookingContractBooker.cancellableWithNoCharges) && Objects.equals(this.isCancellableWithPotentialCharges, bookingContractBooker.isCancellableWithPotentialCharges) && Objects.equals(this.netCommissionableTotalSourceAmount, bookingContractBooker.netCommissionableTotalSourceAmount) && Objects.equals(this.netCommissionableTotalCaptureAmount, bookingContractBooker.netCommissionableTotalCaptureAmount) && Objects.equals(this.netCommissionableTotalDisplayAmount, bookingContractBooker.netCommissionableTotalDisplayAmount) && Objects.equals(this.netCommissionableTotalInternalAmount, bookingContractBooker.netCommissionableTotalInternalAmount) && Objects.equals(this.netTotalFeesAndCommissionsSourceAmount, bookingContractBooker.netTotalFeesAndCommissionsSourceAmount) && Objects.equals(this.netTotalFeesAndCommissionsCaptureAmount, bookingContractBooker.netTotalFeesAndCommissionsCaptureAmount) && Objects.equals(this.netTotalFeesAndCommissionsDisplayAmount, bookingContractBooker.netTotalFeesAndCommissionsDisplayAmount) && Objects.equals(this.netTotalFeesAndCommissionsInternalAmount, bookingContractBooker.netTotalFeesAndCommissionsInternalAmount) && Objects.equals(this.netTotalFeesSourceAmount, bookingContractBooker.netTotalFeesSourceAmount) && Objects.equals(this.netTotalFeesCaptureAmount, bookingContractBooker.netTotalFeesCaptureAmount) && Objects.equals(this.netTotalFeesDisplayAmount, bookingContractBooker.netTotalFeesDisplayAmount) && Objects.equals(this.netTotalFeesInternalAmount, bookingContractBooker.netTotalFeesInternalAmount) && Objects.equals(this.netTotalTripPayFeeSourceAmount, bookingContractBooker.netTotalTripPayFeeSourceAmount) && Objects.equals(this.netTotalTripPayFeeCaptureAmount, bookingContractBooker.netTotalTripPayFeeCaptureAmount) && Objects.equals(this.netTotalTripPayFeeDisplayAmount, bookingContractBooker.netTotalTripPayFeeDisplayAmount) && Objects.equals(this.netTotalTripPayFeeInternalAmount, bookingContractBooker.netTotalTripPayFeeInternalAmount) && Objects.equals(this.netTotalSalesSourceAmount, bookingContractBooker.netTotalSalesSourceAmount) && Objects.equals(this.netTotalSalesCaptureAmount, bookingContractBooker.netTotalSalesCaptureAmount) && Objects.equals(this.netTotalSalesDisplayAmount, bookingContractBooker.netTotalSalesDisplayAmount) && Objects.equals(this.netTotalSalesSupplierAmount, bookingContractBooker.netTotalSalesSupplierAmount) && Objects.equals(this.netTotalSalesInternalAmount, bookingContractBooker.netTotalSalesInternalAmount) && Objects.equals(this.commissionableTotalSourceAmount, bookingContractBooker.commissionableTotalSourceAmount) && Objects.equals(this.commissionableTotalCaptureAmount, bookingContractBooker.commissionableTotalCaptureAmount) && Objects.equals(this.commissionableTotalDisplayAmount, bookingContractBooker.commissionableTotalDisplayAmount) && Objects.equals(this.commissionableTotalInternalAmount, bookingContractBooker.commissionableTotalInternalAmount) && Objects.equals(this.totalFeesAndCommissionsSourceAmount, bookingContractBooker.totalFeesAndCommissionsSourceAmount) && Objects.equals(this.totalFeesAndCommissionsCaptureAmount, bookingContractBooker.totalFeesAndCommissionsCaptureAmount) && Objects.equals(this.totalFeesAndCommissionsDisplayAmount, bookingContractBooker.totalFeesAndCommissionsDisplayAmount) && Objects.equals(this.totalFeesAndCommissionsInternalAmount, bookingContractBooker.totalFeesAndCommissionsInternalAmount) && Objects.equals(this.totalFeesSourceAmount, bookingContractBooker.totalFeesSourceAmount) && Objects.equals(this.totalFeesCaptureAmount, bookingContractBooker.totalFeesCaptureAmount) && Objects.equals(this.totalFeesDisplayAmount, bookingContractBooker.totalFeesDisplayAmount) && Objects.equals(this.totalFeesInternalAmount, bookingContractBooker.totalFeesInternalAmount) && Objects.equals(this.totalTripPayFeeSourceAmount, bookingContractBooker.totalTripPayFeeSourceAmount) && Objects.equals(this.totalTripPayFeeCaptureAmount, bookingContractBooker.totalTripPayFeeCaptureAmount) && Objects.equals(this.totalTripPayFeeDisplayAmount, bookingContractBooker.totalTripPayFeeDisplayAmount) && Objects.equals(this.totalTripPayFeeInternalAmount, bookingContractBooker.totalTripPayFeeInternalAmount) && Objects.equals(this.totalSalesSourceAmount, bookingContractBooker.totalSalesSourceAmount) && Objects.equals(this.totalSalesCaptureAmount, bookingContractBooker.totalSalesCaptureAmount) && Objects.equals(this.totalSalesDisplayAmount, bookingContractBooker.totalSalesDisplayAmount) && Objects.equals(this.totalSalesSupplierAmount, bookingContractBooker.totalSalesSupplierAmount) && Objects.equals(this.totalSalesInternalAmount, bookingContractBooker.totalSalesInternalAmount) && Objects.equals(this.fundsAvailableDate, bookingContractBooker.fundsAvailableDate) && Objects.equals(this.totalFeesInPercent, bookingContractBooker.totalFeesInPercent) && Objects.equals(this.totalCommissionsInPercent, bookingContractBooker.totalCommissionsInPercent) && Objects.equals(this.totalFeesAndCommissionsInPercentWithRefund, bookingContractBooker.totalFeesAndCommissionsInPercentWithRefund) && Objects.equals(this.totalFeesAndCommissionsInPercent, bookingContractBooker.totalFeesAndCommissionsInPercent) && Objects.equals(this.hasSuccessfulRefunds, bookingContractBooker.hasSuccessfulRefunds) && Objects.equals(this.hasPendingRefunds, bookingContractBooker.hasPendingRefunds) && Objects.equals(this.hasFailedRefunds, bookingContractBooker.hasFailedRefunds) && Objects.equals(this.netTotalFeesAndCommissionsSupplierAmount, bookingContractBooker.netTotalFeesAndCommissionsSupplierAmount) && Objects.equals(this.totalFeesSupplierAmount, bookingContractBooker.totalFeesSupplierAmount) && Objects.equals(this.netTotalTripPayFeeSupplierAmount, bookingContractBooker.netTotalTripPayFeeSupplierAmount) && Objects.equals(this.totalTripPayFeeSupplierAmount, bookingContractBooker.totalTripPayFeeSupplierAmount) && Objects.equals(this.netCommissionableTotalSupplierAmount, bookingContractBooker.netCommissionableTotalSupplierAmount) && Objects.equals(this.commissionableTotalSupplierAmount, bookingContractBooker.commissionableTotalSupplierAmount) && Objects.equals(this.totalFeesAndCommissionsSupplierAmount, bookingContractBooker.totalFeesAndCommissionsSupplierAmount) && Objects.equals(this.netTotalFeesSupplierAmount, bookingContractBooker.netTotalFeesSupplierAmount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bookingContractIdentifier, this.createdDate, this.lastUpdate, this.ipAddress, this.traceId, this.sourceUrl, this.identifier, this.supplierIdentifier, this.supplierName, this.displayPriceQuote, this.supplierPriceQuote, this.internalPriceQuote, this.capturePriceQuote, this.itemList, this.externalSupplierIdentifier, this.externalSupplierBookingCode, this.payment, this.cancelled, this.cancelledOn, this.canceller, this.cancellationType, this.cancellerUserIdentifier, this.cancelReason, this.fundsProcessed, this.refunds, this.sourceCurrency, this.displayCurrency, this.supplierCurrency, this.internalCurrency, this.captureCurrency, this.sourceAmount, this.displayAmount, this.supplierAmount, this.internalAmount, this.captureAmount, this.sourceAmountRefundModifier, this.displayAmountRefundModifier, this.supplierAmountRefundModifier, this.internalAmountRefundModifier, this.captureAmountRefundModifier, this.netSourceAmount, this.netDisplayAmount, this.netSupplierAmount, this.netInternalAmount, this.netCaptureAmount, this.totalTokensEarned, this.hasRefunds, this.originalCommissionsInPercent, this.originalFeesInPercent, this.totalCommissionsInPercentWithRefund, this.totalFeesInPercentWithRefund, this.totalTripPayFeeInPercentWithRefund, this.lodging, this.totalTripPayFeeInPercent, this.cancellableBySupplier, this.cancellableByTraveler, this.cancellableWithNoCharges, this.isCancellableWithPotentialCharges, this.netCommissionableTotalSourceAmount, this.netCommissionableTotalCaptureAmount, this.netCommissionableTotalDisplayAmount, this.netCommissionableTotalInternalAmount, this.netTotalFeesAndCommissionsSourceAmount, this.netTotalFeesAndCommissionsCaptureAmount, this.netTotalFeesAndCommissionsDisplayAmount, this.netTotalFeesAndCommissionsInternalAmount, this.netTotalFeesSourceAmount, this.netTotalFeesCaptureAmount, this.netTotalFeesDisplayAmount, this.netTotalFeesInternalAmount, this.netTotalTripPayFeeSourceAmount, this.netTotalTripPayFeeCaptureAmount, this.netTotalTripPayFeeDisplayAmount, this.netTotalTripPayFeeInternalAmount, this.netTotalSalesSourceAmount, this.netTotalSalesCaptureAmount, this.netTotalSalesDisplayAmount, this.netTotalSalesSupplierAmount, this.netTotalSalesInternalAmount, this.commissionableTotalSourceAmount, this.commissionableTotalCaptureAmount, this.commissionableTotalDisplayAmount, this.commissionableTotalInternalAmount, this.totalFeesAndCommissionsSourceAmount, this.totalFeesAndCommissionsCaptureAmount, this.totalFeesAndCommissionsDisplayAmount, this.totalFeesAndCommissionsInternalAmount, this.totalFeesSourceAmount, this.totalFeesCaptureAmount, this.totalFeesDisplayAmount, this.totalFeesInternalAmount, this.totalTripPayFeeSourceAmount, this.totalTripPayFeeCaptureAmount, this.totalTripPayFeeDisplayAmount, this.totalTripPayFeeInternalAmount, this.totalSalesSourceAmount, this.totalSalesCaptureAmount, this.totalSalesDisplayAmount, this.totalSalesSupplierAmount, this.totalSalesInternalAmount, this.fundsAvailableDate, this.totalFeesInPercent, this.totalCommissionsInPercent, this.totalFeesAndCommissionsInPercentWithRefund, this.totalFeesAndCommissionsInPercent, this.hasSuccessfulRefunds, this.hasPendingRefunds, this.hasFailedRefunds, this.netTotalFeesAndCommissionsSupplierAmount, this.totalFeesSupplierAmount, this.netTotalTripPayFeeSupplierAmount, this.totalTripPayFeeSupplierAmount, this.netCommissionableTotalSupplierAmount, this.commissionableTotalSupplierAmount, this.totalFeesAndCommissionsSupplierAmount, this.netTotalFeesSupplierAmount});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BookingContractBooker {\n");
        sb.append("    bookingContractIdentifier: ").append(this.toIndentedString(this.bookingContractIdentifier)).append("\n");
        sb.append("    createdDate: ").append(this.toIndentedString(this.createdDate)).append("\n");
        sb.append("    lastUpdate: ").append(this.toIndentedString(this.lastUpdate)).append("\n");
        sb.append("    ipAddress: ").append(this.toIndentedString(this.ipAddress)).append("\n");
        sb.append("    traceId: ").append(this.toIndentedString(this.traceId)).append("\n");
        sb.append("    sourceUrl: ").append(this.toIndentedString(this.sourceUrl)).append("\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    supplierIdentifier: ").append(this.toIndentedString(this.supplierIdentifier)).append("\n");
        sb.append("    supplierName: ").append(this.toIndentedString(this.supplierName)).append("\n");
        sb.append("    displayPriceQuote: ").append(this.toIndentedString(this.displayPriceQuote)).append("\n");
        sb.append("    supplierPriceQuote: ").append(this.toIndentedString(this.supplierPriceQuote)).append("\n");
        sb.append("    internalPriceQuote: ").append(this.toIndentedString(this.internalPriceQuote)).append("\n");
        sb.append("    capturePriceQuote: ").append(this.toIndentedString(this.capturePriceQuote)).append("\n");
        sb.append("    itemList: ").append(this.toIndentedString(this.itemList)).append("\n");
        sb.append("    externalSupplierIdentifier: ").append(this.toIndentedString(this.externalSupplierIdentifier)).append("\n");
        sb.append("    externalSupplierBookingCode: ").append(this.toIndentedString(this.externalSupplierBookingCode)).append("\n");
        sb.append("    payment: ").append(this.toIndentedString(this.payment)).append("\n");
        sb.append("    cancelled: ").append(this.toIndentedString(this.cancelled)).append("\n");
        sb.append("    cancelledOn: ").append(this.toIndentedString(this.cancelledOn)).append("\n");
        sb.append("    canceller: ").append(this.toIndentedString((Object)this.canceller)).append("\n");
        sb.append("    cancellationType: ").append(this.toIndentedString((Object)this.cancellationType)).append("\n");
        sb.append("    cancellerUserIdentifier: ").append(this.toIndentedString(this.cancellerUserIdentifier)).append("\n");
        sb.append("    cancelReason: ").append(this.toIndentedString(this.cancelReason)).append("\n");
        sb.append("    fundsProcessed: ").append(this.toIndentedString(this.fundsProcessed)).append("\n");
        sb.append("    refunds: ").append(this.toIndentedString(this.refunds)).append("\n");
        sb.append("    sourceCurrency: ").append(this.toIndentedString(this.sourceCurrency)).append("\n");
        sb.append("    displayCurrency: ").append(this.toIndentedString(this.displayCurrency)).append("\n");
        sb.append("    supplierCurrency: ").append(this.toIndentedString(this.supplierCurrency)).append("\n");
        sb.append("    internalCurrency: ").append(this.toIndentedString(this.internalCurrency)).append("\n");
        sb.append("    captureCurrency: ").append(this.toIndentedString(this.captureCurrency)).append("\n");
        sb.append("    sourceAmount: ").append(this.toIndentedString(this.sourceAmount)).append("\n");
        sb.append("    displayAmount: ").append(this.toIndentedString(this.displayAmount)).append("\n");
        sb.append("    supplierAmount: ").append(this.toIndentedString(this.supplierAmount)).append("\n");
        sb.append("    internalAmount: ").append(this.toIndentedString(this.internalAmount)).append("\n");
        sb.append("    captureAmount: ").append(this.toIndentedString(this.captureAmount)).append("\n");
        sb.append("    sourceAmountRefundModifier: ").append(this.toIndentedString(this.sourceAmountRefundModifier)).append("\n");
        sb.append("    displayAmountRefundModifier: ").append(this.toIndentedString(this.displayAmountRefundModifier)).append("\n");
        sb.append("    supplierAmountRefundModifier: ").append(this.toIndentedString(this.supplierAmountRefundModifier)).append("\n");
        sb.append("    internalAmountRefundModifier: ").append(this.toIndentedString(this.internalAmountRefundModifier)).append("\n");
        sb.append("    captureAmountRefundModifier: ").append(this.toIndentedString(this.captureAmountRefundModifier)).append("\n");
        sb.append("    netSourceAmount: ").append(this.toIndentedString(this.netSourceAmount)).append("\n");
        sb.append("    netDisplayAmount: ").append(this.toIndentedString(this.netDisplayAmount)).append("\n");
        sb.append("    netSupplierAmount: ").append(this.toIndentedString(this.netSupplierAmount)).append("\n");
        sb.append("    netInternalAmount: ").append(this.toIndentedString(this.netInternalAmount)).append("\n");
        sb.append("    netCaptureAmount: ").append(this.toIndentedString(this.netCaptureAmount)).append("\n");
        sb.append("    totalTokensEarned: ").append(this.toIndentedString(this.totalTokensEarned)).append("\n");
        sb.append("    hasRefunds: ").append(this.toIndentedString(this.hasRefunds)).append("\n");
        sb.append("    originalCommissionsInPercent: ").append(this.toIndentedString(this.originalCommissionsInPercent)).append("\n");
        sb.append("    originalFeesInPercent: ").append(this.toIndentedString(this.originalFeesInPercent)).append("\n");
        sb.append("    totalCommissionsInPercentWithRefund: ").append(this.toIndentedString(this.totalCommissionsInPercentWithRefund)).append("\n");
        sb.append("    totalFeesInPercentWithRefund: ").append(this.toIndentedString(this.totalFeesInPercentWithRefund)).append("\n");
        sb.append("    totalTripPayFeeInPercentWithRefund: ").append(this.toIndentedString(this.totalTripPayFeeInPercentWithRefund)).append("\n");
        sb.append("    lodging: ").append(this.toIndentedString(this.lodging)).append("\n");
        sb.append("    totalTripPayFeeInPercent: ").append(this.toIndentedString(this.totalTripPayFeeInPercent)).append("\n");
        sb.append("    cancellableBySupplier: ").append(this.toIndentedString(this.cancellableBySupplier)).append("\n");
        sb.append("    cancellableByTraveler: ").append(this.toIndentedString(this.cancellableByTraveler)).append("\n");
        sb.append("    cancellableWithNoCharges: ").append(this.toIndentedString(this.cancellableWithNoCharges)).append("\n");
        sb.append("    isCancellableWithPotentialCharges: ").append(this.toIndentedString(this.isCancellableWithPotentialCharges)).append("\n");
        sb.append("    netCommissionableTotalSourceAmount: ").append(this.toIndentedString(this.netCommissionableTotalSourceAmount)).append("\n");
        sb.append("    netCommissionableTotalCaptureAmount: ").append(this.toIndentedString(this.netCommissionableTotalCaptureAmount)).append("\n");
        sb.append("    netCommissionableTotalDisplayAmount: ").append(this.toIndentedString(this.netCommissionableTotalDisplayAmount)).append("\n");
        sb.append("    netCommissionableTotalInternalAmount: ").append(this.toIndentedString(this.netCommissionableTotalInternalAmount)).append("\n");
        sb.append("    netTotalFeesAndCommissionsSourceAmount: ").append(this.toIndentedString(this.netTotalFeesAndCommissionsSourceAmount)).append("\n");
        sb.append("    netTotalFeesAndCommissionsCaptureAmount: ").append(this.toIndentedString(this.netTotalFeesAndCommissionsCaptureAmount)).append("\n");
        sb.append("    netTotalFeesAndCommissionsDisplayAmount: ").append(this.toIndentedString(this.netTotalFeesAndCommissionsDisplayAmount)).append("\n");
        sb.append("    netTotalFeesAndCommissionsInternalAmount: ").append(this.toIndentedString(this.netTotalFeesAndCommissionsInternalAmount)).append("\n");
        sb.append("    netTotalFeesSourceAmount: ").append(this.toIndentedString(this.netTotalFeesSourceAmount)).append("\n");
        sb.append("    netTotalFeesCaptureAmount: ").append(this.toIndentedString(this.netTotalFeesCaptureAmount)).append("\n");
        sb.append("    netTotalFeesDisplayAmount: ").append(this.toIndentedString(this.netTotalFeesDisplayAmount)).append("\n");
        sb.append("    netTotalFeesInternalAmount: ").append(this.toIndentedString(this.netTotalFeesInternalAmount)).append("\n");
        sb.append("    netTotalTripPayFeeSourceAmount: ").append(this.toIndentedString(this.netTotalTripPayFeeSourceAmount)).append("\n");
        sb.append("    netTotalTripPayFeeCaptureAmount: ").append(this.toIndentedString(this.netTotalTripPayFeeCaptureAmount)).append("\n");
        sb.append("    netTotalTripPayFeeDisplayAmount: ").append(this.toIndentedString(this.netTotalTripPayFeeDisplayAmount)).append("\n");
        sb.append("    netTotalTripPayFeeInternalAmount: ").append(this.toIndentedString(this.netTotalTripPayFeeInternalAmount)).append("\n");
        sb.append("    netTotalSalesSourceAmount: ").append(this.toIndentedString(this.netTotalSalesSourceAmount)).append("\n");
        sb.append("    netTotalSalesCaptureAmount: ").append(this.toIndentedString(this.netTotalSalesCaptureAmount)).append("\n");
        sb.append("    netTotalSalesDisplayAmount: ").append(this.toIndentedString(this.netTotalSalesDisplayAmount)).append("\n");
        sb.append("    netTotalSalesSupplierAmount: ").append(this.toIndentedString(this.netTotalSalesSupplierAmount)).append("\n");
        sb.append("    netTotalSalesInternalAmount: ").append(this.toIndentedString(this.netTotalSalesInternalAmount)).append("\n");
        sb.append("    commissionableTotalSourceAmount: ").append(this.toIndentedString(this.commissionableTotalSourceAmount)).append("\n");
        sb.append("    commissionableTotalCaptureAmount: ").append(this.toIndentedString(this.commissionableTotalCaptureAmount)).append("\n");
        sb.append("    commissionableTotalDisplayAmount: ").append(this.toIndentedString(this.commissionableTotalDisplayAmount)).append("\n");
        sb.append("    commissionableTotalInternalAmount: ").append(this.toIndentedString(this.commissionableTotalInternalAmount)).append("\n");
        sb.append("    totalFeesAndCommissionsSourceAmount: ").append(this.toIndentedString(this.totalFeesAndCommissionsSourceAmount)).append("\n");
        sb.append("    totalFeesAndCommissionsCaptureAmount: ").append(this.toIndentedString(this.totalFeesAndCommissionsCaptureAmount)).append("\n");
        sb.append("    totalFeesAndCommissionsDisplayAmount: ").append(this.toIndentedString(this.totalFeesAndCommissionsDisplayAmount)).append("\n");
        sb.append("    totalFeesAndCommissionsInternalAmount: ").append(this.toIndentedString(this.totalFeesAndCommissionsInternalAmount)).append("\n");
        sb.append("    totalFeesSourceAmount: ").append(this.toIndentedString(this.totalFeesSourceAmount)).append("\n");
        sb.append("    totalFeesCaptureAmount: ").append(this.toIndentedString(this.totalFeesCaptureAmount)).append("\n");
        sb.append("    totalFeesDisplayAmount: ").append(this.toIndentedString(this.totalFeesDisplayAmount)).append("\n");
        sb.append("    totalFeesInternalAmount: ").append(this.toIndentedString(this.totalFeesInternalAmount)).append("\n");
        sb.append("    totalTripPayFeeSourceAmount: ").append(this.toIndentedString(this.totalTripPayFeeSourceAmount)).append("\n");
        sb.append("    totalTripPayFeeCaptureAmount: ").append(this.toIndentedString(this.totalTripPayFeeCaptureAmount)).append("\n");
        sb.append("    totalTripPayFeeDisplayAmount: ").append(this.toIndentedString(this.totalTripPayFeeDisplayAmount)).append("\n");
        sb.append("    totalTripPayFeeInternalAmount: ").append(this.toIndentedString(this.totalTripPayFeeInternalAmount)).append("\n");
        sb.append("    totalSalesSourceAmount: ").append(this.toIndentedString(this.totalSalesSourceAmount)).append("\n");
        sb.append("    totalSalesCaptureAmount: ").append(this.toIndentedString(this.totalSalesCaptureAmount)).append("\n");
        sb.append("    totalSalesDisplayAmount: ").append(this.toIndentedString(this.totalSalesDisplayAmount)).append("\n");
        sb.append("    totalSalesSupplierAmount: ").append(this.toIndentedString(this.totalSalesSupplierAmount)).append("\n");
        sb.append("    totalSalesInternalAmount: ").append(this.toIndentedString(this.totalSalesInternalAmount)).append("\n");
        sb.append("    fundsAvailableDate: ").append(this.toIndentedString(this.fundsAvailableDate)).append("\n");
        sb.append("    totalFeesInPercent: ").append(this.toIndentedString(this.totalFeesInPercent)).append("\n");
        sb.append("    totalCommissionsInPercent: ").append(this.toIndentedString(this.totalCommissionsInPercent)).append("\n");
        sb.append("    totalFeesAndCommissionsInPercentWithRefund: ").append(this.toIndentedString(this.totalFeesAndCommissionsInPercentWithRefund)).append("\n");
        sb.append("    totalFeesAndCommissionsInPercent: ").append(this.toIndentedString(this.totalFeesAndCommissionsInPercent)).append("\n");
        sb.append("    hasSuccessfulRefunds: ").append(this.toIndentedString(this.hasSuccessfulRefunds)).append("\n");
        sb.append("    hasPendingRefunds: ").append(this.toIndentedString(this.hasPendingRefunds)).append("\n");
        sb.append("    hasFailedRefunds: ").append(this.toIndentedString(this.hasFailedRefunds)).append("\n");
        sb.append("    netTotalFeesAndCommissionsSupplierAmount: ").append(this.toIndentedString(this.netTotalFeesAndCommissionsSupplierAmount)).append("\n");
        sb.append("    totalFeesSupplierAmount: ").append(this.toIndentedString(this.totalFeesSupplierAmount)).append("\n");
        sb.append("    netTotalTripPayFeeSupplierAmount: ").append(this.toIndentedString(this.netTotalTripPayFeeSupplierAmount)).append("\n");
        sb.append("    totalTripPayFeeSupplierAmount: ").append(this.toIndentedString(this.totalTripPayFeeSupplierAmount)).append("\n");
        sb.append("    netCommissionableTotalSupplierAmount: ").append(this.toIndentedString(this.netCommissionableTotalSupplierAmount)).append("\n");
        sb.append("    commissionableTotalSupplierAmount: ").append(this.toIndentedString(this.commissionableTotalSupplierAmount)).append("\n");
        sb.append("    totalFeesAndCommissionsSupplierAmount: ").append(this.toIndentedString(this.totalFeesAndCommissionsSupplierAmount)).append("\n");
        sb.append("    netTotalFeesSupplierAmount: ").append(this.toIndentedString(this.netTotalFeesSupplierAmount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CancellerEnum {
        SALES_CHANNEL("SALES_CHANNEL"),
        SUPPLIER("SUPPLIER"),
        TRAVELER("TRAVELER"),
        ACQUIRER("ACQUIRER"),
        ADMINISTRATOR("ADMINISTRATOR");

        private String value;

        private CancellerEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CancellerEnum fromValue(String value) {
            for (CancellerEnum b : CancellerEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum CancellationTypeEnum {
        DUPLICATE("DUPLICATE"),
        CANCELLATION("CANCELLATION"),
        NO_SHOW("NO_SHOW"),
        CC_INVALID("CC_INVALID"),
        CC_INSUFFICIENT("CC_INSUFFICIENT"),
        DISCRETIONARY("DISCRETIONARY");

        private String value;

        private CancellationTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CancellationTypeEnum fromValue(String value) {
            for (CancellationTypeEnum b : CancellationTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

