/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release   # Booking API Welcome to the Booking Engine API - A programmer-friendly way to book inventory that was found on our platform. We take great care in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive payment-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 29.30.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.booking.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.booking.model.AddressAgent;
import travel.wink.sdk.booking.model.ContactAgent;
import travel.wink.sdk.booking.model.GeoJsonPointAgent;
import travel.wink.sdk.booking.model.LocalizedDescriptionAgent;
import travel.wink.sdk.booking.model.PropertyPolicyAgent;
import travel.wink.sdk.booking.model.RecognitionAgent;
import travel.wink.sdk.booking.model.SimpleMultimediaAgent;
import travel.wink.sdk.booking.model.SocialAgent;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Combined property data.
 */
@JsonPropertyOrder({
  HotelOnMapAgent.JSON_PROPERTY_IDENTIFIER,
  HotelOnMapAgent.JSON_PROPERTY_HOTEL_IDENTIFIER,
  HotelOnMapAgent.JSON_PROPERTY_NAME,
  HotelOnMapAgent.JSON_PROPERTY_LOCAL_NAME,
  HotelOnMapAgent.JSON_PROPERTY_CHAIN,
  HotelOnMapAgent.JSON_PROPERTY_BRAND,
  HotelOnMapAgent.JSON_PROPERTY_URL_NAME,
  HotelOnMapAgent.JSON_PROPERTY_STAR_RATING,
  HotelOnMapAgent.JSON_PROPERTY_BOOKINGS,
  HotelOnMapAgent.JSON_PROPERTY_AGGREGATE_REVIEW_RATING,
  HotelOnMapAgent.JSON_PROPERTY_LOCATION,
  HotelOnMapAgent.JSON_PROPERTY_SHORT_DESCRIPTIONS,
  HotelOnMapAgent.JSON_PROPERTY_LONG_DESCRIPTIONS,
  HotelOnMapAgent.JSON_PROPERTY_AGGREGATE_GREENDEX_RATING,
  HotelOnMapAgent.JSON_PROPERTY_LIFESTYLE_TYPES,
  HotelOnMapAgent.JSON_PROPERTY_TOTAL_REVIEWS,
  HotelOnMapAgent.JSON_PROPERTY_AVAILABLE,
  HotelOnMapAgent.JSON_PROPERTY_HOTEL_AVAILABLE,
  HotelOnMapAgent.JSON_PROPERTY_RESERVATIONS,
  HotelOnMapAgent.JSON_PROPERTY_SOCIALS,
  HotelOnMapAgent.JSON_PROPERTY_IMAGES,
  HotelOnMapAgent.JSON_PROPERTY_VIDEOS,
  HotelOnMapAgent.JSON_PROPERTY_POLICY,
  HotelOnMapAgent.JSON_PROPERTY_THIRD_PARTY_REVIEWS,
  HotelOnMapAgent.JSON_PROPERTY_ATTRACTIONS,
  HotelOnMapAgent.JSON_PROPERTY_RECREATIONS,
  HotelOnMapAgent.JSON_PROPERTY_POIS,
  HotelOnMapAgent.JSON_PROPERTY_RESTAURANTS,
  HotelOnMapAgent.JSON_PROPERTY_MEETING_ROOMS,
  HotelOnMapAgent.JSON_PROPERTY_SPAS,
  HotelOnMapAgent.JSON_PROPERTY_ADD_ONS,
  HotelOnMapAgent.JSON_PROPERTY_FULL_NAME_OF_GENERAL_MANAGER,
  HotelOnMapAgent.JSON_PROPERTY_PROFILE_PICTURE_IDENTIFIER_GENERAL_MANAGER,
  HotelOnMapAgent.JSON_PROPERTY_MESSAGES_OF_GENERAL_MANAGER,
  HotelOnMapAgent.JSON_PROPERTY_LOCATION_CATEGORY,
  HotelOnMapAgent.JSON_PROPERTY_SEGMENT_CATEGORY,
  HotelOnMapAgent.JSON_PROPERTY_HOTEL_CATEGORY,
  HotelOnMapAgent.JSON_PROPERTY_ARCHITECTURAL_STYLE,
  HotelOnMapAgent.JSON_PROPERTY_WHEN_BUILT,
  HotelOnMapAgent.JSON_PROPERTY_MULTIMEDIA_IDENTIFIER,
  HotelOnMapAgent.JSON_PROPERTY_IMAGE_IDENTIFIER,
  HotelOnMapAgent.JSON_PROPERTY_IMAGE_ANGLE,
  HotelOnMapAgent.JSON_PROPERTY_VIDEO_IDENTIFIER,
  HotelOnMapAgent.JSON_PROPERTY_CURRENCY_CODE,
  HotelOnMapAgent.JSON_PROPERTY_MEMBERSHIP_RATE_DISCOUNT,
  HotelOnMapAgent.JSON_PROPERTY_PRICE_SCORE,
  HotelOnMapAgent.JSON_PROPERTY_PERK_SCORE,
  HotelOnMapAgent.JSON_PROPERTY_PACKAGE_SCORE,
  HotelOnMapAgent.JSON_PROPERTY_LOYALTY_SCORE,
  HotelOnMapAgent.JSON_PROPERTY_POPULAR_SCORE,
  HotelOnMapAgent.JSON_PROPERTY_EXPERIENCE_SCORE,
  HotelOnMapAgent.JSON_PROPERTY_AVAILABILITY_SCORE,
  HotelOnMapAgent.JSON_PROPERTY_VIEWS,
  HotelOnMapAgent.JSON_PROPERTY_HOTEL_AMENITY_CODES,
  HotelOnMapAgent.JSON_PROPERTY_PROPERTY_ACCESSIBILITY_CODES,
  HotelOnMapAgent.JSON_PROPERTY_PROPERTY_SECURITY_CODES,
  HotelOnMapAgent.JSON_PROPERTY_NUMBER_OF_ROOMS,
  HotelOnMapAgent.JSON_PROPERTY_ADDRESS,
  HotelOnMapAgent.JSON_PROPERTY_ACTIVE,
  HotelOnMapAgent.JSON_PROPERTY_URL_PARAMETERS
})
@JsonTypeName("HotelOnMap_Agent")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-12-27T18:01:04.927620553+07:00[Asia/Bangkok]")
public class HotelOnMapAgent {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private String identifier;

  public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
  private UUID hotelIdentifier;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_LOCAL_NAME = "localName";
  private String localName;

  public static final String JSON_PROPERTY_CHAIN = "chain";
  private String chain;

  public static final String JSON_PROPERTY_BRAND = "brand";
  private String brand;

  public static final String JSON_PROPERTY_URL_NAME = "urlName";
  private String urlName;

  public static final String JSON_PROPERTY_STAR_RATING = "starRating";
  private Integer starRating;

  public static final String JSON_PROPERTY_BOOKINGS = "bookings";
  private Long bookings = 0l;

  public static final String JSON_PROPERTY_AGGREGATE_REVIEW_RATING = "aggregateReviewRating";
  private Float aggregateReviewRating = 0.0f;

  public static final String JSON_PROPERTY_LOCATION = "location";
  private GeoJsonPointAgent location;

  public static final String JSON_PROPERTY_SHORT_DESCRIPTIONS = "shortDescriptions";
  private List<LocalizedDescriptionAgent> shortDescriptions;

  public static final String JSON_PROPERTY_LONG_DESCRIPTIONS = "longDescriptions";
  private List<LocalizedDescriptionAgent> longDescriptions;

  public static final String JSON_PROPERTY_AGGREGATE_GREENDEX_RATING = "aggregateGreendexRating";
  private Float aggregateGreendexRating = 0.0f;

  /**
   * A list of lifestyles the property associates with.
   */
  public enum LifestyleTypesEnum {
    HEALTH_FITNESS("LIFESTYLE_HEALTH_FITNESS"),
    
    RELAX("LIFESTYLE_RELAX"),
    
    ADULT_ONLY("LIFESTYLE_ADULT_ONLY"),
    
    ADVENTURE("LIFESTYLE_ADVENTURE"),
    
    BUSINESS("LIFESTYLE_BUSINESS"),
    
    LGBT("LIFESTYLE_LGBT"),
    
    SINGLE_PARENT("LIFESTYLE_SINGLE_PARENT"),
    
    SOLO_FEMALE("LIFESTYLE_SOLO_FEMALE"),
    
    BEAUTY("LIFESTYLE_BEAUTY"),
    
    FOODIE("LIFESTYLE_FOODIE"),
    
    FAMILY("LIFESTYLE_FAMILY"),
    
    ROMANCE("LIFESTYLE_ROMANCE"),
    
    COUPLE("LIFESTYLE_COUPLE"),
    
    SOLO("LIFESTYLE_SOLO"),
    
    BACKPACKER("LIFESTYLE_BACKPACKER"),
    
    SHOPPING("LIFESTYLE_SHOPPING"),
    
    SPORTS("LIFESTYLE_SPORTS"),
    
    MOUNTAIN("LIFESTYLE_MOUNTAIN"),
    
    BEACH("LIFESTYLE_BEACH"),
    
    CITY("LIFESTYLE_CITY"),
    
    COUNTRY("LIFESTYLE_COUNTRY"),
    
    CULTURE("LIFESTYLE_CULTURE"),
    
    ECO("LIFESTYLE_ECO");

    private String value;

    LifestyleTypesEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static LifestyleTypesEnum fromValue(String value) {
      for (LifestyleTypesEnum b : LifestyleTypesEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_LIFESTYLE_TYPES = "lifestyleTypes";
  private List<LifestyleTypesEnum> lifestyleTypes;

  public static final String JSON_PROPERTY_TOTAL_REVIEWS = "totalReviews";
  private Integer totalReviews = 0;

  public static final String JSON_PROPERTY_AVAILABLE = "available";
  private Boolean available = false;

  public static final String JSON_PROPERTY_HOTEL_AVAILABLE = "hotelAvailable";
  private Boolean hotelAvailable = false;

  public static final String JSON_PROPERTY_RESERVATIONS = "reservations";
  private ContactAgent reservations;

  public static final String JSON_PROPERTY_SOCIALS = "socials";
  private List<SocialAgent> socials;

  public static final String JSON_PROPERTY_IMAGES = "images";
  private List<SimpleMultimediaAgent> images;

  public static final String JSON_PROPERTY_VIDEOS = "videos";
  private List<SimpleMultimediaAgent> videos;

  public static final String JSON_PROPERTY_POLICY = "policy";
  private PropertyPolicyAgent policy;

  public static final String JSON_PROPERTY_THIRD_PARTY_REVIEWS = "thirdPartyReviews";
  private List<RecognitionAgent> thirdPartyReviews;

  public static final String JSON_PROPERTY_ATTRACTIONS = "attractions";
  private Integer attractions = 0;

  public static final String JSON_PROPERTY_RECREATIONS = "recreations";
  private Integer recreations = 0;

  public static final String JSON_PROPERTY_POIS = "pois";
  private Integer pois = 0;

  public static final String JSON_PROPERTY_RESTAURANTS = "restaurants";
  private Integer restaurants = 0;

  public static final String JSON_PROPERTY_MEETING_ROOMS = "meetingRooms";
  private Integer meetingRooms = 0;

  public static final String JSON_PROPERTY_SPAS = "spas";
  private Integer spas = 0;

  public static final String JSON_PROPERTY_ADD_ONS = "addOns";
  private Integer addOns = 0;

  public static final String JSON_PROPERTY_FULL_NAME_OF_GENERAL_MANAGER = "fullNameOfGeneralManager";
  private String fullNameOfGeneralManager;

  public static final String JSON_PROPERTY_PROFILE_PICTURE_IDENTIFIER_GENERAL_MANAGER = "profilePictureIdentifierGeneralManager";
  private String profilePictureIdentifierGeneralManager;

  public static final String JSON_PROPERTY_MESSAGES_OF_GENERAL_MANAGER = "messagesOfGeneralManager";
  private List<LocalizedDescriptionAgent> messagesOfGeneralManager;

  public static final String JSON_PROPERTY_LOCATION_CATEGORY = "locationCategory";
  private String locationCategory;

  public static final String JSON_PROPERTY_SEGMENT_CATEGORY = "segmentCategory";
  private String segmentCategory;

  public static final String JSON_PROPERTY_HOTEL_CATEGORY = "hotelCategory";
  private String hotelCategory;

  public static final String JSON_PROPERTY_ARCHITECTURAL_STYLE = "architecturalStyle";
  private String architecturalStyle;

  public static final String JSON_PROPERTY_WHEN_BUILT = "whenBuilt";
  private String whenBuilt;

  public static final String JSON_PROPERTY_MULTIMEDIA_IDENTIFIER = "multimediaIdentifier";
  private String multimediaIdentifier;

  public static final String JSON_PROPERTY_IMAGE_IDENTIFIER = "imageIdentifier";
  private String imageIdentifier;

  public static final String JSON_PROPERTY_IMAGE_ANGLE = "imageAngle";
  private String imageAngle;

  public static final String JSON_PROPERTY_VIDEO_IDENTIFIER = "videoIdentifier";
  private String videoIdentifier;

  public static final String JSON_PROPERTY_CURRENCY_CODE = "currencyCode";
  private String currencyCode;

  public static final String JSON_PROPERTY_MEMBERSHIP_RATE_DISCOUNT = "membershipRateDiscount";
  private Float membershipRateDiscount = 0f;

  public static final String JSON_PROPERTY_PRICE_SCORE = "priceScore";
  private Integer priceScore = 0;

  public static final String JSON_PROPERTY_PERK_SCORE = "perkScore";
  private Integer perkScore = 0;

  public static final String JSON_PROPERTY_PACKAGE_SCORE = "packageScore";
  private Integer packageScore = 0;

  public static final String JSON_PROPERTY_LOYALTY_SCORE = "loyaltyScore";
  private Integer loyaltyScore = 0;

  public static final String JSON_PROPERTY_POPULAR_SCORE = "popularScore";
  private Integer popularScore = 0;

  public static final String JSON_PROPERTY_EXPERIENCE_SCORE = "experienceScore";
  private Integer experienceScore = 0;

  public static final String JSON_PROPERTY_AVAILABILITY_SCORE = "availabilityScore";
  private Integer availabilityScore = 0;

  public static final String JSON_PROPERTY_VIEWS = "views";
  private Long views = 0l;

  public static final String JSON_PROPERTY_HOTEL_AMENITY_CODES = "hotelAmenityCodes";
  private List<String> hotelAmenityCodes;

  public static final String JSON_PROPERTY_PROPERTY_ACCESSIBILITY_CODES = "propertyAccessibilityCodes";
  private List<String> propertyAccessibilityCodes;

  public static final String JSON_PROPERTY_PROPERTY_SECURITY_CODES = "propertySecurityCodes";
  private List<String> propertySecurityCodes;

  public static final String JSON_PROPERTY_NUMBER_OF_ROOMS = "numberOfRooms";
  private Integer numberOfRooms = 0;

  public static final String JSON_PROPERTY_ADDRESS = "address";
  private AddressAgent address;

  public static final String JSON_PROPERTY_ACTIVE = "active";
  private Boolean active;

  public static final String JSON_PROPERTY_URL_PARAMETERS = "urlParameters";
  private String urlParameters;

  public HotelOnMapAgent() {
  }

  public HotelOnMapAgent identifier(String identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique record identifier. This is NOT the same as the unique hotel record identifier.
   * @return identifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIdentifier(String identifier) {
    this.identifier = identifier;
  }


  public HotelOnMapAgent hotelIdentifier(UUID hotelIdentifier) {
    
    this.hotelIdentifier = hotelIdentifier;
    return this;
  }

   /**
   * Unique hotel record identifier.
   * @return hotelIdentifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getHotelIdentifier() {
    return hotelIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelIdentifier(UUID hotelIdentifier) {
    this.hotelIdentifier = hotelIdentifier;
  }


  public HotelOnMapAgent name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Hotel trade name
   * @return name
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
    this.name = name;
  }


  public HotelOnMapAgent localName(String localName) {
    
    this.localName = localName;
    return this;
  }

   /**
   * Hotel local name if different from the trade name or if it is the local language.
   * @return localName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LOCAL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLocalName() {
    return localName;
  }


  @JsonProperty(JSON_PROPERTY_LOCAL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLocalName(String localName) {
    this.localName = localName;
  }


  public HotelOnMapAgent chain(String chain) {
    
    this.chain = chain;
    return this;
  }

   /**
   * Name of hotel chain if applicable.
   * @return chain
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CHAIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getChain() {
    return chain;
  }


  @JsonProperty(JSON_PROPERTY_CHAIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChain(String chain) {
    this.chain = chain;
  }


  public HotelOnMapAgent brand(String brand) {
    
    this.brand = brand;
    return this;
  }

   /**
   * Name of hotel brand
   * @return brand
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_BRAND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBrand() {
    return brand;
  }


  @JsonProperty(JSON_PROPERTY_BRAND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBrand(String brand) {
    this.brand = brand;
  }


  public HotelOnMapAgent urlName(String urlName) {
    
    this.urlName = urlName;
    return this;
  }

   /**
   * Unique URL-friendly name slug of hotel
   * @return urlName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_URL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUrlName() {
    return urlName;
  }


  @JsonProperty(JSON_PROPERTY_URL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUrlName(String urlName) {
    this.urlName = urlName;
  }


  public HotelOnMapAgent starRating(Integer starRating) {
    
    this.starRating = starRating;
    return this;
  }

   /**
   * Official or self-designated property star rating. Note that in some regions there are 6-star hotels. They are the same as 5-star hotels everywhere else.
   * minimum: 0
   * maximum: 6
   * @return starRating
  **/
  @jakarta.annotation.Nullable
 @Min(0) @Max(6)
  @JsonProperty(JSON_PROPERTY_STAR_RATING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getStarRating() {
    return starRating;
  }


  @JsonProperty(JSON_PROPERTY_STAR_RATING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStarRating(Integer starRating) {
    this.starRating = starRating;
  }


  public HotelOnMapAgent bookings(Long bookings) {
    
    this.bookings = bookings;
    return this;
  }

   /**
   * Number of bookings for this property on the wink.travel payment.
   * @return bookings
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_BOOKINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getBookings() {
    return bookings;
  }


  @JsonProperty(JSON_PROPERTY_BOOKINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBookings(Long bookings) {
    this.bookings = bookings;
  }


  public HotelOnMapAgent aggregateReviewRating(Float aggregateReviewRating) {
    
    this.aggregateReviewRating = aggregateReviewRating;
    return this;
  }

   /**
   * Aggregate score based on all current user reviews.
   * @return aggregateReviewRating
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_AGGREGATE_REVIEW_RATING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getAggregateReviewRating() {
    return aggregateReviewRating;
  }


  @JsonProperty(JSON_PROPERTY_AGGREGATE_REVIEW_RATING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAggregateReviewRating(Float aggregateReviewRating) {
    this.aggregateReviewRating = aggregateReviewRating;
  }


  public HotelOnMapAgent location(GeoJsonPointAgent location) {
    
    this.location = location;
    return this;
  }

   /**
   * Get location
   * @return location
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GeoJsonPointAgent getLocation() {
    return location;
  }


  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLocation(GeoJsonPointAgent location) {
    this.location = location;
  }


  public HotelOnMapAgent shortDescriptions(List<LocalizedDescriptionAgent> shortDescriptions) {
    
    this.shortDescriptions = shortDescriptions;
    return this;
  }

  public HotelOnMapAgent addShortDescriptionsItem(LocalizedDescriptionAgent shortDescriptionsItem) {
    if (this.shortDescriptions == null) {
      this.shortDescriptions = new ArrayList<>();
    }
    this.shortDescriptions.add(shortDescriptionsItem);
    return this;
  }

   /**
   * A localized list of short property descriptions
   * @return shortDescriptions
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SHORT_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<LocalizedDescriptionAgent> getShortDescriptions() {
    return shortDescriptions;
  }


  @JsonProperty(JSON_PROPERTY_SHORT_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShortDescriptions(List<LocalizedDescriptionAgent> shortDescriptions) {
    this.shortDescriptions = shortDescriptions;
  }


  public HotelOnMapAgent longDescriptions(List<LocalizedDescriptionAgent> longDescriptions) {
    
    this.longDescriptions = longDescriptions;
    return this;
  }

  public HotelOnMapAgent addLongDescriptionsItem(LocalizedDescriptionAgent longDescriptionsItem) {
    if (this.longDescriptions == null) {
      this.longDescriptions = new ArrayList<>();
    }
    this.longDescriptions.add(longDescriptionsItem);
    return this;
  }

   /**
   * A localized list of longer property descriptions
   * @return longDescriptions
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LONG_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<LocalizedDescriptionAgent> getLongDescriptions() {
    return longDescriptions;
  }


  @JsonProperty(JSON_PROPERTY_LONG_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLongDescriptions(List<LocalizedDescriptionAgent> longDescriptions) {
    this.longDescriptions = longDescriptions;
  }


  public HotelOnMapAgent aggregateGreendexRating(Float aggregateGreendexRating) {
    
    this.aggregateGreendexRating = aggregateGreendexRating;
    return this;
  }

   /**
   * Aggregate Green Index score if the property has answered our questionnaire available in the Extranet.
   * @return aggregateGreendexRating
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_AGGREGATE_GREENDEX_RATING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getAggregateGreendexRating() {
    return aggregateGreendexRating;
  }


  @JsonProperty(JSON_PROPERTY_AGGREGATE_GREENDEX_RATING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAggregateGreendexRating(Float aggregateGreendexRating) {
    this.aggregateGreendexRating = aggregateGreendexRating;
  }


  public HotelOnMapAgent lifestyleTypes(List<LifestyleTypesEnum> lifestyleTypes) {
    
    this.lifestyleTypes = lifestyleTypes;
    return this;
  }

  public HotelOnMapAgent addLifestyleTypesItem(LifestyleTypesEnum lifestyleTypesItem) {
    if (this.lifestyleTypes == null) {
      this.lifestyleTypes = new ArrayList<>();
    }
    this.lifestyleTypes.add(lifestyleTypesItem);
    return this;
  }

   /**
   * Get lifestyleTypes
   * @return lifestyleTypes
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LIFESTYLE_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<LifestyleTypesEnum> getLifestyleTypes() {
    return lifestyleTypes;
  }


  @JsonProperty(JSON_PROPERTY_LIFESTYLE_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLifestyleTypes(List<LifestyleTypesEnum> lifestyleTypes) {
    this.lifestyleTypes = lifestyleTypes;
  }


  public HotelOnMapAgent totalReviews(Integer totalReviews) {
    
    this.totalReviews = totalReviews;
    return this;
  }

   /**
   * Count of total reviews left by users at this property.
   * @return totalReviews
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOTAL_REVIEWS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getTotalReviews() {
    return totalReviews;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_REVIEWS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalReviews(Integer totalReviews) {
    this.totalReviews = totalReviews;
  }


  public HotelOnMapAgent available(Boolean available) {
    
    this.available = available;
    return this;
  }

   /**
   * Flag indicating whether the payment has made this property available for sale.
   * @return available
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAvailable() {
    return available;
  }


  @JsonProperty(JSON_PROPERTY_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAvailable(Boolean available) {
    this.available = available;
  }


  public HotelOnMapAgent hotelAvailable(Boolean hotelAvailable) {
    
    this.hotelAvailable = hotelAvailable;
    return this;
  }

   /**
   * Flag indicating whether the property has made this property available for sale.
   * @return hotelAvailable
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HOTEL_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHotelAvailable() {
    return hotelAvailable;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelAvailable(Boolean hotelAvailable) {
    this.hotelAvailable = hotelAvailable;
  }


  public HotelOnMapAgent reservations(ContactAgent reservations) {
    
    this.reservations = reservations;
    return this;
  }

   /**
   * Get reservations
   * @return reservations
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_RESERVATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ContactAgent getReservations() {
    return reservations;
  }


  @JsonProperty(JSON_PROPERTY_RESERVATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReservations(ContactAgent reservations) {
    this.reservations = reservations;
  }


  public HotelOnMapAgent socials(List<SocialAgent> socials) {
    
    this.socials = socials;
    return this;
  }

  public HotelOnMapAgent addSocialsItem(SocialAgent socialsItem) {
    if (this.socials == null) {
      this.socials = new ArrayList<>();
    }
    this.socials.add(socialsItem);
    return this;
  }

   /**
   * Property&#39;s social network accounts
   * @return socials
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOCIALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SocialAgent> getSocials() {
    return socials;
  }


  @JsonProperty(JSON_PROPERTY_SOCIALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSocials(List<SocialAgent> socials) {
    this.socials = socials;
  }


  public HotelOnMapAgent images(List<SimpleMultimediaAgent> images) {
    
    this.images = images;
    return this;
  }

  public HotelOnMapAgent addImagesItem(SimpleMultimediaAgent imagesItem) {
    if (this.images == null) {
      this.images = new ArrayList<>();
    }
    this.images.add(imagesItem);
    return this;
  }

   /**
   * Property images.
   * @return images
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_IMAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SimpleMultimediaAgent> getImages() {
    return images;
  }


  @JsonProperty(JSON_PROPERTY_IMAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setImages(List<SimpleMultimediaAgent> images) {
    this.images = images;
  }


  public HotelOnMapAgent videos(List<SimpleMultimediaAgent> videos) {
    
    this.videos = videos;
    return this;
  }

  public HotelOnMapAgent addVideosItem(SimpleMultimediaAgent videosItem) {
    if (this.videos == null) {
      this.videos = new ArrayList<>();
    }
    this.videos.add(videosItem);
    return this;
  }

   /**
   * Property videos.
   * @return videos
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_VIDEOS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SimpleMultimediaAgent> getVideos() {
    return videos;
  }


  @JsonProperty(JSON_PROPERTY_VIDEOS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVideos(List<SimpleMultimediaAgent> videos) {
    this.videos = videos;
  }


  public HotelOnMapAgent policy(PropertyPolicyAgent policy) {
    
    this.policy = policy;
    return this;
  }

   /**
   * Get policy
   * @return policy
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PropertyPolicyAgent getPolicy() {
    return policy;
  }


  @JsonProperty(JSON_PROPERTY_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPolicy(PropertyPolicyAgent policy) {
    this.policy = policy;
  }


  public HotelOnMapAgent thirdPartyReviews(List<RecognitionAgent> thirdPartyReviews) {
    
    this.thirdPartyReviews = thirdPartyReviews;
    return this;
  }

  public HotelOnMapAgent addThirdPartyReviewsItem(RecognitionAgent thirdPartyReviewsItem) {
    if (this.thirdPartyReviews == null) {
      this.thirdPartyReviews = new ArrayList<>();
    }
    this.thirdPartyReviews.add(thirdPartyReviewsItem);
    return this;
  }

   /**
   * Array of awards and third party reviews given to property by certified / non-certified providers.
   * @return thirdPartyReviews
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_THIRD_PARTY_REVIEWS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<RecognitionAgent> getThirdPartyReviews() {
    return thirdPartyReviews;
  }


  @JsonProperty(JSON_PROPERTY_THIRD_PARTY_REVIEWS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setThirdPartyReviews(List<RecognitionAgent> thirdPartyReviews) {
    this.thirdPartyReviews = thirdPartyReviews;
  }


  public HotelOnMapAgent attractions(Integer attractions) {
    
    this.attractions = attractions;
    return this;
  }

   /**
   * Number of attractions property has listed on its profile.
   * @return attractions
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ATTRACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getAttractions() {
    return attractions;
  }


  @JsonProperty(JSON_PROPERTY_ATTRACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAttractions(Integer attractions) {
    this.attractions = attractions;
  }


  public HotelOnMapAgent recreations(Integer recreations) {
    
    this.recreations = recreations;
    return this;
  }

   /**
   * Number of activites property has listed on its profile.
   * @return recreations
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RECREATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getRecreations() {
    return recreations;
  }


  @JsonProperty(JSON_PROPERTY_RECREATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecreations(Integer recreations) {
    this.recreations = recreations;
  }


  public HotelOnMapAgent pois(Integer pois) {
    
    this.pois = pois;
    return this;
  }

   /**
   * Number of places property has listed on its profile.
   * @return pois
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_POIS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPois() {
    return pois;
  }


  @JsonProperty(JSON_PROPERTY_POIS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPois(Integer pois) {
    this.pois = pois;
  }


  public HotelOnMapAgent restaurants(Integer restaurants) {
    
    this.restaurants = restaurants;
    return this;
  }

   /**
   * Number of restaurants property has on its profile.
   * @return restaurants
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RESTAURANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getRestaurants() {
    return restaurants;
  }


  @JsonProperty(JSON_PROPERTY_RESTAURANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRestaurants(Integer restaurants) {
    this.restaurants = restaurants;
  }


  public HotelOnMapAgent meetingRooms(Integer meetingRooms) {
    
    this.meetingRooms = meetingRooms;
    return this;
  }

   /**
   * Number of meeting rooms property has on its profile.
   * @return meetingRooms
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MEETING_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMeetingRooms() {
    return meetingRooms;
  }


  @JsonProperty(JSON_PROPERTY_MEETING_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMeetingRooms(Integer meetingRooms) {
    this.meetingRooms = meetingRooms;
  }


  public HotelOnMapAgent spas(Integer spas) {
    
    this.spas = spas;
    return this;
  }

   /**
   * Number of spas property has on its profile.
   * @return spas
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SPAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getSpas() {
    return spas;
  }


  @JsonProperty(JSON_PROPERTY_SPAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSpas(Integer spas) {
    this.spas = spas;
  }


  public HotelOnMapAgent addOns(Integer addOns) {
    
    this.addOns = addOns;
    return this;
  }

   /**
   * Number of add-ons property has on its profile.
   * @return addOns
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ADD_ONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getAddOns() {
    return addOns;
  }


  @JsonProperty(JSON_PROPERTY_ADD_ONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddOns(Integer addOns) {
    this.addOns = addOns;
  }


  public HotelOnMapAgent fullNameOfGeneralManager(String fullNameOfGeneralManager) {
    
    this.fullNameOfGeneralManager = fullNameOfGeneralManager;
    return this;
  }

   /**
   * Full name of the property&#39;s current and active general manager.
   * @return fullNameOfGeneralManager
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_FULL_NAME_OF_GENERAL_MANAGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFullNameOfGeneralManager() {
    return fullNameOfGeneralManager;
  }


  @JsonProperty(JSON_PROPERTY_FULL_NAME_OF_GENERAL_MANAGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFullNameOfGeneralManager(String fullNameOfGeneralManager) {
    this.fullNameOfGeneralManager = fullNameOfGeneralManager;
  }


  public HotelOnMapAgent profilePictureIdentifierGeneralManager(String profilePictureIdentifierGeneralManager) {
    
    this.profilePictureIdentifierGeneralManager = profilePictureIdentifierGeneralManager;
    return this;
  }

   /**
   * Cloudinary identifier referencing image of general manager.
   * @return profilePictureIdentifierGeneralManager
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PROFILE_PICTURE_IDENTIFIER_GENERAL_MANAGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getProfilePictureIdentifierGeneralManager() {
    return profilePictureIdentifierGeneralManager;
  }


  @JsonProperty(JSON_PROPERTY_PROFILE_PICTURE_IDENTIFIER_GENERAL_MANAGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProfilePictureIdentifierGeneralManager(String profilePictureIdentifierGeneralManager) {
    this.profilePictureIdentifierGeneralManager = profilePictureIdentifierGeneralManager;
  }


  public HotelOnMapAgent messagesOfGeneralManager(List<LocalizedDescriptionAgent> messagesOfGeneralManager) {
    
    this.messagesOfGeneralManager = messagesOfGeneralManager;
    return this;
  }

  public HotelOnMapAgent addMessagesOfGeneralManagerItem(LocalizedDescriptionAgent messagesOfGeneralManagerItem) {
    if (this.messagesOfGeneralManager == null) {
      this.messagesOfGeneralManager = new ArrayList<>();
    }
    this.messagesOfGeneralManager.add(messagesOfGeneralManagerItem);
    return this;
  }

   /**
   * A list of localized welcome messages created by the property&#39;s general manager.
   * @return messagesOfGeneralManager
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_MESSAGES_OF_GENERAL_MANAGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<LocalizedDescriptionAgent> getMessagesOfGeneralManager() {
    return messagesOfGeneralManager;
  }


  @JsonProperty(JSON_PROPERTY_MESSAGES_OF_GENERAL_MANAGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMessagesOfGeneralManager(List<LocalizedDescriptionAgent> messagesOfGeneralManager) {
    this.messagesOfGeneralManager = messagesOfGeneralManager;
  }


  public HotelOnMapAgent locationCategory(String locationCategory) {
    
    this.locationCategory = locationCategory;
    return this;
  }

   /**
   * Supported OTA specification &#x60;LOC&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return locationCategory
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LOCATION_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLocationCategory() {
    return locationCategory;
  }


  @JsonProperty(JSON_PROPERTY_LOCATION_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLocationCategory(String locationCategory) {
    this.locationCategory = locationCategory;
  }


  public HotelOnMapAgent segmentCategory(String segmentCategory) {
    
    this.segmentCategory = segmentCategory;
    return this;
  }

   /**
   * Supported OTA specification &#x60;SEG&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return segmentCategory
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SEGMENT_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSegmentCategory() {
    return segmentCategory;
  }


  @JsonProperty(JSON_PROPERTY_SEGMENT_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSegmentCategory(String segmentCategory) {
    this.segmentCategory = segmentCategory;
  }


  public HotelOnMapAgent hotelCategory(String hotelCategory) {
    
    this.hotelCategory = hotelCategory;
    return this;
  }

   /**
   * Supported OTA specification &#x60;PCT&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return hotelCategory
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HOTEL_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getHotelCategory() {
    return hotelCategory;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelCategory(String hotelCategory) {
    this.hotelCategory = hotelCategory;
  }


  public HotelOnMapAgent architecturalStyle(String architecturalStyle) {
    
    this.architecturalStyle = architecturalStyle;
    return this;
  }

   /**
   * Supported OTA specification &#x60;ARC&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return architecturalStyle
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ARCHITECTURAL_STYLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getArchitecturalStyle() {
    return architecturalStyle;
  }


  @JsonProperty(JSON_PROPERTY_ARCHITECTURAL_STYLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setArchitecturalStyle(String architecturalStyle) {
    this.architecturalStyle = architecturalStyle;
  }


  public HotelOnMapAgent whenBuilt(String whenBuilt) {
    
    this.whenBuilt = whenBuilt;
    return this;
  }

   /**
   * Year the property was constructed.
   * @return whenBuilt
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_WHEN_BUILT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getWhenBuilt() {
    return whenBuilt;
  }


  @JsonProperty(JSON_PROPERTY_WHEN_BUILT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWhenBuilt(String whenBuilt) {
    this.whenBuilt = whenBuilt;
  }


  public HotelOnMapAgent multimediaIdentifier(String multimediaIdentifier) {
    
    this.multimediaIdentifier = multimediaIdentifier;
    return this;
  }

   /**
   * Featured image identifier for this property.
   * @return multimediaIdentifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MULTIMEDIA_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMultimediaIdentifier() {
    return multimediaIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_MULTIMEDIA_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMultimediaIdentifier(String multimediaIdentifier) {
    this.multimediaIdentifier = multimediaIdentifier;
  }


  public HotelOnMapAgent imageIdentifier(String imageIdentifier) {
    
    this.imageIdentifier = imageIdentifier;
    return this;
  }

   /**
   * Featured Cloudinary image identifier for this property.
   * @return imageIdentifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_IMAGE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getImageIdentifier() {
    return imageIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_IMAGE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setImageIdentifier(String imageIdentifier) {
    this.imageIdentifier = imageIdentifier;
  }


  public HotelOnMapAgent imageAngle(String imageAngle) {
    
    this.imageAngle = imageAngle;
    return this;
  }

   /**
   * Meta data information about image angle that gives integrators a chance to crop this image properly.
   * @return imageAngle
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_IMAGE_ANGLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getImageAngle() {
    return imageAngle;
  }


  @JsonProperty(JSON_PROPERTY_IMAGE_ANGLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setImageAngle(String imageAngle) {
    this.imageAngle = imageAngle;
  }


  public HotelOnMapAgent videoIdentifier(String videoIdentifier) {
    
    this.videoIdentifier = videoIdentifier;
    return this;
  }

   /**
   * Featured Cloudinary video identifier for this property.
   * @return videoIdentifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_VIDEO_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getVideoIdentifier() {
    return videoIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_VIDEO_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVideoIdentifier(String videoIdentifier) {
    this.videoIdentifier = videoIdentifier;
  }


  public HotelOnMapAgent currencyCode(String currencyCode) {
    
    this.currencyCode = currencyCode;
    return this;
  }

   /**
   * Currency code for property.
   * @return currencyCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCurrencyCode() {
    return currencyCode;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCurrencyCode(String currencyCode) {
    this.currencyCode = currencyCode;
  }


  public HotelOnMapAgent membershipRateDiscount(Float membershipRateDiscount) {
    
    this.membershipRateDiscount = membershipRateDiscount;
    return this;
  }

   /**
   * A property&#39;s price score is based on calculating historical pricing data. Each property receives a unique score. There is no max score; it&#39;s there to compare it against other properties.
   * @return membershipRateDiscount
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MEMBERSHIP_RATE_DISCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getMembershipRateDiscount() {
    return membershipRateDiscount;
  }


  @JsonProperty(JSON_PROPERTY_MEMBERSHIP_RATE_DISCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMembershipRateDiscount(Float membershipRateDiscount) {
    this.membershipRateDiscount = membershipRateDiscount;
  }


  public HotelOnMapAgent priceScore(Integer priceScore) {
    
    this.priceScore = priceScore;
    return this;
  }

   /**
   * A property&#39;s price score is based on calculating historical pricing data. Each property receives a unique score. There is no max score; it&#39;s there to compare it against other properties.
   * @return priceScore
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PRICE_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPriceScore() {
    return priceScore;
  }


  @JsonProperty(JSON_PROPERTY_PRICE_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPriceScore(Integer priceScore) {
    this.priceScore = priceScore;
  }


  public HotelOnMapAgent perkScore(Integer perkScore) {
    
    this.perkScore = perkScore;
    return this;
  }

   /**
   * A property&#39;s perk score is based on the type of perks that is offered to the guests across all master rates. There is no max score; it&#39;s there to compare it against other properties.
   * @return perkScore
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PERK_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPerkScore() {
    return perkScore;
  }


  @JsonProperty(JSON_PROPERTY_PERK_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPerkScore(Integer perkScore) {
    this.perkScore = perkScore;
  }


  public HotelOnMapAgent packageScore(Integer packageScore) {
    
    this.packageScore = packageScore;
    return this;
  }

   /**
   * A property&#39;s package score is based on general availability and price for all packages and add-ons offered by the property. There is no max score; it&#39;s there to compare it against other properties.
   * @return packageScore
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PACKAGE_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPackageScore() {
    return packageScore;
  }


  @JsonProperty(JSON_PROPERTY_PACKAGE_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPackageScore(Integer packageScore) {
    this.packageScore = packageScore;
  }


  public HotelOnMapAgent loyaltyScore(Integer loyaltyScore) {
    
    this.loyaltyScore = loyaltyScore;
    return this;
  }

   /**
   * A property&#39;s loyalty score is based on calculating how many available rate plans honor loyalty points. There is no max score; it&#39;s there to compare it against other properties.
   * @return loyaltyScore
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LOYALTY_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getLoyaltyScore() {
    return loyaltyScore;
  }


  @JsonProperty(JSON_PROPERTY_LOYALTY_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLoyaltyScore(Integer loyaltyScore) {
    this.loyaltyScore = loyaltyScore;
  }


  public HotelOnMapAgent popularScore(Integer popularScore) {
    
    this.popularScore = popularScore;
    return this;
  }

   /**
   * A property&#39;s popular score is based on calculating number of bookings across room types. There is no max score; it&#39;s there to compare it against other properties.
   * @return popularScore
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_POPULAR_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPopularScore() {
    return popularScore;
  }


  @JsonProperty(JSON_PROPERTY_POPULAR_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPopularScore(Integer popularScore) {
    this.popularScore = popularScore;
  }


  public HotelOnMapAgent experienceScore(Integer experienceScore) {
    
    this.experienceScore = experienceScore;
    return this;
  }

   /**
   * A property&#39;s experience score is based on how calculating how many types of experiences are available and at what price ranges. There is no max score; it&#39;s there to compare it against other properties.
   * @return experienceScore
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_EXPERIENCE_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getExperienceScore() {
    return experienceScore;
  }


  @JsonProperty(JSON_PROPERTY_EXPERIENCE_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExperienceScore(Integer experienceScore) {
    this.experienceScore = experienceScore;
  }


  public HotelOnMapAgent availabilityScore(Integer availabilityScore) {
    
    this.availabilityScore = availabilityScore;
    return this;
  }

   /**
   * A property&#39;s availability score is based on general availability of all room types. If most room types are always unavailable, the attractiveness of this property goes down. We use this as our primary benchmark to decide how and when to feature properties. There is no max score; it&#39;s there to compare it against other properties.
   * @return availabilityScore
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_AVAILABILITY_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getAvailabilityScore() {
    return availabilityScore;
  }


  @JsonProperty(JSON_PROPERTY_AVAILABILITY_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAvailabilityScore(Integer availabilityScore) {
    this.availabilityScore = availabilityScore;
  }


  public HotelOnMapAgent views(Long views) {
    
    this.views = views;
    return this;
  }

   /**
   * Total number of user views of this property.
   * @return views
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_VIEWS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getViews() {
    return views;
  }


  @JsonProperty(JSON_PROPERTY_VIEWS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setViews(Long views) {
    this.views = views;
  }


  public HotelOnMapAgent hotelAmenityCodes(List<String> hotelAmenityCodes) {
    
    this.hotelAmenityCodes = hotelAmenityCodes;
    return this;
  }

  public HotelOnMapAgent addHotelAmenityCodesItem(String hotelAmenityCodesItem) {
    if (this.hotelAmenityCodes == null) {
      this.hotelAmenityCodes = new ArrayList<>();
    }
    this.hotelAmenityCodes.add(hotelAmenityCodesItem);
    return this;
  }

   /**
   * Supported OTA specification &#x60;HAC&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return hotelAmenityCodes
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HOTEL_AMENITY_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getHotelAmenityCodes() {
    return hotelAmenityCodes;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_AMENITY_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelAmenityCodes(List<String> hotelAmenityCodes) {
    this.hotelAmenityCodes = hotelAmenityCodes;
  }


  public HotelOnMapAgent propertyAccessibilityCodes(List<String> propertyAccessibilityCodes) {
    
    this.propertyAccessibilityCodes = propertyAccessibilityCodes;
    return this;
  }

  public HotelOnMapAgent addPropertyAccessibilityCodesItem(String propertyAccessibilityCodesItem) {
    if (this.propertyAccessibilityCodes == null) {
      this.propertyAccessibilityCodes = new ArrayList<>();
    }
    this.propertyAccessibilityCodes.add(propertyAccessibilityCodesItem);
    return this;
  }

   /**
   * Supported OTA specification &#x60;PHY&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return propertyAccessibilityCodes
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PROPERTY_ACCESSIBILITY_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getPropertyAccessibilityCodes() {
    return propertyAccessibilityCodes;
  }


  @JsonProperty(JSON_PROPERTY_PROPERTY_ACCESSIBILITY_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPropertyAccessibilityCodes(List<String> propertyAccessibilityCodes) {
    this.propertyAccessibilityCodes = propertyAccessibilityCodes;
  }


  public HotelOnMapAgent propertySecurityCodes(List<String> propertySecurityCodes) {
    
    this.propertySecurityCodes = propertySecurityCodes;
    return this;
  }

  public HotelOnMapAgent addPropertySecurityCodesItem(String propertySecurityCodesItem) {
    if (this.propertySecurityCodes == null) {
      this.propertySecurityCodes = new ArrayList<>();
    }
    this.propertySecurityCodes.add(propertySecurityCodesItem);
    return this;
  }

   /**
   * Supported OTA specification &#x60;SEC&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return propertySecurityCodes
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PROPERTY_SECURITY_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getPropertySecurityCodes() {
    return propertySecurityCodes;
  }


  @JsonProperty(JSON_PROPERTY_PROPERTY_SECURITY_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPropertySecurityCodes(List<String> propertySecurityCodes) {
    this.propertySecurityCodes = propertySecurityCodes;
  }


  public HotelOnMapAgent numberOfRooms(Integer numberOfRooms) {
    
    this.numberOfRooms = numberOfRooms;
    return this;
  }

   /**
   * Number of rooms / keys for this property.
   * @return numberOfRooms
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_NUMBER_OF_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getNumberOfRooms() {
    return numberOfRooms;
  }


  @JsonProperty(JSON_PROPERTY_NUMBER_OF_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNumberOfRooms(Integer numberOfRooms) {
    this.numberOfRooms = numberOfRooms;
  }


  public HotelOnMapAgent address(AddressAgent address) {
    
    this.address = address;
    return this;
  }

   /**
   * Get address
   * @return address
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AddressAgent getAddress() {
    return address;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddress(AddressAgent address) {
    this.address = address;
  }


  public HotelOnMapAgent active(Boolean active) {
    
    this.active = active;
    return this;
  }

   /**
   * A property is considered active when both available and hotelAvailable flags are true.
   * @return active
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getActive() {
    return active;
  }


  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setActive(Boolean active) {
    this.active = active;
  }


  public HotelOnMapAgent urlParameters(String urlParameters) {
    
    this.urlParameters = urlParameters;
    return this;
  }

   /**
   * Convenience data point that creates url friendly query parameters of property.
   * @return urlParameters
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_URL_PARAMETERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUrlParameters() {
    return urlParameters;
  }


  @JsonProperty(JSON_PROPERTY_URL_PARAMETERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUrlParameters(String urlParameters) {
    this.urlParameters = urlParameters;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    HotelOnMapAgent hotelOnMapAgent = (HotelOnMapAgent) o;
    return Objects.equals(this.identifier, hotelOnMapAgent.identifier) &&
        Objects.equals(this.hotelIdentifier, hotelOnMapAgent.hotelIdentifier) &&
        Objects.equals(this.name, hotelOnMapAgent.name) &&
        Objects.equals(this.localName, hotelOnMapAgent.localName) &&
        Objects.equals(this.chain, hotelOnMapAgent.chain) &&
        Objects.equals(this.brand, hotelOnMapAgent.brand) &&
        Objects.equals(this.urlName, hotelOnMapAgent.urlName) &&
        Objects.equals(this.starRating, hotelOnMapAgent.starRating) &&
        Objects.equals(this.bookings, hotelOnMapAgent.bookings) &&
        Objects.equals(this.aggregateReviewRating, hotelOnMapAgent.aggregateReviewRating) &&
        Objects.equals(this.location, hotelOnMapAgent.location) &&
        Objects.equals(this.shortDescriptions, hotelOnMapAgent.shortDescriptions) &&
        Objects.equals(this.longDescriptions, hotelOnMapAgent.longDescriptions) &&
        Objects.equals(this.aggregateGreendexRating, hotelOnMapAgent.aggregateGreendexRating) &&
        Objects.equals(this.lifestyleTypes, hotelOnMapAgent.lifestyleTypes) &&
        Objects.equals(this.totalReviews, hotelOnMapAgent.totalReviews) &&
        Objects.equals(this.available, hotelOnMapAgent.available) &&
        Objects.equals(this.hotelAvailable, hotelOnMapAgent.hotelAvailable) &&
        Objects.equals(this.reservations, hotelOnMapAgent.reservations) &&
        Objects.equals(this.socials, hotelOnMapAgent.socials) &&
        Objects.equals(this.images, hotelOnMapAgent.images) &&
        Objects.equals(this.videos, hotelOnMapAgent.videos) &&
        Objects.equals(this.policy, hotelOnMapAgent.policy) &&
        Objects.equals(this.thirdPartyReviews, hotelOnMapAgent.thirdPartyReviews) &&
        Objects.equals(this.attractions, hotelOnMapAgent.attractions) &&
        Objects.equals(this.recreations, hotelOnMapAgent.recreations) &&
        Objects.equals(this.pois, hotelOnMapAgent.pois) &&
        Objects.equals(this.restaurants, hotelOnMapAgent.restaurants) &&
        Objects.equals(this.meetingRooms, hotelOnMapAgent.meetingRooms) &&
        Objects.equals(this.spas, hotelOnMapAgent.spas) &&
        Objects.equals(this.addOns, hotelOnMapAgent.addOns) &&
        Objects.equals(this.fullNameOfGeneralManager, hotelOnMapAgent.fullNameOfGeneralManager) &&
        Objects.equals(this.profilePictureIdentifierGeneralManager, hotelOnMapAgent.profilePictureIdentifierGeneralManager) &&
        Objects.equals(this.messagesOfGeneralManager, hotelOnMapAgent.messagesOfGeneralManager) &&
        Objects.equals(this.locationCategory, hotelOnMapAgent.locationCategory) &&
        Objects.equals(this.segmentCategory, hotelOnMapAgent.segmentCategory) &&
        Objects.equals(this.hotelCategory, hotelOnMapAgent.hotelCategory) &&
        Objects.equals(this.architecturalStyle, hotelOnMapAgent.architecturalStyle) &&
        Objects.equals(this.whenBuilt, hotelOnMapAgent.whenBuilt) &&
        Objects.equals(this.multimediaIdentifier, hotelOnMapAgent.multimediaIdentifier) &&
        Objects.equals(this.imageIdentifier, hotelOnMapAgent.imageIdentifier) &&
        Objects.equals(this.imageAngle, hotelOnMapAgent.imageAngle) &&
        Objects.equals(this.videoIdentifier, hotelOnMapAgent.videoIdentifier) &&
        Objects.equals(this.currencyCode, hotelOnMapAgent.currencyCode) &&
        Objects.equals(this.membershipRateDiscount, hotelOnMapAgent.membershipRateDiscount) &&
        Objects.equals(this.priceScore, hotelOnMapAgent.priceScore) &&
        Objects.equals(this.perkScore, hotelOnMapAgent.perkScore) &&
        Objects.equals(this.packageScore, hotelOnMapAgent.packageScore) &&
        Objects.equals(this.loyaltyScore, hotelOnMapAgent.loyaltyScore) &&
        Objects.equals(this.popularScore, hotelOnMapAgent.popularScore) &&
        Objects.equals(this.experienceScore, hotelOnMapAgent.experienceScore) &&
        Objects.equals(this.availabilityScore, hotelOnMapAgent.availabilityScore) &&
        Objects.equals(this.views, hotelOnMapAgent.views) &&
        Objects.equals(this.hotelAmenityCodes, hotelOnMapAgent.hotelAmenityCodes) &&
        Objects.equals(this.propertyAccessibilityCodes, hotelOnMapAgent.propertyAccessibilityCodes) &&
        Objects.equals(this.propertySecurityCodes, hotelOnMapAgent.propertySecurityCodes) &&
        Objects.equals(this.numberOfRooms, hotelOnMapAgent.numberOfRooms) &&
        Objects.equals(this.address, hotelOnMapAgent.address) &&
        Objects.equals(this.active, hotelOnMapAgent.active) &&
        Objects.equals(this.urlParameters, hotelOnMapAgent.urlParameters);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, hotelIdentifier, name, localName, chain, brand, urlName, starRating, bookings, aggregateReviewRating, location, shortDescriptions, longDescriptions, aggregateGreendexRating, lifestyleTypes, totalReviews, available, hotelAvailable, reservations, socials, images, videos, policy, thirdPartyReviews, attractions, recreations, pois, restaurants, meetingRooms, spas, addOns, fullNameOfGeneralManager, profilePictureIdentifierGeneralManager, messagesOfGeneralManager, locationCategory, segmentCategory, hotelCategory, architecturalStyle, whenBuilt, multimediaIdentifier, imageIdentifier, imageAngle, videoIdentifier, currencyCode, membershipRateDiscount, priceScore, perkScore, packageScore, loyaltyScore, popularScore, experienceScore, availabilityScore, views, hotelAmenityCodes, propertyAccessibilityCodes, propertySecurityCodes, numberOfRooms, address, active, urlParameters);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class HotelOnMapAgent {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    hotelIdentifier: ").append(toIndentedString(hotelIdentifier)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    localName: ").append(toIndentedString(localName)).append("\n");
    sb.append("    chain: ").append(toIndentedString(chain)).append("\n");
    sb.append("    brand: ").append(toIndentedString(brand)).append("\n");
    sb.append("    urlName: ").append(toIndentedString(urlName)).append("\n");
    sb.append("    starRating: ").append(toIndentedString(starRating)).append("\n");
    sb.append("    bookings: ").append(toIndentedString(bookings)).append("\n");
    sb.append("    aggregateReviewRating: ").append(toIndentedString(aggregateReviewRating)).append("\n");
    sb.append("    location: ").append(toIndentedString(location)).append("\n");
    sb.append("    shortDescriptions: ").append(toIndentedString(shortDescriptions)).append("\n");
    sb.append("    longDescriptions: ").append(toIndentedString(longDescriptions)).append("\n");
    sb.append("    aggregateGreendexRating: ").append(toIndentedString(aggregateGreendexRating)).append("\n");
    sb.append("    lifestyleTypes: ").append(toIndentedString(lifestyleTypes)).append("\n");
    sb.append("    totalReviews: ").append(toIndentedString(totalReviews)).append("\n");
    sb.append("    available: ").append(toIndentedString(available)).append("\n");
    sb.append("    hotelAvailable: ").append(toIndentedString(hotelAvailable)).append("\n");
    sb.append("    reservations: ").append(toIndentedString(reservations)).append("\n");
    sb.append("    socials: ").append(toIndentedString(socials)).append("\n");
    sb.append("    images: ").append(toIndentedString(images)).append("\n");
    sb.append("    videos: ").append(toIndentedString(videos)).append("\n");
    sb.append("    policy: ").append(toIndentedString(policy)).append("\n");
    sb.append("    thirdPartyReviews: ").append(toIndentedString(thirdPartyReviews)).append("\n");
    sb.append("    attractions: ").append(toIndentedString(attractions)).append("\n");
    sb.append("    recreations: ").append(toIndentedString(recreations)).append("\n");
    sb.append("    pois: ").append(toIndentedString(pois)).append("\n");
    sb.append("    restaurants: ").append(toIndentedString(restaurants)).append("\n");
    sb.append("    meetingRooms: ").append(toIndentedString(meetingRooms)).append("\n");
    sb.append("    spas: ").append(toIndentedString(spas)).append("\n");
    sb.append("    addOns: ").append(toIndentedString(addOns)).append("\n");
    sb.append("    fullNameOfGeneralManager: ").append(toIndentedString(fullNameOfGeneralManager)).append("\n");
    sb.append("    profilePictureIdentifierGeneralManager: ").append(toIndentedString(profilePictureIdentifierGeneralManager)).append("\n");
    sb.append("    messagesOfGeneralManager: ").append(toIndentedString(messagesOfGeneralManager)).append("\n");
    sb.append("    locationCategory: ").append(toIndentedString(locationCategory)).append("\n");
    sb.append("    segmentCategory: ").append(toIndentedString(segmentCategory)).append("\n");
    sb.append("    hotelCategory: ").append(toIndentedString(hotelCategory)).append("\n");
    sb.append("    architecturalStyle: ").append(toIndentedString(architecturalStyle)).append("\n");
    sb.append("    whenBuilt: ").append(toIndentedString(whenBuilt)).append("\n");
    sb.append("    multimediaIdentifier: ").append(toIndentedString(multimediaIdentifier)).append("\n");
    sb.append("    imageIdentifier: ").append(toIndentedString(imageIdentifier)).append("\n");
    sb.append("    imageAngle: ").append(toIndentedString(imageAngle)).append("\n");
    sb.append("    videoIdentifier: ").append(toIndentedString(videoIdentifier)).append("\n");
    sb.append("    currencyCode: ").append(toIndentedString(currencyCode)).append("\n");
    sb.append("    membershipRateDiscount: ").append(toIndentedString(membershipRateDiscount)).append("\n");
    sb.append("    priceScore: ").append(toIndentedString(priceScore)).append("\n");
    sb.append("    perkScore: ").append(toIndentedString(perkScore)).append("\n");
    sb.append("    packageScore: ").append(toIndentedString(packageScore)).append("\n");
    sb.append("    loyaltyScore: ").append(toIndentedString(loyaltyScore)).append("\n");
    sb.append("    popularScore: ").append(toIndentedString(popularScore)).append("\n");
    sb.append("    experienceScore: ").append(toIndentedString(experienceScore)).append("\n");
    sb.append("    availabilityScore: ").append(toIndentedString(availabilityScore)).append("\n");
    sb.append("    views: ").append(toIndentedString(views)).append("\n");
    sb.append("    hotelAmenityCodes: ").append(toIndentedString(hotelAmenityCodes)).append("\n");
    sb.append("    propertyAccessibilityCodes: ").append(toIndentedString(propertyAccessibilityCodes)).append("\n");
    sb.append("    propertySecurityCodes: ").append(toIndentedString(propertySecurityCodes)).append("\n");
    sb.append("    numberOfRooms: ").append(toIndentedString(numberOfRooms)).append("\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    active: ").append(toIndentedString(active)).append("\n");
    sb.append("    urlParameters: ").append(toIndentedString(urlParameters)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

