/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.booking.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.NotNull;
import java.time.LocalDate;
import java.util.Objects;
import java.util.UUID;

@JsonPropertyOrder(value={"identifier", "hotelIdentifier", "type", "category", "provider", "rating", "maxRating", "date", "officialAppointmentInd", "ratingSymbol"})
@JsonTypeName(value="Recognition_Booker")
public class RecognitionBooker {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private UUID identifier;
    public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
    private UUID hotelIdentifier;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_CATEGORY = "category";
    private CategoryEnum category;
    public static final String JSON_PROPERTY_PROVIDER = "provider";
    private String provider;
    public static final String JSON_PROPERTY_RATING = "rating";
    private Float rating;
    public static final String JSON_PROPERTY_MAX_RATING = "maxRating";
    private Float maxRating;
    public static final String JSON_PROPERTY_DATE = "date";
    private LocalDate date;
    public static final String JSON_PROPERTY_OFFICIAL_APPOINTMENT_IND = "officialAppointmentInd";
    private Boolean officialAppointmentInd;
    public static final String JSON_PROPERTY_RATING_SYMBOL = "ratingSymbol";
    private String ratingSymbol;

    public RecognitionBooker identifier(UUID identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIdentifier(UUID identifier) {
        this.identifier = identifier;
    }

    public RecognitionBooker hotelIdentifier(UUID hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getHotelIdentifier() {
        return this.hotelIdentifier;
    }

    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setHotelIdentifier(UUID hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
    }

    public RecognitionBooker type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public RecognitionBooker category(CategoryEnum category) {
        this.category = category;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="category")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CategoryEnum getCategory() {
        return this.category;
    }

    @JsonProperty(value="category")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCategory(CategoryEnum category) {
        this.category = category;
    }

    public RecognitionBooker provider(String provider) {
        this.provider = provider;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="provider")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getProvider() {
        return this.provider;
    }

    @JsonProperty(value="provider")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setProvider(String provider) {
        this.provider = provider;
    }

    public RecognitionBooker rating(Float rating) {
        this.rating = rating;
        return this;
    }

    @Nonnull
    @NotNull
    @DecimalMin(value="0.0")
    @JsonProperty(value="rating")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @DecimalMin(value="0.0") Float getRating() {
        return this.rating;
    }

    @JsonProperty(value="rating")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRating(Float rating) {
        this.rating = rating;
    }

    public RecognitionBooker maxRating(Float maxRating) {
        this.maxRating = maxRating;
        return this;
    }

    @Nullable
    @JsonProperty(value="maxRating")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Float getMaxRating() {
        return this.maxRating;
    }

    @JsonProperty(value="maxRating")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMaxRating(Float maxRating) {
        this.maxRating = maxRating;
    }

    public RecognitionBooker date(LocalDate date) {
        this.date = date;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="date")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getDate() {
        return this.date;
    }

    @JsonProperty(value="date")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDate(LocalDate date) {
        this.date = date;
    }

    public RecognitionBooker officialAppointmentInd(Boolean officialAppointmentInd) {
        this.officialAppointmentInd = officialAppointmentInd;
        return this;
    }

    @Nullable
    @JsonProperty(value="officialAppointmentInd")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getOfficialAppointmentInd() {
        return this.officialAppointmentInd;
    }

    @JsonProperty(value="officialAppointmentInd")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOfficialAppointmentInd(Boolean officialAppointmentInd) {
        this.officialAppointmentInd = officialAppointmentInd;
    }

    public RecognitionBooker ratingSymbol(String ratingSymbol) {
        this.ratingSymbol = ratingSymbol;
        return this;
    }

    @Nullable
    @JsonProperty(value="ratingSymbol")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRatingSymbol() {
        return this.ratingSymbol;
    }

    @JsonProperty(value="ratingSymbol")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRatingSymbol(String ratingSymbol) {
        this.ratingSymbol = ratingSymbol;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecognitionBooker recognitionBooker = (RecognitionBooker)o;
        return Objects.equals(this.identifier, recognitionBooker.identifier) && Objects.equals(this.hotelIdentifier, recognitionBooker.hotelIdentifier) && Objects.equals((Object)this.type, (Object)recognitionBooker.type) && Objects.equals((Object)this.category, (Object)recognitionBooker.category) && Objects.equals(this.provider, recognitionBooker.provider) && Objects.equals(this.rating, recognitionBooker.rating) && Objects.equals(this.maxRating, recognitionBooker.maxRating) && Objects.equals(this.date, recognitionBooker.date) && Objects.equals(this.officialAppointmentInd, recognitionBooker.officialAppointmentInd) && Objects.equals(this.ratingSymbol, recognitionBooker.ratingSymbol);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identifier, this.hotelIdentifier, this.type, this.category, this.provider, this.rating, this.maxRating, this.date, this.officialAppointmentInd, this.ratingSymbol});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RecognitionBooker {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    hotelIdentifier: ").append(this.toIndentedString(this.hotelIdentifier)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    category: ").append(this.toIndentedString((Object)this.category)).append("\n");
        sb.append("    provider: ").append(this.toIndentedString(this.provider)).append("\n");
        sb.append("    rating: ").append(this.toIndentedString(this.rating)).append("\n");
        sb.append("    maxRating: ").append(this.toIndentedString(this.maxRating)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    officialAppointmentInd: ").append(this.toIndentedString(this.officialAppointmentInd)).append("\n");
        sb.append("    ratingSymbol: ").append(this.toIndentedString(this.ratingSymbol)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        STAR_RATING("STAR_RATING"),
        NUMERIC_RATING("NUMERIC_RATING"),
        PERCENT_RATING("PERCENT_RATING");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum CategoryEnum {
        THIRD_PARTY_REVIEW("THIRD_PARTY_REVIEW"),
        PUBLICATION("PUBLICATION"),
        AWARD("AWARD");

        private String value;

        private CategoryEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CategoryEnum fromValue(String value) {
            for (CategoryEnum b : CategoryEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

