/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release   # Booking API Welcome to the Booking Engine API - A programmer-friendly way to book inventory that was found on our platform. We take great care in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive payment-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 29.59.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.booking.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import travel.wink.sdk.booking.model.SubmitReviewAnswerAuthenticatedEntity;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * SubmitReviewRequestAuthenticatedEntity
 */
@JsonPropertyOrder({
  SubmitReviewRequestAuthenticatedEntity.JSON_PROPERTY_ANSWERS,
  SubmitReviewRequestAuthenticatedEntity.JSON_PROPERTY_MESSAGE_FROM_GUEST,
  SubmitReviewRequestAuthenticatedEntity.JSON_PROPERTY_IMAGE_IDENTIFIER,
  SubmitReviewRequestAuthenticatedEntity.JSON_PROPERTY_TEXT,
  SubmitReviewRequestAuthenticatedEntity.JSON_PROPERTY_ROOM_NUMBER,
  SubmitReviewRequestAuthenticatedEntity.JSON_PROPERTY_ROOM_RATING
})
@JsonTypeName("SubmitReviewRequest_Authenticated_Entity")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-03T09:31:55.273299546+07:00[Asia/Bangkok]")
public class SubmitReviewRequestAuthenticatedEntity {
  public static final String JSON_PROPERTY_ANSWERS = "answers";
  private List<SubmitReviewAnswerAuthenticatedEntity> answers = new ArrayList<>();

  public static final String JSON_PROPERTY_MESSAGE_FROM_GUEST = "messageFromGuest";
  private String messageFromGuest;

  public static final String JSON_PROPERTY_IMAGE_IDENTIFIER = "imageIdentifier";
  private String imageIdentifier;

  public static final String JSON_PROPERTY_TEXT = "text";
  private String text;

  public static final String JSON_PROPERTY_ROOM_NUMBER = "roomNumber";
  private String roomNumber;

  public static final String JSON_PROPERTY_ROOM_RATING = "roomRating";
  private Integer roomRating;

  public SubmitReviewRequestAuthenticatedEntity() {
  }

  public SubmitReviewRequestAuthenticatedEntity answers(List<SubmitReviewAnswerAuthenticatedEntity> answers) {
    
    this.answers = answers;
    return this;
  }

  public SubmitReviewRequestAuthenticatedEntity addAnswersItem(SubmitReviewAnswerAuthenticatedEntity answersItem) {
    if (this.answers == null) {
      this.answers = new ArrayList<>();
    }
    this.answers.add(answersItem);
    return this;
  }

   /**
   * List of user review answers.
   * @return answers
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @Size(min=1,max=2147483647)
  @JsonProperty(JSON_PROPERTY_ANSWERS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<SubmitReviewAnswerAuthenticatedEntity> getAnswers() {
    return answers;
  }


  @JsonProperty(JSON_PROPERTY_ANSWERS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAnswers(List<SubmitReviewAnswerAuthenticatedEntity> answers) {
    this.answers = answers;
  }


  public SubmitReviewRequestAuthenticatedEntity messageFromGuest(String messageFromGuest) {
    
    this.messageFromGuest = messageFromGuest;
    return this;
  }

   /**
   * Private message from guest to the hotel. Is not displayed on property profile.
   * @return messageFromGuest
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MESSAGE_FROM_GUEST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMessageFromGuest() {
    return messageFromGuest;
  }


  @JsonProperty(JSON_PROPERTY_MESSAGE_FROM_GUEST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMessageFromGuest(String messageFromGuest) {
    this.messageFromGuest = messageFromGuest;
  }


  public SubmitReviewRequestAuthenticatedEntity imageIdentifier(String imageIdentifier) {
    
    this.imageIdentifier = imageIdentifier;
    return this;
  }

   /**
   * Reviewer can upload her best picture from the property. Cloudinary image identifier.
   * @return imageIdentifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_IMAGE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getImageIdentifier() {
    return imageIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_IMAGE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setImageIdentifier(String imageIdentifier) {
    this.imageIdentifier = imageIdentifier;
  }


  public SubmitReviewRequestAuthenticatedEntity text(String text) {
    
    this.text = text;
    return this;
  }

   /**
   * Free text record created by traveler
   * @return text
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getText() {
    return text;
  }


  @JsonProperty(JSON_PROPERTY_TEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setText(String text) {
    this.text = text;
  }


  public SubmitReviewRequestAuthenticatedEntity roomNumber(String roomNumber) {
    
    this.roomNumber = roomNumber;
    return this;
  }

   /**
   * Guest&#39;s room number during their stay.
   * @return roomNumber
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ROOM_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRoomNumber() {
    return roomNumber;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomNumber(String roomNumber) {
    this.roomNumber = roomNumber;
  }


  public SubmitReviewRequestAuthenticatedEntity roomRating(Integer roomRating) {
    
    this.roomRating = roomRating;
    return this;
  }

   /**
   * Guest&#39;s room rating
   * @return roomRating
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ROOM_RATING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getRoomRating() {
    return roomRating;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_RATING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomRating(Integer roomRating) {
    this.roomRating = roomRating;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SubmitReviewRequestAuthenticatedEntity submitReviewRequestAuthenticatedEntity = (SubmitReviewRequestAuthenticatedEntity) o;
    return Objects.equals(this.answers, submitReviewRequestAuthenticatedEntity.answers) &&
        Objects.equals(this.messageFromGuest, submitReviewRequestAuthenticatedEntity.messageFromGuest) &&
        Objects.equals(this.imageIdentifier, submitReviewRequestAuthenticatedEntity.imageIdentifier) &&
        Objects.equals(this.text, submitReviewRequestAuthenticatedEntity.text) &&
        Objects.equals(this.roomNumber, submitReviewRequestAuthenticatedEntity.roomNumber) &&
        Objects.equals(this.roomRating, submitReviewRequestAuthenticatedEntity.roomRating);
  }

  @Override
  public int hashCode() {
    return Objects.hash(answers, messageFromGuest, imageIdentifier, text, roomNumber, roomRating);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SubmitReviewRequestAuthenticatedEntity {\n");
    sb.append("    answers: ").append(toIndentedString(answers)).append("\n");
    sb.append("    messageFromGuest: ").append(toIndentedString(messageFromGuest)).append("\n");
    sb.append("    imageIdentifier: ").append(toIndentedString(imageIdentifier)).append("\n");
    sb.append("    text: ").append(toIndentedString(text)).append("\n");
    sb.append("    roomNumber: ").append(toIndentedString(roomNumber)).append("\n");
    sb.append("    roomRating: ").append(toIndentedString(roomRating)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

