/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release   # Booking API Welcome to the Booking Engine API - A programmer-friendly way to book inventory that was found on our platform. We take great care in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive payment-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 29.61.2
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.booking.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import travel.wink.sdk.booking.model.CountryAgent;
import travel.wink.sdk.booking.model.GeoJsonPointAgent;
import travel.wink.sdk.booking.model.SubCountryAgent;
import travel.wink.sdk.booking.model.SubSubCountryAgent;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * GeoNames have been created at [https://geonames.org](https://geonames.org) and contain geographical destinations we use as geoname data to associate travel inventory with a location.
 */
@JsonPropertyOrder({
  GeoNameAgent.JSON_PROPERTY_GEO_NAME_ID,
  GeoNameAgent.JSON_PROPERTY_TYPE,
  GeoNameAgent.JSON_PROPERTY_NAME,
  GeoNameAgent.JSON_PROPERTY_URL_NAME,
  GeoNameAgent.JSON_PROPERTY_ASCII_NAME,
  GeoNameAgent.JSON_PROPERTY_LOCATION,
  GeoNameAgent.JSON_PROPERTY_FEATURE_CODE,
  GeoNameAgent.JSON_PROPERTY_COUNTRY_CODE,
  GeoNameAgent.JSON_PROPERTY_TIMEZONE,
  GeoNameAgent.JSON_PROPERTY_COUNTRY,
  GeoNameAgent.JSON_PROPERTY_SUB_COUNTRY,
  GeoNameAgent.JSON_PROPERTY_SUB_SUB_COUNTRY
})
@JsonTypeName("GeoName_Agent")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T22:28:39.474297034+07:00[Asia/Bangkok]")
public class GeoNameAgent {
  public static final String JSON_PROPERTY_GEO_NAME_ID = "geoNameId";
  private String geoNameId;

  /**
   * GeoName type
   */
  public enum TypeEnum {
    CITY("CITY"),
    
    ISLAND("ISLAND"),
    
    OTHER("OTHER");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_URL_NAME = "urlName";
  private String urlName;

  public static final String JSON_PROPERTY_ASCII_NAME = "asciiName";
  private String asciiName;

  public static final String JSON_PROPERTY_LOCATION = "location";
  private GeoJsonPointAgent location;

  public static final String JSON_PROPERTY_FEATURE_CODE = "featureCode";
  private String featureCode;

  public static final String JSON_PROPERTY_COUNTRY_CODE = "countryCode";
  private String countryCode;

  public static final String JSON_PROPERTY_TIMEZONE = "timezone";
  private String timezone;

  public static final String JSON_PROPERTY_COUNTRY = "country";
  private CountryAgent country;

  public static final String JSON_PROPERTY_SUB_COUNTRY = "subCountry";
  private SubCountryAgent subCountry;

  public static final String JSON_PROPERTY_SUB_SUB_COUNTRY = "subSubCountry";
  private SubSubCountryAgent subSubCountry;

  public GeoNameAgent() {
  }

  public GeoNameAgent geoNameId(String geoNameId) {
    
    this.geoNameId = geoNameId;
    return this;
  }

   /**
   * GeoName identifier
   * @return geoNameId
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getGeoNameId() {
    return geoNameId;
  }


  @JsonProperty(JSON_PROPERTY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGeoNameId(String geoNameId) {
    this.geoNameId = geoNameId;
  }


  public GeoNameAgent type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * GeoName type
   * @return type
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public GeoNameAgent name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Name of city
   * @return name
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
    this.name = name;
  }


  public GeoNameAgent urlName(String urlName) {
    
    this.urlName = urlName;
    return this;
  }

   /**
   * Url name
   * @return urlName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_URL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUrlName() {
    return urlName;
  }


  @JsonProperty(JSON_PROPERTY_URL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUrlName(String urlName) {
    this.urlName = urlName;
  }


  public GeoNameAgent asciiName(String asciiName) {
    
    this.asciiName = asciiName;
    return this;
  }

   /**
   * Ascii name of city
   * @return asciiName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ASCII_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAsciiName() {
    return asciiName;
  }


  @JsonProperty(JSON_PROPERTY_ASCII_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAsciiName(String asciiName) {
    this.asciiName = asciiName;
  }


  public GeoNameAgent location(GeoJsonPointAgent location) {
    
    this.location = location;
    return this;
  }

   /**
   * Get location
   * @return location
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GeoJsonPointAgent getLocation() {
    return location;
  }


  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLocation(GeoJsonPointAgent location) {
    this.location = location;
  }


  public GeoNameAgent featureCode(String featureCode) {
    
    this.featureCode = featureCode;
    return this;
  }

   /**
   * Get featureCode
   * @return featureCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_FEATURE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFeatureCode() {
    return featureCode;
  }


  @JsonProperty(JSON_PROPERTY_FEATURE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFeatureCode(String featureCode) {
    this.featureCode = featureCode;
  }


  public GeoNameAgent countryCode(String countryCode) {
    
    this.countryCode = countryCode;
    return this;
  }

   /**
   * Get countryCode
   * @return countryCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCountryCode() {
    return countryCode;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountryCode(String countryCode) {
    this.countryCode = countryCode;
  }


  public GeoNameAgent timezone(String timezone) {
    
    this.timezone = timezone;
    return this;
  }

   /**
   * Timezone
   * @return timezone
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TIMEZONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTimezone() {
    return timezone;
  }


  @JsonProperty(JSON_PROPERTY_TIMEZONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTimezone(String timezone) {
    this.timezone = timezone;
  }


  public GeoNameAgent country(CountryAgent country) {
    
    this.country = country;
    return this;
  }

   /**
   * Get country
   * @return country
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CountryAgent getCountry() {
    return country;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountry(CountryAgent country) {
    this.country = country;
  }


  public GeoNameAgent subCountry(SubCountryAgent subCountry) {
    
    this.subCountry = subCountry;
    return this;
  }

   /**
   * Get subCountry
   * @return subCountry
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SUB_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SubCountryAgent getSubCountry() {
    return subCountry;
  }


  @JsonProperty(JSON_PROPERTY_SUB_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubCountry(SubCountryAgent subCountry) {
    this.subCountry = subCountry;
  }


  public GeoNameAgent subSubCountry(SubSubCountryAgent subSubCountry) {
    
    this.subSubCountry = subSubCountry;
    return this;
  }

   /**
   * Get subSubCountry
   * @return subSubCountry
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SUB_SUB_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SubSubCountryAgent getSubSubCountry() {
    return subSubCountry;
  }


  @JsonProperty(JSON_PROPERTY_SUB_SUB_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubSubCountry(SubSubCountryAgent subSubCountry) {
    this.subSubCountry = subSubCountry;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GeoNameAgent geoNameAgent = (GeoNameAgent) o;
    return Objects.equals(this.geoNameId, geoNameAgent.geoNameId) &&
        Objects.equals(this.type, geoNameAgent.type) &&
        Objects.equals(this.name, geoNameAgent.name) &&
        Objects.equals(this.urlName, geoNameAgent.urlName) &&
        Objects.equals(this.asciiName, geoNameAgent.asciiName) &&
        Objects.equals(this.location, geoNameAgent.location) &&
        Objects.equals(this.featureCode, geoNameAgent.featureCode) &&
        Objects.equals(this.countryCode, geoNameAgent.countryCode) &&
        Objects.equals(this.timezone, geoNameAgent.timezone) &&
        Objects.equals(this.country, geoNameAgent.country) &&
        Objects.equals(this.subCountry, geoNameAgent.subCountry) &&
        Objects.equals(this.subSubCountry, geoNameAgent.subSubCountry);
  }

  @Override
  public int hashCode() {
    return Objects.hash(geoNameId, type, name, urlName, asciiName, location, featureCode, countryCode, timezone, country, subCountry, subSubCountry);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GeoNameAgent {\n");
    sb.append("    geoNameId: ").append(toIndentedString(geoNameId)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    urlName: ").append(toIndentedString(urlName)).append("\n");
    sb.append("    asciiName: ").append(toIndentedString(asciiName)).append("\n");
    sb.append("    location: ").append(toIndentedString(location)).append("\n");
    sb.append("    featureCode: ").append(toIndentedString(featureCode)).append("\n");
    sb.append("    countryCode: ").append(toIndentedString(countryCode)).append("\n");
    sb.append("    timezone: ").append(toIndentedString(timezone)).append("\n");
    sb.append("    country: ").append(toIndentedString(country)).append("\n");
    sb.append("    subCountry: ").append(toIndentedString(subCountry)).append("\n");
    sb.append("    subSubCountry: ").append(toIndentedString(subSubCountry)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

