/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release   # Booking API Welcome to the Booking Engine API - A programmer-friendly way to book inventory that was found on our platform. We take great care in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive payment-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 29.61.2
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.booking.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Customer preferences
 */
@JsonPropertyOrder({
  PreferencesBooker.JSON_PROPERTY_PROPERTY_LOCATION_PREF,
  PreferencesBooker.JSON_PROPERTY_PROPERTY_TYPE_PREF,
  PreferencesBooker.JSON_PROPERTY_HOTEL_CHAIN_PREF,
  PreferencesBooker.JSON_PROPERTY_PROPERTY_AMENITY_PREF,
  PreferencesBooker.JSON_PROPERTY_RECREATION_SRVC_PREF,
  PreferencesBooker.JSON_PROPERTY_BUSINESS_SRVC_PREF,
  PreferencesBooker.JSON_PROPERTY_SECURITY_FEATURE_PREF,
  PreferencesBooker.JSON_PROPERTY_PHYS_CHAL_FEATURE_PREF,
  PreferencesBooker.JSON_PROPERTY_SMOKING_ALLOWED,
  PreferencesBooker.JSON_PROPERTY_ROOM_LOCATION_PREF,
  PreferencesBooker.JSON_PROPERTY_BED_TYPE_PREF,
  PreferencesBooker.JSON_PROPERTY_FOOD_SRVC_PREF,
  PreferencesBooker.JSON_PROPERTY_ROOM_AMENITY_PREF,
  PreferencesBooker.JSON_PROPERTY_GUEST_TYPE,
  PreferencesBooker.JSON_PROPERTY_MEAL_PREF,
  PreferencesBooker.JSON_PROPERTY_CUISINE_PREF,
  PreferencesBooker.JSON_PROPERTY_INTEREST_PREF,
  PreferencesBooker.JSON_PROPERTY_BEVERAGE_PREF,
  PreferencesBooker.JSON_PROPERTY_FOOD_PREF,
  PreferencesBooker.JSON_PROPERTY_ALLERGIES,
  PreferencesBooker.JSON_PROPERTY_PETS_PREF
})
@JsonTypeName("Preferences_Booker")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T22:28:39.474297034+07:00[Asia/Bangkok]")
public class PreferencesBooker {
  public static final String JSON_PROPERTY_PROPERTY_LOCATION_PREF = "propertyLocationPref";
  private String propertyLocationPref;

  public static final String JSON_PROPERTY_PROPERTY_TYPE_PREF = "propertyTypePref";
  private String propertyTypePref;

  public static final String JSON_PROPERTY_HOTEL_CHAIN_PREF = "hotelChainPref";
  private String hotelChainPref;

  public static final String JSON_PROPERTY_PROPERTY_AMENITY_PREF = "propertyAmenityPref";
  private List<String> propertyAmenityPref;

  public static final String JSON_PROPERTY_RECREATION_SRVC_PREF = "recreationSrvcPref";
  private List<String> recreationSrvcPref;

  public static final String JSON_PROPERTY_BUSINESS_SRVC_PREF = "businessSrvcPref";
  private List<String> businessSrvcPref;

  public static final String JSON_PROPERTY_SECURITY_FEATURE_PREF = "securityFeaturePref";
  private List<String> securityFeaturePref;

  public static final String JSON_PROPERTY_PHYS_CHAL_FEATURE_PREF = "physChalFeaturePref";
  private List<String> physChalFeaturePref;

  public static final String JSON_PROPERTY_SMOKING_ALLOWED = "smokingAllowed";
  private Boolean smokingAllowed;

  public static final String JSON_PROPERTY_ROOM_LOCATION_PREF = "roomLocationPref";
  private String roomLocationPref;

  public static final String JSON_PROPERTY_BED_TYPE_PREF = "bedTypePref";
  private String bedTypePref;

  public static final String JSON_PROPERTY_FOOD_SRVC_PREF = "foodSrvcPref";
  private String foodSrvcPref;

  public static final String JSON_PROPERTY_ROOM_AMENITY_PREF = "roomAmenityPref";
  private List<String> roomAmenityPref;

  public static final String JSON_PROPERTY_GUEST_TYPE = "guestType";
  private String guestType;

  public static final String JSON_PROPERTY_MEAL_PREF = "mealPref";
  private String mealPref;

  public static final String JSON_PROPERTY_CUISINE_PREF = "cuisinePref";
  private String cuisinePref;

  public static final String JSON_PROPERTY_INTEREST_PREF = "interestPref";
  private List<String> interestPref;

  public static final String JSON_PROPERTY_BEVERAGE_PREF = "beveragePref";
  private List<String> beveragePref;

  public static final String JSON_PROPERTY_FOOD_PREF = "foodPref";
  private List<String> foodPref;

  public static final String JSON_PROPERTY_ALLERGIES = "allergies";
  private List<String> allergies;

  public static final String JSON_PROPERTY_PETS_PREF = "petsPref";
  private List<String> petsPref;

  public PreferencesBooker() {
  }

  public PreferencesBooker propertyLocationPref(String propertyLocationPref) {
    
    this.propertyLocationPref = propertyLocationPref;
    return this;
  }

   /**
   * Indicates preference for hotel property locations.
   * @return propertyLocationPref
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PROPERTY_LOCATION_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPropertyLocationPref() {
    return propertyLocationPref;
  }


  @JsonProperty(JSON_PROPERTY_PROPERTY_LOCATION_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPropertyLocationPref(String propertyLocationPref) {
    this.propertyLocationPref = propertyLocationPref;
  }


  public PreferencesBooker propertyTypePref(String propertyTypePref) {
    
    this.propertyTypePref = propertyTypePref;
    return this;
  }

   /**
   * Indicates preference for hotel property types.
   * @return propertyTypePref
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PROPERTY_TYPE_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPropertyTypePref() {
    return propertyTypePref;
  }


  @JsonProperty(JSON_PROPERTY_PROPERTY_TYPE_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPropertyTypePref(String propertyTypePref) {
    this.propertyTypePref = propertyTypePref;
  }


  public PreferencesBooker hotelChainPref(String hotelChainPref) {
    
    this.hotelChainPref = hotelChainPref;
    return this;
  }

   /**
   * Identifies a preferred company by name.
   * @return hotelChainPref
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HOTEL_CHAIN_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getHotelChainPref() {
    return hotelChainPref;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_CHAIN_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelChainPref(String hotelChainPref) {
    this.hotelChainPref = hotelChainPref;
  }


  public PreferencesBooker propertyAmenityPref(List<String> propertyAmenityPref) {
    
    this.propertyAmenityPref = propertyAmenityPref;
    return this;
  }

  public PreferencesBooker addPropertyAmenityPrefItem(String propertyAmenityPrefItem) {
    if (this.propertyAmenityPref == null) {
      this.propertyAmenityPref = new ArrayList<>();
    }
    this.propertyAmenityPref.add(propertyAmenityPrefItem);
    return this;
  }

   /**
   * Indicates preferences for hotel property amenities.
   * @return propertyAmenityPref
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PROPERTY_AMENITY_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getPropertyAmenityPref() {
    return propertyAmenityPref;
  }


  @JsonProperty(JSON_PROPERTY_PROPERTY_AMENITY_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPropertyAmenityPref(List<String> propertyAmenityPref) {
    this.propertyAmenityPref = propertyAmenityPref;
  }


  public PreferencesBooker recreationSrvcPref(List<String> recreationSrvcPref) {
    
    this.recreationSrvcPref = recreationSrvcPref;
    return this;
  }

  public PreferencesBooker addRecreationSrvcPrefItem(String recreationSrvcPrefItem) {
    if (this.recreationSrvcPref == null) {
      this.recreationSrvcPref = new ArrayList<>();
    }
    this.recreationSrvcPref.add(recreationSrvcPrefItem);
    return this;
  }

   /**
   * Indicates preference for the type of recreation services in a hotel
   * @return recreationSrvcPref
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RECREATION_SRVC_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getRecreationSrvcPref() {
    return recreationSrvcPref;
  }


  @JsonProperty(JSON_PROPERTY_RECREATION_SRVC_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecreationSrvcPref(List<String> recreationSrvcPref) {
    this.recreationSrvcPref = recreationSrvcPref;
  }


  public PreferencesBooker businessSrvcPref(List<String> businessSrvcPref) {
    
    this.businessSrvcPref = businessSrvcPref;
    return this;
  }

  public PreferencesBooker addBusinessSrvcPrefItem(String businessSrvcPrefItem) {
    if (this.businessSrvcPref == null) {
      this.businessSrvcPref = new ArrayList<>();
    }
    this.businessSrvcPref.add(businessSrvcPrefItem);
    return this;
  }

   /**
   * Indicates preference for type of business services in a hotel
   * @return businessSrvcPref
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_BUSINESS_SRVC_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getBusinessSrvcPref() {
    return businessSrvcPref;
  }


  @JsonProperty(JSON_PROPERTY_BUSINESS_SRVC_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBusinessSrvcPref(List<String> businessSrvcPref) {
    this.businessSrvcPref = businessSrvcPref;
  }


  public PreferencesBooker securityFeaturePref(List<String> securityFeaturePref) {
    
    this.securityFeaturePref = securityFeaturePref;
    return this;
  }

  public PreferencesBooker addSecurityFeaturePrefItem(String securityFeaturePrefItem) {
    if (this.securityFeaturePref == null) {
      this.securityFeaturePref = new ArrayList<>();
    }
    this.securityFeaturePref.add(securityFeaturePrefItem);
    return this;
  }

   /**
   * Indicates preference of rtype of security features in a hotel
   * @return securityFeaturePref
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SECURITY_FEATURE_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getSecurityFeaturePref() {
    return securityFeaturePref;
  }


  @JsonProperty(JSON_PROPERTY_SECURITY_FEATURE_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSecurityFeaturePref(List<String> securityFeaturePref) {
    this.securityFeaturePref = securityFeaturePref;
  }


  public PreferencesBooker physChalFeaturePref(List<String> physChalFeaturePref) {
    
    this.physChalFeaturePref = physChalFeaturePref;
    return this;
  }

  public PreferencesBooker addPhysChalFeaturePrefItem(String physChalFeaturePrefItem) {
    if (this.physChalFeaturePref == null) {
      this.physChalFeaturePref = new ArrayList<>();
    }
    this.physChalFeaturePref.add(physChalFeaturePrefItem);
    return this;
  }

   /**
   * Indicates preferences for type of features required to meet the needs of persons with physical challenges, disabilities, etc.
   * @return physChalFeaturePref
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PHYS_CHAL_FEATURE_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getPhysChalFeaturePref() {
    return physChalFeaturePref;
  }


  @JsonProperty(JSON_PROPERTY_PHYS_CHAL_FEATURE_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPhysChalFeaturePref(List<String> physChalFeaturePref) {
    this.physChalFeaturePref = physChalFeaturePref;
  }


  public PreferencesBooker smokingAllowed(Boolean smokingAllowed) {
    
    this.smokingAllowed = smokingAllowed;
    return this;
  }

   /**
   * Indicates preference for smooking allowed rooms..
   * @return smokingAllowed
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SMOKING_ALLOWED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSmokingAllowed() {
    return smokingAllowed;
  }


  @JsonProperty(JSON_PROPERTY_SMOKING_ALLOWED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSmokingAllowed(Boolean smokingAllowed) {
    this.smokingAllowed = smokingAllowed;
  }


  public PreferencesBooker roomLocationPref(String roomLocationPref) {
    
    this.roomLocationPref = roomLocationPref;
    return this;
  }

   /**
   * Indicates preference for hotel room locations.
   * @return roomLocationPref
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ROOM_LOCATION_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRoomLocationPref() {
    return roomLocationPref;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_LOCATION_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomLocationPref(String roomLocationPref) {
    this.roomLocationPref = roomLocationPref;
  }


  public PreferencesBooker bedTypePref(String bedTypePref) {
    
    this.bedTypePref = bedTypePref;
    return this;
  }

   /**
   * Indicates preferences for the size and features of hotel bed types.
   * @return bedTypePref
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_BED_TYPE_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBedTypePref() {
    return bedTypePref;
  }


  @JsonProperty(JSON_PROPERTY_BED_TYPE_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBedTypePref(String bedTypePref) {
    this.bedTypePref = bedTypePref;
  }


  public PreferencesBooker foodSrvcPref(String foodSrvcPref) {
    
    this.foodSrvcPref = foodSrvcPref;
    return this;
  }

   /**
   * Indicates preferences for type of food listener facilities in a hotel.
   * @return foodSrvcPref
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_FOOD_SRVC_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFoodSrvcPref() {
    return foodSrvcPref;
  }


  @JsonProperty(JSON_PROPERTY_FOOD_SRVC_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFoodSrvcPref(String foodSrvcPref) {
    this.foodSrvcPref = foodSrvcPref;
  }


  public PreferencesBooker roomAmenityPref(List<String> roomAmenityPref) {
    
    this.roomAmenityPref = roomAmenityPref;
    return this;
  }

  public PreferencesBooker addRoomAmenityPrefItem(String roomAmenityPrefItem) {
    if (this.roomAmenityPref == null) {
      this.roomAmenityPref = new ArrayList<>();
    }
    this.roomAmenityPref.add(roomAmenityPrefItem);
    return this;
  }

   /**
   * Indicates preferences for hotel room amenities.
   * @return roomAmenityPref
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ROOM_AMENITY_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getRoomAmenityPref() {
    return roomAmenityPref;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_AMENITY_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomAmenityPref(List<String> roomAmenityPref) {
    this.roomAmenityPref = roomAmenityPref;
  }


  public PreferencesBooker guestType(String guestType) {
    
    this.guestType = guestType;
    return this;
  }

   /**
   * Guest type
   * @return guestType
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_GUEST_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getGuestType() {
    return guestType;
  }


  @JsonProperty(JSON_PROPERTY_GUEST_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGuestType(String guestType) {
    this.guestType = guestType;
  }


  public PreferencesBooker mealPref(String mealPref) {
    
    this.mealPref = mealPref;
    return this;
  }

   /**
   * Indicates meal preference.
   * @return mealPref
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MEAL_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMealPref() {
    return mealPref;
  }


  @JsonProperty(JSON_PROPERTY_MEAL_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMealPref(String mealPref) {
    this.mealPref = mealPref;
  }


  public PreferencesBooker cuisinePref(String cuisinePref) {
    
    this.cuisinePref = cuisinePref;
    return this;
  }

   /**
   * Indicates cuisine preference.
   * @return cuisinePref
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CUISINE_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCuisinePref() {
    return cuisinePref;
  }


  @JsonProperty(JSON_PROPERTY_CUISINE_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCuisinePref(String cuisinePref) {
    this.cuisinePref = cuisinePref;
  }


  public PreferencesBooker interestPref(List<String> interestPref) {
    
    this.interestPref = interestPref;
    return this;
  }

  public PreferencesBooker addInterestPrefItem(String interestPrefItem) {
    if (this.interestPref == null) {
      this.interestPref = new ArrayList<>();
    }
    this.interestPref.add(interestPrefItem);
    return this;
  }

   /**
   * Indicates interest preference
   * @return interestPref
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INTEREST_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getInterestPref() {
    return interestPref;
  }


  @JsonProperty(JSON_PROPERTY_INTEREST_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInterestPref(List<String> interestPref) {
    this.interestPref = interestPref;
  }


  public PreferencesBooker beveragePref(List<String> beveragePref) {
    
    this.beveragePref = beveragePref;
    return this;
  }

  public PreferencesBooker addBeveragePrefItem(String beveragePrefItem) {
    if (this.beveragePref == null) {
      this.beveragePref = new ArrayList<>();
    }
    this.beveragePref.add(beveragePrefItem);
    return this;
  }

   /**
   * Indicates beverage preference.
   * @return beveragePref
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_BEVERAGE_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getBeveragePref() {
    return beveragePref;
  }


  @JsonProperty(JSON_PROPERTY_BEVERAGE_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBeveragePref(List<String> beveragePref) {
    this.beveragePref = beveragePref;
  }


  public PreferencesBooker foodPref(List<String> foodPref) {
    
    this.foodPref = foodPref;
    return this;
  }

  public PreferencesBooker addFoodPrefItem(String foodPrefItem) {
    if (this.foodPref == null) {
      this.foodPref = new ArrayList<>();
    }
    this.foodPref.add(foodPrefItem);
    return this;
  }

   /**
   * Indicates food preference.
   * @return foodPref
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_FOOD_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getFoodPref() {
    return foodPref;
  }


  @JsonProperty(JSON_PROPERTY_FOOD_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFoodPref(List<String> foodPref) {
    this.foodPref = foodPref;
  }


  public PreferencesBooker allergies(List<String> allergies) {
    
    this.allergies = allergies;
    return this;
  }

  public PreferencesBooker addAllergiesItem(String allergiesItem) {
    if (this.allergies == null) {
      this.allergies = new ArrayList<>();
    }
    this.allergies.add(allergiesItem);
    return this;
  }

   /**
   * Indicates allergies
   * @return allergies
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ALLERGIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getAllergies() {
    return allergies;
  }


  @JsonProperty(JSON_PROPERTY_ALLERGIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAllergies(List<String> allergies) {
    this.allergies = allergies;
  }


  public PreferencesBooker petsPref(List<String> petsPref) {
    
    this.petsPref = petsPref;
    return this;
  }

  public PreferencesBooker addPetsPrefItem(String petsPrefItem) {
    if (this.petsPref == null) {
      this.petsPref = new ArrayList<>();
    }
    this.petsPref.add(petsPrefItem);
    return this;
  }

   /**
   * Indicates pet preferences
   * @return petsPref
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PETS_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getPetsPref() {
    return petsPref;
  }


  @JsonProperty(JSON_PROPERTY_PETS_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPetsPref(List<String> petsPref) {
    this.petsPref = petsPref;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PreferencesBooker preferencesBooker = (PreferencesBooker) o;
    return Objects.equals(this.propertyLocationPref, preferencesBooker.propertyLocationPref) &&
        Objects.equals(this.propertyTypePref, preferencesBooker.propertyTypePref) &&
        Objects.equals(this.hotelChainPref, preferencesBooker.hotelChainPref) &&
        Objects.equals(this.propertyAmenityPref, preferencesBooker.propertyAmenityPref) &&
        Objects.equals(this.recreationSrvcPref, preferencesBooker.recreationSrvcPref) &&
        Objects.equals(this.businessSrvcPref, preferencesBooker.businessSrvcPref) &&
        Objects.equals(this.securityFeaturePref, preferencesBooker.securityFeaturePref) &&
        Objects.equals(this.physChalFeaturePref, preferencesBooker.physChalFeaturePref) &&
        Objects.equals(this.smokingAllowed, preferencesBooker.smokingAllowed) &&
        Objects.equals(this.roomLocationPref, preferencesBooker.roomLocationPref) &&
        Objects.equals(this.bedTypePref, preferencesBooker.bedTypePref) &&
        Objects.equals(this.foodSrvcPref, preferencesBooker.foodSrvcPref) &&
        Objects.equals(this.roomAmenityPref, preferencesBooker.roomAmenityPref) &&
        Objects.equals(this.guestType, preferencesBooker.guestType) &&
        Objects.equals(this.mealPref, preferencesBooker.mealPref) &&
        Objects.equals(this.cuisinePref, preferencesBooker.cuisinePref) &&
        Objects.equals(this.interestPref, preferencesBooker.interestPref) &&
        Objects.equals(this.beveragePref, preferencesBooker.beveragePref) &&
        Objects.equals(this.foodPref, preferencesBooker.foodPref) &&
        Objects.equals(this.allergies, preferencesBooker.allergies) &&
        Objects.equals(this.petsPref, preferencesBooker.petsPref);
  }

  @Override
  public int hashCode() {
    return Objects.hash(propertyLocationPref, propertyTypePref, hotelChainPref, propertyAmenityPref, recreationSrvcPref, businessSrvcPref, securityFeaturePref, physChalFeaturePref, smokingAllowed, roomLocationPref, bedTypePref, foodSrvcPref, roomAmenityPref, guestType, mealPref, cuisinePref, interestPref, beveragePref, foodPref, allergies, petsPref);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PreferencesBooker {\n");
    sb.append("    propertyLocationPref: ").append(toIndentedString(propertyLocationPref)).append("\n");
    sb.append("    propertyTypePref: ").append(toIndentedString(propertyTypePref)).append("\n");
    sb.append("    hotelChainPref: ").append(toIndentedString(hotelChainPref)).append("\n");
    sb.append("    propertyAmenityPref: ").append(toIndentedString(propertyAmenityPref)).append("\n");
    sb.append("    recreationSrvcPref: ").append(toIndentedString(recreationSrvcPref)).append("\n");
    sb.append("    businessSrvcPref: ").append(toIndentedString(businessSrvcPref)).append("\n");
    sb.append("    securityFeaturePref: ").append(toIndentedString(securityFeaturePref)).append("\n");
    sb.append("    physChalFeaturePref: ").append(toIndentedString(physChalFeaturePref)).append("\n");
    sb.append("    smokingAllowed: ").append(toIndentedString(smokingAllowed)).append("\n");
    sb.append("    roomLocationPref: ").append(toIndentedString(roomLocationPref)).append("\n");
    sb.append("    bedTypePref: ").append(toIndentedString(bedTypePref)).append("\n");
    sb.append("    foodSrvcPref: ").append(toIndentedString(foodSrvcPref)).append("\n");
    sb.append("    roomAmenityPref: ").append(toIndentedString(roomAmenityPref)).append("\n");
    sb.append("    guestType: ").append(toIndentedString(guestType)).append("\n");
    sb.append("    mealPref: ").append(toIndentedString(mealPref)).append("\n");
    sb.append("    cuisinePref: ").append(toIndentedString(cuisinePref)).append("\n");
    sb.append("    interestPref: ").append(toIndentedString(interestPref)).append("\n");
    sb.append("    beveragePref: ").append(toIndentedString(beveragePref)).append("\n");
    sb.append("    foodPref: ").append(toIndentedString(foodPref)).append("\n");
    sb.append("    allergies: ").append(toIndentedString(allergies)).append("\n");
    sb.append("    petsPref: ").append(toIndentedString(petsPref)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

