/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md   # Booking API Welcome to the Booking Engine API - A programmer-friendly way to book inventory that was found on our platform. We take great care in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive payment-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 29.62.1
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.booking.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import travel.wink.sdk.booking.model.ChildBooker;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Room Configuration
 */
@JsonPropertyOrder({
  RoomConfigurationBooker.JSON_PROPERTY_ADULTS,
  RoomConfigurationBooker.JSON_PROPERTY_CHILDREN,
  RoomConfigurationBooker.JSON_PROPERTY_GET_NUMBER_OF_ADULTS_DETERMINED_BY_HOTEL_POLICY,
  RoomConfigurationBooker.JSON_PROPERTY_GET_NUMBER_OF_CHILDREN_DETERMINED_BY_HOTEL_POLICY
})
@JsonTypeName("RoomConfiguration_Booker")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-12T17:00:09.652883422+07:00[Asia/Bangkok]")
public class RoomConfigurationBooker {
  public static final String JSON_PROPERTY_ADULTS = "adults";
  private Integer adults = 1;

  public static final String JSON_PROPERTY_CHILDREN = "children";
  private List<ChildBooker> children;

  public static final String JSON_PROPERTY_GET_NUMBER_OF_ADULTS_DETERMINED_BY_HOTEL_POLICY = "getNumberOfAdultsDeterminedByHotelPolicy";
  private Integer getNumberOfAdultsDeterminedByHotelPolicy;

  public static final String JSON_PROPERTY_GET_NUMBER_OF_CHILDREN_DETERMINED_BY_HOTEL_POLICY = "getNumberOfChildrenDeterminedByHotelPolicy";
  private Integer getNumberOfChildrenDeterminedByHotelPolicy;

  public RoomConfigurationBooker() {
  }

  public RoomConfigurationBooker adults(Integer adults) {
    
    this.adults = adults;
    return this;
  }

   /**
   * Number of adults
   * minimum: 1
   * @return adults
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @Min(1)
  @JsonProperty(JSON_PROPERTY_ADULTS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getAdults() {
    return adults;
  }


  @JsonProperty(JSON_PROPERTY_ADULTS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAdults(Integer adults) {
    this.adults = adults;
  }


  public RoomConfigurationBooker children(List<ChildBooker> children) {
    
    this.children = children;
    return this;
  }

  public RoomConfigurationBooker addChildrenItem(ChildBooker childrenItem) {
    if (this.children == null) {
      this.children = new ArrayList<>();
    }
    this.children.add(childrenItem);
    return this;
  }

   /**
   * Children configurations
   * @return children
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CHILDREN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ChildBooker> getChildren() {
    return children;
  }


  @JsonProperty(JSON_PROPERTY_CHILDREN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChildren(List<ChildBooker> children) {
    this.children = children;
  }


  public RoomConfigurationBooker getNumberOfAdultsDeterminedByHotelPolicy(Integer getNumberOfAdultsDeterminedByHotelPolicy) {
    
    this.getNumberOfAdultsDeterminedByHotelPolicy = getNumberOfAdultsDeterminedByHotelPolicy;
    return this;
  }

   /**
   * Get getNumberOfAdultsDeterminedByHotelPolicy
   * @return getNumberOfAdultsDeterminedByHotelPolicy
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_GET_NUMBER_OF_ADULTS_DETERMINED_BY_HOTEL_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getGetNumberOfAdultsDeterminedByHotelPolicy() {
    return getNumberOfAdultsDeterminedByHotelPolicy;
  }


  @JsonProperty(JSON_PROPERTY_GET_NUMBER_OF_ADULTS_DETERMINED_BY_HOTEL_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGetNumberOfAdultsDeterminedByHotelPolicy(Integer getNumberOfAdultsDeterminedByHotelPolicy) {
    this.getNumberOfAdultsDeterminedByHotelPolicy = getNumberOfAdultsDeterminedByHotelPolicy;
  }


  public RoomConfigurationBooker getNumberOfChildrenDeterminedByHotelPolicy(Integer getNumberOfChildrenDeterminedByHotelPolicy) {
    
    this.getNumberOfChildrenDeterminedByHotelPolicy = getNumberOfChildrenDeterminedByHotelPolicy;
    return this;
  }

   /**
   * Get getNumberOfChildrenDeterminedByHotelPolicy
   * @return getNumberOfChildrenDeterminedByHotelPolicy
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_GET_NUMBER_OF_CHILDREN_DETERMINED_BY_HOTEL_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getGetNumberOfChildrenDeterminedByHotelPolicy() {
    return getNumberOfChildrenDeterminedByHotelPolicy;
  }


  @JsonProperty(JSON_PROPERTY_GET_NUMBER_OF_CHILDREN_DETERMINED_BY_HOTEL_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGetNumberOfChildrenDeterminedByHotelPolicy(Integer getNumberOfChildrenDeterminedByHotelPolicy) {
    this.getNumberOfChildrenDeterminedByHotelPolicy = getNumberOfChildrenDeterminedByHotelPolicy;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RoomConfigurationBooker roomConfigurationBooker = (RoomConfigurationBooker) o;
    return Objects.equals(this.adults, roomConfigurationBooker.adults) &&
        Objects.equals(this.children, roomConfigurationBooker.children) &&
        Objects.equals(this.getNumberOfAdultsDeterminedByHotelPolicy, roomConfigurationBooker.getNumberOfAdultsDeterminedByHotelPolicy) &&
        Objects.equals(this.getNumberOfChildrenDeterminedByHotelPolicy, roomConfigurationBooker.getNumberOfChildrenDeterminedByHotelPolicy);
  }

  @Override
  public int hashCode() {
    return Objects.hash(adults, children, getNumberOfAdultsDeterminedByHotelPolicy, getNumberOfChildrenDeterminedByHotelPolicy);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RoomConfigurationBooker {\n");
    sb.append("    adults: ").append(toIndentedString(adults)).append("\n");
    sb.append("    children: ").append(toIndentedString(children)).append("\n");
    sb.append("    getNumberOfAdultsDeterminedByHotelPolicy: ").append(toIndentedString(getNumberOfAdultsDeterminedByHotelPolicy)).append("\n");
    sb.append("    getNumberOfChildrenDeterminedByHotelPolicy: ").append(toIndentedString(getNumberOfChildrenDeterminedByHotelPolicy)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

