/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.booking.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;
import travel.wink.sdk.booking.invoker.ApiClient;
import travel.wink.sdk.booking.model.ReviewTemplateAuthenticatedEntity;
import travel.wink.sdk.booking.model.ReviewViewAuthenticatedEntity;
import travel.wink.sdk.booking.model.SubmitReviewRequestAuthenticatedEntity;

public class ReviewApi {
    private ApiClient apiClient;

    public ReviewApi() {
        this(new ApiClient());
    }

    @Autowired
    public ReviewApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec populateReviewRequestCreation(String bookingIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (bookingIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingIdentifier' when calling populateReview", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("bookingIdentifier", bookingIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<ReviewTemplateAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ReviewTemplateAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/booking/{bookingIdentifier}/review/questions", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<ReviewTemplateAuthenticatedEntity> populateReview(String bookingIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ReviewTemplateAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ReviewTemplateAuthenticatedEntity>(this){};
        return this.populateReviewRequestCreation(bookingIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<ReviewTemplateAuthenticatedEntity>> populateReviewWithHttpInfo(String bookingIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ReviewTemplateAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ReviewTemplateAuthenticatedEntity>(this){};
        return this.populateReviewRequestCreation(bookingIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec populateReviewWithResponseSpec(String bookingIdentifier, String winkVersion) throws WebClientResponseException {
        return this.populateReviewRequestCreation(bookingIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec submitReviewRequestCreation(String bookingIdentifier, SubmitReviewRequestAuthenticatedEntity submitReviewRequestAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        SubmitReviewRequestAuthenticatedEntity postBody = submitReviewRequestAuthenticatedEntity;
        if (bookingIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingIdentifier' when calling submitReview", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (submitReviewRequestAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'submitReviewRequestAuthenticatedEntity' when calling submitReview", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("bookingIdentifier", bookingIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<ReviewViewAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ReviewViewAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/booking/{bookingIdentifier}/review", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<ReviewViewAuthenticatedEntity> submitReview(String bookingIdentifier, SubmitReviewRequestAuthenticatedEntity submitReviewRequestAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ReviewViewAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ReviewViewAuthenticatedEntity>(this){};
        return this.submitReviewRequestCreation(bookingIdentifier, submitReviewRequestAuthenticatedEntity, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<ReviewViewAuthenticatedEntity>> submitReviewWithHttpInfo(String bookingIdentifier, SubmitReviewRequestAuthenticatedEntity submitReviewRequestAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ReviewViewAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ReviewViewAuthenticatedEntity>(this){};
        return this.submitReviewRequestCreation(bookingIdentifier, submitReviewRequestAuthenticatedEntity, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec submitReviewWithResponseSpec(String bookingIdentifier, SubmitReviewRequestAuthenticatedEntity submitReviewRequestAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        return this.submitReviewRequestCreation(bookingIdentifier, submitReviewRequestAuthenticatedEntity, winkVersion);
    }
}

