/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md   # Booking API Welcome to the Booking Engine API - A programmer-friendly way to book inventory that was found on our platform. We take great care in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive payment-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 29.65.4
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.booking.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.booking.model.EngineConfigurationThemeBooker;
import travel.wink.sdk.booking.model.GeoNameBooker;
import travel.wink.sdk.booking.model.RoomConfigurationBooker;
import travel.wink.sdk.booking.model.SimpleMultimediaBooker;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Which engine configuration record did the entity application used to facilitate in making this booking happen.
 */
@JsonPropertyOrder({
  EngineConfigurationBookingReportBooker.JSON_PROPERTY_IDENTIFIER,
  EngineConfigurationBookingReportBooker.JSON_PROPERTY_NAME,
  EngineConfigurationBookingReportBooker.JSON_PROPERTY_USER_IDENTIFIER,
  EngineConfigurationBookingReportBooker.JSON_PROPERTY_OWNER_IDENTIFIER,
  EngineConfigurationBookingReportBooker.JSON_PROPERTY_OWNER_NAME,
  EngineConfigurationBookingReportBooker.JSON_PROPERTY_SUB_TYPE,
  EngineConfigurationBookingReportBooker.JSON_PROPERTY_DEFAULT_CURRENCY,
  EngineConfigurationBookingReportBooker.JSON_PROPERTY_DEFAULT_LANGUAGE,
  EngineConfigurationBookingReportBooker.JSON_PROPERTY_LOGOS,
  EngineConfigurationBookingReportBooker.JSON_PROPERTY_HOSTED_BOOKING_ENGINE_URL,
  EngineConfigurationBookingReportBooker.JSON_PROPERTY_SELF_HOSTED,
  EngineConfigurationBookingReportBooker.JSON_PROPERTY_THEME_COLORS,
  EngineConfigurationBookingReportBooker.JSON_PROPERTY_NUMBER_OF_ADVANCE_DAYS,
  EngineConfigurationBookingReportBooker.JSON_PROPERTY_NUMBER_OF_STAY_DAYS,
  EngineConfigurationBookingReportBooker.JSON_PROPERTY_START_DATE,
  EngineConfigurationBookingReportBooker.JSON_PROPERTY_END_DATE,
  EngineConfigurationBookingReportBooker.JSON_PROPERTY_ROOM_CONFIGURATIONS,
  EngineConfigurationBookingReportBooker.JSON_PROPERTY_USE_DAYS,
  EngineConfigurationBookingReportBooker.JSON_PROPERTY_PROMOTIONAL_CODES,
  EngineConfigurationBookingReportBooker.JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_PROPERTY,
  EngineConfigurationBookingReportBooker.JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_BOOKER,
  EngineConfigurationBookingReportBooker.JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_CHANNEL_MANAGER,
  EngineConfigurationBookingReportBooker.JSON_PROPERTY_WC_BOOK_CLICK_ACTION,
  EngineConfigurationBookingReportBooker.JSON_PROPERTY_CITY,
  EngineConfigurationBookingReportBooker.JSON_PROPERTY_SHOW_UNAVAILABLE_CARD,
  EngineConfigurationBookingReportBooker.JSON_PROPERTY_SHOW_RANKINGS
})
@JsonTypeName("EngineConfigurationBookingReport_Booker")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-23T16:37:50.377767878+07:00[Asia/Bangkok]")
public class EngineConfigurationBookingReportBooker {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private UUID identifier;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_USER_IDENTIFIER = "userIdentifier";
  private UUID userIdentifier;

  public static final String JSON_PROPERTY_OWNER_IDENTIFIER = "ownerIdentifier";
  private UUID ownerIdentifier;

  public static final String JSON_PROPERTY_OWNER_NAME = "ownerName";
  private String ownerName;

  /**
   * Sales channel sub-type.
   */
  public enum SubTypeEnum {
    DIRECT("DIRECT"),
    
    APPLICATION("APPLICATION"),
    
    HOTEL("HOTEL"),
    
    TRAVELIKO("TRAVELIKO"),
    
    CORPORATE("CORPORATE"),
    
    TRAVEL_AGENT("TRAVEL_AGENT"),
    
    INFLUENCER("INFLUENCER"),
    
    BLOGGER("BLOGGER"),
    
    DESTINATION("DESTINATION"),
    
    CHANNEL_MANAGER("CHANNEL_MANAGER"),
    
    PROPERTY_MANAGEMENT_SYSTEM("PROPERTY_MANAGEMENT_SYSTEM"),
    
    CENTRAL_RESERVATION_SYSTEM("CENTRAL_RESERVATION_SYSTEM"),
    
    GOOGLE_HOTEL_API("GOOGLE_HOTEL_API"),
    
    MANAGEMENT_COMPANY("MANAGEMENT_COMPANY"),
    
    CHAIN("CHAIN"),
    
    BRAND("BRAND"),
    
    EVENT_ORGANIZER("EVENT_ORGANIZER");

    private String value;

    SubTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static SubTypeEnum fromValue(String value) {
      for (SubTypeEnum b : SubTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SUB_TYPE = "subType";
  private SubTypeEnum subType;

  public static final String JSON_PROPERTY_DEFAULT_CURRENCY = "defaultCurrency";
  private String defaultCurrency = "USD";

  public static final String JSON_PROPERTY_DEFAULT_LANGUAGE = "defaultLanguage";
  private String defaultLanguage = "en";

  public static final String JSON_PROPERTY_LOGOS = "logos";
  private List<SimpleMultimediaBooker> logos;

  public static final String JSON_PROPERTY_HOSTED_BOOKING_ENGINE_URL = "hostedBookingEngineUrl";
  private String hostedBookingEngineUrl = "https://ota.wink.travel";

  public static final String JSON_PROPERTY_SELF_HOSTED = "selfHosted";
  private Boolean selfHosted = false;

  public static final String JSON_PROPERTY_THEME_COLORS = "themeColors";
  private EngineConfigurationThemeBooker themeColors;

  public static final String JSON_PROPERTY_NUMBER_OF_ADVANCE_DAYS = "numberOfAdvanceDays";
  private Integer numberOfAdvanceDays;

  public static final String JSON_PROPERTY_NUMBER_OF_STAY_DAYS = "numberOfStayDays";
  private Integer numberOfStayDays;

  public static final String JSON_PROPERTY_START_DATE = "startDate";
  private LocalDate startDate;

  public static final String JSON_PROPERTY_END_DATE = "endDate";
  private LocalDate endDate;

  public static final String JSON_PROPERTY_ROOM_CONFIGURATIONS = "roomConfigurations";
  private List<RoomConfigurationBooker> roomConfigurations;

  public static final String JSON_PROPERTY_USE_DAYS = "useDays";
  private Boolean useDays;

  public static final String JSON_PROPERTY_PROMOTIONAL_CODES = "promotionalCodes";
  private List<String> promotionalCodes;

  public static final String JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_PROPERTY = "sendBookingNotificationEmailsToProperty";
  private Boolean sendBookingNotificationEmailsToProperty = true;

  public static final String JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_BOOKER = "sendBookingNotificationEmailsToBooker";
  private Boolean sendBookingNotificationEmailsToBooker = true;

  public static final String JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_CHANNEL_MANAGER = "sendBookingNotificationEmailsToChannelManager";
  private Boolean sendBookingNotificationEmailsToChannelManager = true;

  /**
   * Action to complete once a user clicks on the CTA button on inventory.
   */
  public enum WcBookClickActionEnum {
    FORWARD_TO_IBE("FORWARD_TO_IBE"),
    
    IBE_MODAL("IBE_MODAL");

    private String value;

    WcBookClickActionEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static WcBookClickActionEnum fromValue(String value) {
      for (WcBookClickActionEnum b : WcBookClickActionEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_WC_BOOK_CLICK_ACTION = "wcBookClickAction";
  private WcBookClickActionEnum wcBookClickAction;

  public static final String JSON_PROPERTY_CITY = "city";
  private GeoNameBooker city;

  public static final String JSON_PROPERTY_SHOW_UNAVAILABLE_CARD = "showUnavailableCard";
  private Boolean showUnavailableCard;

  public static final String JSON_PROPERTY_SHOW_RANKINGS = "showRankings";
  private Boolean showRankings;

  public EngineConfigurationBookingReportBooker() {
  }

  public EngineConfigurationBookingReportBooker identifier(UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique engine configuration identifier
   * @return identifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifier(UUID identifier) {
    this.identifier = identifier;
  }


  public EngineConfigurationBookingReportBooker name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Engine configuration name
   * @return name
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public EngineConfigurationBookingReportBooker userIdentifier(UUID userIdentifier) {
    
    this.userIdentifier = userIdentifier;
    return this;
  }

   /**
   * Authenticated user identifier
   * @return userIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_USER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getUserIdentifier() {
    return userIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_USER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUserIdentifier(UUID userIdentifier) {
    this.userIdentifier = userIdentifier;
  }


  public EngineConfigurationBookingReportBooker ownerIdentifier(UUID ownerIdentifier) {
    
    this.ownerIdentifier = ownerIdentifier;
    return this;
  }

   /**
   * Engine configuration record creator identifier
   * @return ownerIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getOwnerIdentifier() {
    return ownerIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setOwnerIdentifier(UUID ownerIdentifier) {
    this.ownerIdentifier = ownerIdentifier;
  }


  public EngineConfigurationBookingReportBooker ownerName(String ownerName) {
    
    this.ownerName = ownerName;
    return this;
  }

   /**
   * Name of company owner.
   * @return ownerName
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_OWNER_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getOwnerName() {
    return ownerName;
  }


  @JsonProperty(JSON_PROPERTY_OWNER_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setOwnerName(String ownerName) {
    this.ownerName = ownerName;
  }


  public EngineConfigurationBookingReportBooker subType(SubTypeEnum subType) {
    
    this.subType = subType;
    return this;
  }

   /**
   * Sales channel sub-type.
   * @return subType
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_SUB_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public SubTypeEnum getSubType() {
    return subType;
  }


  @JsonProperty(JSON_PROPERTY_SUB_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSubType(SubTypeEnum subType) {
    this.subType = subType;
  }


  public EngineConfigurationBookingReportBooker defaultCurrency(String defaultCurrency) {
    
    this.defaultCurrency = defaultCurrency;
    return this;
  }

   /**
   * Control which currency your users see prices in initially.
   * @return defaultCurrency
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DEFAULT_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDefaultCurrency() {
    return defaultCurrency;
  }


  @JsonProperty(JSON_PROPERTY_DEFAULT_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDefaultCurrency(String defaultCurrency) {
    this.defaultCurrency = defaultCurrency;
  }


  public EngineConfigurationBookingReportBooker defaultLanguage(String defaultLanguage) {
    
    this.defaultLanguage = defaultLanguage;
    return this;
  }

   /**
   * Control which language your users see text in initially.
   * @return defaultLanguage
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DEFAULT_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDefaultLanguage() {
    return defaultLanguage;
  }


  @JsonProperty(JSON_PROPERTY_DEFAULT_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDefaultLanguage(String defaultLanguage) {
    this.defaultLanguage = defaultLanguage;
  }


  public EngineConfigurationBookingReportBooker logos(List<SimpleMultimediaBooker> logos) {
    
    this.logos = logos;
    return this;
  }

  public EngineConfigurationBookingReportBooker addLogosItem(SimpleMultimediaBooker logosItem) {
    if (this.logos == null) {
      this.logos = new ArrayList<>();
    }
    this.logos.add(logosItem);
    return this;
  }

   /**
   * Customize booking confirmation emails by adding a custom logo to your configuration.
   * @return logos
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LOGOS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SimpleMultimediaBooker> getLogos() {
    return logos;
  }


  @JsonProperty(JSON_PROPERTY_LOGOS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLogos(List<SimpleMultimediaBooker> logos) {
    this.logos = logos;
  }


  public EngineConfigurationBookingReportBooker hostedBookingEngineUrl(String hostedBookingEngineUrl) {
    
    this.hostedBookingEngineUrl = hostedBookingEngineUrl;
    return this;
  }

   /**
   * If you are self-hosting our booking engine, let us know where it is hosted. Note: This url needs to be secured with SSL.
   * @return hostedBookingEngineUrl
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HOSTED_BOOKING_ENGINE_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getHostedBookingEngineUrl() {
    return hostedBookingEngineUrl;
  }


  @JsonProperty(JSON_PROPERTY_HOSTED_BOOKING_ENGINE_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHostedBookingEngineUrl(String hostedBookingEngineUrl) {
    this.hostedBookingEngineUrl = hostedBookingEngineUrl;
  }


  public EngineConfigurationBookingReportBooker selfHosted(Boolean selfHosted) {
    
    this.selfHosted = selfHosted;
    return this;
  }

   /**
   * Flag to indicate you are self-hosting our booking engine and not using our default booking engine url.
   * @return selfHosted
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SELF_HOSTED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSelfHosted() {
    return selfHosted;
  }


  @JsonProperty(JSON_PROPERTY_SELF_HOSTED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSelfHosted(Boolean selfHosted) {
    this.selfHosted = selfHosted;
  }


  public EngineConfigurationBookingReportBooker themeColors(EngineConfigurationThemeBooker themeColors) {
    
    this.themeColors = themeColors;
    return this;
  }

   /**
   * Get themeColors
   * @return themeColors
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_THEME_COLORS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public EngineConfigurationThemeBooker getThemeColors() {
    return themeColors;
  }


  @JsonProperty(JSON_PROPERTY_THEME_COLORS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setThemeColors(EngineConfigurationThemeBooker themeColors) {
    this.themeColors = themeColors;
  }


  public EngineConfigurationBookingReportBooker numberOfAdvanceDays(Integer numberOfAdvanceDays) {
    
    this.numberOfAdvanceDays = numberOfAdvanceDays;
    return this;
  }

   /**
   * You can control the initial itinerary date used to retrieve travel inventory prices. You can do it in one of two ways: 1. Dynamically set the date by indicating how long and how many days in advance (this field), of today&#39;s date, you want to display prices for. 2. Set a fixed date to display prices for. Option 1 is the most shared. Option 2 is for when you want to create a new customization and apply it to a specific event that occurs on a specific date. If you don&#39;t use either of these options, the itinerary will default to today&#39;s date with one night stay. ONLY populate this field if you want to control the itinerary date. Also, leave &#x60;startDate&#x60; and &#x60;endDate&#x60; empty.
   * @return numberOfAdvanceDays
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_NUMBER_OF_ADVANCE_DAYS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getNumberOfAdvanceDays() {
    return numberOfAdvanceDays;
  }


  @JsonProperty(JSON_PROPERTY_NUMBER_OF_ADVANCE_DAYS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNumberOfAdvanceDays(Integer numberOfAdvanceDays) {
    this.numberOfAdvanceDays = numberOfAdvanceDays;
  }


  public EngineConfigurationBookingReportBooker numberOfStayDays(Integer numberOfStayDays) {
    
    this.numberOfStayDays = numberOfStayDays;
    return this;
  }

   /**
   * You can control the initial itinerary date used to retrieve travel inventory prices. You can do it in one of two ways: 1. Dynamically set the date by indicating how long (this field) and how many days in advance, of today&#39;s date, you want to display prices for. 2. Set a fixed date to display prices for. Option 1 is the most shared. Option 2 is for when you want to create a new customization and apply it to a specific event that occurs on a specific date. If you don&#39;t use either of these options, the itinerary will default to today&#39;s date with one night stay. ONLY populate this field if you want to control the itinerary date. Also, leave &#x60;startDate&#x60; and &#x60;endDate&#x60; empty.
   * @return numberOfStayDays
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_NUMBER_OF_STAY_DAYS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getNumberOfStayDays() {
    return numberOfStayDays;
  }


  @JsonProperty(JSON_PROPERTY_NUMBER_OF_STAY_DAYS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNumberOfStayDays(Integer numberOfStayDays) {
    this.numberOfStayDays = numberOfStayDays;
  }


  public EngineConfigurationBookingReportBooker startDate(LocalDate startDate) {
    
    this.startDate = startDate;
    return this;
  }

   /**
   * Set a fixed itinerary start date. ONLY populate this field if you want to fix the itinerary date. Also, leave &#x60;numberOfAdvanceDays&#x60; and &#x60;numberOfStayDays&#x60; empty.
   * @return startDate
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getStartDate() {
    return startDate;
  }


  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStartDate(LocalDate startDate) {
    this.startDate = startDate;
  }


  public EngineConfigurationBookingReportBooker endDate(LocalDate endDate) {
    
    this.endDate = endDate;
    return this;
  }

   /**
   * Set a fixed itinerary end date ONLY populate this field if you want to fix the itinerary date. Also, leave &#x60;numberOfAdvanceDays&#x60; and &#x60;numberOfStayDays&#x60; empty.
   * @return endDate
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getEndDate() {
    return endDate;
  }


  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEndDate(LocalDate endDate) {
    this.endDate = endDate;
  }


  public EngineConfigurationBookingReportBooker roomConfigurations(List<RoomConfigurationBooker> roomConfigurations) {
    
    this.roomConfigurations = roomConfigurations;
    return this;
  }

  public EngineConfigurationBookingReportBooker addRoomConfigurationsItem(RoomConfigurationBooker roomConfigurationsItem) {
    if (this.roomConfigurations == null) {
      this.roomConfigurations = new ArrayList<>();
    }
    this.roomConfigurations.add(roomConfigurationsItem);
    return this;
  }

   /**
   * Control how many adults / children will be staying and how many rooms. Defaults to: One room, two adults.
   * @return roomConfigurations
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ROOM_CONFIGURATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<RoomConfigurationBooker> getRoomConfigurations() {
    return roomConfigurations;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_CONFIGURATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomConfigurations(List<RoomConfigurationBooker> roomConfigurations) {
    this.roomConfigurations = roomConfigurations;
  }


  public EngineConfigurationBookingReportBooker useDays(Boolean useDays) {
    
    this.useDays = useDays;
    return this;
  }

   /**
   * if true, we use numberOfAdvanceDays / numberOfStayDays properties - false, we use startDate / endDate
   * @return useDays
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_USE_DAYS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getUseDays() {
    return useDays;
  }


  @JsonProperty(JSON_PROPERTY_USE_DAYS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUseDays(Boolean useDays) {
    this.useDays = useDays;
  }


  public EngineConfigurationBookingReportBooker promotionalCodes(List<String> promotionalCodes) {
    
    this.promotionalCodes = promotionalCodes;
    return this;
  }

  public EngineConfigurationBookingReportBooker addPromotionalCodesItem(String promotionalCodesItem) {
    if (this.promotionalCodes == null) {
      this.promotionalCodes = new ArrayList<>();
    }
    this.promotionalCodes.add(promotionalCodesItem);
    return this;
  }

   /**
   * If you&#39;ve received special promotional codes from suppliers to give to your audience, you can choose to bake these code directly into the price by entering them here.
   * @return promotionalCodes
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PROMOTIONAL_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getPromotionalCodes() {
    return promotionalCodes;
  }


  @JsonProperty(JSON_PROPERTY_PROMOTIONAL_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPromotionalCodes(List<String> promotionalCodes) {
    this.promotionalCodes = promotionalCodes;
  }


  public EngineConfigurationBookingReportBooker sendBookingNotificationEmailsToProperty(Boolean sendBookingNotificationEmailsToProperty) {
    
    this.sendBookingNotificationEmailsToProperty = sendBookingNotificationEmailsToProperty;
    return this;
  }

   /**
   * An integrator can choose to disable outgoing emails to properties because they want to do that themselves.
   * @return sendBookingNotificationEmailsToProperty
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_PROPERTY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSendBookingNotificationEmailsToProperty() {
    return sendBookingNotificationEmailsToProperty;
  }


  @JsonProperty(JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_PROPERTY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSendBookingNotificationEmailsToProperty(Boolean sendBookingNotificationEmailsToProperty) {
    this.sendBookingNotificationEmailsToProperty = sendBookingNotificationEmailsToProperty;
  }


  public EngineConfigurationBookingReportBooker sendBookingNotificationEmailsToBooker(Boolean sendBookingNotificationEmailsToBooker) {
    
    this.sendBookingNotificationEmailsToBooker = sendBookingNotificationEmailsToBooker;
    return this;
  }

   /**
   * An integrator can choose to disable outgoing emails to users because they want to do that themselves.
   * @return sendBookingNotificationEmailsToBooker
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_BOOKER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSendBookingNotificationEmailsToBooker() {
    return sendBookingNotificationEmailsToBooker;
  }


  @JsonProperty(JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_BOOKER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSendBookingNotificationEmailsToBooker(Boolean sendBookingNotificationEmailsToBooker) {
    this.sendBookingNotificationEmailsToBooker = sendBookingNotificationEmailsToBooker;
  }


  public EngineConfigurationBookingReportBooker sendBookingNotificationEmailsToChannelManager(Boolean sendBookingNotificationEmailsToChannelManager) {
    
    this.sendBookingNotificationEmailsToChannelManager = sendBookingNotificationEmailsToChannelManager;
    return this;
  }

   /**
   * An integrator can choose to disable notifying the property&#39;s channel manager. Note: This should ONLY be done for testing.
   * @return sendBookingNotificationEmailsToChannelManager
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_CHANNEL_MANAGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSendBookingNotificationEmailsToChannelManager() {
    return sendBookingNotificationEmailsToChannelManager;
  }


  @JsonProperty(JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_CHANNEL_MANAGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSendBookingNotificationEmailsToChannelManager(Boolean sendBookingNotificationEmailsToChannelManager) {
    this.sendBookingNotificationEmailsToChannelManager = sendBookingNotificationEmailsToChannelManager;
  }


  public EngineConfigurationBookingReportBooker wcBookClickAction(WcBookClickActionEnum wcBookClickAction) {
    
    this.wcBookClickAction = wcBookClickAction;
    return this;
  }

   /**
   * Action to complete once a user clicks on the CTA button on inventory.
   * @return wcBookClickAction
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_WC_BOOK_CLICK_ACTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public WcBookClickActionEnum getWcBookClickAction() {
    return wcBookClickAction;
  }


  @JsonProperty(JSON_PROPERTY_WC_BOOK_CLICK_ACTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWcBookClickAction(WcBookClickActionEnum wcBookClickAction) {
    this.wcBookClickAction = wcBookClickAction;
  }


  public EngineConfigurationBookingReportBooker city(GeoNameBooker city) {
    
    this.city = city;
    return this;
  }

   /**
   * Get city
   * @return city
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GeoNameBooker getCity() {
    return city;
  }


  @JsonProperty(JSON_PROPERTY_CITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCity(GeoNameBooker city) {
    this.city = city;
  }


  public EngineConfigurationBookingReportBooker showUnavailableCard(Boolean showUnavailableCard) {
    
    this.showUnavailableCard = showUnavailableCard;
    return this;
  }

   /**
   * Show unavailable inventory card when inventory not currently for sale. Otherwise, it displays a normal card but without the price.
   * @return showUnavailableCard
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SHOW_UNAVAILABLE_CARD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowUnavailableCard() {
    return showUnavailableCard;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_UNAVAILABLE_CARD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowUnavailableCard(Boolean showUnavailableCard) {
    this.showUnavailableCard = showUnavailableCard;
  }


  public EngineConfigurationBookingReportBooker showRankings(Boolean showRankings) {
    
    this.showRankings = showRankings;
    return this;
  }

   /**
   * Whether to display rankings (lifestyle, eco score and reviews) on hotel landing page.
   * @return showRankings
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SHOW_RANKINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowRankings() {
    return showRankings;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_RANKINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowRankings(Boolean showRankings) {
    this.showRankings = showRankings;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    EngineConfigurationBookingReportBooker engineConfigurationBookingReportBooker = (EngineConfigurationBookingReportBooker) o;
    return Objects.equals(this.identifier, engineConfigurationBookingReportBooker.identifier) &&
        Objects.equals(this.name, engineConfigurationBookingReportBooker.name) &&
        Objects.equals(this.userIdentifier, engineConfigurationBookingReportBooker.userIdentifier) &&
        Objects.equals(this.ownerIdentifier, engineConfigurationBookingReportBooker.ownerIdentifier) &&
        Objects.equals(this.ownerName, engineConfigurationBookingReportBooker.ownerName) &&
        Objects.equals(this.subType, engineConfigurationBookingReportBooker.subType) &&
        Objects.equals(this.defaultCurrency, engineConfigurationBookingReportBooker.defaultCurrency) &&
        Objects.equals(this.defaultLanguage, engineConfigurationBookingReportBooker.defaultLanguage) &&
        Objects.equals(this.logos, engineConfigurationBookingReportBooker.logos) &&
        Objects.equals(this.hostedBookingEngineUrl, engineConfigurationBookingReportBooker.hostedBookingEngineUrl) &&
        Objects.equals(this.selfHosted, engineConfigurationBookingReportBooker.selfHosted) &&
        Objects.equals(this.themeColors, engineConfigurationBookingReportBooker.themeColors) &&
        Objects.equals(this.numberOfAdvanceDays, engineConfigurationBookingReportBooker.numberOfAdvanceDays) &&
        Objects.equals(this.numberOfStayDays, engineConfigurationBookingReportBooker.numberOfStayDays) &&
        Objects.equals(this.startDate, engineConfigurationBookingReportBooker.startDate) &&
        Objects.equals(this.endDate, engineConfigurationBookingReportBooker.endDate) &&
        Objects.equals(this.roomConfigurations, engineConfigurationBookingReportBooker.roomConfigurations) &&
        Objects.equals(this.useDays, engineConfigurationBookingReportBooker.useDays) &&
        Objects.equals(this.promotionalCodes, engineConfigurationBookingReportBooker.promotionalCodes) &&
        Objects.equals(this.sendBookingNotificationEmailsToProperty, engineConfigurationBookingReportBooker.sendBookingNotificationEmailsToProperty) &&
        Objects.equals(this.sendBookingNotificationEmailsToBooker, engineConfigurationBookingReportBooker.sendBookingNotificationEmailsToBooker) &&
        Objects.equals(this.sendBookingNotificationEmailsToChannelManager, engineConfigurationBookingReportBooker.sendBookingNotificationEmailsToChannelManager) &&
        Objects.equals(this.wcBookClickAction, engineConfigurationBookingReportBooker.wcBookClickAction) &&
        Objects.equals(this.city, engineConfigurationBookingReportBooker.city) &&
        Objects.equals(this.showUnavailableCard, engineConfigurationBookingReportBooker.showUnavailableCard) &&
        Objects.equals(this.showRankings, engineConfigurationBookingReportBooker.showRankings);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, name, userIdentifier, ownerIdentifier, ownerName, subType, defaultCurrency, defaultLanguage, logos, hostedBookingEngineUrl, selfHosted, themeColors, numberOfAdvanceDays, numberOfStayDays, startDate, endDate, roomConfigurations, useDays, promotionalCodes, sendBookingNotificationEmailsToProperty, sendBookingNotificationEmailsToBooker, sendBookingNotificationEmailsToChannelManager, wcBookClickAction, city, showUnavailableCard, showRankings);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class EngineConfigurationBookingReportBooker {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    userIdentifier: ").append(toIndentedString(userIdentifier)).append("\n");
    sb.append("    ownerIdentifier: ").append(toIndentedString(ownerIdentifier)).append("\n");
    sb.append("    ownerName: ").append(toIndentedString(ownerName)).append("\n");
    sb.append("    subType: ").append(toIndentedString(subType)).append("\n");
    sb.append("    defaultCurrency: ").append(toIndentedString(defaultCurrency)).append("\n");
    sb.append("    defaultLanguage: ").append(toIndentedString(defaultLanguage)).append("\n");
    sb.append("    logos: ").append(toIndentedString(logos)).append("\n");
    sb.append("    hostedBookingEngineUrl: ").append(toIndentedString(hostedBookingEngineUrl)).append("\n");
    sb.append("    selfHosted: ").append(toIndentedString(selfHosted)).append("\n");
    sb.append("    themeColors: ").append(toIndentedString(themeColors)).append("\n");
    sb.append("    numberOfAdvanceDays: ").append(toIndentedString(numberOfAdvanceDays)).append("\n");
    sb.append("    numberOfStayDays: ").append(toIndentedString(numberOfStayDays)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    roomConfigurations: ").append(toIndentedString(roomConfigurations)).append("\n");
    sb.append("    useDays: ").append(toIndentedString(useDays)).append("\n");
    sb.append("    promotionalCodes: ").append(toIndentedString(promotionalCodes)).append("\n");
    sb.append("    sendBookingNotificationEmailsToProperty: ").append(toIndentedString(sendBookingNotificationEmailsToProperty)).append("\n");
    sb.append("    sendBookingNotificationEmailsToBooker: ").append(toIndentedString(sendBookingNotificationEmailsToBooker)).append("\n");
    sb.append("    sendBookingNotificationEmailsToChannelManager: ").append(toIndentedString(sendBookingNotificationEmailsToChannelManager)).append("\n");
    sb.append("    wcBookClickAction: ").append(toIndentedString(wcBookClickAction)).append("\n");
    sb.append("    city: ").append(toIndentedString(city)).append("\n");
    sb.append("    showUnavailableCard: ").append(toIndentedString(showUnavailableCard)).append("\n");
    sb.append("    showRankings: ").append(toIndentedString(showRankings)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

