/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release   # Booking API Welcome to the Booking Engine API - A programmer-friendly way to book inventory that was found on our platform. We take great care in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive payment-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 29.8.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.booking.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import travel.wink.sdk.booking.model.BookingUserBooker;
import travel.wink.sdk.booking.model.CustomMonetaryAmountBooker;
import travel.wink.sdk.booking.model.ItineraryBooker;
import travel.wink.sdk.booking.model.RawBeneficiaryBooker;
import travel.wink.sdk.booking.model.RawDailyRateBooker;
import travel.wink.sdk.booking.model.SupplierContractItemPolicyBooker;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * RawSupplierContractItemBooker
 */
@JsonPropertyOrder({
  RawSupplierContractItemBooker.JSON_PROPERTY_USER,
  RawSupplierContractItemBooker.JSON_PROPERTY_NAME_IN_ENGLISH,
  RawSupplierContractItemBooker.JSON_PROPERTY_DESCRIPTION_IN_ENGLISH,
  RawSupplierContractItemBooker.JSON_PROPERTY_PRICE,
  RawSupplierContractItemBooker.JSON_PROPERTY_ITINERARY,
  RawSupplierContractItemBooker.JSON_PROPERTY_PRICING_TYPE,
  RawSupplierContractItemBooker.JSON_PROPERTY_TYPE,
  RawSupplierContractItemBooker.JSON_PROPERTY_PER_USE_QUANTITY,
  RawSupplierContractItemBooker.JSON_PROPERTY_BENEFICIARY_LIST,
  RawSupplierContractItemBooker.JSON_PROPERTY_PAYABLE,
  RawSupplierContractItemBooker.JSON_PROPERTY_POLICY,
  RawSupplierContractItemBooker.JSON_PROPERTY_EXTERNAL_IDENTIFIER,
  RawSupplierContractItemBooker.JSON_PROPERTY_DAILY_RATE_LIST,
  RawSupplierContractItemBooker.JSON_PROPERTY_TOTAL_PRICE
})
@JsonTypeName("RawSupplierContractItem_Booker")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-08-22T15:43:17.859372622+07:00[Asia/Bangkok]")
public class RawSupplierContractItemBooker {
  public static final String JSON_PROPERTY_USER = "user";
  private BookingUserBooker user;

  public static final String JSON_PROPERTY_NAME_IN_ENGLISH = "nameInEnglish";
  private String nameInEnglish;

  public static final String JSON_PROPERTY_DESCRIPTION_IN_ENGLISH = "descriptionInEnglish";
  private String descriptionInEnglish;

  public static final String JSON_PROPERTY_PRICE = "price";
  private CustomMonetaryAmountBooker price;

  public static final String JSON_PROPERTY_ITINERARY = "itinerary";
  private ItineraryBooker itinerary;

  /**
   * Gets or Sets pricingType
   */
  public enum PricingTypeEnum {
    STAY("PER_STAY"),
    
    DAY("PER_DAY"),
    
    NIGHT("PER_NIGHT"),
    
    USE("PER_USE"),
    
    HOUR("PER_HOUR"),
    
    PERSON("PER_PERSON"),
    
    PERSON_PER_NIGHT("PER_PERSON_PER_NIGHT"),
    
    PERSON_PER_HOUR("PER_PERSON_PER_HOUR"),
    
    ADULT("PER_ADULT"),
    
    ADULT_PER_NIGHT("PER_ADULT_PER_NIGHT"),
    
    ADULT_PER_HOUR("PER_ADULT_PER_HOUR"),
    
    CHILD("PER_CHILD"),
    
    CHILD_PER_NIGHT("PER_CHILD_PER_NIGHT"),
    
    CHILD_PER_HOUR("PER_CHILD_PER_HOUR");

    private String value;

    PricingTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PricingTypeEnum fromValue(String value) {
      for (PricingTypeEnum b : PricingTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PRICING_TYPE = "pricingType";
  private PricingTypeEnum pricingType;

  /**
   * Gets or Sets type
   */
  public enum TypeEnum {
    LODGING("LODGING"),
    
    RAIL("RAIL"),
    
    AIR("AIR"),
    
    CAR("CAR"),
    
    CRUISE("CRUISE"),
    
    PACKAGE("PACKAGE"),
    
    ADD_ON("ADD_ON"),
    
    RENTAL("RENTAL"),
    
    EXPERIENCE("EXPERIENCE"),
    
    ANCILLARY_BOOKING("ANCILLARY_BOOKING"),
    
    ANCILLARY_FEE("ANCILLARY_FEE");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_PER_USE_QUANTITY = "perUseQuantity";
  private Integer perUseQuantity;

  public static final String JSON_PROPERTY_BENEFICIARY_LIST = "beneficiaryList";
  private List<RawBeneficiaryBooker> beneficiaryList = new ArrayList<>();

  /**
   * Gets or Sets payable
   */
  public enum PayableEnum {
    IMMEDIATE("IMMEDIATE"),
    
    ARRIVAL("ARRIVAL"),
    
    DEPARTURE("DEPARTURE"),
    
    AGENT("AGENT");

    private String value;

    PayableEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PayableEnum fromValue(String value) {
      for (PayableEnum b : PayableEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PAYABLE = "payable";
  private PayableEnum payable;

  public static final String JSON_PROPERTY_POLICY = "policy";
  private SupplierContractItemPolicyBooker policy;

  public static final String JSON_PROPERTY_EXTERNAL_IDENTIFIER = "externalIdentifier";
  private String externalIdentifier;

  public static final String JSON_PROPERTY_DAILY_RATE_LIST = "dailyRateList";
  private List<RawDailyRateBooker> dailyRateList = new ArrayList<>();

  public static final String JSON_PROPERTY_TOTAL_PRICE = "totalPrice";
  private CustomMonetaryAmountBooker totalPrice;

  public RawSupplierContractItemBooker() {
  }

  public RawSupplierContractItemBooker user(BookingUserBooker user) {
    
    this.user = user;
    return this;
  }

   /**
   * Get user
   * @return user
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_USER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BookingUserBooker getUser() {
    return user;
  }


  @JsonProperty(JSON_PROPERTY_USER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUser(BookingUserBooker user) {
    this.user = user;
  }


  public RawSupplierContractItemBooker nameInEnglish(String nameInEnglish) {
    
    this.nameInEnglish = nameInEnglish;
    return this;
  }

   /**
   * Get nameInEnglish
   * @return nameInEnglish
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_NAME_IN_ENGLISH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getNameInEnglish() {
    return nameInEnglish;
  }


  @JsonProperty(JSON_PROPERTY_NAME_IN_ENGLISH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setNameInEnglish(String nameInEnglish) {
    this.nameInEnglish = nameInEnglish;
  }


  public RawSupplierContractItemBooker descriptionInEnglish(String descriptionInEnglish) {
    
    this.descriptionInEnglish = descriptionInEnglish;
    return this;
  }

   /**
   * Get descriptionInEnglish
   * @return descriptionInEnglish
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_DESCRIPTION_IN_ENGLISH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDescriptionInEnglish() {
    return descriptionInEnglish;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION_IN_ENGLISH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDescriptionInEnglish(String descriptionInEnglish) {
    this.descriptionInEnglish = descriptionInEnglish;
  }


  public RawSupplierContractItemBooker price(CustomMonetaryAmountBooker price) {
    
    this.price = price;
    return this;
  }

   /**
   * Get price
   * @return price
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public CustomMonetaryAmountBooker getPrice() {
    return price;
  }


  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPrice(CustomMonetaryAmountBooker price) {
    this.price = price;
  }


  public RawSupplierContractItemBooker itinerary(ItineraryBooker itinerary) {
    
    this.itinerary = itinerary;
    return this;
  }

   /**
   * Get itinerary
   * @return itinerary
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ITINERARY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ItineraryBooker getItinerary() {
    return itinerary;
  }


  @JsonProperty(JSON_PROPERTY_ITINERARY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setItinerary(ItineraryBooker itinerary) {
    this.itinerary = itinerary;
  }


  public RawSupplierContractItemBooker pricingType(PricingTypeEnum pricingType) {
    
    this.pricingType = pricingType;
    return this;
  }

   /**
   * Get pricingType
   * @return pricingType
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_PRICING_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public PricingTypeEnum getPricingType() {
    return pricingType;
  }


  @JsonProperty(JSON_PROPERTY_PRICING_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPricingType(PricingTypeEnum pricingType) {
    this.pricingType = pricingType;
  }


  public RawSupplierContractItemBooker type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public RawSupplierContractItemBooker perUseQuantity(Integer perUseQuantity) {
    
    this.perUseQuantity = perUseQuantity;
    return this;
  }

   /**
   * Get perUseQuantity
   * @return perUseQuantity
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PER_USE_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPerUseQuantity() {
    return perUseQuantity;
  }


  @JsonProperty(JSON_PROPERTY_PER_USE_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPerUseQuantity(Integer perUseQuantity) {
    this.perUseQuantity = perUseQuantity;
  }


  public RawSupplierContractItemBooker beneficiaryList(List<RawBeneficiaryBooker> beneficiaryList) {
    
    this.beneficiaryList = beneficiaryList;
    return this;
  }

  public RawSupplierContractItemBooker addBeneficiaryListItem(RawBeneficiaryBooker beneficiaryListItem) {
    this.beneficiaryList.add(beneficiaryListItem);
    return this;
  }

   /**
   * Get beneficiaryList
   * @return beneficiaryList
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @Size(min=1,max=2147483647)
  @JsonProperty(JSON_PROPERTY_BENEFICIARY_LIST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<RawBeneficiaryBooker> getBeneficiaryList() {
    return beneficiaryList;
  }


  @JsonProperty(JSON_PROPERTY_BENEFICIARY_LIST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBeneficiaryList(List<RawBeneficiaryBooker> beneficiaryList) {
    this.beneficiaryList = beneficiaryList;
  }


  public RawSupplierContractItemBooker payable(PayableEnum payable) {
    
    this.payable = payable;
    return this;
  }

   /**
   * Get payable
   * @return payable
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_PAYABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public PayableEnum getPayable() {
    return payable;
  }


  @JsonProperty(JSON_PROPERTY_PAYABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPayable(PayableEnum payable) {
    this.payable = payable;
  }


  public RawSupplierContractItemBooker policy(SupplierContractItemPolicyBooker policy) {
    
    this.policy = policy;
    return this;
  }

   /**
   * Get policy
   * @return policy
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SupplierContractItemPolicyBooker getPolicy() {
    return policy;
  }


  @JsonProperty(JSON_PROPERTY_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPolicy(SupplierContractItemPolicyBooker policy) {
    this.policy = policy;
  }


  public RawSupplierContractItemBooker externalIdentifier(String externalIdentifier) {
    
    this.externalIdentifier = externalIdentifier;
    return this;
  }

   /**
   * Get externalIdentifier
   * @return externalIdentifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_EXTERNAL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getExternalIdentifier() {
    return externalIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_EXTERNAL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExternalIdentifier(String externalIdentifier) {
    this.externalIdentifier = externalIdentifier;
  }


  public RawSupplierContractItemBooker dailyRateList(List<RawDailyRateBooker> dailyRateList) {
    
    this.dailyRateList = dailyRateList;
    return this;
  }

  public RawSupplierContractItemBooker addDailyRateListItem(RawDailyRateBooker dailyRateListItem) {
    if (this.dailyRateList == null) {
      this.dailyRateList = new ArrayList<>();
    }
    this.dailyRateList.add(dailyRateListItem);
    return this;
  }

   /**
   * Get dailyRateList
   * @return dailyRateList
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_DAILY_RATE_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<RawDailyRateBooker> getDailyRateList() {
    return dailyRateList;
  }


  @JsonProperty(JSON_PROPERTY_DAILY_RATE_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDailyRateList(List<RawDailyRateBooker> dailyRateList) {
    this.dailyRateList = dailyRateList;
  }


  public RawSupplierContractItemBooker totalPrice(CustomMonetaryAmountBooker totalPrice) {
    
    this.totalPrice = totalPrice;
    return this;
  }

   /**
   * Get totalPrice
   * @return totalPrice
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmountBooker getTotalPrice() {
    return totalPrice;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalPrice(CustomMonetaryAmountBooker totalPrice) {
    this.totalPrice = totalPrice;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RawSupplierContractItemBooker rawSupplierContractItemBooker = (RawSupplierContractItemBooker) o;
    return Objects.equals(this.user, rawSupplierContractItemBooker.user) &&
        Objects.equals(this.nameInEnglish, rawSupplierContractItemBooker.nameInEnglish) &&
        Objects.equals(this.descriptionInEnglish, rawSupplierContractItemBooker.descriptionInEnglish) &&
        Objects.equals(this.price, rawSupplierContractItemBooker.price) &&
        Objects.equals(this.itinerary, rawSupplierContractItemBooker.itinerary) &&
        Objects.equals(this.pricingType, rawSupplierContractItemBooker.pricingType) &&
        Objects.equals(this.type, rawSupplierContractItemBooker.type) &&
        Objects.equals(this.perUseQuantity, rawSupplierContractItemBooker.perUseQuantity) &&
        Objects.equals(this.beneficiaryList, rawSupplierContractItemBooker.beneficiaryList) &&
        Objects.equals(this.payable, rawSupplierContractItemBooker.payable) &&
        Objects.equals(this.policy, rawSupplierContractItemBooker.policy) &&
        Objects.equals(this.externalIdentifier, rawSupplierContractItemBooker.externalIdentifier) &&
        Objects.equals(this.dailyRateList, rawSupplierContractItemBooker.dailyRateList) &&
        Objects.equals(this.totalPrice, rawSupplierContractItemBooker.totalPrice);
  }

  @Override
  public int hashCode() {
    return Objects.hash(user, nameInEnglish, descriptionInEnglish, price, itinerary, pricingType, type, perUseQuantity, beneficiaryList, payable, policy, externalIdentifier, dailyRateList, totalPrice);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RawSupplierContractItemBooker {\n");
    sb.append("    user: ").append(toIndentedString(user)).append("\n");
    sb.append("    nameInEnglish: ").append(toIndentedString(nameInEnglish)).append("\n");
    sb.append("    descriptionInEnglish: ").append(toIndentedString(descriptionInEnglish)).append("\n");
    sb.append("    price: ").append(toIndentedString(price)).append("\n");
    sb.append("    itinerary: ").append(toIndentedString(itinerary)).append("\n");
    sb.append("    pricingType: ").append(toIndentedString(pricingType)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    perUseQuantity: ").append(toIndentedString(perUseQuantity)).append("\n");
    sb.append("    beneficiaryList: ").append(toIndentedString(beneficiaryList)).append("\n");
    sb.append("    payable: ").append(toIndentedString(payable)).append("\n");
    sb.append("    policy: ").append(toIndentedString(policy)).append("\n");
    sb.append("    externalIdentifier: ").append(toIndentedString(externalIdentifier)).append("\n");
    sb.append("    dailyRateList: ").append(toIndentedString(dailyRateList)).append("\n");
    sb.append("    totalPrice: ").append(toIndentedString(totalPrice)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

