/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release   # Booking API Welcome to the Booking Engine API - A programmer-friendly way to book inventory that was found on our platform. We take great care in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive payment-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 29.8.8
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.booking.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.booking.model.BookingContractItemAgent;
import travel.wink.sdk.booking.model.BookingContractPaymentDetailsAgent;
import travel.wink.sdk.booking.model.CustomMonetaryAmount;
import travel.wink.sdk.booking.model.QuoteAgent;
import travel.wink.sdk.booking.model.RefundAgent;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Booking contract created by TripPay
 */
@JsonPropertyOrder({
  BookingContractAgent.JSON_PROPERTY_BOOKING_CONTRACT_IDENTIFIER,
  BookingContractAgent.JSON_PROPERTY_CREATED_DATE,
  BookingContractAgent.JSON_PROPERTY_LAST_UPDATE,
  BookingContractAgent.JSON_PROPERTY_IP_ADDRESS,
  BookingContractAgent.JSON_PROPERTY_TRACE_ID,
  BookingContractAgent.JSON_PROPERTY_SOURCE_URL,
  BookingContractAgent.JSON_PROPERTY_IDENTIFIER,
  BookingContractAgent.JSON_PROPERTY_SUPPLIER_IDENTIFIER,
  BookingContractAgent.JSON_PROPERTY_SUPPLIER_NAME,
  BookingContractAgent.JSON_PROPERTY_DISPLAY_PRICE_QUOTE,
  BookingContractAgent.JSON_PROPERTY_SUPPLIER_PRICE_QUOTE,
  BookingContractAgent.JSON_PROPERTY_INTERNAL_PRICE_QUOTE,
  BookingContractAgent.JSON_PROPERTY_CAPTURE_PRICE_QUOTE,
  BookingContractAgent.JSON_PROPERTY_ITEM_LIST,
  BookingContractAgent.JSON_PROPERTY_EXTERNAL_SUPPLIER_IDENTIFIER,
  BookingContractAgent.JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE,
  BookingContractAgent.JSON_PROPERTY_PAYMENT,
  BookingContractAgent.JSON_PROPERTY_CANCELLED,
  BookingContractAgent.JSON_PROPERTY_CANCELLED_ON,
  BookingContractAgent.JSON_PROPERTY_CANCELLER,
  BookingContractAgent.JSON_PROPERTY_CANCELLATION_TYPE,
  BookingContractAgent.JSON_PROPERTY_CANCELLER_USER_IDENTIFIER,
  BookingContractAgent.JSON_PROPERTY_CANCEL_REASON,
  BookingContractAgent.JSON_PROPERTY_FUNDS_PROCESSED,
  BookingContractAgent.JSON_PROPERTY_REFUNDS,
  BookingContractAgent.JSON_PROPERTY_SOURCE_CURRENCY,
  BookingContractAgent.JSON_PROPERTY_DISPLAY_CURRENCY,
  BookingContractAgent.JSON_PROPERTY_SUPPLIER_CURRENCY,
  BookingContractAgent.JSON_PROPERTY_INTERNAL_CURRENCY,
  BookingContractAgent.JSON_PROPERTY_CAPTURE_CURRENCY,
  BookingContractAgent.JSON_PROPERTY_SOURCE_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_DISPLAY_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_SUPPLIER_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_INTERNAL_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_CAPTURE_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_SOURCE_AMOUNT_REFUND_MODIFIER,
  BookingContractAgent.JSON_PROPERTY_DISPLAY_AMOUNT_REFUND_MODIFIER,
  BookingContractAgent.JSON_PROPERTY_SUPPLIER_AMOUNT_REFUND_MODIFIER,
  BookingContractAgent.JSON_PROPERTY_INTERNAL_AMOUNT_REFUND_MODIFIER,
  BookingContractAgent.JSON_PROPERTY_CAPTURE_AMOUNT_REFUND_MODIFIER,
  BookingContractAgent.JSON_PROPERTY_NET_SOURCE_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_DISPLAY_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_SUPPLIER_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_INTERNAL_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_CAPTURE_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_TOTAL_TOKENS_EARNED,
  BookingContractAgent.JSON_PROPERTY_NET_TOTAL_FEES_SUPPLIER_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_SUPPLIER_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_TOTAL_FEES_SUPPLIER_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_SUPPLIER_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_SUPPLIER_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_SUPPLIER_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_COMMISSIONABLE_TOTAL_SUPPLIER_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_SUPPLIER_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER,
  BookingContractAgent.JSON_PROPERTY_CANCELLABLE_BY_TRAVELER,
  BookingContractAgent.JSON_PROPERTY_CANCELLABLE_WITH_NO_CHARGES,
  BookingContractAgent.JSON_PROPERTY_IS_CANCELLABLE_WITH_POTENTIAL_CHARGES,
  BookingContractAgent.JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_SOURCE_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_CAPTURE_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_DISPLAY_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_INTERNAL_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_SOURCE_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_CAPTURE_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_DISPLAY_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_INTERNAL_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_TOTAL_FEES_SOURCE_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_TOTAL_FEES_CAPTURE_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_TOTAL_FEES_DISPLAY_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_TOTAL_FEES_INTERNAL_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_SOURCE_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_CAPTURE_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_DISPLAY_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_INTERNAL_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_TOTAL_SALES_SOURCE_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_TOTAL_SALES_CAPTURE_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_TOTAL_SALES_DISPLAY_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_TOTAL_SALES_SUPPLIER_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_TOTAL_SALES_INTERNAL_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_COMMISSIONABLE_TOTAL_SOURCE_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_COMMISSIONABLE_TOTAL_CAPTURE_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_COMMISSIONABLE_TOTAL_DISPLAY_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_COMMISSIONABLE_TOTAL_INTERNAL_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_SOURCE_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_CAPTURE_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_DISPLAY_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_INTERNAL_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_TOTAL_FEES_SOURCE_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_TOTAL_FEES_CAPTURE_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_TOTAL_FEES_DISPLAY_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_TOTAL_FEES_INTERNAL_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_SOURCE_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_CAPTURE_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_DISPLAY_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_INTERNAL_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_TOTAL_SALES_SOURCE_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_TOTAL_SALES_CAPTURE_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_TOTAL_SALES_DISPLAY_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_TOTAL_SALES_SUPPLIER_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_TOTAL_SALES_INTERNAL_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_FUNDS_AVAILABLE_DATE,
  BookingContractAgent.JSON_PROPERTY_TOTAL_FEES_IN_PERCENT,
  BookingContractAgent.JSON_PROPERTY_TOTAL_COMMISSIONS_IN_PERCENT,
  BookingContractAgent.JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_IN_PERCENT_WITH_REFUND,
  BookingContractAgent.JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_IN_PERCENT,
  BookingContractAgent.JSON_PROPERTY_HAS_SUCCESSFUL_REFUNDS,
  BookingContractAgent.JSON_PROPERTY_HAS_PENDING_REFUNDS,
  BookingContractAgent.JSON_PROPERTY_HAS_FAILED_REFUNDS,
  BookingContractAgent.JSON_PROPERTY_HAS_REFUNDS,
  BookingContractAgent.JSON_PROPERTY_ORIGINAL_COMMISSIONS_IN_PERCENT,
  BookingContractAgent.JSON_PROPERTY_ORIGINAL_FEES_IN_PERCENT,
  BookingContractAgent.JSON_PROPERTY_TOTAL_COMMISSIONS_IN_PERCENT_WITH_REFUND,
  BookingContractAgent.JSON_PROPERTY_TOTAL_FEES_IN_PERCENT_WITH_REFUND,
  BookingContractAgent.JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_IN_PERCENT_WITH_REFUND,
  BookingContractAgent.JSON_PROPERTY_LODGING,
  BookingContractAgent.JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_IN_PERCENT
})
@JsonTypeName("BookingContract_Agent")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-08-27T09:55:01.659494054+07:00[Asia/Bangkok]")
public class BookingContractAgent {
  public static final String JSON_PROPERTY_BOOKING_CONTRACT_IDENTIFIER = "bookingContractIdentifier";
  private UUID bookingContractIdentifier;

  public static final String JSON_PROPERTY_CREATED_DATE = "createdDate";
  private java.time.LocalDateTime createdDate;

  public static final String JSON_PROPERTY_LAST_UPDATE = "lastUpdate";
  private java.time.LocalDateTime lastUpdate;

  public static final String JSON_PROPERTY_IP_ADDRESS = "ipAddress";
  private String ipAddress;

  public static final String JSON_PROPERTY_TRACE_ID = "traceId";
  private String traceId;

  public static final String JSON_PROPERTY_SOURCE_URL = "sourceUrl";
  private String sourceUrl;

  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private UUID identifier;

  public static final String JSON_PROPERTY_SUPPLIER_IDENTIFIER = "supplierIdentifier";
  private UUID supplierIdentifier;

  public static final String JSON_PROPERTY_SUPPLIER_NAME = "supplierName";
  private String supplierName;

  public static final String JSON_PROPERTY_DISPLAY_PRICE_QUOTE = "displayPriceQuote";
  private QuoteAgent displayPriceQuote;

  public static final String JSON_PROPERTY_SUPPLIER_PRICE_QUOTE = "supplierPriceQuote";
  private QuoteAgent supplierPriceQuote;

  public static final String JSON_PROPERTY_INTERNAL_PRICE_QUOTE = "internalPriceQuote";
  private QuoteAgent internalPriceQuote;

  public static final String JSON_PROPERTY_CAPTURE_PRICE_QUOTE = "capturePriceQuote";
  private QuoteAgent capturePriceQuote;

  public static final String JSON_PROPERTY_ITEM_LIST = "itemList";
  private List<BookingContractItemAgent> itemList = new ArrayList<>();

  public static final String JSON_PROPERTY_EXTERNAL_SUPPLIER_IDENTIFIER = "externalSupplierIdentifier";
  private String externalSupplierIdentifier;

  public static final String JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE = "externalSupplierBookingCode";
  private String externalSupplierBookingCode;

  public static final String JSON_PROPERTY_PAYMENT = "payment";
  private BookingContractPaymentDetailsAgent payment;

  public static final String JSON_PROPERTY_CANCELLED = "cancelled";
  private Boolean cancelled = false;

  public static final String JSON_PROPERTY_CANCELLED_ON = "cancelledOn";
  private java.time.LocalDateTime cancelledOn;

  /**
   * Type of entity that cancelled the booking.
   */
  public enum CancellerEnum {
    SALES_CHANNEL("SALES_CHANNEL"),
    
    SUPPLIER("SUPPLIER"),
    
    TRAVELER("TRAVELER"),
    
    ACQUIRER("ACQUIRER"),
    
    ADMINISTRATOR("ADMINISTRATOR");

    private String value;

    CancellerEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CancellerEnum fromValue(String value) {
      for (CancellerEnum b : CancellerEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CANCELLER = "canceller";
  private CancellerEnum canceller;

  /**
   * Reason type.
   */
  public enum CancellationTypeEnum {
    DUPLICATE("DUPLICATE"),
    
    CANCELLATION("CANCELLATION"),
    
    NO_SHOW("NO_SHOW"),
    
    CC_INVALID("CC_INVALID"),
    
    CC_INSUFFICIENT("CC_INSUFFICIENT"),
    
    DISCRETIONARY("DISCRETIONARY");

    private String value;

    CancellationTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CancellationTypeEnum fromValue(String value) {
      for (CancellationTypeEnum b : CancellationTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CANCELLATION_TYPE = "cancellationType";
  private CancellationTypeEnum cancellationType;

  public static final String JSON_PROPERTY_CANCELLER_USER_IDENTIFIER = "cancellerUserIdentifier";
  private String cancellerUserIdentifier;

  public static final String JSON_PROPERTY_CANCEL_REASON = "cancelReason";
  private String cancelReason;

  public static final String JSON_PROPERTY_FUNDS_PROCESSED = "fundsProcessed";
  private Boolean fundsProcessed;

  public static final String JSON_PROPERTY_REFUNDS = "refunds";
  private List<RefundAgent> refunds = new ArrayList<>();

  public static final String JSON_PROPERTY_SOURCE_CURRENCY = "sourceCurrency";
  private String sourceCurrency;

  public static final String JSON_PROPERTY_DISPLAY_CURRENCY = "displayCurrency";
  private String displayCurrency;

  public static final String JSON_PROPERTY_SUPPLIER_CURRENCY = "supplierCurrency";
  private String supplierCurrency;

  public static final String JSON_PROPERTY_INTERNAL_CURRENCY = "internalCurrency";
  private String internalCurrency;

  public static final String JSON_PROPERTY_CAPTURE_CURRENCY = "captureCurrency";
  private String captureCurrency;

  public static final String JSON_PROPERTY_SOURCE_AMOUNT = "sourceAmount";
  private BigDecimal sourceAmount;

  public static final String JSON_PROPERTY_DISPLAY_AMOUNT = "displayAmount";
  private BigDecimal displayAmount;

  public static final String JSON_PROPERTY_SUPPLIER_AMOUNT = "supplierAmount";
  private BigDecimal supplierAmount;

  public static final String JSON_PROPERTY_INTERNAL_AMOUNT = "internalAmount";
  private BigDecimal internalAmount;

  public static final String JSON_PROPERTY_CAPTURE_AMOUNT = "captureAmount";
  private BigDecimal captureAmount;

  public static final String JSON_PROPERTY_SOURCE_AMOUNT_REFUND_MODIFIER = "sourceAmountRefundModifier";
  private BigDecimal sourceAmountRefundModifier;

  public static final String JSON_PROPERTY_DISPLAY_AMOUNT_REFUND_MODIFIER = "displayAmountRefundModifier";
  private BigDecimal displayAmountRefundModifier;

  public static final String JSON_PROPERTY_SUPPLIER_AMOUNT_REFUND_MODIFIER = "supplierAmountRefundModifier";
  private BigDecimal supplierAmountRefundModifier;

  public static final String JSON_PROPERTY_INTERNAL_AMOUNT_REFUND_MODIFIER = "internalAmountRefundModifier";
  private BigDecimal internalAmountRefundModifier;

  public static final String JSON_PROPERTY_CAPTURE_AMOUNT_REFUND_MODIFIER = "captureAmountRefundModifier";
  private BigDecimal captureAmountRefundModifier;

  public static final String JSON_PROPERTY_NET_SOURCE_AMOUNT = "netSourceAmount";
  private BigDecimal netSourceAmount;

  public static final String JSON_PROPERTY_NET_DISPLAY_AMOUNT = "netDisplayAmount";
  private BigDecimal netDisplayAmount;

  public static final String JSON_PROPERTY_NET_SUPPLIER_AMOUNT = "netSupplierAmount";
  private BigDecimal netSupplierAmount;

  public static final String JSON_PROPERTY_NET_INTERNAL_AMOUNT = "netInternalAmount";
  private BigDecimal netInternalAmount;

  public static final String JSON_PROPERTY_NET_CAPTURE_AMOUNT = "netCaptureAmount";
  private BigDecimal netCaptureAmount;

  public static final String JSON_PROPERTY_TOTAL_TOKENS_EARNED = "totalTokensEarned";
  private Long totalTokensEarned;

  public static final String JSON_PROPERTY_NET_TOTAL_FEES_SUPPLIER_AMOUNT = "netTotalFeesSupplierAmount";
  private CustomMonetaryAmount netTotalFeesSupplierAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_SUPPLIER_AMOUNT = "netTotalFeesAndCommissionsSupplierAmount";
  private CustomMonetaryAmount netTotalFeesAndCommissionsSupplierAmount;

  public static final String JSON_PROPERTY_TOTAL_FEES_SUPPLIER_AMOUNT = "totalFeesSupplierAmount";
  private CustomMonetaryAmount totalFeesSupplierAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_SUPPLIER_AMOUNT = "netTotalTripPayFeeSupplierAmount";
  private CustomMonetaryAmount netTotalTripPayFeeSupplierAmount;

  public static final String JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_SUPPLIER_AMOUNT = "totalTripPayFeeSupplierAmount";
  private CustomMonetaryAmount totalTripPayFeeSupplierAmount;

  public static final String JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_SUPPLIER_AMOUNT = "netCommissionableTotalSupplierAmount";
  private CustomMonetaryAmount netCommissionableTotalSupplierAmount;

  public static final String JSON_PROPERTY_COMMISSIONABLE_TOTAL_SUPPLIER_AMOUNT = "commissionableTotalSupplierAmount";
  private CustomMonetaryAmount commissionableTotalSupplierAmount;

  public static final String JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_SUPPLIER_AMOUNT = "totalFeesAndCommissionsSupplierAmount";
  private CustomMonetaryAmount totalFeesAndCommissionsSupplierAmount;

  public static final String JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER = "cancellableBySupplier";
  private Boolean cancellableBySupplier;

  public static final String JSON_PROPERTY_CANCELLABLE_BY_TRAVELER = "cancellableByTraveler";
  private Boolean cancellableByTraveler;

  public static final String JSON_PROPERTY_CANCELLABLE_WITH_NO_CHARGES = "cancellableWithNoCharges";
  private Boolean cancellableWithNoCharges;

  public static final String JSON_PROPERTY_IS_CANCELLABLE_WITH_POTENTIAL_CHARGES = "isCancellableWithPotentialCharges";
  private Boolean isCancellableWithPotentialCharges;

  public static final String JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_SOURCE_AMOUNT = "netCommissionableTotalSourceAmount";
  private CustomMonetaryAmount netCommissionableTotalSourceAmount;

  public static final String JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_CAPTURE_AMOUNT = "netCommissionableTotalCaptureAmount";
  private CustomMonetaryAmount netCommissionableTotalCaptureAmount;

  public static final String JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_DISPLAY_AMOUNT = "netCommissionableTotalDisplayAmount";
  private CustomMonetaryAmount netCommissionableTotalDisplayAmount;

  public static final String JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_INTERNAL_AMOUNT = "netCommissionableTotalInternalAmount";
  private CustomMonetaryAmount netCommissionableTotalInternalAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_SOURCE_AMOUNT = "netTotalFeesAndCommissionsSourceAmount";
  private CustomMonetaryAmount netTotalFeesAndCommissionsSourceAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_CAPTURE_AMOUNT = "netTotalFeesAndCommissionsCaptureAmount";
  private CustomMonetaryAmount netTotalFeesAndCommissionsCaptureAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_DISPLAY_AMOUNT = "netTotalFeesAndCommissionsDisplayAmount";
  private CustomMonetaryAmount netTotalFeesAndCommissionsDisplayAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_INTERNAL_AMOUNT = "netTotalFeesAndCommissionsInternalAmount";
  private CustomMonetaryAmount netTotalFeesAndCommissionsInternalAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_FEES_SOURCE_AMOUNT = "netTotalFeesSourceAmount";
  private CustomMonetaryAmount netTotalFeesSourceAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_FEES_CAPTURE_AMOUNT = "netTotalFeesCaptureAmount";
  private CustomMonetaryAmount netTotalFeesCaptureAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_FEES_DISPLAY_AMOUNT = "netTotalFeesDisplayAmount";
  private CustomMonetaryAmount netTotalFeesDisplayAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_FEES_INTERNAL_AMOUNT = "netTotalFeesInternalAmount";
  private CustomMonetaryAmount netTotalFeesInternalAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_SOURCE_AMOUNT = "netTotalTripPayFeeSourceAmount";
  private CustomMonetaryAmount netTotalTripPayFeeSourceAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_CAPTURE_AMOUNT = "netTotalTripPayFeeCaptureAmount";
  private CustomMonetaryAmount netTotalTripPayFeeCaptureAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_DISPLAY_AMOUNT = "netTotalTripPayFeeDisplayAmount";
  private CustomMonetaryAmount netTotalTripPayFeeDisplayAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_INTERNAL_AMOUNT = "netTotalTripPayFeeInternalAmount";
  private CustomMonetaryAmount netTotalTripPayFeeInternalAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_SALES_SOURCE_AMOUNT = "netTotalSalesSourceAmount";
  private CustomMonetaryAmount netTotalSalesSourceAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_SALES_CAPTURE_AMOUNT = "netTotalSalesCaptureAmount";
  private CustomMonetaryAmount netTotalSalesCaptureAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_SALES_DISPLAY_AMOUNT = "netTotalSalesDisplayAmount";
  private CustomMonetaryAmount netTotalSalesDisplayAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_SALES_SUPPLIER_AMOUNT = "netTotalSalesSupplierAmount";
  private CustomMonetaryAmount netTotalSalesSupplierAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_SALES_INTERNAL_AMOUNT = "netTotalSalesInternalAmount";
  private CustomMonetaryAmount netTotalSalesInternalAmount;

  public static final String JSON_PROPERTY_COMMISSIONABLE_TOTAL_SOURCE_AMOUNT = "commissionableTotalSourceAmount";
  private CustomMonetaryAmount commissionableTotalSourceAmount;

  public static final String JSON_PROPERTY_COMMISSIONABLE_TOTAL_CAPTURE_AMOUNT = "commissionableTotalCaptureAmount";
  private CustomMonetaryAmount commissionableTotalCaptureAmount;

  public static final String JSON_PROPERTY_COMMISSIONABLE_TOTAL_DISPLAY_AMOUNT = "commissionableTotalDisplayAmount";
  private CustomMonetaryAmount commissionableTotalDisplayAmount;

  public static final String JSON_PROPERTY_COMMISSIONABLE_TOTAL_INTERNAL_AMOUNT = "commissionableTotalInternalAmount";
  private CustomMonetaryAmount commissionableTotalInternalAmount;

  public static final String JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_SOURCE_AMOUNT = "totalFeesAndCommissionsSourceAmount";
  private CustomMonetaryAmount totalFeesAndCommissionsSourceAmount;

  public static final String JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_CAPTURE_AMOUNT = "totalFeesAndCommissionsCaptureAmount";
  private CustomMonetaryAmount totalFeesAndCommissionsCaptureAmount;

  public static final String JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_DISPLAY_AMOUNT = "totalFeesAndCommissionsDisplayAmount";
  private CustomMonetaryAmount totalFeesAndCommissionsDisplayAmount;

  public static final String JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_INTERNAL_AMOUNT = "totalFeesAndCommissionsInternalAmount";
  private CustomMonetaryAmount totalFeesAndCommissionsInternalAmount;

  public static final String JSON_PROPERTY_TOTAL_FEES_SOURCE_AMOUNT = "totalFeesSourceAmount";
  private CustomMonetaryAmount totalFeesSourceAmount;

  public static final String JSON_PROPERTY_TOTAL_FEES_CAPTURE_AMOUNT = "totalFeesCaptureAmount";
  private CustomMonetaryAmount totalFeesCaptureAmount;

  public static final String JSON_PROPERTY_TOTAL_FEES_DISPLAY_AMOUNT = "totalFeesDisplayAmount";
  private CustomMonetaryAmount totalFeesDisplayAmount;

  public static final String JSON_PROPERTY_TOTAL_FEES_INTERNAL_AMOUNT = "totalFeesInternalAmount";
  private CustomMonetaryAmount totalFeesInternalAmount;

  public static final String JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_SOURCE_AMOUNT = "totalTripPayFeeSourceAmount";
  private CustomMonetaryAmount totalTripPayFeeSourceAmount;

  public static final String JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_CAPTURE_AMOUNT = "totalTripPayFeeCaptureAmount";
  private CustomMonetaryAmount totalTripPayFeeCaptureAmount;

  public static final String JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_DISPLAY_AMOUNT = "totalTripPayFeeDisplayAmount";
  private CustomMonetaryAmount totalTripPayFeeDisplayAmount;

  public static final String JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_INTERNAL_AMOUNT = "totalTripPayFeeInternalAmount";
  private CustomMonetaryAmount totalTripPayFeeInternalAmount;

  public static final String JSON_PROPERTY_TOTAL_SALES_SOURCE_AMOUNT = "totalSalesSourceAmount";
  private CustomMonetaryAmount totalSalesSourceAmount;

  public static final String JSON_PROPERTY_TOTAL_SALES_CAPTURE_AMOUNT = "totalSalesCaptureAmount";
  private CustomMonetaryAmount totalSalesCaptureAmount;

  public static final String JSON_PROPERTY_TOTAL_SALES_DISPLAY_AMOUNT = "totalSalesDisplayAmount";
  private CustomMonetaryAmount totalSalesDisplayAmount;

  public static final String JSON_PROPERTY_TOTAL_SALES_SUPPLIER_AMOUNT = "totalSalesSupplierAmount";
  private CustomMonetaryAmount totalSalesSupplierAmount;

  public static final String JSON_PROPERTY_TOTAL_SALES_INTERNAL_AMOUNT = "totalSalesInternalAmount";
  private CustomMonetaryAmount totalSalesInternalAmount;

  public static final String JSON_PROPERTY_FUNDS_AVAILABLE_DATE = "fundsAvailableDate";
  private LocalDate fundsAvailableDate;

  public static final String JSON_PROPERTY_TOTAL_FEES_IN_PERCENT = "totalFeesInPercent";
  private Float totalFeesInPercent;

  public static final String JSON_PROPERTY_TOTAL_COMMISSIONS_IN_PERCENT = "totalCommissionsInPercent";
  private Float totalCommissionsInPercent;

  public static final String JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_IN_PERCENT_WITH_REFUND = "totalFeesAndCommissionsInPercentWithRefund";
  private Float totalFeesAndCommissionsInPercentWithRefund;

  public static final String JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_IN_PERCENT = "totalFeesAndCommissionsInPercent";
  private Float totalFeesAndCommissionsInPercent;

  public static final String JSON_PROPERTY_HAS_SUCCESSFUL_REFUNDS = "hasSuccessfulRefunds";
  private Boolean hasSuccessfulRefunds;

  public static final String JSON_PROPERTY_HAS_PENDING_REFUNDS = "hasPendingRefunds";
  private Boolean hasPendingRefunds;

  public static final String JSON_PROPERTY_HAS_FAILED_REFUNDS = "hasFailedRefunds";
  private Boolean hasFailedRefunds;

  public static final String JSON_PROPERTY_HAS_REFUNDS = "hasRefunds";
  private Boolean hasRefunds;

  public static final String JSON_PROPERTY_ORIGINAL_COMMISSIONS_IN_PERCENT = "originalCommissionsInPercent";
  private BigDecimal originalCommissionsInPercent;

  public static final String JSON_PROPERTY_ORIGINAL_FEES_IN_PERCENT = "originalFeesInPercent";
  private BigDecimal originalFeesInPercent;

  public static final String JSON_PROPERTY_TOTAL_COMMISSIONS_IN_PERCENT_WITH_REFUND = "totalCommissionsInPercentWithRefund";
  private Float totalCommissionsInPercentWithRefund;

  public static final String JSON_PROPERTY_TOTAL_FEES_IN_PERCENT_WITH_REFUND = "totalFeesInPercentWithRefund";
  private Float totalFeesInPercentWithRefund;

  public static final String JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_IN_PERCENT_WITH_REFUND = "totalTripPayFeeInPercentWithRefund";
  private Float totalTripPayFeeInPercentWithRefund;

  public static final String JSON_PROPERTY_LODGING = "lodging";
  private BookingContractItemAgent lodging;

  public static final String JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_IN_PERCENT = "totalTripPayFeeInPercent";
  private Float totalTripPayFeeInPercent;

  public BookingContractAgent() {
  }

  public BookingContractAgent bookingContractIdentifier(UUID bookingContractIdentifier) {
    
    this.bookingContractIdentifier = bookingContractIdentifier;
    return this;
  }

   /**
   * Document UUID
   * @return bookingContractIdentifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_BOOKING_CONTRACT_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getBookingContractIdentifier() {
    return bookingContractIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_BOOKING_CONTRACT_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBookingContractIdentifier(UUID bookingContractIdentifier) {
    this.bookingContractIdentifier = bookingContractIdentifier;
  }


  public BookingContractAgent createdDate(java.time.LocalDateTime createdDate) {
    
    this.createdDate = createdDate;
    return this;
  }

   /**
   * Datetime this record was first created
   * @return createdDate
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CREATED_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getCreatedDate() {
    return createdDate;
  }


  @JsonProperty(JSON_PROPERTY_CREATED_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreatedDate(java.time.LocalDateTime createdDate) {
    this.createdDate = createdDate;
  }


  public BookingContractAgent lastUpdate(java.time.LocalDateTime lastUpdate) {
    
    this.lastUpdate = lastUpdate;
    return this;
  }

   /**
   * Datetime this record was last updated
   * @return lastUpdate
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LAST_UPDATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getLastUpdate() {
    return lastUpdate;
  }


  @JsonProperty(JSON_PROPERTY_LAST_UPDATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLastUpdate(java.time.LocalDateTime lastUpdate) {
    this.lastUpdate = lastUpdate;
  }


  public BookingContractAgent ipAddress(String ipAddress) {
    
    this.ipAddress = ipAddress;
    return this;
  }

   /**
   * Caller&#39;s IP address
   * @return ipAddress
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_IP_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getIpAddress() {
    return ipAddress;
  }


  @JsonProperty(JSON_PROPERTY_IP_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIpAddress(String ipAddress) {
    this.ipAddress = ipAddress;
  }


  public BookingContractAgent traceId(String traceId) {
    
    this.traceId = traceId;
    return this;
  }

   /**
   * Way to track which booking contracts were made together
   * @return traceId
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_TRACE_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getTraceId() {
    return traceId;
  }


  @JsonProperty(JSON_PROPERTY_TRACE_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTraceId(String traceId) {
    this.traceId = traceId;
  }


  public BookingContractAgent sourceUrl(String sourceUrl) {
    
    this.sourceUrl = sourceUrl;
    return this;
  }

   /**
   * Where did the booking occur
   * @return sourceUrl
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_SOURCE_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSourceUrl() {
    return sourceUrl;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSourceUrl(String sourceUrl) {
    this.sourceUrl = sourceUrl;
  }


  public BookingContractAgent identifier(UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique identifier used to track the contract. Create a UUID for this purpose.
   * @return identifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifier(UUID identifier) {
    this.identifier = identifier;
  }


  public BookingContractAgent supplierIdentifier(UUID supplierIdentifier) {
    
    this.supplierIdentifier = supplierIdentifier;
    return this;
  }

   /**
   * Supplier identifier
   * @return supplierIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getSupplierIdentifier() {
    return supplierIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSupplierIdentifier(UUID supplierIdentifier) {
    this.supplierIdentifier = supplierIdentifier;
  }


  public BookingContractAgent supplierName(String supplierName) {
    
    this.supplierName = supplierName;
    return this;
  }

   /**
   * Supplier name
   * @return supplierName
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_SUPPLIER_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSupplierName() {
    return supplierName;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSupplierName(String supplierName) {
    this.supplierName = supplierName;
  }


  public BookingContractAgent displayPriceQuote(QuoteAgent displayPriceQuote) {
    
    this.displayPriceQuote = displayPriceQuote;
    return this;
  }

   /**
   * Get displayPriceQuote
   * @return displayPriceQuote
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_DISPLAY_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public QuoteAgent getDisplayPriceQuote() {
    return displayPriceQuote;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDisplayPriceQuote(QuoteAgent displayPriceQuote) {
    this.displayPriceQuote = displayPriceQuote;
  }


  public BookingContractAgent supplierPriceQuote(QuoteAgent supplierPriceQuote) {
    
    this.supplierPriceQuote = supplierPriceQuote;
    return this;
  }

   /**
   * Get supplierPriceQuote
   * @return supplierPriceQuote
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_SUPPLIER_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public QuoteAgent getSupplierPriceQuote() {
    return supplierPriceQuote;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSupplierPriceQuote(QuoteAgent supplierPriceQuote) {
    this.supplierPriceQuote = supplierPriceQuote;
  }


  public BookingContractAgent internalPriceQuote(QuoteAgent internalPriceQuote) {
    
    this.internalPriceQuote = internalPriceQuote;
    return this;
  }

   /**
   * Get internalPriceQuote
   * @return internalPriceQuote
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_INTERNAL_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public QuoteAgent getInternalPriceQuote() {
    return internalPriceQuote;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInternalPriceQuote(QuoteAgent internalPriceQuote) {
    this.internalPriceQuote = internalPriceQuote;
  }


  public BookingContractAgent capturePriceQuote(QuoteAgent capturePriceQuote) {
    
    this.capturePriceQuote = capturePriceQuote;
    return this;
  }

   /**
   * Get capturePriceQuote
   * @return capturePriceQuote
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_CAPTURE_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public QuoteAgent getCapturePriceQuote() {
    return capturePriceQuote;
  }


  @JsonProperty(JSON_PROPERTY_CAPTURE_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCapturePriceQuote(QuoteAgent capturePriceQuote) {
    this.capturePriceQuote = capturePriceQuote;
  }


  public BookingContractAgent itemList(List<BookingContractItemAgent> itemList) {
    
    this.itemList = itemList;
    return this;
  }

  public BookingContractAgent addItemListItem(BookingContractItemAgent itemListItem) {
    this.itemList.add(itemListItem);
    return this;
  }

   /**
   * Holds one booking line item for a specific supplier.
   * @return itemList
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @Size(min=1,max=2147483647)
  @JsonProperty(JSON_PROPERTY_ITEM_LIST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<BookingContractItemAgent> getItemList() {
    return itemList;
  }


  @JsonProperty(JSON_PROPERTY_ITEM_LIST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setItemList(List<BookingContractItemAgent> itemList) {
    this.itemList = itemList;
  }


  public BookingContractAgent externalSupplierIdentifier(String externalSupplierIdentifier) {
    
    this.externalSupplierIdentifier = externalSupplierIdentifier;
    return this;
  }

   /**
   * Contract creator can choose to geoname this record with her own identifier
   * @return externalSupplierIdentifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_EXTERNAL_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getExternalSupplierIdentifier() {
    return externalSupplierIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_EXTERNAL_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExternalSupplierIdentifier(String externalSupplierIdentifier) {
    this.externalSupplierIdentifier = externalSupplierIdentifier;
  }


  public BookingContractAgent externalSupplierBookingCode(String externalSupplierBookingCode) {
    
    this.externalSupplierBookingCode = externalSupplierBookingCode;
    return this;
  }

   /**
   * External booking code generated by the affiliate
   * @return externalSupplierBookingCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getExternalSupplierBookingCode() {
    return externalSupplierBookingCode;
  }


  @JsonProperty(JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExternalSupplierBookingCode(String externalSupplierBookingCode) {
    this.externalSupplierBookingCode = externalSupplierBookingCode;
  }


  public BookingContractAgent payment(BookingContractPaymentDetailsAgent payment) {
    
    this.payment = payment;
    return this;
  }

   /**
   * Get payment
   * @return payment
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_PAYMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BookingContractPaymentDetailsAgent getPayment() {
    return payment;
  }


  @JsonProperty(JSON_PROPERTY_PAYMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPayment(BookingContractPaymentDetailsAgent payment) {
    this.payment = payment;
  }


  public BookingContractAgent cancelled(Boolean cancelled) {
    
    this.cancelled = cancelled;
    return this;
  }

   /**
   * Optional geoname externalIdentifier to remote inventory.
   * @return cancelled
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancelled() {
    return cancelled;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancelled(Boolean cancelled) {
    this.cancelled = cancelled;
  }


  public BookingContractAgent cancelledOn(java.time.LocalDateTime cancelledOn) {
    
    this.cancelledOn = cancelledOn;
    return this;
  }

   /**
   * When the booking was cancelled.
   * @return cancelledOn
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CANCELLED_ON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getCancelledOn() {
    return cancelledOn;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLED_ON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancelledOn(java.time.LocalDateTime cancelledOn) {
    this.cancelledOn = cancelledOn;
  }


  public BookingContractAgent canceller(CancellerEnum canceller) {
    
    this.canceller = canceller;
    return this;
  }

   /**
   * Type of entity that cancelled the booking.
   * @return canceller
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CancellerEnum getCanceller() {
    return canceller;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCanceller(CancellerEnum canceller) {
    this.canceller = canceller;
  }


  public BookingContractAgent cancellationType(CancellationTypeEnum cancellationType) {
    
    this.cancellationType = cancellationType;
    return this;
  }

   /**
   * Reason type.
   * @return cancellationType
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLATION_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CancellationTypeEnum getCancellationType() {
    return cancellationType;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLATION_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellationType(CancellationTypeEnum cancellationType) {
    this.cancellationType = cancellationType;
  }


  public BookingContractAgent cancellerUserIdentifier(String cancellerUserIdentifier) {
    
    this.cancellerUserIdentifier = cancellerUserIdentifier;
    return this;
  }

   /**
   * User identifier that cancelled the entity.
   * @return cancellerUserIdentifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLER_USER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCancellerUserIdentifier() {
    return cancellerUserIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLER_USER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellerUserIdentifier(String cancellerUserIdentifier) {
    this.cancellerUserIdentifier = cancellerUserIdentifier;
  }


  public BookingContractAgent cancelReason(String cancelReason) {
    
    this.cancelReason = cancelReason;
    return this;
  }

   /**
   * Reason for cancellation.
   * @return cancelReason
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCEL_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCancelReason() {
    return cancelReason;
  }


  @JsonProperty(JSON_PROPERTY_CANCEL_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancelReason(String cancelReason) {
    this.cancelReason = cancelReason;
  }


  public BookingContractAgent fundsProcessed(Boolean fundsProcessed) {
    
    this.fundsProcessed = fundsProcessed;
    return this;
  }

   /**
   * Whether a funds transfer request has been created for this booking.
   * @return fundsProcessed
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_FUNDS_PROCESSED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getFundsProcessed() {
    return fundsProcessed;
  }


  @JsonProperty(JSON_PROPERTY_FUNDS_PROCESSED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFundsProcessed(Boolean fundsProcessed) {
    this.fundsProcessed = fundsProcessed;
  }


  public BookingContractAgent refunds(List<RefundAgent> refunds) {
    
    this.refunds = refunds;
    return this;
  }

  public BookingContractAgent addRefundsItem(RefundAgent refundsItem) {
    if (this.refunds == null) {
      this.refunds = new ArrayList<>();
    }
    this.refunds.add(refundsItem);
    return this;
  }

   /**
   * An optional list of refunds that occurred with this booking. If the refund amount(s) is the same as the total price, the booking also gets cancelled.
   * @return refunds
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_REFUNDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<RefundAgent> getRefunds() {
    return refunds;
  }


  @JsonProperty(JSON_PROPERTY_REFUNDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRefunds(List<RefundAgent> refunds) {
    this.refunds = refunds;
  }


  public BookingContractAgent sourceCurrency(String sourceCurrency) {
    
    this.sourceCurrency = sourceCurrency;
    return this;
  }

   /**
   * The source currency
   * @return sourceCurrency
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_SOURCE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSourceCurrency() {
    return sourceCurrency;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSourceCurrency(String sourceCurrency) {
    this.sourceCurrency = sourceCurrency;
  }


  public BookingContractAgent displayCurrency(String displayCurrency) {
    
    this.displayCurrency = displayCurrency;
    return this;
  }

   /**
   * The display currency
   * @return displayCurrency
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_DISPLAY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDisplayCurrency() {
    return displayCurrency;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDisplayCurrency(String displayCurrency) {
    this.displayCurrency = displayCurrency;
  }


  public BookingContractAgent supplierCurrency(String supplierCurrency) {
    
    this.supplierCurrency = supplierCurrency;
    return this;
  }

   /**
   * The supplier currency
   * @return supplierCurrency
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_SUPPLIER_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSupplierCurrency() {
    return supplierCurrency;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSupplierCurrency(String supplierCurrency) {
    this.supplierCurrency = supplierCurrency;
  }


  public BookingContractAgent internalCurrency(String internalCurrency) {
    
    this.internalCurrency = internalCurrency;
    return this;
  }

   /**
   * The internal currency
   * @return internalCurrency
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_INTERNAL_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getInternalCurrency() {
    return internalCurrency;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInternalCurrency(String internalCurrency) {
    this.internalCurrency = internalCurrency;
  }


  public BookingContractAgent captureCurrency(String captureCurrency) {
    
    this.captureCurrency = captureCurrency;
    return this;
  }

   /**
   * The capture currency
   * @return captureCurrency
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_CAPTURE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCaptureCurrency() {
    return captureCurrency;
  }


  @JsonProperty(JSON_PROPERTY_CAPTURE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCaptureCurrency(String captureCurrency) {
    this.captureCurrency = captureCurrency;
  }


  public BookingContractAgent sourceAmount(BigDecimal sourceAmount) {
    
    this.sourceAmount = sourceAmount;
    return this;
  }

   /**
   * The total initial price as quoted in the original TripPay contract.
   * minimum: 0
   * @return sourceAmount
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BigDecimal getSourceAmount() {
    return sourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSourceAmount(BigDecimal sourceAmount) {
    this.sourceAmount = sourceAmount;
  }


  public BookingContractAgent displayAmount(BigDecimal displayAmount) {
    
    this.displayAmount = displayAmount;
    return this;
  }

   /**
   * The total display price.
   * minimum: 0
   * @return displayAmount
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BigDecimal getDisplayAmount() {
    return displayAmount;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDisplayAmount(BigDecimal displayAmount) {
    this.displayAmount = displayAmount;
  }


  public BookingContractAgent supplierAmount(BigDecimal supplierAmount) {
    
    this.supplierAmount = supplierAmount;
    return this;
  }

   /**
   * The total supplier price.
   * minimum: 0
   * @return supplierAmount
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BigDecimal getSupplierAmount() {
    return supplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSupplierAmount(BigDecimal supplierAmount) {
    this.supplierAmount = supplierAmount;
  }


  public BookingContractAgent internalAmount(BigDecimal internalAmount) {
    
    this.internalAmount = internalAmount;
    return this;
  }

   /**
   * Get internalAmount
   * minimum: 0
   * @return internalAmount
  **/
  @jakarta.annotation.Nullable
  @Valid
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getInternalAmount() {
    return internalAmount;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalAmount(BigDecimal internalAmount) {
    this.internalAmount = internalAmount;
  }


  public BookingContractAgent captureAmount(BigDecimal captureAmount) {
    
    this.captureAmount = captureAmount;
    return this;
  }

   /**
   * The total capture price.
   * minimum: 0
   * @return captureAmount
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BigDecimal getCaptureAmount() {
    return captureAmount;
  }


  @JsonProperty(JSON_PROPERTY_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCaptureAmount(BigDecimal captureAmount) {
    this.captureAmount = captureAmount;
  }


  public BookingContractAgent sourceAmountRefundModifier(BigDecimal sourceAmountRefundModifier) {
    
    this.sourceAmountRefundModifier = sourceAmountRefundModifier;
    return this;
  }

   /**
   * The source amount still due after a partial refund occurs.
   * minimum: 0
   * @return sourceAmountRefundModifier
  **/
  @jakarta.annotation.Nullable
  @Valid
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_SOURCE_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getSourceAmountRefundModifier() {
    return sourceAmountRefundModifier;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceAmountRefundModifier(BigDecimal sourceAmountRefundModifier) {
    this.sourceAmountRefundModifier = sourceAmountRefundModifier;
  }


  public BookingContractAgent displayAmountRefundModifier(BigDecimal displayAmountRefundModifier) {
    
    this.displayAmountRefundModifier = displayAmountRefundModifier;
    return this;
  }

   /**
   * The display amount still due after a partial refund occurs.
   * minimum: 0
   * @return displayAmountRefundModifier
  **/
  @jakarta.annotation.Nullable
  @Valid
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_DISPLAY_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getDisplayAmountRefundModifier() {
    return displayAmountRefundModifier;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisplayAmountRefundModifier(BigDecimal displayAmountRefundModifier) {
    this.displayAmountRefundModifier = displayAmountRefundModifier;
  }


  public BookingContractAgent supplierAmountRefundModifier(BigDecimal supplierAmountRefundModifier) {
    
    this.supplierAmountRefundModifier = supplierAmountRefundModifier;
    return this;
  }

   /**
   * The supplier amount still due after a partial refund occurs.
   * minimum: 0
   * @return supplierAmountRefundModifier
  **/
  @jakarta.annotation.Nullable
  @Valid
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_SUPPLIER_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getSupplierAmountRefundModifier() {
    return supplierAmountRefundModifier;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSupplierAmountRefundModifier(BigDecimal supplierAmountRefundModifier) {
    this.supplierAmountRefundModifier = supplierAmountRefundModifier;
  }


  public BookingContractAgent internalAmountRefundModifier(BigDecimal internalAmountRefundModifier) {
    
    this.internalAmountRefundModifier = internalAmountRefundModifier;
    return this;
  }

   /**
   * The internal amount still due after a partial refund occurs.
   * minimum: 0
   * @return internalAmountRefundModifier
  **/
  @jakarta.annotation.Nullable
  @Valid
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_INTERNAL_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getInternalAmountRefundModifier() {
    return internalAmountRefundModifier;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalAmountRefundModifier(BigDecimal internalAmountRefundModifier) {
    this.internalAmountRefundModifier = internalAmountRefundModifier;
  }


  public BookingContractAgent captureAmountRefundModifier(BigDecimal captureAmountRefundModifier) {
    
    this.captureAmountRefundModifier = captureAmountRefundModifier;
    return this;
  }

   /**
   * The capture amount still due after a partial refund occurs.
   * minimum: 0
   * @return captureAmountRefundModifier
  **/
  @jakarta.annotation.Nullable
  @Valid
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_CAPTURE_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getCaptureAmountRefundModifier() {
    return captureAmountRefundModifier;
  }


  @JsonProperty(JSON_PROPERTY_CAPTURE_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCaptureAmountRefundModifier(BigDecimal captureAmountRefundModifier) {
    this.captureAmountRefundModifier = captureAmountRefundModifier;
  }


  public BookingContractAgent netSourceAmount(BigDecimal netSourceAmount) {
    
    this.netSourceAmount = netSourceAmount;
    return this;
  }

   /**
   * The total initial price as quoted in the original TripPay contract.
   * minimum: 0
   * @return netSourceAmount
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_NET_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BigDecimal getNetSourceAmount() {
    return netSourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setNetSourceAmount(BigDecimal netSourceAmount) {
    this.netSourceAmount = netSourceAmount;
  }


  public BookingContractAgent netDisplayAmount(BigDecimal netDisplayAmount) {
    
    this.netDisplayAmount = netDisplayAmount;
    return this;
  }

   /**
   * The total display price.
   * minimum: 0
   * @return netDisplayAmount
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_NET_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BigDecimal getNetDisplayAmount() {
    return netDisplayAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setNetDisplayAmount(BigDecimal netDisplayAmount) {
    this.netDisplayAmount = netDisplayAmount;
  }


  public BookingContractAgent netSupplierAmount(BigDecimal netSupplierAmount) {
    
    this.netSupplierAmount = netSupplierAmount;
    return this;
  }

   /**
   * The total supplier price.
   * minimum: 0
   * @return netSupplierAmount
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_NET_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BigDecimal getNetSupplierAmount() {
    return netSupplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setNetSupplierAmount(BigDecimal netSupplierAmount) {
    this.netSupplierAmount = netSupplierAmount;
  }


  public BookingContractAgent netInternalAmount(BigDecimal netInternalAmount) {
    
    this.netInternalAmount = netInternalAmount;
    return this;
  }

   /**
   * Get netInternalAmount
   * minimum: 0
   * @return netInternalAmount
  **/
  @jakarta.annotation.Nullable
  @Valid
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_NET_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getNetInternalAmount() {
    return netInternalAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetInternalAmount(BigDecimal netInternalAmount) {
    this.netInternalAmount = netInternalAmount;
  }


  public BookingContractAgent netCaptureAmount(BigDecimal netCaptureAmount) {
    
    this.netCaptureAmount = netCaptureAmount;
    return this;
  }

   /**
   * The total capture price.
   * minimum: 0
   * @return netCaptureAmount
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_NET_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BigDecimal getNetCaptureAmount() {
    return netCaptureAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setNetCaptureAmount(BigDecimal netCaptureAmount) {
    this.netCaptureAmount = netCaptureAmount;
  }


  public BookingContractAgent totalTokensEarned(Long totalTokensEarned) {
    
    this.totalTokensEarned = totalTokensEarned;
    return this;
  }

   /**
   * Total amount of tokens minted on this contract.
   * @return totalTokensEarned
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOTAL_TOKENS_EARNED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getTotalTokensEarned() {
    return totalTokensEarned;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_TOKENS_EARNED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalTokensEarned(Long totalTokensEarned) {
    this.totalTokensEarned = totalTokensEarned;
  }


  public BookingContractAgent netTotalFeesSupplierAmount(CustomMonetaryAmount netTotalFeesSupplierAmount) {
    
    this.netTotalFeesSupplierAmount = netTotalFeesSupplierAmount;
    return this;
  }

   /**
   * Get netTotalFeesSupplierAmount
   * @return netTotalFeesSupplierAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalFeesSupplierAmount() {
    return netTotalFeesSupplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalFeesSupplierAmount(CustomMonetaryAmount netTotalFeesSupplierAmount) {
    this.netTotalFeesSupplierAmount = netTotalFeesSupplierAmount;
  }


  public BookingContractAgent netTotalFeesAndCommissionsSupplierAmount(CustomMonetaryAmount netTotalFeesAndCommissionsSupplierAmount) {
    
    this.netTotalFeesAndCommissionsSupplierAmount = netTotalFeesAndCommissionsSupplierAmount;
    return this;
  }

   /**
   * Get netTotalFeesAndCommissionsSupplierAmount
   * @return netTotalFeesAndCommissionsSupplierAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalFeesAndCommissionsSupplierAmount() {
    return netTotalFeesAndCommissionsSupplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalFeesAndCommissionsSupplierAmount(CustomMonetaryAmount netTotalFeesAndCommissionsSupplierAmount) {
    this.netTotalFeesAndCommissionsSupplierAmount = netTotalFeesAndCommissionsSupplierAmount;
  }


  public BookingContractAgent totalFeesSupplierAmount(CustomMonetaryAmount totalFeesSupplierAmount) {
    
    this.totalFeesSupplierAmount = totalFeesSupplierAmount;
    return this;
  }

   /**
   * Get totalFeesSupplierAmount
   * @return totalFeesSupplierAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalFeesSupplierAmount() {
    return totalFeesSupplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalFeesSupplierAmount(CustomMonetaryAmount totalFeesSupplierAmount) {
    this.totalFeesSupplierAmount = totalFeesSupplierAmount;
  }


  public BookingContractAgent netTotalTripPayFeeSupplierAmount(CustomMonetaryAmount netTotalTripPayFeeSupplierAmount) {
    
    this.netTotalTripPayFeeSupplierAmount = netTotalTripPayFeeSupplierAmount;
    return this;
  }

   /**
   * Get netTotalTripPayFeeSupplierAmount
   * @return netTotalTripPayFeeSupplierAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalTripPayFeeSupplierAmount() {
    return netTotalTripPayFeeSupplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalTripPayFeeSupplierAmount(CustomMonetaryAmount netTotalTripPayFeeSupplierAmount) {
    this.netTotalTripPayFeeSupplierAmount = netTotalTripPayFeeSupplierAmount;
  }


  public BookingContractAgent totalTripPayFeeSupplierAmount(CustomMonetaryAmount totalTripPayFeeSupplierAmount) {
    
    this.totalTripPayFeeSupplierAmount = totalTripPayFeeSupplierAmount;
    return this;
  }

   /**
   * Get totalTripPayFeeSupplierAmount
   * @return totalTripPayFeeSupplierAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalTripPayFeeSupplierAmount() {
    return totalTripPayFeeSupplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalTripPayFeeSupplierAmount(CustomMonetaryAmount totalTripPayFeeSupplierAmount) {
    this.totalTripPayFeeSupplierAmount = totalTripPayFeeSupplierAmount;
  }


  public BookingContractAgent netCommissionableTotalSupplierAmount(CustomMonetaryAmount netCommissionableTotalSupplierAmount) {
    
    this.netCommissionableTotalSupplierAmount = netCommissionableTotalSupplierAmount;
    return this;
  }

   /**
   * Get netCommissionableTotalSupplierAmount
   * @return netCommissionableTotalSupplierAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetCommissionableTotalSupplierAmount() {
    return netCommissionableTotalSupplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetCommissionableTotalSupplierAmount(CustomMonetaryAmount netCommissionableTotalSupplierAmount) {
    this.netCommissionableTotalSupplierAmount = netCommissionableTotalSupplierAmount;
  }


  public BookingContractAgent commissionableTotalSupplierAmount(CustomMonetaryAmount commissionableTotalSupplierAmount) {
    
    this.commissionableTotalSupplierAmount = commissionableTotalSupplierAmount;
    return this;
  }

   /**
   * Get commissionableTotalSupplierAmount
   * @return commissionableTotalSupplierAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE_TOTAL_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getCommissionableTotalSupplierAmount() {
    return commissionableTotalSupplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE_TOTAL_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCommissionableTotalSupplierAmount(CustomMonetaryAmount commissionableTotalSupplierAmount) {
    this.commissionableTotalSupplierAmount = commissionableTotalSupplierAmount;
  }


  public BookingContractAgent totalFeesAndCommissionsSupplierAmount(CustomMonetaryAmount totalFeesAndCommissionsSupplierAmount) {
    
    this.totalFeesAndCommissionsSupplierAmount = totalFeesAndCommissionsSupplierAmount;
    return this;
  }

   /**
   * Get totalFeesAndCommissionsSupplierAmount
   * @return totalFeesAndCommissionsSupplierAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalFeesAndCommissionsSupplierAmount() {
    return totalFeesAndCommissionsSupplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalFeesAndCommissionsSupplierAmount(CustomMonetaryAmount totalFeesAndCommissionsSupplierAmount) {
    this.totalFeesAndCommissionsSupplierAmount = totalFeesAndCommissionsSupplierAmount;
  }


  public BookingContractAgent cancellableBySupplier(Boolean cancellableBySupplier) {
    
    this.cancellableBySupplier = cancellableBySupplier;
    return this;
  }

   /**
   * Whether the booking can still be cancelled completely by the supplier.
   * @return cancellableBySupplier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableBySupplier() {
    return cancellableBySupplier;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableBySupplier(Boolean cancellableBySupplier) {
    this.cancellableBySupplier = cancellableBySupplier;
  }


  public BookingContractAgent cancellableByTraveler(Boolean cancellableByTraveler) {
    
    this.cancellableByTraveler = cancellableByTraveler;
    return this;
  }

   /**
   * Whether the booking can still be cancelled completely by the traveller.
   * @return cancellableByTraveler
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_TRAVELER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableByTraveler() {
    return cancellableByTraveler;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_TRAVELER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableByTraveler(Boolean cancellableByTraveler) {
    this.cancellableByTraveler = cancellableByTraveler;
  }


  public BookingContractAgent cancellableWithNoCharges(Boolean cancellableWithNoCharges) {
    
    this.cancellableWithNoCharges = cancellableWithNoCharges;
    return this;
  }

   /**
   * Whether the cancellation comes at no cost to the traveler.
   * @return cancellableWithNoCharges
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLABLE_WITH_NO_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableWithNoCharges() {
    return cancellableWithNoCharges;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_WITH_NO_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableWithNoCharges(Boolean cancellableWithNoCharges) {
    this.cancellableWithNoCharges = cancellableWithNoCharges;
  }


  public BookingContractAgent isCancellableWithPotentialCharges(Boolean isCancellableWithPotentialCharges) {
    
    this.isCancellableWithPotentialCharges = isCancellableWithPotentialCharges;
    return this;
  }

   /**
   * Whether a cancellation comes with partial charges. I.e. Only some of the items in contract are not fully refundable.
   * @return isCancellableWithPotentialCharges
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_IS_CANCELLABLE_WITH_POTENTIAL_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIsCancellableWithPotentialCharges() {
    return isCancellableWithPotentialCharges;
  }


  @JsonProperty(JSON_PROPERTY_IS_CANCELLABLE_WITH_POTENTIAL_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIsCancellableWithPotentialCharges(Boolean isCancellableWithPotentialCharges) {
    this.isCancellableWithPotentialCharges = isCancellableWithPotentialCharges;
  }


  public BookingContractAgent netCommissionableTotalSourceAmount(CustomMonetaryAmount netCommissionableTotalSourceAmount) {
    
    this.netCommissionableTotalSourceAmount = netCommissionableTotalSourceAmount;
    return this;
  }

   /**
   * Get netCommissionableTotalSourceAmount
   * @return netCommissionableTotalSourceAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetCommissionableTotalSourceAmount() {
    return netCommissionableTotalSourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetCommissionableTotalSourceAmount(CustomMonetaryAmount netCommissionableTotalSourceAmount) {
    this.netCommissionableTotalSourceAmount = netCommissionableTotalSourceAmount;
  }


  public BookingContractAgent netCommissionableTotalCaptureAmount(CustomMonetaryAmount netCommissionableTotalCaptureAmount) {
    
    this.netCommissionableTotalCaptureAmount = netCommissionableTotalCaptureAmount;
    return this;
  }

   /**
   * Get netCommissionableTotalCaptureAmount
   * @return netCommissionableTotalCaptureAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetCommissionableTotalCaptureAmount() {
    return netCommissionableTotalCaptureAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetCommissionableTotalCaptureAmount(CustomMonetaryAmount netCommissionableTotalCaptureAmount) {
    this.netCommissionableTotalCaptureAmount = netCommissionableTotalCaptureAmount;
  }


  public BookingContractAgent netCommissionableTotalDisplayAmount(CustomMonetaryAmount netCommissionableTotalDisplayAmount) {
    
    this.netCommissionableTotalDisplayAmount = netCommissionableTotalDisplayAmount;
    return this;
  }

   /**
   * Get netCommissionableTotalDisplayAmount
   * @return netCommissionableTotalDisplayAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetCommissionableTotalDisplayAmount() {
    return netCommissionableTotalDisplayAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetCommissionableTotalDisplayAmount(CustomMonetaryAmount netCommissionableTotalDisplayAmount) {
    this.netCommissionableTotalDisplayAmount = netCommissionableTotalDisplayAmount;
  }


  public BookingContractAgent netCommissionableTotalInternalAmount(CustomMonetaryAmount netCommissionableTotalInternalAmount) {
    
    this.netCommissionableTotalInternalAmount = netCommissionableTotalInternalAmount;
    return this;
  }

   /**
   * Get netCommissionableTotalInternalAmount
   * @return netCommissionableTotalInternalAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetCommissionableTotalInternalAmount() {
    return netCommissionableTotalInternalAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetCommissionableTotalInternalAmount(CustomMonetaryAmount netCommissionableTotalInternalAmount) {
    this.netCommissionableTotalInternalAmount = netCommissionableTotalInternalAmount;
  }


  public BookingContractAgent netTotalFeesAndCommissionsSourceAmount(CustomMonetaryAmount netTotalFeesAndCommissionsSourceAmount) {
    
    this.netTotalFeesAndCommissionsSourceAmount = netTotalFeesAndCommissionsSourceAmount;
    return this;
  }

   /**
   * Get netTotalFeesAndCommissionsSourceAmount
   * @return netTotalFeesAndCommissionsSourceAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalFeesAndCommissionsSourceAmount() {
    return netTotalFeesAndCommissionsSourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalFeesAndCommissionsSourceAmount(CustomMonetaryAmount netTotalFeesAndCommissionsSourceAmount) {
    this.netTotalFeesAndCommissionsSourceAmount = netTotalFeesAndCommissionsSourceAmount;
  }


  public BookingContractAgent netTotalFeesAndCommissionsCaptureAmount(CustomMonetaryAmount netTotalFeesAndCommissionsCaptureAmount) {
    
    this.netTotalFeesAndCommissionsCaptureAmount = netTotalFeesAndCommissionsCaptureAmount;
    return this;
  }

   /**
   * Get netTotalFeesAndCommissionsCaptureAmount
   * @return netTotalFeesAndCommissionsCaptureAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalFeesAndCommissionsCaptureAmount() {
    return netTotalFeesAndCommissionsCaptureAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalFeesAndCommissionsCaptureAmount(CustomMonetaryAmount netTotalFeesAndCommissionsCaptureAmount) {
    this.netTotalFeesAndCommissionsCaptureAmount = netTotalFeesAndCommissionsCaptureAmount;
  }


  public BookingContractAgent netTotalFeesAndCommissionsDisplayAmount(CustomMonetaryAmount netTotalFeesAndCommissionsDisplayAmount) {
    
    this.netTotalFeesAndCommissionsDisplayAmount = netTotalFeesAndCommissionsDisplayAmount;
    return this;
  }

   /**
   * Get netTotalFeesAndCommissionsDisplayAmount
   * @return netTotalFeesAndCommissionsDisplayAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalFeesAndCommissionsDisplayAmount() {
    return netTotalFeesAndCommissionsDisplayAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalFeesAndCommissionsDisplayAmount(CustomMonetaryAmount netTotalFeesAndCommissionsDisplayAmount) {
    this.netTotalFeesAndCommissionsDisplayAmount = netTotalFeesAndCommissionsDisplayAmount;
  }


  public BookingContractAgent netTotalFeesAndCommissionsInternalAmount(CustomMonetaryAmount netTotalFeesAndCommissionsInternalAmount) {
    
    this.netTotalFeesAndCommissionsInternalAmount = netTotalFeesAndCommissionsInternalAmount;
    return this;
  }

   /**
   * Get netTotalFeesAndCommissionsInternalAmount
   * @return netTotalFeesAndCommissionsInternalAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalFeesAndCommissionsInternalAmount() {
    return netTotalFeesAndCommissionsInternalAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalFeesAndCommissionsInternalAmount(CustomMonetaryAmount netTotalFeesAndCommissionsInternalAmount) {
    this.netTotalFeesAndCommissionsInternalAmount = netTotalFeesAndCommissionsInternalAmount;
  }


  public BookingContractAgent netTotalFeesSourceAmount(CustomMonetaryAmount netTotalFeesSourceAmount) {
    
    this.netTotalFeesSourceAmount = netTotalFeesSourceAmount;
    return this;
  }

   /**
   * Get netTotalFeesSourceAmount
   * @return netTotalFeesSourceAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalFeesSourceAmount() {
    return netTotalFeesSourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalFeesSourceAmount(CustomMonetaryAmount netTotalFeesSourceAmount) {
    this.netTotalFeesSourceAmount = netTotalFeesSourceAmount;
  }


  public BookingContractAgent netTotalFeesCaptureAmount(CustomMonetaryAmount netTotalFeesCaptureAmount) {
    
    this.netTotalFeesCaptureAmount = netTotalFeesCaptureAmount;
    return this;
  }

   /**
   * Get netTotalFeesCaptureAmount
   * @return netTotalFeesCaptureAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalFeesCaptureAmount() {
    return netTotalFeesCaptureAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalFeesCaptureAmount(CustomMonetaryAmount netTotalFeesCaptureAmount) {
    this.netTotalFeesCaptureAmount = netTotalFeesCaptureAmount;
  }


  public BookingContractAgent netTotalFeesDisplayAmount(CustomMonetaryAmount netTotalFeesDisplayAmount) {
    
    this.netTotalFeesDisplayAmount = netTotalFeesDisplayAmount;
    return this;
  }

   /**
   * Get netTotalFeesDisplayAmount
   * @return netTotalFeesDisplayAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalFeesDisplayAmount() {
    return netTotalFeesDisplayAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalFeesDisplayAmount(CustomMonetaryAmount netTotalFeesDisplayAmount) {
    this.netTotalFeesDisplayAmount = netTotalFeesDisplayAmount;
  }


  public BookingContractAgent netTotalFeesInternalAmount(CustomMonetaryAmount netTotalFeesInternalAmount) {
    
    this.netTotalFeesInternalAmount = netTotalFeesInternalAmount;
    return this;
  }

   /**
   * Get netTotalFeesInternalAmount
   * @return netTotalFeesInternalAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalFeesInternalAmount() {
    return netTotalFeesInternalAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalFeesInternalAmount(CustomMonetaryAmount netTotalFeesInternalAmount) {
    this.netTotalFeesInternalAmount = netTotalFeesInternalAmount;
  }


  public BookingContractAgent netTotalTripPayFeeSourceAmount(CustomMonetaryAmount netTotalTripPayFeeSourceAmount) {
    
    this.netTotalTripPayFeeSourceAmount = netTotalTripPayFeeSourceAmount;
    return this;
  }

   /**
   * Get netTotalTripPayFeeSourceAmount
   * @return netTotalTripPayFeeSourceAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalTripPayFeeSourceAmount() {
    return netTotalTripPayFeeSourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalTripPayFeeSourceAmount(CustomMonetaryAmount netTotalTripPayFeeSourceAmount) {
    this.netTotalTripPayFeeSourceAmount = netTotalTripPayFeeSourceAmount;
  }


  public BookingContractAgent netTotalTripPayFeeCaptureAmount(CustomMonetaryAmount netTotalTripPayFeeCaptureAmount) {
    
    this.netTotalTripPayFeeCaptureAmount = netTotalTripPayFeeCaptureAmount;
    return this;
  }

   /**
   * Get netTotalTripPayFeeCaptureAmount
   * @return netTotalTripPayFeeCaptureAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalTripPayFeeCaptureAmount() {
    return netTotalTripPayFeeCaptureAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalTripPayFeeCaptureAmount(CustomMonetaryAmount netTotalTripPayFeeCaptureAmount) {
    this.netTotalTripPayFeeCaptureAmount = netTotalTripPayFeeCaptureAmount;
  }


  public BookingContractAgent netTotalTripPayFeeDisplayAmount(CustomMonetaryAmount netTotalTripPayFeeDisplayAmount) {
    
    this.netTotalTripPayFeeDisplayAmount = netTotalTripPayFeeDisplayAmount;
    return this;
  }

   /**
   * Get netTotalTripPayFeeDisplayAmount
   * @return netTotalTripPayFeeDisplayAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalTripPayFeeDisplayAmount() {
    return netTotalTripPayFeeDisplayAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalTripPayFeeDisplayAmount(CustomMonetaryAmount netTotalTripPayFeeDisplayAmount) {
    this.netTotalTripPayFeeDisplayAmount = netTotalTripPayFeeDisplayAmount;
  }


  public BookingContractAgent netTotalTripPayFeeInternalAmount(CustomMonetaryAmount netTotalTripPayFeeInternalAmount) {
    
    this.netTotalTripPayFeeInternalAmount = netTotalTripPayFeeInternalAmount;
    return this;
  }

   /**
   * Get netTotalTripPayFeeInternalAmount
   * @return netTotalTripPayFeeInternalAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalTripPayFeeInternalAmount() {
    return netTotalTripPayFeeInternalAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalTripPayFeeInternalAmount(CustomMonetaryAmount netTotalTripPayFeeInternalAmount) {
    this.netTotalTripPayFeeInternalAmount = netTotalTripPayFeeInternalAmount;
  }


  public BookingContractAgent netTotalSalesSourceAmount(CustomMonetaryAmount netTotalSalesSourceAmount) {
    
    this.netTotalSalesSourceAmount = netTotalSalesSourceAmount;
    return this;
  }

   /**
   * Get netTotalSalesSourceAmount
   * @return netTotalSalesSourceAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_SALES_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalSalesSourceAmount() {
    return netTotalSalesSourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_SALES_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalSalesSourceAmount(CustomMonetaryAmount netTotalSalesSourceAmount) {
    this.netTotalSalesSourceAmount = netTotalSalesSourceAmount;
  }


  public BookingContractAgent netTotalSalesCaptureAmount(CustomMonetaryAmount netTotalSalesCaptureAmount) {
    
    this.netTotalSalesCaptureAmount = netTotalSalesCaptureAmount;
    return this;
  }

   /**
   * Get netTotalSalesCaptureAmount
   * @return netTotalSalesCaptureAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_SALES_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalSalesCaptureAmount() {
    return netTotalSalesCaptureAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_SALES_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalSalesCaptureAmount(CustomMonetaryAmount netTotalSalesCaptureAmount) {
    this.netTotalSalesCaptureAmount = netTotalSalesCaptureAmount;
  }


  public BookingContractAgent netTotalSalesDisplayAmount(CustomMonetaryAmount netTotalSalesDisplayAmount) {
    
    this.netTotalSalesDisplayAmount = netTotalSalesDisplayAmount;
    return this;
  }

   /**
   * Get netTotalSalesDisplayAmount
   * @return netTotalSalesDisplayAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_SALES_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalSalesDisplayAmount() {
    return netTotalSalesDisplayAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_SALES_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalSalesDisplayAmount(CustomMonetaryAmount netTotalSalesDisplayAmount) {
    this.netTotalSalesDisplayAmount = netTotalSalesDisplayAmount;
  }


  public BookingContractAgent netTotalSalesSupplierAmount(CustomMonetaryAmount netTotalSalesSupplierAmount) {
    
    this.netTotalSalesSupplierAmount = netTotalSalesSupplierAmount;
    return this;
  }

   /**
   * Get netTotalSalesSupplierAmount
   * @return netTotalSalesSupplierAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_SALES_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalSalesSupplierAmount() {
    return netTotalSalesSupplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_SALES_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalSalesSupplierAmount(CustomMonetaryAmount netTotalSalesSupplierAmount) {
    this.netTotalSalesSupplierAmount = netTotalSalesSupplierAmount;
  }


  public BookingContractAgent netTotalSalesInternalAmount(CustomMonetaryAmount netTotalSalesInternalAmount) {
    
    this.netTotalSalesInternalAmount = netTotalSalesInternalAmount;
    return this;
  }

   /**
   * Get netTotalSalesInternalAmount
   * @return netTotalSalesInternalAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_SALES_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalSalesInternalAmount() {
    return netTotalSalesInternalAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_SALES_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalSalesInternalAmount(CustomMonetaryAmount netTotalSalesInternalAmount) {
    this.netTotalSalesInternalAmount = netTotalSalesInternalAmount;
  }


  public BookingContractAgent commissionableTotalSourceAmount(CustomMonetaryAmount commissionableTotalSourceAmount) {
    
    this.commissionableTotalSourceAmount = commissionableTotalSourceAmount;
    return this;
  }

   /**
   * Get commissionableTotalSourceAmount
   * @return commissionableTotalSourceAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE_TOTAL_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getCommissionableTotalSourceAmount() {
    return commissionableTotalSourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE_TOTAL_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCommissionableTotalSourceAmount(CustomMonetaryAmount commissionableTotalSourceAmount) {
    this.commissionableTotalSourceAmount = commissionableTotalSourceAmount;
  }


  public BookingContractAgent commissionableTotalCaptureAmount(CustomMonetaryAmount commissionableTotalCaptureAmount) {
    
    this.commissionableTotalCaptureAmount = commissionableTotalCaptureAmount;
    return this;
  }

   /**
   * Get commissionableTotalCaptureAmount
   * @return commissionableTotalCaptureAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE_TOTAL_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getCommissionableTotalCaptureAmount() {
    return commissionableTotalCaptureAmount;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE_TOTAL_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCommissionableTotalCaptureAmount(CustomMonetaryAmount commissionableTotalCaptureAmount) {
    this.commissionableTotalCaptureAmount = commissionableTotalCaptureAmount;
  }


  public BookingContractAgent commissionableTotalDisplayAmount(CustomMonetaryAmount commissionableTotalDisplayAmount) {
    
    this.commissionableTotalDisplayAmount = commissionableTotalDisplayAmount;
    return this;
  }

   /**
   * Get commissionableTotalDisplayAmount
   * @return commissionableTotalDisplayAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE_TOTAL_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getCommissionableTotalDisplayAmount() {
    return commissionableTotalDisplayAmount;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE_TOTAL_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCommissionableTotalDisplayAmount(CustomMonetaryAmount commissionableTotalDisplayAmount) {
    this.commissionableTotalDisplayAmount = commissionableTotalDisplayAmount;
  }


  public BookingContractAgent commissionableTotalInternalAmount(CustomMonetaryAmount commissionableTotalInternalAmount) {
    
    this.commissionableTotalInternalAmount = commissionableTotalInternalAmount;
    return this;
  }

   /**
   * Get commissionableTotalInternalAmount
   * @return commissionableTotalInternalAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE_TOTAL_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getCommissionableTotalInternalAmount() {
    return commissionableTotalInternalAmount;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE_TOTAL_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCommissionableTotalInternalAmount(CustomMonetaryAmount commissionableTotalInternalAmount) {
    this.commissionableTotalInternalAmount = commissionableTotalInternalAmount;
  }


  public BookingContractAgent totalFeesAndCommissionsSourceAmount(CustomMonetaryAmount totalFeesAndCommissionsSourceAmount) {
    
    this.totalFeesAndCommissionsSourceAmount = totalFeesAndCommissionsSourceAmount;
    return this;
  }

   /**
   * Get totalFeesAndCommissionsSourceAmount
   * @return totalFeesAndCommissionsSourceAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalFeesAndCommissionsSourceAmount() {
    return totalFeesAndCommissionsSourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalFeesAndCommissionsSourceAmount(CustomMonetaryAmount totalFeesAndCommissionsSourceAmount) {
    this.totalFeesAndCommissionsSourceAmount = totalFeesAndCommissionsSourceAmount;
  }


  public BookingContractAgent totalFeesAndCommissionsCaptureAmount(CustomMonetaryAmount totalFeesAndCommissionsCaptureAmount) {
    
    this.totalFeesAndCommissionsCaptureAmount = totalFeesAndCommissionsCaptureAmount;
    return this;
  }

   /**
   * Get totalFeesAndCommissionsCaptureAmount
   * @return totalFeesAndCommissionsCaptureAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalFeesAndCommissionsCaptureAmount() {
    return totalFeesAndCommissionsCaptureAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalFeesAndCommissionsCaptureAmount(CustomMonetaryAmount totalFeesAndCommissionsCaptureAmount) {
    this.totalFeesAndCommissionsCaptureAmount = totalFeesAndCommissionsCaptureAmount;
  }


  public BookingContractAgent totalFeesAndCommissionsDisplayAmount(CustomMonetaryAmount totalFeesAndCommissionsDisplayAmount) {
    
    this.totalFeesAndCommissionsDisplayAmount = totalFeesAndCommissionsDisplayAmount;
    return this;
  }

   /**
   * Get totalFeesAndCommissionsDisplayAmount
   * @return totalFeesAndCommissionsDisplayAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalFeesAndCommissionsDisplayAmount() {
    return totalFeesAndCommissionsDisplayAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalFeesAndCommissionsDisplayAmount(CustomMonetaryAmount totalFeesAndCommissionsDisplayAmount) {
    this.totalFeesAndCommissionsDisplayAmount = totalFeesAndCommissionsDisplayAmount;
  }


  public BookingContractAgent totalFeesAndCommissionsInternalAmount(CustomMonetaryAmount totalFeesAndCommissionsInternalAmount) {
    
    this.totalFeesAndCommissionsInternalAmount = totalFeesAndCommissionsInternalAmount;
    return this;
  }

   /**
   * Get totalFeesAndCommissionsInternalAmount
   * @return totalFeesAndCommissionsInternalAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalFeesAndCommissionsInternalAmount() {
    return totalFeesAndCommissionsInternalAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalFeesAndCommissionsInternalAmount(CustomMonetaryAmount totalFeesAndCommissionsInternalAmount) {
    this.totalFeesAndCommissionsInternalAmount = totalFeesAndCommissionsInternalAmount;
  }


  public BookingContractAgent totalFeesSourceAmount(CustomMonetaryAmount totalFeesSourceAmount) {
    
    this.totalFeesSourceAmount = totalFeesSourceAmount;
    return this;
  }

   /**
   * Get totalFeesSourceAmount
   * @return totalFeesSourceAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalFeesSourceAmount() {
    return totalFeesSourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalFeesSourceAmount(CustomMonetaryAmount totalFeesSourceAmount) {
    this.totalFeesSourceAmount = totalFeesSourceAmount;
  }


  public BookingContractAgent totalFeesCaptureAmount(CustomMonetaryAmount totalFeesCaptureAmount) {
    
    this.totalFeesCaptureAmount = totalFeesCaptureAmount;
    return this;
  }

   /**
   * Get totalFeesCaptureAmount
   * @return totalFeesCaptureAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalFeesCaptureAmount() {
    return totalFeesCaptureAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalFeesCaptureAmount(CustomMonetaryAmount totalFeesCaptureAmount) {
    this.totalFeesCaptureAmount = totalFeesCaptureAmount;
  }


  public BookingContractAgent totalFeesDisplayAmount(CustomMonetaryAmount totalFeesDisplayAmount) {
    
    this.totalFeesDisplayAmount = totalFeesDisplayAmount;
    return this;
  }

   /**
   * Get totalFeesDisplayAmount
   * @return totalFeesDisplayAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalFeesDisplayAmount() {
    return totalFeesDisplayAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalFeesDisplayAmount(CustomMonetaryAmount totalFeesDisplayAmount) {
    this.totalFeesDisplayAmount = totalFeesDisplayAmount;
  }


  public BookingContractAgent totalFeesInternalAmount(CustomMonetaryAmount totalFeesInternalAmount) {
    
    this.totalFeesInternalAmount = totalFeesInternalAmount;
    return this;
  }

   /**
   * Get totalFeesInternalAmount
   * @return totalFeesInternalAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalFeesInternalAmount() {
    return totalFeesInternalAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalFeesInternalAmount(CustomMonetaryAmount totalFeesInternalAmount) {
    this.totalFeesInternalAmount = totalFeesInternalAmount;
  }


  public BookingContractAgent totalTripPayFeeSourceAmount(CustomMonetaryAmount totalTripPayFeeSourceAmount) {
    
    this.totalTripPayFeeSourceAmount = totalTripPayFeeSourceAmount;
    return this;
  }

   /**
   * Get totalTripPayFeeSourceAmount
   * @return totalTripPayFeeSourceAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalTripPayFeeSourceAmount() {
    return totalTripPayFeeSourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalTripPayFeeSourceAmount(CustomMonetaryAmount totalTripPayFeeSourceAmount) {
    this.totalTripPayFeeSourceAmount = totalTripPayFeeSourceAmount;
  }


  public BookingContractAgent totalTripPayFeeCaptureAmount(CustomMonetaryAmount totalTripPayFeeCaptureAmount) {
    
    this.totalTripPayFeeCaptureAmount = totalTripPayFeeCaptureAmount;
    return this;
  }

   /**
   * Get totalTripPayFeeCaptureAmount
   * @return totalTripPayFeeCaptureAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalTripPayFeeCaptureAmount() {
    return totalTripPayFeeCaptureAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalTripPayFeeCaptureAmount(CustomMonetaryAmount totalTripPayFeeCaptureAmount) {
    this.totalTripPayFeeCaptureAmount = totalTripPayFeeCaptureAmount;
  }


  public BookingContractAgent totalTripPayFeeDisplayAmount(CustomMonetaryAmount totalTripPayFeeDisplayAmount) {
    
    this.totalTripPayFeeDisplayAmount = totalTripPayFeeDisplayAmount;
    return this;
  }

   /**
   * Get totalTripPayFeeDisplayAmount
   * @return totalTripPayFeeDisplayAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalTripPayFeeDisplayAmount() {
    return totalTripPayFeeDisplayAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalTripPayFeeDisplayAmount(CustomMonetaryAmount totalTripPayFeeDisplayAmount) {
    this.totalTripPayFeeDisplayAmount = totalTripPayFeeDisplayAmount;
  }


  public BookingContractAgent totalTripPayFeeInternalAmount(CustomMonetaryAmount totalTripPayFeeInternalAmount) {
    
    this.totalTripPayFeeInternalAmount = totalTripPayFeeInternalAmount;
    return this;
  }

   /**
   * Get totalTripPayFeeInternalAmount
   * @return totalTripPayFeeInternalAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalTripPayFeeInternalAmount() {
    return totalTripPayFeeInternalAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalTripPayFeeInternalAmount(CustomMonetaryAmount totalTripPayFeeInternalAmount) {
    this.totalTripPayFeeInternalAmount = totalTripPayFeeInternalAmount;
  }


  public BookingContractAgent totalSalesSourceAmount(CustomMonetaryAmount totalSalesSourceAmount) {
    
    this.totalSalesSourceAmount = totalSalesSourceAmount;
    return this;
  }

   /**
   * Get totalSalesSourceAmount
   * @return totalSalesSourceAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_SALES_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalSalesSourceAmount() {
    return totalSalesSourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_SALES_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalSalesSourceAmount(CustomMonetaryAmount totalSalesSourceAmount) {
    this.totalSalesSourceAmount = totalSalesSourceAmount;
  }


  public BookingContractAgent totalSalesCaptureAmount(CustomMonetaryAmount totalSalesCaptureAmount) {
    
    this.totalSalesCaptureAmount = totalSalesCaptureAmount;
    return this;
  }

   /**
   * Get totalSalesCaptureAmount
   * @return totalSalesCaptureAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_SALES_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalSalesCaptureAmount() {
    return totalSalesCaptureAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_SALES_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalSalesCaptureAmount(CustomMonetaryAmount totalSalesCaptureAmount) {
    this.totalSalesCaptureAmount = totalSalesCaptureAmount;
  }


  public BookingContractAgent totalSalesDisplayAmount(CustomMonetaryAmount totalSalesDisplayAmount) {
    
    this.totalSalesDisplayAmount = totalSalesDisplayAmount;
    return this;
  }

   /**
   * Get totalSalesDisplayAmount
   * @return totalSalesDisplayAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_SALES_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalSalesDisplayAmount() {
    return totalSalesDisplayAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_SALES_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalSalesDisplayAmount(CustomMonetaryAmount totalSalesDisplayAmount) {
    this.totalSalesDisplayAmount = totalSalesDisplayAmount;
  }


  public BookingContractAgent totalSalesSupplierAmount(CustomMonetaryAmount totalSalesSupplierAmount) {
    
    this.totalSalesSupplierAmount = totalSalesSupplierAmount;
    return this;
  }

   /**
   * Get totalSalesSupplierAmount
   * @return totalSalesSupplierAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_SALES_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalSalesSupplierAmount() {
    return totalSalesSupplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_SALES_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalSalesSupplierAmount(CustomMonetaryAmount totalSalesSupplierAmount) {
    this.totalSalesSupplierAmount = totalSalesSupplierAmount;
  }


  public BookingContractAgent totalSalesInternalAmount(CustomMonetaryAmount totalSalesInternalAmount) {
    
    this.totalSalesInternalAmount = totalSalesInternalAmount;
    return this;
  }

   /**
   * Get totalSalesInternalAmount
   * @return totalSalesInternalAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_SALES_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalSalesInternalAmount() {
    return totalSalesInternalAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_SALES_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalSalesInternalAmount(CustomMonetaryAmount totalSalesInternalAmount) {
    this.totalSalesInternalAmount = totalSalesInternalAmount;
  }


  public BookingContractAgent fundsAvailableDate(LocalDate fundsAvailableDate) {
    
    this.fundsAvailableDate = fundsAvailableDate;
    return this;
  }

   /**
   * Returns the date the funds will be released to the customer.
   * @return fundsAvailableDate
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_FUNDS_AVAILABLE_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getFundsAvailableDate() {
    return fundsAvailableDate;
  }


  @JsonProperty(JSON_PROPERTY_FUNDS_AVAILABLE_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFundsAvailableDate(LocalDate fundsAvailableDate) {
    this.fundsAvailableDate = fundsAvailableDate;
  }


  public BookingContractAgent totalFeesInPercent(Float totalFeesInPercent) {
    
    this.totalFeesInPercent = totalFeesInPercent;
    return this;
  }

   /**
   * All amounts that are not of type SALE before a refund was applied
   * @return totalFeesInPercent
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_IN_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getTotalFeesInPercent() {
    return totalFeesInPercent;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_IN_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalFeesInPercent(Float totalFeesInPercent) {
    this.totalFeesInPercent = totalFeesInPercent;
  }


  public BookingContractAgent totalCommissionsInPercent(Float totalCommissionsInPercent) {
    
    this.totalCommissionsInPercent = totalCommissionsInPercent;
    return this;
  }

   /**
   * All amounts that are not of type SALE before a refund was applied
   * @return totalCommissionsInPercent
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOTAL_COMMISSIONS_IN_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getTotalCommissionsInPercent() {
    return totalCommissionsInPercent;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_COMMISSIONS_IN_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalCommissionsInPercent(Float totalCommissionsInPercent) {
    this.totalCommissionsInPercent = totalCommissionsInPercent;
  }


  public BookingContractAgent totalFeesAndCommissionsInPercentWithRefund(Float totalFeesAndCommissionsInPercentWithRefund) {
    
    this.totalFeesAndCommissionsInPercentWithRefund = totalFeesAndCommissionsInPercentWithRefund;
    return this;
  }

   /**
   * All amounts that are not of type SALE
   * @return totalFeesAndCommissionsInPercentWithRefund
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_IN_PERCENT_WITH_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getTotalFeesAndCommissionsInPercentWithRefund() {
    return totalFeesAndCommissionsInPercentWithRefund;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_IN_PERCENT_WITH_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalFeesAndCommissionsInPercentWithRefund(Float totalFeesAndCommissionsInPercentWithRefund) {
    this.totalFeesAndCommissionsInPercentWithRefund = totalFeesAndCommissionsInPercentWithRefund;
  }


  public BookingContractAgent totalFeesAndCommissionsInPercent(Float totalFeesAndCommissionsInPercent) {
    
    this.totalFeesAndCommissionsInPercent = totalFeesAndCommissionsInPercent;
    return this;
  }

   /**
   * All amounts that are not of type SALE before a refund was applied
   * @return totalFeesAndCommissionsInPercent
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_IN_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getTotalFeesAndCommissionsInPercent() {
    return totalFeesAndCommissionsInPercent;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_IN_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalFeesAndCommissionsInPercent(Float totalFeesAndCommissionsInPercent) {
    this.totalFeesAndCommissionsInPercent = totalFeesAndCommissionsInPercent;
  }


  public BookingContractAgent hasSuccessfulRefunds(Boolean hasSuccessfulRefunds) {
    
    this.hasSuccessfulRefunds = hasSuccessfulRefunds;
    return this;
  }

   /**
   * Indicates whether a successful refund is present.
   * @return hasSuccessfulRefunds
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_SUCCESSFUL_REFUNDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasSuccessfulRefunds() {
    return hasSuccessfulRefunds;
  }


  @JsonProperty(JSON_PROPERTY_HAS_SUCCESSFUL_REFUNDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasSuccessfulRefunds(Boolean hasSuccessfulRefunds) {
    this.hasSuccessfulRefunds = hasSuccessfulRefunds;
  }


  public BookingContractAgent hasPendingRefunds(Boolean hasPendingRefunds) {
    
    this.hasPendingRefunds = hasPendingRefunds;
    return this;
  }

   /**
   * Indicates whether a pending refund is present.
   * @return hasPendingRefunds
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_PENDING_REFUNDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasPendingRefunds() {
    return hasPendingRefunds;
  }


  @JsonProperty(JSON_PROPERTY_HAS_PENDING_REFUNDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasPendingRefunds(Boolean hasPendingRefunds) {
    this.hasPendingRefunds = hasPendingRefunds;
  }


  public BookingContractAgent hasFailedRefunds(Boolean hasFailedRefunds) {
    
    this.hasFailedRefunds = hasFailedRefunds;
    return this;
  }

   /**
   * Indicates whether a failed refund is present.
   * @return hasFailedRefunds
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_FAILED_REFUNDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasFailedRefunds() {
    return hasFailedRefunds;
  }


  @JsonProperty(JSON_PROPERTY_HAS_FAILED_REFUNDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasFailedRefunds(Boolean hasFailedRefunds) {
    this.hasFailedRefunds = hasFailedRefunds;
  }


  public BookingContractAgent hasRefunds(Boolean hasRefunds) {
    
    this.hasRefunds = hasRefunds;
    return this;
  }

   /**
   * Indicates whether any refund in any state is present.
   * @return hasRefunds
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_REFUNDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasRefunds() {
    return hasRefunds;
  }


  @JsonProperty(JSON_PROPERTY_HAS_REFUNDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasRefunds(Boolean hasRefunds) {
    this.hasRefunds = hasRefunds;
  }


  public BookingContractAgent originalCommissionsInPercent(BigDecimal originalCommissionsInPercent) {
    
    this.originalCommissionsInPercent = originalCommissionsInPercent;
    return this;
  }

   /**
   * All amounts that are not of type SALE before a refund was applied
   * @return originalCommissionsInPercent
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ORIGINAL_COMMISSIONS_IN_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getOriginalCommissionsInPercent() {
    return originalCommissionsInPercent;
  }


  @JsonProperty(JSON_PROPERTY_ORIGINAL_COMMISSIONS_IN_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOriginalCommissionsInPercent(BigDecimal originalCommissionsInPercent) {
    this.originalCommissionsInPercent = originalCommissionsInPercent;
  }


  public BookingContractAgent originalFeesInPercent(BigDecimal originalFeesInPercent) {
    
    this.originalFeesInPercent = originalFeesInPercent;
    return this;
  }

   /**
   * All amounts that are not of type SALE before a refund was applied
   * @return originalFeesInPercent
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ORIGINAL_FEES_IN_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getOriginalFeesInPercent() {
    return originalFeesInPercent;
  }


  @JsonProperty(JSON_PROPERTY_ORIGINAL_FEES_IN_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOriginalFeesInPercent(BigDecimal originalFeesInPercent) {
    this.originalFeesInPercent = originalFeesInPercent;
  }


  public BookingContractAgent totalCommissionsInPercentWithRefund(Float totalCommissionsInPercentWithRefund) {
    
    this.totalCommissionsInPercentWithRefund = totalCommissionsInPercentWithRefund;
    return this;
  }

   /**
   * All amounts that are not of type SALE
   * @return totalCommissionsInPercentWithRefund
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOTAL_COMMISSIONS_IN_PERCENT_WITH_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getTotalCommissionsInPercentWithRefund() {
    return totalCommissionsInPercentWithRefund;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_COMMISSIONS_IN_PERCENT_WITH_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalCommissionsInPercentWithRefund(Float totalCommissionsInPercentWithRefund) {
    this.totalCommissionsInPercentWithRefund = totalCommissionsInPercentWithRefund;
  }


  public BookingContractAgent totalFeesInPercentWithRefund(Float totalFeesInPercentWithRefund) {
    
    this.totalFeesInPercentWithRefund = totalFeesInPercentWithRefund;
    return this;
  }

   /**
   * All amounts that are not of type SALE
   * @return totalFeesInPercentWithRefund
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_IN_PERCENT_WITH_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getTotalFeesInPercentWithRefund() {
    return totalFeesInPercentWithRefund;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_IN_PERCENT_WITH_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalFeesInPercentWithRefund(Float totalFeesInPercentWithRefund) {
    this.totalFeesInPercentWithRefund = totalFeesInPercentWithRefund;
  }


  public BookingContractAgent totalTripPayFeeInPercentWithRefund(Float totalTripPayFeeInPercentWithRefund) {
    
    this.totalTripPayFeeInPercentWithRefund = totalTripPayFeeInPercentWithRefund;
    return this;
  }

   /**
   * All amounts that are not of type SALE
   * @return totalTripPayFeeInPercentWithRefund
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_IN_PERCENT_WITH_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getTotalTripPayFeeInPercentWithRefund() {
    return totalTripPayFeeInPercentWithRefund;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_IN_PERCENT_WITH_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalTripPayFeeInPercentWithRefund(Float totalTripPayFeeInPercentWithRefund) {
    this.totalTripPayFeeInPercentWithRefund = totalTripPayFeeInPercentWithRefund;
  }


  public BookingContractAgent lodging(BookingContractItemAgent lodging) {
    
    this.lodging = lodging;
    return this;
  }

   /**
   * Get lodging
   * @return lodging
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LODGING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BookingContractItemAgent getLodging() {
    return lodging;
  }


  @JsonProperty(JSON_PROPERTY_LODGING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLodging(BookingContractItemAgent lodging) {
    this.lodging = lodging;
  }


  public BookingContractAgent totalTripPayFeeInPercent(Float totalTripPayFeeInPercent) {
    
    this.totalTripPayFeeInPercent = totalTripPayFeeInPercent;
    return this;
  }

   /**
   * All amounts that are not of type SALE before a refund was applied
   * @return totalTripPayFeeInPercent
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_IN_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getTotalTripPayFeeInPercent() {
    return totalTripPayFeeInPercent;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_IN_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalTripPayFeeInPercent(Float totalTripPayFeeInPercent) {
    this.totalTripPayFeeInPercent = totalTripPayFeeInPercent;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BookingContractAgent bookingContractAgent = (BookingContractAgent) o;
    return Objects.equals(this.bookingContractIdentifier, bookingContractAgent.bookingContractIdentifier) &&
        Objects.equals(this.createdDate, bookingContractAgent.createdDate) &&
        Objects.equals(this.lastUpdate, bookingContractAgent.lastUpdate) &&
        Objects.equals(this.ipAddress, bookingContractAgent.ipAddress) &&
        Objects.equals(this.traceId, bookingContractAgent.traceId) &&
        Objects.equals(this.sourceUrl, bookingContractAgent.sourceUrl) &&
        Objects.equals(this.identifier, bookingContractAgent.identifier) &&
        Objects.equals(this.supplierIdentifier, bookingContractAgent.supplierIdentifier) &&
        Objects.equals(this.supplierName, bookingContractAgent.supplierName) &&
        Objects.equals(this.displayPriceQuote, bookingContractAgent.displayPriceQuote) &&
        Objects.equals(this.supplierPriceQuote, bookingContractAgent.supplierPriceQuote) &&
        Objects.equals(this.internalPriceQuote, bookingContractAgent.internalPriceQuote) &&
        Objects.equals(this.capturePriceQuote, bookingContractAgent.capturePriceQuote) &&
        Objects.equals(this.itemList, bookingContractAgent.itemList) &&
        Objects.equals(this.externalSupplierIdentifier, bookingContractAgent.externalSupplierIdentifier) &&
        Objects.equals(this.externalSupplierBookingCode, bookingContractAgent.externalSupplierBookingCode) &&
        Objects.equals(this.payment, bookingContractAgent.payment) &&
        Objects.equals(this.cancelled, bookingContractAgent.cancelled) &&
        Objects.equals(this.cancelledOn, bookingContractAgent.cancelledOn) &&
        Objects.equals(this.canceller, bookingContractAgent.canceller) &&
        Objects.equals(this.cancellationType, bookingContractAgent.cancellationType) &&
        Objects.equals(this.cancellerUserIdentifier, bookingContractAgent.cancellerUserIdentifier) &&
        Objects.equals(this.cancelReason, bookingContractAgent.cancelReason) &&
        Objects.equals(this.fundsProcessed, bookingContractAgent.fundsProcessed) &&
        Objects.equals(this.refunds, bookingContractAgent.refunds) &&
        Objects.equals(this.sourceCurrency, bookingContractAgent.sourceCurrency) &&
        Objects.equals(this.displayCurrency, bookingContractAgent.displayCurrency) &&
        Objects.equals(this.supplierCurrency, bookingContractAgent.supplierCurrency) &&
        Objects.equals(this.internalCurrency, bookingContractAgent.internalCurrency) &&
        Objects.equals(this.captureCurrency, bookingContractAgent.captureCurrency) &&
        Objects.equals(this.sourceAmount, bookingContractAgent.sourceAmount) &&
        Objects.equals(this.displayAmount, bookingContractAgent.displayAmount) &&
        Objects.equals(this.supplierAmount, bookingContractAgent.supplierAmount) &&
        Objects.equals(this.internalAmount, bookingContractAgent.internalAmount) &&
        Objects.equals(this.captureAmount, bookingContractAgent.captureAmount) &&
        Objects.equals(this.sourceAmountRefundModifier, bookingContractAgent.sourceAmountRefundModifier) &&
        Objects.equals(this.displayAmountRefundModifier, bookingContractAgent.displayAmountRefundModifier) &&
        Objects.equals(this.supplierAmountRefundModifier, bookingContractAgent.supplierAmountRefundModifier) &&
        Objects.equals(this.internalAmountRefundModifier, bookingContractAgent.internalAmountRefundModifier) &&
        Objects.equals(this.captureAmountRefundModifier, bookingContractAgent.captureAmountRefundModifier) &&
        Objects.equals(this.netSourceAmount, bookingContractAgent.netSourceAmount) &&
        Objects.equals(this.netDisplayAmount, bookingContractAgent.netDisplayAmount) &&
        Objects.equals(this.netSupplierAmount, bookingContractAgent.netSupplierAmount) &&
        Objects.equals(this.netInternalAmount, bookingContractAgent.netInternalAmount) &&
        Objects.equals(this.netCaptureAmount, bookingContractAgent.netCaptureAmount) &&
        Objects.equals(this.totalTokensEarned, bookingContractAgent.totalTokensEarned) &&
        Objects.equals(this.netTotalFeesSupplierAmount, bookingContractAgent.netTotalFeesSupplierAmount) &&
        Objects.equals(this.netTotalFeesAndCommissionsSupplierAmount, bookingContractAgent.netTotalFeesAndCommissionsSupplierAmount) &&
        Objects.equals(this.totalFeesSupplierAmount, bookingContractAgent.totalFeesSupplierAmount) &&
        Objects.equals(this.netTotalTripPayFeeSupplierAmount, bookingContractAgent.netTotalTripPayFeeSupplierAmount) &&
        Objects.equals(this.totalTripPayFeeSupplierAmount, bookingContractAgent.totalTripPayFeeSupplierAmount) &&
        Objects.equals(this.netCommissionableTotalSupplierAmount, bookingContractAgent.netCommissionableTotalSupplierAmount) &&
        Objects.equals(this.commissionableTotalSupplierAmount, bookingContractAgent.commissionableTotalSupplierAmount) &&
        Objects.equals(this.totalFeesAndCommissionsSupplierAmount, bookingContractAgent.totalFeesAndCommissionsSupplierAmount) &&
        Objects.equals(this.cancellableBySupplier, bookingContractAgent.cancellableBySupplier) &&
        Objects.equals(this.cancellableByTraveler, bookingContractAgent.cancellableByTraveler) &&
        Objects.equals(this.cancellableWithNoCharges, bookingContractAgent.cancellableWithNoCharges) &&
        Objects.equals(this.isCancellableWithPotentialCharges, bookingContractAgent.isCancellableWithPotentialCharges) &&
        Objects.equals(this.netCommissionableTotalSourceAmount, bookingContractAgent.netCommissionableTotalSourceAmount) &&
        Objects.equals(this.netCommissionableTotalCaptureAmount, bookingContractAgent.netCommissionableTotalCaptureAmount) &&
        Objects.equals(this.netCommissionableTotalDisplayAmount, bookingContractAgent.netCommissionableTotalDisplayAmount) &&
        Objects.equals(this.netCommissionableTotalInternalAmount, bookingContractAgent.netCommissionableTotalInternalAmount) &&
        Objects.equals(this.netTotalFeesAndCommissionsSourceAmount, bookingContractAgent.netTotalFeesAndCommissionsSourceAmount) &&
        Objects.equals(this.netTotalFeesAndCommissionsCaptureAmount, bookingContractAgent.netTotalFeesAndCommissionsCaptureAmount) &&
        Objects.equals(this.netTotalFeesAndCommissionsDisplayAmount, bookingContractAgent.netTotalFeesAndCommissionsDisplayAmount) &&
        Objects.equals(this.netTotalFeesAndCommissionsInternalAmount, bookingContractAgent.netTotalFeesAndCommissionsInternalAmount) &&
        Objects.equals(this.netTotalFeesSourceAmount, bookingContractAgent.netTotalFeesSourceAmount) &&
        Objects.equals(this.netTotalFeesCaptureAmount, bookingContractAgent.netTotalFeesCaptureAmount) &&
        Objects.equals(this.netTotalFeesDisplayAmount, bookingContractAgent.netTotalFeesDisplayAmount) &&
        Objects.equals(this.netTotalFeesInternalAmount, bookingContractAgent.netTotalFeesInternalAmount) &&
        Objects.equals(this.netTotalTripPayFeeSourceAmount, bookingContractAgent.netTotalTripPayFeeSourceAmount) &&
        Objects.equals(this.netTotalTripPayFeeCaptureAmount, bookingContractAgent.netTotalTripPayFeeCaptureAmount) &&
        Objects.equals(this.netTotalTripPayFeeDisplayAmount, bookingContractAgent.netTotalTripPayFeeDisplayAmount) &&
        Objects.equals(this.netTotalTripPayFeeInternalAmount, bookingContractAgent.netTotalTripPayFeeInternalAmount) &&
        Objects.equals(this.netTotalSalesSourceAmount, bookingContractAgent.netTotalSalesSourceAmount) &&
        Objects.equals(this.netTotalSalesCaptureAmount, bookingContractAgent.netTotalSalesCaptureAmount) &&
        Objects.equals(this.netTotalSalesDisplayAmount, bookingContractAgent.netTotalSalesDisplayAmount) &&
        Objects.equals(this.netTotalSalesSupplierAmount, bookingContractAgent.netTotalSalesSupplierAmount) &&
        Objects.equals(this.netTotalSalesInternalAmount, bookingContractAgent.netTotalSalesInternalAmount) &&
        Objects.equals(this.commissionableTotalSourceAmount, bookingContractAgent.commissionableTotalSourceAmount) &&
        Objects.equals(this.commissionableTotalCaptureAmount, bookingContractAgent.commissionableTotalCaptureAmount) &&
        Objects.equals(this.commissionableTotalDisplayAmount, bookingContractAgent.commissionableTotalDisplayAmount) &&
        Objects.equals(this.commissionableTotalInternalAmount, bookingContractAgent.commissionableTotalInternalAmount) &&
        Objects.equals(this.totalFeesAndCommissionsSourceAmount, bookingContractAgent.totalFeesAndCommissionsSourceAmount) &&
        Objects.equals(this.totalFeesAndCommissionsCaptureAmount, bookingContractAgent.totalFeesAndCommissionsCaptureAmount) &&
        Objects.equals(this.totalFeesAndCommissionsDisplayAmount, bookingContractAgent.totalFeesAndCommissionsDisplayAmount) &&
        Objects.equals(this.totalFeesAndCommissionsInternalAmount, bookingContractAgent.totalFeesAndCommissionsInternalAmount) &&
        Objects.equals(this.totalFeesSourceAmount, bookingContractAgent.totalFeesSourceAmount) &&
        Objects.equals(this.totalFeesCaptureAmount, bookingContractAgent.totalFeesCaptureAmount) &&
        Objects.equals(this.totalFeesDisplayAmount, bookingContractAgent.totalFeesDisplayAmount) &&
        Objects.equals(this.totalFeesInternalAmount, bookingContractAgent.totalFeesInternalAmount) &&
        Objects.equals(this.totalTripPayFeeSourceAmount, bookingContractAgent.totalTripPayFeeSourceAmount) &&
        Objects.equals(this.totalTripPayFeeCaptureAmount, bookingContractAgent.totalTripPayFeeCaptureAmount) &&
        Objects.equals(this.totalTripPayFeeDisplayAmount, bookingContractAgent.totalTripPayFeeDisplayAmount) &&
        Objects.equals(this.totalTripPayFeeInternalAmount, bookingContractAgent.totalTripPayFeeInternalAmount) &&
        Objects.equals(this.totalSalesSourceAmount, bookingContractAgent.totalSalesSourceAmount) &&
        Objects.equals(this.totalSalesCaptureAmount, bookingContractAgent.totalSalesCaptureAmount) &&
        Objects.equals(this.totalSalesDisplayAmount, bookingContractAgent.totalSalesDisplayAmount) &&
        Objects.equals(this.totalSalesSupplierAmount, bookingContractAgent.totalSalesSupplierAmount) &&
        Objects.equals(this.totalSalesInternalAmount, bookingContractAgent.totalSalesInternalAmount) &&
        Objects.equals(this.fundsAvailableDate, bookingContractAgent.fundsAvailableDate) &&
        Objects.equals(this.totalFeesInPercent, bookingContractAgent.totalFeesInPercent) &&
        Objects.equals(this.totalCommissionsInPercent, bookingContractAgent.totalCommissionsInPercent) &&
        Objects.equals(this.totalFeesAndCommissionsInPercentWithRefund, bookingContractAgent.totalFeesAndCommissionsInPercentWithRefund) &&
        Objects.equals(this.totalFeesAndCommissionsInPercent, bookingContractAgent.totalFeesAndCommissionsInPercent) &&
        Objects.equals(this.hasSuccessfulRefunds, bookingContractAgent.hasSuccessfulRefunds) &&
        Objects.equals(this.hasPendingRefunds, bookingContractAgent.hasPendingRefunds) &&
        Objects.equals(this.hasFailedRefunds, bookingContractAgent.hasFailedRefunds) &&
        Objects.equals(this.hasRefunds, bookingContractAgent.hasRefunds) &&
        Objects.equals(this.originalCommissionsInPercent, bookingContractAgent.originalCommissionsInPercent) &&
        Objects.equals(this.originalFeesInPercent, bookingContractAgent.originalFeesInPercent) &&
        Objects.equals(this.totalCommissionsInPercentWithRefund, bookingContractAgent.totalCommissionsInPercentWithRefund) &&
        Objects.equals(this.totalFeesInPercentWithRefund, bookingContractAgent.totalFeesInPercentWithRefund) &&
        Objects.equals(this.totalTripPayFeeInPercentWithRefund, bookingContractAgent.totalTripPayFeeInPercentWithRefund) &&
        Objects.equals(this.lodging, bookingContractAgent.lodging) &&
        Objects.equals(this.totalTripPayFeeInPercent, bookingContractAgent.totalTripPayFeeInPercent);
  }

  @Override
  public int hashCode() {
    return Objects.hash(bookingContractIdentifier, createdDate, lastUpdate, ipAddress, traceId, sourceUrl, identifier, supplierIdentifier, supplierName, displayPriceQuote, supplierPriceQuote, internalPriceQuote, capturePriceQuote, itemList, externalSupplierIdentifier, externalSupplierBookingCode, payment, cancelled, cancelledOn, canceller, cancellationType, cancellerUserIdentifier, cancelReason, fundsProcessed, refunds, sourceCurrency, displayCurrency, supplierCurrency, internalCurrency, captureCurrency, sourceAmount, displayAmount, supplierAmount, internalAmount, captureAmount, sourceAmountRefundModifier, displayAmountRefundModifier, supplierAmountRefundModifier, internalAmountRefundModifier, captureAmountRefundModifier, netSourceAmount, netDisplayAmount, netSupplierAmount, netInternalAmount, netCaptureAmount, totalTokensEarned, netTotalFeesSupplierAmount, netTotalFeesAndCommissionsSupplierAmount, totalFeesSupplierAmount, netTotalTripPayFeeSupplierAmount, totalTripPayFeeSupplierAmount, netCommissionableTotalSupplierAmount, commissionableTotalSupplierAmount, totalFeesAndCommissionsSupplierAmount, cancellableBySupplier, cancellableByTraveler, cancellableWithNoCharges, isCancellableWithPotentialCharges, netCommissionableTotalSourceAmount, netCommissionableTotalCaptureAmount, netCommissionableTotalDisplayAmount, netCommissionableTotalInternalAmount, netTotalFeesAndCommissionsSourceAmount, netTotalFeesAndCommissionsCaptureAmount, netTotalFeesAndCommissionsDisplayAmount, netTotalFeesAndCommissionsInternalAmount, netTotalFeesSourceAmount, netTotalFeesCaptureAmount, netTotalFeesDisplayAmount, netTotalFeesInternalAmount, netTotalTripPayFeeSourceAmount, netTotalTripPayFeeCaptureAmount, netTotalTripPayFeeDisplayAmount, netTotalTripPayFeeInternalAmount, netTotalSalesSourceAmount, netTotalSalesCaptureAmount, netTotalSalesDisplayAmount, netTotalSalesSupplierAmount, netTotalSalesInternalAmount, commissionableTotalSourceAmount, commissionableTotalCaptureAmount, commissionableTotalDisplayAmount, commissionableTotalInternalAmount, totalFeesAndCommissionsSourceAmount, totalFeesAndCommissionsCaptureAmount, totalFeesAndCommissionsDisplayAmount, totalFeesAndCommissionsInternalAmount, totalFeesSourceAmount, totalFeesCaptureAmount, totalFeesDisplayAmount, totalFeesInternalAmount, totalTripPayFeeSourceAmount, totalTripPayFeeCaptureAmount, totalTripPayFeeDisplayAmount, totalTripPayFeeInternalAmount, totalSalesSourceAmount, totalSalesCaptureAmount, totalSalesDisplayAmount, totalSalesSupplierAmount, totalSalesInternalAmount, fundsAvailableDate, totalFeesInPercent, totalCommissionsInPercent, totalFeesAndCommissionsInPercentWithRefund, totalFeesAndCommissionsInPercent, hasSuccessfulRefunds, hasPendingRefunds, hasFailedRefunds, hasRefunds, originalCommissionsInPercent, originalFeesInPercent, totalCommissionsInPercentWithRefund, totalFeesInPercentWithRefund, totalTripPayFeeInPercentWithRefund, lodging, totalTripPayFeeInPercent);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BookingContractAgent {\n");
    sb.append("    bookingContractIdentifier: ").append(toIndentedString(bookingContractIdentifier)).append("\n");
    sb.append("    createdDate: ").append(toIndentedString(createdDate)).append("\n");
    sb.append("    lastUpdate: ").append(toIndentedString(lastUpdate)).append("\n");
    sb.append("    ipAddress: ").append(toIndentedString(ipAddress)).append("\n");
    sb.append("    traceId: ").append(toIndentedString(traceId)).append("\n");
    sb.append("    sourceUrl: ").append(toIndentedString(sourceUrl)).append("\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    supplierIdentifier: ").append(toIndentedString(supplierIdentifier)).append("\n");
    sb.append("    supplierName: ").append(toIndentedString(supplierName)).append("\n");
    sb.append("    displayPriceQuote: ").append(toIndentedString(displayPriceQuote)).append("\n");
    sb.append("    supplierPriceQuote: ").append(toIndentedString(supplierPriceQuote)).append("\n");
    sb.append("    internalPriceQuote: ").append(toIndentedString(internalPriceQuote)).append("\n");
    sb.append("    capturePriceQuote: ").append(toIndentedString(capturePriceQuote)).append("\n");
    sb.append("    itemList: ").append(toIndentedString(itemList)).append("\n");
    sb.append("    externalSupplierIdentifier: ").append(toIndentedString(externalSupplierIdentifier)).append("\n");
    sb.append("    externalSupplierBookingCode: ").append(toIndentedString(externalSupplierBookingCode)).append("\n");
    sb.append("    payment: ").append(toIndentedString(payment)).append("\n");
    sb.append("    cancelled: ").append(toIndentedString(cancelled)).append("\n");
    sb.append("    cancelledOn: ").append(toIndentedString(cancelledOn)).append("\n");
    sb.append("    canceller: ").append(toIndentedString(canceller)).append("\n");
    sb.append("    cancellationType: ").append(toIndentedString(cancellationType)).append("\n");
    sb.append("    cancellerUserIdentifier: ").append(toIndentedString(cancellerUserIdentifier)).append("\n");
    sb.append("    cancelReason: ").append(toIndentedString(cancelReason)).append("\n");
    sb.append("    fundsProcessed: ").append(toIndentedString(fundsProcessed)).append("\n");
    sb.append("    refunds: ").append(toIndentedString(refunds)).append("\n");
    sb.append("    sourceCurrency: ").append(toIndentedString(sourceCurrency)).append("\n");
    sb.append("    displayCurrency: ").append(toIndentedString(displayCurrency)).append("\n");
    sb.append("    supplierCurrency: ").append(toIndentedString(supplierCurrency)).append("\n");
    sb.append("    internalCurrency: ").append(toIndentedString(internalCurrency)).append("\n");
    sb.append("    captureCurrency: ").append(toIndentedString(captureCurrency)).append("\n");
    sb.append("    sourceAmount: ").append(toIndentedString(sourceAmount)).append("\n");
    sb.append("    displayAmount: ").append(toIndentedString(displayAmount)).append("\n");
    sb.append("    supplierAmount: ").append(toIndentedString(supplierAmount)).append("\n");
    sb.append("    internalAmount: ").append(toIndentedString(internalAmount)).append("\n");
    sb.append("    captureAmount: ").append(toIndentedString(captureAmount)).append("\n");
    sb.append("    sourceAmountRefundModifier: ").append(toIndentedString(sourceAmountRefundModifier)).append("\n");
    sb.append("    displayAmountRefundModifier: ").append(toIndentedString(displayAmountRefundModifier)).append("\n");
    sb.append("    supplierAmountRefundModifier: ").append(toIndentedString(supplierAmountRefundModifier)).append("\n");
    sb.append("    internalAmountRefundModifier: ").append(toIndentedString(internalAmountRefundModifier)).append("\n");
    sb.append("    captureAmountRefundModifier: ").append(toIndentedString(captureAmountRefundModifier)).append("\n");
    sb.append("    netSourceAmount: ").append(toIndentedString(netSourceAmount)).append("\n");
    sb.append("    netDisplayAmount: ").append(toIndentedString(netDisplayAmount)).append("\n");
    sb.append("    netSupplierAmount: ").append(toIndentedString(netSupplierAmount)).append("\n");
    sb.append("    netInternalAmount: ").append(toIndentedString(netInternalAmount)).append("\n");
    sb.append("    netCaptureAmount: ").append(toIndentedString(netCaptureAmount)).append("\n");
    sb.append("    totalTokensEarned: ").append(toIndentedString(totalTokensEarned)).append("\n");
    sb.append("    netTotalFeesSupplierAmount: ").append(toIndentedString(netTotalFeesSupplierAmount)).append("\n");
    sb.append("    netTotalFeesAndCommissionsSupplierAmount: ").append(toIndentedString(netTotalFeesAndCommissionsSupplierAmount)).append("\n");
    sb.append("    totalFeesSupplierAmount: ").append(toIndentedString(totalFeesSupplierAmount)).append("\n");
    sb.append("    netTotalTripPayFeeSupplierAmount: ").append(toIndentedString(netTotalTripPayFeeSupplierAmount)).append("\n");
    sb.append("    totalTripPayFeeSupplierAmount: ").append(toIndentedString(totalTripPayFeeSupplierAmount)).append("\n");
    sb.append("    netCommissionableTotalSupplierAmount: ").append(toIndentedString(netCommissionableTotalSupplierAmount)).append("\n");
    sb.append("    commissionableTotalSupplierAmount: ").append(toIndentedString(commissionableTotalSupplierAmount)).append("\n");
    sb.append("    totalFeesAndCommissionsSupplierAmount: ").append(toIndentedString(totalFeesAndCommissionsSupplierAmount)).append("\n");
    sb.append("    cancellableBySupplier: ").append(toIndentedString(cancellableBySupplier)).append("\n");
    sb.append("    cancellableByTraveler: ").append(toIndentedString(cancellableByTraveler)).append("\n");
    sb.append("    cancellableWithNoCharges: ").append(toIndentedString(cancellableWithNoCharges)).append("\n");
    sb.append("    isCancellableWithPotentialCharges: ").append(toIndentedString(isCancellableWithPotentialCharges)).append("\n");
    sb.append("    netCommissionableTotalSourceAmount: ").append(toIndentedString(netCommissionableTotalSourceAmount)).append("\n");
    sb.append("    netCommissionableTotalCaptureAmount: ").append(toIndentedString(netCommissionableTotalCaptureAmount)).append("\n");
    sb.append("    netCommissionableTotalDisplayAmount: ").append(toIndentedString(netCommissionableTotalDisplayAmount)).append("\n");
    sb.append("    netCommissionableTotalInternalAmount: ").append(toIndentedString(netCommissionableTotalInternalAmount)).append("\n");
    sb.append("    netTotalFeesAndCommissionsSourceAmount: ").append(toIndentedString(netTotalFeesAndCommissionsSourceAmount)).append("\n");
    sb.append("    netTotalFeesAndCommissionsCaptureAmount: ").append(toIndentedString(netTotalFeesAndCommissionsCaptureAmount)).append("\n");
    sb.append("    netTotalFeesAndCommissionsDisplayAmount: ").append(toIndentedString(netTotalFeesAndCommissionsDisplayAmount)).append("\n");
    sb.append("    netTotalFeesAndCommissionsInternalAmount: ").append(toIndentedString(netTotalFeesAndCommissionsInternalAmount)).append("\n");
    sb.append("    netTotalFeesSourceAmount: ").append(toIndentedString(netTotalFeesSourceAmount)).append("\n");
    sb.append("    netTotalFeesCaptureAmount: ").append(toIndentedString(netTotalFeesCaptureAmount)).append("\n");
    sb.append("    netTotalFeesDisplayAmount: ").append(toIndentedString(netTotalFeesDisplayAmount)).append("\n");
    sb.append("    netTotalFeesInternalAmount: ").append(toIndentedString(netTotalFeesInternalAmount)).append("\n");
    sb.append("    netTotalTripPayFeeSourceAmount: ").append(toIndentedString(netTotalTripPayFeeSourceAmount)).append("\n");
    sb.append("    netTotalTripPayFeeCaptureAmount: ").append(toIndentedString(netTotalTripPayFeeCaptureAmount)).append("\n");
    sb.append("    netTotalTripPayFeeDisplayAmount: ").append(toIndentedString(netTotalTripPayFeeDisplayAmount)).append("\n");
    sb.append("    netTotalTripPayFeeInternalAmount: ").append(toIndentedString(netTotalTripPayFeeInternalAmount)).append("\n");
    sb.append("    netTotalSalesSourceAmount: ").append(toIndentedString(netTotalSalesSourceAmount)).append("\n");
    sb.append("    netTotalSalesCaptureAmount: ").append(toIndentedString(netTotalSalesCaptureAmount)).append("\n");
    sb.append("    netTotalSalesDisplayAmount: ").append(toIndentedString(netTotalSalesDisplayAmount)).append("\n");
    sb.append("    netTotalSalesSupplierAmount: ").append(toIndentedString(netTotalSalesSupplierAmount)).append("\n");
    sb.append("    netTotalSalesInternalAmount: ").append(toIndentedString(netTotalSalesInternalAmount)).append("\n");
    sb.append("    commissionableTotalSourceAmount: ").append(toIndentedString(commissionableTotalSourceAmount)).append("\n");
    sb.append("    commissionableTotalCaptureAmount: ").append(toIndentedString(commissionableTotalCaptureAmount)).append("\n");
    sb.append("    commissionableTotalDisplayAmount: ").append(toIndentedString(commissionableTotalDisplayAmount)).append("\n");
    sb.append("    commissionableTotalInternalAmount: ").append(toIndentedString(commissionableTotalInternalAmount)).append("\n");
    sb.append("    totalFeesAndCommissionsSourceAmount: ").append(toIndentedString(totalFeesAndCommissionsSourceAmount)).append("\n");
    sb.append("    totalFeesAndCommissionsCaptureAmount: ").append(toIndentedString(totalFeesAndCommissionsCaptureAmount)).append("\n");
    sb.append("    totalFeesAndCommissionsDisplayAmount: ").append(toIndentedString(totalFeesAndCommissionsDisplayAmount)).append("\n");
    sb.append("    totalFeesAndCommissionsInternalAmount: ").append(toIndentedString(totalFeesAndCommissionsInternalAmount)).append("\n");
    sb.append("    totalFeesSourceAmount: ").append(toIndentedString(totalFeesSourceAmount)).append("\n");
    sb.append("    totalFeesCaptureAmount: ").append(toIndentedString(totalFeesCaptureAmount)).append("\n");
    sb.append("    totalFeesDisplayAmount: ").append(toIndentedString(totalFeesDisplayAmount)).append("\n");
    sb.append("    totalFeesInternalAmount: ").append(toIndentedString(totalFeesInternalAmount)).append("\n");
    sb.append("    totalTripPayFeeSourceAmount: ").append(toIndentedString(totalTripPayFeeSourceAmount)).append("\n");
    sb.append("    totalTripPayFeeCaptureAmount: ").append(toIndentedString(totalTripPayFeeCaptureAmount)).append("\n");
    sb.append("    totalTripPayFeeDisplayAmount: ").append(toIndentedString(totalTripPayFeeDisplayAmount)).append("\n");
    sb.append("    totalTripPayFeeInternalAmount: ").append(toIndentedString(totalTripPayFeeInternalAmount)).append("\n");
    sb.append("    totalSalesSourceAmount: ").append(toIndentedString(totalSalesSourceAmount)).append("\n");
    sb.append("    totalSalesCaptureAmount: ").append(toIndentedString(totalSalesCaptureAmount)).append("\n");
    sb.append("    totalSalesDisplayAmount: ").append(toIndentedString(totalSalesDisplayAmount)).append("\n");
    sb.append("    totalSalesSupplierAmount: ").append(toIndentedString(totalSalesSupplierAmount)).append("\n");
    sb.append("    totalSalesInternalAmount: ").append(toIndentedString(totalSalesInternalAmount)).append("\n");
    sb.append("    fundsAvailableDate: ").append(toIndentedString(fundsAvailableDate)).append("\n");
    sb.append("    totalFeesInPercent: ").append(toIndentedString(totalFeesInPercent)).append("\n");
    sb.append("    totalCommissionsInPercent: ").append(toIndentedString(totalCommissionsInPercent)).append("\n");
    sb.append("    totalFeesAndCommissionsInPercentWithRefund: ").append(toIndentedString(totalFeesAndCommissionsInPercentWithRefund)).append("\n");
    sb.append("    totalFeesAndCommissionsInPercent: ").append(toIndentedString(totalFeesAndCommissionsInPercent)).append("\n");
    sb.append("    hasSuccessfulRefunds: ").append(toIndentedString(hasSuccessfulRefunds)).append("\n");
    sb.append("    hasPendingRefunds: ").append(toIndentedString(hasPendingRefunds)).append("\n");
    sb.append("    hasFailedRefunds: ").append(toIndentedString(hasFailedRefunds)).append("\n");
    sb.append("    hasRefunds: ").append(toIndentedString(hasRefunds)).append("\n");
    sb.append("    originalCommissionsInPercent: ").append(toIndentedString(originalCommissionsInPercent)).append("\n");
    sb.append("    originalFeesInPercent: ").append(toIndentedString(originalFeesInPercent)).append("\n");
    sb.append("    totalCommissionsInPercentWithRefund: ").append(toIndentedString(totalCommissionsInPercentWithRefund)).append("\n");
    sb.append("    totalFeesInPercentWithRefund: ").append(toIndentedString(totalFeesInPercentWithRefund)).append("\n");
    sb.append("    totalTripPayFeeInPercentWithRefund: ").append(toIndentedString(totalTripPayFeeInPercentWithRefund)).append("\n");
    sb.append("    lodging: ").append(toIndentedString(lodging)).append("\n");
    sb.append("    totalTripPayFeeInPercent: ").append(toIndentedString(totalTripPayFeeInPercent)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

