/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release   # Booking API Welcome to the Booking Engine API - A programmer-friendly way to book inventory that was found on our platform. We take great care in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive payment-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 29.8.8
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.booking.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.booking.model.RawSupplierContractItemBooker;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * RawSupplierContractBooker
 */
@JsonPropertyOrder({
  RawSupplierContractBooker.JSON_PROPERTY_IDENTIFIER,
  RawSupplierContractBooker.JSON_PROPERTY_SUPPLIER_IDENTIFIER,
  RawSupplierContractBooker.JSON_PROPERTY_SUPPLIER_IDENTIFIER_TYPE,
  RawSupplierContractBooker.JSON_PROPERTY_CONTRACT_ITEM_LIST,
  RawSupplierContractBooker.JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE,
  RawSupplierContractBooker.JSON_PROPERTY_EXTERNAL_TRANSACTION_IDENTIFIER
})
@JsonTypeName("RawSupplierContract_Booker")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-08-27T09:55:01.659494054+07:00[Asia/Bangkok]")
public class RawSupplierContractBooker {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private UUID identifier;

  public static final String JSON_PROPERTY_SUPPLIER_IDENTIFIER = "supplierIdentifier";
  private UUID supplierIdentifier;

  /**
   * Gets or Sets supplierIdentifierType
   */
  public enum SupplierIdentifierTypeEnum {
    INTERNAL("INTERNAL"),
    
    EXTERNAL("EXTERNAL");

    private String value;

    SupplierIdentifierTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static SupplierIdentifierTypeEnum fromValue(String value) {
      for (SupplierIdentifierTypeEnum b : SupplierIdentifierTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SUPPLIER_IDENTIFIER_TYPE = "supplierIdentifierType";
  private SupplierIdentifierTypeEnum supplierIdentifierType;

  public static final String JSON_PROPERTY_CONTRACT_ITEM_LIST = "contractItemList";
  private List<RawSupplierContractItemBooker> contractItemList = new ArrayList<>();

  public static final String JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE = "externalSupplierBookingCode";
  private String externalSupplierBookingCode;

  public static final String JSON_PROPERTY_EXTERNAL_TRANSACTION_IDENTIFIER = "externalTransactionIdentifier";
  private String externalTransactionIdentifier;

  public RawSupplierContractBooker() {
  }

  public RawSupplierContractBooker identifier(UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Get identifier
   * @return identifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIdentifier(UUID identifier) {
    this.identifier = identifier;
  }


  public RawSupplierContractBooker supplierIdentifier(UUID supplierIdentifier) {
    
    this.supplierIdentifier = supplierIdentifier;
    return this;
  }

   /**
   * Get supplierIdentifier
   * @return supplierIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getSupplierIdentifier() {
    return supplierIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSupplierIdentifier(UUID supplierIdentifier) {
    this.supplierIdentifier = supplierIdentifier;
  }


  public RawSupplierContractBooker supplierIdentifierType(SupplierIdentifierTypeEnum supplierIdentifierType) {
    
    this.supplierIdentifierType = supplierIdentifierType;
    return this;
  }

   /**
   * Get supplierIdentifierType
   * @return supplierIdentifierType
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_SUPPLIER_IDENTIFIER_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public SupplierIdentifierTypeEnum getSupplierIdentifierType() {
    return supplierIdentifierType;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_IDENTIFIER_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSupplierIdentifierType(SupplierIdentifierTypeEnum supplierIdentifierType) {
    this.supplierIdentifierType = supplierIdentifierType;
  }


  public RawSupplierContractBooker contractItemList(List<RawSupplierContractItemBooker> contractItemList) {
    
    this.contractItemList = contractItemList;
    return this;
  }

  public RawSupplierContractBooker addContractItemListItem(RawSupplierContractItemBooker contractItemListItem) {
    this.contractItemList.add(contractItemListItem);
    return this;
  }

   /**
   * Get contractItemList
   * @return contractItemList
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @Size(min=1,max=2147483647)
  @JsonProperty(JSON_PROPERTY_CONTRACT_ITEM_LIST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<RawSupplierContractItemBooker> getContractItemList() {
    return contractItemList;
  }


  @JsonProperty(JSON_PROPERTY_CONTRACT_ITEM_LIST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setContractItemList(List<RawSupplierContractItemBooker> contractItemList) {
    this.contractItemList = contractItemList;
  }


  public RawSupplierContractBooker externalSupplierBookingCode(String externalSupplierBookingCode) {
    
    this.externalSupplierBookingCode = externalSupplierBookingCode;
    return this;
  }

   /**
   * Get externalSupplierBookingCode
   * @return externalSupplierBookingCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getExternalSupplierBookingCode() {
    return externalSupplierBookingCode;
  }


  @JsonProperty(JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExternalSupplierBookingCode(String externalSupplierBookingCode) {
    this.externalSupplierBookingCode = externalSupplierBookingCode;
  }


  public RawSupplierContractBooker externalTransactionIdentifier(String externalTransactionIdentifier) {
    
    this.externalTransactionIdentifier = externalTransactionIdentifier;
    return this;
  }

   /**
   * Get externalTransactionIdentifier
   * @return externalTransactionIdentifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_EXTERNAL_TRANSACTION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getExternalTransactionIdentifier() {
    return externalTransactionIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_EXTERNAL_TRANSACTION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExternalTransactionIdentifier(String externalTransactionIdentifier) {
    this.externalTransactionIdentifier = externalTransactionIdentifier;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RawSupplierContractBooker rawSupplierContractBooker = (RawSupplierContractBooker) o;
    return Objects.equals(this.identifier, rawSupplierContractBooker.identifier) &&
        Objects.equals(this.supplierIdentifier, rawSupplierContractBooker.supplierIdentifier) &&
        Objects.equals(this.supplierIdentifierType, rawSupplierContractBooker.supplierIdentifierType) &&
        Objects.equals(this.contractItemList, rawSupplierContractBooker.contractItemList) &&
        Objects.equals(this.externalSupplierBookingCode, rawSupplierContractBooker.externalSupplierBookingCode) &&
        Objects.equals(this.externalTransactionIdentifier, rawSupplierContractBooker.externalTransactionIdentifier);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, supplierIdentifier, supplierIdentifierType, contractItemList, externalSupplierBookingCode, externalTransactionIdentifier);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RawSupplierContractBooker {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    supplierIdentifier: ").append(toIndentedString(supplierIdentifier)).append("\n");
    sb.append("    supplierIdentifierType: ").append(toIndentedString(supplierIdentifierType)).append("\n");
    sb.append("    contractItemList: ").append(toIndentedString(contractItemList)).append("\n");
    sb.append("    externalSupplierBookingCode: ").append(toIndentedString(externalSupplierBookingCode)).append("\n");
    sb.append("    externalTransactionIdentifier: ").append(toIndentedString(externalTransactionIdentifier)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

