/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release   # Booking API Welcome to the Booking Engine API - A programmer-friendly way to book inventory that was found on our platform. We take great care in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive payment-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 29.8.8
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.booking.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Review answer
 */
@JsonPropertyOrder({
  ReviewAnswerOptionBooker.JSON_PROPERTY_KEY,
  ReviewAnswerOptionBooker.JSON_PROPERTY_SORT,
  ReviewAnswerOptionBooker.JSON_PROPERTY_POINTS,
  ReviewAnswerOptionBooker.JSON_PROPERTY_HASHTAGS,
  ReviewAnswerOptionBooker.JSON_PROPERTY_ICONS
})
@JsonTypeName("ReviewAnswerOption_Booker")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-08-27T09:55:01.659494054+07:00[Asia/Bangkok]")
public class ReviewAnswerOptionBooker {
  public static final String JSON_PROPERTY_KEY = "key";
  private String key;

  public static final String JSON_PROPERTY_SORT = "sort";
  private Integer sort;

  public static final String JSON_PROPERTY_POINTS = "points";
  private Integer points;

  public static final String JSON_PROPERTY_HASHTAGS = "hashtags";
  private List<String> hashtags = new ArrayList<>();

  public static final String JSON_PROPERTY_ICONS = "icons";
  private List<String> icons = new ArrayList<>();

  public ReviewAnswerOptionBooker() {
  }

  public ReviewAnswerOptionBooker key(String key) {
    
    this.key = key;
    return this;
  }

   /**
   * Get key
   * @return key
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_KEY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getKey() {
    return key;
  }


  @JsonProperty(JSON_PROPERTY_KEY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setKey(String key) {
    this.key = key;
  }


  public ReviewAnswerOptionBooker sort(Integer sort) {
    
    this.sort = sort;
    return this;
  }

   /**
   * Sort key
   * @return sort
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getSort() {
    return sort;
  }


  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSort(Integer sort) {
    this.sort = sort;
  }


  public ReviewAnswerOptionBooker points(Integer points) {
    
    this.points = points;
    return this;
  }

   /**
   * Value of answer
   * @return points
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_POINTS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getPoints() {
    return points;
  }


  @JsonProperty(JSON_PROPERTY_POINTS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPoints(Integer points) {
    this.points = points;
  }


  public ReviewAnswerOptionBooker hashtags(List<String> hashtags) {
    
    this.hashtags = hashtags;
    return this;
  }

  public ReviewAnswerOptionBooker addHashtagsItem(String hashtagsItem) {
    this.hashtags.add(hashtagsItem);
    return this;
  }

   /**
   * Get hashtags
   * @return hashtags
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_HASHTAGS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<String> getHashtags() {
    return hashtags;
  }


  @JsonProperty(JSON_PROPERTY_HASHTAGS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setHashtags(List<String> hashtags) {
    this.hashtags = hashtags;
  }


  public ReviewAnswerOptionBooker icons(List<String> icons) {
    
    this.icons = icons;
    return this;
  }

  public ReviewAnswerOptionBooker addIconsItem(String iconsItem) {
    this.icons.add(iconsItem);
    return this;
  }

   /**
   * Get icons
   * @return icons
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ICONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<String> getIcons() {
    return icons;
  }


  @JsonProperty(JSON_PROPERTY_ICONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIcons(List<String> icons) {
    this.icons = icons;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ReviewAnswerOptionBooker reviewAnswerOptionBooker = (ReviewAnswerOptionBooker) o;
    return Objects.equals(this.key, reviewAnswerOptionBooker.key) &&
        Objects.equals(this.sort, reviewAnswerOptionBooker.sort) &&
        Objects.equals(this.points, reviewAnswerOptionBooker.points) &&
        Objects.equals(this.hashtags, reviewAnswerOptionBooker.hashtags) &&
        Objects.equals(this.icons, reviewAnswerOptionBooker.icons);
  }

  @Override
  public int hashCode() {
    return Objects.hash(key, sort, points, hashtags, icons);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ReviewAnswerOptionBooker {\n");
    sb.append("    key: ").append(toIndentedString(key)).append("\n");
    sb.append("    sort: ").append(toIndentedString(sort)).append("\n");
    sb.append("    points: ").append(toIndentedString(points)).append("\n");
    sb.append("    hashtags: ").append(toIndentedString(hashtags)).append("\n");
    sb.append("    icons: ").append(toIndentedString(icons)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

