/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md   # Booking API Welcome to the Booking Engine API - A programmer-friendly way to book inventory that was found on our platform. We take great care in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive payment-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with Wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 30.2.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.booking.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import travel.wink.sdk.booking.model.LocalizedPriceBooker;
import travel.wink.sdk.booking.model.RatePlanLevelFeeBooker;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * List of extra charges that applies to the rate plan.
 */
@JsonPropertyOrder({
  ExtraChargeBooker.JSON_PROPERTY_RATE_PLAN_LEVEL_FEE,
  ExtraChargeBooker.JSON_PROPERTY_UNIT_PRICE,
  ExtraChargeBooker.JSON_PROPERTY_PRICE
})
@JsonTypeName("ExtraCharge_Booker")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-08-01T16:15:53.455975605+07:00[Asia/Bangkok]")
public class ExtraChargeBooker {
  public static final String JSON_PROPERTY_RATE_PLAN_LEVEL_FEE = "ratePlanLevelFee";
  private RatePlanLevelFeeBooker ratePlanLevelFee;

  public static final String JSON_PROPERTY_UNIT_PRICE = "unitPrice";
  private LocalizedPriceBooker unitPrice;

  public static final String JSON_PROPERTY_PRICE = "price";
  private LocalizedPriceBooker price;

  public ExtraChargeBooker() {
  }

  public ExtraChargeBooker ratePlanLevelFee(RatePlanLevelFeeBooker ratePlanLevelFee) {
    
    this.ratePlanLevelFee = ratePlanLevelFee;
    return this;
  }

   /**
   * Get ratePlanLevelFee
   * @return ratePlanLevelFee
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_RATE_PLAN_LEVEL_FEE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RatePlanLevelFeeBooker getRatePlanLevelFee() {
    return ratePlanLevelFee;
  }


  @JsonProperty(JSON_PROPERTY_RATE_PLAN_LEVEL_FEE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRatePlanLevelFee(RatePlanLevelFeeBooker ratePlanLevelFee) {
    this.ratePlanLevelFee = ratePlanLevelFee;
  }


  public ExtraChargeBooker unitPrice(LocalizedPriceBooker unitPrice) {
    
    this.unitPrice = unitPrice;
    return this;
  }

   /**
   * Get unitPrice
   * @return unitPrice
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_UNIT_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalizedPriceBooker getUnitPrice() {
    return unitPrice;
  }


  @JsonProperty(JSON_PROPERTY_UNIT_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUnitPrice(LocalizedPriceBooker unitPrice) {
    this.unitPrice = unitPrice;
  }


  public ExtraChargeBooker price(LocalizedPriceBooker price) {
    
    this.price = price;
    return this;
  }

   /**
   * Get price
   * @return price
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalizedPriceBooker getPrice() {
    return price;
  }


  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPrice(LocalizedPriceBooker price) {
    this.price = price;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ExtraChargeBooker extraChargeBooker = (ExtraChargeBooker) o;
    return Objects.equals(this.ratePlanLevelFee, extraChargeBooker.ratePlanLevelFee) &&
        Objects.equals(this.unitPrice, extraChargeBooker.unitPrice) &&
        Objects.equals(this.price, extraChargeBooker.price);
  }

  @Override
  public int hashCode() {
    return Objects.hash(ratePlanLevelFee, unitPrice, price);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ExtraChargeBooker {\n");
    sb.append("    ratePlanLevelFee: ").append(toIndentedString(ratePlanLevelFee)).append("\n");
    sb.append("    unitPrice: ").append(toIndentedString(unitPrice)).append("\n");
    sb.append("    price: ").append(toIndentedString(price)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

