/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md   # Booking API Welcome to the Booking Engine API - A programmer-friendly way to book inventory that was found on our platform. We take great care in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive payment-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with Wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 30.2.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.booking.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.UUID;
import travel.wink.sdk.booking.model.PersonalAgent;
import travel.wink.sdk.booking.model.PreferencesAgent;
import travel.wink.sdk.booking.model.ProfileUserAgent;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Optional profile record
 */
@JsonPropertyOrder({
  ProfileAgent.JSON_PROPERTY_PROFILE_IDENTIFIER,
  ProfileAgent.JSON_PROPERTY_USER_IDENTIFIER,
  ProfileAgent.JSON_PROPERTY_SHARE,
  ProfileAgent.JSON_PROPERTY_USER,
  ProfileAgent.JSON_PROPERTY_PERSONAL,
  ProfileAgent.JSON_PROPERTY_PREFERENCES
})
@JsonTypeName("Profile_Agent")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-08-01T16:15:53.455975605+07:00[Asia/Bangkok]")
public class ProfileAgent {
  public static final String JSON_PROPERTY_PROFILE_IDENTIFIER = "profileIdentifier";
  private UUID profileIdentifier;

  public static final String JSON_PROPERTY_USER_IDENTIFIER = "userIdentifier";
  private UUID userIdentifier;

  public static final String JSON_PROPERTY_SHARE = "share";
  private Boolean share;

  public static final String JSON_PROPERTY_USER = "user";
  private ProfileUserAgent user;

  public static final String JSON_PROPERTY_PERSONAL = "personal";
  private PersonalAgent personal;

  public static final String JSON_PROPERTY_PREFERENCES = "preferences";
  private PreferencesAgent preferences;

  public ProfileAgent() {
  }

  public ProfileAgent profileIdentifier(UUID profileIdentifier) {
    
    this.profileIdentifier = profileIdentifier;
    return this;
  }

   /**
   * Profile identifier
   * @return profileIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_PROFILE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getProfileIdentifier() {
    return profileIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_PROFILE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setProfileIdentifier(UUID profileIdentifier) {
    this.profileIdentifier = profileIdentifier;
  }


  public ProfileAgent userIdentifier(UUID userIdentifier) {
    
    this.userIdentifier = userIdentifier;
    return this;
  }

   /**
   * User identifier
   * @return userIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_USER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getUserIdentifier() {
    return userIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_USER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUserIdentifier(UUID userIdentifier) {
    this.userIdentifier = userIdentifier;
  }


  public ProfileAgent share(Boolean share) {
    
    this.share = share;
    return this;
  }

   /**
   * Indicates whether the user wants to share this profile of themselves with hotel(s)
   * @return share
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_SHARE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getShare() {
    return share;
  }


  @JsonProperty(JSON_PROPERTY_SHARE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setShare(Boolean share) {
    this.share = share;
  }


  public ProfileAgent user(ProfileUserAgent user) {
    
    this.user = user;
    return this;
  }

   /**
   * Get user
   * @return user
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_USER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ProfileUserAgent getUser() {
    return user;
  }


  @JsonProperty(JSON_PROPERTY_USER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUser(ProfileUserAgent user) {
    this.user = user;
  }


  public ProfileAgent personal(PersonalAgent personal) {
    
    this.personal = personal;
    return this;
  }

   /**
   * Get personal
   * @return personal
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_PERSONAL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public PersonalAgent getPersonal() {
    return personal;
  }


  @JsonProperty(JSON_PROPERTY_PERSONAL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPersonal(PersonalAgent personal) {
    this.personal = personal;
  }


  public ProfileAgent preferences(PreferencesAgent preferences) {
    
    this.preferences = preferences;
    return this;
  }

   /**
   * Get preferences
   * @return preferences
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_PREFERENCES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public PreferencesAgent getPreferences() {
    return preferences;
  }


  @JsonProperty(JSON_PROPERTY_PREFERENCES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPreferences(PreferencesAgent preferences) {
    this.preferences = preferences;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ProfileAgent profileAgent = (ProfileAgent) o;
    return Objects.equals(this.profileIdentifier, profileAgent.profileIdentifier) &&
        Objects.equals(this.userIdentifier, profileAgent.userIdentifier) &&
        Objects.equals(this.share, profileAgent.share) &&
        Objects.equals(this.user, profileAgent.user) &&
        Objects.equals(this.personal, profileAgent.personal) &&
        Objects.equals(this.preferences, profileAgent.preferences);
  }

  @Override
  public int hashCode() {
    return Objects.hash(profileIdentifier, userIdentifier, share, user, personal, preferences);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ProfileAgent {\n");
    sb.append("    profileIdentifier: ").append(toIndentedString(profileIdentifier)).append("\n");
    sb.append("    userIdentifier: ").append(toIndentedString(userIdentifier)).append("\n");
    sb.append("    share: ").append(toIndentedString(share)).append("\n");
    sb.append("    user: ").append(toIndentedString(user)).append("\n");
    sb.append("    personal: ").append(toIndentedString(personal)).append("\n");
    sb.append("    preferences: ").append(toIndentedString(preferences)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

