/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.booking.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.booking.invoker.ApiClient;
import travel.wink.sdk.booking.model.BookingConfirmationsAgent;
import travel.wink.sdk.booking.model.BookingViewBooker;
import travel.wink.sdk.booking.model.BooleanResponseBooker;
import travel.wink.sdk.booking.model.CancellationDetailBooker;
import travel.wink.sdk.booking.model.CreateAgentBookingRequestAgent;
import travel.wink.sdk.booking.model.PageBookingViewBooker;
import travel.wink.sdk.booking.model.StateBooker;

public class BookingApi {
    private ApiClient apiClient;

    public BookingApi() {
        this(new ApiClient());
    }

    @Autowired
    public BookingApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec cancelBookingRequestCreation(String bookingIdentifier, CancellationDetailBooker cancellationDetailBooker, String winkVersion) throws WebClientResponseException {
        CancellationDetailBooker postBody = cancellationDetailBooker;
        if (bookingIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingIdentifier' when calling cancelBooking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (cancellationDetailBooker == null) {
            throw new WebClientResponseException("Missing the required parameter 'cancellationDetailBooker' when calling cancelBooking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("bookingIdentifier", bookingIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<BookingViewBooker> localVarReturnType = new ParameterizedTypeReference<BookingViewBooker>(this){};
        return this.apiClient.invokeAPI("/api/booking/{bookingIdentifier}", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BookingViewBooker> cancelBooking(String bookingIdentifier, CancellationDetailBooker cancellationDetailBooker, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewBooker> localVarReturnType = new ParameterizedTypeReference<BookingViewBooker>(this){};
        return this.cancelBookingRequestCreation(bookingIdentifier, cancellationDetailBooker, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BookingViewBooker>> cancelBookingWithHttpInfo(String bookingIdentifier, CancellationDetailBooker cancellationDetailBooker, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewBooker> localVarReturnType = new ParameterizedTypeReference<BookingViewBooker>(this){};
        return this.cancelBookingRequestCreation(bookingIdentifier, cancellationDetailBooker, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec cancelBookingWithResponseSpec(String bookingIdentifier, CancellationDetailBooker cancellationDetailBooker, String winkVersion) throws WebClientResponseException {
        return this.cancelBookingRequestCreation(bookingIdentifier, cancellationDetailBooker, winkVersion);
    }

    private WebClient.ResponseSpec cancelGroupBookingRequestCreation(String groupIdentifier, CancellationDetailBooker cancellationDetailBooker, String winkVersion) throws WebClientResponseException {
        CancellationDetailBooker postBody = cancellationDetailBooker;
        if (groupIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'groupIdentifier' when calling cancelGroupBooking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (cancellationDetailBooker == null) {
            throw new WebClientResponseException("Missing the required parameter 'cancellationDetailBooker' when calling cancelGroupBooking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("groupIdentifier", groupIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<BookingViewBooker> localVarReturnType = new ParameterizedTypeReference<BookingViewBooker>(this){};
        return this.apiClient.invokeAPI("/api/booking/group/{groupIdentifier}", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<BookingViewBooker> cancelGroupBooking(String groupIdentifier, CancellationDetailBooker cancellationDetailBooker, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewBooker> localVarReturnType = new ParameterizedTypeReference<BookingViewBooker>(this){};
        return this.cancelGroupBookingRequestCreation(groupIdentifier, cancellationDetailBooker, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<BookingViewBooker>>> cancelGroupBookingWithHttpInfo(String groupIdentifier, CancellationDetailBooker cancellationDetailBooker, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewBooker> localVarReturnType = new ParameterizedTypeReference<BookingViewBooker>(this){};
        return this.cancelGroupBookingRequestCreation(groupIdentifier, cancellationDetailBooker, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec cancelGroupBookingWithResponseSpec(String groupIdentifier, CancellationDetailBooker cancellationDetailBooker, String winkVersion) throws WebClientResponseException {
        return this.cancelGroupBookingRequestCreation(groupIdentifier, cancellationDetailBooker, winkVersion);
    }

    private WebClient.ResponseSpec createAgentBookingRequestCreation(CreateAgentBookingRequestAgent createAgentBookingRequestAgent, String winkVersion) throws WebClientResponseException {
        CreateAgentBookingRequestAgent postBody = createAgentBookingRequestAgent;
        if (createAgentBookingRequestAgent == null) {
            throw new WebClientResponseException("Missing the required parameter 'createAgentBookingRequestAgent' when calling createAgentBooking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<BookingConfirmationsAgent> localVarReturnType = new ParameterizedTypeReference<BookingConfirmationsAgent>(this){};
        return this.apiClient.invokeAPI("/api/booking/agent", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BookingConfirmationsAgent> createAgentBooking(CreateAgentBookingRequestAgent createAgentBookingRequestAgent, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingConfirmationsAgent> localVarReturnType = new ParameterizedTypeReference<BookingConfirmationsAgent>(this){};
        return this.createAgentBookingRequestCreation(createAgentBookingRequestAgent, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BookingConfirmationsAgent>> createAgentBookingWithHttpInfo(CreateAgentBookingRequestAgent createAgentBookingRequestAgent, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingConfirmationsAgent> localVarReturnType = new ParameterizedTypeReference<BookingConfirmationsAgent>(this){};
        return this.createAgentBookingRequestCreation(createAgentBookingRequestAgent, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createAgentBookingWithResponseSpec(CreateAgentBookingRequestAgent createAgentBookingRequestAgent, String winkVersion) throws WebClientResponseException {
        return this.createAgentBookingRequestCreation(createAgentBookingRequestAgent, winkVersion);
    }

    private WebClient.ResponseSpec resendBookingConfirmationEmailRequestCreation(String bookingIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (bookingIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingIdentifier' when calling resendBookingConfirmationEmail", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("bookingIdentifier", bookingIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<BooleanResponseBooker> localVarReturnType = new ParameterizedTypeReference<BooleanResponseBooker>(this){};
        return this.apiClient.invokeAPI("/api/booking/{bookingIdentifier}/resend", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BooleanResponseBooker> resendBookingConfirmationEmail(String bookingIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BooleanResponseBooker> localVarReturnType = new ParameterizedTypeReference<BooleanResponseBooker>(this){};
        return this.resendBookingConfirmationEmailRequestCreation(bookingIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BooleanResponseBooker>> resendBookingConfirmationEmailWithHttpInfo(String bookingIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BooleanResponseBooker> localVarReturnType = new ParameterizedTypeReference<BooleanResponseBooker>(this){};
        return this.resendBookingConfirmationEmailRequestCreation(bookingIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec resendBookingConfirmationEmailWithResponseSpec(String bookingIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.resendBookingConfirmationEmailRequestCreation(bookingIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showBookingRequestCreation(String bookingIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (bookingIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingIdentifier' when calling showBooking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("bookingIdentifier", bookingIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<BookingViewBooker> localVarReturnType = new ParameterizedTypeReference<BookingViewBooker>(this){};
        return this.apiClient.invokeAPI("/api/booking/{bookingIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BookingViewBooker> showBooking(String bookingIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewBooker> localVarReturnType = new ParameterizedTypeReference<BookingViewBooker>(this){};
        return this.showBookingRequestCreation(bookingIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BookingViewBooker>> showBookingWithHttpInfo(String bookingIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewBooker> localVarReturnType = new ParameterizedTypeReference<BookingViewBooker>(this){};
        return this.showBookingRequestCreation(bookingIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showBookingWithResponseSpec(String bookingIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showBookingRequestCreation(bookingIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showBookingByTransactionIdRequestCreation(String transactionIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (transactionIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'transactionIdentifier' when calling showBookingByTransactionId", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("transactionIdentifier", transactionIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<BookingViewBooker> localVarReturnType = new ParameterizedTypeReference<BookingViewBooker>(this){};
        return this.apiClient.invokeAPI("/api/booking/tx/{transactionIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BookingViewBooker> showBookingByTransactionId(String transactionIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewBooker> localVarReturnType = new ParameterizedTypeReference<BookingViewBooker>(this){};
        return this.showBookingByTransactionIdRequestCreation(transactionIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BookingViewBooker>> showBookingByTransactionIdWithHttpInfo(String transactionIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewBooker> localVarReturnType = new ParameterizedTypeReference<BookingViewBooker>(this){};
        return this.showBookingByTransactionIdRequestCreation(transactionIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showBookingByTransactionIdWithResponseSpec(String transactionIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showBookingByTransactionIdRequestCreation(transactionIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showBookingGridRequestCreation(StateBooker stateBooker, String winkVersion) throws WebClientResponseException {
        StateBooker postBody = stateBooker;
        if (stateBooker == null) {
            throw new WebClientResponseException("Missing the required parameter 'stateBooker' when calling showBookingGrid", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PageBookingViewBooker> localVarReturnType = new ParameterizedTypeReference<PageBookingViewBooker>(this){};
        return this.apiClient.invokeAPI("/api/booking/grid", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageBookingViewBooker> showBookingGrid(StateBooker stateBooker, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageBookingViewBooker> localVarReturnType = new ParameterizedTypeReference<PageBookingViewBooker>(this){};
        return this.showBookingGridRequestCreation(stateBooker, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageBookingViewBooker>> showBookingGridWithHttpInfo(StateBooker stateBooker, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageBookingViewBooker> localVarReturnType = new ParameterizedTypeReference<PageBookingViewBooker>(this){};
        return this.showBookingGridRequestCreation(stateBooker, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showBookingGridWithResponseSpec(StateBooker stateBooker, String winkVersion) throws WebClientResponseException {
        return this.showBookingGridRequestCreation(stateBooker, winkVersion);
    }

    private WebClient.ResponseSpec showBookingsRequestCreation(Integer page, Integer size, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "page", page));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "size", size));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PageBookingViewBooker> localVarReturnType = new ParameterizedTypeReference<PageBookingViewBooker>(this){};
        return this.apiClient.invokeAPI("/api/booking/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageBookingViewBooker> showBookings(Integer page, Integer size, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageBookingViewBooker> localVarReturnType = new ParameterizedTypeReference<PageBookingViewBooker>(this){};
        return this.showBookingsRequestCreation(page, size, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageBookingViewBooker>> showBookingsWithHttpInfo(Integer page, Integer size, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageBookingViewBooker> localVarReturnType = new ParameterizedTypeReference<PageBookingViewBooker>(this){};
        return this.showBookingsRequestCreation(page, size, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showBookingsWithResponseSpec(Integer page, Integer size, String winkVersion, String accept) throws WebClientResponseException {
        return this.showBookingsRequestCreation(page, size, winkVersion, accept);
    }

    private WebClient.ResponseSpec showBookingsByReviewStateRequestCreation(String state, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "state", state));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<BookingViewBooker> localVarReturnType = new ParameterizedTypeReference<BookingViewBooker>(this){};
        return this.apiClient.invokeAPI("/api/booking/review/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<BookingViewBooker> showBookingsByReviewState(String state, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewBooker> localVarReturnType = new ParameterizedTypeReference<BookingViewBooker>(this){};
        return this.showBookingsByReviewStateRequestCreation(state, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<BookingViewBooker>>> showBookingsByReviewStateWithHttpInfo(String state, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewBooker> localVarReturnType = new ParameterizedTypeReference<BookingViewBooker>(this){};
        return this.showBookingsByReviewStateRequestCreation(state, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showBookingsByReviewStateWithResponseSpec(String state, String winkVersion, String accept) throws WebClientResponseException {
        return this.showBookingsByReviewStateRequestCreation(state, winkVersion, accept);
    }

    private WebClient.ResponseSpec showBookingsByStateRequestCreation(String state, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "state", state));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<BookingViewBooker> localVarReturnType = new ParameterizedTypeReference<BookingViewBooker>(this){};
        return this.apiClient.invokeAPI("/api/booking/state", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<BookingViewBooker> showBookingsByState(String state, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewBooker> localVarReturnType = new ParameterizedTypeReference<BookingViewBooker>(this){};
        return this.showBookingsByStateRequestCreation(state, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<BookingViewBooker>>> showBookingsByStateWithHttpInfo(String state, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewBooker> localVarReturnType = new ParameterizedTypeReference<BookingViewBooker>(this){};
        return this.showBookingsByStateRequestCreation(state, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showBookingsByStateWithResponseSpec(String state, String winkVersion, String accept) throws WebClientResponseException {
        return this.showBookingsByStateRequestCreation(state, winkVersion, accept);
    }

    private WebClient.ResponseSpec showGroupedBookingsRequestCreation(String groupIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (groupIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'groupIdentifier' when calling showGroupedBookings", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("groupIdentifier", groupIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<BookingViewBooker> localVarReturnType = new ParameterizedTypeReference<BookingViewBooker>(this){};
        return this.apiClient.invokeAPI("/api/booking/group/{groupIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<BookingViewBooker> showGroupedBookings(String groupIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewBooker> localVarReturnType = new ParameterizedTypeReference<BookingViewBooker>(this){};
        return this.showGroupedBookingsRequestCreation(groupIdentifier, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<BookingViewBooker>>> showGroupedBookingsWithHttpInfo(String groupIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewBooker> localVarReturnType = new ParameterizedTypeReference<BookingViewBooker>(this){};
        return this.showGroupedBookingsRequestCreation(groupIdentifier, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showGroupedBookingsWithResponseSpec(String groupIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showGroupedBookingsRequestCreation(groupIdentifier, winkVersion, accept);
    }
}

