package travel.wink.sdk.booking.api;

import travel.wink.sdk.booking.invoker.ApiClient;

import travel.wink.sdk.booking.model.GenericErrorMessage;
import travel.wink.sdk.booking.model.ReviewTemplateAuthenticatedEntity;
import travel.wink.sdk.booking.model.ReviewViewAuthenticatedEntity;
import travel.wink.sdk.booking.model.SubmitReview400Response;
import travel.wink.sdk.booking.model.SubmitReviewRequestAuthenticatedEntity;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-08-05T21:40:49.918233763+07:00[Asia/Bangkok]")
public class ReviewApi {
    private ApiClient apiClient;

    public ReviewApi() {
        this(new ApiClient());
    }

    @Autowired
    public ReviewApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Show Review Template
     * Loads available questions and answer options
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param bookingIdentifier The bookingIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ReviewTemplateAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec populateReviewRequestCreation(String bookingIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'bookingIdentifier' is set
        if (bookingIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingIdentifier' when calling populateReview", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("bookingIdentifier", bookingIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<ReviewTemplateAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ReviewTemplateAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/booking/{bookingIdentifier}/review/questions", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Review Template
     * Loads available questions and answer options
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param bookingIdentifier The bookingIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ReviewTemplateAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ReviewTemplateAuthenticatedEntity> populateReview(String bookingIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ReviewTemplateAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ReviewTemplateAuthenticatedEntity>() {};
        return populateReviewRequestCreation(bookingIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Show Review Template
     * Loads available questions and answer options
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param bookingIdentifier The bookingIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;ReviewTemplateAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<ReviewTemplateAuthenticatedEntity>> populateReviewWithHttpInfo(String bookingIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ReviewTemplateAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ReviewTemplateAuthenticatedEntity>() {};
        return populateReviewRequestCreation(bookingIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Show Review Template
     * Loads available questions and answer options
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param bookingIdentifier The bookingIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec populateReviewWithResponseSpec(String bookingIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return populateReviewRequestCreation(bookingIdentifier, winkVersion, accept);
    }
    /**
     * Submit Review
     * Submit review for booking
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>201</b> - Created
     * @param bookingIdentifier The bookingIdentifier parameter
     * @param submitReviewRequestAuthenticatedEntity The submitReviewRequestAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return ReviewViewAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec submitReviewRequestCreation(String bookingIdentifier, SubmitReviewRequestAuthenticatedEntity submitReviewRequestAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        Object postBody = submitReviewRequestAuthenticatedEntity;
        // verify the required parameter 'bookingIdentifier' is set
        if (bookingIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingIdentifier' when calling submitReview", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'submitReviewRequestAuthenticatedEntity' is set
        if (submitReviewRequestAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'submitReviewRequestAuthenticatedEntity' when calling submitReview", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("bookingIdentifier", bookingIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<ReviewViewAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ReviewViewAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/booking/{bookingIdentifier}/review", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Submit Review
     * Submit review for booking
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>201</b> - Created
     * @param bookingIdentifier The bookingIdentifier parameter
     * @param submitReviewRequestAuthenticatedEntity The submitReviewRequestAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return ReviewViewAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ReviewViewAuthenticatedEntity> submitReview(String bookingIdentifier, SubmitReviewRequestAuthenticatedEntity submitReviewRequestAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ReviewViewAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ReviewViewAuthenticatedEntity>() {};
        return submitReviewRequestCreation(bookingIdentifier, submitReviewRequestAuthenticatedEntity, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Submit Review
     * Submit review for booking
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>201</b> - Created
     * @param bookingIdentifier The bookingIdentifier parameter
     * @param submitReviewRequestAuthenticatedEntity The submitReviewRequestAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;ReviewViewAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<ReviewViewAuthenticatedEntity>> submitReviewWithHttpInfo(String bookingIdentifier, SubmitReviewRequestAuthenticatedEntity submitReviewRequestAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ReviewViewAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ReviewViewAuthenticatedEntity>() {};
        return submitReviewRequestCreation(bookingIdentifier, submitReviewRequestAuthenticatedEntity, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Submit Review
     * Submit review for booking
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>201</b> - Created
     * @param bookingIdentifier The bookingIdentifier parameter
     * @param submitReviewRequestAuthenticatedEntity The submitReviewRequestAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec submitReviewWithResponseSpec(String bookingIdentifier, SubmitReviewRequestAuthenticatedEntity submitReviewRequestAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        return submitReviewRequestCreation(bookingIdentifier, submitReviewRequestAuthenticatedEntity, winkVersion);
    }
}
